﻿<%@ Control Language="C#" %>
<%@ Import Namespace="Kesion.Publics" %>
<%@ Import Namespace="Kesion.Cache" %>
<%@ Import Namespace="Kesion.Components" %>
<%@ Import Namespace="Kesion.BLL" %>
<%@ Import Namespace="Kesion.HtmlTags" %>
<%@ Import Namespace="System.Data" %>

<script runat="server" type="text/C#">

    dynamic __userinfo = HttpContext.Current.Items["user"];                //初始化用户信息
    public static DataRow dr = null;
    public int id = 0;
    public string ordertype = string.Empty;
    int flag = 0;
    bool isLoadPage = true;  //定义页面是否加载

    protected void Page_Load(object sender, EventArgs e)
    {
        id = Utils.StrToInt(KSCMS.S("id"));
        ordertype = KSCMS.S("ordertype");

        if (id == 0)
        {  isLoadPage = false;
            Msg.Alert("Error!");
            return;
        }
        if (KSCMS.S("do") == "dosave")
        {
            isLoadPage = false;
            DoSave();
            return;
        }
        else
        {
            this.RdbReturnMoneyType.Attributes.Add("onclick", "showbank()");
            this.RdbDeliverType.Attributes.Add("onclick", "showmoneytype()");

            using (DataTable dt = DataFactory.GetDataTable("select top 1 * From KS_ProOrder Where ID=" + id))
            {
                if (dt.Rows.Count > 0)
                {
                     dr = dt.Rows[0];

                    if (__userinfo == null || dr == null)
                    {
                        JS.AlertDoFun("出错，找不到订单!", "history.back()");
                    }
                    if (__userinfo.UserName != dr["username"].ToString())
                    {
                        JS.AlertDoFun("对不起，该订单不是您的，不能申请退货退款！", "history.back()");
                    }
                    else
                    {

                        if (dr["status"].ToString() == "4")
                        {
                            JS.AlertDoFun("已申请过退款操作， 请等待处理！", "history.back()");
                        }
                        else if (dr["status"].ToString() == "5")
                        {
                            JS.AlertDoFun("已申请过换货操作， 请等待处理！", "history.back()");
                        }

                        if (dr["DeliverStatus"].ToString() == "1")
                        {
                            JS.AlertDoFun("对不起，订单已发货，请确认收货后再来申请退货退款！", "history.back()");
                        }


                        if (dr["status"].ToString() == "0")
                        {
                            JS.AlertDoFun("对不起，未付款的订单无法申请退货退款！", "history.back()");
                        }

                        if (dr["DeliverStatus"].ToString() == "0")
                        {
                            RdbDeliverType.Items.Clear();
                            ListItem li = new ListItem();
                            li.Text = "申请退款";
                            li.Value = "3";
                            li.Selected = true;
                            RdbDeliverType.Items.Add(li);
                            moneytype.Visible = true;
                            // DeliveryCompany.Visible = false;
                            PhotoUrlsFile.Visible = true;
                            flag = 1;
                        }
                    }
                }
            }
        }
    }
    private void DoSave()
    {
        string reason = KSCMS.S("Reason");
        int flag = Utils.StrToInt(KSCMS.S("flag"));

        if (string.IsNullOrEmpty(reason))
        {
            Msg.AlertDoFun("请输入申请退货退款的理由！", "history.back()");
            return;
        }
        int DeliverType = Utils.StrToInt(KSCMS.S(RdbDeliverType.UniqueID));


        string ClientName = dr["realname"].ToString();
        if (string.IsNullOrEmpty(ClientName)) ClientName = __userinfo.RealName;
        Hashtable ht = new Hashtable();
        ht.Add("orderId", dr["orderid"].ToString());
        ht.Add("ClientName", ClientName);
        ht.Add("UserName", dr["username"].ToString());
        ht.Add("Inputer", __userinfo.UserName);
        ht.Add("HandlerName", __userinfo.UserName);
        ht.Add("DeliverDate", DateTime.Now);
        ht.Add("DeliverType", DeliverType);  //客户自行申请退货


        ht.Add("Remark", reason);

        ht.Add("PhotoUrls", KSCMS.S("files"));//上传凭证

        //仅申请 未处理
        if ((float)Convert.ToDouble(dr["MoneyReceipt"].ToString()) > 0)  //已支付情况
        {
            ht.Add("MoneyReturnType", Utils.StrToInt(KSCMS.S(RdbReturnMoneyType.UniqueID)));
        }
        else
        {
            ht.Add("MoneyReturnType", "0");
        }
        ht.Add("MoneyReturnBankCard", KSCMS.S("moneyReturnBankCard"));
        ht.Add("MoneyReturnBankName", KSCMS.S("MoneyReturnBankName"));
        ht.Add("MoneyReturnCardName", KSCMS.S("MoneyReturnCardName"));
        if (flag == 0)
        {
            if (DeliverType == 3)  //退货
            {
                ht.Add("Status", 3); //正在等待管理员同意,客户申请退货退款
                                     //ht.Add("RemarkStr", "正在等待管理员同意,客户申请退货退款");
            }
            else  //换货
            {
                ht.Add("Status", 4);//正在等待管理员同意,客户申请换货
                                    //ht.Add("RemarkStr", "正在等待管理员同意,客户申请换货");
            }
        }
        else
        {
            ht.Add("Status", 15);
            // ht.Add("Remark", "客户申请退款");
        }
        CommonData.Insert("[KS_ProLogDeliver]", ht);
        int LogDeliverId = CommonData.GetMaxId("KS_ProLogDeliver", "ID");

        //  Msg.Alert(flag.ToString());

        if (flag == 0)   //已发货的情况
        {
            if (DeliverType == 3)  //退货或退款
            {
                DataFactory.ExecuteNonQuery("UPDATE KS_ProOrder Set Status=4,DeliverStatus=5 Where id=" + id);

            }
            else      //换货
            {
                DataFactory.ExecuteNonQuery("UPDATE KS_ProOrder Set Status=5,DeliverStatus=6 Where id=" + id);

            }

            #region 产生订单记录,申请退货退款
            ht.Clear();
            ht.Add("UserName", new TemporaryVar().UserName);
            ht.Add("Inputer", "system");
            ht.Add("LogDeliverId", LogDeliverId);
            ht.Add("AddDate", DateTime.Now);
            if (DeliverType == 3)  //退货
            {
                ht.Add("Remark", Utils.GetLanguageNode("//language/node[@name='modelview']/shopmodel/orderlog/step7/item1")); //产生订单记录,申请退货退款
            }
            else  //换货
            {
                ht.Add("Remark", Utils.GetLanguageNode("//language/node[@name='modelview']/shopmodel/orderlog/step7/item4")); //产生订单记录,申请换货
            }
            Kesion.APPCode.OrderProcess.InsertOrderLog(dr["orderId"].ToString(), 11, ht, true);
            #endregion

            #region 产生订单记录,申请退货退款
            ht.Clear();
            ht.Add("UserName", new TemporaryVar().UserName);
            ht.Add("Inputer", "system");
            ht.Add("LogDeliverId", LogDeliverId);
            ht.Add("AddDate", DateTime.Now);
            if (DeliverType == 3)  //退货
            {
                ht.Add("Remark", "正在等待管理员同意申请退货退款"); //产生订单记录,申请退货退款
            }
            else  //换货
            {
                ht.Add("Remark", "正在等待管理员同意申请换货"); //产生订单记录,申请换货
            }
            Kesion.APPCode.OrderProcess.InsertOrderLog(dr["orderId"].ToString(), 11, ht, true);
            #endregion

        }
        else   //未发货的情况
        {
            DataFactory.ExecuteNonQuery("UPDATE KS_ProOrder Set Status=4 ,DeliverStatus=14 Where id=" + id);

            #region 产生订单记录,申请退货退款
            ht.Clear();
            ht.Add("UserName", new TemporaryVar().UserName);
            ht.Add("Inputer", "system");
            ht.Add("LogDeliverId", LogDeliverId);
            ht.Add("AddDate", DateTime.Now);
            if (DeliverType == 3)  //退货
            {
                ht.Add("Remark", "申请退款"); //产生订单记录,申请退货退款
            }

            Kesion.APPCode.OrderProcess.InsertOrderLog(dr["orderId"].ToString(), 12, ht, true);
            #endregion


        }

        Msg.Alert("恭喜，申请退货退款成功,请等待处理!", BasicField.GetUserUrl("Shop/MyOrder"));
        return;


    }
</script>
<%
    if (!isLoadPage) return;
%>
      <form name="myform" action="{$GetCurrUrl}" method="post" id="myform">
       <input type="hidden" name="do" id="do" value="dosave"/>
       <input type="hidden" name="flag" value="<%=flag %>" />
       <input type="hidden" name="ordertype" value="<%=ordertype %>" />
       <table  class="border" width="98%" align="center" border="0">
	 <tr class="title">
         <td colspan="2"> 退货退款申请</td>
     </tr>
    
     <tr class="tdbg">
       <td  class="lefttd" align="right" style="width:100px;">订单编号：</td>
       <td><%=dr["orderid"].ToString() %>
       </td>
     </tr>
     <tr class="tdbg">
        <td  class="lefttd" align="right">订单费用：</td>
         <td style="height:30px"> 
          <%=MyCache.GetCurrencySymbol%><%=Utils.StrToFloat(dr["NoUseCouponMoney"].ToString()).ToString("F2")%>  <%=MyCache.GetCurrencyUnit%>
         
          &nbsp;&nbsp;已 付 款：<span style="font-weight:bold;font-size:16px;color:green"><%=MyCache.GetCurrencySymbol%><%=Utils.StrToFloat(dr["MoneyReceipt"].ToString()).ToString("f2") %></span> <%=MyCache.GetCurrencyUnit%>
         </td>
     </tr>
     <tr class="tdbg">
        <td  class="lefttd" align="right">操作类型：</td>
         <td> 
          <asp:RadioButtonList ID="RdbDeliverType" runat="server" RepeatDirection="Horizontal" RepeatLayout="Flow">
            <asp:ListItem Value="4" Selected="True">换货</asp:ListItem>
            <asp:ListItem Value="3">退货并退款</asp:ListItem>
           </asp:RadioButtonList>
         </td>
     </tr>
     <tr class="tdbg">
        <td  class="lefttd" align="right">退换货原因：</td>
         <td> 
         <textarea name="Reason" id="Reason"  style="width:95%;height:200px;"></textarea>
                  <%Kesion.APPCode.EditorAPI.EchoHead(); %>
                  <% Kesion.APPCode.EditorAPI.EchoEditor("editor", "Reason", "Basic",0,false,true,true,false);%>
         </td>
     </tr>

    <tr class="tdbg" id="PhotoUrlsFile" runat="server">
        <td class="lefttd">上传凭证：</td>
        <td>
            <input type="hidden" name="files" id='files' />
            <!--上传图片开始-->
            <div class="imagebox">
                <script type="text/javascript">
                    function uploadOk(v, s) {
                        box.close();
                        if (s == undefined) s = v;
                        if ($("#files").val() == '') {
                            $("#files").val(s + "|" + v);
                        } else {
                            $("#files").val($("#files").val() + "§" + s + "|" + v);
                        }
                        $(".upshow").append("<li><img src='" + s + "'/></li>");
                    }
                    function doSubmit(obj) { box = top.$.dialog({ title: false, content: '请稍等，正在上传文件...' }); }
                </script>
                <div class="upshow"></div>
                <iframe src="/plus/include/autoupload.aspx?channelid=4&fun=parent.parent.uploadOk" width="60" height="60" scrolling="no" frameborder="0"></iframe>
                <span class="tips">只能是图片</span>
            </div>

            <!--上传图片结束-->


        </td>
    </tr>
     <tr class="tdbg" id="moneytype" runat="server">
        <td  class="lefttd" align="right">货款退回方式：</td>
         <td> 
          <asp:RadioButtonList ID="RdbReturnMoneyType" runat="server">
            <asp:ListItem Value="1" Selected="True">退回我的会员预付款中</asp:ListItem>
            <asp:ListItem Value="2">退回到指定的银行帐号</asp:ListItem>
            <asp:ListItem Value="3">原路退回</asp:ListItem>
           </asp:RadioButtonList>
         </td>
     </tr>
     
     <tbody id="returnbank" style="display:none">
     <tr class="tdbg">
        <td  class="lefttd" align="right">银行卡信息：</td>
         <td> 
             银行名称：<input type="text" name="MoneyReturnBankName" id="MoneyReturnBankName" MaxLength="100" width="200" class="textbox"> <span class="tips">如中国工商银行某某分理处。</span>
           <br />银行卡号：<input type="text" name="MoneyReturnBankCard" id="MoneyReturnBankCard" MaxLength="100" width="200" class="textbox"> <span class="tips">请正确填写银行卡号。</span>
            <br />银行户名：<input type="text" name="MoneyReturnCardName" id="MoneyReturnCardName" MaxLength="100" width="200" class="textbox"> <span class="tips">请正确填写银行卡户主。</span>

         </td>
     </tr>

   
     </tbody>
    

   
     <tr class="tdbg">
         <td></td>
         <td style="height:50px;">
             <input type="submit" ID="BtnNext"  onclick="return(checkform());" class="button" value="确定申请"  /></td>
     </tr>
    </table>
   </form> 
    <script>
        $(function () {
            showmoneytype();
        });
    function checkform() {
        if (editor.hasContents()==false) {
            KesionJS.Alert('请输入退货或退款的原因！', "editor.focus(); ");
               return false;
        }
        var type = jQuery("#<%=this.RdbDeliverType.ClientID %> :radio[checked]").val();
        if (type == 3) {
            var checkrad = jQuery("#<%=this.RdbReturnMoneyType.ClientID %> :radio[checked]").val();
            if (checkrad == 2) {
                if ($("#MoneyReturnBankName").val() == '') {
                    KesionJS.Alert('请输入银行名称！', "$('#MoneyReturnBankName').focus()");
                    return false;
                }
                if ($("#MoneyReturnBankCard").val() == '') {
                    KesionJS.Alert('请输入银行卡号！', "$('#MoneyReturnBankCard').focus()");
                    return false;
                }
                if ($("#MoneyReturnCardName").val() == '') {
                    KesionJS.Alert('请输入银行卡号户名！', "$('#MoneyReturnCardName').focus()");
                    return false;
                }
            }
        }
     }
     function showbank() {
         var checkrad = jQuery("#<%=this.RdbReturnMoneyType.ClientID %> :radio[checked]").val();
         if (checkrad == 2) {
             $("#returnbank").show();
         } else {
           $("#returnbank").hide();
         }
     }
        function showmoneytype() {
            var checkrad = jQuery("#<%=this.RdbDeliverType.ClientID %> :radio[checked]").val();
            if (checkrad == 3) {
                $("#<%=moneytype.ClientID%>").show();
            } else {
                $("#<%=moneytype.ClientID%>").hide();
                $("#returnbank").hide();
            }
        }
</script>