﻿
namespace Kesion.NET.WebSite.Plus
{
    using System;
    using System.Collections;
    using System.Collections.Generic;
    using System.Data;
    using System.Text;
    using System.Web;
    using System.Web.SessionState;
    using Kesion.BLL;
    using Kesion.Cache;
    using Kesion.Components;
    using Kesion.Publics;
    using Lucene.Net.Analysis;
    using System.Text.RegularExpressions;
    using System.Xml;

    /// <summary>
    /// $codebehindclassname$ 的摘要说明
    /// </summary>
    public class Ajaxs : IHttpHandler, IRequiresSessionState
    {

        public void ProcessRequest(HttpContext context)
        {
            //context.Response.ContentType = "text/plain";
            //context.Response.Write("Hello World");

            context.Response.Cache.SetCacheability(HttpCacheability.NoCache);  //禁止缓存
            string A = KSCMS.S("a");
            if (string.IsNullOrEmpty(A))
            {
                return;
            }
            A = A.ToLower();
            switch (A)
            {

                #region 小组
                case "addgrouplimits"://判断加入小组的权限问题
                    checkgroup();
                    break;
                #endregion


                case "getperiod":
                    CoursePeriod();//获取课时信息
                    break;
                case "digg":   //Dig模块
                    Digg();
                    break;
                case "getskinpic":
                    getSkinPic();
                    break;
                case "getadmininputclass": //后台添加文档，加载栏目级联
                    GetAdminInputClass();
                    break;
                case "shareaddscore": //点分享按钮赠送积分
                    ShareAddScore();
                    break;
                case "clickads": //点广告条
                    ClickAds();
                    break;
                case "testftp":   //检查FTP是否正常
                    TestFtp();
                    break;
                case "checktoken":
                    checkToken();
                    break;
                case "setchargestatus":  //设置允许扣费标志
                    SetChargeStatus();
                    break;
                case "admincheckmsg": //后台登录检查是否有新消息
                    AdminCheckMsg();
                    break;
                case "getnewmessage":  //新短消息
                    KSCMS.W(getNewMessage(Utils.StrToInt(KSCMS.S("type"))));
                    break;
                case "classtree":
                    ClassTree();
                    break;
                case "specialclasstree":
                    SpecialClassTree();
                    break;
                case "convertclassname":
                    ConvertClassName();
                    break;
                case "modelename":
                    GetModelEname();
                    break;
                case "testcollectlist":
                    GetTestCollectList();
                    break;
                case "testcollectlistlink":
                    GetTestCollectListLink();
                    break;
                case "getmodelfieldmanage": //后台首页的模型字段管理
                    GetModelFieldManage();
                    break;
                case "checkislogin":   //检查是否登录
                    CheckIsLogin();
                    break;
                case "checklogin":     //提交登录验证
                    CheckLogin();
                    break;
                case "loadcityoption":
                    LoadCityOption();
                    break;
                case "loadcountyoption":
                    LoadCountyOption();
                    break;
                case "getnoselectprovince":
                    GetNoSelectProvince();
                    break;
                case "gettags":
                    GetKeyTags();
                    break;
                case "linkhits":  //友情链接计数
                    LinkHits();
                    break;
                case "loaditeminfo"://加载模型文档
                    LoadItemInfo();
                    break;

                #region 投稿栏目
                case "getinputclass":
                    GetInputClass();
                    break;
                #endregion

                #region pk相关
                case "checkpklogin":  //检查PK是否要登录
                    CheckPKLogin();
                    break;
                case "savepkpost":    //提交PK观点
                    SavePKPost();
                    break;
                case "getpkvotes":    //得票数
                    GetPKVotes();
                    break;
                case "getpkgdlist":  //得到PK观点列表 
                    GetPKGDList();
                    break;
                #endregion

                #region 网店系统
                case "proimages":
                    LoadProImages();
                    break;
                case "getproprice":
                    GetProPrice();
                    break;
                case "getcartinfo":
                    GetCartInfo();
                    break;
                case "delfromcart":
                    delFromCart();
                    break;
                case "setbuynum":
                    setBuyNum();
                    break;
                case "setgroupbuynum":
                    setGroupBuyNum();
                    break;
                case "addchangebuytocart":
                    addChangeBuyToCart();
                    break;
                case "removeallprofromcart":
                    removeAllProFromCart();
                    break;
                #region 购物车发票相关操作
                case "saveinvoice":
                    SaveInvoice();
                    break;
                case "loadmyinvoice":
                    LoadMyInvoice();
                    break;
                case "deletemyinvoice":
                    DeleteMyInvoice();
                    break;
                case "modifyinvoice":
                    ModifyInvoice();
                    break;
                #endregion

                #region 收货地址
                case "saveproaddress":
                    SaveProAddress();
                    break;
                case "loadaddaddress":
                    LoadAddAddress();
                    break;
                case "loaddefaultaddress":
                    LoadDefaultAddress();
                    break;
                case "modifyproaddress":
                    ModifyProAddress();
                    break;
                case "deletemyaddress":
                    DeleteMyAddress();
                    break;
                #endregion


                case "loaddeliverlist":
                    LoadDeliverList();
                    break;
                case "validatecoupon":
                    ValidateCoupon();
                    break;
                case "cleancouponnum":
                    CleanCouponNum();
                    break;
                case "getlimitbuy":
                    GetLimitBuy();
                    break;
                case "searchuser":
                    SearchUser();
                    break;
                case "addcart":
                    AddCart();
                    break;
                case "savecartids":
                    saveCartIds();
                    break;
                case "groupbuyclassoption":
                    GroupBuyClassOption();
                    break;
                case "groupbuycityoption":
                    GetCityOption();
                    break;
                case "checkproid":
                    CheckProID();
                    break;
                case "loadbrandlist":
                    LoadBrandList();
                    break;
                #endregion

                #region 点赞收藏操作
                case "docorz"://操作课程收藏

                    DoCollectOrZan(Utils.StrToInt(KSCMS.S("optype")), Utils.StrToInt(KSCMS.S("isgetinfo")));
                    break;
                #endregion
                case "getcosperiod":
                    GetCosPeriod();
                    break;
                case "getcosinfo":
                    GetCosInfo();
                    break;

            }
            context.Response.End();
        }
        /// <summary>
        ///      操作收藏或点赞
        /// </summary>
        /// <param name="OpType">操作类型 0收藏 1点赞</param>
        /// <param name="IsGetInfo">0 操作收藏点赞，1获取状态</param>
        private void DoCollectOrZan(int OpType = 0, int IsGetInfo = 0)
        {
            string action = KSCMS.S("act");
            string IsList = KSCMS.S("list");
            int ModelID = Utils.StrToInt(KSCMS.S("modelid"));
            int ID = Utils.StrToInt(KSCMS.S("id"));
            //   int optype = Utils.StrToInt(KSCMS.S("optype"));

            Kesion.APPCode.Public.DoCollectOrZan(ID, ModelID, new TemporaryVar().UserID, OpType, IsGetInfo, false, action, IsList);
        }
        private void GetCourseCollectCount()
        {
            #region 判断是否课程收藏
            int modelid = Utils.StrToInt(KSCMS.S("modelid"));
            int id = Utils.StrToInt(KSCMS.S("id"));
            int count = Utils.StrToInt(DataFactory.GetOnlyValue("select count(*) from KS_Favorite where username='" + (new TemporaryVar()).UserName + "' and InfoID=" + id + " and ChannelID=" + modelid));
            KSCMS.Die(count);
            #endregion
        }


        public string GetCosPeriod(int gettype = 0, int courseid = 0, int userid = 0)
        {
            if (userid == 0)
                userid = Utils.StrToInt(KSCMS.S("userid"));
            if (courseid == 0)
                courseid = Utils.StrToInt(KSCMS.S("courseid"));
            if (!string.IsNullOrEmpty(KSCMS.S("from")))
            {
                KSCMS.Die(Kesion.APPCode.Public.GetCosPeriod(courseid, userid, KSCMS.S("from"), KSCMS.S("action")));
            }

            return Kesion.APPCode.Public.GetCosPeriod(gettype, courseid, userid);

        }

        public void GetCosInfo()
        {
            #region 会员中心获取课程和学员的数据
            StringBuilder sb = new StringBuilder();
            StringBuilder sb2 = new StringBuilder();
            int courseid = Utils.StrToInt(KSCMS.S("courseid"));

            using (DataTable dt = DataFactory.GetDataTable("select top 1 zlnum,sjnum,countpid,tcid from KS_Course where courseid=" + courseid))
            {
                if (dt.Rows.Count > 0)
                {
                    sb.Append(@"{");
                    sb.AppendFormat("\"zlnum\":\"{0}\",", dt.Rows[0][0].ToString());
                    sb.AppendFormat("\"sjnum\":\"{0}\",", dt.Rows[0][1].ToString());
                    sb.AppendFormat("\"countpid\":\"{0}\",", dt.Rows[0][2].ToString());
                    string tcname = string.Empty;
                    if (!string.IsNullOrEmpty(dt.Rows[0][2].ToString()))
                    {
                        using (DataTable dts = DataFactory.GetDataTable("select Tname from KS_cosTeacher where tcid in(" + dt.Rows[0][3].ToString() + ")"))
                        {
                            if (dts.Rows.Count > 0)
                            {
                                foreach (DataRow drs in dts.Rows)
                                {
                                    tcname += drs["tname"].ToString() + ",";
                                }
                                sb.AppendFormat("\"tname\":\"{0}\",", tcname.TrimEnd(','));
                            }
                        }
                    }
                    sb.AppendFormat("\"bjnum\":\"{0}\"", DataFactory.GetOnlyValue("select top 1 count(*) from KS_CosBj where courseid=" + courseid));
                    sb.Append(@"}");
                }
            }

            if (!string.IsNullOrEmpty(sb.ToString()))
            {
                sb2.AppendFormat("\"CosData\":{0}", sb.ToString());
            }
            string s = GetCosPeriod(1, courseid);
            if (!string.IsNullOrEmpty(s))
            {
                s = s.Substring(0, (s.Length - 1));
                if (!string.IsNullOrEmpty(sb.ToString()))
                {

                    s = s + "," + sb2.ToString() + "}";
                }
                else
                {
                    s = s + sb2.ToString() + "}";
                }
            }
            else
            {
                s = "{" + sb2.ToString() + "}";
            }

            KSCMS.Die(s);
            #endregion
        }




        public bool IsReusable
        {
            get
            {
                return false;
            }
        }

        /*private void GetInputClass()
        {
            #region 投稿栏目选项
            StringBuilder sb = new StringBuilder();
            int classId = Utils.StrToInt(KSCMS.S("classid"));
            string parentIdPath = string.Empty;
            int depth = 0;
            using (DataTable dt = DataFactory.GetDataTable("select classid,classname,root,depth,child,orderid,classtype,AllowPubGroupID,AllowPubInfo,PubFlag,parentIdPath from KS_Class A Inner Join KS_Model B on a.channelid=b.ChannelID Where a.parentid=" + classId + " and a.ClassType=1 and B.BasicType!=4 And B.ModelStatus=1 Order By root,OrderID asc,ClassID desc"))
            {
                foreach (DataRow dr in dt.Rows)
                {
                    bool classPower = ClassManage.CheckClassUserPurview(dr);
                    bool childPower = ClassManage.CheckChildUserPurView(dr);
                    if (classPower == true || childPower == true)
                    {
                        parentIdPath = dr["parentIdPath"].ToString();
                        depth = Utils.StrToInt(dr["depth"].ToString());
                        if (classPower == false || dr["pubFlag"].ToString() == "0")
                        {
                            if (Utils.StrToInt(dr["child"].ToString()) > 0)
                            {
                                sb.AppendLine(string.Format(@"<option value=""{0}"" ispub=""0"">{1}</option>", dr["classid"].ToString(), dr["classname"].ToString()));
                            }
                        }
                        else
                        {
                            sb.AppendLine(string.Format(@"<option value=""{0}"" ispub=""1"">{1}</option>", dr["classid"].ToString(), dr["classname"].ToString()));
                        }
                    }

                }
            }
            string str = sb.ToString();
            if (!string.IsNullOrEmpty(str))
            {
                KSCMS.W(string.Format(@"<li depth=""{0}"">", depth));
                KSCMS.W(string.Format(@"<select onchange=""changeclass(this.value,{0},{2})"" name=""m{0}"" id=""m{0}"" multiple=""multiple"" style=""height:220px;width:180px;"">{1}</select>", classId, str,depth));
                KSCMS.W("</li>");
            }
            KSCMS.Die("");
            #endregion
        }*/


        #region   判断小组的权限问题

        //判断小组里面是否有该成员    检查小组
        private void checkgroup()
        {
            int count = Utils.StrToInt(DataFactory.GetOnlyValue("select count(1) from KS_BBSMember where userid=" + new TemporaryVar().UserID + " and BoardId =" + KSCMS.S("groupid")));

            if (count == 0)
            {
                addgrouplimits();//新增组员
            }
            else
            {
                KSCMS.Die("您已经是该小组组员！");
            }
        }
        //加入小组
        private void addgrouplimits()
        {
            //1表示没有权限进入小组    2表示加入小组成功  //0表示未登录
            if (CheckUserLogin.Check() == "success")
            {
                int userid = (new TemporaryVar()).UserID;//当前用户的id信息
                int groupid = Utils.StrToInt(KSCMS.S("groupid"));
                string setting = DataFactory.GetOnlyValue("select top 1 setting from KS_BBSBoard where BoardID =" + groupid);
                setting = setting + "$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$";
                string[] seting = System.Text.RegularExpressions.Regex.Split(setting, @"[$]{4}");
                if (seting[26].ToString() == "1")//判断是否加入小组信息
                {
                    Hashtable ht = new Hashtable();
                    ht.Add("userid", new TemporaryVar().UserID);
                    ht.Add("username", new TemporaryVar().UserName);
                    ht.Add("BoardId", groupid);
                    CommonData.Insert("KS_BBSMember", ht);
                    //更新组员数量
                    DataFactory.ExecuteNonQuery("Update KS_BBSBoard set studentnum=studentnum+1 where BoardID=" + groupid);
                    KSCMS.Die("2");//2表示加入小组成功
                }
                else
                {
                    KSCMS.Die("1");//1表示没有权限进入小组
                }

            }
            else
            {
                KSCMS.Die("0");//0表示未登录
            }
        }
        #endregion




        private void getSkinPic()
        {
            #region 得到风格图片
            var skinId = Utils.StrToInt(KSCMS.S("skinid"));
            if (skinId > 0)
            {
                using (DataTable dt = DataFactory.GetDataTable("select top 1 defaultPic From KS_Template Where templateid=" + skinId))
                {
                    if (dt.Rows.Count > 0)
                    {
                        KSCMS.Die(dt.Rows[0][0].ToString());
                    }
                }
            }
            KSCMS.Die("");
            #endregion
        }


        #region Digg模块
        private void Digg()
        {
            #region Digg模块
            string Action = KSCMS.S("Action");
            int ChannelID = Utils.StrToInt(KSCMS.S("Channelid"));
            int InfoID = Utils.StrToInt(KSCMS.S("infoid"));
            int DiggType = Utils.StrToInt(KSCMS.S("diggtype"));
            if (ChannelID == 0 || InfoID == 0)
            {
                KSCMS.Die("err");
            }
            string username = Utils.ChkSQL(KSCMS.GetCookie("User", "username"));

            if (Action.Equals("hits"))
            {
                if (username.Equals("") && MyCache.GetCacheModel(ChannelID, 13) == "0")
                    KSCMS.Die("nologin");
                else
                {
                    if (username.Equals("")) username = "游客";

                    #region 检测并添加被Digg的主题
                    DiggManage.CreateDiggList(ChannelID, InfoID, username, 0, DiggType);
                    #endregion

                    int diggid = Utils.StrToInt(DataFactory.GetOnlyValue(string.Format(@"Select top 1 DiggID From KS_DiggList Where ChannelID={0} And InfoID={1}", ChannelID, InfoID)));
                    string diggstatus = DiggManage.CheckHasDigg(ChannelID, InfoID, username);
                    if (diggstatus != "nodigg")
                    {
                        KSCMS.Die(diggstatus);
                    }

                    DiggManage.CreateDigg(ChannelID, InfoID, username, diggid, DiggType);


                    int diggAddScore = Utils.StrToInt(MyCache.GetModelSetting(ChannelID, 13));
                    int diggAddInputerScore = Utils.StrToInt(MyCache.GetModelSetting(ChannelID, 14));
                    int maxScorePerDay = Utils.StrToInt(MyCache.GetModelSetting(ChannelID, 15));
                    if (diggAddScore > 0 || diggAddInputerScore > 0)
                    {
                        using (DataTable dt = DataFactory.GetDataTable(string.Format("select top 1 title,inputer from {0} where infoid={1}", MyCache.GetCacheModel(ChannelID, 3), InfoID)))
                        {
                            if (dt.Rows.Count > 0)
                            {
                                string title = dt.Rows[0]["title"].ToString();
                                string inputer = dt.Rows[0]["inputer"].ToString();
                                int HasAddScore = 0;
                                if (maxScorePerDay > 0)
                                {
                                    HasAddScore = Utils.StrToInt(DataFactory.GetOnlyValue("select sum(score) from KS_LogScore Where InOrOutFlag=1 and ChannelID=" + -ChannelID + " and year(AddDate)=" + DateTime.Now.Year + " and month(AddDate)=" + DateTime.Now.Month + " and day(AddDate)=" + DateTime.Now.Day));
                                }
                                if (HasAddScore < maxScorePerDay || maxScorePerDay == 0)  //未达到一天允许增加的积分数，才继续
                                {
                                    if (diggAddScore > 0 && CheckUserLogin.Check() == "success" && new TemporaryVar().UserName != inputer)
                                    {
                                        #region 赠送点Digg会员积分
                                        if (!DataFactory.Exists("KS_LogScore", "ChannelID=" + -ChannelID + " and infoid=" + -InfoID + " and username='" + new TemporaryVar().UserName + "'"))
                                        {
                                            Charge.ScoreInOrOut(-ChannelID, -InfoID, new TemporaryVar().UserName, 1, diggAddScore, "system", "对文章[" + title + "]进行Digg奖励！");
                                        }
                                        #endregion
                                    }
                                    if (diggAddInputerScore > 0 && DiggType == 0 && inputer != username)
                                    {
                                        #region 投稿的文章被赞加积分
                                        string remark = "您发表的文章[" + title + "]被用户[" + username + "]点赞奖励！";
                                        if (!DataFactory.Exists("KS_LogScore", "ChannelID=" + -ChannelID + " and infoid=" + -InfoID + " and username='" + inputer + "' and remark='" + remark + "'"))
                                        {
                                            if (DataFactory.Exists("KS_Admin", "username='" + inputer + "'") == false && DataFactoryUser.Exists("KS_User", "username='" + inputer + "'"))  //非管理员发的稿件才赠送积分
                                            {
                                                Charge.ScoreInOrOut(-ChannelID, -InfoID, inputer, 1, diggAddInputerScore, "system", remark);
                                            }
                                        }
                                        #endregion
                                    }
                                }
                            }
                        }

                    }

                    if (DiggType == 0)
                    {
                        DataFactory.ExecuteNonQuery(string.Format(@"Update KS_DiggList set SupportNum=SupportNum+{2} Where ChannelID={0} And InfoID={1}", ChannelID, InfoID, Utils.StrToInt(MyCache.GetCacheModel(ChannelID, 15))));

                        if (MyCache.GetCacheModel(ChannelID, 4) == "4")
                        {
                            DataFactory.ExecuteNonQuery(string.Format(@"Update KS_ProductList set GoodNum=GoodNum+{2} Where ChannelID={0} And InfoID={1}", ChannelID, InfoID, Utils.StrToInt(MyCache.GetCacheModel(ChannelID, 15))));
                        }
                        else
                        {
                            DataFactory.ExecuteNonQuery(string.Format(@"Update KS_InfoList set GoodNum=GoodNum+{2} Where ChannelID={0} And InfoID={1}", ChannelID, InfoID, Utils.StrToInt(MyCache.GetCacheModel(ChannelID, 15))));
                        }
                        DataFactory.ExecuteNonQuery(string.Format(@"Update {3} set GoodNum=GoodNum+{2} Where ChannelID={0} And InfoID={1}", ChannelID, InfoID, Utils.StrToInt(MyCache.GetCacheModel(ChannelID, 15)), MyCache.GetCacheModel(ChannelID, 3)));



                        //Response.Write(InfoID + "|" + DataFactory.GetOnlyValue(string.Format(@"Select SupportNum From KS_DiggList Where ChannelID={0} And InfoID={1}", ChannelID, InfoID)));
                    }
                    else
                    {
                        DataFactory.ExecuteNonQuery(string.Format(@"Update KS_DiggList set AgainstNum=AgainstNum+{2} Where ChannelID={0} And InfoID={1}", ChannelID, InfoID, Utils.StrToInt(MyCache.GetCacheModel(ChannelID, 15))));

                        if (MyCache.GetCacheModel(ChannelID, 4) == "4")
                        {
                            DataFactory.ExecuteNonQuery(string.Format(@"Update KS_ProductList set BadNum=BadNum+{2} Where ChannelID={0} And InfoID={1}", ChannelID, InfoID, Utils.StrToInt(MyCache.GetCacheModel(ChannelID, 15))));
                        }
                        else
                        {
                            DataFactory.ExecuteNonQuery(string.Format(@"Update KS_InfoList set BadNum=BadNum+{2} Where ChannelID={0} And InfoID={1}", ChannelID, InfoID, Utils.StrToInt(MyCache.GetCacheModel(ChannelID, 15))));
                        }
                        DataFactory.ExecuteNonQuery(string.Format(@"Update {3} set GoodNum=GoodNum+{2} Where ChannelID={0} And InfoID={1}", ChannelID, InfoID, Utils.StrToInt(MyCache.GetCacheModel(ChannelID, 15)), MyCache.GetCacheModel(ChannelID, 3)));


                    }

                    KSCMS.Die(InfoID + "|" + DataFactory.GetOnlyValue(string.Format(@"Select SupportNum From KS_DiggList Where ChannelID={0} And InfoID={1}", ChannelID, InfoID)) + "|" + DataFactory.GetOnlyValue(string.Format(@"Select AgainstNum From KS_DiggList Where ChannelID={0} And InfoID={1}", ChannelID, InfoID)));


                }
            }
            else
            {

                KSCMS.Die(InfoID + "|" + DataFactory.GetOnlyValue(string.Format(@"Select SupportNum From KS_DiggList Where ChannelID={0} And InfoID={1}", ChannelID, InfoID)) + "|" + DataFactory.GetOnlyValue(string.Format(@"Select AgainstNum From KS_DiggList Where ChannelID={0} And InfoID={1}", ChannelID, InfoID)));

            }
            KSCMS.Die();
            #endregion
        }
        #endregion

        /// <summary>
        /// 按栏目加载对应模型的文档
        /// </summary>
        private void LoadItemInfo()
        {
            #region 按栏目加载对应模型的文档
            int classId = Utils.StrToInt(KSCMS.S("classid"));
            int channelId = Utils.StrToInt(KSCMS.S("channelid"));
            int infoId = Utils.StrToInt(KSCMS.S("infoid"));
            StringBuilder sb = new StringBuilder();
            sb.AppendLine(string.Format(@" <option value='0'>--请选择{0}--</option>", MyCache.GetCacheModel(channelId, 5)));
            if (channelId > 0)
            {
                if (DataFactory.Exists("KS_Model", "channelid=" + channelId))
                {
                    string param = " where verify=1";
                    if (classId > 0) param += " and classid=" + classId;
                    using (DataTable dt = DataFactory.GetDataTable("select top 1000 infoid,title From " + MyCache.GetCacheModel(channelId, 3) + " " + param + " Order by InfoID Desc"))
                    {
                        if (dt.Rows.Count > 0)
                        {
                            foreach (DataRow dr in dt.Rows)
                            {
                                sb.AppendLine(string.Format("<option value='{0}'{2}>{1}</option>", dr["infoid"].ToString(), dr["title"].ToString(), dr["infoid"].ToString() == infoId.ToString() ? " selected" : string.Empty));
                            }
                        }

                    }
                }
            }
            KSCMS.Die(sb.ToString());


            #endregion
        }


        /// <summary>
        /// 后台添加文档加载栏目
        /// </summary>
        private void GetAdminInputClass()
        {
            #region 后台添加文档加载栏目
            var ChannelID = Utils.StrToInt(KSCMS.S("ChannelID"));
            var ParentID = Utils.StrToInt(KSCMS.S("ParentID"));
            if (KSCMS.S("folderID") != "0" && KSCMS.S("ischange").ToLower() == "false")
            { //编辑

                var ts = MyCache.GetCacheClass(Utils.StrToInt(KSCMS.S("folderid")), 3);
                ts += "," + KSCMS.S("folderid");
                ts = ts.Substring(2);
                var folderIdArr = ts.Split(',');

                for (var i = 0; i < folderIdArr.Length; i++)
                {
                    if (!string.IsNullOrEmpty(folderIdArr[i]))
                    {
                        LoadInputClassByParam(ChannelID, Utils.StrToInt(MyCache.GetCacheClass(Utils.StrToInt(folderIdArr[i]), 23)));
                    }
                }
            }
            else
            {
                LoadInputClassByParam(ChannelID, ParentID);
            }
            KSCMS.Die("");
            #endregion
        }

        private void LoadInputClassByParam(int ChannelID, int ParentID)
        {
            #region 后台添加文档加载栏目（条件）
            var ts = MyCache.GetCacheClass(Utils.StrToInt(KSCMS.S("folderid")), 3);
            ts += "," + KSCMS.S("folderid") + ",,,,,,,,,,,,,,,,,,,,,,,,,,,";
            ts = ts.Substring(2);
            var folderIdArr = ts.Split(',');

            StringBuilder sb = new StringBuilder();
            var depth = 1;
            var PubTF = 0;
            using (DataTable dt = MyCache.GetCacheClassTable())
            {
                if (dt.Rows.Count > 0)
                {
                    string param = "classtype=1 and parentid=" + ParentID;
                    if (ChannelID != 0) param += " and channelid=" + ChannelID;
                    DataView dv = dt.DefaultView;
                    dv.RowFilter = param;
                    using (DataTable dtt = dv.ToTable())
                    {

                        if (dtt.Rows.Count > 0)
                        {
                            foreach (DataRow dr in dtt.Rows)
                            {
                                depth = Utils.StrToInt(dr["depth"].ToString());
                                PubTF = Utils.StrToInt(dr["pubflag"].ToString());
                                var SelectStr = string.Empty;
                                var classId = Utils.StrToInt(dr["classid"].ToString());
                                var adminPurview = dr["adminPurview"].ToString();
                                if (folderIdArr[depth - 1] == classId.ToString()) SelectStr = @" selected=""true""";
                                if (KSCMS.GetCookie("Admin", "UserType") == "1" || Utils.InArray(KSCMS.GetCookie("Admin", "AdminUser"), adminPurview, ",") || CheckXJTk(classId, depth))
                                {
                                    sb.AppendLine(string.Format(@" <option value=""{0}"" ispub=""{1}""{2}>{3}</option>", classId, PubTF, SelectStr, dr["classname"].ToString()));
                                }
                            }
                        }
                    }

                }
            }

            if (sb.ToString().Length > 0 || ParentID == 0)
            {
                KSCMS.W(string.Format(@"<label depth=""{0}"">", depth));
                KSCMS.W(string.Format(@"<select onchange=""changeclass(this.value,'{0}',{1})"" name=""m{0}"" id=""m{0}""><option value='-1'>--请选择--</option>{2}</select>", ParentID, depth, sb.ToString()));
                KSCMS.W("</label>");
            }
            #endregion

        }
        /// <summary>
        /// 检查栏目ID检查下级有没有允许投稿的栏目
        /// </summary>
        /// <param name="classId"></param>
        /// <param name="tj"></param>
        /// <returns></returns>
        private bool CheckXJTk(int classId, int tj)
        {
            #region 检查栏目ID检查下级有没有允许投稿的栏目
            using (DataTable dt = MyCache.GetCacheClassTable())
            {
                if (dt.Rows.Count > 0)
                {
                    DataView dv = dt.DefaultView;
                    dv.RowFilter = "classtype=1 and ','+ParentIDPath+',' like '%," + classId + ",%' and depth>" + tj;
                    using (DataTable dtt = dv.ToTable())
                    {
                        if (dtt.Rows.Count > 0)
                        {
                            foreach (DataRow dr in dtt.Rows)
                            {
                                var adminPurview = dr["adminPurview"].ToString();
                                if (Utils.InArray(KSCMS.GetCookie("Admin", "AdminUser"), adminPurview, ","))
                                {
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
            return false;
            #endregion
        }



        private void GetInputClass()
        {
            #region 投稿栏目选项
            StringBuilder sb = new StringBuilder();
            int classId = Utils.StrToInt(KSCMS.S("classid"));
            string parentIdPath = string.Empty;
            int depth = 0;
            using (DataTable dt = DataFactory.GetDataTable("select classid,classname,root,depth,child,orderid,classtype,AllowPubGroupID,AllowPubInfo,PubFlag,parentIdPath from KS_Class A Inner Join KS_Model B on a.channelid=b.ChannelID Where a.parentid=" + classId + " and a.ClassType=1 and B.BasicType<>4 And B.ModelStatus=1 Order By root,OrderID asc,ClassID desc"))
            {

                foreach (DataRow dr in dt.Rows)
                {
                    bool classPower = ClassManage.CheckClassUserPurview(dr);
                    bool childPower = ClassManage.CheckChildUserPurView(dr);
                    if (classPower == true || childPower == true)
                    {
                        parentIdPath = dr["parentIdPath"].ToString();
                        depth = Utils.StrToInt(dr["depth"].ToString());
                        if (classPower == false || dr["pubFlag"].ToString() == "0")
                        {
                            if (Utils.StrToInt(dr["child"].ToString()) > 0)
                            {
                                sb.AppendLine(string.Format(@"<li depth=""{3}"" onclick=""changeclass({0},{2},{3})"" value=""{0}"" ispub=""0"">{1}</li>", dr["classid"].ToString(), dr["classname"].ToString(), classId, depth));

                            }
                        }
                        else
                        {
                            sb.AppendLine(string.Format(@"<li depth=""{3}"" onclick=""changeclass({0},{2},{3})"" value=""{0}"" ispub=""1"">{1}</li>", dr["classid"].ToString(), dr["classname"].ToString(), classId, depth));

                        }
                    }

                }
            }
            string str = sb.ToString();
            if (!string.IsNullOrEmpty(str))
            {
                KSCMS.W(string.Format(@"<li depth=""{0}"" class=""select_list"">", depth));
                //KSCMS.W(string.Format(@"<select onchange=""changeclass(this.value,{0},{2})"" name=""m{0}"" id=""m{0}"" multiple=""multiple"" style=""height:220px;width:180px;"">{1}</select>", classId, str, depth));
                KSCMS.W(string.Format(@"<div  name=""m{0}"" id=""m{0}"" multiple=""multiple"" class=""select_item""><ul>{1}</ul></div>", classId, str));
                KSCMS.W("</li>");


            }
            KSCMS.Die("");
            #endregion

        }


        /// <summary>
        /// 分享得积分
        /// </summary>
        private void ShareAddScore()
        {
            #region 分享得积分
            int classId = Utils.StrToInt(KSCMS.S("classid"));
            int infoId = Utils.StrToInt(KSCMS.S("infoid"));

            if (!string.IsNullOrEmpty((new TemporaryVar()).UserName))
            {
                if (classId == 0 || infoId == 0)
                {
                    KSCMS.Die("error!");
                }
                else
                {
                    int score = Utils.StrToInt(MyCache.GetCacheClass(classId, 36));
                    if (score > 0)
                    {
                        string remark = "分享[" + DataFactory.GetOnlyValue("select top 1 title from KS_InfoList Where InfoID=" + infoId) + "]所得!";
                        if (!DataFactoryUser.Exists("KS_LogScore", " username='" + (new TemporaryVar()).UserName + "' and InOrOutFlag=1 and channelid=" + classId + " and infoid=" + infoId))
                        {
                            Charge.ScoreInOrOut(classId, infoId, (new TemporaryVar()).UserName, 1, score, "system", remark);
                        }
                    }

                }
            }

            //记录分享次数
            int channelId = Utils.StrToInt(MyCache.GetCacheClass(classId, 12));
            if (MyCache.GetCacheModel(channelId, 4) == "4")
            {
                DataFactory.ExecuteNonQuery("Update KS_ProductList Set ShareNum=ShareNum+1 WHERE InfoID=" + infoId);
                DataFactory.ExecuteNonQuery("Update " + MyCache.GetCacheModel(channelId, 3) + " Set  ShareNum=ShareNum+1 WHERE InfoID=" + infoId);
            }
            else
            {
                DataFactory.ExecuteNonQuery("Update KS_InfoList Set  ShareNum=ShareNum+1 WHERE InfoID=" + infoId);
                DataFactory.ExecuteNonQuery("Update " + MyCache.GetCacheModel(channelId, 3) + " Set  ShareNum=ShareNum+1 WHERE InfoID=" + infoId);

            }
            #endregion
        }

        /// <summary>
        /// 点击广告
        /// </summary>
        private void ClickAds()
        {
            #region 点击广告
            int adId = Utils.StrToInt(KSCMS.S("adid"));
            int bid = Utils.StrToInt(KSCMS.S("bid"));
            if (adId == 0 || bid == 0 || string.IsNullOrEmpty(System.Web.HttpContext.Current.Request.ServerVariables["HTTP_REFERER"]))
            {
                return;
            }
            else
            {
                using (DataTable dt = DataFactory.GetDataTable("select top 1 * from KS_Advertise Where AdId=" + adId))
                {
                    if (dt.Rows.Count > 0)
                    {
                        DataRow dr = dt.Rows[0];

                        #region 记录点击记录
                        if (dr["recordclickip"].ToString() == "1")
                        {
                            Hashtable ht = new Hashtable();
                            ht.Add("adid", adId);
                            ht.Add("boardid", bid);
                            ht.Add("adddate", DateTime.Now);
                            ht.Add("userip", Utils.GetRealIP());
                            ht.Add("username", !string.IsNullOrEmpty((new TemporaryVar().UserName)) ? (new TemporaryVar().UserName) : "游客");
                            CommonData.Insert("KS_AdIpList", ht);
                        }
                        #endregion

                        #region 点广告送积分
                        int score = Utils.StrToInt(dr["clickscore"].ToString());
                        if (!string.IsNullOrEmpty(new TemporaryVar().UserName) && score > 0)
                        {
                            if (CheckUserLogin.Check() == "success")
                            {
                                string remark = "点广告[" + dr["title"].ToString() + "]所得!";
                                int ClickAddScorePerTime = Utils.StrToInt(dr["ClickAddScorePerTime"].ToString());

                                if (ClickAddScorePerTime == 0 || !DataFactoryUser.Exists("KS_LogScore", " datediff(hour,adddate,getdate())<" + ClickAddScorePerTime + " and username='" + (new TemporaryVar()).UserName + "' and InOrOutFlag=1 and channelid=-1 and infoid=" + adId))
                                {
                                    Charge.ScoreInOrOut(-1, adId, (new TemporaryVar()).UserName, 1, score, "system", remark);
                                }
                            }
                        }
                        #endregion

                        DataFactory.ExecuteNonQuery("Update KS_Advertise Set clicks=clicks+1 Where adid=" + adId + " and boardid=" + bid);
                    }
                }
            }
            KSCMS.Die("ok");
            #endregion

        }

        /// <summary>
        /// 检查FTP是否正常
        /// </summary>
        private void TestFtp()
        {
            #region ftp
            if (!string.IsNullOrEmpty(KSCMS.GetCookie("Admin", "AdminUser")))
            {
                string ftppass = string.Empty;
                string ftpuser = string.Empty;
                if (HttpContext.Current.Request["ftpuser"] != null) ftpuser = HttpContext.Current.Request["ftpuser"].ToString();
                if (HttpContext.Current.Request["ftppass"] != null) ftppass = HttpContext.Current.Request["ftppass"].ToString();
                FtpWeb ft = new FtpWeb(KSCMS.S("ftpip"), KSCMS.S("ftpport"), KSCMS.S("ftpdir"), ftpuser, ftppass);
                string upfile = "/web.config";
                string rstr = ft.Upload(upfile);
                if (rstr == "success")
                {
                    ft.Delete("/web.config");
                }
                KSCMS.Die(rstr);
            }
            #endregion
        }
        private void SetChargeStatus()
        {
            (new TemporaryVar()).CurrChargeInfoID = Utils.StrToInt(KSCMS.S("infoid"));
            (new TemporaryVar()).CurrChargeModelID = Utils.StrToInt(KSCMS.S("modelid"));
        }

        /// <summary>
        /// 检查发表到社交平台是否已授权
        /// </summary>
        private void checkToken()
        {
            #region 检查发表到社交平台是否已授权
            string apiid = KSCMS.S("apiid");
            if (string.IsNullOrEmpty(apiid))
            {
                KSCMS.Die("false");
            }
            else
            {
                apiid = apiid.ToLower();
                string token = MyCache.GetAccountAPIConfig(apiid, "token");
                string uid = MyCache.GetAccountAPIConfig(apiid, "uid");
                if (string.IsNullOrEmpty(token) || string.IsNullOrEmpty(uid))
                {
                    KSCMS.Die("false");
                }
                else
                {
                    switch (apiid)
                    {
                        case "sina":
                            string graph_url = "https://api.weibo.com/2/users/show.json";
                            graph_url += "?access_token=" + token + "&uid=" + uid;
                            Uri url = new Uri(graph_url);
                            string result = CollectionCommon.GetHttpPage(url, "utf-8");
                            if (result.IndexOf("error") == -1)
                            {
                                KSCMS.Die("true");
                            }
                            else
                            {
                                KSCMS.Die("false");
                            }
                            break;
                        case "qq":
                            graph_url = "https://graph.qq.com/user/get_user_info";
                            graph_url += "?access_token=" + token + "&oauth_consumer_key=" + MyCache.GetAccountAPIConfig(apiid, "apiid") + "&openid=" + uid;
                            url = new Uri(graph_url);
                            result = CollectionCommon.GetHttpPage(url, "utf-8");
                            Newtonsoft.Json.Linq.JObject jsonObj = Newtonsoft.Json.Linq.JObject.Parse(result);
                            if (jsonObj["ret"].ToString() == "0")
                            {
                                KSCMS.Die("true");
                            }
                            else
                            {
                                KSCMS.Die("false");
                            }
                            break;
                    }
                }
            }
            #endregion
        }

        /// <summary>
        /// 后台登录检查是否有新消息
        /// </summary>
        private void AdminCheckMsg()
        {
            #region 后台登录检查是否有新消息
            if (!string.IsNullOrEmpty(KSCMS.GetCookie("Admin", "AdminUser")))
            {
                StringBuilder sb = new StringBuilder();

                using (DataTable dt = DataFactory.GetDataTable("select top 10 addDate,TipsDays ,datediff(day,adddate,getdate()) From KS_AdminPlan where status=0 and datediff(day,adddate,getdate())<=TipsDays and adddate<getdate() and UserName='" + Utils.ChkSQL(KSCMS.GetCookie("Admin", "AdminUser")) + "'"))
                {
                    if (dt.Rows.Count > 0)
                    {
                        foreach (DataRow dr in dt.Rows)
                        {

                            sb.AppendFormat(@"<tr><td><a href=""javascript:;"" title=""点击查看未完成的计划"" onclick=""top.showPlan('{0}');"">{0}<span class=""tips"">({1})</span></a></td><td> 有工作计划未完成；</td></tr>", Convert.ToDateTime(dr["addDate"].ToString()).ToShortDateString(), Utils.GetWeekDay(Convert.ToDateTime(dr["addDate"].ToString())));

                        }
                    }
                }




                int num = 0;
                using (DataTable dt = MyCache.GetCacheModelTable())  //检查等审核稿件
                {
                    if (dt.Rows.Count > 0)
                    {
                        foreach (DataRow dr in dt.Rows)
                        {
                            if (KSSecurity.CheckMenuPower(dr["modelfolder"].ToString().ToLower())) //检查权限
                            {
                                if (KSSecurity.CheckPower("content", dr["modelfolder"].ToString().ToLower(), 3))
                                {

                                    string Param = string.Empty;
                                    if (KSCMS.GetCookie("Admin", "UserType") != "1")
                                    {
                                        Param = " inner join KS_Class b on a.classid=b.classid Where  a.deltf=0 and a.verify=0 and ','+cast(AdminPurview as nvarchar(4000))+',' like '%," + Utils.ChkSQL(KSCMS.GetCookie("Admin", "AdminUser")) + ",%'";
                                        if (KSCMS.GetCookie("Admin", "DocPower") == "1")
                                        {
                                            Param += " and a.inputer='" + KSCMS.GetCookie("Admin", "AdminUser") + "'";
                                        }
                                    }
                                    else
                                    {
                                        Param = " Where a.deltf=0 and a.verify=0";
                                    }
                                    num = Utils.StrToInt(DataFactory.GetOnlyValue("select count(1) From " + MyCache.GetCacheModel(Utils.StrToInt(dr["channelid"].ToString()), 3) + " a " + Param));
                                    if (num > 0)
                                    {
                                        sb.AppendFormat(@"<tr><td width=""180"" class=""tipsleft"">待审核{0}：</td><td class=""tipsright""><a href='Content/KS.ContentManage.aspx?channelid={1}&showType=1' target='main'><span>{2}</span>{3}</a></td></tr>", dr["modelitem"].ToString(), dr["channelid"].ToString(), num, dr["modelitemunit"].ToString());
                                    }


                                }
                            }
                        }
                    }
                }


                string power = KSSecurity.RemovePowerBadChar("Content/KS.Comment.aspx");
                if (KSSecurity.CheckMenuPower(power)) //检查权限
                {
                    num = Utils.StrToInt(DataFactory.GetOnlyValue("select count(1) From KS_Comment Where verify=0"));
                    if (num > 0)
                    {
                        sb.AppendFormat(@"<tr><td width=""180"" class=""tipsleft"">待审核评论：</td><td class=""tipsright""><a href='Content/KS.Comment.Aspx?showType=1' target='main'><span>{0}</span>条</a></td></tr>", num);
                    }
                    num = Utils.StrToInt(DataFactory.GetOnlyValue("select count(1) From KS_Comment Where reports>0"));
                    if (num > 0)
                    {
                        sb.AppendFormat(@"<tr><td width=""180"" class=""tipsleft"">被举报评论：</td><td class=""tipsright""><a href='Content/KS.Comment.Aspx?showType=3' target='main'><span>{0}</span>条</a></td></tr>", num);
                    }
                }

                #region 电商系统
                if (Utils.GetSysInfo("//sysinfo/model/mall").ToString().ToLower() == "true") //网店
                {
                    power = KSSecurity.RemovePowerBadChar("Shop/KS.ShopOrder.aspx");
                    if (KSSecurity.CheckMenuPower(power)) //检查权限
                    {
                        num = Utils.StrToInt(DataFactory.GetOnlyValue("select count(1) From KS_ProOrder Where MoneyReceipt>0 and DeliverStatus=0 and status=1"));
                        if (num > 0)
                        {
                            sb.AppendFormat(@"<tr><td width=""180"" class=""tipsleft"">已付款待发货：</td><td class=""tipsright""><a href='Shop/KS.ShopOrder.aspx?showType=2' target='main'><span>{0}</span>单</a></td></tr>", num);
                        }

                    }

                    power = KSSecurity.RemovePowerBadChar("Shop/KS.ShopLogDelivery.aspx");
                    if (KSSecurity.CheckMenuPower(power)) //检查权限
                    {
                        num = Utils.StrToInt(DataFactory.GetOnlyValue("select count(1) From KS_ProLogDeliver Where DeliverType=3 and status=0"));
                        if (num > 0)
                        {
                            sb.AppendFormat(@"<tr><td width=""180"" class=""tipsleft"">未处理的退货退款：</td><td class=""tipsright""><a href='Shop/KS.ShopLogDelivery.aspx?logType=5' target='main'><span>{0}</span>单</a></td></tr>", num);
                        }

                    }

                    power = KSSecurity.RemovePowerBadChar("Shop/KS.ShopOrder.aspx");
                    if (KSSecurity.CheckMenuPower(power)) //检查权限
                    {
                        num = Utils.StrToInt(DataFactory.GetOnlyValue("select count(1) From KS_ProOrder Where MoneyReceipt>0 and status=1 and IsInvoice=1 and Invoiced=0"));
                        if (num > 0)
                        {
                            sb.AppendFormat(@"<tr><td width=""180"" class=""tipsleft"">待开发票：</td><td class=""tipsright""><a href='Shop/KS.ShopOrder.aspx?showType=3' target='main'><span>{0}</span>单</a></td></tr>", num);
                        }

                    }

                    power = KSSecurity.RemovePowerBadChar("Shop/KS.ShopComment.aspx");
                    if (KSSecurity.CheckMenuPower(power)) //检查权限
                    {
                        num = Utils.StrToInt(DataFactory.GetOnlyValue("select count(1) From KS_ProComment Where Status=0"));
                        if (num > 0)
                        {
                            sb.AppendFormat(@"<tr><td width=""180"" class=""tipsleft"">待审核商品评价：</td><td class=""tipsright""><a href='Shop/KS.ShopComment.aspx?logType=2' target='main'><span>{0}</span>条</a></td></tr>", num);
                        }
                        num = Utils.StrToInt(DataFactory.GetOnlyValue("select count(1) From KS_ProCommentReply Where Status=0"));
                        if (num > 0)
                        {
                            sb.AppendFormat(@"<tr><td width=""180"" class=""tipsleft"">待审核商品评价回复：</td><td class=""tipsright""><a href='Shop/KS.ShopCommentReply.aspx?logType=2' target='main'><span>{0}</span>条</a></td></tr>", num);
                        }

                    }

                    power = KSSecurity.RemovePowerBadChar("Shop/KS.ShopAsk.aspx");
                    if (KSSecurity.CheckMenuPower(power)) //检查权限
                    {
                        num = Utils.StrToInt(DataFactory.GetOnlyValue("select count(1) From KS_ProAsk Where Status=0"));
                        if (num > 0)
                        {
                            sb.AppendFormat(@"<tr><td width=""180"" class=""tipsleft"">待审核商品咨询：</td><td class=""tipsright""><a href='Shop/KS.ShopAsk.aspx?logType=2' target='main'><span>{0}</span>条</a></td></tr>", num);

                        }
                    }


                }
                #endregion



                power = KSSecurity.RemovePowerBadChar("Common/KS.Link.aspx");
                if (KSSecurity.CheckMenuPower(power)) //检查权限
                {
                    num = Utils.StrToInt(DataFactory.GetOnlyValue("select count(1) From KS_Link Where verify=0"));
                    if (num > 0)
                    {
                        sb.AppendFormat(@"<tr><td width=""180"" class=""tipsleft"">待审核友情链接：</td><td class=""tipsright""><a href='Common/KS.Link.Aspx?showType=1' target='main'><span>{0}</span>个</a></td></tr>", num);
                    }
                }

                power = KSSecurity.RemovePowerBadChar("Common/KS.PKZTYJ.aspx");
                if (KSSecurity.CheckMenuPower(power)) //检查权限
                {
                    num = Utils.StrToInt(DataFactory.GetOnlyValue("select count(1) From KS_PKGD Where status=0"));
                    if (num > 0)
                    {
                        sb.AppendFormat(@"<tr><td width=""180"" class=""tipsleft"">待审核PK观点：</td><td class=""tipsright""><a href='Common/KS.PKZTYJ.aspx?showType=1' target='main'><span>{0}</span>条</a></td></tr>", num);
                    }
                }

                power = KSSecurity.RemovePowerBadChar("User/KS.User.aspx");
                if (KSSecurity.CheckMenuPower(power)) //检查权限
                {
                    num = Utils.StrToInt(DataFactoryUser.GetOnlyValue("select count(1) From KS_User Where locked=2"));
                    if (num > 0)
                    {
                        sb.AppendFormat(@"<tr><td width=""180"" class=""tipsleft"">待审核的会员：</td><td class=""tipsright""><a href='User/KS.User.aspx?UserType=3' target='main'><span>{0}</span>位</a></td></tr>", num);
                    }
                }


                if (sb.ToString().Length > 0)
                {
                    KSCMS.Die(@"<table width=""100%"">" + sb.ToString() + "</table>");
                }
                else
                {
                    KSCMS.Die();
                }
            }

            #endregion
        }

        //自动获取Tags
        public void GetKeyTags()
        {
            #region 自动获取Tags
            string str = Utils.UrlDecode(KSCMS.S("text"));
            if (string.IsNullOrEmpty(str))
            {
                KSCMS.Die();
            }
            else
            {
                StringBuilder sb = new StringBuilder();
                sb.Remove(0, sb.Length);
                string t1 = "";
                int i = 0;
                Analyzer analyzer = new Lucene.China.ChineseAnalyzer();
                System.IO.StringReader sr = new System.IO.StringReader(str);
                TokenStream stream = analyzer.TokenStream(null, sr);

                long begin = System.DateTime.Now.Ticks;
                Token t = stream.Next();
                while (t != null)
                {
                    t1 = t.ToString();     //显示格式： (关键词,0,2) ，需要处理
                    t1 = t1.Replace("(", "");
                    char[] separator = { ',' };
                    t1 = t1.Split(separator)[0];
                    if (t1.Length > 1)
                        sb.Append(t1 + " ");
                    t = stream.Next();
                    i++;
                }
                string key = sb.ToString();
                key = Utils.FilterRepeatInArray(key, " "); //过滤重复
                KSCMS.Die(key);
            }
            #endregion
        }

        private void LinkHits()
        {
            int linkid = Utils.StrToInt(KSCMS.S("linkid"));
            if (linkid > 0)
            {
                DataFactory.ExecuteNonQuery("UPDATE KS_Link Set Hits=hits+1 Where LinkID=" + linkid);
            }
        }

        //检查返回新短消息
        private string getNewMessage(int type)
        {
            #region 检查返回新短消息
            String numStr = String.Empty;
            if ((new TemporaryVar()).UserName == "")
            {
                numStr = "0";
            }
            else
            {
                SqlParam[] p = new SqlParam[2];
                p[0] = new SqlParam("ToUserName", (new TemporaryVar()).UserName);
                p[1] = new SqlParam("ReadTF", 0);
                DataTable dt = CommonData.GetDataTable("[KS_Message]", "id", p);
                if (dt.Rows.Count > 0)
                {
                    numStr = "<font class='red'>" + dt.Rows.Count + "</font><bgsound src='images/mail.wmv' loop=1 autostart=true  border=0/>";
                }
                else
                {
                    numStr = "0";
                }
                dt.Dispose();

            }

            if (type == 0)
            {
                return (string.Format("站内短信({0})", numStr));
            }
            else
            {
                return (string.Format("{0}", numStr));
            }
            #endregion

        }
        //目录树,以xml格式输出
        private void ClassTree()
        {
            #region 目录树,以xml格式输出
            string adminName = KSCMS.GetCookie("Admin", "AdminUser");
            string userType = KSCMS.GetCookie("Admin", "UserType");
            if (string.IsNullOrEmpty(adminName) || string.IsNullOrEmpty(userType)) return;

            int ParentID = Utils.StrToInt(KSCMS.S("PID"));
            StringBuilder sb = new StringBuilder();
            sb.Append(@"<?xml version=""1.0"" encoding=""UTF-8"" ?> ");
            sb.Append(" <data>");
            using (DataTable dt = ClassManage.GetClassTableByPurview())
            {
                if (dt != null)
                {
                    DataRow[] rows = dt.Select(string.Format("parentid={0}", ParentID.ToString()));

                    foreach (DataRow dr in rows)
                    {
                        string url = dr[2].ToString();

                        if (url.IndexOf("{$") != -1)
                        {
                            for (var m = Regex.Match(url, @"({\$[^{\$}]*})", RegexOptions.IgnoreCase); m.Success; m = m.NextMatch())
                            {
                                string keys = Regex.Match(m.Value, @"(?<=\{\$)[ ]*[\w\S ]+[ ]*(?=\})", RegexOptions.IgnoreCase).Value;
                                url = url.Replace(m.Value, Kesion.HtmlTags.ReplaceLabels.ParseStr(keys));
                            }
                        }

                        if (url.IndexOf("{=") != -1)
                        {
                            for (var m = Regex.Match(url, @"({=[^{\$}]*})", RegexOptions.IgnoreCase); m.Success; m = m.NextMatch())
                            {
                                string keys = Regex.Match(m.Value, @"(?<=\{=)[ ]*[\w\S ]+[ ]*(?=\})", RegexOptions.IgnoreCase).Value;
                                url = url.Replace(m.Value, Kesion.HtmlTags.ReplaceLabels.ParseEqualStr(keys, null));
                            }
                        }
                        url = url.Replace(MyCache.GetCacheConfig(5), string.Empty);


                        if (KSCMS.S("from") == "shop")
                        {
                            if (MyCache.GetCacheModel(Convert.ToInt16(dr["channelid"].ToString()), 4) == "4")
                            {
                                bool classPower = ClassManage.CheckClassPurview(dr, adminName, userType);
                                bool childPower = ClassManage.CheckChildPurView(dr, adminName, userType);
                                if (classPower == true || childPower == true)
                                {
                                    sb.AppendFormat(@"<treexml pid=""{1}"" childcount=""{2}"" layer=""{3}"" parentid=""{4}"" modelid=""{5}"" classtype=""{6}""  disabled=""{8}"" pubflag=""{9}"">
                                    <name><![CDATA[{0}]]></name>
                                    <classename><![CDATA[{7}]]></classename>
                                    </treexml>", dr[1].ToString(), dr[0].ToString(), dr[21].ToString(), Utils.StrToInt(dr[22].ToString()) - 1, dr[23].ToString(), dr[12].ToString(), dr[4].ToString(), url, classPower.ToString().ToLower(), dr["pubFlag"].ToString());
                                }

                            }
                        }
                        else
                        {
                            if (MyCache.GetCacheModel(Convert.ToInt16(dr["channelid"].ToString()), 4) != "4")
                            {
                                //  bool classPower = ClassManage.CheckClassPurview(dr, adminName, userType);
                                //  bool childPower = ClassManage.CheckChildPurView(dr, adminName, userType);
                                //   if (classPower == true || childPower == true)
                                {
                                    sb.AppendFormat(@"<treexml pid=""{1}"" childcount=""{2}"" layer=""{3}"" parentid=""{4}"" modelid=""{5}"" classtype=""{6}""  disabled=""{8}"" pubflag=""{9}"">
                                       <name><![CDATA[{0}]]></name>
                                       <classename><![CDATA[{7}]]></classename>
                                      </treexml>", dr[1].ToString(), dr[0].ToString(), dr[21].ToString(), Utils.StrToInt(dr[22].ToString()) - 1, dr[23].ToString(), dr[12].ToString(), dr[4].ToString(), url, "true", dr["pubFlag"].ToString());
                                }

                            }

                        }

                    }
                }
            }
            sb.Append("</data>");


            WriteXML(sb.ToString());
            #endregion
        }



        /// <summary>
        /// 获取课时
        /// </summary>
        private void CoursePeriod()
        {
            int courseid = Utils.StrToInt(KSCMS.S("courseid"));//获取课程id
            int ClassID = Utils.StrToInt(KSCMS.S("PID"));
            StringBuilder sb = new StringBuilder();
            sb.Append(@"<?xml version=""1.0"" encoding=""UTF-8"" ?> ");
            sb.Append(" <data>");
            if (ClassID == -1)
            {
                using (DataTable dt = DataFactory.GetDataTable("select * from KS_CosPeriod where courseid=" + courseid))
                {
                    if (dt != null)
                    {
                        foreach (DataRow dr in dt.Rows)
                        {
                            if (dr["parentid"].ToString() == "0" && dr["depth"].ToString() == "1")
                            {
                                if (dr["addtype"].ToString() == "1") //课时
                                {
                                    sb.AppendFormat(@"<treexml name=""{0}"" pid=""{1}"" childcount=""0"" layer=""1"" parentid=""{0}""/> ", dr["PeriodName"].ToString(), dr["PeriodID"].ToString());
                                }
                                else if (dr["addtype"].ToString() == "0")//章
                                {
                                    sb.AppendFormat(@"<treexml name=""{0}"" pid=""{1}"" childcount=""1"" layer=""0"" parentid=""{0}""/> ", dr["PeriodName"].ToString(), dr["PeriodID"].ToString());
                                }
                                else if (dr["addtype"].ToString() == "2")//节
                                {
                                    sb.AppendFormat(@"<treexml name=""{0}"" pid=""{1}"" childcount=""1"" layer=""0"" parentid=""{0}""/> ", dr["PeriodName"].ToString(), dr["PeriodID"].ToString());
                                }
                            }
                        }
                    }
                }
            }
            else
            {
                using (DataTable dt = DataFactory.GetDataTable("select * from KS_CosPeriod where parentid=" + ClassID + " and courseid=" + courseid))
                {
                    foreach (DataRow dr in dt.Rows)
                    {
                        if (dr["addtype"].ToString() == "2")//节
                        {
                            sb.AppendFormat(@"<treexml name=""{0}"" pid=""{1}"" childcount=""1"" layer=""0"" parentid=""{2}""/> ", dr["PeriodName"].ToString(), dr["PeriodID"].ToString(), ClassID.ToString());
                        }
                        else if (dr["addtype"].ToString() == "1")
                        {
                            sb.AppendFormat(@"<treexml name=""{0}"" pid=""{1}"" childcount=""0"" layer=""1"" parentid=""{2}""/> ", dr["PeriodName"].ToString(), dr["PeriodID"].ToString(), ClassID.ToString());
                        }
                    }
                }
            }
            sb.Append("</data>");
            WriteXML(sb.ToString());
        }




        /// <summary>
        /// 专题分类
        /// </summary>
        private void SpecialClassTree()
        {
            int ClassID = Utils.StrToInt(KSCMS.S("PID"));
            StringBuilder sb = new StringBuilder();
            sb.Append(@"<?xml version=""1.0"" encoding=""UTF-8"" ?> ");
            sb.Append(" <data>");
            DataTable dt;
            if (ClassID == -1)
            {
                sb.AppendFormat(@"<treexml name=""{0}"" pid=""{1}"" childcount=""1"" layer=""0"" parentid=""{0}""/> ", "全站专题", 0);

                dt = CommonData.GetDataTable(3);
                if (dt != null)
                {
                    foreach (DataRow dr in dt.Rows)
                    {
                        sb.AppendFormat(@"<treexml name=""{0}"" pid=""{1}"" childcount=""1"" layer=""0"" parentid=""{0}""/> ", dr[1].ToString(), dr[0].ToString());
                    }
                }
            }
            else
            {

                SqlParam[] param = new SqlParam[1];
                param[0] = new SqlParam("classid", ClassID);
                dt = CommonData.GetDataTable("[KS_Special]", "SpecialID,SpecialName", param, "SpecialID Desc");
                foreach (DataRow dr in dt.Rows)
                {
                    sb.AppendFormat(@"<treexml name=""{0}"" pid=""{1}"" childcount=""0"" layer=""1"" parentid=""{2}""/> ", dr[1].ToString(), dr[0].ToString(), ClassID.ToString());
                }

            }
            sb.Append("</data>");
            WriteXML(sb.ToString());


        }
        //栏目名转拼音,以文本格式输出
        private void ConvertClassName()
        {
            string ClassName = Utils.RemoveXss(KSCMS.S("classname"));
            if (!string.IsNullOrEmpty(ClassName))
            {

                KSCMS.Die(UtilsPinyin.Convert(ClassName));
                // KSCMS.Die(UtilsPinyin.GetChineseSpell(ClassName).ToLower());
            }
        }
        //模型英文名，以文本格式输出
        private void GetModelEname()
        {
            int ModelID = Utils.StrToInt(KSCMS.S("ModelID"));
            int col = Utils.StrToInt(KSCMS.S("col"));
            if (ModelID != 0)
            {
                KSCMS.Die(MyCache.GetCacheModel(ModelID, col));

            }
        }

        //测试截取列表
        private void GetTestCollectList()
        {

            string ListStartTag = HttpContext.Current.Request.QueryString["liststarttag"];
            string ListEndTag = HttpContext.Current.Request.QueryString["ListEndTag"];
            string Url = HttpContext.Current.Request.QueryString["Url"];
            string Encoding = HttpContext.Current.Request.QueryString["Encoding"];
            Uri url = new Uri(Url);
            string PageText = CollectionCommon.GetHttpPage(url, Encoding);
            string CutText = CollectionCommon.CutHttpString(PageText, ListStartTag, ListEndTag);
            HttpContext.Current.Response.Write(CutText);

        }
        //测试载取列表的链接
        private void GetTestCollectListLink()
        {
            string ListStartTag = HttpContext.Current.Request.QueryString["liststarttag"];
            string ListEndTag = HttpContext.Current.Request.QueryString["ListEndTag"];
            string LinkStartTag = HttpContext.Current.Request.QueryString["linkstarttag"];
            string LinkEndTag = HttpContext.Current.Request.QueryString["linkendtag"];
            string Url = HttpContext.Current.Request.QueryString["Url"];
            string Encoding = HttpContext.Current.Request.QueryString["Encoding"];
            Uri url = new Uri(Url);
            string PageText = CollectionCommon.GetHttpPage(url, Encoding);
            string CutText = CollectionCommon.CutHttpString(PageText, ListStartTag, ListEndTag);

            ArrayList list = CollectionCommon.GetArray(CutText, LinkStartTag, LinkEndTag);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < list.Count; i++)
            {
                sb.Append(CollectionCommon.ConvertToAbsluteUrl(list[i].ToString(), Url.ToString()) + "\r\n");
            }
            HttpContext.Current.Response.Write(sb.ToString());

        }

        //后台模型字段管理列表
        private void GetModelFieldManage()
        {
            DataTable dt = MyCache.GetCacheModelTable();
            if (Utils.GetSysInfo("//sysinfo/model/mall") == "false")
            {
                DataView dv = dt.DefaultView;
                dv.RowFilter = "basictype<>4";
                dt = dv.ToTable();
            }


            if (dt != null)
            {
                foreach (DataRow dr in dt.Rows)
                {

                    HttpContext.Current.Response.Write(string.Format(@"<li><a href=""Model/KS.Field.aspx?Channelid={0}"" target=""main"">{1}字段管理</a></li>", dr["channelid"].ToString(), dr["modelname"].ToString()));
                }
            }
            dt.Dispose();

        }
        //检查是否登录
        private void CheckIsLogin()
        {
            #region 检查是否登录
            StringBuilder sb = new StringBuilder();
            sb.Append(@"<?xml version=""1.0"" encoding=""UTF-8"" ?>");
            sb.Append(@"<login>");

            if (CheckUserLogin.Check() != "success")
            {
                sb.Append("<islogin>false</islogin>");
            }
            else
            {
                sb.AppendLine("<islogin>true</islogin>");
                UserInfo __info = UserManage.GetUserInfo();
                if (__info == null)
                {
                    __info = UserManage.GetUserInfo(new TemporaryVar().UserID);
                }
                sb.AppendFormat("<username>{0}</username>", __info.UserName);
                sb.AppendFormat("<score>{0}</score>", __info.Score.ToString());
                sb.AppendFormat("<money>{0}</money>", __info.Money.ToString());
                sb.AppendFormat("<point><![CDATA[{0}]]></point>", "当前" + MyCache.GetCacheConfig(49) + ":" + __info.Point.ToString() + MyCache.GetCacheConfig(50));
                sb.AppendFormat("<message><![CDATA[{0}]]></message>", getNewMessage(2));
                sb.AppendFormat("<logintimes>{0}</logintimes>", __info.LoginTimes.ToString());
                sb.AppendFormat("<userface>{0}</userface>", __info.UserFace);
                sb.AppendFormat("<userid>{0}</userid>", __info.UserID);
                sb.AppendFormat("<groupid>{0}</groupid>", __info.GroupID);
                sb.AppendFormat("<realname>{0}</realname>", __info.RealName);
                __info = null;
            }
            sb.Append("</login>");

            WriteXML(sb.ToString());
            #endregion
        }

        //获取市级选项
        private void LoadCityOption()
        {
            int pId = Utils.StrToInt(KSCMS.S("pid"));
            StringBuilder psb = new StringBuilder();
            using (DataTable dt = DataFactory.GetDataTable("select id,city from ks_area where parentid=" + pId + " order by orderid ,id"))
            {
                if (dt.Rows.Count > 0)
                {
                    // psb.Append(@"<select name=""cityid"" id=""cityid"" onchange=""loadCounty();"">");
                    //  psb.AppendLine(string.Format(@"<option value=''>{0}</option>", Utils.GetLanguageNode("//language/node[@name='modelview']/shopmodel/pleaseselectbyoption")));
                }

                foreach (DataRow dr in dt.Rows)
                {
                    psb.AppendFormat(@"<option value=""{0}"">{1}</option>", dr[0].ToString(), dr[1].ToString());
                }
                // if (dt.Rows.Count > 0) psb.Append("</select><span id='showcounty'></span>");
            }
            KSCMS.W(psb.ToString());
        }
        private void LoadCountyOption()
        {
            int pId = Utils.StrToInt(KSCMS.S("cid"));
            StringBuilder psb = new StringBuilder();
            using (DataTable dt = DataFactory.GetDataTable("select id,city from ks_area where parentid=" + pId + " order by orderid ,id"))
            {
                if (dt.Rows.Count > 0)
                {
                    //   psb.Append(@"<select name=""countyid"" id=""countyid"" onchange=""loadSelect();"">");
                    //    psb.AppendLine(string.Format(@"<option value=''>{0}</option>", Utils.GetLanguageNode("//language/node[@name='modelview']/shopmodel/pleaseselectbyoption")));
                }

                foreach (DataRow dr in dt.Rows)
                {
                    psb.AppendFormat(@"<option value=""{0}"">{1}</option>", dr[0].ToString(), dr[1].ToString());
                }
                // if (dt.Rows.Count > 0) psb.Append("</select><span id='showcounty'></span>");
            }
            KSCMS.W(psb.ToString());
        }
        private void GetNoSelectProvince()
        {
            string nval = string.Empty;
            string param = string.Empty;
            int deliveryId = Utils.StrToInt(KSCMS.S("deliveryId"));
            param = " WHERE ParentID=0";
            if (!string.IsNullOrEmpty(nval))
            {
                // nval = "'" + Utils.ReplaceString(nval, ",", "','", true) + "'";
                // param += " and City Not In(" + nval + ")";
            }

            using (DataTable dt = DataFactory.GetDataTable("select * from KS_ProDeliveryItem WHERE  DeliveryID=" + deliveryId))
            {
                if (dt.Rows.Count > 0)
                {
                    foreach (DataRow dr in dt.Rows)
                    {
                        nval += "," + dr["provinces"].ToString();
                    }
                }
            }



            string str = string.Empty;

            using (DataTable dt = DataFactory.GetDataTable(string.Format(@"select id,city from KS_Area {0} Order by OrderID,ID", param)))
            {
                if (dt.Rows.Count > 0)
                {
                    foreach (DataRow dr in dt.Rows)
                    {
                        #region 城市
                        DataRow[] drrcity = MyCache.GetAreaTable().Select("parentid=" + dr["id"].ToString());
                        if (drrcity.Length > 0)
                        {
                            foreach (DataRow drcity in drrcity)
                            {
                                DataRow[] drrcounty = MyCache.GetAreaTable().Select("parentid=" + drcity["id"].ToString());
                                if (drrcounty.Length > 0)
                                {
                                    foreach (DataRow drcounty in drrcounty)
                                    {
                                        #region 城镇
                                        string item = dr["city"].ToString() + "->" + drcity["city"].ToString() + "->" + drcounty["city"].ToString();
                                        if (Utils.InArray(item, nval, ",") == false)
                                        {
                                            if (string.IsNullOrEmpty(str))
                                            {
                                                str = item;
                                            }
                                            else
                                            {
                                                str += "," + item;
                                            }
                                        }
                                        #endregion
                                    }
                                }


                            }
                        }
                        #endregion

                    }
                }
            }




            KSCMS.W(str);
        }

        #region PK相关

        #region 检查PK是否要登录才能发表
        private void CheckPKLogin()
        {
            int pkId = Utils.StrToInt(KSCMS.S("pkid"));
            if (pkId == 0)
            {
                HttpContext.Current.Response.Write("1|找不到PK主题!|null");
                return;
            }
            else
            {
                PKInfo __info = KSManage.getPKInfo(pkId);
                if (__info == null)
                {
                    HttpContext.Current.Response.Write("1|找不到PK主题!|null");
                    return;
                }
                else
                {
                    if (__info.Status == 0)
                    {
                        HttpContext.Current.Response.Write("1|该PK已锁定!|null");
                        return;
                    }
                    else if (__info.TimeLimit == 1 && DateTime.Now > __info.EndDate)
                    {
                        HttpContext.Current.Response.Write("1|该PK已过期了!|null");
                        return;
                    }
                    else if (__info.TimeLimit == 1 && DateTime.Now < __info.BeginDate)
                    {
                        HttpContext.Current.Response.Write("1|该PK还没开始呢!|null");
                        return;
                    }
                    else if (__info.UserTF == 1 && CheckUserLogin.Check() != "success")
                    {
                        HttpContext.Current.Response.Write("login||");
                        return;
                    }
                    else
                    {
                        HttpContext.Current.Response.Write("success||");
                        return;
                    }
                }

            }
        }



        #endregion

        #region 提交PK观点
        private void SavePKPost()
        {
            int pkId = Utils.StrToInt(KSCMS.S("pkid"));
            if (pkId == 0)
            {
                HttpContext.Current.Response.Write("1|找不到PK主题!|null");
                return;
            }
            else
            {
                PKInfo __info = KSManage.getPKInfo(pkId);
                if (__info == null)
                {
                    HttpContext.Current.Response.Write("1|找不到PK主题!|null");
                    return;
                }
                else
                {
                    if (__info.Status == 0)
                    {
                        HttpContext.Current.Response.Write("1|该PK已锁定!|null");
                        return;
                    }
                    else if (__info.TimeLimit == 1 && DateTime.Now > __info.EndDate)
                    {
                        HttpContext.Current.Response.Write("1|该PK已过期了!|null");
                        return;
                    }
                    else if (__info.TimeLimit == 1 && DateTime.Now < __info.BeginDate)
                    {
                        HttpContext.Current.Response.Write("1|该PK还没开始呢!|null");
                        return;
                    }
                    else if (__info.UserTF == 1 && CheckUserLogin.Check() != "success")
                    {
                        HttpContext.Current.Response.Write("login||");
                        return;
                    }
                    else if (__info.OnceTF == 1 && DataFactory.Exists("KS_PKGD", "PKID=" + pkId + " And UserIp='" + Utils.GetRealIP() + "'"))
                    {
                        HttpContext.Current.Response.Write("1|您已PK过了,请不要重复PK!|null");
                        return;
                    }
                    else
                    {
                        string content = KSCMS.S("Content");
                        int role = Utils.StrToInt(KSCMS.S("role"));
                        if (string.IsNullOrEmpty(content))
                        {
                            HttpContext.Current.Response.Write("1|请输入内容!|null");
                            return;
                        }
                        string userName = (new TemporaryVar()).UserName;
                        if (string.IsNullOrEmpty(userName)) userName = "网友";

                        PKGDInfo _gdInfo = new PKGDInfo();
                        _gdInfo.PKID = pkId;
                        _gdInfo.UserName = userName;
                        _gdInfo.Content = content;
                        _gdInfo.UserIP = Utils.GetRealIP();
                        _gdInfo.UserID = new TemporaryVar().UserID;
                        if (__info.VerifyTF == 1)
                            _gdInfo.Status = 0;
                        else
                            _gdInfo.Status = 1;
                        _gdInfo.Role = role;
                        _gdInfo.AddDate = DateTime.Now;
                        if (KSManage.addPKGD(_gdInfo) >= 1)
                        {
                            HttpContext.Current.Response.Write("success||");
                        }
                        else
                        {
                            HttpContext.Current.Response.Write("error||");
                        }
                        return;
                    }
                }

            }

        }
        #endregion

        #region PK得票数
        private void GetPKVotes()
        {
            int pkId = Utils.StrToInt(KSCMS.S("pkid"));
            PKInfo __info = KSManage.getPKInfo(pkId);
            if (__info == null)
            {
                HttpContext.Current.Response.Write("0|0|0");
            }
            else
            {
                HttpContext.Current.Response.Write(__info.ZFVotes.ToString() + "|" + __info.FFVotes.ToString() + "|" + __info.SFVotes.ToString());
            }

        }
        #endregion

        #region PK观点列表
        private void GetPKGDList()
        {
            int role = Utils.StrToInt(KSCMS.S("role"));
            int pkId = Utils.StrToInt(KSCMS.S("pkid"));

            IList<PKGDInfo> list = KSManage.getPkGDList(30, pkId, role);
            string str = string.Empty;
            int n = 0;
            foreach (PKGDInfo __info in list)
            {
                string content = string.Empty;
                string[] userIpArr = __info.UserIP.Split('.');
                string userIp = string.Empty;
                for (int i = 0; i < userIpArr.Length; i++)
                {
                    if (i == 3)
                    {
                        userIp += "*";
                    }
                    else
                    {
                        userIp += userIpArr[i] + ".";
                    }
                }
                if (__info.Status == 0)
                {
                    content = "此观点未通过审核!";
                }
                else
                {
                    content = __info.Content;
                }

                content = Utils.ReplaceString(content, "\n", "<br/>", false);
                content = Utils.ReplaceString(content, @"""", @"\""", false);

                DateTime addDate = __info.AddDate;
                string NewAddDate = addDate.Year + "/" + addDate.Month + "/" + addDate.Day + " " + addDate.Hour + ":" + addDate.Minute + ":" + addDate.Second;
                str += string.Format(@"{{""uname"":""{0}"",""comment_date"":""{1}"",""client_ip"":""{2}"",""comment_contents"":""{3}""}}", __info.UserName, NewAddDate, userIp, content);
                n++;
                if (n != list.Count) str += ",";
            }

            HttpContext.Current.Response.Write(string.Format(@"var commentJsonVarStr___={{""count"":""3"",""comments"":[{0}]}};", str));

            if (role == 1)
            {
                HttpContext.Current.Response.Write("showagree(commentJsonVarStr___);");
            }
            else if (role == 2)
            {
                HttpContext.Current.Response.Write("showargue(commentJsonVarStr___);");
            }
            else
            {
                HttpContext.Current.Response.Write("showother(commentJsonVarStr___);");

            }

        }
        #endregion

        #endregion


        #region 提交登录验证
        private void CheckLogin()
        {
            #region 提交登录验证
            string userName = KSCMS.S("username");
            string passWord = KSCMS.S("passWord");
            int ExpiresDate = Utils.StrToInt(KSCMS.S("ExpiresDate"));


            string msg = string.Empty;
            bool issuccess = false;

            if (!string.IsNullOrEmpty(userName))
            {
                userName = userName.Replace("'", string.Empty).Replace("%", string.Empty);
            }

            StringBuilder sb = new StringBuilder();
            sb.Append(@"<?xml version=""1.0"" encoding=""UTF-8"" ?><login>");


            //检查账号安全
            if (Utils.StrToInt(MyCache.GetShopCommonConfig(51)) > 0 && Utils.StrToInt(MyCache.GetShopCommonConfig(52)) > 0)
            {
                int errNum = Utils.StrToInt(DataFactoryUser.GetOnlyValue("select count(1) from ks_userrecord where flag=2 and datediff(minute,adddate,getdate())<" + Utils.StrToInt(MyCache.GetShopCommonConfig(52)) + " and (username='" + userName + "' or userip='" + Utils.GetRealIP() + "')"));
                if (errNum >= Utils.StrToInt(MyCache.GetShopCommonConfig(51)))
                {
                    issuccess = false;
                    msg = string.Format(Utils.GetLanguageNode("//language/node[@name='user']/login/errtimeslimit"), MyCache.GetShopCommonConfig(52));
                    goto Kesion_End_Tag;

                }
            }



            if (MyCache.GetCacheConfig(3).ToLower().IndexOf("user/login.aspx") != -1)
            {
                string verifycode = KSCMS.S("verifycode");
                HttpCookie cookie = HttpContext.Current.Request.Cookies["CheckCode"];
                if (verifycode.ToLower() != cookie.Value.ToLower() || string.IsNullOrEmpty(verifycode))
                {
                    issuccess = false;
                    msg = Utils.GetLanguageNode("//language/node[@name='user']/login/errverifycode");
                    goto Kesion_End_Tag;
                }
            }

            if (string.IsNullOrEmpty(userName) || string.IsNullOrEmpty(passWord))
            {
                issuccess = false;
            }
            else
            {

                int loginType = Utils.StrToInt(MyCache.GetShopCommonConfig(55));
                //非普通用户号，只能验证用户名字段
                if (Utils.StrToInt(MyCache.GetShopCommonConfig(56)) != 0) loginType = 0;


                string param = "username='" + Utils.ChkSQL(userName) + "' or userId=" + Utils.StrToInt(userName);
                switch (loginType)
                {
                    case 1: //仅手机号
                        param = "mobile='" + Utils.ChkSQL(userName) + "'";
                        break;
                    case 2: //仅电子邮件
                        param = "email='" + Utils.ChkSQL(userName) + "'";
                        break;
                    case 3: //手机号及电子邮件
                        param = "mobile='" + Utils.ChkSQL(userName) + "' or email='" + Utils.ChkSQL(userName) + "'";
                        break;
                    case 4: //普通用户名/UID、手机号及电子Email均可
                        param += " or mobile='" + Utils.ChkSQL(userName) + "' or email='" + Utils.ChkSQL(userName) + "'";
                        break;
                }
                using (DataTable dt = DataFactoryUser.GetDataTable("select top 1 locked,username,LastLoginTime,password,salt From KS_User Where " + param))
                {
                    if (dt.Rows.Count <= 0)
                    {
                        issuccess = false;
                        msg = Utils.GetLanguageNode("//language/node[@name='user']/login/erruser");
                        #region 记录登录失败
                        if (Utils.StrToInt(MyCache.GetShopCommonConfig(51)) > 0 && Utils.StrToInt(MyCache.GetShopCommonConfig(52)) > 0)
                        {
                            Kesion.APPCode.Public.addUserRecord(userName, 2, msg);
                        }
                        #endregion
                    }
                    else
                    {
                        DataRow dr = dt.Rows[0];
                        if (UserManage.CheckLogin(userName, ref passWord, dr["salt"].ToString()))
                        {

                            int locked = Utils.StrToInt(dr["Locked"].ToString());
                            userName = dr["username"].ToString();
                            DateTime LastLoginTime = Convert.ToDateTime(dr["LastLoginTime"].ToString());

                            if (locked == 1)
                            {
                                //锁定
                                issuccess = false;
                                msg = Utils.GetLanguageNode("//language/node[@name='user']/login/erruserlocked");
                            }
                            else if (locked == 2)
                            {
                                //认证
                                issuccess = false;
                                msg = Utils.GetLanguageNode("//language/node[@name='user']/login/erruserverify");
                            }
                            else if (locked == 3)
                            {
                                //激活
                                issuccess = false;
                                msg = Utils.GetLanguageNode("//language/node[@name='user']/login/erremailverify");
                            }
                            else
                            {
                                //更新登录信息
                                issuccess = true;
                                CheckUserLogin.UpdateLoginInfo(userName, passWord, LastLoginTime, ExpiresDate);
                            }
                        }
                        else
                        {
                            issuccess = false;
                            msg = Utils.GetLanguageNode("//language/node[@name='user']/login/errpass");

                            #region 记录登录失败
                            if (Utils.StrToInt(MyCache.GetShopCommonConfig(51)) > 0 && Utils.StrToInt(MyCache.GetShopCommonConfig(52)) > 0)
                            {
                                Kesion.APPCode.Public.addUserRecord(userName, 2, msg);
                            }
                            #endregion
                        }
                    }
                }




            }

        Kesion_End_Tag:

            sb.AppendFormat("<success>{0}</success>", issuccess.ToString());
            sb.AppendFormat("<message>{0}</message>", msg);
            sb.Append("</login>");

            WriteXML(sb.ToString());
            #endregion
        }
        #endregion


        #region 商城系统
        /// <summary>
        /// 检查商品ID是否正确
        /// </summary>
        private void CheckProID()
        {
            #region 检查商品ID是否正确
            using (DataTable dt = DataFactory.GetDataTable("select top 1  * From KS_ProductList Where infoid<>" + Utils.StrToInt(KSCMS.S("ID")) + " and ProID='" + Utils.ChkSQL(KSCMS.S("proid")) + "'"))
            {
                if (dt.Rows.Count > 0)
                {
                    KSCMS.Die("true");
                }
                else
                {
                    KSCMS.Die("false");
                }
            }
            #endregion
        }
        /// <summary>
        /// 根据栏目ID加载品牌
        /// </summary>
        private void LoadBrandList()
        {
            #region 根据栏目ID加载品牌
            int classId = Utils.StrToInt(KSCMS.S("classid"));
            int id = Utils.StrToInt(KSCMS.S("brandid"));
            using (DataTable dt = DataFactory.GetDataTable("select a.id,a.brandname from KS_ProBrand a inner join KS_ProBrandR b on a.id=b.brandid where b.classid=" + classId))
            {
                foreach (DataRow dr in dt.Rows)
                {
                    if (id == Utils.StrToInt(dr["id"].ToString()))
                    {
                        KSCMS.W(string.Format(@"<option value='{0}' selected>{1}</option>", dr["id"].ToString(), dr["brandname"].ToString()));
                    }
                    else
                    {
                        KSCMS.W(string.Format(@"<option value='{0}'>{1}</option>", dr["id"].ToString(), dr["brandname"].ToString()));
                    }
                }
            }
            #endregion
        }

        #region 加入购物车
        private void AddCart()
        {
            int id = Utils.StrToInt(KSCMS.S("id"));
            if (id == 0)
            {
                KSCMS.Die("var data={'flag':'error','str':''}");
            }
            else
            {
                string isLogin = CheckUserLogin.Check();
                if (MyCache.GetCacheShopConfig(11) != "1" && isLogin != "success")
                {
                    KSCMS.Die("var data={'flag':'error1','str':''}");
                }
                string userName = string.Empty;
                int IsAnonymous = 0;

                if (CheckUserLogin.Check() != "success")
                {
                    userName = Kesion.APPCode.ShoppingCartUser.UserName;
                    IsAnonymous = 1;
                }
                else
                {
                    userName = (new TemporaryVar()).UserName;
                    IsAnonymous = 0;
                }


                #region 商品加入购物车
                if (id != 0)
                {
                    ShopItem _sinfo = ShopManage.GetShopItemInfo(Utils.StrToInt(KSCMS.S("m"), 4), id);
                    if (_sinfo != null)
                    {

                        string attrids = Utils.FilterIDs(KSCMS.S("attrid"));
                        if (attrids == "0")
                        {
                            int num = Utils.StrToInt(KSCMS.S("num"), 1);
                            int attrid = Utils.StrToInt(KSCMS.S("attrid"));

                            ShoppingCartInfo __info = new ShoppingCartInfo();
                            __info.InfoID = id;
                            __info.Num = num;
                            __info.IsAnonymous = IsAnonymous;
                            __info.IsChangeBuy = 0;
                            __info.userName = userName;
                            __info.AddDate = DateTime.Now;
                            __info.IsBundleSale = Utils.StrToInt(KSCMS.S("IsBundleSale"));
                            __info.IsLimitBuy = _sinfo.IsLimitBuy;
                            __info.LimitBuyTaskID = _sinfo.LimitBuyTaskID;
                            __info.AttrID = attrid;
                            __info.Business = _sinfo.Inputer;
                            int minOrderNum = 0;
                            int maxOrderNum = 0;
                            int result = ShopManage.AddShoppingCart(__info, ref minOrderNum, ref maxOrderNum);

                            if (result == -3 && minOrderNum != 0)
                            {
                                KSCMS.Die("var data={'flag':'errors','str':'" + string.Format(Utils.GetLanguageNode("//language/node[@name='modelview']/shopmodel/shoppingcart/errminnum"), minOrderNum) + "'}");

                            }
                            else if (result == -4 && maxOrderNum != 0)
                            {
                                KSCMS.Die("var data={'flag':'errors','str':'" + string.Format(Utils.GetLanguageNode("//language/node[@name='modelview']/shopmodel/shoppingcart/errmaxnum"), maxOrderNum) + "'}");

                            }
                            #region 捆绑销售套餐
                            if (__info.IsBundleSale == 1 && result > 0)
                            {
                                string bundleIDs = KSCMS.S("BundleIDs");
                                if (!string.IsNullOrEmpty(bundleIDs))
                                {
                                    string[] bundleIDsArr = Utils.FilterIDs(bundleIDs).Split(',');
                                    foreach (string bundleId in bundleIDsArr)
                                    {
                                        ShopManage.ProCartAddBundleSale(Convert.ToInt16(bundleId), result);
                                    }
                                }
                            }
                            #endregion
                        }
                        else
                        {
                            #region 批发模式
                            string[] attridArr = attrids.Split(',');
                            string[] numArr = string.Concat(KSCMS.S("num"), ",,,,,,,,,").Split(',');
                            int n = 0;
                            foreach (string aid in attridArr)
                            {
                                int num = Utils.StrToInt(numArr[n]);
                                if (num > 0)
                                {
                                    ShoppingCartInfo __info = new ShoppingCartInfo();
                                    __info.InfoID = id;
                                    __info.Num = num;
                                    __info.IsAnonymous = IsAnonymous;
                                    __info.IsChangeBuy = 0;
                                    __info.userName = userName;
                                    __info.AddDate = DateTime.Now;
                                    __info.IsBundleSale = Utils.StrToInt(KSCMS.S("IsBundleSale"));
                                    __info.IsLimitBuy = _sinfo.IsLimitBuy;
                                    __info.LimitBuyTaskID = _sinfo.LimitBuyTaskID;
                                    __info.AttrID = Utils.StrToInt(aid); ;
                                    __info.Business = _sinfo.Inputer;
                                    int minOrderNum = 0;
                                    int maxOrderNum = 0;
                                    int result = ShopManage.AddShoppingCart(__info, ref minOrderNum, ref maxOrderNum);

                                    if (result == -3 && minOrderNum != 0)
                                    {
                                        KSCMS.Die("var data={'flag':'errors','str':'" + string.Format(Utils.GetLanguageNode("//language/node[@name='modelview']/shopmodel/shoppingcart/errminnum"), minOrderNum) + "'}");

                                    }
                                    else if (result == -4 && maxOrderNum != 0)
                                    {
                                        KSCMS.Die("var data={'flag':'errors','str':'" + string.Format(Utils.GetLanguageNode("//language/node[@name='modelview']/shopmodel/shoppingcart/errmaxnum"), maxOrderNum) + "'}");

                                    }
                                }
                                n++;
                            }
                            #endregion

                        }


                    }

                }
                #endregion



                StringBuilder sb = new StringBuilder();
                using (DataTable dt = ShopManage.GetProductFromShoppingCart(userName))
                {
                    int totalNum = dt.Rows.Count;
                    if (totalNum > 0)
                    {
                        sb.AppendFormat(@"<form name=""shopform"" method=""post"" action=""{0}""><img src=""/ks_inc/mall/img/suc.gif"" align=""absmiddle"">{1}", Kesion.HtmlTags.BasicField.GetRewriteUrl("orderinfo"), Utils.GetLanguageNode("//language/node[@name='modelview']/shopmodel/shoppingcart/addcartips"));
                        sb.Append(@"<div  style=""width:380px;height:160px;"">");
                        sb.AppendFormat(@"<div style=""FONT-SIZE: 10pt;OVERFLOW-y: auto;overflow-x:hidden; WIDTH: 360px; LINE-HEIGHT: 20px; max-height: 150px"">");

                        sb.AppendFormat(Utils.GetLanguageNode("//language/node[@name='modelview']/shopmodel/shoppingcart/cartips"), totalNum);
                        sb.AppendFormat(@"<table border=""0"" width=""98%"" align=""center"" cellspacing=""0"" cellpadding=""0"" style=""margin-top:10px;"">");
                        int i = 0;
                        decimal price = 0;
                        foreach (DataRow dr in dt.Rows)
                        {
                            i++;
                            sb.AppendFormat(@"<tr><td style=""line-height:24px; border-bottom:#f1f1f1 1px solid; class=""carttitle""><input type=""checkbox"" name=""cartid"" value=""{0}"" checked/>{1}、{2}</td>", dr["cartid"].ToString(), i, dr["title"].ToString());
                            if (Utils.StrToInt(dr["IsLimitBuy"].ToString()) != 0)
                            {
                                price = Utils.StrToDecimal(dr["LimitBuyPrice"].ToString());  //抢购价
                            }
                            else
                            {
                                price = Kesion.APPCode.ShoppingCartUser.getPrice(dr);
                            }
                            sb.AppendFormat(@"<td width=""80"" style=""line-height:24px;  font-weight:bold; border-bottom:#f1f1f1 1px solid; "" class=""cartprice"">{0}×{1}</td></tr>", MyCache.GetCurrencySymbol + Kesion.APPCode.Public.ReturnShopPrice(price), dr["num"].ToString());

                            #region 商品属性
                            string attribute = string.Empty;
                            if (!string.IsNullOrEmpty(dr["attributecart"].ToString()))
                            {
                                using (DataTable dtattr = DataFactory.GetDataTable("select top 1 * From KS_ProSpecificationPrice Where ID=" + dr["attrid"].ToString()))
                                {
                                    if (dtattr.Rows.Count > 0)
                                    {
                                        DataRow attrow = dtattr.Rows[0];
                                        string[] attrArr = dr["attributecart"].ToString().Split(',');
                                        for (int ii = 1; ii <= attrArr.Length; ii++)
                                        {
                                            if (!string.IsNullOrEmpty(attrow["attr" + ii.ToString()].ToString().Split('|')[0]))
                                            {
                                                if (string.IsNullOrEmpty(attribute))
                                                {
                                                    attribute = string.Format(@"<span class=""tname"">{0}</span>：{1}", attrArr[ii - 1], attrow["attr" + ii.ToString()].ToString().Split('|')[0]);
                                                }
                                                else
                                                {
                                                    attribute += "&nbsp;&nbsp;" + string.Format(@"<span class=""tname"">{0}</span>：{1}", attrArr[ii - 1], attrow["attr" + ii.ToString()].ToString().Split('|')[0]);

                                                }
                                            }
                                        }

                                    }
                                }
                                sb.AppendFormat(@"<tr><td colspan=""2"" style=""text-align:left;color:#999;"">{0}</td></tr>", attribute);


                            }
                            #endregion


                        }
                        sb.AppendFormat("</table>");
                        sb.Append("</div>");
                        sb.Append("</div>");
                        sb.AppendFormat(@"<div class=""jrgwc""><input onclick=""return(shop.checkToPay())"" type=""image"" src=""/ks_inc/mall/img/hesuan.gif""/> <a href=""{0}""><img src=""/ks_inc/mall/img/chakangouwuche.gif""></a></form></div>", Kesion.HtmlTags.BasicField.GetRewriteUrl("shoppingcart"));
                    }
                }
                int cartnum = Utils.StrToInt(DataFactory.GetOnlyValue("select count(1) From KS_ProShoppingCart Where flag=0 and UserName='" + Kesion.APPCode.ShoppingCartUser.UserName + "'"));

                KSCMS.Die(string.Format(@"var data={{'flag':'ok','cartnum':'{1}','str':'{0}'}}", sb.ToString(), cartnum.ToString()));

            }

        }
        #endregion

        #region 商城组图
        private void LoadProImages()
        {
            int ProID = Utils.StrToInt(KSCMS.S("ProID"));
            string GroupName = Utils.RemoveXss(KSCMS.S("GroupName"));
            int RowNum = 5;
            StringBuilder sb = new StringBuilder();
            DataTable dt = DataFactory.GetDataTable("select top 100 ID,InfoID,PhotoUrl,BigPhoto from [KS_ProImages] where infoId=" + ProID + " and intro='" + GroupName + "'");
            if (dt.Rows.Count > 0)
            {
                for (int i = 0; i < dt.Rows.Count; i++)
                {
                    DataRow dr = dt.Rows[i];
                    sb.Append(string.Format(@"<span onmouseover=""ShowPhoto('{0}','{1}');this.className='CurrSmallPic';"" onmouseout=""SetMouseOutPhoto();{3}"" onclick=""SetDefaultPhoto(this,'{0}','{1}')"" class=""{2}""><img width=""45"" height=""56"" style=""cursor:pointer""  src=""{0}"" border=""0""></span>", dr[2].ToString(), dr[3].ToString(), i == 0 ? "CurrSmallPic" : "DefaultSmallPic", dt.Rows.Count != 1 ? "if(currobj!=this){this.className='DefaultSmallPic';}" : ""));
                    if ((i + 1) % RowNum == 0) sb.Append(@"<div style=""height:5px;overflow:hidden""></div>");
                }

            }
            KSCMS.W(string.Format(@"var data={{""groupname"":'{0}',""str"":""{1}""}}", GroupName, sb.ToString().Replace(@"""", @"\""")));
        }
        #endregion

        #region 取得内容页价格
        private void GetProPrice()
        {
            string str = string.Empty;
            int isLimitBuy = 0;
            int Amount = 0;
            int modelId = Utils.StrToInt(KSCMS.S("modelid"), 4);
            int ProID = Utils.StrToInt(KSCMS.S("ProID"));
            if (!BaseFun.CheckTableExists(MyCache.GetCacheModel(modelId, 3))) return;

            decimal dis = 1; //会员组折扣
            using (DataTable dt = DataFactory.GetDataTable("select top 1 GroupPrice,IsGroupRate,Price,Price_Member,IsLimitbuy,LimitBuyTaskID,LimitBuyAmount,LimitBuyPrice,IsScoreChange,ChangeScore,AttributeCart,Amount From [" + MyCache.GetCacheModel(modelId, 3) + "] WHERE infoID=" + ProID))
            {
                if (dt.Rows.Count > 0)
                {
                    #region 判断价格
                    DataRow dr = dt.Rows[0];
                    int promotionType = Utils.StrToInt(dr["groupPrice"].ToString());   //商品促销 0普通商品 1限时 2限购 3积分兑换 4暂时没用 5换购 6竞价 
                    decimal price = Utils.StrToDecimal(dr["Price_Member"].ToString());  //一口价
                    isLimitBuy = Utils.StrToInt(dr["IsLimitBuy"].ToString());
                    Amount = Utils.StrToInt(dr["Amount"].ToString());

                    #region 是否启用用户组折扣
                    int isGroupRate = Utils.StrToInt(dr["IsGroupRate"].ToString());  //是否启用用户组折扣 0不启用 1按用户组折扣率计算 2详细设置用户组价格


                    if (isGroupRate >= 1 && promotionType <= 2) //普通商品、限时及限量才判断按会员组折扣
                    {
                        if (CheckUserLogin.Check() != "success")
                        {
                            str = Utils.GetLanguageNode("//language/node[@name='modelview']/shopmodel/dynamicprice/nologin").Replace(@"""", @"\""");
                            goto addEnd;
                        }
                    }

                    if (isGroupRate == 1 && promotionType <= 2) //普通商品、限时及限量才判断按会员组折扣
                    {
                        string discount = UserGroupManage.GetGroupSettings(7);
                        if (Utils.IsNumeric(discount) && Utils.StrToFloat(discount) > 0)
                        {
                            dis = Utils.StrToDecimal(discount) / 10;
                        }
                    }
                    #endregion



                    if (!string.IsNullOrEmpty(dr["AttributeCart"].ToString()))
                    {
                        #region 启用规格
                        using (DataTable dtt = DataFactory.GetDataTable("Select Max(price) as maxPrice,min(price) as minPrice From [KS_ProSpecificationPrice] Where ProID=" + ProID))
                        {
                            if (dtt.Rows.Count > 0)
                            {
                                decimal minPrice = Utils.StrToDecimal(dtt.Rows[0]["minPrice"].ToString());
                                decimal maxPrice = Utils.StrToDecimal(dtt.Rows[0]["maxPrice"].ToString());
                                if (isGroupRate == 1)  //按用户组折扣
                                {
                                    minPrice = minPrice * dis;
                                    maxPrice = maxPrice * dis;
                                }
                                ;
                                if (minPrice != maxPrice)
                                {
                                    str = string.Format(@"{0}~{1}", MyCache.GetCurrencySymbol + Kesion.APPCode.Public.ReturnShopPrice(minPrice) + MyCache.GetCurrencyUnit, MyCache.GetCurrencySymbol + Kesion.APPCode.Public.ReturnShopPrice(maxPrice) + MyCache.GetCurrencyUnit);
                                }
                                else
                                {
                                    str = string.Format(@"{0}", MyCache.GetCurrencySymbol + Kesion.APPCode.Public.ReturnShopPrice(minPrice) + MyCache.GetCurrencyUnit);
                                }
                            }
                            else
                            {
                                str = MyCache.GetCurrencySymbol + Kesion.APPCode.Public.ReturnShopPrice(Utils.StrToDecimal(dr["Price_Member"].ToString()) * dis) + MyCache.GetCurrencyUnit;
                            }

                        }
                        Amount = Utils.StrToInt(DataFactory.GetOnlyValue("Select sum(amount) From [KS_ProSpecificationPrice] Where ProID=" + ProID));
                        #endregion
                    }
                    else
                    {
                        decimal MyPrice = Utils.StrToDecimal(dr["Price_Member"].ToString());
                        if (promotionType == 1 || promotionType == 2) //抢购
                        {
                            MyPrice = Utils.StrToDecimal(dr["LimitBuyPrice"].ToString());
                            Amount = Utils.StrToInt(dr["LimitBuyAmount"].ToString());
                        }

                        if (promotionType == 3)
                        {
                            #region 积分兑换
                            if (MyPrice > 0)
                            {
                                str = MyCache.GetCurrencySymbol + Kesion.APPCode.Public.ReturnShopPrice(MyPrice) + MyCache.GetCurrencyUnit + "+";
                            }
                            str += dr["ChangeScore"].ToString() + "分";
                            #endregion
                        }
                        else
                        {
                            if (isGroupRate == 1)
                            {
                                MyPrice = Utils.StrToDecimal(dr["Price_Member"].ToString()) * dis;
                            }
                            else if (isGroupRate == 2 && MyCache.GetUserGroupInfo(new TemporaryVar().GroupID, "isgroupprice").Equals("1"))
                            {
                                MyPrice = Utils.StrToDecimal(DataFactory.GetOnlyValue("select top 1 Price From KS_ProGroupPrice Where InfoID=" + ProID + " and groupid=" + new TemporaryVar().GroupID));
                            }
                            if (MyPrice == 0)
                            {
                                MyPrice = Utils.StrToDecimal(dr["Price_Member"].ToString());
                            }
                            str = string.Format(@"{0}", MyCache.GetCurrencySymbol + Kesion.APPCode.Public.ReturnShopPrice(MyPrice) + MyCache.GetCurrencyUnit);
                        }

                    }



                    #endregion
                }
            }
        addEnd:
            KSCMS.W(string.Format(@"var DynamicPrice={{""str"":""{0}"",""isLimitBuy"":""{1}"",""Amount"":""{2}"",discount:""{3}""}}", str, isLimitBuy, Amount, dis.ToString()));

        }
        #endregion

        /// <summary>
        /// 动态显示内容页的购物车信息
        /// </summary>
        private void GetCartInfo()
        {
            #region 动态显示内容页的购物车信息
            int ismobile = Utils.StrToInt(KSCMS.S("ismobile"));
            int proId = Utils.StrToInt(KSCMS.S("proid"));
            string templateDir = string.Empty;
            if (ismobile == 1)
            {
                templateDir = MyCache.GetTemplateDir(1);
            }
            else
            {
                templateDir = MyCache.GetTemplateDir();
            }
            if (proId == 0)
            {
                KSCMS.Die("");
            }
            else
            {
                UserInfo __info = null;
                using (DataTable dt = DataFactory.GetDataTable("select top 1 * From KS_ProductList Where InfoID=" + proId))
                {
                    if (dt.Rows.Count > 0)
                    {
                        DataRow dr = dt.Rows[0];
                        int IsLimitBuy = Utils.StrToInt(dr["IsLimitBuy"].ToString());
                        int IsBookCode = Utils.StrToInt(dr["IsBookCode"].ToString());
                        int BookCodeTypeID = Utils.StrToInt(dr["BookCodeTypeID"].ToString());
                        int LimitCityNum = Utils.StrToInt(dr["LimitCityNum"].ToString());
                        string tp = string.Empty;
                        DateTime beginDate = Utils.StrToDateTime(dr["LimitBeginDate"].ToString());
                        DateTime endDate = Utils.StrToDateTime(dr["LimitEndDate"].ToString());
                        string unit = dr["unit"].ToString();
                        if (string.IsNullOrEmpty(unit)) unit = "件";
                        var LimitBuyAmount = Utils.StrToInt(dr["LimitBuyAmount"].ToString());
                        if (IsLimitBuy == 2)
                        {
                            KSCMS.Die("limitnum:2:" + LimitBuyAmount);  //限量抢购,显示剩余量。
                        }

                        if (IsLimitBuy == 1)
                        {
                            #region 启用时间限制
                            TimeSpan ts = DateTime.Now.Subtract(beginDate);
                            TimeSpan ts1 = DateTime.Now.Subtract(endDate);
                            if (ts.TotalSeconds < 0)
                            {
                                #region 等待开放购买
                                tp = Kesion.XML.XmlObject.ReadXmlReturnNode(Utils.GetMapPath(templateDir + "/config/proviewcartinfo.config"), "//labeltemplate/label[@name='waitbuy']");
                                tp = tp.Replace("{$begindate}", DateTime.Now.ToString());
                                tp = tp.Replace("{$enddate}", beginDate.ToString());
                                if (BookCodeTypeID > 0 && IsBookCode == 1)
                                {
                                    tp = tp.Replace("[applybookcode]", string.Empty).Replace("[/applybookcode]", string.Empty);
                                    tp = tp.Replace("{$bookcodetypeid}", BookCodeTypeID.ToString());
                                    tp = tp.Replace("{$bookcodeappurl}", Kesion.HtmlTags.BasicField.GetRewriteUrl("bookcodeapply", BookCodeTypeID));

                                }
                                else
                                {
                                    tp = tp.Replace(Utils.CutHttpString(tp, "[applybookcode]", "[/applybookcode]", true), string.Empty);
                                }
                                tp = tp.Replace("{$proid}", proId.ToString());
                                tp = tp.Replace("{$limitnum}", LimitBuyAmount.ToString());
                                KSCMS.Die(tp);
                                #endregion
                            }
                            else if (ts1.TotalSeconds < 0)
                            {
                                #region 开放购买
                                KSCMS.Die("limitnum:1:" + LimitBuyAmount);  //限时抢购,显示剩余量。
                                #endregion
                            }
                            else
                            {
                                #region 结束购买
                                tp = Kesion.XML.XmlObject.ReadXmlReturnNode(Utils.GetMapPath(templateDir + "/config/proviewcartinfo.config"), "//labeltemplate/label[@name='endbuy']");
                                tp = tp.Replace("{$begindate}", beginDate.ToString());
                                tp = tp.Replace("{$enddate}", endDate.ToString());
                                KSCMS.Die(tp);
                                #endregion
                            }

                            #endregion
                        }

                        if (LimitCityNum != 0)
                        {
                            #region 城市限购件数
                            if (string.IsNullOrEmpty(new TemporaryVar().UserName))
                            {
                                #region 未登录
                                tp = Kesion.XML.XmlObject.ReadXmlReturnNode(Utils.GetMapPath(templateDir + "/config/proviewcartinfo.config"), "//labeltemplate/label[@name='beginbuy']/item[@name='nologin']");
                                #endregion
                            }
                            else
                            {
                                __info = UserManage.GetUserInfo();
                                if (__info == null)
                                {
                                    #region 未登录
                                    tp = Kesion.XML.XmlObject.ReadXmlReturnNode(Utils.GetMapPath(templateDir + "/config/proviewcartinfo.config"), "//labeltemplate/label[@name='beginbuy']/item[@name='nologin']");
                                    #endregion

                                }
                                else
                                {
                                    int cityId = __info.CityID;
                                    int soldOutNum = Utils.StrToInt(DataFactory.GetOnlyValue("select count(1) From KS_ProOrderItem Where CityID=" + cityId + " and infoId=" + proId));
                                    if (soldOutNum >= LimitCityNum)
                                    {
                                        if (DataFactory.Exists("KS_ProOrderItem a inner join KS_ProOrder b On A.OrderID=b.OrderID", "b.username='" + __info.UserName + "' and InfoID=" + proId))
                                        {
                                            tp = Kesion.XML.XmlObject.ReadXmlReturnNode(Utils.GetMapPath(templateDir + "/config/proviewcartinfo.config"), "//labeltemplate/label[@name='beginbuy']/item[@name='hasbuy']");
                                        }
                                        else
                                        {
                                            tp = Kesion.XML.XmlObject.ReadXmlReturnNode(Utils.GetMapPath(templateDir + "/config/proviewcartinfo.config"), "//labeltemplate/label[@name='beginbuy']/item[@name='hasloginsoldout']");
                                        }
                                    }
                                    else if (Utils.StrToInt(dr["MaxOrderNum"].ToString()) == 1 && DataFactory.Exists("KS_ProOrderItem a inner join KS_ProOrder b On A.OrderID=b.OrderID", "b.username='" + __info.UserName + "' and InfoID=" + proId))
                                    {
                                        tp = Kesion.XML.XmlObject.ReadXmlReturnNode(Utils.GetMapPath(templateDir + "/config/proviewcartinfo.config"), "//labeltemplate/label[@name='beginbuy']/item[@name='hasbuy']");

                                    }
                                    else if (IsBookCode == 1 && BookCodeTypeID != 0)
                                    {
                                        tp = Kesion.XML.XmlObject.ReadXmlReturnNode(Utils.GetMapPath(templateDir + "/config/proviewcartinfo.config"), "//labeltemplate/label[@name='beginbuy']/item[@name='haslogininputbookcode']");
                                    }
                                    else if (IsLimitBuy == 1)
                                    {
                                        tp = Kesion.XML.XmlObject.ReadXmlReturnNode(Utils.GetMapPath(templateDir + "/config/proviewcartinfo.config"), "//labeltemplate/label[@name='beginbuy']/item[@name='nolimitcitynum']");

                                    }
                                    else
                                    {
                                        tp = Kesion.XML.XmlObject.ReadXmlReturnNode(Utils.GetMapPath(templateDir + "/config/proviewcartinfo.config"), "//labeltemplate/label[@name='beginbuy']/item[@name='nolimit']");
                                    }

                                    if (__info.CityID == 0)
                                    {
                                        tp = Kesion.XML.XmlObject.ReadXmlReturnNode(Utils.GetMapPath(templateDir + "/config/proviewcartinfo.config"), "//labeltemplate/label[@name='beginbuy']/item[@name='hasloginnotsetcity']");

                                    }
                                    else
                                    {
                                        tp = tp.Replace("{$city}", string.Format(@"<input type=""hidden"" name=""cityid"" id=""cityid"" value=""{0}""/>{1}", __info.CityID, MyCache.GetAreaName(__info.CityID, "city")));
                                    }
                                    tp = tp.Replace("{$userid}", __info.UserID.ToString());
                                    tp = tp.Replace("{$username}", __info.UserName);
                                    tp = tp.Replace("{$soldoutnum}", soldOutNum.ToString());
                                    tp = tp.Replace("{$setaddressurl}", Kesion.HtmlTags.BasicField.GetUserUrl("basic/editinfo"));

                                }

                            }

                            #endregion
                        }
                        else if (IsBookCode == 1 && BookCodeTypeID != 0)
                        {

                            #region 需要预约码
                            using (DataTable dty = DataFactory.GetDataTable("select top 1 ApplyMustLogin From KS_ProBookCodeType Where [TypeID]=" + BookCodeTypeID))
                            {
                                if (dty.Rows.Count > 0)
                                {
                                    var haslogin = false;
                                    DataRow dry = dty.Rows[0];
                                    if (dry["ApplyMustLogin"].ToString() == "1")  //必须会员登录
                                    {
                                        #region 必须会员登录
                                        if (string.IsNullOrEmpty(new TemporaryVar().UserName))
                                        {
                                            #region 未登录
                                            tp = Kesion.XML.XmlObject.ReadXmlReturnNode(Utils.GetMapPath(templateDir + "/config/proviewcartinfo.config"), "//labeltemplate/label[@name='beginbuy']/item[@name='nologinnocitylimit']");
                                            #endregion

                                        }
                                        else
                                        {
                                            __info = UserManage.GetUserInfo();
                                            if (__info == null)
                                            {
                                                #region 未登录
                                                tp = Kesion.XML.XmlObject.ReadXmlReturnNode(Utils.GetMapPath(templateDir + "/config/proviewcartinfo.config"), "//labeltemplate/label[@name='beginbuy']/item[@name='nologinnocitylimit']");
                                                #endregion

                                            }
                                            else
                                            {
                                                haslogin = true;
                                            }
                                        }
                                        #endregion

                                    }
                                    else
                                    {
                                        haslogin = true;
                                    }
                                    if (haslogin)
                                    {

                                        #region 要求输入预约码
                                        tp = Kesion.XML.XmlObject.ReadXmlReturnNode(Utils.GetMapPath(templateDir + "/config/proviewcartinfo.config"), "//labeltemplate/label[@name='beginbuy']/item[@name='nocitylimitinputcode']");
                                        #endregion
                                    }

                                }
                                else
                                {
                                    KSCMS.Die("");
                                }
                            }
                            #endregion

                        }
                        else
                        {

                            tp = Kesion.XML.XmlObject.ReadXmlReturnNode(Utils.GetMapPath(templateDir + "/config/proviewcartinfo.config"), "//labeltemplate/label[@name='beginbuy']/item[@name='nolimit']");
                        }

                        if (tp.IndexOf("[nobookcode]") != -1)
                        {
                            string bookCode = string.Empty;
                            if (__info != null)
                            {
                                using (DataTable dtc = DataFactory.GetDataTable("select top 1 codeid From KS_ProBookCode Where isUsed=0 and TypeID=" + BookCodeTypeID + " and UserName='" + __info.UserName + "' and cityId=" + __info.CityID))
                                {
                                    if (dtc.Rows.Count > 0)
                                    {
                                        bookCode = dtc.Rows[0]["codeid"].ToString();
                                    }
                                }
                            }

                            if (string.IsNullOrEmpty(bookCode))  //找不到预约码，让其录入
                            {
                                tp = Kesion.XML.XmlObject.ReadXmlReturnNode(Utils.GetMapPath(templateDir + "/config/proviewcartinfo.config"), "//labeltemplate/label[@name='beginbuy']/item[@name='nocitylimitinputcode']");
                            }


                            if (!string.IsNullOrEmpty(bookCode))
                            {
                                tp = tp.Replace(Utils.CutHttpString(tp, "[nobookcode]", "[/nobookcode]", true), string.Empty);
                                tp = tp.Replace("[hasbookcode]", string.Empty).Replace("[/hasbookcode]", string.Empty);
                                tp = tp.Replace("{$codeid}", bookCode);
                            }
                            else if (tp.IndexOf("[hasbookcode]") != -1)
                            {
                                tp = tp.Replace(Utils.CutHttpString(tp, "[hasbookcode]", "[/hasbookcode]", true), string.Empty);
                                tp = tp.Replace("[nobookcode]", string.Empty).Replace("[/nobookcode]", string.Empty);


                            }
                        }

                        if (!string.IsNullOrEmpty(tp))
                        {
                            if (IsLimitBuy == 1)
                            {
                                tp = tp.Replace("[limittime]", string.Empty).Replace("[/limittime]", string.Empty);
                            }
                            else if (tp.IndexOf("[limittime]") != -1)
                            {
                                tp = tp.Replace(Utils.CutHttpString(tp, "[limittime]", "[/limittime]", true), string.Empty);
                            }


                            tp = tp.Replace("{$begindate}", beginDate.ToString());
                            tp = tp.Replace("{$enddate}", endDate.ToString());
                            tp = tp.Replace("{$limitcitynum}", LimitCityNum.ToString());
                            tp = tp.Replace("{$unit}", unit);
                        }
                        KSCMS.Die(tp);



                    }

                }
            }
            #endregion

        }

        private void delFromCart()
        {
            int cartId = Utils.StrToInt(KSCMS.S("cartid"));
            if (cartId == 0) return;
            Hashtable ht = new Hashtable();
            ht.Add("username", BaseFun.getUser());
            ht.Add("cartid", cartId);
            CommonData.Delete("KS_ProShoppingCart", ht);
            new Kesion.APPCode.ShoppingCartUser().checkAndDelChangeBuyPro();
            ht.Clear();
            ht.Add("cartid", cartId);
            CommonData.Delete("KS_ProBundleSelect", ht);
            KSCMS.Die("success");
        }
        private void setBuyNum()
        {
            #region 改变购物车内商品数量
            int num = Utils.StrToInt(KSCMS.S("num"));
            int cartId = Utils.StrToInt(KSCMS.S("cartId"));
            int proId = Utils.StrToInt(KSCMS.S("proid"));
            if (num == 0 || cartId == 0 || proId == 0)
            {
                KSCMS.Die(@"var data={""issuccess"":'false'}");
            }
            else
            {
                using (DataTable dt = DataFactory.GetDataTable("select top 1 I.amount,I.MinOrderNum,I.MaxOrderNum,I.LimitBuyAmount,C.IsLimitBuy,C.AttrID,I.IsScoreChange,I.ChangeScore,limitBuyNum,limitBuyType from [KS_ProductList] I INNER JOIN [KS_ProShoppingCart] C ON I.InfoID=C.InfoID Where C.flag=0 and c.cartID=" + cartId))
                {
                    if (dt.Rows.Count <= 0)
                    {
                        KSCMS.Die(@"var data={""issuccess"":'false'}");
                    }
                    else
                    {

                        //判断限购
                        #region 判断限制购买
                        string userName = string.Empty;
                        if (CheckUserLogin.Check() != "success")
                        {
                            userName = Kesion.APPCode.ShoppingCartUser.UserName;
                        }
                        else
                        {
                            userName = (new TemporaryVar()).UserName;
                        }
                        int limitBuyNum = Utils.StrToInt(dt.Rows[0]["limitBuyNum"].ToString());
                        int limitBuyType = Utils.StrToInt(dt.Rows[0]["limitBuyType"].ToString());
                        if (limitBuyNum > 0)
                        {
                            string LimitTips = string.Empty;
                            string sqlParam = " KS_ProOrder o Inner Join KS_ProOrderItem i On o.orderid=i.orderid  where o.username='" + userName + "'";
                            switch (limitBuyType)
                            {
                                case 0:
                                    sqlParam += " and Year(InputTime)=" + DateTime.Now.Year + " and Month(InputTime)=" + DateTime.Now.Month + " and Day(InputTime)=" + DateTime.Now.Day;
                                    LimitTips = "每天";
                                    break;
                                case 1:
                                    sqlParam += " and Year(InputTime)=" + DateTime.Now.Year + " and Month(InputTime)=" + DateTime.Now.Month;
                                    LimitTips = "每月";
                                    break;
                                case 2:
                                    sqlParam += " and datediff(month,InputTime,getdate())<=3";
                                    LimitTips = "三个月内";
                                    break;
                                case 3:
                                    sqlParam += " and datediff(month,InputTime,getdate())<=6";
                                    LimitTips = "半年内";
                                    break;
                                case 4:
                                    sqlParam += " and datediff(yy,InputTime,GETDATE())<=1";
                                    LimitTips = "一年内";
                                    break;

                            }
                            int hasBuyNum = Utils.StrToInt(DataFactory.GetOnlyValue("select sum(num) From " + sqlParam));
                            if (hasBuyNum >= limitBuyNum || (num + hasBuyNum) > limitBuyNum)
                            {
                                KSCMS.Die(@"var data={""issuccess"":'failmaxnum',""amount"":'" + limitBuyNum + "'}");

                            }
                        }
                        #endregion



                        int MinOrderNum = int.Parse(dt.Rows[0]["MinOrderNum"].ToString());
                        int MaxOrderNum = int.Parse(dt.Rows[0]["MaxOrderNum"].ToString());
                        int ProNum = 0;
                        int attrId = Utils.StrToInt(dt.Rows[0]["AttrID"].ToString());
                        if (attrId > 0)
                        {
                            if (MyCache.GetShopCommonConfig(103) == "1")  //有启用仓库
                            {
                                using (DataTable dtt = DataFactory.GetDataTable("select top 1 Amount From KS_ProAmount Where ProID=" + proId + " and AttrID=" + attrId + " order by Amount Desc"))
                                {
                                    if (dtt.Rows.Count > 0)
                                    {
                                        ProNum = Utils.StrToInt(dtt.Rows[0][0].ToString());
                                    }
                                    else
                                    {
                                        ProNum = Utils.StrToInt(DataFactory.GetOnlyValue("select top 1 amount from KS_ProSpecificationPrice Where ID=" + attrId));
                                    }
                                }

                            }
                            else
                            {
                                ProNum = Utils.StrToInt(DataFactory.GetOnlyValue("select top 1 amount from KS_ProSpecificationPrice Where ID=" + attrId));
                            }
                        }
                        else if (Utils.StrToInt(dt.Rows[0]["IsLimitBuy"].ToString()) != 0)
                        {
                            ProNum = int.Parse(dt.Rows[0]["LimitBuyAmount"].ToString());
                        }
                        else
                        {
                            if (MyCache.GetShopCommonConfig(103) == "1")  //有启用仓库
                            {
                                using (DataTable dtt = DataFactory.GetDataTable("select top 1 Amount From KS_ProAmount Where ProID=" + proId + " and AttrID=0 order by Amount Desc"))
                                {
                                    if (dtt.Rows.Count > 0)
                                    {
                                        ProNum = Utils.StrToInt(dtt.Rows[0][0].ToString());
                                    }
                                    else
                                    {
                                        ProNum = int.Parse(dt.Rows[0]["Amount"].ToString());
                                    }
                                }
                            }
                            else
                            {

                                ProNum = int.Parse(dt.Rows[0]["Amount"].ToString());
                            }
                        }

                        if (num > ProNum || (MaxOrderNum != 0 && num > MaxOrderNum))
                        {
                            if (num > ProNum)
                                KSCMS.Die(@"var data={""issuccess"":'failnum',""amount"":'" + ProNum + "'}");
                            else
                                KSCMS.Die(@"var data={""issuccess"":'failmaxnum',""amount"":'" + MaxOrderNum + "'}");

                        }
                        else if (MinOrderNum != 0 && num < MinOrderNum)
                        {
                            KSCMS.Die(@"var data={""issuccess"":'failminnum',""amount"":'" + MinOrderNum + "'}");
                        }
                        else
                        {
                            Hashtable ht = new Hashtable();
                            ht.Add("num", num);
                            CommonData.Update("KS_ProShoppingCart", ht, "where cartid=" + cartId);
                            if (Kesion.APPCode.ShoppingCartUser.getOrderTotalPriceByNoneChangeBuy < new Kesion.APPCode.ShoppingCartUser().getChangeBuyNeedPrice && new Kesion.APPCode.ShoppingCartUser().getChangeBuyNeedPrice != 0)
                            {
                                new Kesion.APPCode.ShoppingCartUser().checkAndDelChangeBuyPro();
                                KSCMS.Die(@"var data={""issuccess"":'reload'}");
                            }
                            else
                            {
                                KSCMS.Die(@"var data={""issuccess"":'true'}");
                            }
                        }
                    }
                }

            }
            #endregion
        }
        private void setGroupBuyNum()
        {
            #region 改变团购购物车内商品数量
            int num = Utils.StrToInt(KSCMS.S("num"));
            int cartId = Utils.StrToInt(KSCMS.S("cartId"));
            int proId = Utils.StrToInt(KSCMS.S("proid"));
            if (num == 0 || cartId == 0 || proId == 0)
            {
                KSCMS.Die(@"var data={""issuccess"":'false'}");
            }
            else
            {
                using (DataTable dt = DataFactory.GetDataTable("select top 1 LimitBuyNum,Amount from [KS_ProGroupBuy] Where ID=" + proId))
                {
                    if (dt.Rows.Count <= 0)
                    {
                        KSCMS.Die(@"var data={""issuccess"":'false'}");
                    }
                    else
                    {
                        DataRow dr = dt.Rows[0];
                        int ProNum = Utils.StrToInt(dr["LimitBuyNum"].ToString());
                        int Amount = Utils.StrToInt(dr["Amount"].ToString());
                        if (ProNum > 0 && num > ProNum)
                        {
                            KSCMS.Die(@"var data={""issuccess"":'failmaxnum',""amount"":'" + ProNum + "'}");
                        }
                        else if (Amount > 0 && num > Amount)
                        {
                            KSCMS.Die(@"var data={""issuccess"":'failamount',""amount"":'" + Amount + "'}");
                        }
                        else
                        {
                            Hashtable ht = new Hashtable();
                            ht.Add("num", num);
                            CommonData.Update("KS_ProShoppingCart", ht, "where cartid=" + cartId);
                            KSCMS.Die(@"var data={""issuccess"":'true'}");
                        }
                    }
                }

            }
            #endregion
        }
        private void saveCartIds()
        {
            #region 保存购物车准备付款的ID
            if (Utils.StrToInt(KSCMS.S("flag")) == 1 && HttpContext.Current.Session["CartIds"] != null)
            {
                KSCMS.Die(HttpContext.Current.Session["CartIds"].ToString());
            }
            else
            {
                HttpContext.Current.Session["CartIds"] = Utils.FilterIDs(KSCMS.S("cartIds"));
                #region 检查换购条件是否满足
                using (DataTable dt = DataFactory.GetDataTable("select top 1 a.cartid,a.infoId,a.IsChangeBuy,a.num,ChangeBuyNeedPrice,ChangeBuyPresentPrice,b.title,b.LimitBuyType,b.LimitBuyNum From KS_ProShoppingCart a inner Join KS_ProductList b on a.infoid=b.infoid Where a.username='" + BaseFun.getUser() + "' and a.cartid in(" + Utils.FilterIDs(KSCMS.S("cartIds")) + ")"))
                {
                    if (dt.Rows.Count > 0)
                    {
                        foreach (DataRow dr in dt.Rows)
                        {
                            if (dr["IsChangeBuy"].ToString() == "1")
                            {
                                #region 检查换购品是否符合条件
                                float ChangeBuyNeedPrice = Utils.StrToFloat(dr["ChangeBuyNeedPrice"].ToString());
                                float ChangeBuyPresentPrice = Utils.StrToFloat(dr["ChangeBuyPresentPrice"].ToString());
                                float totalPayMoney = Utils.StrToFloat(KSCMS.S("totalPayMoney"));
                                totalPayMoney = totalPayMoney - ChangeBuyPresentPrice;  //减去换购价格
                                if (totalPayMoney < ChangeBuyNeedPrice)
                                {
                                    DataFactory.ExecuteNonQuery("Delete From KS_ProShoppingcart Where cartid=" + dr["cartid"].ToString());
                                    KSCMS.Die("errorchangebuy");
                                }
                                #endregion
                            }
                            else if (Utils.StrToInt(dr["LimitBuyNum"].ToString()) > 0)
                            {
                                #region 判断限购
                                int limitBuyType = Utils.StrToInt(dr["LimitBuyType"].ToString());
                                int limitBuyNum = Utils.StrToInt(dr["LimitBuyNum"].ToString());

                                string LimitTips = string.Empty;
                                int num = Utils.StrToInt(dr["num"].ToString());
                                string sqlParam = " KS_ProOrder o Inner Join KS_ProOrderItem i On o.orderid=i.orderid  where o.username='" + Kesion.APPCode.ShoppingCartUser.UserName + "'";
                                switch (limitBuyType)
                                {
                                    case 0:
                                        sqlParam += " and Year(InputTime)=" + DateTime.Now.Year + " and Month(InputTime)=" + DateTime.Now.Month + " and Day(InputTime)=" + DateTime.Now.Day;
                                        LimitTips = "每天";
                                        break;
                                    case 1:
                                        sqlParam += " and Year(InputTime)=" + DateTime.Now.Year + " and Month(InputTime)=" + DateTime.Now.Month;
                                        LimitTips = "每月";
                                        break;
                                    case 2:
                                        sqlParam += " and datediff(month,InputTime,getdate())<=3";
                                        LimitTips = "三个月内";
                                        break;
                                    case 3:
                                        sqlParam += " and datediff(month,InputTime,getdate())<=6";
                                        LimitTips = "半年内";
                                        break;
                                    case 4:
                                        sqlParam += " and datediff(yy,InputTime,GETDATE())<=1";
                                        LimitTips = "一年内";
                                        break;

                                }
                                int hasBuyNum = Utils.StrToInt(DataFactory.GetOnlyValue("select sum(num) From " + sqlParam));
                                if (hasBuyNum >= limitBuyNum || (num + hasBuyNum) > limitBuyNum)
                                {

                                    string removeCartID = dr["cartid"].ToString();
                                    if (HttpContext.Current.Session["CartIds"] != null)
                                    {
                                        HttpContext.Current.Session["CartIds"] = Utils.RemoveItemInfArray(HttpContext.Current.Session["CartIds"].ToString(), removeCartID, ",");
                                    }

                                    KSCMS.Die("errorlimitbuy|" + string.Format(Utils.GetLanguageNode("//language/node[@name='modelview']/shopmodel/shoppingcart/errlimitbuynum"), dr["Title"].ToString(), LimitTips, limitBuyNum));

                                }

                                #endregion

                            }



                        }



                    }

                }

                #endregion
                KSCMS.Die("0");
            }
            #endregion
        }
        private void addChangeBuyToCart()
        {
            #region 换购商品加入购物车
            int proId = Utils.StrToInt(KSCMS.S("proid"));
            if (proId == 0) return;
            string userName = Kesion.APPCode.ShoppingCartUser.UserName;
            Hashtable ht = new Hashtable();
            ht.Add("username", Utils.ChkSQL(userName));
            ht.Add("ischangebuy", 1);
            CommonData.Delete("[KS_ProShoppingCart]", ht);

            ShoppingCartInfo __info = new ShoppingCartInfo();
            __info.InfoID = proId;
            __info.AttrID = 0;
            __info.Num = 1;
            if (CheckUserLogin.Check() != "success")
            {
                __info.IsAnonymous = 1;
            }
            else
            {
                __info.IsAnonymous = 0;
            }
            __info.IsChangeBuy = 1;
            __info.Price = Utils.StrToFloat(DataFactory.GetOnlyValue("select top 1 ChangeBuyPresentPrice From [KS_ProductList] Where InfoID=" + proId));
            __info.userName = userName;
            __info.AddDate = DateTime.Now;
            int result = ShopManage.AddShoppingCart(__info);
            if (result > 0)  //添加成功
            {
                //多用户系统B2B2C
                if (Utils.StrToInt(MyCache.GetShopCommonConfig(41)) > 0)
                {
                    string business = DataFactory.GetOnlyValue("select top 1 inputer from ks_productlist where infoid=" + proId);
                    DataFactory.ExecuteNonQuery("update KS_ProShoppingCart set business='" + business + "' where CartID=" + CommonData.GetMaxId("KS_ProShoppingCart", "cartid"));
                }
                KSCMS.W("success");
            }
            else
            {
                KSCMS.W("error");
            }
            #endregion

        }
        private void removeAllProFromCart()
        {
            string userName = Kesion.APPCode.ShoppingCartUser.UserName;
            Hashtable ht = new Hashtable();
            ht.Add("username", Utils.ChkSQL(userName));
            CommonData.Delete("[KS_ProShoppingCart]", ht);
            new Kesion.APPCode.ShoppingCartUser().checkAndDelChangeBuyPro();
            KSCMS.W("success");
        }


        #region 购物车发票相关操作
        /// <summary>
        /// 保存发票信息
        /// </summary>
        private void SaveInvoice()
        {
            #region 保存发票信息
            int invoiceType = Utils.StrToInt(KSCMS.S("invoiceType"));
            int titleType = Utils.StrToInt(KSCMS.S("titleType"));

            int invoiceId = Utils.StrToInt(KSCMS.S("invoiceId"));
            string username = Kesion.APPCode.ShoppingCartUser.UserName;
            string companyName = string.Empty;
            if (invoiceType == 1)
            {
                companyName = Utils.RemoveXss(KSCMS.S("companyName"));
            }
            else
            {
                companyName = Utils.RemoveXss(KSCMS.S("invoiceTitle"));
            }

            if (DataFactory.Exists("KS_ProInvoice", "invoiceId<>" + invoiceId + " and companyName='" + Utils.ChkSQL(companyName) + "' and username='" + username + "' and InvoiceType=" + invoiceType + " and titleType=" + titleType))
            {
                KSCMS.Die("exists");
            }
            if (invoiceId == 0)
            {
                if (Utils.StrToInt(DataFactory.GetOnlyValue("select count(1) From KS_ProInvoice Where username='" + username + "'")) >= 20)
                {
                    KSCMS.Die("full");
                }
            }
            //if (invoiceType == 1 || titleType==1)
            {
                Hashtable ht = new Hashtable();
                ht.Add("InvoiceType", invoiceType);
                ht.Add("TitleType", titleType);
                ht.Add("CompanyName", companyName);
                ht.Add("NSRSBH", Utils.RemoveXss(KSCMS.S("NSRSBH")));
                ht.Add("Address", Utils.RemoveXss(KSCMS.S("Address")));
                ht.Add("Tel", Utils.RemoveXss(KSCMS.S("Tel")));
                ht.Add("Bank", Utils.RemoveXss(KSCMS.S("Bank")));
                ht.Add("BankNum", Utils.RemoveXss(KSCMS.S("BankNum")));
                ht.Add("ContactMan", Utils.RemoveXss(KSCMS.S("ContactMan")));
                ht.Add("Mobile", Utils.RemoveXss(KSCMS.S("Mobile")));
                ht.Add("userName", username);
                ht.Add("provinceid", Utils.StrToInt(KSCMS.S("i_provinceid")));
                ht.Add("cityid", Utils.StrToInt(KSCMS.S("i_cityid")));
                ht.Add("countyid", Utils.StrToInt(KSCMS.S("i_countyid")));
                ht.Add("ContactAddress", KSCMS.S("S_Address"));
                ht.Add("Email", KSCMS.S("email"));
                if (invoiceId > 0)
                {
                    CommonData.Update("KS_ProInvoice", ht, "where invoiceid=" + invoiceId + " and username='" + username + "'");
                }
                else
                {
                    ht.Add("adddate", DateTime.Now);
                    ht.Add("IsDefault", 0);
                    CommonData.Insert("KS_ProInvoice", ht);
                    invoiceId = Utils.StrToInt(DataFactory.GetOnlyValue("select max(invoiceid) from KS_ProInvoice where username='" + username + "'"));
                    if (string.IsNullOrEmpty((new TemporaryVar()).UserName))
                    {
                        (new TemporaryVar()).InvoiceId = invoiceId;
                    }
                }
            }
            KSCMS.W(invoiceId.ToString());
            #endregion
        }

        /// <summary>
        /// 加载修改发票信息
        /// </summary>
        private void ModifyInvoice()
        {
            #region 加载修改发票信息
            int invoiceId = Utils.StrToInt(KSCMS.S("invoiceId"));
            string userName = Kesion.APPCode.ShoppingCartUser.UserName;
            using (DataTable dt = DataFactory.GetDataTable("Select Top 1 * FROM KS_ProInvoice Where invoiceId=" + invoiceId + " and UserName='" + userName + "'"))
            {

                if (dt.Rows.Count > 0)
                {
                    DataRow dr = dt.Rows[0];
                    KSCMS.W(string.Format(@"var invoice={{""issuccess"":""true"",""invoicetype"":""{0}"",""titletype"":""{1}"",""companyname"":""{2}"",""nsrsbh"":""{3}"",""address"":""{4}"",""tel"":""{5}"",""bank"":""{6}"",""banknum"":""{7}"",""contactman"":""{8}"",""mobile"":""{9}"",""provinceid"":""{10}"",""cityid"":""{11}"",""countyid"":""{12}"",""contactaddress"":""{13}"",""email"":""{14}""}}",
                        dr["invoicetype"].ToString(), dr["titletype"].ToString(), dr["companyname"].ToString(), dr["nsrsbh"].ToString(), dr["address"].ToString(), dr["tel"].ToString(), dr["bank"].ToString(), dr["bankNum"].ToString(), dr["contactman"].ToString(), dr["mobile"].ToString(), dr["provinceid"].ToString(), dr["cityid"].ToString(), dr["countyid"].ToString(), dr["contactaddress"].ToString(), dr["email"].ToString()));
                }
                else
                {
                    KSCMS.W(@"var invoice={""issuccess"":""false""}");
                }
            }
            #endregion
        }
        /// <summary>
        /// 加载当前用户的发票信息
        /// </summary>
        private void LoadMyInvoice()
        {
            #region 加载当前用户的发票信息
            int invoiceId = Utils.StrToInt(KSCMS.S("invoiceId"));
            KSCMS.W(Kesion.APPCode.ShoppingCartUser.GetDefaultInvoiceStr(invoiceId));
            #endregion
        }
        /// <summary>
        /// 删除发票信息
        /// </summary>
        private void DeleteMyInvoice()
        {
            #region 删除发票信息
            int invoiceId = Utils.StrToInt(KSCMS.S("invoiceId"));
            string userName = Kesion.APPCode.ShoppingCartUser.UserName;
            DataFactory.ExecuteNonQuery("Delete From KS_ProInvoice Where UserName='" + userName + "' and invoiceId=" + invoiceId);
            KSCMS.W("success");
            #endregion
        }
        #endregion

        #region 购物车收货地址相关操作
        private void SaveProAddress()
        {
            #region 保存收货地址
            string realName = Utils.RemoveXss(KSCMS.S("realName"));
            string address = Utils.RemoveXss(KSCMS.S("address"));
            int addressId = Utils.StrToInt(KSCMS.S("addrid"));
            if (!string.IsNullOrEmpty(realName) && !string.IsNullOrEmpty(address))
            {
                Hashtable ht = new Hashtable();
                ht.Add("realName", realName);
                ht.Add("address", address);
                ht.Add("userName", Kesion.APPCode.ShoppingCartUser.UserName);
                ht.Add("provinceid", Utils.StrToInt(KSCMS.S("provinceid")));
                ht.Add("cityid", Utils.StrToInt(KSCMS.S("cityid")));
                ht.Add("countyid", Utils.StrToInt(KSCMS.S("countyid")));
                ht.Add("zipcode", Utils.RemoveXss(KSCMS.S("zipcode")));
                ht.Add("tel", Utils.RemoveXss(KSCMS.S("tel")));
                ht.Add("mobile", Utils.RemoveXss(KSCMS.S("mobile")));
                ht.Add("email", Utils.RemoveXss(KSCMS.S("email")));
                if (addressId != 0)
                {
                    CommonData.Update("KS_ProAddress", ht, "where addressid=" + addressId + " and username='" + Kesion.APPCode.ShoppingCartUser.UserName + "'");
                }
                else
                {
                    ht.Add("adddate", DateTime.Now);
                    CommonData.Insert("KS_ProAddress", ht);
                    addressId = Utils.StrToInt(DataFactory.GetOnlyValue("select max(addressid) from ks_proaddress where username='" + Kesion.APPCode.ShoppingCartUser.UserName + "'"));
                    if (string.IsNullOrEmpty((new TemporaryVar()).UserName))
                    {
                        (new TemporaryVar()).AddressId = addressId;
                    }
                }
            }
            KSCMS.W(addressId.ToString());
            #endregion
        }
        private void LoadAddAddress()
        {
            KSCMS.W(Kesion.APPCode.ShoppingCartUser.GetAddAddressStr());
        }
        private void LoadDefaultAddress()
        {
            KSCMS.W(Kesion.APPCode.ShoppingCartUser.GetDefaultAddressStr(Utils.StrToInt(KSCMS.S("sid")), Utils.StrToInt(KSCMS.S("fromMobile")) == 1));
        }
        private void ModifyProAddress()
        {
            int addrId = Utils.StrToInt(KSCMS.S("addrid"));
            string userName = Kesion.APPCode.ShoppingCartUser.UserName;
            using (DataTable dt = DataFactory.GetDataTable("Select Top 1 * FROM KS_ProAddress Where AddressID=" + addrId + " and UserName='" + userName + "'"))
            {

                if (dt.Rows.Count > 0)
                {
                    DataRow dr = dt.Rows[0];
                    KSCMS.W(string.Format(@"var address={{""issuccess"":""true"",""realname"":""{0}"",""zipcode"":""{1}"",""tel"":""{2}"",""mobile"":""{3}"",""email"":""{4}"",""address"":""{5}"",""provinceid"":""{6}"",""cityid"":""{7}"",""countyid"":""{8}""}}", dr["realname"].ToString(), dr["zipcode"].ToString(), dr["tel"].ToString(), dr["mobile"].ToString(), dr["email"].ToString(), dr["address"].ToString(), dr["provinceid"].ToString(), dr["cityid"].ToString(), dr["countyid"].ToString()));
                }
                else
                {
                    KSCMS.W(@"var address={""issuccess"":""false""}");
                }
            }
        }
        /// <summary>
        /// 删除收货地址
        /// </summary>
        private void DeleteMyAddress()
        {
            #region 删除收货地址
            int addressId = Utils.StrToInt(KSCMS.S("addressId"));
            string userName = Kesion.APPCode.ShoppingCartUser.UserName;
            DataFactory.ExecuteNonQuery("Delete From KS_ProAddress Where UserName='" + userName + "' and addressId=" + addressId);
            KSCMS.W("success");
            #endregion
        }
        #endregion

        private void LoadDeliverList()
        {
            int provinceId = Utils.StrToInt(KSCMS.S("provinceid"));
            int cityId = Utils.StrToInt(KSCMS.S("cityid"));
            int countyId = Utils.StrToInt(KSCMS.S("countyId"));
            int from = Utils.StrToInt(KSCMS.S("from"));
            #region 送货方式
            decimal defaultFreight = 0;
            StringBuilder sb = new StringBuilder();
            string template = string.Empty;
            if (from == 1) //手机
            {
                template = Kesion.XML.XmlObject.ReadXmlReturnNode(Utils.GetMapPath(MyCache.GetTemplateDir(1) + "/config/deliverylist.config"), "//labeltemplate/label");
            }
            else
            {
                template = Kesion.XML.XmlObject.ReadXmlReturnNode(Utils.GetMapPath(MyCache.GetTemplateDir(0) + "/config/deliverylist.config"), "//labeltemplate/label");
            }

            int MainStoreId = 0;                          //主仓库ID
            int MainStoreProvinceID = 0;                  //主仓库所在省份
            int MainStoreCityID = 0;                      //主仓库所有城市
            if (MyCache.GetShopCommonConfig(103) == "1")  //启用仓库,记录下主仓库ID号
            {
                using (DataTable dt = DataFactory.GetDataTable("SELECT Top 1 ID,ProvinceID,CityID From KS_ProStore Where StoreType=1"))
                {
                    if (dt.Rows.Count > 0)
                    {
                        DataRow dr = dt.Rows[0];
                        MainStoreId = Utils.StrToInt(dr["id"].ToString());
                        MainStoreProvinceID = Utils.StrToInt(dr["provinceid"].ToString());
                        MainStoreCityID = Utils.StrToInt(dr["cityid"].ToString());
                    }
                }
            }

            bool hasDeliveryCorp = false;  //标志有没有可用的物流仓库
            int nowNum = 0;
            using (DataTable dt = MyCache.GetCacheDeliveryTable())
            {
                if (dt.Rows.Count > 0)
                {
                    string recordLoopTemplate = Utils.CutHttpString(template, "[recordloop]", "[/recordloop]", false);
                    foreach (DataRow dr in dt.Rows)
                    {
                        int storeId = 0; //仓库ID
                        string freightTemplate = string.Empty;
                        string promotTemplate = string.Empty;
                        decimal totalFreight = 0;

                        int promotionType = Utils.StrToInt(dr["PromotionType"].ToString());
                        int DetailTipsTF = Utils.StrToInt(dr["DetailTipsTF"].ToString());

                        #region 送货方式优惠提示信息
                        string tempTp = string.Empty;
                        if (promotionType > 0)
                        {
                            if (Utils.StrToInt(dr["FreightType"].ToString()) != 0)
                            {

                                switch (promotionType)
                                {
                                    case 1:
                                        tempTp = Utils.GetLanguageNode("//language/node[@name='modelview']/shopmodel/shoppingcart/freightpro1");
                                        tempTp = Utils.ReplaceString(tempTp, "{$GetCurrencySymbol}", MyCache.GetCurrencySymbol, true);
                                        tempTp = Utils.ReplaceString(tempTp, "{$GetCurrencyUnit}", MyCache.GetCurrencyUnit, true);
                                        promotTemplate = string.Format(tempTp, Kesion.APPCode.Public.ReturnShopPrice(dr["OrderAmount1"].ToString()));
                                        break;
                                    case 2:
                                        tempTp = Utils.GetLanguageNode("//language/node[@name='modelview']/shopmodel/shoppingcart/freightpro2");
                                        tempTp = Utils.ReplaceString(tempTp, "{$GetCurrencySymbol}", MyCache.GetCurrencySymbol, true);
                                        tempTp = Utils.ReplaceString(tempTp, "{$GetCurrencyUnit}", MyCache.GetCurrencyUnit, true);
                                        promotTemplate = string.Format(tempTp, Kesion.APPCode.Public.ReturnShopPrice(dr["OrderAmount2"].ToString()), Kesion.APPCode.Public.ReturnShopPrice(dr["Freight1"].ToString()));
                                        break;
                                    case 3:
                                        tempTp = Utils.GetLanguageNode("//language/node[@name='modelview']/shopmodel/shoppingcart/freightpro3");
                                        tempTp = Utils.ReplaceString(tempTp, "{$GetCurrencySymbol}", MyCache.GetCurrencySymbol, true);
                                        tempTp = Utils.ReplaceString(tempTp, "{$GetCurrencyUnit}", MyCache.GetCurrencyUnit, true);
                                        promotTemplate = string.Format(tempTp, Kesion.APPCode.Public.ReturnShopPrice(dr["OrderAmount3"].ToString()), Kesion.APPCode.Public.ReturnShopPrice(dr["Freight2"].ToString()));
                                        break;
                                }
                            }
                        }
                        #endregion


                        #region 得到运费
                        decimal limitMinWeight = Utils.StrToDecimal(dr["limitMinWeight"].ToString());
                        decimal limitWeight = Utils.StrToDecimal(dr["limitweight"].ToString());
                        bool freightFree1 = true;
                        decimal totalWeight = 0;
                        if (limitWeight > 0)
                        {
                            totalWeight = new Kesion.APPCode.ShoppingCartUser().getOrderWeight(ref freightFree1);
                        }

                        bool FreightFree = false;  //免运费标志
                        int chargeType = Utils.StrToInt(dr["chargeType"].ToString());
                        int FreightType = Utils.StrToInt(dr["FreightType"].ToString());
                        #region 启用地区运费
                        string item = string.Empty;
                        string province = string.Empty;
                        string city = string.Empty;
                        string county = string.Empty;
                        if (chargeType > 0 && FreightType > 0)
                        {
                            province = MyCache.GetAreaName(provinceId, "city");
                            city = MyCache.GetAreaName(cityId, "city");
                            county = MyCache.GetAreaName(countyId, "city");

                            //构造数据库查询数据
                            switch (chargeType)
                            {
                                case 1:
                                    item = province;
                                    break;
                                case 2:
                                    item = province + "->" + city;
                                    break;
                                case 3:
                                    item = province + "->" + city + "->" + county;
                                    break;
                                default:
                                    item = province;
                                    break;
                            }
                        }
                        #endregion

                        switch (FreightType)
                        {
                            case 0:     //免费
                                #region 免运费
                                if (limitWeight > 0 && limitMinWeight >= 0 && (totalWeight >= limitWeight || totalWeight < limitMinWeight))
                                {
                                    System.Web.HttpContext.Current.Session["FreightFree" + dr["deliveryid"].ToString()] = false;
                                    continue;
                                }
                                else
                                {
                                    totalFreight = 0;
                                    freightTemplate = Utils.GetLanguageNode("//language/node[@name='modelview']/shopmodel/shoppingcart/freight1");
                                    hasDeliveryCorp = true;
                                }
                                break;
                                #endregion
                            case 1:  //固定运费
                                #region 固定运费
                                if (limitWeight > 0 && limitMinWeight >= 0 && (totalWeight >= limitWeight || totalWeight < limitMinWeight))
                                {
                                    System.Web.HttpContext.Current.Session["FreightFree" + dr["deliveryid"].ToString()] = false;
                                    continue;
                                }
                                else
                                {
                                    if (chargeType == 0)
                                    {
                                        #region 未启用地区
                                        totalFreight = Utils.StrToDecimal(dr["Freight"].ToString());
                                        #endregion
                                    }
                                    else
                                    {
                                        #region 启用地区
                                        #region 同城
                                        if (dr["iscitytf"].ToString().Equals("1") && cityId == Utils.StrToInt(MyCache.GetCacheShopConfig(1)))  // 同城
                                        {
                                            totalFreight = Utils.StrToDecimal(dr["CityFirstFreight"].ToString());
                                            FreightFree = true;  //同城免费
                                        }
                                        else if (dr["isprovincetf"].ToString().Equals("1") && provinceId == Utils.StrToInt(MyCache.GetCacheShopConfig(0))) //同省
                                        {
                                            totalFreight = Utils.StrToDecimal(dr["ProvinceFirstFreight"].ToString());
                                            FreightFree = true;  //同省免费
                                        }
                                        else if (string.IsNullOrEmpty(province))
                                        {
                                            continue;

                                        }
                                        else
                                        {

                                            using (DataTable dtd = DataFactory.GetDataTable("select top 1 * from [KS_ProDeliveryItem] Where DeliveryID=" + dr["DeliveryID"].ToString() + " and Convert(Nvarchar(4000),provinces) like N'%" + item + "%'"))
                                            {
                                                if (dtd.Rows.Count > 0)
                                                {
                                                    DataRow drd = dtd.Rows[0];
                                                    totalFreight = Utils.StrToDecimal(drd["firstFreight"].ToString());
                                                }
                                                else
                                                {
                                                    continue;
                                                }
                                            }
                                        }
                                        #endregion
                                        #endregion

                                    }


                                    decimal orderWeight = new Kesion.APPCode.ShoppingCartUser().getOrderWeight(ref FreightFree);
                                    if (FreightFree && dr["IsFreightFree"].ToString() == "1")  //包邮
                                    {
                                        totalFreight = 0;
                                    }
                                    else
                                    {
                                        totalFreight = new Kesion.APPCode.ShoppingCartUser().getRealFreight(promotionType, totalFreight, dr);  //得促销后的实际运费
                                    }
                                    freightTemplate = Utils.GetLanguageNode("//language/node[@name='modelview']/shopmodel/shoppingcart/freight2");
                                    freightTemplate = Utils.ReplaceString(freightTemplate, "{$GetCurrencySymbol}", MyCache.GetCurrencySymbol, true);
                                    freightTemplate = Utils.ReplaceString(freightTemplate, "{$GetCurrencyUnit}", MyCache.GetCurrencyUnit, true);
                                    freightTemplate = string.Format(freightTemplate, Kesion.APPCode.Public.ReturnShopPrice(totalFreight.ToString()));
                                    hasDeliveryCorp = true;
                                }
                                break;
                                #endregion
                            case 2: //按重量
                                #region 按重量
                                freightTemplate = Utils.GetLanguageNode("//language/node[@name='modelview']/shopmodel/shoppingcart/freight3");

                                decimal firstHeavy = Utils.StrToDecimal(dr["firstHeavy"].ToString());
                                decimal continueHeavy = Utils.StrToDecimal(dr["continueHeavy"].ToString());
                                decimal firstFreight = Utils.StrToDecimal(dr["firstFreight"].ToString());
                                decimal continueFreight = Utils.StrToDecimal(dr["continueFreight"].ToString());
                                decimal limitFreight = Utils.StrToDecimal(dr["limitFreight"].ToString());
                                int oneWeight = Utils.StrToInt(dr["oneweight"].ToString());
                                decimal weight = 0;





                                if (MyCache.GetShopCommonConfig(103) == "1")  //启用仓库
                                {

                                    #region  启用仓库
                                    int deliveryItemId = 0;  //配送点项
                                    if (chargeType != 0)   //启用仓库，必须分别设置地区运费才能使用该配置方式
                                    {
                                        #region 分别设置地区运费

                                        bool IsTcYF = false;
                                        if (string.IsNullOrEmpty(province))
                                        {
                                            continue;

                                        }
                                        #region 同城
                                        if (dr["iscitytf"].ToString().Equals("1") && cityId == Utils.StrToInt(MainStoreCityID))  // 同城
                                        {
                                            if (MainStoreId > 0)
                                            {
                                                //判断库存
                                                if (CheckHasStock(MainStoreId) == true)
                                                {
                                                    IsTcYF = true;
                                                    firstFreight = Utils.StrToDecimal(dr["CityFirstFreight"].ToString());
                                                    continueFreight = Utils.StrToDecimal(dr["CityContinueFreight"].ToString());
                                                    limitFreight = Utils.StrToDecimal(dr["CityLimitFreight"].ToString());
                                                    totalFreight = new Kesion.APPCode.ShoppingCartUser().getFreightByWeight(ref weight, firstHeavy, continueHeavy, firstFreight, continueFreight, limitFreight, oneWeight, ref FreightFree, Utils.StrToInt(dr["isFreightFree"].ToString()));
                                                    FreightFree = true;  //同城免费
                                                }

                                            }
                                        }
                                        #endregion

                                        #region 同省
                                        if (IsTcYF == false && dr["isprovincetf"].ToString().Equals("1") && provinceId == Utils.StrToInt(MainStoreProvinceID)) //同省
                                        {
                                            if (MainStoreId > 0)
                                            {
                                                if (CheckHasStock(MainStoreId) == true)
                                                {
                                                    IsTcYF = true;
                                                    firstFreight = Utils.StrToDecimal(dr["ProvinceFirstFreight"].ToString());
                                                    continueFreight = Utils.StrToDecimal(dr["ProvinceContinueFreight"].ToString());
                                                    limitFreight = Utils.StrToDecimal(dr["ProvinceLimitFreight"].ToString());
                                                    totalFreight = new Kesion.APPCode.ShoppingCartUser().getFreightByWeight(ref weight, firstHeavy, continueHeavy, firstFreight, continueFreight, limitFreight, oneWeight, ref FreightFree, Utils.StrToInt(dr["isFreightFree"].ToString()));
                                                    FreightFree = true;  //同省免费
                                                }
                                            }
                                        }
                                        #endregion

                                        if (IsTcYF == false)
                                        {

                                            #region 先判断辅仓库
                                            using (DataTable dtd = DataFactory.GetDataTable("select top 1 id,storeid from [KS_ProDeliveryItem] WHERE StoreType<>1 and DeliveryID=" + dr["DeliveryID"].ToString() + " and Convert(Nvarchar(4000),provinces) like N'%" + item + "%'"))
                                            {
                                                if (dtd.Rows.Count > 0) //辅仓库找到。
                                                {
                                                    DataRow dtr = dtd.Rows[0];
                                                    deliveryItemId = Utils.StrToInt(dtr["id"].ToString());
                                                    storeId = Utils.StrToInt(dtr["storeId"].ToString());
                                                    if (storeId > 0)
                                                    {

                                                        //判断库存
                                                        if (CheckHasStock(storeId) == false)
                                                        {
                                                            storeId = 0;  //无库存
                                                        }
                                                    }
                                                }
                                            }
                                            #endregion

                                            #region 辅仓库找不着或是没有库存，判断主仓库
                                            if (storeId == 0)
                                            {
                                                using (DataTable dtd = DataFactory.GetDataTable("select top 1 id from [KS_ProDeliveryItem] WHERE StoreType=1 and DeliveryID=" + dr["DeliveryID"].ToString() + " and Convert(Nvarchar(4000),provinces) like N'%" + item + "%'"))
                                                {
                                                    if (dtd.Rows.Count > 0) //主仓库找到。
                                                    {
                                                        DataRow dtr = dtd.Rows[0];
                                                        deliveryItemId = Utils.StrToInt(dtr["id"].ToString());
                                                        if (MainStoreId > 0)
                                                        {
                                                            //判断库存
                                                            if (CheckHasStock(MainStoreId) == false)
                                                            {
                                                                continue;
                                                            }

                                                        }
                                                    }
                                                    else
                                                    {
                                                        continue;
                                                    }
                                                }

                                            }
                                            #endregion

                                            #region 得运费
                                            if (deliveryItemId > 0)
                                            {
                                                using (DataTable dtd = DataFactory.GetDataTable("select top 1 * from [KS_ProDeliveryItem] Where ID=" + deliveryItemId))
                                                {
                                                    if (dtd.Rows.Count > 0)
                                                    {
                                                        DataRow drd = dtd.Rows[0];
                                                        firstFreight = Utils.StrToDecimal(drd["firstFreight"].ToString());
                                                        continueFreight = Utils.StrToDecimal(drd["continueFreight"].ToString());
                                                        limitFreight = Utils.StrToDecimal(drd["limitFreight"].ToString());
                                                        totalFreight = new Kesion.APPCode.ShoppingCartUser().getFreightByWeight(ref weight, firstHeavy, continueHeavy, firstFreight, continueFreight, limitFreight, oneWeight, ref FreightFree, Utils.StrToInt(dr["isFreightFree"].ToString()));
                                                        FreightFree = true;
                                                        hasDeliveryCorp = true;
                                                    }
                                                    else
                                                    {
                                                        continue;
                                                    }
                                                }
                                            }
                                            else
                                            {
                                                continue;
                                            }
                                            #endregion

                                        }
                                        #endregion

                                    }
                                    #endregion

                                }
                                else
                                {

                                    #region 启用分地区，未启用仓库
                                    if (chargeType != 0)
                                    {
                                        #region 启用不同地区设置不同运费
                                        if (dr["iscitytf"].ToString().Equals("1") && cityId == Utils.StrToInt(MyCache.GetCacheShopConfig(1)))  // 同城
                                        {
                                            firstFreight = Utils.StrToDecimal(dr["CityFirstFreight"].ToString());
                                            continueFreight = Utils.StrToDecimal(dr["CityContinueFreight"].ToString());
                                            limitFreight = Utils.StrToDecimal(dr["CityLimitFreight"].ToString());
                                            totalFreight = new Kesion.APPCode.ShoppingCartUser().getFreightByWeight(ref weight, firstHeavy, continueHeavy, firstFreight, continueFreight, limitFreight, oneWeight, ref FreightFree, Utils.StrToInt(dr["isFreightFree"].ToString()));
                                            FreightFree = true;  //同城免费
                                        }
                                        else if (dr["isprovincetf"].ToString().Equals("1") && provinceId == Utils.StrToInt(MyCache.GetCacheShopConfig(0))) //同省
                                        {
                                            firstFreight = Utils.StrToDecimal(dr["ProvinceFirstFreight"].ToString());
                                            continueFreight = Utils.StrToDecimal(dr["ProvinceContinueFreight"].ToString());
                                            limitFreight = Utils.StrToDecimal(dr["ProvinceLimitFreight"].ToString());
                                            totalFreight = new Kesion.APPCode.ShoppingCartUser().getFreightByWeight(ref weight, firstHeavy, continueHeavy, firstFreight, continueFreight, limitFreight, oneWeight, ref FreightFree, Utils.StrToInt(dr["isFreightFree"].ToString()));
                                            FreightFree = true;  //同省免费
                                        }
                                        else if (string.IsNullOrEmpty(province))
                                        {
                                            continue;

                                        }
                                        else
                                        {


                                            using (DataTable dtd = DataFactory.GetDataTable("select top 1 * from [KS_ProDeliveryItem] Where DeliveryID=" + dr["DeliveryID"].ToString() + " and Convert(Nvarchar(4000),provinces) like N'%" + item + "%'"))
                                            {
                                                if (dtd.Rows.Count > 0)
                                                {
                                                    DataRow drd = dtd.Rows[0];
                                                    firstFreight = Utils.StrToDecimal(drd["firstFreight"].ToString());
                                                    continueFreight = Utils.StrToDecimal(drd["continueFreight"].ToString());
                                                    limitFreight = Utils.StrToDecimal(drd["limitFreight"].ToString());
                                                    totalFreight = new Kesion.APPCode.ShoppingCartUser().getFreightByWeight(ref weight, firstHeavy, continueHeavy, firstFreight, continueFreight, limitFreight, oneWeight, ref FreightFree, Utils.StrToInt(dr["isFreightFree"].ToString()));

                                                }
                                                else
                                                {
                                                    continue;
                                                }
                                            }
                                        }
                                        #endregion

                                    }
                                    else
                                    {
                                        #region 所有地区相同运费
                                        firstFreight = Utils.StrToDecimal(dr["FirstFreight"].ToString());
                                        continueFreight = Utils.StrToDecimal(dr["ContinueFreight"].ToString());
                                        limitFreight = Utils.StrToDecimal(dr["LimitFreight"].ToString());
                                        totalFreight = new Kesion.APPCode.ShoppingCartUser().getFreightByWeight(ref weight, firstHeavy, continueHeavy, firstFreight, continueFreight, limitFreight, oneWeight, ref FreightFree, Utils.StrToInt(dr["isFreightFree"].ToString()));
                                        #endregion
                                    }
                                    #endregion

                                }

                                bool isFilterWeight = false;
                                if (limitWeight > 0 && limitMinWeight >= 0)
                                {
                                    if (totalWeight >= limitWeight || totalWeight < limitMinWeight)
                                    {
                                        isFilterWeight = true;
                                    }

                                }


                                totalFreight = new Kesion.APPCode.ShoppingCartUser().getRealFreight(promotionType, totalFreight, dr);  //得促销后的实际运费



                                if (isFilterWeight || (totalFreight <= 0 && promotionType == 0 && FreightFree == false)) //要运费，没有运费促销过滤掉 或时超过订单重量的情况下过滤掉
                                {
                                    System.Web.HttpContext.Current.Session["FreightFree" + dr["deliveryid"].ToString()] = false;
                                    continue;
                                }
                                else
                                {
                                    System.Web.HttpContext.Current.Session["FreightFree" + dr["deliveryid"].ToString()] = true;
                                    hasDeliveryCorp = true;
                                }
                                freightTemplate = Utils.ReplaceString(freightTemplate, "{$GetCurrencySymbol}", MyCache.GetCurrencySymbol, true);
                                freightTemplate = Utils.ReplaceString(freightTemplate, "{$GetCurrencyUnit}", MyCache.GetCurrencyUnit, true);

                                freightTemplate = string.Format(freightTemplate, firstHeavy, Kesion.APPCode.Public.ReturnShopPrice(firstFreight), continueHeavy, Kesion.APPCode.Public.ReturnShopPrice(continueFreight), Kesion.APPCode.Public.ReturnShopPrice(limitFreight), Kesion.APPCode.Public.ReturnShopPrice(weight.ToString()), Kesion.APPCode.Public.ReturnShopPrice(totalFreight));
                                break;
                                #endregion
                        }


                        #endregion


                        nowNum++;
                        string tt = recordLoopTemplate;
                        if (dr["isdefault"].ToString() == "1" || nowNum == 1)
                        {
                            defaultFreight = totalFreight;
                            tt = Utils.ReplaceString(tt, "{KS:Checked}", " checked", true);
                        }
                        else
                        {
                            tt = Utils.ReplaceString(tt, "{KS:Checked}", string.Empty, true);
                        }
                        tt = Utils.ReplaceString(tt, "{KS:DeliveryID}", dr["deliveryid"].ToString(), true);
                        tt = Utils.ReplaceString(tt, "{KS:IsZT}", dr["iszt"].ToString(), true);
                        tt = Utils.ReplaceString(tt, "{KS:DeliveryName}", dr["deliveryName"].ToString(), true);


                        string storeName = string.Empty;
                        if (MyCache.GetShopCommonConfig(103) == "1")  //判断显示仓库 
                        {
                            if (storeId == 0) storeId = MainStoreId;
                            storeName = DataFactory.GetOnlyValue("select top 1 Title From KS_ProStore Where id=" + storeId, false);
                            if (!string.IsNullOrEmpty(storeName))
                            {
                                storeName = "(" + storeName + ")";

                            }
                        }

                        tt = Utils.ReplaceString(tt, "{KS:ShowPromotInfo}", promotTemplate + storeName, true);
                        tt = Utils.ReplaceString(tt, "{KS:Intro}", dr["intro"].ToString(), true);


                        if (DetailTipsTF == 1)
                        {
                            tt = Utils.ReplaceString(tt, "{KS:ShowFreight}", freightTemplate, true);
                        }
                        else
                        {
                            if (totalFreight == 0)
                            {
                                tt = Utils.ReplaceString(tt, "{KS:ShowFreight}", Utils.GetLanguageNode("//language/node[@name='modelview']/shopmodel/shoppingcart/freight1"), true);
                            }
                            else
                            {
                                tt = Utils.ReplaceString(tt, "{KS:ShowFreight}", MyCache.GetCurrencySymbol + Kesion.APPCode.Public.ReturnShopPrice(totalFreight) + MyCache.GetCurrencyUnit, true);
                            }
                        }
                        tt = Utils.ReplaceString(tt, "{KS:Freight}", Kesion.APPCode.Public.ReturnShopPrice(totalFreight), true);


                        System.Web.HttpContext.Current.Session["FreightFree" + dr["deliveryid"].ToString()] = true;  //标志该物流可用
                        System.Web.HttpContext.Current.Session["Freight" + dr["deliveryId"].ToString()] = Kesion.APPCode.Public.ReturnShopPrice(totalFreight);  //运费保存到Session中
                        System.Web.HttpContext.Current.Session["StoreID" + dr["deliveryId"].ToString()] = storeId.ToString();

                        sb.AppendLine(tt);
                    }
                }
            }

            template = Utils.ReplaceString(template, Utils.CutHttpString(template, "[recordloop]", "[/recordloop]", true), sb.ToString(), true);
            template = Utils.ReplaceString(template, "{$GetCurrencySymbol}", MyCache.GetCurrencySymbol, true);
            template = Utils.ReplaceString(template, "{$GetCurrencyUnit}", MyCache.GetCurrencyUnit, true);

            #region 配货点
            if (template.IndexOf("{KS:ShowStore}") != -1 && MyCache.GetShopCommonConfig(103) != "1")   //并且没有启用仓库
            {
                sb = new StringBuilder();
                string storeInfo = Utils.GetLanguageNode("//language/node[@name='modelview']/shopmodel/shoppingcart/storeinfo");
                int n = 0;
                using (DataTable dt = MyCache.GetCacheProStoreTable())
                {
                    if (dt.Rows.Count > 0)
                    {
                        DataRow[] drr = null;
                        if (provinceId > 0)
                        {
                            drr = dt.Select("provinceid=" + provinceId);
                        }
                        else
                        {
                            drr = dt.Select("1=1");
                        }
                        if (drr != null)
                        {
                            foreach (DataRow dr in drr)
                            {
                                sb.AppendLine(string.Format(storeInfo, dr["id"].ToString(), dr["title"].ToString(), dr["address"].ToString(), dr["tel"].ToString(), n == 0 ? " checked" : string.Empty));
                                n++;
                            }
                        }
                    }
                }
                template = Utils.ReplaceString(template, "{KS:ShowStore}", sb.ToString(), true);

            }
            #endregion


            if (hasDeliveryCorp == false)
            {
                KSCMS.W("0@@@0");  //无可用物流
            }
            else
            {
                KSCMS.W(defaultFreight.ToString("F2") + "@@@" + template);
            }
            #endregion

        }

        /// <summary>
        /// 判断指定仓库是否有库存
        /// </summary>
        /// <param name="StoreID"></param>
        /// <returns></returns>
        private bool CheckHasStock(int StoreID)
        {
            #region 判断指定仓库是否有库存
            bool hasStock = true;
            using (DataTable dt = DataFactory.GetDataTable("select  a.cartid,a.infoid,a.num,m.amount From KS_ProShoppingCart A Inner Join KS_ProAmount M On (A.InfoID=M.ProID and A.attrID=M.AttrID) WHERE a.istopay=1 and m.storeid=" + StoreID + " and  username='" + Kesion.APPCode.ShoppingCartUser.UserName + "'"))
            {
                if (dt.Rows.Count > 0)
                {
                    foreach (DataRow dr in dt.Rows)
                    {
                        if (Utils.StrToInt(dr["amount"].ToString()) < Utils.StrToInt(dr["num"].ToString()))
                        {
                            hasStock = false;
                            break;
                        }
                    }
                }
                else
                {
                    hasStock = false;   //找不到记录，设置为无库存
                }
            }
            return hasStock;
            #endregion
        }


        private void GetLimitBuy()
        {
            int num = Utils.StrToInt(KSCMS.S("num"));
            int id = Utils.StrToInt(KSCMS.S("id"));
            int Style = Utils.StrToInt(KSCMS.S("Style"), 1);
            if (id == 0) return;
            if (num == 0) num = 2;

            //=========检测没有到达最后支付期限,没有支付的订单,并处理============
            ShopManage.LimitBuyCheckPayEndTime();


            using (DataTable dt = ShopManage.GetProductFromLimitBuy(num, id))
            {
                if (dt.Rows.Count > 0)
                {
                    string template = Kesion.XML.XmlObject.ReadXmlReturnNode(Utils.GetMapPath(KSCMS.GetInstallDir() + MyCache.GetCacheConfig(13) + "/config/limitbuy.config"), "//labeltemplate/label[@name='" + Style + "']");
                    string str, defaultPic;
                    string taskType = string.Empty;
                    string limitbuyBeginTime = string.Empty;
                    string limitbuyEndTime = string.Empty;
                    StringBuilder sb = new StringBuilder();
                    sb.Append("<ul>");
                    foreach (DataRow dr in dt.Rows)
                    {
                        str = template;
                        taskType = dr["TaskType"].ToString();
                        limitbuyBeginTime = dr["LimitBuyBeginTime"].ToString();
                        limitbuyEndTime = dr["LimitBuyEndTime"].ToString();
                        defaultPic = dr["defaultPic"].ToString();
                        if (string.IsNullOrEmpty(defaultPic)) defaultPic = MyCache.GetCacheShopConfig(9);
                        int amount = Convert.ToInt16(dr["limitbuyamount"].ToString());
                        if (amount <= 0)
                        {
                            str = Utils.ReplaceString(str, "{KS:LinkUrl}", @" href=""#"" onclick=""alert('抢购结束!');return false"" style=""cursor:pointer""", true);
                        }
                        else
                        {
                            str = Utils.ReplaceString(str, "{KS:LinkUrl}", string.Format(@" href=""{0}""", Kesion.HtmlTags.BasicField.GetItemUrl(dr)), true);
                        }
                        str = Utils.ReplaceString(str, "{$GetInstallDir}", KSCMS.GetInstallDir(), true);
                        str = Utils.ReplaceString(str, "{$GetSiteUrl}", MyCache.GetCacheConfig(5) + KSCMS.GetInstallDir(), true);
                        str = Utils.ReplaceString(str, "{KS:Title}", dr["title"].ToString(), true);
                        str = Utils.ReplaceString(str, "{KS:Amount}", amount.ToString(), true);
                        str = Utils.ReplaceString(str, "{KS:Price_Market}", Kesion.APPCode.Public.ReturnShopPrice(Utils.StrToDecimal(dr["price"].ToString())), true);
                        str = Utils.ReplaceString(str, "{KS:Price_Member}", Kesion.APPCode.Public.ReturnShopPrice(dr["price_member"].ToString()), true);
                        str = Utils.ReplaceString(str, "{KS:Price}", Kesion.APPCode.Public.ReturnShopPrice(dr["price"].ToString()), true);
                        str = Utils.ReplaceString(str, "{KS:LimitBuyPrice}", Kesion.APPCode.Public.ReturnShopPrice(dr["LimitBuyPrice"].ToString()), true);
                        str = Utils.ReplaceString(str, "{KS:Unit}", dr["unit"].ToString(), true);
                        str = Utils.ReplaceString(str, "{KS:DefaultPic}", defaultPic, true);
                        sb.Append(str);
                    }
                    sb.Append("</ul>");

                    KSCMS.W(string.Format(@"var t{0}=new calculagraph();t{0}._tasktype={1};t{0}._id='time{0}';t{0}._sT='{2}';  t{0}._cT='{3}';  t{0}._eT='{4}';   t{0}._interval();|", id, taskType, limitbuyBeginTime, DateTime.Now.ToString(), limitbuyEndTime));
                    KSCMS.Die(sb.ToString());

                }
            }

        }

        /// <summary>
        /// 清空优惠券号码
        /// </summary>
        private void CleanCouponNum()
        {
            int couponType = Utils.StrToInt(KSCMS.S("CouponType"));
            if (couponType == 1)
            {
                HttpContext.Current.Session["CouponNum1"] = null;
            }
            else
            {
                HttpContext.Current.Session["CouponNum"] = null;
            }
            KSCMS.Die("ok");

        }
        private void ValidateCoupon()
        {
            #region  检查优惠券及红包
            string str = string.Empty;
            int couponType = Utils.StrToInt(KSCMS.S("CouponType"));
            string name = string.Empty;
            if (couponType == 1)
            {
                name = "红包!";
            }
            else
            {
                name = "优惠券!";
            }
            if (CheckUserLogin.Check() != "success")
            {
                str = "登录后才可以使用" + name;
                HttpContext.Current.Session["CouponNum"] = string.Empty;
            }
            else
            {
                string couponNum = KSCMS.S("CouponNum");

                if (string.IsNullOrEmpty(couponNum))
                {
                    if (HttpContext.Current.Session["CouponNum" + couponType] != null)
                    {
                        if (!string.IsNullOrEmpty(HttpContext.Current.Session["CouponNum" + couponType].ToString()))
                        {
                            couponNum = HttpContext.Current.Session["CouponNum" + couponType].ToString();
                        }
                    }
                }
                if (string.IsNullOrEmpty(couponNum)) return;

                using (DataTable dt = ShopManage.GetCouponInfoByCouponNum(couponNum))
                {
                    if (dt.Rows.Count > 0)
                    {
                        DataRow dr = dt.Rows[0];
                        if (dr["RangeType"].ToString() == "0" || dr["RangeType"].ToString() == "3")
                        {
                            DateTime beginDate = Utils.StrToDateTime(dr["BeginDate"].ToString());
                            DateTime endDate = Utils.StrToDateTime(dr["EndDate"].ToString());
                            TimeSpan ts = beginDate.Subtract(DateTime.Now);
                            TimeSpan ts1 = endDate.Subtract(DateTime.Now);
                            if (dr["CouponType"].ToString() == "1" && dr["UserName"].ToString() != (new TemporaryVar()).UserName)
                            {
                                str = Utils.GetLanguageNode("//language/node[@name='modelview']/shopmodel/shoppingcart/errcoupon0");
                            }
                            else if (ts.Seconds > 0) //没到开始使用日期
                            {
                                str = string.Format(Utils.GetLanguageNode("//language/node[@name='modelview']/shopmodel/shoppingcart/errcoupon1"), dr["BeginDate"].ToString());
                            }
                            else if (ts1.Seconds < 0)  //过期
                            {
                                str = string.Format(Utils.GetLanguageNode("//language/node[@name='modelview']/shopmodel/shoppingcart/errcoupon3"), dr["EndDate"].ToString());
                            }
                            else if (dr["status"].ToString() == "0") // 已被锁定
                            {
                                str = Utils.GetLanguageNode("//language/node[@name='modelview']/shopmodel/shoppingcart/errcoupon4");
                            }
                            else if (Utils.StrToFloat(dr["AvailableMoney"].ToString()) <= 0)
                            {
                                str = Utils.GetLanguageNode("//language/node[@name='modelview']/shopmodel/shoppingcart/errcoupon5");
                            }
                            else
                            {

                                bool couponIsUse = true;
                                #region 商品类型限制使用
                                if (dr["LimitType"].ToString() == "1" && HttpContext.Current.Session["Cart_Classid"] != null)
                                {
                                    couponIsUse = Kesion.APPCode.ShoppingCartUser.CheckAllowUserCoupon(HttpContext.Current.Session["Cart_Classid"].ToString(), dr["LimitClassIDs"].ToString());
                                }
                                #endregion

                                #region 商品限制使用
                                if (dr["LimitType"].ToString() == "2" && couponIsUse == true && HttpContext.Current.Session["Cart_Infoid"] != null)
                                {
                                    couponIsUse = Kesion.APPCode.ShoppingCartUser.CheckAllowUserCoupon(HttpContext.Current.Session["Cart_Infoid"].ToString(), dr["LimitProIds"].ToString());
                                }
                                #endregion

                                if (couponIsUse == false)
                                {
                                    str = Utils.GetLanguageNode("//language/node[@name='modelview']/shopmodel/shoppingcart/errcoupon6");
                                }
                                else
                                {
                                    str = dr["FaceValue"].ToString() + "|" + dr["MinAmount"].ToString() + "|" + dr["MaxDiscount"].ToString() + "|" + dr["AvailableMoney"].ToString() + "|" + couponNum;
                                }
                            }

                            if (couponType == 1)
                            {
                                HttpContext.Current.Session["CouponNum1"] = couponNum;  //红包
                            }
                            else
                            {
                                HttpContext.Current.Session["CouponNum"] = couponNum;  //优惠券
                            }
                        }

                    }
                }
            }
            str = Utils.ReplaceString(str, "{$GetCurrencySymbol}", MyCache.GetCurrencySymbol, true);
            str = Utils.ReplaceString(str, "{$GetCurrencyUnit}", MyCache.GetCurrencyUnit, true);
            KSCMS.W(str);
            #endregion
        }
        private void GroupBuyClassOption()
        {
            #region 团购小类
            int bigClassID = Utils.StrToInt(KSCMS.S("parentid"));
            int classID = Utils.StrToInt(KSCMS.S("classid"));
            StringBuilder sb = new StringBuilder();

            if (bigClassID > 0)
            {
                using (DataTable dt = DataFactory.GetDataTable("select classid,classname,parentid from KS_ProGroupBuyClass where parentid=" + bigClassID + " and islock=0 order by rootid,orders"))
                {
                    if (dt.Rows.Count > 0)
                    {
                        foreach (DataRow dr in dt.Rows)
                        {
                            sb.AppendFormat("<option value='{0}'{2}>{1}</option>", dr["classid"].ToString(), dr["classname"].ToString(), Utils.StrToInt(dr["classid"].ToString()) == classID ? " selected" : string.Empty);
                        }
                    }
                }
            }
            KSCMS.W(sb.ToString());
            #endregion
        }

        private void GetCityOption()
        {
            #region 初始化城市
            int provinceid = Utils.StrToInt(KSCMS.S("provinceid"));
            int cityid = Utils.StrToInt(KSCMS.S("cityid"));
            StringBuilder sb = new StringBuilder();
            if (provinceid > 0)
            {

                using (DataTable dt = MyCache.GetAreaTable())
                {
                    if (dt.Rows.Count > 0)
                    {
                        DataView dv = dt.DefaultView;
                        dv.RowFilter = "parentid=" + provinceid.ToString();
                        DataTable dtt = dv.ToTable();
                        foreach (DataRow dr in dtt.Rows)
                        {
                            sb.AppendFormat("<option value='{0}'{2}>{1}</option>", dr["id"].ToString(), dr["city"].ToString(), Utils.StrToInt(dr["id"].ToString()) == cityid ? " selected" : string.Empty);
                        }
                    }

                }
            }
            KSCMS.W(sb.ToString());
            #endregion
        }
        #endregion


        private void SearchUser()
        {
            string key = Utils.ChkSQL(KSCMS.S("key"));
            if (string.IsNullOrEmpty(key)) return;
            string SQL = "Select top 500 UserName FROM KS_User Where UserName like N'%" + key + "%'";
            using (DataTable dt = DataFactoryUser.GetDataTable(SQL))
            {
                foreach (DataRow dr in dt.Rows)
                {
                    KSCMS.W(dr["UserName"].ToString() + "|");
                }
            }
        }


        private void WriteXML(string strxml)
        {
            HttpContext.Current.Response.ContentType = "application/xml";
            HttpContext.Current.Response.Expires = 0;
            HttpContext.Current.Response.Cache.SetNoStore();
            HttpContext.Current.Response.Charset = "utf-8";

            KSCMS.Die(strxml);

        }



    }
}