#define D65E_0_SLOT 0

#include "sys/types.h"

#include "sys/stream.h"

#include "sys/socket.h"

#include "/etc/conf/cf.d/config.h"



/*
 * DE-650CT plus PCMCIA Ethernet card media selection. Can have one of the
 * following values:
 *
 *	MEDIA_UTP	- twisted pair connection
 *	MEDIA_BNC	- BNC connection
 *	MEDIA_AUI	- AUI connection
 *	MEDIA_AUTO	- Automatic detect connected media
 *	MEDIA_DEFAULT	- Use default setting.
 */
#define MEDIA_UTP	0
#define MEDIA_BNC	1
#define MEDIA_AUI	2
#define MEDIA_AUTO	3
#define MEDIA_DEFAULT	-1

#define ND65E_MediaType_0	MEDIA_AUTO
#define ND65E_MediaType_1	MEDIA_AUTO
#define ND65E_MediaType_2	MEDIA_AUTO
#define ND65E_MediaType_3	MEDIA_AUTO



/* interrupt level per board  */

#if defined(D65E3_UNITS)

#define ND65EUNIT (D65E3_UNITS+D65E2_UNITS+D65E1_UNITS+D65E_UNITS)

ulong de650intl[ND65EUNIT] =

	{ D65E_0_VECT,D65E1_0_VECT,D65E2_0_VECT,D65E3_0_VECT };

ulong de650ioaddr[ND65EUNIT] =

	{ D65E_0_SIOA,D65E1_0_SIOA,D65E2_0_SIOA,D65E3_0_SIOA };

ulong de650mem[ND65EUNIT] =

	{ D65E_0_SCMA,D65E1_0_SCMA,D65E2_0_SCMA,D65E3_0_SCMA };

ulong de650slot[ND65EUNIT] =

	{ D65E_0_SLOT,D65E1_0_SLOT,D65E2_0_SLOT,D65E3_0_SLOT };

ulong de650media[ND65EUNIT] = {
	ND65E_MediaType_0,
	ND65E_MediaType_1,
	ND65E_MediaType_2,
	ND65E_MediaType_3
	};

#elif defined(D65E2_UNITS)

#define ND65EUNIT (D65E2_UNITS+D65E1_UNITS+D65E_UNITS)

ulong de650intl[ND65EUNIT] =

	{ D65E_0_VECT,D65E1_0_VECT,D65E2_0_VECT };

ulong de650ioaddr[ND65EUNIT] =

	{ D65E_0_SIOA,D65E1_0_SIOA,D65E2_0_SIOA };

ulong de650mem[ND65EUNIT] =

	{ D65E_0_SCMA,D65E1_0_SCMA,D65E2_0_SCMA };

ulong de650slot[ND65EUNIT] =

	{ D65E_0_SLOT,D65E1_0_SLOT,D65E2_0_SLOT };

ulong de650media[ND65EUNIT] = {
	ND65E_MediaType_0,
	ND65E_MediaType_1,
	ND65E_MediaType_2
	};

#elif defined(D65E1_UNITS)

#define ND65EUNIT (D65E1_UNITS+D65E_UNITS)

ulong de650intl[ND65EUNIT] = { D65E_0_VECT,D65E1_0_VECT };

ulong de650ioaddr[ND65EUNIT] = { D65E_0_SIOA,D65E1_0_SIOA };

ulong de650mem[ND65EUNIT] = { D65E_0_SCMA,D65E1_0_SCMA };

ulong de650slot[ND65EUNIT] = { D65E_0_SLOT,D65E1_0_SLOT };

ulong de650media[ND65EUNIT] = {
	ND65E_MediaType_0,
	ND65E_MediaType_1
	};

#elif defined(D65E_UNITS)

#define ND65EUNIT D65E_UNITS

ulong de650intl[ND65EUNIT] = { D65E_0_VECT };

ulong de650ioaddr[ND65EUNIT] = { D65E_0_SIOA };

ulong de650mem[ND65EUNIT] = { D65E_0_SCMA };

ulong de650slot[ND65EUNIT] = { D65E_0_SLOT };

ulong de650media[ND65EUNIT] = {
	ND65E_MediaType_0
	};

#endif



ulong DE650_BOARDS = ND65EUNIT;

