/*
 * Decompiled with CFR 0.152.
 */
package webetk.install.server;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.ServerSocket;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import webetk.install.resources.Resource;
import webetk.install.server.HeaderPanel;
import webetk.install.server.InstallServer;
import webetk.install.utils.ImageCache;
import webetk.install.utils.LimitedNumberField;
import webetk.install.utils.LineBreakPanel;

public class AskPort
extends JPanel {
    private static Logger log = Logger.getLogger(AskPort.class);
    private InstallServer mParent;
    private HeaderPanel mHeaderPanel;
    private boolean mbAskTomcatPorts;
    private boolean mbAskTransbasePorts;
    private String mszTargetDir = "";
    private String msServerPropFile;
    private JButton mButtonUebernehmen;
    private JButton mButtonAbbrechen;
    private LineBreakPanel mInformation;
    private JLabel mtxtTomcat;
    private JLabel mtxtShutdownPort;
    private JTextField mtfShutdownPort;
    private JLabel mtxtPort;
    private JTextField mtfPort;
    private JLabel mtxtTb;
    private JLabel mtxtShutdownPortTb;
    private JTextField mtfShutdownPortTb;
    private JLabel mtxtPortTb;
    private JTextField mtfPortTb;

    public AskPort(InstallServer parent, String targetDir, String sServerPropFile, boolean bAskTomcatPorts, boolean bAskTransbasePorts) {
        this.mParent = parent;
        this.mszTargetDir = targetDir;
        this.msServerPropFile = sServerPropFile;
        this.mbAskTomcatPorts = bAskTomcatPorts;
        this.mbAskTransbasePorts = bAskTransbasePorts;
        this.mHeaderPanel = new HeaderPanel(Resource.getInstance().getAuswahlDesPorts(), null);
        this.initComponents();
    }

    private void initComponents() {
        this.mParent.setTitle(Resource.getInstance().getAuswahlDesPorts());
        this.mButtonUebernehmen = new JButton(Resource.getInstance().getOk(), ImageCache.getInstance().getIcon("ok.gif"));
        this.mButtonAbbrechen = new JButton(Resource.getInstance().getAbbrechen(), ImageCache.getInstance().getIcon("delete.gif"));
        this.mInformation = new LineBreakPanel(Resource.getInstance().getExplainPort());
        Dimension size = new Dimension(this.getWidth(), 80);
        this.mInformation.setMinimumSize(size);
        if (this.mbAskTomcatPorts) {
            this.mtxtTomcat = new JLabel(Resource.getInstance().getTomcat());
            this.mtxtPort = new JLabel(Resource.getInstance().getApplicationPort() + ":");
            this.mtfPort = new LimitedNumberField(12);
            this.mtxtShutdownPort = new JLabel(Resource.getInstance().getShutdownPort() + ":");
            this.mtfShutdownPort = new LimitedNumberField(12);
        }
        if (this.mbAskTransbasePorts) {
            this.mtxtTb = new JLabel(Resource.getInstance().getTransbase());
            this.mtxtPortTb = new JLabel(Resource.getInstance().getApplicationPort() + ":");
            this.mtfPortTb = new LimitedNumberField(12);
            this.mtxtShutdownPortTb = new JLabel(Resource.getInstance().getShutdownPort() + ":");
            this.mtfShutdownPortTb = new LimitedNumberField(12);
        }
        ServerSocket asapSocket = null;
        ServerSocket asapSocket2 = null;
        ServerSocket applicationSocket = null;
        ServerSocket shutdownSocket = null;
        ServerSocket applicationSocketTb = null;
        ServerSocket shutdownSocketTb = null;
        try {
            asapSocket = new ServerSocket(3097);
            asapSocket2 = new ServerSocket(3098);
        }
        catch (IOException ex) {
            // empty catch block
        }
        try {
            if (this.mbAskTomcatPorts) {
                applicationSocket = new ServerSocket(0);
                shutdownSocket = new ServerSocket(0);
                this.mtfPort.setText("" + applicationSocket.getLocalPort());
                this.mtfShutdownPort.setText("" + shutdownSocket.getLocalPort());
            }
            if (this.mbAskTransbasePorts) {
                try {
                    applicationSocketTb = new ServerSocket(2024);
                    shutdownSocketTb = new ServerSocket(2025);
                }
                catch (IOException e) {
                    applicationSocketTb = new ServerSocket(0);
                    shutdownSocketTb = new ServerSocket(0);
                }
                this.mtfPortTb.setText("" + applicationSocketTb.getLocalPort());
                this.mtfShutdownPortTb.setText("" + shutdownSocketTb.getLocalPort());
            }
            if (this.mbAskTomcatPorts) {
                if (applicationSocket != null) {
                    applicationSocket.close();
                }
                if (shutdownSocket != null) {
                    shutdownSocket.close();
                }
            }
            if (this.mbAskTransbasePorts) {
                if (applicationSocketTb != null) {
                    applicationSocketTb.close();
                }
                if (shutdownSocketTb != null) {
                    shutdownSocketTb.close();
                }
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), Resource.getInstance().getAuswahlDesPorts(), 0);
            e.printStackTrace();
        }
        try {
            if (asapSocket != null) {
                asapSocket.close();
            }
            if (asapSocket2 != null) {
                asapSocket2.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        this.layoutAll();
    }

    private void layoutAll() {
        int[] w = new int[]{0};
        int[] h = new int[]{0, 0, 0};
        HIGLayout l = new HIGLayout(w, h);
        l.setColumnWeight(1, 1);
        l.setRowWeight(3, 1);
        HIGConstraints c = new HIGConstraints();
        this.setLayout(l);
        this.add((Component)this.mHeaderPanel, c.rc(1, 1, "tlbr"));
        JPanel content = this.createContent();
        this.add((Component)content, c.rc(3, 1, "tlbr"));
    }

    private JPanel createContent() {
        JPanel panel = new JPanel();
        HIGConstraints c = new HIGConstraints();
        int[] widths = new int[]{10, 0, 10};
        int[] heights = new int[]{10, 0, 10, 0, 10};
        HIGLayout layoutPosTeileliste = new HIGLayout(widths, heights);
        layoutPosTeileliste.setColumnWeight(2, 1);
        layoutPosTeileliste.setRowWeight(5, 1);
        panel.setLayout(layoutPosTeileliste);
        panel.add((Component)this.createCenterPanel(), c.rc(2, 2, "lrtb"));
        panel.add((Component)this.createButtonPanel(), c.rc(4, 2, "lrtb"));
        return panel;
    }

    private JPanel createCenterPanel() {
        JPanel panel = new JPanel();
        HIGConstraints c = new HIGConstraints();
        int[] widths = new int[]{10, 0, 10, 0, 10};
        int[] heights = null;
        heights = this.mbAskTomcatPorts && this.mbAskTransbasePorts ? new int[]{10, 0, 10, 0, 10, 0, 10, 0, 10, 0, 10, 0, 10, 0, 10} : new int[]{10, 0, 10, 0, 10, 0, 10, 0, 10};
        HIGLayout layout = new HIGLayout(widths, heights);
        layout.setColumnWeight(4, 1);
        panel.setLayout(layout);
        panel.add((Component)this.mInformation, c.rcwh(2, 2, 3, 1, "tlbr"));
        int nRowOffset = 4;
        if (this.mbAskTomcatPorts) {
            panel.add((Component)this.mtxtTomcat, c.rc(4, 2, "l"));
            panel.add((Component)this.mtxtPort, c.rc(6, 2, "l"));
            panel.add((Component)this.mtfPort, c.rc(6, 4, "l"));
            panel.add((Component)this.mtxtShutdownPort, c.rc(8, 2, "l"));
            panel.add((Component)this.mtfShutdownPort, c.rc(8, 4, "l"));
            nRowOffset = 10;
        }
        if (this.mbAskTransbasePorts) {
            panel.add((Component)this.mtxtTb, c.rc(nRowOffset, 2, "l"));
            panel.add((Component)this.mtxtPortTb, c.rc(nRowOffset + 2, 2, "l"));
            panel.add((Component)this.mtfPortTb, c.rc(nRowOffset + 2, 4, "l"));
            panel.add((Component)this.mtxtShutdownPortTb, c.rc(nRowOffset + 4, 2, "l"));
            panel.add((Component)this.mtfShutdownPortTb, c.rc(nRowOffset + 4, 4, "l"));
        }
        return panel;
    }

    private JPanel createButtonPanel() {
        JPanel panel = new JPanel();
        HIGConstraints c = new HIGConstraints();
        int[] widths = new int[]{-5, -4, 10, -2, -1};
        int[] heights = new int[]{0, 10};
        HIGLayout layoutPosTeileliste = new HIGLayout(widths, heights);
        layoutPosTeileliste.setColumnWeight(1, 1);
        layoutPosTeileliste.setColumnWeight(5, 1);
        layoutPosTeileliste.setRowWeight(2, 1);
        panel.setLayout(layoutPosTeileliste);
        panel.add((Component)this.mButtonUebernehmen, c.rc(1, 2, "lrtb"));
        panel.add((Component)this.mButtonAbbrechen, c.rc(1, 4, "lrtb"));
        this.mButtonUebernehmen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AskPort.this.mbAskTomcatPorts) {
                    AskPort.this.configTomcat();
                }
                if (AskPort.this.mbAskTransbasePorts) {
                    AskPort.this.configTransbase();
                }
                AskPort.this.mParent.executeNextStep();
            }
        });
        this.mButtonAbbrechen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AskPort.this.mParent.stopInstall();
            }
        });
        return panel;
    }

    public void configTomcat() {
        String szLine;
        BufferedWriter out;
        this.setCursor(Cursor.getPredefinedCursor(3));
        String sTomcatDir = this.mszTargetDir + File.separator + "tomcat";
        String sConfigFile = sTomcatDir + File.separator + "conf" + File.separator + "server.xml";
        String sTemplateFile = sTomcatDir + File.separator + "conf" + File.separator + "dummy.xml";
        String sJavaClientPorpertiesFile = this.mszTargetDir + File.separator + "javaclient" + File.separator + "classes" + File.separator + "javaclient.properties";
        log.info("Tomcat Ports: " + this.mtfPort.getText() + " und " + this.mtfShutdownPort.getText());
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(sTemplateFile)));
            out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(sConfigFile)));
            szLine = "";
            while ((szLine = in.readLine()) != null) {
                szLine = AskPort.substituteStringStraight(szLine, "&shutdownport&", this.mtfShutdownPort.getText());
                szLine = AskPort.substituteStringStraight(szLine, "&connectorport&", this.mtfPort.getText());
                out.write(szLine + "\n");
            }
            in.close();
            out.close();
        }
        catch (IOException e) {
            log.error("Fehler beim speichern der Tomcat-Ports in " + sConfigFile, e);
            e.printStackTrace();
            this.setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        Vector<String> aszZeilen = new Vector<String>();
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(sJavaClientPorpertiesFile)));
            szLine = "";
            while ((szLine = in.readLine()) != null) {
                if (szLine.startsWith("tomcat.port")) {
                    szLine = "tomcat.port = " + this.mtfPort.getText();
                } else if (szLine.startsWith("server.URL")) {
                    szLine = "server.URL = http://localhost:" + this.mtfPort.getText() + "/javaserver/rest";
                }
                aszZeilen.add(szLine);
            }
            in.close();
        }
        catch (IOException e) {
            log.error("Fehler beim speichern der Tomcat-Ports in " + sJavaClientPorpertiesFile, e);
            e.printStackTrace();
            return;
        }
        try {
            out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(sJavaClientPorpertiesFile)));
            Iterator iter = aszZeilen.iterator();
            while (iter.hasNext()) {
                out.write((String)iter.next() + System.getProperty("line.separator"));
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void configTransbase() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        String sTransbaseDir = this.mszTargetDir + File.separator + "transbase";
        String sTbenvFile = sTransbaseDir + File.separator + "rc.tbenv";
        if (InstallServer.isMSWindows()) {
            sTbenvFile = sTransbaseDir + File.separator + "tbwin.ini";
        }
        String sAdmintoolPropFile = this.mszTargetDir + File.separator + "admintool" + File.separator + "admintool.properties";
        String sMigrationPropFile = this.mszTargetDir + File.separator + "migration" + File.separator + "migration.properties";
        Vector<String> aszZeilen = new Vector<String>();
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(sTbenvFile)));
            String szLine = "";
            while ((szLine = in.readLine()) != null) {
                if (szLine.startsWith("TRANSBASE_SERVICENAMES=")) {
                    szLine = "TRANSBASE_SERVICENAMES=" + this.mtfPortTb.getText() + ":" + this.mtfShutdownPortTb.getText();
                }
                aszZeilen.add(szLine);
            }
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        try {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(sTbenvFile)));
            Iterator iter = aszZeilen.iterator();
            while (iter.hasNext()) {
                out.write((String)iter.next() + System.getProperty("line.separator"));
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        this.replacePortInConnectString(sAdmintoolPropFile);
        this.replacePortInConnectString(sMigrationPropFile);
        this.replacePortInConnectString(this.msServerPropFile);
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void replacePortInConnectString(String sFile) {
        Vector<String> aszZeilen = new Vector<String>();
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(sFile)));
            String szLine = "";
            while ((szLine = in.readLine()) != null) {
                szLine = AskPort.substituteStringStraight(szLine, "jdbc:transbase://localhost:2024", "jdbc:transbase://localhost:" + this.mtfPortTb.getText());
                aszZeilen.add(szLine);
            }
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        try {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(sFile)));
            Iterator iter = aszZeilen.iterator();
            while (iter.hasNext()) {
                out.write((String)iter.next() + System.getProperty("line.separator"));
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String substituteStringStraight(String sSource, String sParam, String sSubst) {
        if (sSource == null || sParam == null) {
            return sSource;
        }
        if (sSubst == null) {
            sSubst = "";
        }
        int nIndex = sSource.indexOf(sParam);
        while (nIndex != -1) {
            String sNewString;
            sSource = sNewString = sSource.substring(0, nIndex) + sSubst + sSource.substring(nIndex + sParam.length(), sSource.length());
            nIndex = sSource.indexOf(sParam, nIndex + sSubst.length());
        }
        return sSource;
    }
}

