/*
 * Decompiled with CFR 0.152.
 */
package webetk.install.server;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import javax.swing.Icon;
import javax.swing.JPanel;
import webetk.install.lookandfeel.UIHelper;

public class HeaderPanel
extends JPanel {
    Font bigTitleFont = UIHelper.getBigTitleFont();
    Font smallTitleFont = UIHelper.getSmallTitleFont();
    String bigTitle;
    String smallTitle;
    Icon icon;

    public HeaderPanel(String bigTitle, Icon icon) {
        this(bigTitle, null, icon);
    }

    public HeaderPanel(String bigTitle, String smallTitle, Icon icon) {
        if (bigTitle == null) {
            throw new IllegalArgumentException("bigTitle must not be null for HeaderPanel");
        }
        this.bigTitle = bigTitle;
        this.smallTitle = smallTitle == null || smallTitle.length() == 0 || smallTitle.equals(" ") ? null : smallTitle;
        this.icon = icon;
    }

    public void setBigTitle(String sBigTitle) {
        this.bigTitle = sBigTitle;
    }

    public void setSmallTitle(String sSmallTitle) {
        this.smallTitle = sSmallTitle;
    }

    public void setIcon(Icon sIcon) {
        this.icon = sIcon;
    }

    @Override
    public void paint(Graphics g) {
        Rectangle2D boundsBig;
        TextLayout tBig;
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setColor(Color.white);
        Dimension d = this.getSize();
        g2d.fillRect(0, 0, d.width, d.height);
        FontRenderContext ctx = g2d.getFontRenderContext();
        if (this.smallTitle != null) {
            tBig = new TextLayout(this.bigTitle, this.bigTitleFont, ctx);
            boundsBig = tBig.getBounds();
            TextLayout tSmall = null;
            tSmall = new TextLayout(this.smallTitle, this.smallTitleFont, ctx);
            Rectangle2D boundsSmall = tSmall.getBounds();
            double height = boundsBig.getHeight() + boundsSmall.getHeight();
            double diff = ((double)d.height - height) / 3.0;
            g2d.setColor(UIHelper.getBigTitleColor());
            tBig.draw(g2d, 10.0f, (float)(3.0 + diff - boundsBig.getY()));
            g2d.setColor(UIHelper.getSmallTitleColor());
            tSmall.draw(g2d, 20.0f, (float)((double)d.height - boundsSmall.getHeight() - boundsSmall.getY() - diff));
        } else {
            tBig = new TextLayout(this.bigTitle, this.bigTitleFont, ctx);
            boundsBig = tBig.getBounds();
            double height = boundsBig.getHeight();
            double diff = ((double)d.height - height) / 2.0;
            g2d.setColor(UIHelper.getBigTitleColor());
            tBig.draw(g2d, 10.0f, (float)(diff - boundsBig.getY()));
        }
        if (this.icon != null) {
            int x = d.width - this.icon.getIconWidth();
            int y = (d.height - this.icon.getIconHeight()) / 2;
            this.icon.paintIcon(this, g2d, x, y);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.icon != null) {
            return new Dimension(200, Math.max(40, this.icon.getIconHeight()));
        }
        return new Dimension(200, 55);
    }
}

