/*
 * Decompiled with CFR 0.152.
 */
package webetk.install.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import webetk.install.utils.CopyFilenameFilter;

public class Copy {
    private static final int BLOCKSIZE = 64000;

    public static void copyFile(String file, String newFile) throws FileNotFoundException, IOException {
        int nread;
        FileInputStream is = new FileInputStream(file);
        FileOutputStream os = new FileOutputStream(newFile);
        byte[] buffer = new byte[64000];
        while ((nread = ((InputStream)is).read(buffer, 0, buffer.length)) != -1) {
            ((OutputStream)os).write(buffer, 0, nread);
        }
        ((InputStream)is).close();
        ((OutputStream)os).close();
    }

    private static void copyFile(File file, File newFile) throws FileNotFoundException, IOException {
        int nread;
        FileInputStream is = new FileInputStream(file);
        FileOutputStream os = new FileOutputStream(newFile);
        byte[] buffer = new byte[64000];
        while ((nread = ((InputStream)is).read(buffer, 0, buffer.length)) != -1) {
            ((OutputStream)os).write(buffer, 0, nread);
        }
        ((InputStream)is).close();
        ((OutputStream)os).close();
    }

    public static void copyFiles(String directory, String destination, String fileNamePrefix, String fileNameSuffix) throws FileNotFoundException, IOException {
        Copy.copyFiles(new File(directory), new File(destination), fileNamePrefix, fileNameSuffix);
    }

    public static void copyFiles(File directory, File destination, String fileNamePrefix, String fileNameSuffix) throws FileNotFoundException, IOException {
        if (directory.isDirectory()) {
            boolean ret;
            if (!destination.exists() && !(ret = destination.mkdirs())) {
                throw new IOException("error while creating target directory" + destination);
            }
            CopyFilenameFilter fileNameFilter = new CopyFilenameFilter(fileNamePrefix, fileNameSuffix);
            String[] listOfFileNames = directory.list(fileNameFilter);
            for (int i = 0; i < listOfFileNames.length; ++i) {
                Copy.copyFile(new File(directory, listOfFileNames[i]), new File(destination, listOfFileNames[i]));
            }
        }
    }

    public static boolean copyDirectory(File directory, File destination) throws FileNotFoundException, IOException {
        if (directory.isDirectory()) {
            boolean ret;
            if (!destination.exists() && !(ret = destination.mkdirs())) {
                return false;
            }
            String[] list = directory.list();
            for (int i = 0; i < list.length; ++i) {
                Copy.copyDirectory(new File(directory, list[i]), new File(destination, list[i]));
            }
        } else if (directory.isFile()) {
            Copy.copyFile(directory.getPath(), destination.getPath());
        }
        return true;
    }

    public static boolean copyDirectory(String directory, String destination) throws FileNotFoundException, IOException {
        return Copy.copyDirectory(new File(directory), new File(destination));
    }

    public static boolean deleteDirectory(File directory) throws SecurityException {
        if (directory.isDirectory()) {
            String[] list = directory.list();
            for (int i = 0; i < list.length; ++i) {
                Copy.deleteDirectory(new File(directory, list[i]));
            }
        }
        return directory.delete();
    }

    public static boolean deleteDirectory(File directory, String exception) throws SecurityException {
        if (directory.getName().equals(exception)) {
            return true;
        }
        if (directory.isDirectory()) {
            String[] list = directory.list();
            for (int i = 0; i < list.length; ++i) {
                Copy.deleteDirectory(new File(directory, list[i]), exception);
            }
        }
        return directory.delete();
    }
}

