/*
 * Decompiled with CFR 0.152.
 */
package webetk.install.utils;

import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class EnhancedTextDocument
extends PlainDocument {
    public static final int ALL_CHARACTERS = 0;
    public static final int NUMBERS_ONLY = 1;
    public static final int NUMBERS_AND_WILDCARD_ONLY = 2;
    public static final int NUMBERS_AND_POINT_ONLY = 3;
    public static final int PRICE = 4;
    public static final int SIGNED_PRICE = 5;
    public static final int NO_NUMBERS = 6;
    private int maxChars = 0;
    private int checks = 0;

    public EnhancedTextDocument(int maxCharacters) {
        this.maxChars = maxCharacters <= 0 ? 0 : maxCharacters;
        this.checks = 0;
    }

    public EnhancedTextDocument(int maxCharacters, int check) {
        int n = this.maxChars = maxCharacters <= 0 ? 0 : maxCharacters;
        if (check != 0 && check != 2 && check != 3 && check != 4 && check != 5 && check != 6 && check != 1) {
            check = 0;
            throw new IllegalArgumentException("Illegal check parameter: " + Integer.toString(check));
        }
        this.checks = check;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (str == null) {
            return;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (this.checks == 5 || this.checks == 4) {
            String sTest = super.getText(0, this.getLength());
            String sVorne = sTest.substring(0, offs);
            String sHinten = sTest.substring(offs);
            sTest = sVorne + str + sHinten;
            if (this.checkPrice(sTest)) {
                super.insertString(offs, str, a);
            } else {
                toolkit.beep();
            }
            return;
        }
        if (this.maxChars != 0 && this.getLength() + str.length() > this.maxChars) {
            toolkit.beep();
            return;
        }
        if (this.checks == 1 || this.checks == 2 || this.checks == 3 || this.checks == 4 || this.checks == 5 || this.checks == 6) {
            char[] source = str.toCharArray();
            char[] result = new char[source.length];
            int j = 0;
            for (int i = 0; i < result.length; ++i) {
                if (Character.isDigit(source[i]) && this.checks == 1 || !Character.isDigit(source[i]) && this.checks == 6 || Character.isDigit(source[i]) && this.checks == 2 || Character.isDigit(source[i]) && this.checks == 3 || source[i] == '*' && this.checks == 2 || source[i] == '.' && this.checks == 3) {
                    result[j++] = source[i];
                    continue;
                }
                toolkit.beep();
            }
            super.insertString(offs, new String(result, 0, j), a);
        } else {
            super.insertString(offs, str, a);
        }
    }

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (this.checks == 5 || this.checks == 4) {
            String sTest = super.getText(0, this.getLength());
            String sVorne = sTest.substring(0, offs);
            String sHinten = sTest.substring(offs + len);
            sTest = sVorne + sHinten;
            if (!this.checkPrice(sTest)) {
                toolkit.beep();
                return;
            }
        }
        super.remove(offs, len);
    }

    protected boolean checkPrice(String sTest) {
        if (sTest.length() == 0) {
            return true;
        }
        if (sTest.length() == 1) {
            char chTest = sTest.charAt(0);
            return Character.isDigit(chTest) || chTest == '.' || this.checks == 5 && (chTest == '+' || chTest == '-');
        }
        if (this.checks != 5 && (sTest.lastIndexOf("+") > 0 || sTest.lastIndexOf("-") > 0)) {
            return false;
        }
        try {
            double dTest = Double.parseDouble(sTest);
            if (dTest == 0.0) {
                return true;
            }
            int nKommaPos = sTest.indexOf(".");
            if (nKommaPos > -1 && nKommaPos < sTest.length() - 3) {
                return false;
            }
            return !(this.checks == 5 && sTest.indexOf("+") < 0 && sTest.indexOf("-") < 0 ? nKommaPos > this.maxChars - 4 || nKommaPos < 0 && sTest.length() > this.maxChars - 4 : nKommaPos > this.maxChars - 3 || nKommaPos < 0 && sTest.length() > this.maxChars - 3);
        }
        catch (Exception ex) {
            return false;
        }
    }
}

