/*
 * Decompiled with CFR 0.152.
 */
package webetk.install.utils;

import java.awt.Image;
import java.net.URL;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class ImageCache {
    private HashMap images = new HashMap();
    private HashMap icons = new HashMap();
    private static ImageCache instance;
    private static final String PREFIX = "/webetk/images/";

    protected ImageCache() {
    }

    public static ImageCache getInstance() {
        if (instance == null) {
            instance = new ImageCache();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getImage(String name) {
        try {
            HashMap hashMap = this.images;
            synchronized (hashMap) {
                Object o = this.images.get(name);
                if (o == null) {
                    URL url = ImageCache.class.getResource(PREFIX + name);
                    Image img = null;
                    try {
                        ImageIcon icon = new ImageIcon(url);
                        img = icon.getImage();
                    }
                    catch (NullPointerException nex) {
                        // empty catch block
                    }
                    this.images.put(name, img);
                    return img;
                }
                return (Image)o;
            }
        }
        catch (Throwable t) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Icon getIcon(String name) {
        try {
            HashMap hashMap = this.icons;
            synchronized (hashMap) {
                Object o = this.icons.get(name);
                if (o == null) {
                    URL url = ImageCache.class.getResource(PREFIX + name);
                    ImageIcon icon = new ImageIcon(url);
                    this.icons.put(name, icon);
                    return icon;
                }
                return (Icon)o;
            }
        }
        catch (Throwable t) {
            return null;
        }
    }
}

