/*
 * Decompiled with CFR 0.152.
 */
package webetk.install.utils;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import javax.swing.JPanel;
import webetk.install.lookandfeel.UIHelper;

public class LineBreakPanel
extends JPanel {
    private LineBreakMeasurer lineMeasurer;
    private int paragraphStart;
    private int paragraphEnd;
    private int mnZeilenabstand = 10;
    private static final FontRenderContext DEFAULT_FRC = new FontRenderContext(null, false, false);

    public LineBreakPanel(String text) {
        AttributedString aString = new AttributedString(text, UIHelper.getNormalFont().getAttributes());
        AttributedCharacterIterator paragraph = aString.getIterator();
        this.paragraphStart = paragraph.getBeginIndex();
        this.paragraphEnd = paragraph.getEndIndex();
        this.lineMeasurer = new LineBreakMeasurer(paragraph, DEFAULT_FRC);
    }

    public void setZeilenabastand(int nZeilenabstand) {
        this.mnZeilenabstand = nZeilenabstand;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D graphics2D = (Graphics2D)g;
        Dimension size = this.getSize();
        float formatWidth = (float)size.width - 10.0f;
        float drawPosY = 0.0f;
        this.lineMeasurer.setPosition(this.paragraphStart);
        while (this.lineMeasurer.getPosition() < this.paragraphEnd) {
            TextLayout layout = this.lineMeasurer.nextLayout(formatWidth);
            float drawPosX = layout.isLeftToRight() ? 0.0f : formatWidth - layout.getAdvance();
            layout.draw(graphics2D, drawPosX, drawPosY += layout.getAscent());
            drawPosY += layout.getDescent() + layout.getLeading();
            drawPosY += (float)this.mnZeilenabstand;
        }
    }
}

