/*
 * Decompiled with CFR 0.152.
 */
package rasterviewer;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import rasterviewer.ImageViewerComponent;

public class DefaultToolbar
extends JToolBar {
    private static final long serialVersionUID = 1L;
    ImageViewerComponent m_viewerComponent;
    JToggleButton m_butNavigator;
    JToggleButton m_butHotspots;
    JToggleButton m_butHotspotRollover;

    public DefaultToolbar(ImageViewerComponent panel) {
        this.setPanel(panel);
        AbstractAction zoom100percent = new AbstractAction("100%"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DefaultToolbar.this.m_viewerComponent.zoom100percent();
            }
        };
        JButton m_butZoom100percent = new JButton(zoom100percent);
        m_butZoom100percent.setIcon(new ImageIcon(this.getClass().getResource("1to1.gif")));
        m_butZoom100percent.setText(null);
        this.add(m_butZoom100percent);
        AbstractAction zoomFit = new AbstractAction("Fit"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DefaultToolbar.this.m_viewerComponent.zoomFit();
            }
        };
        JButton m_butZoomFit = new JButton(zoomFit);
        m_butZoomFit.setIcon(new ImageIcon(this.getClass().getResource("winscale.gif")));
        m_butZoomFit.setText(null);
        this.add(m_butZoomFit);
        AbstractAction move = new AbstractAction("Move"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DefaultToolbar.this.m_viewerComponent.moveMode();
            }
        };
        JToggleButton m_butMove = new JToggleButton(move);
        m_butMove.setIcon(new ImageIcon(this.getClass().getResource("move.gif")));
        m_butMove.setText(null);
        this.add(m_butMove);
        AbstractAction zoom = new AbstractAction("Zoom"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DefaultToolbar.this.m_viewerComponent.zoomMode();
            }
        };
        JToggleButton m_butZoom = new JToggleButton(zoom);
        m_butZoom.setIcon(new ImageIcon(this.getClass().getResource("zoom.gif")));
        m_butZoom.setText(null);
        m_butZoom.setRolloverEnabled(true);
        this.add(m_butZoom);
        zoom.actionPerformed(new ActionEvent(this, 1001, ""));
        m_butZoom.setSelected(true);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(m_butMove);
        buttonGroup.add(m_butZoom);
        AbstractAction hotspots = new AbstractAction("Show hotspots"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DefaultToolbar.this.m_viewerComponent.showHotspots(DefaultToolbar.this.m_butHotspots.isSelected());
            }
        };
        this.m_butHotspots = new JToggleButton(hotspots);
        this.m_butHotspots.setRolloverEnabled(true);
        this.add(this.m_butHotspots);
        AbstractAction hotspotsRollover = new AbstractAction("hotspotRollover"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DefaultToolbar.this.m_viewerComponent.showHotspotRollover(DefaultToolbar.this.m_butHotspotRollover.isSelected());
            }
        };
        this.m_butHotspotRollover = new JToggleButton(hotspotsRollover);
        this.m_butHotspotRollover.setRolloverEnabled(true);
        this.add(this.m_butHotspotRollover);
        final JComboBox<String> comboQuality = new JComboBox<String>(new String[]{"Schnell", "Gut", "Beste"});
        comboQuality.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int quality = comboQuality.getSelectedIndex() + 1;
                DefaultToolbar.this.m_viewerComponent.setRenderQuality(quality);
                DefaultToolbar.this.m_viewerComponent.refresh();
            }
        });
        this.add(comboQuality);
        this.setFloatable(false);
    }

    public ImageViewerComponent getPanel() {
        return this.m_viewerComponent;
    }

    public void setPanel(ImageViewerComponent m_panel) {
        this.m_viewerComponent = m_panel;
    }
}

