/*
 * Decompiled with CFR 0.152.
 */
package rasterviewer;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import javax.swing.JPanel;
import rasterviewer.ImageSizeInfo;
import rasterviewer.ImageViewerComponent;
import rasterviewer.hotspot.IHotspot;
import rasterviewer.hotspot.IHotspotManager;

public class ImageRendererPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    ImageViewerComponent parent;
    private Thumbnail thumbnail;
    private boolean imageSizeIs100percent = false;
    private Image img;
    private boolean showHotspots = false;
    private IHotspotManager hotspotMgr;
    private Color frameColor = new Color(0, 0, 255, 255);
    private Color fillColor = new Color(255, 255, 0, 128);
    private static final int ZOOM_FIT = 1;
    private static final int ZOOM_SHOW_COORDINATES = 2;
    private static final int ZOOM_100_PERCENT = 3;
    private static final int ZOOM_FILL = 4;
    private int currentMode = 1;
    private int imageWidth;
    private int imageHeight;
    private boolean rubberbandFirstTime = false;
    private int lastStartX;
    private int lastStartY;
    private int lastEndX;
    private int lastEndY;
    private int renderQuality = 1;
    private boolean isResizingHint = false;
    private int xStart;
    private int yStart;
    private int xEnd;
    private int yEnd;
    private String currentHotspot = null;
    private float imgSpLx;
    private float imgSpLy;
    private float imgSpSx;
    private float imgSpSy;
    private Color backgroundColor;
    int oldHSize = -1;
    int oldVSize = -1;

    @Override
    public void paint(Graphics g) {
        this.paintBackground((Graphics2D)g);
        if (this.currentMode == 1) {
            this.paintZoomFit((Graphics2D)g);
        } else if (this.currentMode == 4) {
            this.paintZoomFill((Graphics2D)g);
        } else if (this.currentMode == 2) {
            this.paintZoomCoordinates((Graphics2D)g);
        } else if (this.currentMode == 3) {
            this.paintZoom100Percent((Graphics2D)g);
        }
        if (this.currentHotspot != null) {
            Iterator<IHotspot> it = this.hotspotMgr.getHotspotIterator();
            while (it.hasNext()) {
                IHotspot hs = it.next();
                if (!hs.getID().equals(this.currentHotspot)) continue;
                this.showHotspot(g, hs);
            }
        }
        if (this.showHotspots) {
            this.paintAllHotspots(g);
        }
        this.recalcScrollbar();
    }

    public void paintBackground(Graphics2D g2d) {
        g2d.setColor(this.backgroundColor);
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    protected void drawImage(Graphics2D g, int imgStartX, int imgStartY, int imgEndX, int imgEndY) {
        Graphics2D g2d = g;
        g2d.setComposite(AlphaComposite.Src);
        switch (this.renderQuality) {
            case 1: {
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
                break;
            }
            case 2: {
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
                break;
            }
            case 3: {
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                break;
            }
            default: {
                throw new RuntimeException("Rendering quality must be one of QUALITY_FASTEST, QUALITY_GOOD, QUALITY_BEST");
            }
        }
        this.xStart = imgStartX;
        this.yStart = imgStartY;
        this.xEnd = imgEndX;
        this.yEnd = imgEndY;
        int newHSize = imgEndX - imgStartX;
        int newVSize = imgEndY - imgStartY;
        if (this.imageSizeIs100percent) {
            g.drawImage(this.img, this.xStart, this.yStart, this.xEnd, this.yEnd, 0, 0, this.imageWidth, this.imageHeight, null);
        } else if (this.thumbnail != null && this.thumbnail.isThumbnailReady(newHSize, newVSize)) {
            g.drawImage(this.thumbnail.getThumbnail(), this.xStart, this.yStart, null);
        } else {
            g.drawImage(this.img, this.xStart, this.yStart, this.xEnd, this.yEnd, 0, 0, this.imageWidth, this.imageHeight, null);
        }
        this.imgSpLx = this.getImageSpaceCoordinateX(0);
        this.imgSpLy = this.getImageSpaceCoordinateY(0);
        this.imgSpSx = this.getImageSpaceCoordinateX(this.parent.getRendererWidthWithScrollbars());
        this.imgSpSy = this.getImageSpaceCoordinateY(this.parent.getRendererHeightWithScrollbars());
    }

    protected void paintZoomFill(Graphics2D g) {
        float xRatio;
        if (this.img == null) {
            return;
        }
        int width = this.parent.getRendererWidthNoScrollbars();
        int height = this.parent.getRendererHeightNoScrollbars();
        float yRatio = (float)height / (float)this.imageHeight;
        if (yRatio > (xRatio = (float)width / (float)this.imageWidth)) {
            int yHeight = Math.round(xRatio * (float)this.imageHeight);
            int yOffset = height - yHeight;
            this.drawImage(g, 0, yOffset / 2, width, yOffset / 2 + yHeight);
        } else {
            int xWidth = Math.round(yRatio * (float)this.imageWidth);
            int xOffset = width - xWidth;
            this.drawImage(g, xOffset / 2, 0, xOffset / 2 + xWidth, height);
        }
    }

    protected void paintZoomFit(Graphics2D g) {
        if (this.img == null) {
            return;
        }
        int width = this.parent.getRendererWidthNoScrollbars();
        int height = this.parent.getRendererHeightNoScrollbars();
        if (this.imageWidth <= width && this.imageHeight <= height) {
            int xDiff = width - this.imageWidth;
            int yDiff = height - this.imageHeight;
            this.drawImage(g, xDiff / 2, yDiff / 2, xDiff / 2 + this.imageWidth, yDiff / 2 + this.imageHeight);
        } else {
            float xRatio = (float)width / (float)this.imageWidth;
            float yRatio = (float)height / (float)this.imageHeight;
            if (xRatio < yRatio) {
                int yHeight = Math.round(xRatio * (float)this.imageHeight);
                int xDiff = width - this.imageWidth;
                if (xDiff < 0) {
                    xDiff = 0;
                }
                int yOffset = height - yHeight;
                this.drawImage(g, xDiff / 2, yOffset / 2, xDiff / 2 + width, yOffset / 2 + yHeight);
            } else {
                int xWidth = Math.round(yRatio * (float)this.imageWidth);
                int yDiff = height - this.imageHeight;
                if (yDiff < 0) {
                    yDiff = 0;
                }
                int xOffset = width - xWidth;
                this.drawImage(g, xOffset / 2, yDiff / 2, xOffset / 2 + xWidth, yDiff / 2 + height);
            }
        }
    }

    protected void paintZoom100Percent(Graphics2D g) {
        if (this.img == null) {
            return;
        }
        this.drawImage(g, 0, 0, this.imageWidth, this.imageHeight);
    }

    protected void paintZoomCoordinates(Graphics2D g) {
        if (this.xStart < 0 || this.yStart < 0 || this.xEnd > this.parent.getRendererWidthNoScrollbars() || this.yEnd > this.parent.getRendererHeightNoScrollbars()) {
            if (!this.parent.isScrollbarsVisible()) {
                this.parent.setScrollbarsVisible(true);
            }
        } else {
            this.parent.setScrollbarsVisible(false);
        }
        this.drawImage(g, this.xStart, this.yStart, this.xEnd, this.yEnd);
    }

    public void setImage(Image img) {
        this.img = img;
        this.thumbnail = new Thumbnail(img, this);
        this.imageWidth = img.getWidth(null);
        this.imageHeight = img.getHeight(null);
    }

    public void zoomFit() {
        this.imageSizeIs100percent = false;
        this.currentMode = 1;
        this.repaint();
    }

    public void zoomFillscreen() {
        this.currentMode = 4;
        this.repaint();
    }

    public void zoomIn(int mouseStartX, int mouseStartY, int mouseEndX, int mouseEndY) {
        int t;
        if (Math.abs(mouseStartX - mouseEndX) < 2 || Math.abs(mouseStartY - mouseEndY) < 2) {
            return;
        }
        if (mouseStartX > mouseEndX) {
            t = mouseStartX;
            mouseStartX = mouseEndX;
            mouseEndX = t;
        }
        if (mouseStartY > mouseEndY) {
            t = mouseStartY;
            mouseStartY = mouseEndY;
            mouseEndY = t;
        }
        float w = mouseEndX - mouseStartX;
        float h = mouseEndY - mouseStartY;
        float ar = w / h;
        System.out.println("zoomIn Scrollbars notwendig");
        float sw = this.parent.getRendererWidthWithScrollbars();
        float sh = this.parent.getRendererHeightWithScrollbars();
        boolean scrollbarsNeeded = true;
        float ar2 = sw / sh;
        if (ar < ar2) {
            int iw = Math.round(h * ar2);
            mouseEndX = mouseStartX + iw;
        } else if (ar > ar2) {
            int ih = Math.round(w / ar2);
            mouseEndY = mouseStartY + ih;
        }
        this.imgSpLx = this.getImageSpaceCoordinateX(mouseStartX);
        this.imgSpLy = this.getImageSpaceCoordinateY(mouseStartY);
        if (scrollbarsNeeded) {
            System.out.println("zoomIn scrollbarsNeeded");
            this.imgSpSx = this.getImageSpaceCoordinateX(mouseEndX);
            this.imgSpSy = this.getImageSpaceCoordinateY(mouseEndY);
        }
        this.recalcScreenCoordinatesFromImagesCoordinatesCompletely();
        float tx = this.getScreenSpaceCoordinateX(this.imgSpSx);
        float ty = this.getScreenSpaceCoordinateY(this.imgSpSy);
        System.out.println("tx: " + tx + " " + this.parent.getRendererWidthWithScrollbars());
        System.out.println("ty: " + ty + " " + this.parent.getRendererHeightWithScrollbars());
        float tx2 = this.getImageSpaceCoordinateX(this.parent.getRendererWidthWithScrollbars());
        float ty2 = this.getImageSpaceCoordinateY(this.parent.getRendererHeightWithScrollbars());
        System.out.println("tx2: " + tx2 + " " + this.imgSpSx);
        System.out.println("ty2: " + ty2 + " " + this.imgSpSy);
        this.currentMode = 2;
        this.repaint();
    }

    public void moveImgSpace(float imgLx, float imgLy) {
        int imgDiffX = Math.round(this.getScreenSpaceCoordinateX(imgLx) - this.getScreenSpaceCoordinateX(this.imgSpLx));
        int imgDiffY = Math.round(this.getScreenSpaceCoordinateY(imgLy) - this.getScreenSpaceCoordinateY(this.imgSpLy));
        this.moveImage(-imgDiffX, -imgDiffY);
    }

    public void zoom100percent() {
        this.imageSizeIs100percent = true;
        this.currentMode = 3;
        this.repaint();
    }

    public void initRubberband() {
        this.rubberbandFirstTime = true;
    }

    public void drawRubberBand(int mouseStartX, int mouseStartY, int mouseEndX, int mouseEndY, boolean lastDraw) {
        Graphics2D g = (Graphics2D)this.getGraphics();
        if (!this.rubberbandFirstTime) {
            g.setXORMode(Color.white);
            this.drawRect(g, this.lastStartX, this.lastStartY, 1 + this.lastEndX - this.lastStartX, 1 + this.lastEndY - this.lastStartY);
        }
        if (!lastDraw) {
            g.setXORMode(Color.white);
            this.drawRect(g, mouseStartX, mouseStartY, 1 + mouseEndX - mouseStartX, 1 + mouseEndY - mouseStartY);
        }
        this.lastStartX = mouseStartX;
        this.lastStartY = mouseStartY;
        this.lastEndX = mouseEndX;
        this.lastEndY = mouseEndY;
        this.rubberbandFirstTime = false;
        g.setPaintMode();
    }

    private void drawRect(Graphics g, int lx, int ly, int hx, int hy) {
        if (hx < 0) {
            lx += hx;
            hx = -hx;
        }
        if (hy < 0) {
            ly += hy;
            hy = -hy;
        }
        g.drawRect(lx, ly, hx, hy);
    }

    public void moveImage(int x, int y) {
        float ix = -this.getImageSpaceSize(x);
        float iy = -this.getImageSpaceSize(y);
        boolean normalMove = true;
        if (normalMove) {
            this.imgSpLx += ix;
            this.imgSpSx += ix;
            this.imgSpLy += iy;
            this.imgSpSy += iy;
        }
        this.currentMode = 2;
        this.recalcScreenCoordinatesFromImagesCoordinatesMove();
        this.repaint();
    }

    protected void recalcScrollbar() {
        int width;
        int height;
        ImageSizeInfo e = new ImageSizeInfo(this, 2000);
        boolean scrollbars = false;
        if (this.yStart >= 0 && this.yEnd <= this.parent.getRendererHeightNoScrollbars()) {
            height = this.parent.getRendererHeightNoScrollbars();
        } else {
            scrollbars = true;
            height = this.parent.getRendererHeightWithScrollbars();
        }
        if (this.xStart >= 0 && this.xEnd <= this.parent.getRendererWidthNoScrollbars()) {
            width = this.parent.getRendererWidthNoScrollbars();
        } else {
            scrollbars = true;
            width = this.parent.getRendererWidthWithScrollbars();
        }
        e.setYMin(this.yStart);
        e.setYMax(this.yEnd);
        e.setYExtent(this.getHeight());
        e.setYValue(0);
        e.setXMin(this.xStart);
        e.setXMax(this.xEnd);
        e.setXExtent(this.getWidth());
        e.setXValue(0);
        e.setImgLx(this.imgSpLx);
        e.setImgLy(this.imgSpLy);
        if (scrollbars) {
            e.setImgHx(this.imgSpSx);
            e.setImgHy(this.imgSpSy);
        } else {
            float hx = this.getImageSpaceCoordinateX(width);
            float hy = this.getImageSpaceCoordinateY(height);
            e.setImgHx(hx);
            e.setImgHy(hy);
        }
        this.parent.imageSizeChanged(e);
    }

    public void showHotspot(Graphics g, IHotspot hs) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setComposite(AlphaComposite.SrcOver);
        float lx = this.getScreenSpaceCoordinateX(hs.getShape().x);
        float ly = this.getScreenSpaceCoordinateY(hs.getShape().y);
        float hx = this.getScreenSpaceCoordinateX(hs.getShape().x + hs.getShape().width);
        float hy = this.getScreenSpaceCoordinateY(hs.getShape().y + hs.getShape().height);
        Rectangle2D.Float rect = new Rectangle2D.Float();
        rect.setFrameFromDiagonal(lx, ly, hx, hy);
        if (this.fillColor != null) {
            g2d.setPaint(this.fillColor);
            g2d.fill(rect);
        }
        if (this.frameColor != null) {
            g2d.setPaint(this.frameColor);
            g2d.draw(rect);
        }
    }

    public int getRenderQuality() {
        return this.renderQuality;
    }

    public void setRenderQuality(int renderQuality) {
        this.renderQuality = renderQuality;
    }

    public ImageRendererPanel(ImageViewerComponent parent) {
        this.setDoubleBuffered(false);
        this.setOpaque(true);
        this.parent = parent;
    }

    public int getCurrentMode() {
        return this.currentMode;
    }

    public Color getHotspotFillColor() {
        return this.fillColor;
    }

    public Color getHotspotFrameColor() {
        return this.frameColor;
    }

    public void setHotspotFillColor(Color fillColor) {
        this.fillColor = fillColor;
    }

    public void setHotspotFrameColor(Color frameColor) {
        this.frameColor = frameColor;
    }

    public void showHotspots(boolean doShow) {
        this.showHotspots = doShow;
    }

    public void paintAllHotspots(Graphics g) {
        Iterator<IHotspot> it = this.hotspotMgr.getHotspotIterator();
        while (it.hasNext()) {
            IHotspot hs = it.next();
            this.showHotspot(g, hs);
        }
    }

    public void setHotspotManager(IHotspotManager mgr) {
        this.hotspotMgr = mgr;
    }

    public void onResize(int newSizeX, int newSizeY, int oldSizeX, int oldSizeY) {
        if (this.currentMode == 2) {
            this.imgSpSx = this.getImageSpaceCoordinateX(this.parent.getRendererWidthWithScrollbars());
            this.imgSpSy = this.getImageSpaceCoordinateY(this.parent.getRendererHeightWithScrollbars());
        }
    }

    protected void recalcScreenCoordinatesFromImagesCoordinatesCompletely() {
        this.xStart = Math.round(this.getScreenSpaceCoordinateX(0.0f));
        this.yStart = Math.round(this.getScreenSpaceCoordinateY(0.0f));
        this.xEnd = Math.round(this.getScreenSpaceCoordinateX(this.imageWidth));
        this.yEnd = Math.round(this.getScreenSpaceCoordinateY(this.imageHeight));
    }

    protected void recalcScreenCoordinatesFromImagesCoordinatesPartially() {
    }

    protected void recalcScreenCoordinatesFromImagesCoordinatesMove() {
        int w = this.xEnd - this.xStart;
        int h = this.yEnd - this.yStart;
        this.xStart = Math.round(this.getScreenSpaceCoordinateX(0.0f));
        this.yStart = Math.round(this.getScreenSpaceCoordinateY(0.0f));
        this.xEnd = this.xStart + w;
        this.yEnd = this.yStart + h;
    }

    protected float getImageSpaceCoordinateX(int mouseX) {
        int realOffset = mouseX - this.xStart;
        float realCoordinate = (float)realOffset * (float)this.imageWidth / (float)(this.xEnd - this.xStart);
        return realCoordinate;
    }

    protected float getImageSpaceCoordinateY(int mouseY) {
        float start = this.yStart;
        float end = this.yEnd;
        float realOffset = (float)mouseY - start;
        float realCoordinate = realOffset * (float)this.imageHeight / (end - start);
        return realCoordinate;
    }

    protected float getImageSpaceSize(int screenSize) {
        return (float)screenSize * (float)this.imageWidth / (float)(this.xEnd - this.xStart);
    }

    public Point2D.Float getImageSpaceCoordinates(Point2D p) {
        return new Point2D.Float(this.getImageSpaceCoordinateX((int)p.getX()), this.getImageSpaceCoordinateY((int)p.getY()));
    }

    private float getScreenSpaceCoordinateX(float imageX) {
        float offset = imageX - this.imgSpLx;
        float realCoordinate = offset * (float)this.parent.getRendererWidthWithScrollbars() / (this.imgSpSx - this.imgSpLx);
        return realCoordinate;
    }

    private float getScreenSpaceCoordinateY(float imageY) {
        float offset = imageY - this.imgSpLy;
        float realCoordinate = offset * (float)this.parent.getRendererHeightWithScrollbars() / (this.imgSpSy - this.imgSpLy);
        return realCoordinate;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setCurrentHotspot(String string) {
        this.currentHotspot = string;
    }

    public String getCurrentHotspot() {
        return this.currentHotspot;
    }

    public synchronized void setIsCurrentlyResizingHint(boolean isResizing) {
        this.isResizingHint = isResizing;
    }

    static class Thumbnail {
        private boolean threadIsRunning = false;
        private int scaledImageWidth;
        private Image image;
        private Image scaledImage = null;
        private ImageRendererPanel repaintCallback;

        public Thumbnail(Image image, ImageRendererPanel repaintCallback) {
            this.image = image;
            this.scaledImage = null;
            this.scaledImageWidth = -1;
            this.repaintCallback = repaintCallback;
        }

        public synchronized Image getThumbnail() {
            return this.scaledImage;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isThumbnailReady(final int width, final int heigth) {
            Thumbnail thumbnail = this;
            synchronized (thumbnail) {
                if (this.repaintCallback.isResizingHint) {
                    return false;
                }
                if (this.threadIsRunning) {
                    return false;
                }
                if (this.scaledImage == null || Math.abs(width - this.scaledImageWidth) > 1) {
                    Thread t = new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Image img = Thumbnail.this.image.getScaledInstance(width, heigth, 4);
                            Thumbnail thumbnail = Thumbnail.this;
                            synchronized (thumbnail) {
                                Thumbnail.this.scaledImage = img;
                                Thumbnail.this.scaledImageWidth = width;
                                Thumbnail.this.threadIsRunning = false;
                                Thumbnail.this.repaintCallback.repaint();
                            }
                        }
                    };
                    t.setPriority(1);
                    t.start();
                    return false;
                }
            }
            return true;
        }
    }
}

