/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.etk.rest;

import java.sql.SQLException;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.InvalidDataException;
import webetk.communication.command.AbstractTransferableCommand;
import webetk.communication.command.TrfAdminToolCommand;
import webetk.communication.command.TrfDateiCommand;
import webetk.communication.command.TrfFahrzeugIdCommand;
import webetk.communication.command.TrfHashMapCommand;
import webetk.communication.command.TrfImageCommand;
import webetk.communication.command.TrfMiscCommand;
import webetk.communication.command.TrfStringCommand;
import webetk.communication.command.TrfTeilelisteCommand;
import webetk.communication.command.TrfTeilesucheCommand;
import webetk.communication.command.TrfZubMarketingCommand;
import webetk.communication.command.TrfZubMiscCommand;
import webetk.communication.command.TrfZubSucheCommand;
import webetk.communication.command.TrfZubTechnischCommand;
import webetk.communication.command.TrfZubVerwaltungCommand;
import webetk.communication.transferables.Transferable;
import webetk.communication.transferables.TrfAdminTool;
import webetk.communication.transferables.TrfDatei;
import webetk.communication.transferables.TrfFahrzeugId;
import webetk.communication.transferables.TrfHashMap;
import webetk.communication.transferables.TrfImage;
import webetk.communication.transferables.TrfMisc;
import webetk.communication.transferables.TrfString;
import webetk.communication.transferables.TrfTeileliste;
import webetk.communication.transferables.TrfTeilesuche;
import webetk.communication.transferables.TrfZubMarketing;
import webetk.communication.transferables.TrfZubMisc;
import webetk.communication.transferables.TrfZubSuche;
import webetk.communication.transferables.TrfZubTechnisch;
import webetk.communication.transferables.TrfZubVerwaltung;
import webetk.javaserver.framework.SessionInfo;

public class TransferableCommandExecutor<T extends Transferable> {
    protected Logger log = Logger.getLogger(TrfZubTechnischCommand.class);

    public T executeCommand(T pTransferable, SessionInfo pSessionInfo) {
        AbstractTransferableCommand command = this.createCommandForTransferable((Transferable)pTransferable);
        command.setTransferable((Transferable)pTransferable);
        command.setEnvironment(pSessionInfo);
        try {
            this.log.debug("CommandID: " + ((Transferable)pTransferable).getCommand() + " " + pTransferable.getClass().getSimpleName());
            command.execute();
        }
        catch (InvalidDataException e) {
            ((Transferable)pTransferable).setError(e);
        }
        catch (DatabaseBusyException e) {
            ((Transferable)pTransferable).setError(e);
        }
        catch (SQLException e) {
            ((Transferable)pTransferable).setError(e);
        }
        this.log.debug("CommandID: " + ((Transferable)pTransferable).getCommand() + " " + pTransferable.getClass().getSimpleName() + " executed with errors: " + (((Transferable)pTransferable).getError() != null));
        return pTransferable;
    }

    private AbstractTransferableCommand createCommandForTransferable(Transferable pTransferable) {
        AbstractTransferableCommand command = null;
        if (pTransferable instanceof TrfAdminTool) {
            command = new TrfAdminToolCommand();
        }
        if (pTransferable instanceof TrfDatei) {
            command = new TrfDateiCommand();
        }
        if (pTransferable instanceof TrfFahrzeugId) {
            command = new TrfFahrzeugIdCommand();
        }
        if (pTransferable instanceof TrfHashMap) {
            command = new TrfHashMapCommand();
        }
        if (pTransferable instanceof TrfImage) {
            command = new TrfImageCommand();
        }
        if (pTransferable instanceof TrfMisc) {
            command = new TrfMiscCommand();
        }
        if (pTransferable instanceof TrfString) {
            command = new TrfStringCommand();
        }
        if (pTransferable instanceof TrfTeileliste) {
            command = new TrfTeilelisteCommand();
        }
        if (pTransferable instanceof TrfTeilesuche) {
            command = new TrfTeilesucheCommand();
        }
        if (pTransferable instanceof TrfZubMarketing) {
            command = new TrfZubMarketingCommand();
        }
        if (pTransferable instanceof TrfZubMisc) {
            command = new TrfZubMiscCommand();
        }
        if (pTransferable instanceof TrfZubSuche) {
            command = new TrfZubSucheCommand();
        }
        if (pTransferable instanceof TrfZubTechnisch) {
            command = new TrfZubTechnischCommand();
        }
        if (pTransferable instanceof TrfZubVerwaltung) {
            command = new TrfZubVerwaltungCommand();
        }
        return command;
    }
}

