/*
 * Decompiled with CFR 0.152.
 */
package ibaseDip.service;

import com.bmw.ibase.beans.Entry;
import com.bmw.ibase.beans.dealer.v1.Brand;
import com.bmw.ibase.beans.dealer.v1.Contract;
import com.bmw.ibase.beans.dealer.v1.DealerMasterData;
import com.bmw.ibase.beans.dealer.v1.DistributionPartner;
import com.bmw.ibase.beans.dealer.v1.Outlet;
import com.bmw.ibase.beans.wsm.DmsConfiguration;
import com.bmw.ibase.beans.wsm.Language;
import com.bmw.ibase.beans.wsm.ServiceUrl;
import com.bmw.ibase.beans.wsm.UncLink;
import ibaseDip.service.DipException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import localhost._23006.services.ispiagentservice.v1.IspiAgent;
import localhost._23006.services.ispiagentservice.v1.IspiAgentService;
import org.apache.log4j.Logger;

public class Dip {
    private static Logger log = Logger.getLogger(Dip.class);
    private static String agentUrl = "http://localhost:23006/services/IspiAgentService/v1";
    private static QName ISPIAGENTSERVICE_QNAME = new QName(agentUrl, "IspiAgentService");
    public static final String domBasicUrlKey = "domBasicUrl";
    public static final String zrUrlKey = "zrUrl";
    public static final String UNCACHED = "???";
    public static final String BROKER_REST = "abstract=rest,serviceType=Broker";
    public static final String BROKER_BINARY = "abstract=bin,serviceType=Broker";
    private static IspiAgentService ispiAgentService = null;
    private static IspiAgent ispiAgent = null;
    private DealerMasterData dealerMasterData;
    private static Dip instance;
    private HashMap<String, CachedValue> cacheMap = new HashMap(12);
    private long threshold = 0L;

    private Dip() {
    }

    public void initAgent() {
        System.out.println("initializing Agent");
        try {
            ispiAgentService = new IspiAgentService(new URL(agentUrl + "?wsdl"), ISPIAGENTSERVICE_QNAME);
            ispiAgent = ispiAgentService.getIspiAgentPort();
            Map ctx = ((BindingProvider)ispiAgent).getRequestContext();
            ctx.put("com.sun.xml.ws.transport.http.client.streaming.chunk.size", 8192);
            ctx.put("javax.xml.ws.service.endpoint.address", agentUrl);
            System.out.println("initializing Agent done...");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public static Dip getInstance() throws DipException {
        if (instance == null) {
            instance = new Dip();
        }
        return instance;
    }

    public static Dip getInstance(String thresholdMinutes) throws DipException {
        if (instance == null) {
            instance = new Dip();
        }
        instance.setCacheTreshold(thresholdMinutes);
        return instance;
    }

    public String getDefaultLanguage() {
        Language lang;
        String operationName = "getDefaultLanguage";
        String retVal = this.getCachedValue(operationName);
        if (retVal == UNCACHED && (lang = ispiAgent.getLocalLanguage()) != null) {
            retVal = lang.getId();
            this.setCachedValue(operationName, retVal);
        }
        log.info(operationName + ": " + retVal);
        return retVal;
    }

    public String getClientInstallerShare() {
        UncLink uncLink;
        String operationName = "getClientInstallerShare";
        String retVal = this.getCachedValue(operationName);
        if (retVal == UNCACHED && (uncLink = ispiAgent.getClientInstallerShare()) != null) {
            retVal = uncLink.getUncPath();
            this.setCachedValue(operationName, retVal);
        }
        log.info("path: " + retVal);
        return retVal;
    }

    public String getDmsServerUrl() {
        String operationName = "getDmsConfigurationEtk";
        String retVal = this.getCachedValue(operationName);
        if (retVal == UNCACHED) {
            DmsConfiguration dmsconfig = ispiAgent.getDmsConfigurationEtk();
            if (dmsconfig != null) {
                retVal = dmsconfig.getUrl();
                if (retVal != null && retVal != "") {
                    try {
                        new URL(retVal);
                    }
                    catch (MalformedURLException e) {
                        log.error("Fehler f\u00fcr: " + retVal + " Meldung: " + e.getLocalizedMessage());
                        retVal = null;
                    }
                } else {
                    log.warn("null erhalten von dmsconfig.getUrl()");
                }
                this.setCachedValue(operationName, retVal);
            } else {
                System.out.println("Keine DmsConfiguration erhalten");
                retVal = null;
            }
        }
        log.debug(operationName + " has url: " + retVal);
        return retVal;
    }

    public String getEtkServerName() {
        String retVal = "localhost";
        ServiceUrl url = ispiAgent.getEtkServer();
        if (url != null && !url.getIp().equals("")) {
            retVal = url.getIp();
        }
        return retVal;
    }

    public String getEtkServerUrl() {
        String retVal = "http://" + this.getEtkServerName() + ":8100/javaserver/rest";
        log.debug("return " + retVal);
        return retVal;
    }

    private DealerMasterData getDealerMasterData() {
        log.debug("getting dealerDataBean for String");
        this.dealerMasterData = ispiAgent.getDealerDataBean();
        if (this.dealerMasterData == null) {
            System.out.println("no DealerMasterData got from operation getDealerDataBean");
        }
        return this.dealerMasterData;
    }

    private DistributionPartner getDistributionPartner() {
        DistributionPartner dp = null;
        DealerMasterData dealer = this.getDealerMasterData();
        if (dealer != null) {
            dp = dealer.getDistributionPartner();
        } else {
            log.error("no DealerMasterData for op. ");
        }
        return dp;
    }

    private Outlet getOutlet() {
        Outlet outlet = null;
        DistributionPartner dp = this.getDistributionPartner();
        if (dp != null) {
            List<Outlet> outlets = dp.getOutlet();
            if (outlets.size() > 0) {
                outlet = outlets.get(0);
            } else {
                log.error("no outlets in DistributionPartner");
                System.out.println("DistributionPartner enth\u00e4lt kein outlet");
            }
        } else {
            log.error("no DistributionPartner in dealerMasterData");
            System.out.println("DealerMasterData enth\u00e4lt kein DistributionPartner");
        }
        return outlet;
    }

    public String getDistributionPartnerNumber() {
        String operationName = "getDistributionPartnerNumber";
        String retVal = this.getCachedValue(operationName);
        if (retVal == UNCACHED) {
            log.debug("getting: DistributionPartnerNumber");
            DistributionPartner dp = this.getDistributionPartner();
            if (dp != null) {
                retVal = dp.getDistributionPartnerNumber().toString();
                this.setCachedValue(operationName, retVal);
            } else {
                log.error("no DistributionPartner in dealerMasterData");
            }
        }
        log.info("getDistributionPartnerNumber: " + retVal);
        return retVal;
    }

    public String getDistributionPartnerName() {
        String operationName = "getDistributionPartnerName";
        String retVal = this.getCachedValue(operationName);
        if (retVal == UNCACHED) {
            log.debug("getting: DistributionPartnerName");
            DistributionPartner dp = this.getDistributionPartner();
            if (dp != null) {
                retVal = dp.getName();
                this.setCachedValue(operationName, retVal);
            } else {
                log.error("no DistributionPartner in dealerMasterData");
            }
        }
        log.info("getDistributionPartnerName: " + retVal);
        return retVal;
    }

    public String getOutletNumber() {
        String operationName = "getOutlet";
        String retVal = this.getCachedValue(operationName);
        if (retVal == UNCACHED) {
            log.debug("getting: " + operationName);
            Outlet outlet = this.getOutlet();
            if (outlet != null) {
                retVal = outlet.getOutletNumber().toString();
                this.setCachedValue(operationName, retVal);
            }
        }
        log.debug("received " + retVal);
        return retVal;
    }

    public String getOutletName() {
        String operationName = "getOutletName";
        String retVal = this.getCachedValue(operationName);
        if (retVal == UNCACHED) {
            log.debug("retrieve getOutletName");
            Outlet outlet = this.getOutlet();
            if (outlet != null) {
                retVal = outlet.getName();
                this.setCachedValue(operationName, retVal);
            }
        }
        log.debug("received " + retVal);
        return retVal;
    }

    public String getBrand() {
        String operationName = "getBrand";
        Outlet outlet = this.getOutlet();
        String retVal = this.getCachedValue(operationName);
        if (retVal == UNCACHED && outlet != null) {
            List<Contract> contract = outlet.getContract();
            retVal = "";
            if (contract.size() > 0) {
                for (int i = 0; i < contract.size(); ++i) {
                    Brand brand = contract.get(i).getBrand();
                    if (!this.containsBrand(retVal, brand.value())) {
                        retVal = !retVal.equals("") ? retVal + "|" + brand.value() : brand.value();
                    }
                    this.setCachedValue(operationName, retVal);
                }
            } else {
                log.error("no contract for outlet");
            }
        }
        log.debug("received " + retVal);
        return retVal;
    }

    public boolean containsBrand(String retVal, String brand) {
        String dummy = retVal;
        String testString = "";
        int beginIndex = 0;
        boolean ergebnis = false;
        while (dummy.length() > 0) {
            log.debug("ContainsBrand Dummy = " + dummy);
            log.debug("ContainsBrand IndexOf = " + dummy.indexOf(" "));
            if (dummy.indexOf(" ") != -1) {
                testString = dummy.substring(beginIndex, dummy.indexOf(" ") - 1);
                if (testString.equals(brand)) {
                    ergebnis = true;
                }
                if (dummy.length() > dummy.indexOf(" ") + 1) {
                    dummy = dummy.substring(dummy.indexOf(" ") + 1);
                    continue;
                }
                dummy = "";
                continue;
            }
            if (dummy.equals(brand)) {
                ergebnis = true;
            }
            dummy = "";
        }
        return ergebnis;
    }

    public String getCountryCode() {
        String operationName = "getCountryCode";
        String retVal = this.getCachedValue(operationName);
        if (retVal == UNCACHED) {
            retVal = ispiAgent.getCountryCode();
            this.setCachedValue(operationName, retVal);
        }
        log.info(operationName + ": " + retVal);
        return retVal;
    }

    public String getCachedValue(String operationName) {
        if (this.threshold <= 0L) {
            log.debug("caching is off completely (" + operationName + ")");
            return UNCACHED;
        }
        CachedValue cachedValue = this.cacheMap.get(operationName);
        if (cachedValue == null) {
            log.debug("cache for " + operationName + " is empty, so cache it");
            return UNCACHED;
        }
        long diffTime = new Date().getTime() - cachedValue.timeCached;
        if (diffTime > this.threshold) {
            log.debug("cached value for " + operationName + " expired, age " + diffTime + ". Please cache again");
            return UNCACHED;
        }
        log.debug("cache for " + operationName + " returns cachedValue '" + cachedValue.value + "' after " + diffTime);
        return cachedValue.value;
    }

    public void setCachedValue(String operationName, String value) {
        if (this.threshold <= 0L) {
            log.debug("caching is off. Value " + value + " not cached for " + operationName + ")");
        } else {
            CachedValue cachedValue = this.cacheMap.get(operationName);
            if (cachedValue == null) {
                log.debug("caching value '" + value + "' for: " + operationName);
                this.cacheMap.put(operationName, new CachedValue(value));
            } else {
                log.debug("cach update value '" + value + "' for: " + operationName);
                cachedValue.update();
            }
        }
    }

    public void setCacheTreshold(String minutes) {
        this.threshold = Long.parseLong(minutes) * 60000L;
        log.debug("threshold set to (millis):" + this.threshold);
    }

    public String retrieveSystemURL(String key) {
        List<ServiceUrl> lSurl = null;
        String urlString = this.getCachedValue(key);
        if (urlString == UNCACHED) {
            if (key.equals(domBasicUrlKey)) {
                lSurl = ispiAgent.findServices("ScoreBroker", BROKER_REST);
            } else if (key.equals(zrUrlKey)) {
                lSurl = ispiAgent.findServices("ScoreBroker", BROKER_BINARY);
            } else {
                log.error("unbekannter key");
                return null;
            }
            try {
                ServiceUrl surl = lSurl.get(0);
                System.out.println("AbstractType: " + surl.getAbstractType());
                System.out.println("Context: " + surl.getContext());
                System.out.println("IP: " + surl.getIp());
                System.out.println("Locale: " + surl.getLocale());
                System.out.println("Port: " + surl.getPort());
                System.out.println("Protocol: " + surl.getProtocol());
                System.out.println("Scope: " + surl.getScope());
                List<Entry> lst = surl.getAttributes().getEntry();
                for (Entry entry : lst) {
                    System.out.println("Entry (Key): " + entry.getKey());
                    System.out.println("Entry (Value): " + entry.getValue());
                }
                urlString = surl.getProtocol() + "://" + surl.getIp() + ":" + surl.getPort() + surl.getContext();
                log.error("BrokerURL: " + urlString);
                this.setCachedValue(key, urlString);
            }
            catch (Exception e) {
                log.error("Fehler beim Ermitteln der URL vom ScoreBroker", e);
                return null;
            }
        }
        return urlString;
    }

    public IspiAgent getIspiAgent() {
        return ispiAgent;
    }

    public String getAgentUrl() {
        return agentUrl;
    }

    public void setAgentUrl(String agentUrl) {
        Dip.agentUrl = agentUrl;
    }

    private class CachedValue {
        protected long timeCached = new Date().getTime();
        protected String value;

        protected CachedValue(String value) {
            this.value = value;
        }

        protected void update() {
            this.timeCached = new Date().getTime();
        }
    }
}

