/*
 * Decompiled with CFR 0.152.
 */
package webetk.app;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Vector;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.WebetkUtils;
import webetk.app.ServerGlobalObjects;
import webetk.db.dbaccess.AllgemeinDbAccess;
import webetk.fix.Constants;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class BmwNetzeInfos
implements Serializable {
    @XmlTransient
    private static final long serialVersionUID = 1L;
    @XmlTransient
    private static Logger log = Logger.getLogger(BmwNetzeInfos.class);
    private String netz_netz = null;
    private String netz_krit = null;
    private Collection<BmwNetzUrl> netzurls = new Vector<BmwNetzUrl>();
    private String proxy_name;
    private int proxy_port;
    private String proxy_user;
    private String proxy_pw;

    protected String getNetz_netz() {
        return this.netz_netz;
    }

    protected void setNetz_netz(String netz_netz) {
        this.netz_netz = netz_netz;
    }

    protected String getNetz_krit() {
        return this.netz_krit;
    }

    protected void setNetz_krit(String netz_krit) {
        this.netz_krit = netz_krit;
    }

    public Collection<BmwNetzUrl> getNetzurls() {
        return this.netzurls;
    }

    public void setNetzurls(Collection<BmwNetzUrl> netzurls) {
        this.netzurls = netzurls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info("Loading BmwNetzInfos ...");
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnectionNutzer("BmwNetzInfos_w_netz.load");
            res = AllgemeinDbAccess.loadBmwNetzNutzer(con);
            if (res != null && res.next()) {
                this.netz_netz = res.getString("Netz");
                this.netz_krit = res.getString("Krit");
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnectionNutzer(con, "BmwNetzInfos_w_netz.load");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnectionNutzer(con, "BmwNetzInfos_w_netz.load");
        try {
            con = gObj.getDBConnectionNutzer("BmwNetzInfos_w_proxy.load");
            res = AllgemeinDbAccess.loadBmwProxy(con);
            if (res != null && res.next()) {
                this.proxy_name = res.getString("ProxyName");
                this.proxy_port = res.getInt("Port");
                this.proxy_user = res.getString("UserName");
                this.proxy_pw = res.getString("Passwort");
            }
        }
        finally {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnectionNutzer(con, "BmwNetzInfos_w_proxy.load");
        }
        try {
            con = gObj.getDBConnection("BmwNetzInfos_w_netzurl.load");
            res = AllgemeinDbAccess.loadAllBmwNetzPubl(con);
            if (res != null) {
                while (res.next()) {
                    BmwNetzUrl oBmwNetzUrl = new BmwNetzUrl();
                    oBmwNetzUrl.netzurl_netz = res.getString("netzurl_netz");
                    oBmwNetzUrl.netzurl_krit = res.getString("netzurl_krit");
                    oBmwNetzUrl.netzurl_krit_textcode = res.getInt("netzurl_krit_textcode");
                    oBmwNetzUrl.netzurl_url_asap = res.getString("netzurl_url_asap");
                    oBmwNetzUrl.netzurl_asaptunnel = res.getString("netzurl_asaptunnel");
                    oBmwNetzUrl.netzurl_url_zr = res.getString("netzurl_url_zr");
                    oBmwNetzUrl.netzurl_url_dom_basic = res.getString("netzurl_url_dom_basic");
                    oBmwNetzUrl.netzurl_url_dom_options = res.getString("netzurl_url_dom_options");
                    this.netzurls.add(oBmwNetzUrl);
                }
            }
        }
        finally {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnection(con, "BmwNetzInfos_w_netzurl.load");
        }
    }

    public String getAsapUrlToContext(String sLoginKontext) {
        Constants.Mapping_LoginKontext_NetzArtKrit.NetzArtKrit oNetzArtKrit = this.getNetzArtKrit(sLoginKontext);
        return this.getBmwNetzUrl(oNetzArtKrit.netz, oNetzArtKrit.krit) != null ? this.getBmwNetzUrl(oNetzArtKrit.netz, oNetzArtKrit.krit).netzurl_url_asap : null;
    }

    public boolean isContextPreSelected(String sLoginKontext) {
        Constants.Mapping_LoginKontext_NetzArtKrit.NetzArtKrit oNetzArtKrit = this.getNetzArtKrit(sLoginKontext);
        return this.netz_netz != null && this.netz_netz.equals(oNetzArtKrit.netz) && this.netz_krit != null && this.netz_krit.equals(oNetzArtKrit.krit) || sLoginKontext.equals("ContextDcs") && this.netz_netz != null && this.netz_netz.equals(oNetzArtKrit.netz) && this.netz_krit != null && this.netz_krit.startsWith("USA");
    }

    private Constants.Mapping_LoginKontext_NetzArtKrit.NetzArtKrit getNetzArtKrit(String sLoginKontext) {
        return Constants.Mapping_LoginKontext_NetzArtKrit.LOGIN_KONTEXT_NETZ_ART_KRIT.get(sLoginKontext);
    }

    private BmwNetzUrl getBmwNetzUrl(String sNetzARt, String sNetzKrit) {
        for (BmwNetzUrl oBmwNetzUrl : this.netzurls) {
            if (oBmwNetzUrl.netzurl_netz == null || !oBmwNetzUrl.netzurl_netz.equals(sNetzARt) || oBmwNetzUrl.netzurl_krit == null || !oBmwNetzUrl.netzurl_krit.equals(sNetzKrit)) continue;
            return oBmwNetzUrl;
        }
        return null;
    }

    public boolean isAsapRequired() {
        if (this.netz_netz != null && this.netz_krit != null && !this.netz_netz.equals("INTRANET")) {
            for (BmwNetzUrl oBmwNetzUrl : this.netzurls) {
                if (oBmwNetzUrl.netzurl_netz == null || !oBmwNetzUrl.netzurl_netz.equals(this.netz_netz) || oBmwNetzUrl.netzurl_krit == null || !oBmwNetzUrl.netzurl_krit.equals(this.netz_krit)) continue;
                return oBmwNetzUrl.netzurl_asaptunnel != null && oBmwNetzUrl.netzurl_asaptunnel.equals("J");
            }
        }
        return false;
    }

    public String getProxy_name() {
        return this.proxy_name;
    }

    public void setProxy_name(String proxy_name) {
        this.proxy_name = proxy_name;
    }

    public int getProxy_port() {
        return this.proxy_port;
    }

    public void setProxy_port(int proxy_port) {
        this.proxy_port = proxy_port;
    }

    public String getProxy_user() {
        return this.proxy_user;
    }

    public void setProxy_user(String proxy_user) {
        this.proxy_user = proxy_user;
    }

    public String getProxy_pw() {
        return this.proxy_pw;
    }

    public void setProxy_pw(String proxy_pw) {
        this.proxy_pw = proxy_pw;
    }

    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class BmwNetzUrl
    implements Serializable {
        @XmlTransient
        private static final long serialVersionUID = 1L;
        private String netzurl_netz = null;
        private String netzurl_krit = null;
        private int netzurl_krit_textcode = -1;
        private String netzurl_url_asap = null;
        private String netzurl_asaptunnel = null;
        private String netzurl_url_zr = null;
        private String netzurl_url_dom_basic = null;
        private String netzurl_url_dom_options = null;

        protected String getNetzurl_netz() {
            return this.netzurl_netz;
        }

        protected void setNetzurl_netz(String netzurl_netz) {
            this.netzurl_netz = netzurl_netz;
        }

        protected String getNetzurl_krit() {
            return this.netzurl_krit;
        }

        protected void setNetzurl_krit(String netzurl_krit) {
            this.netzurl_krit = netzurl_krit;
        }

        protected int getNetzurl_krit_textcode() {
            return this.netzurl_krit_textcode;
        }

        protected void setNetzurl_krit_textcode(int netzurl_krit_textcode) {
            this.netzurl_krit_textcode = netzurl_krit_textcode;
        }

        protected String getNetzurl_url_asap() {
            return this.netzurl_url_asap;
        }

        protected void setNetzurl_url_asap(String netzurl_url_asap) {
            this.netzurl_url_asap = netzurl_url_asap;
        }

        protected String getNetzurl_asaptunnel() {
            return this.netzurl_asaptunnel;
        }

        protected void setNetzurl_asaptunnel(String netzurl_asaptunnel) {
            this.netzurl_asaptunnel = netzurl_asaptunnel;
        }

        protected String getNetzurl_url_zr() {
            return this.netzurl_url_zr;
        }

        protected void setNetzurl_url_zr(String netzurl_url_zr) {
            this.netzurl_url_zr = netzurl_url_zr;
        }

        protected String getNetzurl_url_dom_basic() {
            return this.netzurl_url_dom_basic;
        }

        protected void setNetzurl_url_dom_basic(String netzurl_url_dom_basic) {
            this.netzurl_url_dom_basic = netzurl_url_dom_basic;
        }

        protected String getNetzurl_url_dom_options() {
            return this.netzurl_url_dom_options;
        }

        protected void setNetzurl_url_dom_options(String netzurl_url_dom_options) {
            this.netzurl_url_dom_options = netzurl_url_dom_options;
        }
    }
}

