/*
 * Decompiled with CFR 0.152.
 */
package webetk.app;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import webetk.DatabaseBusyException;
import webetk.NoDataFoundException;
import webetk.WebetkUtils;
import webetk.app.ServerGlobalObjects;
import webetk.db.dbaccess.TechnischeLiteraturDbAccess;
import webetk.db.dbaccess.TeileSucheAssDbAccess;
import webetk.db.dbaccess.TeileSucheFzgDbAccess;

public class HGFGs
implements Collection {
    private boolean mbIsCurrentHG;
    private int mnPos = 0;
    private HGFGData mCurrentHGFG;
    private Collection mcExpandedHGs;
    private Collection mcHGs;
    private Hashtable mhFGs;
    private Iterator mHGIterator = null;
    private Iterator mFGIterator = null;

    public HGFGs(Collection cExpandedHGs) {
        this.mcExpandedHGs = cExpandedHGs;
        this.mcHGs = new Vector();
        this.mhFGs = new Hashtable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadHGFGs(boolean bGrafischeSuche, boolean bZentraleSuche, long lModellspalte, String sMarke, String sLanguage, String sGetriebe) throws SQLException, DatabaseBusyException {
        this.mcHGs.clear();
        this.mhFGs.clear();
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        Connection con = null;
        ResultSet resHG = null;
        ResultSet resFG = null;
        try {
            con = gObj.getDBConnection("HGFGs.loadHGFGs");
            resHG = TeileSucheFzgDbAccess.selectHGs(con, bGrafischeSuche, lModellspalte, sMarke, sLanguage);
            while (resHG != null && resHG.next()) {
                String sHg = resHG.getString("Hauptgruppe");
                String string = sGetriebe = sGetriebe == null ? "" : sGetriebe;
                if (sGetriebe.equals("A") && sHg.equals("23") || sGetriebe.equals("M") && sHg.equals("24")) continue;
                String sBenennung = resHG.getString("Benennung");
                String sGrafikId = resHG.getString("GrafikId");
                long lGrafikId = sGrafikId == null ? 0L : Long.parseLong(sGrafikId);
                String sTimestamp = resHG.getString("ModStamp");
                long lTimestamp = sTimestamp == null ? 0L : Long.parseLong(sTimestamp);
                byte[] aGrafik = null;
                if (bGrafischeSuche) {
                    aGrafik = !bZentraleSuche ? resHG.getBytes("Grafik") : WebetkUtils.ladeGrafik(sGrafikId, "T");
                }
                boolean bExpanded = this.isHGExpanded(sHg);
                HGFGData elemHG = new HGFGData(sHg, sBenennung, lGrafikId, lTimestamp, aGrafik);
                this.mcHGs.add(elemHG);
                if (!bExpanded) continue;
                resFG = TeileSucheFzgDbAccess.selectFGs(con, lModellspalte, sHg, sLanguage);
                Vector<HGFGData> cFGs = new Vector<HGFGData>();
                while (resFG != null && resFG.next()) {
                    String sFg = resFG.getString("Funktionsgruppe");
                    sBenennung = resFG.getString("Benennung");
                    HGFGData elemFG = new HGFGData(sHg, sFg, sBenennung);
                    cFGs.add(elemFG);
                }
                this.mhFGs.put(sHg, cFGs);
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(resHG);
            WebetkUtils.closeQuery(resFG);
            gObj.freeDBConnection(con, "HGFGs.loadHGFGs");
            throw throwable;
        }
        WebetkUtils.closeQuery(resHG);
        WebetkUtils.closeQuery(resFG);
        gObj.freeDBConnection(con, "HGFGs.loadHGFGs");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAllHGFGs(boolean bGrafischeSuche, long lModellspalte, String sMarke, String sLanguage, String sGetriebe) throws NoDataFoundException, SQLException, DatabaseBusyException {
        this.mcHGs.clear();
        this.mhFGs.clear();
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        Connection con = null;
        ResultSet resHgFg = null;
        try {
            con = gObj.getDBConnection("HGFGs.loadAllHGFGs");
            resHgFg = TeileSucheFzgDbAccess.selectHGFGs(con, lModellspalte, sMarke, sLanguage);
            String sHgMerk = null;
            Vector<HGFGData> cFGs = null;
            while (resHgFg != null && resHgFg.next()) {
                String sHg = resHgFg.getString("Hauptgruppe");
                String string = sGetriebe = sGetriebe == null ? "" : sGetriebe;
                if (sGetriebe.equals("A") && sHg.equals("23") || sGetriebe.equals("M") && sHg.equals("24")) continue;
                String sFg = resHgFg.getString("Funktionsgruppe");
                String sBenennung = resHgFg.getString("Benennung");
                if (sHgMerk == null || !sHgMerk.equals(sHg)) {
                    if (sHgMerk != null) {
                        this.mhFGs.put(sHgMerk, cFGs);
                    }
                    sHgMerk = sHg;
                    cFGs = new Vector<HGFGData>();
                }
                if (sFg.equals("00")) {
                    HGFGData elemHG = new HGFGData(sHg, sBenennung, 0L, 0L, null);
                    this.mcHGs.add(elemHG);
                    continue;
                }
                HGFGData elemFG = new HGFGData(sHg, sFg, sBenennung);
                cFGs.add(elemFG);
            }
            this.mhFGs.put(sHgMerk, cFGs);
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(resHgFg);
            gObj.freeDBConnection(con, "HGFGs.loadAllHGFGs");
            throw throwable;
        }
        WebetkUtils.closeQuery(resHgFg);
        gObj.freeDBConnection(con, "HGFGs.loadAllHGFGs");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadHGFGs(boolean bGrafischeSuche, boolean bZentraleSuche, String sMarke, String sLanguage, String sProduktart, String sKatUmfang) throws SQLException, DatabaseBusyException {
        this.mcHGs.clear();
        this.mhFGs.clear();
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        Connection con = null;
        ResultSet resHG = null;
        ResultSet resFG = null;
        try {
            con = gObj.getDBConnection("HGFGs.loadHGFGs");
            resHG = TeileSucheAssDbAccess.selectHGs(con, bGrafischeSuche, sMarke, sProduktart, sKatUmfang, sLanguage);
            while (resHG != null && resHG.next()) {
                String sHg = resHG.getString("Hauptgruppe");
                String sBenennung = resHG.getString("Benennung");
                String sGrafikId = resHG.getString("GrafikId");
                long lGrafikId = sGrafikId == null ? 0L : Long.parseLong(sGrafikId);
                String sTimestamp = resHG.getString("ModStamp");
                long lTimestamp = sTimestamp == null ? 0L : Long.parseLong(sTimestamp);
                byte[] aGrafik = null;
                if (bGrafischeSuche) {
                    aGrafik = !bZentraleSuche ? resHG.getBytes("Grafik") : WebetkUtils.ladeGrafik(sGrafikId, "T");
                }
                boolean bExpanded = this.isHGExpanded(sHg);
                HGFGData elemHG = new HGFGData(sHg, sBenennung, lGrafikId, lTimestamp, aGrafik);
                this.mcHGs.add(elemHG);
                if (!bExpanded) continue;
                resFG = TeileSucheAssDbAccess.selectFGs(con, sMarke, sProduktart, sKatUmfang, sHg, sLanguage);
                Vector<HGFGData> cFGs = new Vector<HGFGData>();
                while (resFG != null && resFG.next()) {
                    String sFg = resFG.getString("Funktionsgruppe");
                    sBenennung = resFG.getString("Benennung");
                    HGFGData elemFG = new HGFGData(sHg, sFg, sBenennung);
                    cFGs.add(elemFG);
                }
                this.mhFGs.put(sHg, cFGs);
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(resHG);
            WebetkUtils.closeQuery(resFG);
            gObj.freeDBConnection(con, "HGFGs.loadHGFGs");
            throw throwable;
        }
        WebetkUtils.closeQuery(resHG);
        WebetkUtils.closeQuery(resFG);
        gObj.freeDBConnection(con, "HGFGs.loadHGFGs");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAllHGFGs(boolean bGrafischeSuche, String sMarke, String sLanguage, String sProduktart, String sKatUmfang) throws NoDataFoundException, SQLException, DatabaseBusyException {
        this.mcHGs.clear();
        this.mhFGs.clear();
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        Connection con = null;
        ResultSet resHgFg = null;
        try {
            con = gObj.getDBConnection("HGFGs.laodAllHGFGs");
            resHgFg = TeileSucheAssDbAccess.selectHGFGs(con, sMarke, sProduktart, sKatUmfang, sLanguage);
            String sHgMerk = null;
            Vector<HGFGData> cFGs = null;
            while (resHgFg != null && resHgFg.next()) {
                String sHg = resHgFg.getString("Hauptgruppe");
                String sFg = resHgFg.getString("Funktionsgruppe");
                String sBenennung = resHgFg.getString("Benennung");
                if (sHgMerk == null || !sHgMerk.equals(sHg)) {
                    if (sHgMerk != null) {
                        this.mhFGs.put(sHgMerk, cFGs);
                    }
                    sHgMerk = sHg;
                    cFGs = new Vector<HGFGData>();
                }
                if (sFg.equals("00")) {
                    HGFGData elemHG = new HGFGData(sHg, sBenennung, 0L, 0L, null);
                    this.mcHGs.add(elemHG);
                    continue;
                }
                HGFGData elemFG = new HGFGData(sHg, sFg, sBenennung);
                cFGs.add(elemFG);
            }
            this.mhFGs.put(sHgMerk, cFGs);
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(resHgFg);
            gObj.freeDBConnection(con, "HGFGs.loadAllHGFGs");
            throw throwable;
        }
        WebetkUtils.closeQuery(resHgFg);
        gObj.freeDBConnection(con, "HGFGs.loadAllHGFGs");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFGsFuerTL(long lModellspalte, String sMarke, String sProduktart, String sKatalogumfang, String sLanguage) throws SQLException, DatabaseBusyException {
        this.mcHGs.clear();
        this.mhFGs.clear();
        Vector<HGFGData> cFGs = new Vector<HGFGData>();
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        Connection con = null;
        ResultSet resFG = null;
        try {
            con = gObj.getDBConnection("HGFGs.loadFGsFuerTL");
            resFG = TechnischeLiteraturDbAccess.selectFGs(con, sLanguage, lModellspalte, sMarke, sProduktart, sKatalogumfang);
            boolean bFirst = true;
            while (resFG != null && resFG.next()) {
                if (bFirst) {
                    bFirst = false;
                    HGFGData elemHG = new HGFGData("01", "not relevant", -1L, 0L, null);
                    this.mcHGs.add(elemHG);
                }
                String sFg = resFG.getString("Funktionsgruppe");
                String sBenennung = resFG.getString("Benennung");
                HGFGData elemFG = new HGFGData("01", sFg, sBenennung);
                cFGs.add(elemFG);
            }
            this.mhFGs.put("01", cFGs);
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(resFG);
            gObj.freeDBConnection(con, "HGFGs.loadFGsFuerTL");
            throw throwable;
        }
        WebetkUtils.closeQuery(resFG);
        gObj.freeDBConnection(con, "HGFGs.loadFGsFuerTL");
    }

    public Collection getHGs() {
        return this.mcHGs;
    }

    public Collection getFGs(String sHG) {
        return (Collection)this.mhFGs.get(sHG);
    }

    private boolean isHGExpanded(String sHG) {
        if (this.mcExpandedHGs == null) {
            return false;
        }
        Iterator iterator = this.mcExpandedHGs.iterator();
        while (iterator.hasNext()) {
            if (!sHG.equals(iterator.next())) continue;
            return true;
        }
        return false;
    }

    public String getExpandKZ() {
        if (!this.isCurrentHG()) {
            return "";
        }
        if (this.isCurrentExpanded()) {
            return "-";
        }
        return "+";
    }

    public boolean isHeaderZeile() {
        return this.mnPos == 1 || this.mnPos % 16 == 0;
    }

    public void goFirst() throws NoDataFoundException {
        this.mHGIterator = this.mcHGs.iterator();
        this.mFGIterator = null;
        this.mnPos = 0;
        if (!this.mHGIterator.hasNext()) {
            this.mCurrentHGFG = null;
            throw new NoDataFoundException("no hg found!");
        }
        this.mCurrentHGFG = (HGFGData)this.mHGIterator.next();
        this.mbIsCurrentHG = true;
        this.mnPos = 1;
    }

    public void next() throws NoDataFoundException {
        if (this.mbIsCurrentHG) {
            if (this.isCurrentExpanded()) {
                Collection cFGs = this.getFGs(this.mCurrentHGFG.getHG());
                if (cFGs == null) {
                    throw new NoDataFoundException("No values found");
                }
                this.mFGIterator = cFGs.iterator();
                if (this.mFGIterator.hasNext()) {
                    this.mCurrentHGFG = (HGFGData)this.mFGIterator.next();
                    this.mbIsCurrentHG = false;
                    ++this.mnPos;
                } else {
                    if (this.mHGIterator.hasNext()) {
                        this.mCurrentHGFG = (HGFGData)this.mHGIterator.next();
                        this.mbIsCurrentHG = true;
                        ++this.mnPos;
                    } else {
                        this.mHGIterator = null;
                        this.mCurrentHGFG = null;
                        this.mnPos = 0;
                    }
                    this.mFGIterator = null;
                }
            } else {
                if (this.mHGIterator.hasNext()) {
                    this.mCurrentHGFG = (HGFGData)this.mHGIterator.next();
                    this.mbIsCurrentHG = true;
                    ++this.mnPos;
                } else {
                    this.mHGIterator = null;
                    this.mCurrentHGFG = null;
                    this.mnPos = 0;
                }
                this.mFGIterator = null;
            }
        } else if (this.mFGIterator.hasNext()) {
            this.mCurrentHGFG = (HGFGData)this.mFGIterator.next();
            this.mbIsCurrentHG = false;
            ++this.mnPos;
        } else {
            if (this.mHGIterator.hasNext()) {
                this.mCurrentHGFG = (HGFGData)this.mHGIterator.next();
                this.mbIsCurrentHG = true;
                ++this.mnPos;
            } else {
                this.mHGIterator = null;
                this.mCurrentHGFG = null;
                this.mnPos = 0;
            }
            this.mFGIterator = null;
        }
    }

    public boolean hasNext() throws NoDataFoundException {
        if (this.mbIsCurrentHG) {
            if (this.isCurrentExpanded()) {
                return true;
            }
            return this.mHGIterator.hasNext();
        }
        if (this.mFGIterator.hasNext()) {
            return true;
        }
        return this.mHGIterator.hasNext();
    }

    public String getCurrentHG() {
        if (this.mCurrentHGFG == null) {
            return "";
        }
        return this.mCurrentHGFG.getHG();
    }

    public String getCurrentFG() {
        if (this.mCurrentHGFG == null) {
            return "";
        }
        return this.mCurrentHGFG.getFG();
    }

    public String getCurrentHGShow() {
        if (this.mCurrentHGFG == null) {
            return "";
        }
        return this.mCurrentHGFG.getHGShow();
    }

    public String getCurrentFGShow() {
        if (this.mCurrentHGFG == null) {
            return "";
        }
        return this.mCurrentHGFG.getFGShow();
    }

    public String getCurrentName() {
        if (this.mCurrentHGFG == null) {
            return "";
        }
        return this.mCurrentHGFG.getName();
    }

    public String getCurrentGrafikId() {
        if (this.mCurrentHGFG == null) {
            return "";
        }
        long lBildId = this.mCurrentHGFG.getGrafikId();
        if (lBildId == 0L) {
            return "";
        }
        return Long.toString(lBildId);
    }

    public byte[] getCurrentGrafik() {
        if (this.mCurrentHGFG == null) {
            return null;
        }
        return this.mCurrentHGFG.getGrafik();
    }

    public String getCurrentTimestamp() {
        if (this.mCurrentHGFG == null) {
            return "";
        }
        long lTimestamp = this.mCurrentHGFG.getTimestamp();
        if (lTimestamp == 0L) {
            return "";
        }
        return Long.toString(lTimestamp);
    }

    public boolean isCurrentHG() {
        return this.mbIsCurrentHG;
    }

    public boolean isCurrentExpanded() {
        boolean bCurrentHG = this.isCurrentHG();
        if (!bCurrentHG) {
            return false;
        }
        return this.isHGExpanded(this.mCurrentHGFG.getHG());
    }

    public boolean add(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object o) {
        return this.mcHGs.contains(o);
    }

    public boolean containsAll(Collection c) {
        return this.mcHGs.containsAll(c);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        return this.toString().equals(o.toString());
    }

    @Override
    public int hashCode() {
        return this.mcHGs.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.mcHGs.isEmpty();
    }

    @Override
    public Iterator iterator() {
        return this.mcHGs.iterator();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.mcHGs.size();
    }

    @Override
    public Object[] toArray() {
        return this.mcHGs.toArray();
    }

    public Object[] toArray(Object[] a) {
        return this.mcHGs.toArray(a);
    }

    public static class HGFGData {
        private String msHG;
        private String msFG;
        private String msHGShow;
        private String msFGShow;
        private String msName;
        private long mlBildID;
        private long mlTimestamp;
        private byte[] maGrafik = null;

        public HGFGData(String sHG, String sFG, String sName) {
            this.msHG = sHG;
            this.msFG = sFG;
            this.msHGShow = "";
            this.msFGShow = sFG;
            this.msName = sName;
            this.mlBildID = 0L;
            this.mlTimestamp = 0L;
            this.maGrafik = null;
        }

        public HGFGData(String sHG, String sName, long lGrafikId, long lTimestamp, byte[] aGrafik) {
            this.msHG = sHG;
            this.msFG = null;
            this.msHGShow = sHG;
            this.msFGShow = "";
            this.msName = sName;
            this.mlBildID = lGrafikId;
            this.mlTimestamp = lTimestamp;
            this.maGrafik = aGrafik;
        }

        public String getName() {
            return this.msName;
        }

        public String getHG() {
            return this.msHG;
        }

        public String getFG() {
            return this.msFG;
        }

        public String getHGShow() {
            return this.msHGShow;
        }

        public String getFGShow() {
            return this.msFGShow;
        }

        public long getGrafikId() {
            return this.mlBildID;
        }

        public long getTimestamp() {
            return this.mlTimestamp;
        }

        public byte[] getGrafik() {
            return this.maGrafik;
        }
    }
}

