/*
 * Decompiled with CFR 0.152.
 */
package webetk.app;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TimeZone;
import java.util.Vector;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.NoDataFoundException;
import webetk.WebetkUtils;
import webetk.app.BTEBedingungsmenge;
import webetk.app.Bedingungsmenge;
import webetk.app.Bedingungswert;
import webetk.app.ServerGlobalObjects;
import webetk.app.SucheInfo;
import webetk.app.bteanzeige.Bedingung;
import webetk.app.bteanzeige.Element;
import webetk.app.bteanzeige.Obergruppe;
import webetk.db.dbaccess.BteAnzeigeDbAccess;
import webetk.db.dbaccess.TeileSucheAllgemeinDbAccess;
import webetk.framework.ServerSessionInfo;
import webetk.utils.StringUtils;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SearchBTETeile
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(SearchBTETeile.class);
    public static final int BTE = 1;
    public static final int TEIL = 2;
    public static final int BOTH = 3;
    public static final int NONE = 4;
    protected Collection<PartOrBTE> mcBTEs;
    protected Collection<PartOrBTE> mcTeile;
    protected Collection<PartOrBTE> mcBTEsFiltered;
    protected Collection<PartOrBTE> mcBTEsMarktSortiert;
    private String msID = String.valueOf(System.currentTimeMillis());
    private transient Iterator<PartOrBTE> mIteratorBTE = null;
    private transient Iterator<PartOrBTE> mIteratorTeil = null;
    private PartOrBTE mCurrentBTE = null;
    private PartOrBTE mCurrentTeil = null;
    private int mnPosBTE = 0;
    private int mnPosTeil = 0;
    private boolean mbIncludeAccessoiresBildtafeln = true;
    private String mSelPrimaerMarktIso;
    private ArrayList<String> mSelSonstigeMaerkteIsos;

    public SearchBTETeile() {
        this.mcBTEs = new ArrayList<PartOrBTE>();
        this.mcTeile = new ArrayList<PartOrBTE>();
    }

    public void addTeile(Collection<PartOrBTE> cTeile) {
        this.mcTeile.addAll(cTeile);
    }

    public void includeAccessoiresBildtafeln(boolean bIncludeAccessoiresBildtafeln) {
        this.mbIncludeAccessoiresBildtafeln = bIncludeAccessoiresBildtafeln;
    }

    public boolean includeAccessoiresBildtafeln() {
        return this.mbIncludeAccessoiresBildtafeln;
    }

    public int performSearch(SucheInfo oSucheInfo, String sLang, ServerSessionInfo oServerSessionInfo) throws SQLException, DatabaseBusyException {
        throw new RuntimeException("SearchBTETeile::performSearch");
    }

    public Collection<PartOrBTE> getBTEs() {
        if (this.mcBTEs == null || this.mcBTEs.isEmpty()) {
            return null;
        }
        return this.mcBTEs;
    }

    public void setBTEs(Collection<PartOrBTE> btes) {
        this.mcBTEs = btes;
    }

    public Collection<PartOrBTE> getBTEsMarktSortiert() {
        if (this.mcBTEsMarktSortiert == null || this.mcBTEsMarktSortiert.isEmpty()) {
            return null;
        }
        return this.mcBTEsMarktSortiert;
    }

    public void setBTEsMarktSortiert(Collection<PartOrBTE> btes) {
        this.mcBTEsMarktSortiert = btes;
    }

    public Collection<PartOrBTE> getBTEsFiltered() {
        if (this.mcBTEsFiltered == null || this.mcBTEsFiltered.isEmpty()) {
            return null;
        }
        return this.mcBTEsFiltered;
    }

    public void setBTEsFiltered(Collection<PartOrBTE> btesFiltered) {
        this.mcBTEsFiltered = btesFiltered;
    }

    public void setBTEsFiltered() {
        if (this.getBTEs() != null) {
            Iterator<PartOrBTE> iter = this.getBTEs().iterator();
            ArrayList<PartOrBTE> btesFiltered = new ArrayList<PartOrBTE>();
            while (iter.hasNext()) {
                PartOrBTE bte = iter.next();
                if (!bte.isBteBedingungRelevant3() && (bte.isBteBedingungRelevant3() || !bte.hatNachruestenRelevantBTEBedingung3())) continue;
                btesFiltered.add(bte);
            }
            if (!btesFiltered.isEmpty()) {
                this.setBTEsFiltered(btesFiltered);
            }
        }
    }

    public boolean isCurrentBTERelevant() {
        return this.mCurrentBTE.isBteBedingungRelevant3() || !this.mCurrentBTE.isBteBedingungRelevant3() && this.mCurrentBTE.hatNachruestenRelevantBTEBedingung3();
    }

    public boolean isCurrentBTERotMarkiert() {
        PartOrBTE oBte = this.mCurrentBTE;
        boolean isRotMarkiert = !oBte.isBteBedingungRelevant3() && oBte.hatNachruestenRelevantBTEBedingung3();
        return isRotMarkiert;
    }

    public boolean habenBildtafelnUngefiltertNachruestungsRelevanteBedingungen() {
        if (this.mcBTEs != null) {
            for (PartOrBTE oBte : this.mcBTEs) {
                if (oBte.isBteBedingungRelevant3() || !oBte.hatNachruestenRelevantBTEBedingung3()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean habenBildtafelnGefiltertNachruestungsRelevanteBedingungen() {
        if (this.mcBTEsFiltered != null) {
            for (PartOrBTE oBte : this.mcBTEsFiltered) {
                if (oBte.isBteBedingungRelevant3() || !oBte.hatNachruestenRelevantBTEBedingung3()) continue;
                return true;
            }
        }
        return false;
    }

    public Collection<PartOrBTE> getTeile() {
        if (this.mcTeile == null || this.mcTeile.isEmpty()) {
            return null;
        }
        return this.mcTeile;
    }

    public String isResultUnique() {
        if (this.mcTeile != null && !this.mcTeile.isEmpty()) {
            return null;
        }
        if (this.mcBTEs == null) {
            return null;
        }
        if (this.mcBTEs.size() == 1) {
            Iterator<PartOrBTE> iterator = this.mcBTEs.iterator();
            PartOrBTE resultObject = iterator.next();
            String sBtNummer = resultObject.getIdNummer();
            return sBtNummer;
        }
        return null;
    }

    public String toString() {
        return this.msID;
    }

    public boolean validiere(String sID) {
        return this.msID.equals(sID);
    }

    public void goFirstBTE() throws NoDataFoundException {
        this.mIteratorBTE = this.mcBTEsMarktSortiert.iterator();
        this.mnPosBTE = 0;
        if (!this.mIteratorBTE.hasNext()) {
            this.mCurrentBTE = null;
            throw new NoDataFoundException("no bte found!");
        }
        this.mCurrentBTE = this.mIteratorBTE.next();
        this.mnPosBTE = 1;
    }

    public void nextBTE() throws NoDataFoundException {
        if (this.mIteratorBTE.hasNext()) {
            this.mCurrentBTE = this.mIteratorBTE.next();
            ++this.mnPosBTE;
        } else {
            this.mCurrentBTE = null;
            this.mnPosBTE = 0;
        }
    }

    public boolean hasNextBTE() throws NoDataFoundException {
        return this.mIteratorBTE.hasNext();
    }

    public boolean hasCurrentBteInfo() {
        if (this.mCurrentBTE == null) {
            return false;
        }
        return this.mCurrentBTE.hasInfo();
    }

    public boolean hasCurrentBteNachruestungRelevatBTEBedingung3() {
        if (this.mCurrentBTE == null) {
            return false;
        }
        return this.mCurrentBTE.hatNachruestenRelevantBTEBedingung3();
    }

    public boolean isCurrentBteBedingungRelevant3() {
        if (this.mCurrentBTE == null) {
            return false;
        }
        return this.mCurrentBTE.isBteBedingungRelevant3();
    }

    public PartOrBTE getCurrentBte() {
        return this.mCurrentBTE;
    }

    public String getCurrentBteNummer() {
        if (this.mCurrentBTE == null) {
            return "";
        }
        return this.mCurrentBTE.getIdNummer();
    }

    public String getCurrentBteUeberschrift() {
        if (this.mCurrentBTE == null) {
            return "";
        }
        return this.mCurrentBTE.getBenennung();
    }

    public String getCurrentBteMarktIso() {
        if (this.mCurrentBTE == null) {
            return "";
        }
        if (this.mCurrentBTE.getMarktIso() == null) {
            return "";
        }
        return this.mCurrentBTE.getMarktIso();
    }

    public String getCurrentBteMarktBen() {
        if (this.mCurrentBTE == null) {
            return "";
        }
        if (this.mCurrentBTE.getMarktBen() == null) {
            return "";
        }
        return this.mCurrentBTE.getMarktBen();
    }

    public String getCurrentBteIndex() {
        if (this.mCurrentBTE == null) {
            return "0";
        }
        if (this.mnPosBTE < 10) {
            return "000" + Integer.toString(this.mnPosBTE);
        }
        if (this.mnPosBTE < 100) {
            return "00" + Integer.toString(this.mnPosBTE);
        }
        if (this.mnPosBTE < 1000) {
            return "0" + Integer.toString(this.mnPosBTE);
        }
        return Integer.toString(this.mnPosBTE);
    }

    public int getCurrentBteIndexAsInteger() {
        if (this.mCurrentBTE == null) {
            return 0;
        }
        return this.mnPosBTE;
    }

    public void goFirstTeil() throws NoDataFoundException {
        this.mIteratorTeil = this.mcTeile.iterator();
        this.mnPosTeil = 0;
        if (!this.mIteratorTeil.hasNext()) {
            this.mCurrentTeil = null;
            throw new NoDataFoundException("no part found!");
        }
        this.mCurrentTeil = this.mIteratorTeil.next();
        this.mnPosTeil = 1;
    }

    public void nextTeil() throws NoDataFoundException {
        if (this.mIteratorTeil.hasNext()) {
            this.mCurrentTeil = this.mIteratorTeil.next();
            ++this.mnPosTeil;
        } else {
            this.mCurrentTeil = null;
            this.mnPosTeil = 0;
        }
    }

    public boolean hasNextTeil() throws NoDataFoundException {
        return this.mIteratorTeil.hasNext();
    }

    public String getCurrentTeilenummer(boolean bFormatiert) {
        if (this.mCurrentTeil == null) {
            return "";
        }
        String sTemp = this.mCurrentTeil.getIdNummer();
        if (bFormatiert) {
            return WebetkUtils.formatiereTeilenummer(sTemp);
        }
        return sTemp;
    }

    public String getCurrentSachnummer(boolean bFormatiert) {
        if (this.mCurrentTeil == null) {
            return "";
        }
        String sTemp = this.mCurrentTeil.getIdNummer();
        sTemp = sTemp.substring(4);
        if (bFormatiert) {
            return sTemp.substring(0, 1) + " " + sTemp.substring(1, 4) + " " + sTemp.substring(4, 7);
        }
        return sTemp;
    }

    public boolean isCurrentTeilDiebstahlrelevant() {
        if (this.mCurrentTeil == null) {
            return false;
        }
        return this.mCurrentTeil.isDiebstahlrelevant();
    }

    public String getCurrentTeilebenennung() {
        if (this.mCurrentTeil == null) {
            return "";
        }
        return this.mCurrentTeil.getBenennung();
    }

    public String getCurrentTeilezusatz() {
        if (this.mCurrentTeil == null) {
            return "";
        }
        return this.mCurrentTeil.getZusatz();
    }

    public String getCurrentTeilekommentar() {
        if (this.mCurrentTeil == null) {
            return "";
        }
        return this.mCurrentTeil.getBenennungKommentar();
    }

    public String getCurrentTeilIndex() {
        if (this.mCurrentTeil == null) {
            return "0";
        }
        if (this.mnPosTeil < 10) {
            return "000" + Integer.toString(this.mnPosTeil);
        }
        if (this.mnPosTeil < 100) {
            return "00" + Integer.toString(this.mnPosTeil);
        }
        if (this.mnPosTeil < 1000) {
            return "0" + Integer.toString(this.mnPosTeil);
        }
        return Integer.toString(this.mnPosTeil);
    }

    public int getCurrentTeilIndexAsInteger() {
        if (this.mCurrentTeil == null) {
            return 0;
        }
        return this.mnPosTeil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PartOrBTE readResultIntoBte(ResultSet res, String sSprache, String sProduktart, PartOrBTE.PartOrBTEHelper pPartOrBTEHelper, boolean bIGDOM) throws SQLException, DatabaseBusyException {
        String sBtArt = res.getString("BildtafelArt");
        String sBtNummer = res.getString("BildtafelNr");
        String sUeberschrift = res.getString("Benennung");
        String sKommentar = res.getString("Kommentar");
        String sCPVorhanden = res.getString("CPVorhanden");
        boolean bCPVorhanden = sCPVorhanden.equals("J");
        String sBedignungKZ = res.getString("BedingungKZ");
        boolean bHasInfo = sKommentar != null || bCPVorhanden || sBedignungKZ != null;
        String sMarktIso = res.getString("MarktIso");
        String sBtType = ServerGlobalObjects.getInstance().getBtTypeForBtArt(sBtArt);
        String sMarktBenennung = null;
        if (sMarktIso != null && sMarktIso.length() != 0) {
            ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
            Connection conMB = null;
            ResultSet resMB = null;
            try {
                conMB = gObj.getDBConnection("SearchBTETeile.selectMarktBenennung");
                resMB = TeileSucheAllgemeinDbAccess.selectMarktBenennung(conMB, sSprache, sProduktart, sBtNummer);
                while (resMB != null && resMB.next()) {
                    sMarktBenennung = resMB.getString("MarktBen");
                }
            }
            catch (Throwable throwable) {
                WebetkUtils.closeQuery(resMB);
                gObj.freeDBConnection(conMB, "selectMarktBenennung");
                throw throwable;
            }
            WebetkUtils.closeQuery(resMB);
            gObj.freeDBConnection(conMB, "selectMarktBenennung");
        }
        PartOrBTE obj = new PartOrBTE(sBtType, sBtNummer, sUeberschrift, bHasInfo, sBedignungKZ, sMarktIso, sMarktBenennung, pPartOrBTEHelper, bIGDOM);
        return obj;
    }

    public static PartOrBTE readResultIntoPart(ResultSet res) throws SQLException {
        String sHG = res.getString("Hauptgruppe");
        String sUG = res.getString("Untergruppe");
        String sSachnummer = res.getString("Sachnummer");
        String sTeilenummer = sHG + sUG + sSachnummer;
        String sBenennung = res.getString("Benennung");
        String sZusatz = res.getString("Zusatz");
        String sBenennungKommentar = res.getString("BenennungKommentar");
        String sDiebstahlrelevant = res.getString("Teil_Diebstahlrelevant");
        PartOrBTE obj = new PartOrBTE(sTeilenummer, sBenennung, sZusatz, sBenennungKommentar, sDiebstahlrelevant);
        return obj;
    }

    public static PartOrBTE getPartFromResult(ResultSet res) throws SQLException {
        String sHG = res.getString("Hauptgruppe");
        String sUG = res.getString("Untergruppe");
        String sSachnummer = res.getString("Sachnummer");
        String sTeilenummer = sHG + sUG + sSachnummer;
        String sBenennung = res.getString("Benennung");
        String sZusatz = res.getString("Zusatz");
        String sBenennungKommentar = res.getString("BenennungKommentar");
        String CP_Kabelbaum = res.getString("BTZeilenAlter");
        String Pos = res.getString("Pos");
        String BTNummer = res.getString("BTNummer");
        String sDiebstahlrelevant = res.getString("Teil_Diebstahlrelevant");
        PartOrBTE obj = new PartOrBTE(sTeilenummer, sBenennung, sZusatz, sBenennungKommentar, sDiebstahlrelevant);
        if (Pos != null) {
            obj.setPos(Long.parseLong(Pos));
        } else {
            obj.setPos(0L);
        }
        if (BTNummer != null) {
            obj.setBTNummer(BTNummer);
        } else {
            obj.setBTNummer("");
        }
        if (CP_Kabelbaum != null && CP_Kabelbaum.equals("J")) {
            log.info("*** CP_Kabelbaum: " + CP_Kabelbaum);
            obj.setCP_Kabelbaum(true);
        }
        return obj;
    }

    public String getSelPrimaerMarktIso() {
        return this.mSelPrimaerMarktIso;
    }

    public void setSelPrimaerMarktIso(String selPrimaerMarktIso) {
        this.mSelPrimaerMarktIso = selPrimaerMarktIso;
    }

    public ArrayList<String> getSelSonstigeMaerkteIsos() {
        return this.mSelSonstigeMaerkteIsos;
    }

    public void setSelSonstigeMaerkteIsos(ArrayList<String> selSonstigeMaerkteIsos) {
        this.mSelSonstigeMaerkteIsos = selSonstigeMaerkteIsos;
    }

    public boolean habenBildtafelnLokaleMaerkte() {
        if (this.mcBTEs == null) {
            return false;
        }
        for (PartOrBTE bte : this.mcBTEs) {
            if (bte.getMarktIso() == null || bte.getMarktIso().length() <= 0) continue;
            return true;
        }
        return false;
    }

    public void aktualisierenBedingungen(boolean pbReset, Long plBedId, Bedingungswert poBedWert) {
        Collection<PartOrBTE> cBTEs = this.getBTEs();
        for (PartOrBTE oBTE : cBTEs) {
            if (oBTE.getPartOrBTEHelper() != null && oBTE.getPartOrBTEHelper().getBedingungsmenge() != null) {
                if (!pbReset && poBedWert != null) {
                    oBTE.getPartOrBTEHelper().getBedingungsmenge().setBedWert(plBedId, poBedWert);
                }
                if (pbReset) {
                    oBTE.getPartOrBTEHelper().getBedingungsmenge().resetWerte();
                }
            }
            try {
                if (oBTE.getBteBedingung() == null) continue;
                oBTE.mbIsBteBedingungRelevant = oBTE.auswertenBedingungenZurBTE();
            }
            catch (Exception e) {
                log.error("*** Fehler w\u00e4hrend der Aktualisierung der Bedingungen zur BTE " + oBTE.getIdNummer() + " (" + e.getMessage() + ")", e);
            }
        }
    }

    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class PartOrBTE
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @XmlElement
        private String msBtType = null;
        @XmlElement
        private String msIdNummer = null;
        @XmlElement
        private String msBenennung = null;
        @XmlElement
        private String msZusatz = null;
        @XmlElement
        private boolean CP_Kabelbaum = false;
        @XmlElement
        private long Pos;
        @XmlElement
        private String BTNummer = null;
        @XmlElement
        private String msBenennungKommentar = null;
        @XmlElement
        private String msDiebstahlrelevant = null;
        @XmlElement
        private long mlGrafikId = 0L;
        @XmlElement
        private long mlTimestamp = 0L;
        @XmlElement
        private byte[] mGrafik = null;
        @XmlElement
        private boolean mbIsBTE;
        @XmlElement
        private PartOrBTEHelper mPartOrBTEHelper = null;
        @XmlElement
        private boolean mbHasInfo;
        @XmlElement
        private Bedingung mBteBedingung = null;
        @XmlElement
        private Hashtable<String, Boolean> mhErgebnis = null;
        @XmlElement
        private boolean mbIsBteBedingungRelevant = true;
        @XmlElements(value={@XmlElement(type=Bedingung.class)})
        private ArrayList<Bedingung> mcBedingungen3 = null;
        @XmlElement
        private Hashtable<String, Boolean> mhErgebnis3 = null;
        @XmlElement
        private boolean mbIsBteBedingungRelevant3 = true;
        @XmlElement
        private BTEBedingungsmenge moBTEBedingungsmenge3 = null;
        @XmlElement
        private boolean mbHatNachruestenRelevantBTEBedingung3 = false;
        @XmlElement
        private Hashtable<String, ArrayList<String>> mhUeberBedingungen3;
        @XmlElement
        private String msBedKez = null;
        @XmlElement
        private String msMarktIso = null;
        @XmlElement
        private String msMarktBen = null;
        @XmlElements(value={@XmlElement(type=String.class)})
        Vector<String> maMarken = null;
        @XmlElement
        private boolean mbIsRotMarkiert = false;

        public PartOrBTE(String sTeilenummer, String sBenennung, String sZusatz, String sBenennungKommentar, String sDiebstahlrelevant) {
            this.mbIsBTE = false;
            this.msIdNummer = sTeilenummer;
            this.msBenennung = sBenennung;
            this.msZusatz = sZusatz;
            this.msBenennungKommentar = sBenennungKommentar;
            this.msDiebstahlrelevant = sDiebstahlrelevant;
            this.mlGrafikId = 0L;
            this.mGrafik = null;
            this.mlTimestamp = 0L;
            this.mbHasInfo = true;
            this.mBteBedingung = null;
            this.maMarken = new Vector();
            this.mbIsRotMarkiert = false;
        }

        public PartOrBTE(String sBtType, String sBteNummer, String sBteUeberschrift, boolean bHasInfo, String bedingungKZ, String sMarktIso, String sMarktBen, PartOrBTEHelper pPartOrBTEHelper, boolean bIGDOM) {
            this.mbIsBTE = true;
            this.msBtType = sBtType;
            this.msIdNummer = sBteNummer;
            this.msBenennung = sBteUeberschrift;
            this.msZusatz = null;
            this.msBenennungKommentar = null;
            this.msBedKez = bedingungKZ;
            this.mlGrafikId = 0L;
            this.mGrafik = null;
            this.mlTimestamp = 0L;
            this.mbHasInfo = bHasInfo;
            this.mbIsRotMarkiert = false;
            if (pPartOrBTEHelper != null) {
                this.setPartOrBTEHelper(pPartOrBTEHelper);
            }
            if (this.msBedKez != null && !this.msBedKez.equals("")) {
                try {
                    this.mBteBedingung = this.ladenBteBedingung(sBteNummer, this.msBedKez);
                    if (this.mBteBedingung != null) {
                        this.mbIsBteBedingungRelevant = this.auswertenBedingungenZurBTE();
                    }
                    if (this.mPartOrBTEHelper != null && this.mPartOrBTEHelper.mbAusweisungenElementeAktiv) {
                        this.ladenBedingungenFzg(sBteNummer, this.mPartOrBTEHelper.mlModellSpalte);
                        if (this.getBedingungen3() != null) {
                            this.mbIsBteBedingungRelevant3 = this.auswertenBedingungenZurBTE3(bIGDOM);
                        }
                    }
                }
                catch (SQLException e) {
                    log.error(e.getMessage(), e);
                    e.printStackTrace();
                }
                catch (DatabaseBusyException e) {
                    log.error(e.getMessage(), e);
                    e.printStackTrace();
                }
            }
            this.msMarktIso = sMarktIso;
            this.msMarktBen = sMarktBen;
            this.maMarken = new Vector();
        }

        public PartOrBTE(String sBtType, String sBteNummer, String sBteUeberschrift, long lGrafikId, long lTimestamp, byte[] Grafik2, boolean bHasInfo, String bedingungKZ, String sMarktIso, String sMarktBen, PartOrBTEHelper pPartOrBTEHelper, boolean bIGDOM) {
            this.mbIsBTE = true;
            this.msBtType = sBtType;
            this.msIdNummer = sBteNummer;
            this.msBenennung = sBteUeberschrift;
            this.msZusatz = null;
            this.msBenennungKommentar = null;
            this.msBedKez = bedingungKZ;
            this.mlGrafikId = lGrafikId;
            this.mGrafik = Grafik2;
            this.mlTimestamp = lTimestamp;
            this.mbHasInfo = bHasInfo;
            this.mbIsRotMarkiert = false;
            this.setPartOrBTEHelper(pPartOrBTEHelper);
            if (this.msBedKez != null && !this.msBedKez.equals("")) {
                try {
                    this.mBteBedingung = this.ladenBteBedingung(sBteNummer, this.msBedKez);
                    if (this.mBteBedingung != null) {
                        this.mbIsBteBedingungRelevant = this.auswertenBedingungenZurBTE();
                    }
                    if (this.mPartOrBTEHelper != null && this.mPartOrBTEHelper.mbAusweisungenElementeAktiv) {
                        this.ladenBedingungenFzg(sBteNummer, this.mPartOrBTEHelper.mlModellSpalte);
                        if (this.getBedingungen3() != null) {
                            this.mbIsBteBedingungRelevant3 = this.auswertenBedingungenZurBTE3(bIGDOM);
                        }
                    }
                }
                catch (SQLException e) {
                    log.error(e.getMessage(), e);
                    e.printStackTrace();
                }
                catch (DatabaseBusyException e) {
                    log.error(e.getMessage(), e);
                    e.printStackTrace();
                }
            }
            this.msMarktIso = sMarktIso;
            this.msMarktBen = sMarktBen;
            this.maMarken = new Vector();
        }

        public PartOrBTE() {
        }

        protected Date printDurationStart(String psFrom) {
            Date dt = new Date();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
            df.setTimeZone(TimeZone.getDefault());
            log.debug(psFrom + " " + df.format(dt));
            return dt;
        }

        protected void printDurationEnde(String psFrom, Date pDateStart) {
            Date dt = new Date();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
            df.setTimeZone(TimeZone.getDefault());
            long timeMs = dt.getTime() - pDateStart.getTime();
            log.debug(psFrom + " " + df.format(dt) + " ben\u00f6tigte Zeit in MS: " + timeMs);
        }

        protected boolean auswertenBedingungenZurBTE() throws SQLException, DatabaseBusyException {
            Date dt = this.printDurationStart("auswertenBedingungenZurBTE");
            boolean returnValue = true;
            this.mhErgebnis = null;
            this.mhErgebnis = this.mBteBedingung.auswerten();
            returnValue = this.mhErgebnis != null && !this.mhErgebnis.isEmpty();
            log.debug("QCF # 005 - Test - ALT " + this.msIdNummer + "/" + this.msBedKez + " -> mbIsBteBedingungRelevant: " + returnValue);
            log.debug("QCF # 005 - Test - ALT " + this.msIdNummer + "/" + this.msBedKez + " -> Ergebnis: " + this.mhErgebnis);
            this.printDurationEnde("auswertenBedingungenZurBTE", dt);
            return returnValue;
        }

        protected boolean auswertenBedingungenZurBTE3(boolean bIGDOM) throws SQLException, DatabaseBusyException {
            Date dt = this.printDurationStart("auswertenBedingungenZurBTE3");
            boolean returnValue = true;
            this.mhErgebnis3 = null;
            this.moBTEBedingungsmenge3 = null;
            Object copy = this.getBedingungen3().clone();
            ArrayList<Bedingung> cBedingungen = (ArrayList<Bedingung>)copy;
            cBedingungen = this.setzenAusweisungenElementeZurBTE(cBedingungen, bIGDOM);
            log.debug("QCF # 005 - Test - NEU3 " + this.msIdNummer + "/" + this.msBedKez + " -> BTE Bedingungen nach setzenAusweisungenElementeZurBTE(): " + this.getBedingungen3().toString());
            this.mhErgebnis3 = this.auswertenAusweisungenZurBTE(cBedingungen);
            if (this.mhErgebnis3 == null || this.mhErgebnis3.isEmpty() || this.copyBedingungenOhneRegelnummer(this.mhErgebnis3).get(this.mBteBedingung.getKuerzel()) == null) {
                returnValue = false;
            }
            if (this.moBTEBedingungsmenge3 != null && this.moBTEBedingungsmenge3.getBedingungsmenge() != null) {
                this.mbHatNachruestenRelevantBTEBedingung3 = this.moBTEBedingungsmenge3.getBedingungsmenge().hatNachruestenRelevantBTEBedingungen();
            }
            if (this.mbHatNachruestenRelevantBTEBedingung3 && !returnValue && this.auswertenNachruestungsRelevanteSAmitNein(cBedingungen)) {
                this.mbHatNachruestenRelevantBTEBedingung3 = false;
                returnValue = true;
            }
            this.printDurationEnde("auswertenBedingungenZurBTE3", dt);
            return returnValue;
        }

        protected Hashtable<String, Boolean> copyBedingungenOhneRegelnummer(Hashtable<String, Boolean> hBeds) {
            Hashtable<String, Boolean> hBedsNew = new Hashtable<String, Boolean>();
            Enumeration<String> en = hBeds.keys();
            while (en.hasMoreElements()) {
                String str = en.nextElement();
                String strNew = str.replaceAll("[0-9]*", "").trim();
                hBedsNew.put(strNew, hBeds.get(str));
            }
            return hBedsNew;
        }

        protected ArrayList<Bedingung> setzenAusweisungenElementeZurBTE(ArrayList<Bedingung> cBedingungen, boolean bIGDOM) throws SQLException, DatabaseBusyException {
            if (cBedingungen == null || cBedingungen.isEmpty()) {
                return cBedingungen;
            }
            if (this.getPartOrBTEHelper() != null && this.getPartOrBTEHelper().isAusweisungenElementeAktiv() && this.getPartOrBTEHelper().isVinIdentif() && this.msBtType.equals("FZG")) {
                this.moBTEBedingungsmenge3 = new BTEBedingungsmenge(this.msIdNummer, this.getPartOrBTEHelper().getModellSpalte(), this.getPartOrBTEHelper().getBedingungsmenge());
                this.moBTEBedingungsmenge3.load(this.getPartOrBTEHelper().getSprache(), false, bIGDOM, new Boolean(this.getPartOrBTEHelper().isUSATyp()), new Boolean(this.getPartOrBTEHelper().isVinIdentif()));
                for (Bedingung Bed : cBedingungen) {
                    for (Obergruppe OG : Bed.getObergruppen()) {
                        for (Element Elem : OG.getElemente()) {
                            String sWertNutzer = this.moBTEBedingungsmenge3.getBedWert(new Long(Elem.getElemId()));
                            Elem.setAusweisung(sWertNutzer);
                        }
                    }
                }
            }
            return cBedingungen;
        }

        protected Hashtable<String, Boolean> auswertenAusweisungenZurBTE(ArrayList<Bedingung> cBedingungen) {
            if (cBedingungen == null || cBedingungen.isEmpty()) {
                return null;
            }
            Hashtable<String, Boolean> hBedingungen = new Hashtable<String, Boolean>();
            for (Bedingung Bed : cBedingungen) {
                log.debug("Aufruf Bedingungsauswertung");
                Hashtable<String, Boolean> hBedingungenRelevant = Bed.auswerten();
                Enumeration<String> eBedingungenRelevant = hBedingungenRelevant.keys();
                while (eBedingungenRelevant.hasMoreElements()) {
                    String sKuerzel = eBedingungenRelevant.nextElement();
                    Boolean bVollstaendigAusgewertet = hBedingungenRelevant.get(sKuerzel);
                    hBedingungen.put(sKuerzel, bVollstaendigAusgewertet);
                }
            }
            return hBedingungen;
        }

        protected boolean auswertenNachruestungsRelevanteSAmitNein(ArrayList<Bedingung> cBedingungen) {
            if (cBedingungen == null || cBedingungen.isEmpty()) {
                return false;
            }
            log.debug("Aufruf Bedingungsauswertung Nachruestungs Relevante SA mit Nein");
            for (Bedingung Bed : cBedingungen) {
                if (!this.mBteBedingung.getKuerzel().equals(Bed.getKuerzel())) continue;
                for (Obergruppe OG : Bed.getObergruppen()) {
                    if (!OG.getVArt().equals("O") && !OG.getVArt().equals("R")) continue;
                    for (Element elem : OG.getElemente()) {
                        String sWertNutzer = this.moBTEBedingungsmenge3.getBedWert(new Long(elem.getElemId()));
                        if (!sWertNutzer.equals("1") || elem.getVorzeichen().charAt(0) != '-' || elem.getAusweisungChar() != 'F') continue;
                        return true;
                    }
                }
            }
            return false;
        }

        public boolean isRotMarkiert() {
            return this.mbIsRotMarkiert;
        }

        public void setIsRotMarkiert(boolean bIsRotMarkiert) {
            this.mbIsRotMarkiert = bIsRotMarkiert;
        }

        public Hashtable<String, String> getHashtable() {
            Hashtable<String, String> objHashtable = new Hashtable<String, String>();
            if (!this.mbIsBTE) {
                String sachnummer = this.msIdNummer.substring(4);
                objHashtable.put("Sachnummer", sachnummer);
                String teilenummer = this.msIdNummer.substring(0, 2) + " " + this.msIdNummer.substring(2, 4) + " " + this.msIdNummer.substring(4, 5) + " " + this.msIdNummer.substring(5, 8) + " " + this.msIdNummer.substring(8, 11);
                objHashtable.put("Teilenummer", teilenummer);
                objHashtable.put("Benennung", this.msBenennung);
                objHashtable.put("Zusatz", this.getZusatz());
                objHashtable.put("Kommentar", this.getBenennungKommentar());
                objHashtable.put("Diebstahlrelevant", this.getDiebstahlrelevant());
                objHashtable.put("Teilenr_und_Benennung", teilenummer + " - " + this.msBenennung);
            }
            return objHashtable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Bedingung ladenBteBedingung(String sBteNummer, String sBedKez) throws SQLException, DatabaseBusyException {
            Bedingung bed = null;
            ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
            Connection con = null;
            ResultSet res = null;
            try {
                con = gObj.getDBConnection("SearchBTETeile.ladenBTEBedingung");
                res = BteAnzeigeDbAccess.loadBteBedingungFzg(con, sBteNummer, sBedKez);
                Obergruppe OG = null;
                Element Elem = null;
                String sOgIdMerk = "";
                String sGesamtterm_VZ = null;
                String sGesamtterm = null;
                String sFZeile = null;
                int nPos = 0;
                boolean bET = false;
                boolean bFirst = true;
                while (res != null && res.next()) {
                    String sOgId;
                    if (bFirst) {
                        sGesamtterm_VZ = res.getString("GesamttermVZ");
                        sGesamtterm = res.getString("Gesamtterm");
                        bed = new Bedingung(sBedKez, sGesamtterm_VZ, sGesamtterm);
                        bFirst = false;
                    }
                    if (!sOgIdMerk.equals(sOgId = res.getString("OG"))) {
                        String sVArt = res.getString("VArt");
                        sFZeile = res.getString("FZeile");
                        OG = new Obergruppe(sOgId, sVArt, sFZeile);
                        bET = sVArt.equals("E") || sVArt.equals("B");
                        nPos = 1;
                        if (bET) {
                            bed.setAusweisung(OG.getAusweisung());
                        }
                        bed.appendObergruppe(OG);
                        sOgIdMerk = sOgId;
                    }
                    String sAusweisung = " ";
                    String sRegelzeile = null;
                    if (bET) {
                        sAusweisung = sFZeile;
                        if (sGesamtterm_VZ.equals("+")) {
                            sAusweisung = StringUtils.substituteStringStraight(sAusweisung, "X", " ");
                            sAusweisung = StringUtils.substituteStringStraight(sAusweisung, "0", "-");
                        } else {
                            sAusweisung = StringUtils.substituteStringStraight(sAusweisung, "X", "-");
                            sAusweisung = StringUtils.substituteStringStraight(sAusweisung, "0", " ");
                        }
                        int nLength = sFZeile.length();
                        sRegelzeile = "";
                        int nGrenzeA = (int)Math.pow(2.0, nPos - 1);
                        for (int i = 1; i <= nGrenzeA; ++i) {
                            int j;
                            int nPow = (int)Math.pow(2.0, nPos);
                            int nGrenzeB = nLength / nPow;
                            for (j = 1; j <= nGrenzeB; ++j) {
                                sRegelzeile = sRegelzeile + "X";
                            }
                            for (j = 1; j <= nGrenzeB; ++j) {
                                sRegelzeile = sRegelzeile + "0";
                            }
                        }
                        ++nPos;
                    }
                    String sElementVZ = res.getString("ElementVZ");
                    long lElementId = res.getLong("ElementId");
                    Elem = new Element(sElementVZ, lElementId, sRegelzeile, sAusweisung);
                    OG.appendElement(Elem);
                }
                WebetkUtils.closeQuery(res);
            }
            catch (Throwable throwable) {
                WebetkUtils.closeQuery(res);
                gObj.freeDBConnection(con, "SearchBTETeile.ladenBTEBedingung");
                throw throwable;
            }
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnection(con, "SearchBTETeile.ladenBTEBedingung");
            return bed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void ladenBedingungenFzg(String psBteNummer, long plModellSpalte) throws SQLException, DatabaseBusyException {
            if (this.getBedingungen3() == null) {
                this.setBedingungen3(new ArrayList<Bedingung>());
            } else {
                this.getBedingungen3().clear();
            }
            if (this.getUeberBedingungen3() == null) {
                this.setUeberBedingungen3(new Hashtable<String, ArrayList<String>>());
            } else {
                this.getUeberBedingungen3().clear();
            }
            ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
            Connection con = null;
            ResultSet res = null;
            try {
                con = gObj.getDBConnection("SearchBTETeile.ladenBedingungenFzg");
                res = BteAnzeigeDbAccess.loadBedingungenFzg(con, psBteNummer, plModellSpalte);
                Bedingung Bed = null;
                Obergruppe OG = null;
                Element Elem = null;
                String sKuerzelMerk = "";
                String sOgIdMerk = "";
                String sGesamtterm_VZ = null;
                String sGesamtterm = null;
                String sFZeile = null;
                int nPos = 0;
                boolean bET = false;
                while (res != null && res.next()) {
                    String sOgId;
                    String sKuerzel = res.getString("Kuerzel");
                    if (!sKuerzelMerk.equals(sKuerzel)) {
                        sGesamtterm_VZ = res.getString("GesamttermVZ");
                        sGesamtterm = res.getString("Gesamtterm");
                        Bed = new Bedingung(sKuerzel, sGesamtterm_VZ, sGesamtterm);
                        this.getBedingungen3().add(Bed);
                        sKuerzelMerk = sKuerzel;
                        sOgIdMerk = "";
                    }
                    if (!sOgIdMerk.equals(sOgId = res.getString("OG"))) {
                        String sVArt = res.getString("VArt");
                        sFZeile = res.getString("FZeile");
                        OG = new Obergruppe(sOgId, sVArt, sFZeile);
                        bET = sVArt.equals("E") || sVArt.equals("B");
                        nPos = 1;
                        if (bET) {
                            Bed.setAusweisung(OG.getAusweisung());
                        }
                        Bed.appendObergruppe(OG);
                        sOgIdMerk = sOgId;
                    }
                    String sAusweisung = " ";
                    String sRegelzeile = null;
                    if (bET) {
                        sAusweisung = sFZeile;
                        if (sGesamtterm_VZ.equals("+")) {
                            sAusweisung = StringUtils.substituteStringStraight(sAusweisung, "X", " ");
                            sAusweisung = StringUtils.substituteStringStraight(sAusweisung, "0", "-");
                        } else {
                            sAusweisung = StringUtils.substituteStringStraight(sAusweisung, "X", "-");
                            sAusweisung = StringUtils.substituteStringStraight(sAusweisung, "0", " ");
                        }
                        int nLength = sFZeile.length();
                        sRegelzeile = "";
                        int nGrenzeA = (int)Math.pow(2.0, nPos - 1);
                        for (int i = 1; i <= nGrenzeA; ++i) {
                            int j;
                            int nPow = (int)Math.pow(2.0, nPos);
                            int nGrenzeB = nLength / nPow;
                            for (j = 1; j <= nGrenzeB; ++j) {
                                sRegelzeile = sRegelzeile + "X";
                            }
                            for (j = 1; j <= nGrenzeB; ++j) {
                                sRegelzeile = sRegelzeile + "0";
                            }
                        }
                        ++nPos;
                    }
                    String sElementVZ = res.getString("ElementVZ");
                    long lElementId = res.getLong("ElementId");
                    Elem = new Element(sElementVZ, lElementId, sRegelzeile, sAusweisung);
                    OG.appendElement(Elem);
                }
                WebetkUtils.closeQuery(res);
                Iterator<Bedingung> iterator = this.getBedingungen3().iterator();
                while (iterator.hasNext()) {
                    log.debug("Zeile: " + iterator.next().toString());
                }
                res = BteAnzeigeDbAccess.loadUeberbedingungenFzg(con, psBteNummer, plModellSpalte);
                sKuerzelMerk = "";
                ArrayList<String> cUeberBed = null;
                while (res != null && res.next()) {
                    String sKuerzel = res.getString("Kuerzel");
                    String sKuerzelUeber = res.getString("KuerzelUeber");
                    if (!sKuerzelMerk.equals(sKuerzel)) {
                        cUeberBed = new ArrayList<String>();
                        cUeberBed.add(sKuerzelUeber);
                        this.getUeberBedingungen3().put(sKuerzel, cUeberBed);
                        sKuerzelMerk = sKuerzel;
                        continue;
                    }
                    cUeberBed.add(sKuerzelUeber);
                }
            }
            catch (Throwable throwable) {
                WebetkUtils.closeQuery(res);
                gObj.freeDBConnection(con, "CurrentBTE.ladenBedingungenFzg");
                throw throwable;
            }
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnection(con, "CurrentBTE.ladenBedingungenFzg");
        }

        public String getIdNummer() {
            return this.msIdNummer;
        }

        public String getIdNummerHtmlTd() {
            if (this.isBTE()) {
                if (!this.isBteBedingungRelevant3() && this.hatNachruestenRelevantBTEBedingung3()) {
                    return "<td class=\"rot\" align=\"left\">" + this.msIdNummer + "</td>";
                }
                return "<td align=\"left\">" + this.msIdNummer + "</td>";
            }
            return "";
        }

        public String getBenennung() {
            return this.msBenennung;
        }

        public String getBenennungHtmlDiv() {
            if (this.isBTE()) {
                if (!this.isBteBedingungRelevant3() && this.hatNachruestenRelevantBTEBedingung3()) {
                    return "<div class=\"rot\">" + this.msBenennung + "</div>";
                }
                return "<div>" + this.msBenennung + "</div>";
            }
            return "";
        }

        public String getZusatz() {
            if (this.msZusatz == null) {
                return "";
            }
            return this.msZusatz;
        }

        public String getBenennungKommentar() {
            if (this.msBenennungKommentar == null) {
                return "";
            }
            return this.msBenennungKommentar;
        }

        public boolean isDiebstahlrelevant() {
            if (this.msDiebstahlrelevant == null) {
                return false;
            }
            return this.msDiebstahlrelevant.equals("J");
        }

        public String getDiebstahlrelevant() {
            if (this.msDiebstahlrelevant == null) {
                return "N";
            }
            return this.msDiebstahlrelevant;
        }

        public long getGrafikId() {
            return this.mlGrafikId;
        }

        public byte[] getGrafik() {
            return this.mGrafik;
        }

        public long getTimestamp() {
            return this.mlTimestamp;
        }

        public boolean isBTE() {
            return this.mbIsBTE;
        }

        public boolean hasInfo() {
            return this.mbHasInfo;
        }

        public String getBtType() {
            return this.msBtType;
        }

        public boolean getBteBedingungRelevant() {
            return this.mbIsBteBedingungRelevant;
        }

        public void setBteBedingungRelevant(boolean mbIsRelevant) {
            this.mbIsBteBedingungRelevant = mbIsRelevant;
        }

        public String getMarktIso() {
            return this.msMarktIso;
        }

        public String getMarktBen() {
            return this.msMarktBen;
        }

        public String getMarktBenUndIso() {
            if (this.msMarktBen != null && this.msMarktBen.length() > 0 && this.msMarktIso != null && this.msMarktIso.length() > 0) {
                return this.msMarktBen + " " + this.msMarktIso;
            }
            return "";
        }

        public Vector<String> getMarken() {
            return this.maMarken;
        }

        public void addMarke(String sMarke) {
            this.maMarken.add(sMarke);
        }

        public void setPartOrBTEHelper(PartOrBTEHelper mPartOrBTEHelper) {
            this.mPartOrBTEHelper = mPartOrBTEHelper;
        }

        public PartOrBTEHelper getPartOrBTEHelper() {
            return this.mPartOrBTEHelper;
        }

        public void setIsBteBedingungRelevant3(boolean mbIsBteBedingungRelevant3) {
            this.mbIsBteBedingungRelevant3 = mbIsBteBedingungRelevant3;
        }

        public boolean isBteBedingungRelevant3() {
            return this.mbIsBteBedingungRelevant3;
        }

        public void setBteBedingung(Bedingung mBteBedingung) {
            this.mBteBedingung = mBteBedingung;
        }

        public Bedingung getBteBedingung() {
            return this.mBteBedingung;
        }

        public void setErgebnis(Hashtable<String, Boolean> mhErgebnis) {
            this.mhErgebnis = mhErgebnis;
        }

        public Hashtable<String, Boolean> getErgebnis() {
            return this.mhErgebnis;
        }

        public void setErgebnis3(Hashtable<String, Boolean> mhErgebnis3) {
            this.mhErgebnis3 = mhErgebnis3;
        }

        public Hashtable<String, Boolean> getErgebnis3() {
            return this.mhErgebnis3;
        }

        public void setBedingungen3(ArrayList<Bedingung> mcBedingungen3) {
            this.mcBedingungen3 = mcBedingungen3;
        }

        public ArrayList<Bedingung> getBedingungen3() {
            return this.mcBedingungen3;
        }

        public void setUeberBedingungen3(Hashtable<String, ArrayList<String>> mhUeberBedingungen3) {
            this.mhUeberBedingungen3 = mhUeberBedingungen3;
        }

        public Hashtable<String, ArrayList<String>> getUeberBedingungen3() {
            return this.mhUeberBedingungen3;
        }

        public void setHatNachruestenRelevantBTEBedingung3(boolean mbHatNachruestenRelevantBTEBedingung3) {
            this.mbHatNachruestenRelevantBTEBedingung3 = mbHatNachruestenRelevantBTEBedingung3;
        }

        public boolean hatNachruestenRelevantBTEBedingung3() {
            return this.mbHatNachruestenRelevantBTEBedingung3;
        }

        public void setBTEBedingungsmenge3(BTEBedingungsmenge moBTEBedingungsmenge3) {
            this.moBTEBedingungsmenge3 = moBTEBedingungsmenge3;
        }

        public BTEBedingungsmenge getBTEBedingungsmenge3() {
            return this.moBTEBedingungsmenge3;
        }

        public void setCP_Kabelbaum(boolean cP_Kabelbaum) {
            this.CP_Kabelbaum = cP_Kabelbaum;
        }

        public boolean isCP_Kabelbaum() {
            return this.CP_Kabelbaum;
        }

        public void setPos(long pos) {
            this.Pos = pos;
        }

        public long getPos() {
            return this.Pos;
        }

        public void setBTNummer(String bTNummer) {
            this.BTNummer = bTNummer;
        }

        public String getBTNummer() {
            return this.BTNummer;
        }

        public String toString() {
            return "mbHasInfo: " + this.mbHasInfo + " mbIsBTE: " + this.mbIsBTE + " mbIsBteBedingungRelevant: " + this.mbIsBteBedingungRelevant + " mBteBedingung: " + this.mBteBedingung + " mGrafik: " + this.mGrafik + " mlGrafikId: " + this.mlGrafikId + " mlTimestamp: " + this.mlTimestamp + " msBedKez: " + this.msBedKez + " msBenennung: " + this.msBenennung + " msBenennungKommentar: " + this.msBenennungKommentar + " msBtType: " + this.msBtType + " msIdNummer: " + this.msIdNummer + " msMarktBen: " + this.msMarktBen + " msMarktIso: " + this.msMarktIso + " msZusatz: " + this.msZusatz + " CP_Kabelbaum: " + this.CP_Kabelbaum;
        }

        public String getMsBtType() {
            return this.msBtType;
        }

        public void setMsBtType(String msBtType) {
            this.msBtType = msBtType;
        }

        public String getMsIdNummer() {
            return this.msIdNummer;
        }

        public void setMsIdNummer(String msIdNummer) {
            this.msIdNummer = msIdNummer;
        }

        public String getMsBenennung() {
            return this.msBenennung;
        }

        public void setMsBenennung(String msBenennung) {
            this.msBenennung = msBenennung;
        }

        public String getMsZusatz() {
            return this.msZusatz;
        }

        public void setMsZusatz(String msZusatz) {
            this.msZusatz = msZusatz;
        }

        public String getMsBenennungKommentar() {
            return this.msBenennungKommentar;
        }

        public void setMsBenennungKommentar(String msBenennungKommentar) {
            this.msBenennungKommentar = msBenennungKommentar;
        }

        public String getMsDiebstahlrelevant() {
            return this.msDiebstahlrelevant;
        }

        public void setMsDiebstahlrelevant(String msDiebstahlrelevant) {
            this.msDiebstahlrelevant = msDiebstahlrelevant;
        }

        public long getMlGrafikId() {
            return this.mlGrafikId;
        }

        public void setMlGrafikId(long mlGrafikId) {
            this.mlGrafikId = mlGrafikId;
        }

        public long getMlTimestamp() {
            return this.mlTimestamp;
        }

        public void setMlTimestamp(long mlTimestamp) {
            this.mlTimestamp = mlTimestamp;
        }

        public byte[] getmGrafik() {
            return this.mGrafik;
        }

        public void setmGrafik(byte[] mGrafik) {
            this.mGrafik = mGrafik;
        }

        public boolean isMbIsBTE() {
            return this.mbIsBTE;
        }

        public void setMbIsBTE(boolean mbIsBTE) {
            this.mbIsBTE = mbIsBTE;
        }

        public PartOrBTEHelper getmPartOrBTEHelper() {
            return this.mPartOrBTEHelper;
        }

        public void setmPartOrBTEHelper(PartOrBTEHelper mPartOrBTEHelper) {
            this.mPartOrBTEHelper = mPartOrBTEHelper;
        }

        public boolean isMbHasInfo() {
            return this.mbHasInfo;
        }

        public void setMbHasInfo(boolean mbHasInfo) {
            this.mbHasInfo = mbHasInfo;
        }

        public Bedingung getmBteBedingung() {
            return this.mBteBedingung;
        }

        public void setmBteBedingung(Bedingung mBteBedingung) {
            this.mBteBedingung = mBteBedingung;
        }

        public Hashtable<String, Boolean> getMhErgebnis() {
            return this.mhErgebnis;
        }

        public void setMhErgebnis(Hashtable<String, Boolean> mhErgebnis) {
            this.mhErgebnis = mhErgebnis;
        }

        public boolean isMbIsBteBedingungRelevant() {
            return this.mbIsBteBedingungRelevant;
        }

        public void setMbIsBteBedingungRelevant(boolean mbIsBteBedingungRelevant) {
            this.mbIsBteBedingungRelevant = mbIsBteBedingungRelevant;
        }

        public ArrayList<Bedingung> getMcBedingungen3() {
            return this.mcBedingungen3;
        }

        public void setMcBedingungen3(ArrayList<Bedingung> mcBedingungen3) {
            this.mcBedingungen3 = mcBedingungen3;
        }

        public Hashtable<String, Boolean> getMhErgebnis3() {
            return this.mhErgebnis3;
        }

        public void setMhErgebnis3(Hashtable<String, Boolean> mhErgebnis3) {
            this.mhErgebnis3 = mhErgebnis3;
        }

        public boolean isMbIsBteBedingungRelevant3() {
            return this.mbIsBteBedingungRelevant3;
        }

        public void setMbIsBteBedingungRelevant3(boolean mbIsBteBedingungRelevant3) {
            this.mbIsBteBedingungRelevant3 = mbIsBteBedingungRelevant3;
        }

        public BTEBedingungsmenge getMoBTEBedingungsmenge3() {
            return this.moBTEBedingungsmenge3;
        }

        public void setMoBTEBedingungsmenge3(BTEBedingungsmenge moBTEBedingungsmenge3) {
            this.moBTEBedingungsmenge3 = moBTEBedingungsmenge3;
        }

        public boolean isMbHatNachruestenRelevantBTEBedingung3() {
            return this.mbHatNachruestenRelevantBTEBedingung3;
        }

        public void setMbHatNachruestenRelevantBTEBedingung3(boolean mbHatNachruestenRelevantBTEBedingung3) {
            this.mbHatNachruestenRelevantBTEBedingung3 = mbHatNachruestenRelevantBTEBedingung3;
        }

        public Hashtable<String, ArrayList<String>> getMhUeberBedingungen3() {
            return this.mhUeberBedingungen3;
        }

        public void setMhUeberBedingungen3(Hashtable<String, ArrayList<String>> mhUeberBedingungen3) {
            this.mhUeberBedingungen3 = mhUeberBedingungen3;
        }

        public String getMsBedKez() {
            return this.msBedKez;
        }

        public void setMsBedKez(String msBedKez) {
            this.msBedKez = msBedKez;
        }

        public String getMsMarktIso() {
            return this.msMarktIso;
        }

        public void setMsMarktIso(String msMarktIso) {
            this.msMarktIso = msMarktIso;
        }

        public String getMsMarktBen() {
            return this.msMarktBen;
        }

        public void setMsMarktBen(String msMarktBen) {
            this.msMarktBen = msMarktBen;
        }

        public Vector<String> getMaMarken() {
            return this.maMarken;
        }

        public void setMaMarken(Vector<String> maMarken) {
            this.maMarken = maMarken;
        }

        public boolean isMbIsRotMarkiert() {
            return this.mbIsRotMarkiert;
        }

        public void setMbIsRotMarkiert(boolean mbIsRotMarkiert) {
            this.mbIsRotMarkiert = mbIsRotMarkiert;
        }

        @XmlRootElement
        @XmlAccessorType(value=XmlAccessType.FIELD)
        public static class PartOrBTEHelper
        implements Serializable {
            private static final long serialVersionUID = 1L;
            @XmlElement
            private boolean mbAusweisungenElementeAktiv = false;
            @XmlElement
            private long mlModellSpalte = 0L;
            @XmlElement
            private String msSprache = null;
            @XmlElement
            private boolean mbUSATyp = false;
            @XmlElement
            private boolean mbVinIdentif = false;
            @XmlElement
            private boolean mbNachruestRelevant = false;
            @XmlElement
            private Bedingungsmenge moBedingungsmenge = null;

            public PartOrBTEHelper(boolean pbAusweisungenElementeAktiv, long plModellSpalte, String psSprache, boolean pbNachruestRelevant, boolean pbUSATyp, boolean pbVinIdentif, Bedingungsmenge poBedingungsmenge) {
                this.setAusweisungenElementeAktiv(pbAusweisungenElementeAktiv);
                this.setModellSpalte(plModellSpalte);
                this.setSprache(psSprache);
                this.setNachruestRelevant(pbNachruestRelevant);
                this.setUSATyp(pbUSATyp);
                this.setVinIdentif(pbVinIdentif);
                this.setBedingungsmenge(poBedingungsmenge);
            }

            public PartOrBTEHelper() {
            }

            public void setModellSpalte(long mlModellSpalte) {
                this.mlModellSpalte = mlModellSpalte;
            }

            public long getModellSpalte() {
                return this.mlModellSpalte;
            }

            public void setSprache(String msSprache) {
                this.msSprache = msSprache;
            }

            public String getSprache() {
                return this.msSprache;
            }

            public void setNachruestRelevant(boolean mbNachruestRelevant) {
                this.mbNachruestRelevant = mbNachruestRelevant;
            }

            public boolean isNachruestRelevant() {
                return this.mbNachruestRelevant;
            }

            public void setUSATyp(boolean mbUSATyp) {
                this.mbUSATyp = mbUSATyp;
            }

            public boolean isUSATyp() {
                return this.mbUSATyp;
            }

            public void setVinIdentif(boolean mbVinIdentif) {
                this.mbVinIdentif = mbVinIdentif;
            }

            public boolean isVinIdentif() {
                return this.mbVinIdentif;
            }

            public void setAusweisungenElementeAktiv(boolean mbAusweisungenElementeAktiv) {
                this.mbAusweisungenElementeAktiv = mbAusweisungenElementeAktiv;
            }

            public boolean isAusweisungenElementeAktiv() {
                return this.mbAusweisungenElementeAktiv;
            }

            public void setBedingungsmenge(Bedingungsmenge moBedingungsmenge) {
                this.moBedingungsmenge = moBedingungsmenge;
            }

            public Bedingungsmenge getBedingungsmenge() {
                return this.moBedingungsmenge;
            }

            public boolean isMbAusweisungenElementeAktiv() {
                return this.mbAusweisungenElementeAktiv;
            }

            public void setMbAusweisungenElementeAktiv(boolean mbAusweisungenElementeAktiv) {
                this.mbAusweisungenElementeAktiv = mbAusweisungenElementeAktiv;
            }

            public long getMlModellSpalte() {
                return this.mlModellSpalte;
            }

            public void setMlModellSpalte(long mlModellSpalte) {
                this.mlModellSpalte = mlModellSpalte;
            }

            public String getMsSprache() {
                return this.msSprache;
            }

            public void setMsSprache(String msSprache) {
                this.msSprache = msSprache;
            }

            public boolean isMbUSATyp() {
                return this.mbUSATyp;
            }

            public void setMbUSATyp(boolean mbUSATyp) {
                this.mbUSATyp = mbUSATyp;
            }

            public boolean isMbVinIdentif() {
                return this.mbVinIdentif;
            }

            public void setMbVinIdentif(boolean mbVinIdentif) {
                this.mbVinIdentif = mbVinIdentif;
            }

            public boolean isMbNachruestRelevant() {
                return this.mbNachruestRelevant;
            }

            public void setMbNachruestRelevant(boolean mbNachruestRelevant) {
                this.mbNachruestRelevant = mbNachruestRelevant;
            }

            public Bedingungsmenge getMoBedingungsmenge() {
                return this.moBedingungsmenge;
            }

            public void setMoBedingungsmenge(Bedingungsmenge moBedingungsmenge) {
                this.moBedingungsmenge = moBedingungsmenge;
            }
        }
    }
}

