/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.admintool;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.app.ServerGlobalObjects;
import webetk.app.admintool.Sprache;
import webetk.db.SQLStatements;
import webetk.db.dbaccess.AdminToolDbAccess;
import webetk.utils.StringUtils;

public class DBConnection {
    private static Logger log = Logger.getLogger(DBConnection.class);

    public static int erzeugePreise(ArrayList<String[]> recordList, boolean bUpdate, String sFirma) throws SQLException, DatabaseBusyException {
        int retCode = 0;
        Connection connection = null;
        connection = ServerGlobalObjects.getInstance().getDBConnectionPreise("erzeugePreise");
        log.debug("erzeugePreise w_preise connected by: " + connection.toString());
        connection.setAutoCommit(false);
        for (int i = 0; i < recordList.size(); ++i) {
            AdminToolDbAccess.erzeugePreis(connection, recordList.get(i), bUpdate, sFirma);
        }
        connection.commit();
        connection.setAutoCommit(false);
        ServerGlobalObjects.getInstance().freeDBConnectionPreise(connection, "erzeugePreise");
        log.debug("erzeugePreise 'w_preise' closed");
        return retCode;
    }

    public static int getCountPreise(Connection con, String sFirmaId) throws SQLException, ClassNotFoundException {
        String sSQLStatement = SQLStatements.Admintool.instance.GET_COUNT_FIRMA_PREISE();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", sFirmaId);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        int nCount = 0;
        if (res != null) {
            while (res.next()) {
                nCount = res.getInt("cnt");
            }
        }
        DBConnection.closeQuery(res);
        return nCount;
    }

    public static void closeQuery(ResultSet rset) {
        if (rset == null) {
            return;
        }
        try {
            Statement stmt = rset.getStatement();
            if (rset != null) {
                rset.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            log.warn("Unable to close statement and/or resultset!", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Sprache> ladeSprachen() throws SQLException, ClassNotFoundException, DatabaseBusyException {
        ArrayList<Sprache> oSprachen = new ArrayList<Sprache>();
        Connection con = null;
        ResultSet res = null;
        try {
            con = ServerGlobalObjects.getInstance().getDBConnection("ladeSprachen");
            String sSQLStatement = SQLStatements.Admintool.instance.LOAD_SPRACHEN();
            log.debug("Executing: " + sSQLStatement);
            Statement stmt = con.createStatement();
            res = stmt.executeQuery(sSQLStatement);
            if (res != null) {
                while (res.next()) {
                    String sISO = res.getString("ISO");
                    String sRegISO = res.getString("RegISO");
                    if (sRegISO.equals("  ")) {
                        sRegISO = null;
                    }
                    String sBenennung = res.getString("Benennung");
                    oSprachen.add(new Sprache(sBenennung, sISO, sRegISO));
                }
            }
        }
        catch (Throwable throwable) {
            DBConnection.closeQuery(res);
            ServerGlobalObjects.getInstance().freeDBConnection(con, "ladeSprachen");
            throw throwable;
        }
        DBConnection.closeQuery(res);
        ServerGlobalObjects.getInstance().freeDBConnection(con, "ladeSprachen");
        return oSprachen;
    }

    public static String[] ladeVersionInfo() throws SQLException, DatabaseBusyException {
        String[] retVal = new String[]{null, null};
        Connection con = ServerGlobalObjects.getInstance().getDBConnection("ladeVersionInfo");
        ResultSet res = DBConnection.ladeDBVersion(con);
        String msDatenVom = null;
        while (res != null && res.next()) {
            String sInfo = res.getString("Info");
            if (sInfo.equals("DB_VERSION")) {
                retVal[0] = res.getString("Wert");
                continue;
            }
            if (!sInfo.equals("DB_DATEN_VOM")) continue;
            msDatenVom = res.getString("Wert");
            long lDatenVom = Long.parseLong(msDatenVom);
            if (lDatenVom == 0L) {
                msDatenVom = "";
                continue;
            }
            msDatenVom = StringUtils.getStringFromDate(StringUtils.getDateFromLong(lDatenVom), "de", 2);
        }
        retVal[1] = msDatenVom;
        ServerGlobalObjects.getInstance().freeDBConnection(con, "ladeSprachen");
        return retVal;
    }

    private static ResultSet ladeDBVersion(Connection con) throws SQLException {
        String sSQLStatement = SQLStatements.Admintool.instance.LOAD_DBVERSIONSINFO();
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ArrayList ladeFirmenId(Connection con) throws SQLException {
        ArrayList<String> oFirmen = new ArrayList<String>();
        String sSQLStatement = SQLStatements.Admintool.instance.LOAD_FIRMEN();
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        if (res != null) {
            while (res.next()) {
                oFirmen.add(res.getString("Id"));
            }
        }
        DBConnection.closeQuery(res);
        return oFirmen;
    }
}

