/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.admintool;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import webetk.app.ServerGlobalObjects;
import webetk.app.admintool.DBConnection;
import webetk.app.admintool.StreamGobbler;
import webetk.db.dbaccess.AdminToolDbAccess;

public class DBSicherung {
    private static String savDir;
    private static String dbPass;
    private static String versionSicherungFile;
    private static Exception exceptionOccured;
    private static String transbaseDir;
    private static Logger log;

    public static List sichereEtkNutzer() {
        ArrayList<Number> retList = new ArrayList<Number>();
        String sPath = DBSicherung.getSavDir();
        File oDirectory = new File(sPath);
        log.info("Store Data from Database \"etk_nutzer\" in Path " + oDirectory.getAbsolutePath());
        String sProgramVersion = DBSicherung.readProgramVersion();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String sCurrentDate = sdf.format(new Date());
        String fileName = "etk_nutzer" + sCurrentDate + "_" + sProgramVersion + ".tbtar";
        File destinationFile = new File(oDirectory + File.separator + fileName);
        if (destinationFile.exists()) {
            destinationFile.delete();
            log.info("File already existed before deletion");
        }
        if (!oDirectory.exists()) {
            oDirectory.mkdirs();
        }
        String[] sCommand = DBSicherung.getTbTarCommand();
        sCommand[2] = sCommand[2] + " -w etk_nutzer p=" + DBSicherung.getDbPass() + " f=" + oDirectory + File.separator + fileName;
        try {
            int exitVal = DBSicherung.executeCommand(sCommand);
            if (exitVal != 0) {
                throw new IOException();
            }
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(oDirectory + File.separator + DBSicherung.getVersionSicherungFile())));
            out.write(fileName + System.getProperty("line.separator"));
            out.close();
            long fileSize = destinationFile.length();
            int retCode = 0;
            retList.add(new Integer(retCode));
            retList.add(new Long(fileSize));
        }
        catch (Exception ex) {
            log.error("Exception: ", ex);
            DBSicherung.setExceptionOccured(ex);
            int retCode = 1001;
            retList.add(new Integer(retCode));
        }
        return retList;
    }

    private static int excuteTbTarRead(File oDirectory, String fileName, Connection con) throws IOException, InterruptedException, SQLException {
        String[] sCommand = DBSicherung.getTbTarCommand();
        sCommand[2] = sCommand[2] + " -r etk_nutzer p=" + DBSicherung.getDbPass() + " f=" + oDirectory + File.separator + fileName;
        return DBSicherung.executeCommand(sCommand);
    }

    private static void excuteTbTarWrite(File oDirectory, String fileName) throws Exception {
        String[] sCommand = DBSicherung.getTbTarCommand();
        sCommand[2] = sCommand[2] + " -w etk_nutzer p=" + DBSicherung.getDbPass() + " f=" + oDirectory + File.separator + fileName;
        try {
            int exitVal = DBSicherung.executeCommand(sCommand);
            if (exitVal != 0) {
                throw new IOException();
            }
        }
        catch (Exception ex) {
            log.error("Exception: ", ex);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int ladeEtkNutzer() {
        String sPath = DBSicherung.getSavDir();
        log.debug("SAVEDIR : " + sPath);
        String fileName = null;
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader(new FileInputStream(sPath + File.separator + DBSicherung.getVersionSicherungFile())));
            fileName = in.readLine();
            if (fileName == null) {
                log.error("fileName is null!");
                DBSicherung.setExceptionOccured(new Exception("fileName is null!"));
                int n = 1000;
                return n;
            }
            fileName = fileName.trim();
            in.close();
        }
        catch (FileNotFoundException e2) {
            log.error("Exception: ", e2);
            DBSicherung.setExceptionOccured(e2);
            int ex = 1000;
            return ex;
        }
        catch (IOException e2) {
            log.error("Exception: ", e2);
            DBSicherung.setExceptionOccured(e2);
            int ex = 1000;
            return ex;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    log.error("Exception closing inputstream: ", ex);
                }
            }
        }
        Connection con = null;
        ServerGlobalObjects globO = ServerGlobalObjects.getInstance();
        try {
            con = globO.getDBConnectionNutzer("ladeEtkNutzer");
            con.setAutoCommit(false);
            ArrayList lstFirmen = DBConnection.ladeFirmenId(con);
            File tempDir = new File(sPath);
            File tmpFile = File.createTempFile("tbTemp", ".bak", tempDir);
            tmpFile.delete();
            DBSicherung.excuteTbTarWrite(tempDir, tmpFile.getName());
            AdminToolDbAccess.loescheNutzertabellen(con);
            AdminToolDbAccess.loescheNutzersequenzen(con);
            con.commit();
            String[] sCommand = DBSicherung.getTbTarCommand();
            sCommand[2] = sCommand[2] + " -r etk_nutzer p=" + DBSicherung.getDbPass() + " f=" + sPath + File.separator + fileName;
            int exitVal = DBSicherung.executeCommand(sCommand);
            if (exitVal != 0) {
                String msg = "ExitVal " + exitVal + " from command: " + sCommand[0] + sCommand[1] + sCommand[2];
                Exception ex = new Exception(msg);
                DBSicherung.setExceptionOccured(ex);
                log.error(msg, ex);
                int n = 1001;
                return n;
            }
            ArrayList loadFirmen = DBConnection.ladeFirmenId(con);
            con.commit();
            if (!DBSicherung.checkFirmenListe(loadFirmen, lstFirmen)) {
                AdminToolDbAccess.loescheNutzertabellen(con);
                AdminToolDbAccess.loescheNutzersequenzen(con);
                con.commit();
                exitVal = DBSicherung.excuteTbTarRead(tempDir, tmpFile.getName(), con);
                if (exitVal != 0) {
                    log.error("ExitVal: " + exitVal);
                    throw new Exception();
                }
                tmpFile.delete();
                DBSicherung.setExceptionOccured(new Exception("Error List of BusinesspartnerIds does not match"));
                log.error(DBSicherung.getExceptionOccured());
                int ex = 1003;
                return ex;
            }
            tmpFile.delete();
            String programVersion = fileName.length() > 26 ? fileName.substring(19, fileName.length() - 6) : "1.0.01";
            int retCode = DBSicherung.updateEtkNutzerFromVersion(programVersion);
            if (retCode != 0) {
                int n = retCode;
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception ex) {
            ex = new Exception();
            DBSicherung.setExceptionOccured(ex);
            log.error("Exception", ex);
            try {
                con.rollback();
            }
            catch (SQLException e1) {
                log.warn("Exception beim rollback: ", e1);
            }
            int n = 1002;
            return n;
        }
        finally {
            try {
                con.setAutoCommit(true);
                globO.freeDBConnectionNutzer(con, "ladeEtkNutzer");
            }
            catch (SQLException e1) {
                DBSicherung.setExceptionOccured(e1);
                log.error("Exception", e1);
                return 1000;
            }
        }
    }

    private static int executeCommand(String[] sCommand) throws IOException, InterruptedException {
        log.info(sCommand[2]);
        Process p = Runtime.getRuntime().exec(sCommand);
        StreamGobbler errorGobbler = new StreamGobbler(p.getErrorStream());
        StreamGobbler outputGobbler = new StreamGobbler(p.getInputStream());
        errorGobbler.start();
        outputGobbler.start();
        int exitVal = p.waitFor();
        log.debug("ExitValue: " + exitVal);
        return exitVal;
    }

    private static boolean checkFirmenListe(List loadFirmen, List listFirmen) {
        ArrayList lstFirmen = new ArrayList(listFirmen);
        for (String firmaLoad : loadFirmen) {
            Iterator itold = lstFirmen.iterator();
            boolean bFound = false;
            while (itold.hasNext()) {
                String firmaOld = (String)itold.next();
                if (!firmaOld.equals(firmaLoad)) continue;
                bFound = true;
                lstFirmen.remove(firmaOld);
                break;
            }
            if (bFound) continue;
            return false;
        }
        return lstFirmen.isEmpty();
    }

    private static String readProgramVersion() {
        String sProgramVersion = "";
        String sPath = ServerGlobalObjects.getInstance().getHomePath() + "WEB-INF";
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(sPath + File.separator + "version.txt")));
            String szLine = in.readLine();
            while (szLine != null) {
                if ((szLine = szLine.trim()).startsWith("Version.Programme")) {
                    sProgramVersion = szLine.substring(szLine.indexOf("=") + 1).trim();
                }
                szLine = in.readLine();
            }
            in.close();
        }
        catch (FileNotFoundException e1) {
            log.error("File version.txt does not exist!", e1);
        }
        catch (IOException e1) {
            log.error("Error while reading version.txt!", e1);
        }
        return sProgramVersion;
    }

    private static int updateEtkNutzerFromVersion(String sOldVersion) {
        int retCode = 0;
        String etkNutzerDir = "P:" + File.separator + "ETK" + File.separator + "etk_nutzer";
        if (sOldVersion.compareTo("1.6.02") < 0) {
            DBSicherung.callUpdateEtkNutzer(etkNutzerDir + File.separator + "updateIsisNutzer1.6.00.sql");
        }
        log.info("updating DB EtkNutzer from version " + sOldVersion);
        File oDir = new File(etkNutzerDir);
        File[] aFiles = oDir.listFiles();
        if (aFiles != null) {
            String[] aFilePaths = new String[aFiles.length];
            for (int ii = 0; ii < aFiles.length; ++ii) {
                if (!aFiles[ii].isFile() || !aFiles[ii].getName().endsWith("sql") || !aFiles[ii].getName().startsWith("updateNutzer") || aFiles[ii].getName().compareTo("updateNutzer" + sOldVersion + ".sql") <= 0 || aFiles[ii].getName().endsWith("Preise.sql")) continue;
                aFilePaths[ii] = aFiles[ii].getAbsolutePath();
            }
            String sFile = DBSicherung.getMinString(aFilePaths);
            while (sFile != null) {
                log.info("call " + sFile);
                retCode = DBSicherung.callUpdateEtkNutzer(sFile);
                if (retCode != 0) {
                    return retCode;
                }
                sFile = DBSicherung.getMinString(aFilePaths);
            }
        }
        return retCode;
    }

    private static int callUpdateEtkNutzer(String sSkriptname) {
        try {
            String[] sCommand = new String[]{"cmd.exe", "/C", DBSicherung.getTransbaseDir() + File.separator + "tbi32.exe"};
            File oSkript = new File(sSkriptname);
            sCommand[2] = sCommand[2] + " -f " + oSkript.getAbsolutePath();
            sCommand[2] = sSkriptname.endsWith("Preise.sql") ? sCommand[2] + " etk_preise" : sCommand[2] + " etk_nutzer";
            sCommand[2] = sCommand[2] + " tbadmin " + DBSicherung.getDbPass();
            Process p = Runtime.getRuntime().exec(sCommand);
            StreamGobbler errorGobbler = new StreamGobbler(p.getErrorStream());
            StreamGobbler outputGobbler = new StreamGobbler(p.getInputStream());
            errorGobbler.start();
            outputGobbler.start();
            int exitVal = p.waitFor();
            if (exitVal > 0 && !sSkriptname.endsWith("updateNutzer1.6.01.sql")) {
                String msg = sSkriptname + " ist gescheitert mit ExitVal " + exitVal;
                Exception ex = new Exception(msg);
                DBSicherung.setExceptionOccured(ex);
                log.error(msg, ex);
                return 1000;
            }
            log.info("exitVal: " + Integer.toString(exitVal));
            return 0;
        }
        catch (Exception ex) {
            String msg = "updateEtkNutzerFromVersion ist mit Exception gescheitert";
            ex = new Exception(msg);
            DBSicherung.setExceptionOccured(ex);
            log.error(msg, ex);
            return 1000;
        }
    }

    private static String getMinString(String[] aStrings) {
        int i;
        String sMinString = "Z";
        for (i = 0; i < aStrings.length; ++i) {
            if (aStrings[i] == null || aStrings[i].compareTo(sMinString) >= 0) continue;
            sMinString = aStrings[i];
        }
        if (sMinString.equals("Z")) {
            return null;
        }
        for (i = 0; i < aStrings.length; ++i) {
            if (aStrings[i] == null || !aStrings[i].equals(sMinString)) continue;
            aStrings[i] = null;
        }
        return sMinString;
    }

    private static String getSavDir() {
        return savDir;
    }

    public static void setSavDir(String savDir) {
        DBSicherung.savDir = savDir;
    }

    private static String[] getTbTarCommand() {
        String[] sCommand = new String[]{"cmd.exe", "/C", DBSicherung.getTransbaseDir() + File.separator + "tbtar32.exe"};
        return sCommand;
    }

    private static String getDbPass() {
        if (dbPass == null) {
            log.fatal("db pass not set", new Exception());
        }
        return dbPass;
    }

    public static void setDbPass(String dbPass) {
        DBSicherung.dbPass = dbPass;
    }

    private static String getVersionSicherungFile() {
        if (versionSicherungFile == null) {
            versionSicherungFile = "AktuelleVersion.txt";
        }
        return versionSicherungFile;
    }

    public static void setVersionSicherungFile(String versionSicherungFile) {
        DBSicherung.versionSicherungFile = versionSicherungFile;
    }

    public static Exception getExceptionOccured() {
        return exceptionOccured;
    }

    private static void setExceptionOccured(Exception exceptionOccured) {
        DBSicherung.exceptionOccured = exceptionOccured;
    }

    public static String getTransbaseDir() {
        if (transbaseDir == null) {
            transbaseDir = ServerGlobalObjects.getInstance().getHomePath() + "..\\..\\..\\transbase";
            File transbaseDirFile = new File(transbaseDir);
            try {
                transbaseDir = transbaseDirFile.getCanonicalPath();
                if (!transbaseDirFile.exists()) {
                    log.error("transbaseDir: " + transbaseDir + " does not exist");
                }
            }
            catch (IOException e) {
                log.error("Wrong INTERNAL setting", e);
            }
            log.debug("transbaseDir: " + transbaseDir);
        }
        return transbaseDir;
    }

    static {
        dbPass = null;
        versionSicherungFile = null;
        exceptionOccured = null;
        transbaseDir = null;
        log = Logger.getLogger(DBSicherung.class);
    }
}

