/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.asssuche;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.WebetkUtils;
import webetk.app.SearchBTETeile;
import webetk.app.ServerGlobalObjects;
import webetk.app.StringKomparator;
import webetk.app.SucheInfo;
import webetk.app.asssuche.AssSucheInfo;
import webetk.app.basesuche.BaseHgFgSuche;
import webetk.db.dbaccess.TeileSucheAssDbAccess;
import webetk.framework.ServerSessionInfo;

@XmlRootElement(name="HGFGSucheAss")
@XmlType(name="webetk.app.asssuche.HGFGSuche")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class HGFGSuche
extends BaseHgFgSuche
implements Serializable {
    @XmlTransient
    private static final long serialVersionUID = 1L;
    @XmlTransient
    private static Logger log = Logger.getLogger(HGFGSuche.class);
    private String[] maHg = new String[0];
    private String[] maFg = new String[0];
    private String msHGSel;
    private Hashtable<String, String[]> mhHgFg = new Hashtable();
    private int mnAktIndexHG = -1;
    private int mnAktIndexFG = -1;
    private boolean mbDirekteEingabe = false;
    private boolean mbFGSuche = false;

    public HGFGSuche() {
    }

    public HGFGSuche(Collection<String> aHgFg, String sHgSel, Collection<String> aFg, boolean bGrafischeSuche, boolean bMitGrafiken, boolean bZentraleSuche, boolean bDirekteEingabe, boolean bFGSuche) {
        this.msHGSel = sHgSel;
        this.mbDirekteEingabe = bDirekteEingabe;
        this.mbFGSuche = bFGSuche;
        this.evalHgFgSuchkriterien(aHgFg);
        this.evalFgSuchkriterien(aFg);
        if (this.maHg.length > 0) {
            this.mnAktIndexHG = sHgSel != null ? this.findIndex(sHgSel) : 0;
        }
        this.mbGrafischeSuche = bGrafischeSuche;
        this.mbZentraleSuche = bZentraleSuche;
        this.mbMitGrafiken = bMitGrafiken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int performSearch(SucheInfo oSucheInfo, String sLang, ServerSessionInfo oServerSessionInfo) throws SQLException, DatabaseBusyException {
        log.info("PerformSearch() - EtkiBase_Webetklogik");
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        if (!(oSucheInfo instanceof AssSucheInfo)) {
            log.error("oSucheInfo is no instance of AssSucheInfo!");
            return 4;
        }
        AssSucheInfo oAssSucheInfo = (AssSucheInfo)oSucheInfo;
        boolean bIGDOM = oSucheInfo.isIGDOM();
        log.info("HGFGSuche: " + oAssSucheInfo.getSuchHG());
        String sHg = null;
        String sFg = null;
        if (this.mbDirekteEingabe || this.mbFGSuche) {
            String sHgFg;
            String[] aHgFgs;
            if (this.maHg.length == 1) {
                aHgFgs = this.mhHgFg.get(this.maHg[0]);
                sHgFg = aHgFgs[0];
                sHg = sHgFg.substring(0, 2);
                sFg = sHgFg.length() != 4 ? null : sHgFg.substring(2, 4);
            } else {
                sHg = this.msHGSel;
                aHgFgs = this.mhHgFg.get(sHg);
                sHgFg = aHgFgs[0];
                String string = sFg = sHgFg.length() != 4 ? null : sHgFg.substring(2, 4);
            }
        }
        if (this.maFg.length > 0) {
            this.mnAktIndexFG = sFg != null ? this.findIndexFg(sFg) : 0;
        }
        log.info("sHG: " + sHg + "  sFG: " + sFg);
        oSucheInfo.setSuchHGFG(sHg, sFg);
        this.mcBTEs.clear();
        this.mcTeile.clear();
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnection("HGFGSuche.performSearch");
            String sMarke = oAssSucheInfo.getMarke();
            String sProduktart = oAssSucheInfo.getProduktart();
            String sKatUmfang = oAssSucheInfo.getKatalogumfang();
            String sAktHg = this.maHg[this.mnAktIndexHG];
            String[] asHgFg = this.mhHgFg.get(sAktHg);
            if (asHgFg.length == 0) {
                throw new SQLException("keine Hg bzw. HgFgs f\u00fcr Suche vorhanden");
            }
            oSucheInfo.setSuchHgFgs(asHgFg, !this.mbDirekteEingabe);
            if (!this.mbGrafischeSuche) {
                res = TeileSucheAssDbAccess.searchBildtafel_HGFG(con, asHgFg, sLang, sMarke, sProduktart, sKatUmfang);
            } else {
                boolean bMitGrafiken = this.mbMitGrafiken;
                if (this.mbZentraleSuche) {
                    bMitGrafiken = false;
                }
                if (asHgFg.length != 1) {
                    throw new SQLException("f\u00fcr Grafische Suche darf nur genau eine Hg angegeben sein");
                }
                String sHG = asHgFg[0];
                res = this.mbFGSuche ? TeileSucheAssDbAccess.searchBildtafel_HG_FG_Grafisch(con, sHg, sFg, sLang, sMarke, sProduktart, sKatUmfang, bMitGrafiken) : TeileSucheAssDbAccess.searchBildtafel_HG_Grafisch(con, sHG, sLang, sMarke, sProduktart, sKatUmfang, bMitGrafiken);
            }
            while (res != null && res.next()) {
                SearchBTETeile.PartOrBTE obj = this.readResultIntoPartOrBte(res, sLang, sProduktart, null, bIGDOM);
                this.mcBTEs.add(obj);
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnection(con, "HGFGSuche.performSearch");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnection(con, "HGFGSuche.performSearch");
        return this.mcBTEs.size() == 0 ? 4 : 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int checkSearch_grafisch(SucheInfo oSucheInfo) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        String sCount = null;
        if (!(oSucheInfo instanceof AssSucheInfo)) {
            log.error("oSucheInfo is no instance of AssSucheInfo!");
            return 4;
        }
        AssSucheInfo oAssSucheInfo = (AssSucheInfo)oSucheInfo;
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnection("HGFGSuche.performSearch");
            String sMarke = oAssSucheInfo.getMarke();
            String sProduktart = oAssSucheInfo.getProduktart();
            String sKatUmfang = oAssSucheInfo.getKatalogumfang();
            String sHG = this.maHg[0];
            res = TeileSucheAssDbAccess.checkBildtafel_HG_Grafisch(con, sHG, sMarke, sProduktart, sKatUmfang);
            while (res != null && res.next()) {
                sCount = res.getString("countBte");
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnection(con, "HGFGSuche.performSearch");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnection(con, "HGFGSuche.performSearch");
        if (sCount == null || sCount.equals("0")) {
            return 4;
        }
        return 1;
    }

    public void setAktIndexHG(int nIndexHG) {
        this.mnAktIndexHG = nIndexHG;
    }

    public int getIndexNextHG() {
        int nIndex = this.mnAktIndexHG + 1;
        if (nIndex >= this.maHg.length) {
            return -1;
        }
        return nIndex;
    }

    public int getIndexPrevHG() {
        int nIndex = this.mnAktIndexHG - 1;
        if (nIndex < 0) {
            return -1;
        }
        return nIndex;
    }

    public int getIndexNextFG() {
        int nIndex = this.mnAktIndexFG + 1;
        if (nIndex >= this.maFg.length) {
            return -1;
        }
        return nIndex;
    }

    public int getIndexPrevFG() {
        int nIndex = this.mnAktIndexFG - 1;
        if (nIndex < 0) {
            return -1;
        }
        return nIndex;
    }

    private void evalHgFgSuchkriterien(Collection<String> aHgFg) {
        TreeSet<String> oSortedHgFgs = new TreeSet<String>(new StringKomparator());
        oSortedHgFgs.addAll(aHgFg);
        Vector<String> aHelpHg = new Vector<String>();
        Vector<String> aHelpHgFg = new Vector<String>();
        Iterator<String> iter = oSortedHgFgs.iterator();
        String sAktHg = null;
        while (iter.hasNext()) {
            String sEintrag = iter.next();
            String sHg = sEintrag.substring(0, 2);
            if (sAktHg == null || !sAktHg.equals(sHg)) {
                aHelpHg.add(sHg);
                if (aHelpHgFg.size() > 0) {
                    String[] aHelpHgFgString = this.toStringArray(aHelpHgFg);
                    this.mhHgFg.put(sAktHg, aHelpHgFgString);
                    aHelpHgFg.clear();
                }
                sAktHg = sHg;
            }
            aHelpHgFg.add(sEintrag);
        }
        if (aHelpHgFg.size() > 0) {
            String[] aHelpHgFgString = this.toStringArray(aHelpHgFg);
            this.mhHgFg.put(sAktHg, aHelpHgFgString);
            aHelpHgFg.clear();
        }
        this.maHg = this.toStringArray(aHelpHg);
    }

    private void evalFgSuchkriterien(Collection<String> aFg) {
        TreeSet<String> oSortedFgs = new TreeSet<String>(new StringKomparator());
        oSortedFgs.addAll(aFg);
        Vector<String> aHelpFg = new Vector<String>();
        Iterator<String> iter = oSortedFgs.iterator();
        String sAktFg = null;
        while (iter.hasNext()) {
            String sEintrag = iter.next();
            String sFg = sEintrag.substring(0, 2);
            if (sAktFg != null && sAktFg.equals(sFg)) continue;
            aHelpFg.add(sFg);
            sAktFg = sFg;
        }
        this.maFg = this.toStringArray(aHelpFg);
    }

    private int findIndex(String sHg) {
        for (int i = 0; i < this.maHg.length; ++i) {
            if (!sHg.equals(this.maHg[i].substring(0, 2))) continue;
            return i;
        }
        return -1;
    }

    private int findIndexFg(String sFg) {
        for (int i = 0; i < this.maFg.length; ++i) {
            if (!sFg.equals(this.maFg[i])) continue;
            return i;
        }
        return -1;
    }

    private String[] toStringArray(Collection<String> aHelp) {
        String[] aStringArray = new String[aHelp.size()];
        Object[] aHelpArray = aHelp.toArray();
        for (int i = 0; i < aHelpArray.length; ++i) {
            aStringArray[i] = (String)aHelpArray[i];
        }
        return aStringArray;
    }

    public int getAnzHGs() {
        if (this.mhHgFg == null) {
            return 0;
        }
        return this.mhHgFg.values().size();
    }
}

