/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.basesuche;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Vector;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.WebetkUtils;
import webetk.app.SearchBTETeile;
import webetk.app.ServerGlobalObjects;
import webetk.app.SucheInfo;
import webetk.app.asssuche.AssSucheInfo;
import webetk.app.fzgsuche.FzgSucheInfo;
import webetk.db.dbaccess.AllgemeinDbAccess;
import webetk.db.dbaccess.TeileSucheAssDbAccess;
import webetk.db.dbaccess.TeileSucheFzgDbAccess;
import webetk.framework.ServerSessionInfo;
import webetk.utils.StringUtils;

@XmlRootElement
@XmlType(name="webetk.app.basesuche.FremdeTNrSuche")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class FremdeTNrSuche
extends SearchBTETeile
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(FremdeTNrSuche.class);
    private String msFremdeTNr = null;

    public FremdeTNrSuche(String sFremdeTNr) {
        this.msFremdeTNr = this.bereinigenFremdeTNr(sFremdeTNr);
    }

    public FremdeTNrSuche() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int performSearch(SucheInfo oSucheInfo, String sLang, ServerSessionInfo oServerSessionInfo) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        oSucheInfo.setSuchFremdeSachnummer(this.msFremdeTNr);
        boolean bIGDOM = oSucheInfo.isIGDOM();
        this.mcBTEs.clear();
        this.mcTeile.clear();
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnection("FremdeTNrSuche.performSearch");
            Vector<SearchBTETeile.PartOrBTE> aPartsOrBtes = this.searchBildtafel_SNrFremd(con, this.msFremdeTNr, oSucheInfo, sLang, bIGDOM);
            if (aPartsOrBtes != null && aPartsOrBtes.size() > 0) {
                SearchBTETeile.PartOrBTE firstPartOrBte = aPartsOrBtes.get(0);
                if (firstPartOrBte.isBTE()) {
                    this.mcBTEs.addAll(aPartsOrBtes);
                } else {
                    this.mcTeile.addAll(aPartsOrBtes);
                }
            }
        }
        finally {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnection(con, "FremdeTNrSuche.performSearch");
        }
        if (this.mcBTEs.size() == 0 && this.mcTeile.size() == 0) {
            return 4;
        }
        if (this.mcBTEs.size() != 0 && this.mcTeile.size() != 0) {
            return 3;
        }
        if (this.mcBTEs.size() != 0) {
            return 1;
        }
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector<SearchBTETeile.PartOrBTE> searchBildtafel_SNrFremd(Connection con, String sSachnummerFremd, SucheInfo oSucheInfo, String sSprache, boolean bIGDOM) throws SQLException, DatabaseBusyException {
        Vector<SearchBTETeile.PartOrBTE> aPartsOrBtes = new Vector<SearchBTETeile.PartOrBTE>();
        FzgSucheInfo oFzgSucheInfo = null;
        AssSucheInfo oAssSucheInfo = null;
        if (oSucheInfo instanceof FzgSucheInfo) {
            oFzgSucheInfo = (FzgSucheInfo)oSucheInfo;
        } else if (oSucheInfo instanceof AssSucheInfo) {
            oAssSucheInfo = (AssSucheInfo)oSucheInfo;
        } else {
            log.error("oSucheInfo is no instance of FzgSucheInfo or AssSucheInfo!");
            return aPartsOrBtes;
        }
        sSachnummerFremd = StringUtils.maskiereHochkommaFuerDb(sSachnummerFremd);
        Vector<String> aSachnummern = AllgemeinDbAccess.retrieveBMWSachnummern(con, sSachnummerFremd);
        ResultSet res = null;
        try {
            if (aSachnummern == null || aSachnummern.size() < 1) {
                aPartsOrBtes = null;
            } else if (aSachnummern.size() == 1) {
                String sSachnummer = aSachnummern.get(0);
                oSucheInfo.setSuchSachnummer(sSachnummer);
                if (oSucheInfo.getBtNummer() != null && !oSucheInfo.getBtNummer().isEmpty()) {
                    if (oFzgSucheInfo != null) {
                        boolean bIncludeAccessoiresBildtafeln = this.includeAccessoiresBildtafeln();
                        res = TeileSucheFzgDbAccess.searchBildtafel_BTNummer(con, oFzgSucheInfo, sSachnummer, sSprache, bIncludeAccessoiresBildtafeln, oSucheInfo.getBtNummer());
                    } else if (oAssSucheInfo != null) {
                        res = TeileSucheAssDbAccess.searchBildtafel_BTNummer(con, oAssSucheInfo, sSachnummer, sSprache, oSucheInfo.getBtNummer());
                    }
                } else if (oFzgSucheInfo != null) {
                    boolean bIncludeAccessoiresBildtafeln = false;
                    res = TeileSucheFzgDbAccess.searchBildtafel_SNrCompl(con, oFzgSucheInfo, sSachnummer, sSprache, bIncludeAccessoiresBildtafeln, null);
                } else if (oAssSucheInfo != null) {
                    res = TeileSucheAssDbAccess.searchBildtafel_SNrCompl(con, oAssSucheInfo, sSachnummer, sSprache, null);
                }
                while (res != null && res.next()) {
                    SearchBTETeile.PartOrBTE obj = SearchBTETeile.readResultIntoBte(res, sSprache, oAssSucheInfo.getProduktart(), null, bIGDOM);
                    aPartsOrBtes.add(obj);
                }
            } else {
                if (oFzgSucheInfo != null) {
                    res = TeileSucheFzgDbAccess.searchSachnummer_Sachnummern(con, oFzgSucheInfo, aSachnummern, sSprache);
                } else if (oAssSucheInfo != null) {
                    res = TeileSucheAssDbAccess.searchSachnummer_Sachnummern(con, oAssSucheInfo, aSachnummern, sSprache);
                }
                while (res != null && res.next()) {
                    SearchBTETeile.PartOrBTE obj = SearchBTETeile.readResultIntoPart(res);
                    aPartsOrBtes.add(obj);
                }
            }
        }
        finally {
            WebetkUtils.closeQuery(res);
        }
        return aPartsOrBtes;
    }

    protected String bereinigenFremdeTNr(String sFremdeTNr) {
        sFremdeTNr = StringUtils.substituteString(sFremdeTNr, " ", "");
        String sFremdeTNrBereinigt = "";
        for (int i = 0; i < sFremdeTNr.length(); ++i) {
            char cTemp = sFremdeTNr.charAt(i);
            if (!Character.isLetterOrDigit(cTemp)) continue;
            sFremdeTNrBereinigt = sFremdeTNrBereinigt + cTemp;
        }
        return sFremdeTNrBereinigt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<String> retrieveBMWNummernForFremdeTNr() {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        Connection con = null;
        try {
            con = globs.getDBConnection("FremdeTNrSuche.retrieveBMWNummernForFremdeTNr");
            Vector<String> aSachnummern = AllgemeinDbAccess.retrieveBMWSachnummern(con, this.msFremdeTNr);
            if (aSachnummern == null || aSachnummern.size() == 0) {
                Collection<String> collection = null;
                return collection;
            }
            Vector<String> vector = aSachnummern;
            return vector;
        }
        catch (DatabaseBusyException ex) {
            log.error("Error during retrieval of BMW number for foreign partsnumber " + this.msFremdeTNr + ": " + ex.getMessage(), ex);
            Collection<String> collection = null;
            return collection;
        }
        catch (SQLException ex) {
            log.error("Error during retrieval of BMW number for foreign partsnumber " + this.msFremdeTNr + ": " + ex.getMessage(), ex);
            Collection<String> collection = null;
            return collection;
        }
        finally {
            try {
                globs.freeDBConnection(con, "FremdeTNrSuche.retrieveBMWNummernForFremdeTNr");
            }
            catch (Exception e) {}
        }
    }

    public Collection<String> getBmwSachnummern() {
        return this.retrieveBMWNummernForFremdeTNr();
    }
}

