/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.basesuche;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.InvalidInitializationException;
import webetk.WebetkUtils;
import webetk.app.SearchBTETeile;
import webetk.app.ServerGlobalObjects;
import webetk.app.SucheInfo;
import webetk.app.asssuche.AssSucheInfo;
import webetk.app.fzgsuche.FzgSucheInfo;
import webetk.db.dbaccess.TeileSucheAssDbAccess;
import webetk.db.dbaccess.TeileSucheFzgDbAccess;
import webetk.framework.ServerSessionInfo;
import webetk.utils.StringUtils;

@XmlRootElement
@XmlType(name="webetk.app.basesuche.SachnummernSuche")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SachnummernSuche
extends SearchBTETeile
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(SachnummernSuche.class);
    private String msSachnummerInit;
    private String msHGUG;
    private String msSachnummer;
    private boolean mbComplete;

    public SachnummernSuche() {
        this.msHGUG = null;
        this.msSachnummer = null;
        this.mbComplete = true;
    }

    public SachnummernSuche(String sHGUG, String sSachnummer) throws InvalidInitializationException {
        int nCountDigitHgUg = StringUtils.getCountDigit(sHGUG);
        if (nCountDigitHgUg != 4) {
            throw new InvalidInitializationException("HGUG mu\u00df 4-stellig angegeben werden!");
        }
        int nCountDigitSnr = StringUtils.getCountDigit(sSachnummer);
        if (nCountDigitSnr != 7) {
            throw new InvalidInitializationException("Sachnummer mu\u00df 7-stellig angegeben werden!");
        }
        this.msHGUG = sHGUG;
        this.msSachnummer = sSachnummer;
        this.msSachnummerInit = sSachnummer;
        this.mbComplete = true;
    }

    public SachnummernSuche(String sSachnummer) throws InvalidInitializationException {
        this.msHGUG = null;
        if (sSachnummer.length() > 7) {
            throw new InvalidInitializationException("Such-Sachnummer ist l\u00e4nger als 7 Stellen!");
        }
        int nCountDigitSnr = StringUtils.getCountDigit(sSachnummer);
        if (nCountDigitSnr < 3) {
            throw new InvalidInitializationException("Such-Sachnummer mu\u00df mindestens 3 Ziffern beinhalten!");
        }
        this.msSachnummerInit = sSachnummer;
        int nLengthVor = sSachnummer.length();
        int nLengthNach = 0;
        while (nLengthVor != nLengthNach) {
            sSachnummer = StringUtils.substituteString(sSachnummer, "?*", "*");
            sSachnummer = StringUtils.substituteString(sSachnummer, "*?", "*");
            sSachnummer = StringUtils.substituteString(sSachnummer, "**", "*");
            nLengthNach = sSachnummer.length();
        }
        if (nCountDigitSnr == 7 && sSachnummer.length() == 7) {
            this.mbComplete = true;
        } else {
            if (sSachnummer.charAt(sSachnummer.length() - 1) != '*') {
                sSachnummer = sSachnummer + "*";
            }
            this.mbComplete = false;
        }
        this.msSachnummer = sSachnummer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int performSearch(SucheInfo oSucheInfo, String sLang, ServerSessionInfo oServerSessionInfo) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        FzgSucheInfo oFzgSucheInfo = null;
        AssSucheInfo oAssSucheInfo = null;
        if (oSucheInfo instanceof FzgSucheInfo) {
            oFzgSucheInfo = (FzgSucheInfo)oSucheInfo;
        } else if (oSucheInfo instanceof AssSucheInfo) {
            oAssSucheInfo = (AssSucheInfo)oSucheInfo;
        } else {
            log.error("oSucheInfo is no instance of FzgSucheInfo or AssSucheInfo!");
            return 4;
        }
        String sHGSuch = null;
        String sUGSuch = null;
        if (this.msHGUG != null) {
            sHGSuch = this.msHGUG.substring(0, 2);
            if (this.msHGUG.length() == 4) {
                sUGSuch = this.msHGUG.substring(2);
            }
        }
        oSucheInfo.setSuchSachnummer(sHGSuch, sUGSuch, this.msSachnummerInit);
        boolean bIGDOM = oSucheInfo.isIGDOM();
        this.mcBTEs.clear();
        this.mcTeile.clear();
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnection("SachnummernSuche.performSearch");
            if (this.mbComplete) {
                boolean bIncludeAccessoiresBildtafeln;
                if (oSucheInfo.getBtNummer() != null && !oSucheInfo.getBtNummer().isEmpty()) {
                    if (oFzgSucheInfo != null) {
                        bIncludeAccessoiresBildtafeln = this.includeAccessoiresBildtafeln();
                        res = TeileSucheFzgDbAccess.searchBildtafel_BTNummer(con, oFzgSucheInfo, this.msSachnummer, sLang, bIncludeAccessoiresBildtafeln, oSucheInfo.getBtNummer());
                    } else if (oAssSucheInfo != null) {
                        res = TeileSucheAssDbAccess.searchBildtafel_BTNummer(con, oAssSucheInfo, this.msSachnummer, sLang, oSucheInfo.getBtNummer());
                    }
                } else if (oFzgSucheInfo != null) {
                    bIncludeAccessoiresBildtafeln = this.includeAccessoiresBildtafeln();
                    res = TeileSucheFzgDbAccess.searchBildtafel_SNrCompl(con, oFzgSucheInfo, this.msSachnummer, sLang, bIncludeAccessoiresBildtafeln, oSucheInfo.getBtNummer());
                } else if (oAssSucheInfo != null) {
                    res = TeileSucheAssDbAccess.searchBildtafel_SNrCompl(con, oAssSucheInfo, this.msSachnummer, sLang, oSucheInfo.getBtNummer());
                }
                SearchBTETeile.PartOrBTE.PartOrBTEHelper oPoBHelper = oServerSessionInfo.getMoSessionInfoDez() != null ? (oServerSessionInfo.getMoSessionInfoDez().isMbAusweisungenElementeAktiv() ? new SearchBTETeile.PartOrBTE.PartOrBTEHelper(oServerSessionInfo.getMoSessionInfoDez().isMbAusweisungenElementeAktiv(), oFzgSucheInfo.getModellspalte(), sLang, oServerSessionInfo.getMoSessionInfoDez().isMbNachruestungenRelevant(), oFzgSucheInfo.getRegion().equals("USA"), oFzgSucheInfo.getFahrgestellnummer() != null && !oFzgSucheInfo.getFahrgestellnummer().equals(""), oServerSessionInfo.getMoSessionInfoDez().getMoBedingungswerte_BTE()) : null) : (oServerSessionInfo.isAusweisungenElementeAktiv() && oFzgSucheInfo != null ? new SearchBTETeile.PartOrBTE.PartOrBTEHelper(oServerSessionInfo.isAusweisungenElementeAktiv(), oFzgSucheInfo.getModellspalte(), sLang, oServerSessionInfo.getUserInfo().getNachruestungenRelevant(), oFzgSucheInfo.getRegion().equals("USA"), oFzgSucheInfo.getFahrgestellnummer() != null && !oFzgSucheInfo.getFahrgestellnummer().equals(""), oServerSessionInfo.getFzgSucheInfo().getBedingungsMenge_BTE()) : null);
                while (res != null && res.next()) {
                    String sProduktart = null;
                    if (oFzgSucheInfo != null) {
                        sProduktart = oFzgSucheInfo.getProduktart();
                    } else if (oAssSucheInfo != null) {
                        sProduktart = oAssSucheInfo.getProduktart();
                    }
                    SearchBTETeile.PartOrBTE obj = SachnummernSuche.readResultIntoBte(res, sLang, sProduktart, oPoBHelper, bIGDOM);
                    this.mcBTEs.add(obj);
                }
            } else {
                if (oFzgSucheInfo != null) {
                    res = TeileSucheFzgDbAccess.searchSachnummer_SNrIncompl(con, oFzgSucheInfo, this.msSachnummer, sLang);
                } else if (oAssSucheInfo != null) {
                    res = TeileSucheAssDbAccess.searchSachnummer_SNrIncompl(con, oAssSucheInfo, this.msSachnummer, sLang);
                }
                while (res != null && res.next()) {
                    SearchBTETeile.PartOrBTE obj = SachnummernSuche.readResultIntoPart(res);
                    this.mcTeile.add(obj);
                }
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnection(con, "SachnummernSuche.performSearch");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnection(con, "SachnummernSuche.performSearch");
        if (this.mcBTEs.size() == 0 && this.mcTeile.size() == 0) {
            return 4;
        }
        if (this.mcBTEs.size() != 0) {
            return 1;
        }
        return 2;
    }
}

