/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.bteanzeige;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.log4j.Logger;
import webetk.app.bteanzeige.Obergruppe;
import webetk.utils.StringUtils;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="webetk.app.bteanzeige.Bedingung")
public class Bedingung
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final char TRUE = 'T';
    public static final char FALSE = 'F';
    public static final char UNBEKANNT = '?';
    @XmlElement
    private String msKuerzel = null;
    @XmlElement
    private String msVorzeichen = null;
    @XmlElement
    private String msGesamtterm = null;
    @XmlElement
    private String msAusweisung = null;
    @XmlElements(value={@XmlElement(type=Obergruppe.class)})
    private ArrayList<Obergruppe> mcObergruppen;
    private static Logger log = Logger.getLogger(Bedingung.class);

    Bedingung() {
    }

    public Bedingung(String sKuerzel, String sVorzeichen, String sGesamtterm) {
        this.msKuerzel = sKuerzel;
        this.msVorzeichen = sVorzeichen;
        this.msGesamtterm = sGesamtterm;
        this.msAusweisung = " ";
    }

    public String getKuerzel() {
        return this.msKuerzel == null ? "" : this.msKuerzel;
    }

    public String getVorzeichen() {
        return this.msVorzeichen == null ? "" : this.msVorzeichen;
    }

    public String getGesamtterm() {
        return this.msGesamtterm == null ? "" : this.msGesamtterm;
    }

    public String getAusweisung() {
        return this.msAusweisung == null ? "" : this.msAusweisung;
    }

    public ArrayList<Obergruppe> getObergruppen() {
        return this.mcObergruppen;
    }

    public void setAusweisung(String sAusw) {
        this.msAusweisung = sAusw;
    }

    public void setAusweisung(char cAusw) {
        this.msAusweisung = new Character(cAusw).toString();
    }

    public void setAusweisung(char cAusw, int nIndex) {
        this.msAusweisung = this.msAusweisung.substring(0, nIndex) + new Character(cAusw).toString() + this.msAusweisung.substring(nIndex + 1);
    }

    public void appendObergruppe(Obergruppe Obj) {
        if (this.mcObergruppen == null) {
            this.mcObergruppen = new ArrayList();
        }
        this.mcObergruppen.add(Obj);
    }

    public Hashtable<String, Boolean> auswerten() {
        Hashtable<String, Boolean> hBedingungenRelevant = new Hashtable<String, Boolean>();
        boolean bVollstaendigBelegt = true;
        for (Obergruppe OG : this.mcObergruppen) {
            boolean bVollstaendig;
            String sVorzeichenBedingung;
            if (OG.getVArt().equals("E") || OG.getVArt().equals("B")) {
                sVorzeichenBedingung = this.msVorzeichen;
                char cVorzeichenET = this.msGesamtterm.charAt(0);
                if (sVorzeichenBedingung.equals("-") && cVorzeichenET == '-') {
                    this.msVorzeichen = "+";
                    this.msGesamtterm = this.msGesamtterm.substring(1);
                } else if (sVorzeichenBedingung.equals("-") || cVorzeichenET == '-') {
                    this.msVorzeichen = "+";
                    if (cVorzeichenET == '-') {
                        this.msGesamtterm = this.msGesamtterm.substring(1);
                    }
                    OG.convertFZeile();
                    this.msAusweisung = OG.getAusweisung();
                }
            }
            if (OG.getVArt().equals("T") && (sVorzeichenBedingung = this.msVorzeichen).equals("-") && !OG.getFZeile().isEmpty()) {
                OG.setMsFZeile("!(" + OG.getMsFZeile() + ")");
            }
            if (bVollstaendig = OG.auswerten()) continue;
            bVollstaendigBelegt = false;
        }
        String sAusweisung = this.getAusweisung();
        int nLength = sAusweisung.length();
        for (int i = 1; i <= nLength; ++i) {
            char cAusw;
            if (sAusweisung.charAt(i - 1) == '-' || (cAusw = this.auswertenIndex(i - 1)) == 'F') continue;
            String sKuerzel = this.msKuerzel;
            if (nLength > 1) {
                sKuerzel = sKuerzel + new Integer(i).toString();
            }
            hBedingungenRelevant.put(sKuerzel, new Boolean(bVollstaendigBelegt));
        }
        return hBedingungenRelevant;
    }

    private char auswertenIndex(int nIndex) {
        String sGesamtterm = this.getGesamtterm();
        if (this.msGesamtterm == null || this.msGesamtterm.length() == 0) {
            return ' ';
        }
        sGesamtterm = StringUtils.substituteStringStraight(sGesamtterm, " ", "");
        for (Obergruppe OG : this.mcObergruppen) {
            String sOgId = OG.getOGId();
            char cAusw = OG.getAusweisungChar(nIndex);
            sGesamtterm = StringUtils.substituteStringStraight(sGesamtterm, sOgId, new Character(cAusw).toString());
        }
        while (sGesamtterm.length() > 1) {
            int nLengthVor = sGesamtterm.length();
            String sSrc = new Character('T').toString() + "&" + new Character('T').toString();
            String sDest = new Character('T').toString();
            sGesamtterm = StringUtils.substituteStringStraight(sGesamtterm, sSrc, sDest);
            sSrc = new Character('T').toString() + "&" + new Character('F').toString();
            sDest = new Character('F').toString();
            sGesamtterm = StringUtils.substituteStringStraight(sGesamtterm, sSrc, sDest);
            sSrc = new Character('T').toString() + "&" + new Character('?').toString();
            sDest = new Character('?').toString();
            sGesamtterm = StringUtils.substituteStringStraight(sGesamtterm, sSrc, sDest);
            sSrc = new Character('F').toString() + "&" + new Character('T').toString();
            sDest = new Character('F').toString();
            sGesamtterm = StringUtils.substituteStringStraight(sGesamtterm, sSrc, sDest);
            sSrc = new Character('F').toString() + "&" + new Character('F').toString();
            sDest = new Character('F').toString();
            sGesamtterm = StringUtils.substituteStringStraight(sGesamtterm, sSrc, sDest);
            sSrc = new Character('F').toString() + "&" + new Character('?').toString();
            sDest = new Character('F').toString();
            sGesamtterm = StringUtils.substituteStringStraight(sGesamtterm, sSrc, sDest);
            sSrc = new Character('?').toString() + "&" + new Character('T').toString();
            sDest = new Character('?').toString();
            sGesamtterm = StringUtils.substituteStringStraight(sGesamtterm, sSrc, sDest);
            sSrc = new Character('?').toString() + "&" + new Character('F').toString();
            sDest = new Character('F').toString();
            sGesamtterm = StringUtils.substituteStringStraight(sGesamtterm, sSrc, sDest);
            sSrc = new Character('?').toString() + "&" + new Character('?').toString();
            sDest = new Character('?').toString();
            sGesamtterm = StringUtils.substituteStringStraight(sGesamtterm, sSrc, sDest);
            sSrc = new Character('T').toString() + "/" + new Character('T').toString();
            sDest = new Character('T').toString();
            sGesamtterm = StringUtils.substituteStringStraight(sGesamtterm, sSrc, sDest);
            sSrc = new Character('T').toString() + "/" + new Character('F').toString();
            sDest = new Character('T').toString();
            sGesamtterm = StringUtils.substituteStringStraight(sGesamtterm, sSrc, sDest);
            sSrc = new Character('T').toString() + "/" + new Character('?').toString();
            sDest = new Character('T').toString();
            sGesamtterm = StringUtils.substituteStringStraight(sGesamtterm, sSrc, sDest);
            sSrc = new Character('F').toString() + "/" + new Character('T').toString();
            sDest = new Character('T').toString();
            sGesamtterm = StringUtils.substituteStringStraight(sGesamtterm, sSrc, sDest);
            sSrc = new Character('F').toString() + "/" + new Character('F').toString();
            sDest = new Character('F').toString();
            sGesamtterm = StringUtils.substituteStringStraight(sGesamtterm, sSrc, sDest);
            sSrc = new Character('F').toString() + "/" + new Character('?').toString();
            sDest = new Character('?').toString();
            sGesamtterm = StringUtils.substituteStringStraight(sGesamtterm, sSrc, sDest);
            sSrc = new Character('?').toString() + "/" + new Character('T').toString();
            sDest = new Character('T').toString();
            sGesamtterm = StringUtils.substituteStringStraight(sGesamtterm, sSrc, sDest);
            sSrc = new Character('?').toString() + "/" + new Character('F').toString();
            sDest = new Character('?').toString();
            sGesamtterm = StringUtils.substituteStringStraight(sGesamtterm, sSrc, sDest);
            sSrc = new Character('?').toString() + "/" + new Character('?').toString();
            sDest = new Character('?').toString();
            sGesamtterm = StringUtils.substituteStringStraight(sGesamtterm, sSrc, sDest);
            sSrc = "(" + new Character('T').toString() + ")";
            sDest = new Character('T').toString();
            sGesamtterm = StringUtils.substituteStringStraight(sGesamtterm, sSrc, sDest);
            sSrc = "(" + new Character('F').toString() + ")";
            sDest = new Character('F').toString();
            sGesamtterm = StringUtils.substituteStringStraight(sGesamtterm, sSrc, sDest);
            sSrc = "(" + new Character('?').toString() + ")";
            sDest = new Character('?').toString();
            sGesamtterm = StringUtils.substituteStringStraight(sGesamtterm, sSrc, sDest);
            sSrc = "-" + new Character('T').toString();
            sDest = new Character('F').toString();
            sGesamtterm = StringUtils.substituteStringStraight(sGesamtterm, sSrc, sDest);
            sSrc = "-" + new Character('F').toString();
            sDest = new Character('T').toString();
            sGesamtterm = StringUtils.substituteStringStraight(sGesamtterm, sSrc, sDest);
            sSrc = "-" + new Character('?').toString();
            sDest = new Character('?').toString();
            sGesamtterm = StringUtils.substituteStringStraight(sGesamtterm, sSrc, sDest);
            sSrc = "+" + new Character('T').toString();
            sDest = new Character('T').toString();
            sGesamtterm = StringUtils.substituteStringStraight(sGesamtterm, sSrc, sDest);
            sSrc = "+" + new Character('F').toString();
            sDest = new Character('F').toString();
            sGesamtterm = StringUtils.substituteStringStraight(sGesamtterm, sSrc, sDest);
            sSrc = "+" + new Character('?').toString();
            int nLengthNach = (sGesamtterm = StringUtils.substituteStringStraight(sGesamtterm, sSrc, sDest = new Character('?').toString())).length();
            if (nLengthVor != nLengthNach) continue;
            sGesamtterm = new Character('T').toString();
            log.debug("Bedingung: " + this.getKuerzel() + " nicht auswertbar => wird auf T gesetzt!");
            break;
        }
        char cAusw = sGesamtterm.charAt(0);
        String sVorzeichen = this.getVorzeichen();
        if (sVorzeichen.equals("-")) {
            char c = cAusw = cAusw == 'T' ? (char)'F' : 'T';
        }
        if (cAusw == '?') {
            cAusw = 'T';
        }
        this.setAusweisung(cAusw, nIndex);
        return cAusw;
    }

    public static char ODER(char cWert1, char cWert2) {
        if (cWert1 == 'T' || cWert2 == 'T') {
            return 'T';
        }
        if (cWert1 == '?' || cWert2 == '?') {
            return '?';
        }
        return 'F';
    }

    public static char UND(char cWert1, char cWert2) {
        if (cWert1 == 'F' || cWert2 == 'F') {
            return 'F';
        }
        if (cWert1 == '?' || cWert2 == '?') {
            return '?';
        }
        return 'T';
    }

    public String toString() {
        String sString = "\n**************************";
        sString = sString + "\nK\u00fcrzel: " + this.msKuerzel + ": " + this.msVorzeichen + this.msGesamtterm;
        sString = sString + "\nAusweisung: " + this.msAusweisung;
        if (this.mcObergruppen == null) {
            sString = sString + "\n*Achtung: Bedingung hat keine Obergruppen!";
            return sString;
        }
        Iterator<Obergruppe> iterator = this.mcObergruppen.iterator();
        while (iterator.hasNext()) {
            sString = sString + iterator.next().toString();
        }
        return sString;
    }

    public static char getTrue() {
        return 'T';
    }

    public static char getFalse() {
        return 'F';
    }

    public static char getUnbekannt() {
        return '?';
    }

    public String getMsKuerzel() {
        return this.msKuerzel;
    }

    public void setMsKuerzel(String msKuerzel) {
        this.msKuerzel = msKuerzel;
    }

    public String getMsVorzeichen() {
        return this.msVorzeichen;
    }

    public void setMsVorzeichen(String msVorzeichen) {
        this.msVorzeichen = msVorzeichen;
    }

    public String getMsGesamtterm() {
        return this.msGesamtterm;
    }

    public void setMsGesamtterm(String msGesamtterm) {
        this.msGesamtterm = msGesamtterm;
    }

    public String getMsAusweisung() {
        return this.msAusweisung;
    }

    public void setMsAusweisung(String msAusweisung) {
        this.msAusweisung = msAusweisung;
    }

    public ArrayList<Obergruppe> getMcObergruppen() {
        return this.mcObergruppen;
    }

    public void setMcObergruppen(ArrayList<Obergruppe> mcObergruppen) {
        this.mcObergruppen = mcObergruppen;
    }

    public static Logger getLog() {
        return log;
    }

    public static void setLog(Logger log) {
        Bedingung.log = log;
    }
}

