/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.bteinfo;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.WebetkUtils;
import webetk.app.ServerGlobalObjects;
import webetk.app.bteanzeige.KommZeile;
import webetk.app.bteanzeige.RawKommZeile;
import webetk.app.bteinfo.BteHinweisTexteAdapter;
import webetk.db.dbaccess.BteAnzeigeDbAccess;
import webetk.db.dbaccess.BteInfoDbAccess;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Info
implements Serializable {
    @XmlTransient
    private static final long serialVersionUID = 1L;
    private String msBTENr;
    protected String msBildPosNr;
    private String msTitel;
    @XmlElement
    @XmlJavaTypeAdapter(value=BteHinweisTexteAdapter.class)
    protected Vector<Hashtable<String, String>> mcHinweise;
    @XmlTransient
    private static Logger log = Logger.getLogger(Info.class);

    public Info(String sBTENr, String sProduktart, String sLanguage) throws SQLException, DatabaseBusyException {
        this(sBTENr, null, sProduktart, sLanguage);
    }

    public Info() {
        this.mcHinweise = new Vector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Info(String sBTENr, String sBildPosNr, String sProduktart, String sLanguage) throws SQLException, DatabaseBusyException {
        ResultSet res;
        Connection con;
        ServerGlobalObjects gObj;
        block3: {
            this.mcHinweise = new Vector();
            this.msBildPosNr = sBildPosNr;
            this.msBTENr = sBTENr;
            this.msTitel = "";
            this.mcHinweise = null;
            gObj = ServerGlobalObjects.getInstance();
            log.info("Loading BTEInfo for BT with No: " + sBTENr + " Language: " + sLanguage);
            con = null;
            res = null;
            try {
                con = gObj.getDBConnection("Bteinfo.Info");
                res = BteInfoDbAccess.loadBTEInfo(con, sBTENr, sProduktart, sLanguage);
                if (res != null && res.next()) break block3;
            }
            catch (Throwable throwable) {
                WebetkUtils.closeQuery(res);
                gObj.freeDBConnection(con, "Bteinfo.Info");
                throw throwable;
            }
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnection(con, "Bteinfo.Info");
            return;
        }
        this.msTitel = res.getString("Ueberschrift");
        this.mcHinweise = this.loadHinweise(con, sBTENr, sLanguage);
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnection(con, "Bteinfo.Info");
    }

    public String getBTENr() {
        if (this.msBTENr == null) {
            return "";
        }
        return this.msBTENr;
    }

    public String getTitel() {
        if (this.msTitel == null) {
            return "";
        }
        return this.msTitel;
    }

    public Collection getHinweise() {
        if (this.mcHinweise == null) {
            this.mcHinweise = new Vector();
        }
        return this.mcHinweise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Vector<Hashtable<String, String>> loadHinweise(Connection con, String sBTENr, String sSprache) throws SQLException, DatabaseBusyException {
        String sTextJa = "";
        String sTextNein = "";
        ResultSet res = null;
        try {
            res = BteAnzeigeDbAccess.loadJaNein(con, sSprache);
            while (res != null && res.next()) {
                String sText = res.getString("Bezeichnung");
                if (sText.equals("+")) {
                    sTextJa = res.getString("Benennung");
                }
                if (!sText.equals("-")) continue;
                sTextNein = res.getString("Benennung");
            }
        }
        finally {
            WebetkUtils.closeQuery(res);
        }
        Vector cKommentare = new Vector();
        try {
            res = this.getActiveResultSet(con, sBTENr, sSprache);
            while (res != null && res.next()) {
                this.extrahiereKommentarZeile(cKommentare, res, sTextJa, sTextNein);
            }
        }
        finally {
            WebetkUtils.closeQuery(res);
        }
        Vector<Hashtable<String, String>> cHinweise = this.extrahiereHinweise(cKommentare);
        return cHinweise;
    }

    protected ResultSet getActiveResultSet(Connection con, String sBTENr, String sSprache) throws SQLException {
        return BteInfoDbAccess.loadBTEKommentar(con, sBTENr, sSprache);
    }

    protected Vector<Hashtable<String, String>> extrahiereHinweise(Vector cKommentare) {
        Vector<Hashtable<String, String>> cHinweise = new Vector<Hashtable<String, String>>();
        if (cKommentare != null) {
            for (RawKommZeile RawZeile2 : cKommentare) {
                KommZeile Zeile2 = new KommZeile(RawZeile2);
                Hashtable<String, String> objHashtable = new Hashtable<String, String>();
                objHashtable.put("Text", Zeile2.getText());
                objHashtable.put("Zusatz", Zeile2.getZusatz());
                cHinweise.add(objHashtable);
            }
        }
        return cHinweise;
    }

    protected void extrahiereKommentarZeile(Vector cKommentare, ResultSet res, String sTextJa, String sTextNein) throws SQLException {
        if (res.getString("Text").equals("*****")) {
            String sVorzeichen = res.getString("VZ");
            if (sVorzeichen.equals("+") || sVorzeichen.equals("-")) {
                RawKommZeile ZeileLast = (RawKommZeile)cKommentare.lastElement();
                String sVorzeichenHelp = ZeileLast.getVorzeichen();
                if (!sVorzeichenHelp.equals(" ") && !sVorzeichenHelp.equals(sVorzeichen)) {
                    log.debug("Error bei Vorzeichen-Verschiebung");
                } else {
                    ZeileLast.setVorzeichen(sVorzeichen);
                    if (sVorzeichen.equals("+")) {
                        ZeileLast.setVorzeichenString(sTextJa);
                    }
                    if (sVorzeichen.equals("-")) {
                        ZeileLast.setVorzeichenString(sTextNein);
                    }
                }
            }
            return;
        }
        RawKommZeile Zeile2 = new RawKommZeile();
        Zeile2.setText(res.getString("Text"));
        Zeile2.setCode(res.getString("Code"));
        String sVorzeichen = res.getString("VZ");
        Zeile2.setVorzeichen(sVorzeichen);
        if (sVorzeichen.equals("+")) {
            Zeile2.setVorzeichenString(sTextJa);
        }
        if (sVorzeichen.equals("-")) {
            Zeile2.setVorzeichenString(sTextNein);
        }
        Zeile2.setDarstellung(res.getString("Darstellung"));
        Zeile2.setTiefe(res.getInt("Tiefe"));
        cKommentare.add(Zeile2);
    }
}

