/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.changepoints;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import webetk.DatabaseBusyException;
import webetk.WebetkUtils;
import webetk.app.ServerGlobalObjects;
import webetk.app.bteanzeige.Changepoint;
import webetk.app.changepoints.BTEChangepointList;
import webetk.app.changepoints.ChangepointException;
import webetk.app.changepoints.ChangepointList;
import webetk.db.dbaccess.BedAuswertungDbAccess;

public class ChangepointManager
implements Serializable {
    private Map<String, ChangepointList> mcChangepoints = null;
    private transient ServerGlobalObjects moServerObjects = ServerGlobalObjects.getInstance();
    private static final String COL_ART = "Art";
    private static final String COL_DATUM = "Datum";
    private static final long serialVersionUID = 1L;

    protected ChangepointManager() throws ChangepointException {
        if (this.moServerObjects == null) {
            String message = "Zugriff auf globale Server-Objekte ist nicht moeglich!";
            throw new ChangepointException("Zugriff auf globale Server-Objekte ist nicht moeglich!");
        }
        this.mcChangepoints = new HashMap<String, ChangepointList>();
    }

    public static ChangepointManager getObject() throws ChangepointException {
        return new ChangepointManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadChangepoints(String sFgstNummer, String sBteNummer) throws ChangepointException {
        ChangepointList changepointList;
        if (sFgstNummer == null || sFgstNummer.length() == 0) {
            String message = "Fahrgestellnummer ist nicht gesetzt oder leer!";
            throw new ChangepointException("Fahrgestellnummer ist nicht gesetzt oder leer!");
        }
        if (sBteNummer == null || sBteNummer.length() == 0) {
            String message = "BTE-Nummer ist nicht gesetzt oder leer!";
            throw new ChangepointException("BTE-Nummer ist nicht gesetzt oder leer!");
        }
        if (this.moServerObjects == null) {
            String message = "Zugriff auf die globalen Server-Objekte nicht moeglich!";
            throw new ChangepointException("Zugriff auf die globalen Server-Objekte nicht moeglich!");
        }
        ChangepointList changepointList2 = changepointList = this.mcChangepoints.containsKey(sFgstNummer) ? this.mcChangepoints.get(sFgstNummer) : new ChangepointList(sFgstNummer);
        if (changepointList == null) {
            String message = "Ermittelung oder Erzeugung eines ChangepointList-Objektes fehlgeschlagen!";
            throw new ChangepointException("Ermittelung oder Erzeugung eines ChangepointList-Objektes fehlgeschlagen!");
        }
        if (!this.mcChangepoints.containsKey(sFgstNummer)) {
            this.mcChangepoints.put(sFgstNummer, changepointList);
        }
        if (!changepointList.exists(sBteNummer)) {
            BTEChangepointList bteChangepoints = new BTEChangepointList(sBteNummer);
            changepointList.addBTEChangepointList(sBteNummer, bteChangepoints);
        }
        changepointList.resetBTEList(sBteNummer);
        try {
            ResultSet results;
            Connection connection;
            block12: {
                connection = null;
                results = null;
                try {
                    connection = this.moServerObjects.getDBConnection("ChangepointManager.loadChangepoints");
                    results = BedAuswertungDbAccess.loadBTEChangepoints(connection, sBteNummer);
                    if (results == null) break block12;
                    while (results.next()) {
                        String sArt = results.getString(COL_ART);
                        Long lDatum = results.getLong(COL_DATUM);
                        Changepoint oChangepoint = new Changepoint(null, null, sArt, lDatum, null, null, null, null, null, null, null);
                        changepointList.addChangepoint(sBteNummer, oChangepoint);
                    }
                }
                catch (Throwable throwable) {
                    WebetkUtils.closeQuery(results);
                    this.moServerObjects.freeDBConnection(connection, "ChangepointManager.loadChangepoints");
                    throw throwable;
                }
            }
            WebetkUtils.closeQuery(results);
            this.moServerObjects.freeDBConnection(connection, "ChangepointManager.loadChangepoints");
        }
        catch (SQLException exc) {
            String message = "Database error: " + exc.getMessage();
            throw new ChangepointException(message, exc);
        }
        catch (DatabaseBusyException exc) {
            String message = "Database not available: " + exc.getMessage();
            throw new ChangepointException(message, exc);
        }
    }

    public boolean isBteValid(String sFgstNummer, String sBteNummer, Long lTypProddatum) throws ChangepointException {
        if (sFgstNummer == null || sFgstNummer.length() == 0) {
            return true;
        }
        if (sBteNummer == null || sBteNummer.length() == 0) {
            String message = "BTE-Nummer ist nicht gesetzt oder leer!";
            throw new ChangepointException("BTE-Nummer ist nicht gesetzt oder leer!");
        }
        if (lTypProddatum == null) {
            return true;
        }
        ChangepointList changepoints = this.mcChangepoints.get(sFgstNummer);
        if (changepoints == null) {
            return true;
        }
        return changepoints.isBTEValid(sBteNummer, lTypProddatum);
    }
}

