/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.erstbevorratung;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.NoDataFoundException;
import webetk.NoHGFoundException;
import webetk.WebetkUtils;
import webetk.app.BlaetternButton;
import webetk.app.GenericTeil;
import webetk.app.ServerGlobalObjects;
import webetk.app.fzgumfang.FzgUmfang;
import webetk.app.teileersetzung.VectorVectorAdapter;
import webetk.db.dbaccess.ErstbevorratungDbAccess;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Erstbevorratung
implements Serializable {
    @XmlTransient
    private static final long serialVersionUID = 1L;
    @XmlTransient
    private static Logger log = Logger.getLogger(Erstbevorratung.class);
    private int mnIndexAkt = -1;
    private String msAktHG;
    private String msMarke;
    private String msBaureihen;
    private String msVonHG;
    private String msBisHG;
    private String msModellspalten;
    private String msTeileUebernehmen;
    private String msLenkung;
    private Vector<String> mcHGs = new Vector();
    @XmlJavaTypeAdapter(value=VectorVectorAdapter.class)
    private Vector<Vector<GenericTeil>> mcTeile = new Vector();
    private int mnAnzahl = 0;
    private Vector<BlaetternButton> mcBlaetterButtonInfo = new Vector();

    public Erstbevorratung() {
    }

    public Erstbevorratung(FzgUmfang objFzgUmfang, String sSprache, String sLandkuerzel) throws NoDataFoundException, NoHGFoundException, SQLException, DatabaseBusyException {
        Collection cSelLenkungen;
        this.msMarke = objFzgUmfang.getMarke();
        this.msBaureihen = "";
        if (objFzgUmfang.getSelBaureihen() != null) {
            Iterator Baureihen = objFzgUmfang.getSelBaureihen().iterator();
            while (Baureihen != null && Baureihen.hasNext()) {
                this.msBaureihen = this.msBaureihen + (String)Baureihen.next() + " ";
            }
        }
        this.msTeileUebernehmen = "NurSelektierte";
        this.msVonHG = objFzgUmfang.getAbHG();
        this.msBisHG = objFzgUmfang.getBisHG();
        this.msLenkung = "";
        Collection cLenkungen = objFzgUmfang.getLenkungen();
        if (cLenkungen != null && cLenkungen.size() > 1 && (cSelLenkungen = objFzgUmfang.getSelLenkungen()) != null && cSelLenkungen.size() == 1) {
            this.msLenkung = (String)cSelLenkungen.iterator().next();
        }
        this.msModellspalten = objFzgUmfang.loadModellspalten();
        try {
            this.loadHGs(objFzgUmfang.getAbHG(), objFzgUmfang.getBisHG(), this.msModellspalten, this.msLenkung);
        }
        catch (NoDataFoundException e) {
            if (this.checkNoHG()) {
                throw new NoHGFoundException();
            }
            throw new NoDataFoundException();
        }
        Iterator<String> HGs = this.mcHGs.iterator();
        if (HGs.hasNext()) {
            this.msAktHG = HGs.next();
        }
        this.loadTeile(sSprache, this.msAktHG, this.msModellspalten, this.msLenkung, sLandkuerzel);
    }

    public Erstbevorratung(String sMarke, String sModellspaltenId, String sLenkung, String sTeileUebernehmen, Vector cHGs, String sAktHG, String sSprache, String sLandkuerzel) throws SQLException, DatabaseBusyException {
        this.msMarke = sMarke;
        this.msBaureihen = "";
        this.msVonHG = "";
        this.msBisHG = "";
        this.msModellspalten = sModellspaltenId;
        this.msLenkung = sLenkung;
        this.msTeileUebernehmen = sTeileUebernehmen;
        this.mcHGs = cHGs;
        this.msAktHG = sAktHG;
        this.loadTeile(sSprache, this.msAktHG, this.msModellspalten, this.msLenkung, sLandkuerzel);
    }

    public Erstbevorratung(Collection cBaureihen) {
        this.msBaureihen = "";
        if (cBaureihen != null) {
            Iterator Baureihen = cBaureihen.iterator();
            while (Baureihen != null && Baureihen.hasNext()) {
                this.msBaureihen = this.msBaureihen + (String)Baureihen.next() + " ";
            }
        }
    }

    public String getAktHG() {
        return this.msAktHG;
    }

    public String getMarke() {
        return this.msMarke;
    }

    public String getModellspalten() {
        return this.msModellspalten;
    }

    public Collection getTeile(int nIndex) {
        if (nIndex < 0 || nIndex >= this.mcTeile.size()) {
            return new Vector();
        }
        return this.mcTeile.get(nIndex);
    }

    public Collection getTeile() {
        return this.getTeile(this.mnIndexAkt);
    }

    public String getBaureihenString() {
        return this.msBaureihen;
    }

    public List<String> getHGs() {
        return this.mcHGs;
    }

    public Collection getHGHashtables() {
        Vector cHGHashtables = new Vector();
        Iterator<String> iter = this.mcHGs.iterator();
        int nLfdNr = 0;
        while (iter.hasNext()) {
            Hashtable<String, String> objHashtable = new Hashtable<String, String>();
            String sLfdNr = String.valueOf(++nLfdNr);
            objHashtable.put("LfdNr", sLfdNr);
            objHashtable.put("HG", iter.next());
            cHGHashtables.add(objHashtable);
        }
        return cHGHashtables;
    }

    public String getLenkung() {
        return this.msLenkung;
    }

    public Collection getTeileHashtableCollection(int nIndex) {
        Vector<Hashtable<String, String>> cTeile = new Vector<Hashtable<String, String>>();
        Collection cTeileSrc = this.getTeile(nIndex);
        Iterator iter = cTeileSrc.iterator();
        int nLfdNr = 0;
        while (iter.hasNext()) {
            GenericTeil objTeil = (GenericTeil)iter.next();
            Hashtable<String, String> objHashtable = objTeil.getHashtable();
            String sLfdNr = String.valueOf(++nLfdNr);
            objHashtable.put("LfdNr", sLfdNr);
            if ((nLfdNr - 1) % 15 == 0) {
                objHashtable.put("hatUeberschrift", "J");
            }
            cTeile.add(objHashtable);
        }
        return cTeile;
    }

    public Collection getTeileHashtableCollection() {
        return this.getTeileHashtableCollection(this.mnIndexAkt);
    }

    public String getTeileUebernehmen() {
        return this.msTeileUebernehmen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadHGs(String sHGVon, String sHGBis, String sMospIDs, String sLenkung) throws NoDataFoundException, SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Accessing database ...");
        Connection con = null;
        ResultSet res = null;
        if (sMospIDs == null) {
            log.debug("No MosIDs: No data found.");
            throw new NoDataFoundException();
        }
        try {
            con = globs.getDBConnection("Teileersetzung.loadHGs");
            log.debug("Executing query ...");
            res = ErstbevorratungDbAccess.selectHGs(con, sHGVon, sHGBis, sMospIDs, sLenkung);
            this.mcHGs = new Vector();
            if (res == null || !res.next()) {
                throw new NoDataFoundException("No values found");
            }
            while (res != null) {
                String sValue = res.getString("HG");
                this.mcHGs.add(sValue);
                if (res.next()) continue;
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            globs.freeDBConnection(con, "Teileersetzung.loadHGs");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        globs.freeDBConnection(con, "Teileersetzung.loadHGs");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadTeile(String sSprache, String sHG, String sMospIDs, String sLenkung, String sLandkuerzel) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Accessing database ...");
        Connection con = null;
        ResultSet res = null;
        try {
            con = globs.getDBConnection("Erstbevorratung.loadTeile");
            log.debug("Executing query ...");
            res = ErstbevorratungDbAccess.selectTeile(con, sSprache, sHG, sMospIDs, sLenkung, sLandkuerzel);
            int nCounter = 0;
            this.mnAnzahl = 0;
            Vector<GenericTeil> cTeile = null;
            while (res != null && res.next()) {
                String sC;
                GenericTeil objTeil = new GenericTeil();
                ++this.mnAnzahl;
                String sValue = res.getString("HG");
                objTeil.setHG(sValue);
                sValue = res.getString("UG");
                objTeil.setUG(sValue);
                sValue = res.getString("SACHNR");
                objTeil.setSachnummer(sValue);
                sValue = res.getString("BENENNUNG");
                objTeil.setBenennung(sValue);
                sValue = res.getString("ZUSATZ");
                if (sValue == null) {
                    sValue = "";
                }
                objTeil.setZusatz(sValue);
                String sSi = res.getString("SI");
                String sPi = res.getString("PI");
                String sLzb = res.getString("LZB");
                String sIdKommentar = res.getString("BENKOMMENTARID");
                boolean bIsReach = res.getString("REACH") != null && res.getString("REACH").equals("J");
                boolean bIsAspg = res.getString("ASPG") != null && res.getString("ASPG").equals("J");
                String sI = "";
                if (sSi != null && sSi.equals("J") || sLzb != null && sLzb.equals("J") || sIdKommentar != null && !sIdKommentar.equals("0") || sPi != null || bIsReach) {
                    sI = "I";
                }
                sC = (sC = res.getString("TC")) != null && sC.equals("C") ? "C" : "";
                objTeil.setZI(sI + sC);
                if (res.getString("Teil_Diebstahlrelevant") != null) {
                    objTeil.setIsTeilDiebstahlrelevant(res.getString("Teil_Diebstahlrelevant"));
                } else {
                    objTeil.setIsTeilDiebstahlrelevant("N");
                }
                if (nCounter == 0) {
                    cTeile = new Vector<GenericTeil>();
                    this.mcTeile.add(cTeile);
                }
                cTeile.add(objTeil);
                if (++nCounter != 100) continue;
                nCounter = 0;
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            globs.freeDBConnection(con, "Erstbevorratung.loadTeile");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        globs.freeDBConnection(con, "Erstbevorratung.loadTeile");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkNoHG() throws SQLException, DatabaseBusyException {
        ResultSet res;
        Connection con;
        ServerGlobalObjects globs;
        block4: {
            boolean bl;
            globs = ServerGlobalObjects.getInstance();
            if (this.msVonHG.length() == 0 || !this.msVonHG.equals(this.msBisHG)) {
                return false;
            }
            con = null;
            res = null;
            try {
                con = globs.getDBConnection("Erstbevorratung.checkNoHG");
                log.debug("Executing query ...");
                res = ErstbevorratungDbAccess.findHG(con, this.msVonHG);
                if (res != null && res.next()) break block4;
                bl = true;
            }
            catch (Throwable throwable) {
                WebetkUtils.closeQuery(res);
                globs.freeDBConnection(con, "Erstbevorratung.loadTeile");
                throw throwable;
            }
            WebetkUtils.closeQuery(res);
            globs.freeDBConnection(con, "Erstbevorratung.loadTeile");
            return bl;
        }
        boolean bl = false;
        WebetkUtils.closeQuery(res);
        globs.freeDBConnection(con, "Erstbevorratung.loadTeile");
        return bl;
    }

    public void setAktuellenIndex(int nIndex) {
        this.mnIndexAkt = nIndex;
    }

    public int getAnzahlTeile() {
        return this.mnAnzahl;
    }

    public int getAnzahlPakete() {
        return this.mcTeile.size();
    }

    public void setBlaetterButtonInfo(Collection cBlaetterButtonInfo) {
        this.mcBlaetterButtonInfo = (Vector)cBlaetterButtonInfo;
    }

    public Collection getBlaetterButtonInfo() {
        return this.mcBlaetterButtonInfo;
    }

    public Collection getBlaetterButtonCollection() {
        Vector cButtonInfo = new Vector();
        for (BlaetternButton oButton : this.mcBlaetterButtonInfo) {
            if (oButton == null) continue;
            Hashtable<String, String> oHashtable = new Hashtable<String, String>();
            oHashtable.put("Index", Integer.toString(oButton.getIndex()));
            oHashtable.put("Beschriftung", oButton.getBeschriftung());
            if (oButton.isSensitiv()) {
                oHashtable.put("isSensitiv", "J");
            }
            cButtonInfo.add(oHashtable);
        }
        return cButtonInfo;
    }
}

