/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.etktext;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.WebetkUtils;
import webetk.app.Bedingung;
import webetk.app.ServerGlobalObjects;
import webetk.app.etktext.ETKKommentarAdapter;
import webetk.app.etktext.ETKText;
import webetk.app.etktext.ETKTextZeile;
import webetk.app.etktext.ETKTexteAdapter;
import webetk.db.dbaccess.EtkTextDbAccess;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ETKTexte
implements Serializable {
    @XmlTransient
    private static final long serialVersionUID = 1L;
    @XmlTransient
    private static Logger log = Logger.getLogger(ETKTexte.class);
    private boolean mbIstGeladen = false;
    @XmlElement
    @XmlJavaTypeAdapter(value=ETKKommentarAdapter.class)
    public HashMap<Long, Vector<String>> mETKKommentare = new HashMap();
    @XmlElement
    @XmlJavaTypeAdapter(value=ETKTexteAdapter.class)
    public HashMap<String, HashMap<Long, ETKText>> mETKTexte = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(String sISO, String sRegISO) throws SQLException, DatabaseBusyException {
        this.mETKKommentare.clear();
        this.mETKTexte.clear();
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info("Loading from DB ");
        Connection con = null;
        ResultSet res = null;
        try {
            long lKommId;
            con = gObj.getDBConnection("ETKTexte.load");
            res = EtkTextDbAccess.loadETKTexte(con);
            while (res.next()) {
                String sProduktart = res.getString("Produktart");
                String sHG = res.getString("HG");
                String sFG = res.getString("FG");
                if (sFG.equals("00")) {
                    sFG = "";
                }
                lKommId = res.getLong("KommId");
                long lBedId = res.getLong("ElemId");
                ETKText oETKText = new ETKText(new Long(lKommId));
                HashMap<Long, ETKText> oETKTextHGFG = this.mETKTexte.get(sProduktart + "_" + sHG + sFG);
                if (oETKTextHGFG == null) {
                    oETKTextHGFG = new HashMap();
                    oETKTextHGFG.put(new Long(lBedId), oETKText);
                    this.mETKTexte.put(sProduktart + "_" + sHG + sFG, oETKTextHGFG);
                    continue;
                }
                oETKTextHGFG.put(new Long(lBedId), oETKText);
            }
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnection(con, "ETKTexte.load");
            if (sRegISO == null) {
                sRegISO = "  ";
            }
            con = gObj.getDBConnection("ETKTexte.load");
            res = EtkTextDbAccess.loadETKTexteZuKommentaren(con, sISO, sRegISO);
            Vector<String> aZeilen = null;
            long lKommId_Compare = -1L;
            while (res.next()) {
                lKommId = res.getLong("KommId");
                String sText = res.getString("Text");
                if (sText.equals("*****")) continue;
                if (lKommId_Compare != lKommId) {
                    lKommId_Compare = lKommId;
                    aZeilen = new Vector<String>();
                    this.mETKKommentare.put(new Long(lKommId), aZeilen);
                }
                aZeilen.add(sText);
            }
            this.mbIstGeladen = true;
        }
        catch (Exception e) {
            try {
                log.info("failed with error " + e.getMessage());
                this.mbIstGeladen = false;
            }
            catch (Throwable throwable) {
                WebetkUtils.closeQuery(res);
                gObj.freeDBConnection(con, "ETKTexte.load");
                throw throwable;
            }
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnection(con, "ETKTexte.load");
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnection(con, "ETKTexte.load");
        return true;
    }

    public Collection evalETKTexte(String sProduktart, String sHG, String sFG, Collection cBedingungen, boolean bIgnoreAnzeigeFlag, boolean bSetAngezeigt) {
        Vector<ETKTextZeile> cErgebnisTextZeilen = new Vector<ETKTextZeile>();
        boolean bLeerzeile = false;
        ETKTextZeile oZeile = null;
        Iterator iterBed = cBedingungen.iterator();
        while (iterBed.hasNext()) {
            ETKText oETKText;
            HashMap<Long, ETKText> oETKTextHGFG;
            ETKText oETKText2;
            boolean bShowBedingung = true;
            Bedingung oBed = (Bedingung)iterBed.next();
            Long lBedId = oBed.getId();
            String sCode = oBed.getCode();
            String sBenennung = oBed.getName();
            HashMap<Long, ETKText> oETKTextHG = this.mETKTexte.get(sProduktart + "_" + sHG);
            if (oETKTextHG != null && (oETKText2 = oETKTextHG.get(lBedId)) != null) {
                Long lKommId = oETKText2.getKommId();
                if (!bIgnoreAnzeigeFlag && oETKText2.getAngezeigt()) continue;
                if (bSetAngezeigt) {
                    oETKText2.setAngezeigt(true);
                }
                if (bLeerzeile) {
                    oZeile = new ETKTextZeile("", false);
                    cErgebnisTextZeilen.add(oZeile);
                }
                oZeile = new ETKTextZeile(sCode + " " + sBenennung, true);
                cErgebnisTextZeilen.add(oZeile);
                bShowBedingung = false;
                Collection cZeilen = this.mETKKommentare.get(lKommId);
                Iterator iterZeilen = cZeilen.iterator();
                while (iterZeilen.hasNext()) {
                    cErgebnisTextZeilen.add(new ETKTextZeile((String)iterZeilen.next(), false));
                }
                bLeerzeile = true;
            }
            if ((oETKTextHGFG = this.mETKTexte.get(sProduktart + "_" + sHG + sFG)) == null || (oETKText = oETKTextHGFG.get(lBedId)) == null) continue;
            Long lKommId = oETKText.getKommId();
            if (!bIgnoreAnzeigeFlag && oETKText.getAngezeigt()) continue;
            if (bSetAngezeigt) {
                oETKText.setAngezeigt(true);
            }
            if (bLeerzeile) {
                oZeile = new ETKTextZeile("", false);
                cErgebnisTextZeilen.add(oZeile);
            }
            if (bShowBedingung) {
                oZeile = new ETKTextZeile(sCode + " " + sBenennung, true);
                cErgebnisTextZeilen.add(oZeile);
            }
            Collection cZeilen = this.mETKKommentare.get(lKommId);
            Iterator iterZeilen = cZeilen.iterator();
            while (iterZeilen.hasNext()) {
                cErgebnisTextZeilen.add(new ETKTextZeile((String)iterZeilen.next(), false));
            }
            bLeerzeile = true;
        }
        return cErgebnisTextZeilen;
    }

    public boolean hatETKTexte(String sProduktart, String sHG, String sFG, Collection cBedingungen, boolean bIgnoreAngezeigt) {
        for (Bedingung oBed : cBedingungen) {
            ETKText oETKText;
            ETKText oETKText2;
            Long lBedId = oBed.getId();
            HashMap<Long, ETKText> oETKTextHG = this.mETKTexte.get(sProduktart + "_" + sHG);
            if (oETKTextHG != null && (oETKText2 = oETKTextHG.get(lBedId)) != null) {
                if (!bIgnoreAngezeigt && oETKText2.getAngezeigt()) continue;
                return true;
            }
            HashMap<Long, ETKText> oETKTextHGFG = this.mETKTexte.get(sProduktart + "_" + sHG + sFG);
            if (oETKTextHGFG == null || (oETKText = oETKTextHGFG.get(lBedId)) == null || !bIgnoreAngezeigt && oETKText.getAngezeigt()) continue;
            return true;
        }
        return false;
    }

    public void resetAnzeigeKomplett() {
        this.resetAnzeige(null, null, null);
    }

    public void resetAnzeige(String sProduktart, String sHG, String sFG) {
        boolean bVergleichen = false;
        String sVergleich1 = "";
        String sVergleich2 = "";
        if (sProduktart != null && !sProduktart.equals("")) {
            sVergleich1 = sProduktart + "_" + sHG;
            sVergleich2 = sProduktart + "_" + sHG + sFG;
            bVergleichen = true;
        }
        Set<Map.Entry<String, HashMap<Long, ETKText>>> oSetEintraege = this.mETKTexte.entrySet();
        for (Map.Entry<String, HashMap<Long, ETKText>> oObj : oSetEintraege) {
            String oKey = oObj.getKey();
            HashMap<Long, ETKText> oETKTextReset = null;
            if (!bVergleichen) {
                oETKTextReset = oObj.getValue();
            } else if (bVergleichen && !oKey.equals(sVergleich1) && !oKey.equals(sVergleich2)) {
                oETKTextReset = oObj.getValue();
            }
            if (oETKTextReset == null) continue;
            Set<Map.Entry<Long, ETKText>> oSetEintraege2 = oETKTextReset.entrySet();
            for (Map.Entry<Long, ETKText> oObj2 : oSetEintraege2) {
                ETKText oETKText = oObj2.getValue();
                oETKText.setAngezeigt(false);
            }
        }
    }

    public boolean istGeladen() {
        return this.mbIstGeladen;
    }

    public HashMap<Long, Vector<String>> getmETKKommentare() {
        return this.mETKKommentare;
    }

    public void setmETKKommentare(HashMap<Long, Vector<String>> mETKKommentare) {
        this.mETKKommentare = mETKKommentare;
    }

    public HashMap<String, HashMap<Long, ETKText>> getmETKTexte() {
        return this.mETKTexte;
    }

    public void setmETKTexte(HashMap<String, HashMap<Long, ETKText>> mETKTexte) {
        this.mETKTexte = mETKTexte;
    }
}

