/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.fzgid;

import java.io.Serializable;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.app.fzgid.CallingServices;
import webetk.app.fzgid.FzgIdInfo;
import webetk.framework.ServerUserInfo;
import webetk.mrkprd.Produkte;

public class FzgIdControlInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static Logger log = Logger.getLogger(FzgIdControlInfo.class);
    protected String msCallingService;
    protected boolean mbCompleteId;
    protected boolean mbUpdateMode = false;
    protected boolean mbFedernAspgVIN = false;
    protected String msDefProdukArtValue;
    protected boolean mbGraphicalSearch = false;
    protected FzgIdInfo mFzgIdInfo = null;

    public String getCallingService() {
        return this.msCallingService;
    }

    public void setCallingService(String msCallingService) {
        this.msCallingService = msCallingService;
    }

    public boolean isFedernAspgVIN() {
        return this.mbFedernAspgVIN;
    }

    public void setFedernAspgVIN(boolean mbFedernAspgVIN) {
        this.mbFedernAspgVIN = mbFedernAspgVIN;
    }

    public FzgIdControlInfo(FzgIdInfo oFzgIdInfo, ServerUserInfo oUserInfo) {
        this.mFzgIdInfo = oFzgIdInfo;
        this.msDefProdukArtValue = oUserInfo.getProduktart();
    }

    public FzgIdInfo getFzgIdInfo() {
        return this.mFzgIdInfo;
    }

    public boolean doBranchToService() {
        if (this.mbCompleteId) {
            if (!this.mFzgIdInfo.isCompletelyIdentified()) {
                this.mbUpdateMode = true;
                return false;
            }
            if (!this.mFzgIdInfo.isCompletelyIdentifiedFedernAspgVIN()) {
                this.mbFedernAspgVIN = true;
                return false;
            }
        } else {
            return this.mFzgIdInfo.isNormallyIdentified();
        }
        return true;
    }

    public void setGraphicSearchIndicator(boolean bGraphicSearch) {
        this.mbGraphicalSearch = bGraphicSearch;
    }

    public boolean getGraphicSearchIndicator() {
        return this.mbGraphicalSearch;
    }

    public boolean requiresCompleteFzgId() throws IllegalArgumentException {
        return CallingServices.requiresCompleteFzgId(this.msCallingService);
    }

    public void adjustFzgId() {
        if (this.mFzgIdInfo == null) {
            return;
        }
        if (this.mFzgIdInfo.getProduktart().equals(Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung()) && (this.msCallingService.equals("Federtabelle") || this.msCallingService.equals("Fuellmengen"))) {
            log.info("Switching product to PKW due to service restrictions!");
            try {
                this.mFzgIdInfo.setProduktart(Produkte.getInstance().getProdukt("AUTO").getBerechtigung(), this.requiresCompleteFzgId());
            }
            catch (Exception ex) {
                log.error("Error in switching product to PKW: " + ex.getMessage(), ex);
                log.warn("Continuing with KRAD!");
            }
        }
        try {
            this.mFzgIdInfo.adjust(this.requiresCompleteFzgId());
        }
        catch (DatabaseBusyException ex) {
            String sFzgIdType = this.requiresCompleteFzgId() ? "complete" : "normal";
            log.error("Error in converting to " + sFzgIdType + " FzgId: " + ex.getMessage(), ex);
            log.warn("Continuing without conversion. Might cause strange GUI initialization.");
        }
        catch (SQLException ex) {
            String sFzgIdType = this.requiresCompleteFzgId() ? "complete" : "normal";
            log.error("Error in converting to " + sFzgIdType + " FzgId: " + ex.getMessage(), ex);
            log.warn("Continuing without conversion. Might cause strange GUI initialization.");
        }
        catch (IllegalArgumentException ex) {
            String sFzgIdType = this.requiresCompleteFzgId() ? "complete" : "normal";
            log.error("Error in converting to " + sFzgIdType + " FzgId: " + ex.getMessage(), ex);
            log.warn("Continuing without conversion. Might cause strange GUI initialization.");
        }
    }
}

