/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.fzgsuche;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.InvalidInitializationException;
import webetk.WebetkUtils;
import webetk.app.SearchBTETeile;
import webetk.app.ServerGlobalObjects;
import webetk.app.SucheInfo;
import webetk.app.basesuche.BaseBegriffSuche;
import webetk.app.fzgsuche.FzgSucheInfo;
import webetk.db.dbaccess.TeileSucheFzgDbAccess;
import webetk.framework.ServerSessionInfo;

@XmlRootElement(name="BegriffSucheFzg")
@XmlType(name="webetk.app.fzgsuche.BegriffSuche")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class BegriffSuche
extends BaseBegriffSuche
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(BegriffSuche.class);

    public BegriffSuche() {
    }

    public BegriffSuche(String sBegriff) throws InvalidInitializationException {
        super(sBegriff);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int performSearch(SucheInfo oSucheInfo, String sLang, ServerSessionInfo oServerSessionInfo) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        if (!(oSucheInfo instanceof FzgSucheInfo)) {
            log.error("oSucheInfo is no instance of FzgSucheInfo!");
            return 4;
        }
        FzgSucheInfo oFzgSucheInfo = (FzgSucheInfo)oSucheInfo;
        oSucheInfo.setSuchSuchbegriff(this.msSuchbegriff);
        this.mcBTEs.clear();
        this.mcTeile.clear();
        Connection con = null;
        Vector<SearchBTETeile.PartOrBTE> objKB = new Vector<SearchBTETeile.PartOrBTE>();
        ResultSet res = null;
        try {
            SearchBTETeile.PartOrBTE obj;
            con = gObj.getDBConnection("BegriffSuche.performSearch");
            String sMarke = oFzgSucheInfo.getMarke();
            String sProduktart = oFzgSucheInfo.getProduktart();
            String sKatalogumfang = oFzgSucheInfo.getKatalogumfang();
            long lModellspalte = oFzgSucheInfo.getModellspalte();
            String sLenkung = oFzgSucheInfo.getLenkung();
            String sGetriebe = oFzgSucheInfo.getGetriebe();
            String sBaujahr = oFzgSucheInfo.getBaujahr();
            String sZulassungsmonat = oFzgSucheInfo.getZulassungsmonat();
            String sFahrgestellnummer = oFzgSucheInfo.getFahrgestellnummer();
            boolean bIdentifiedByFgstnr = sFahrgestellnummer != null && !sFahrgestellnummer.equals("");
            boolean bSicherheitsrelevant = oFzgSucheInfo.isSicherheitsfahrzeug();
            sLenkung = sLenkung == null ? "kA" : sLenkung;
            sGetriebe = sGetriebe == null ? "kA" : sGetriebe;
            sBaujahr = sBaujahr == null ? "kA" : sBaujahr;
            sZulassungsmonat = sZulassungsmonat == null ? "kA" : sZulassungsmonat;
            res = TeileSucheFzgDbAccess.searchBildtafel_Begriff(con, this.mcBegriffePlus, this.mcBegriffeMinus, this.mcBegriffeOder, sLang, sMarke, sProduktart, sKatalogumfang, lModellspalte, sLenkung, sGetriebe, sBaujahr, sZulassungsmonat, bIdentifiedByFgstnr, bSicherheitsrelevant, this.includeAccessoiresBildtafeln());
            while (res != null && res.next()) {
                obj = BegriffSuche.readResultIntoBte(res, sLang, sProduktart, null, false);
                this.mcBTEs.add(obj);
            }
            WebetkUtils.closeQuery(res);
            res = TeileSucheFzgDbAccess.searchSachnummern_Begriff(con, this.mcBegriffePlus, this.mcBegriffeMinus, this.mcBegriffeOder, sLang, sMarke, sProduktart, sKatalogumfang, lModellspalte, sLenkung, sGetriebe, sBaujahr, sZulassungsmonat, bIdentifiedByFgstnr, bSicherheitsrelevant, this.includeAccessoiresBildtafeln());
            while (res != null && res.next()) {
                obj = BegriffSuche.getPartFromResult(res);
                objKB.add(obj);
            }
            WebetkUtils.closeQuery(res);
            for (SearchBTETeile.PartOrBTE oPOBTE : objKB) {
                if (oPOBTE.isCP_Kabelbaum()) {
                    if (!TeileSucheFzgDbAccess.getChangepointsKB(con, oFzgSucheInfo, oPOBTE)) continue;
                    this.mcTeile.add(oPOBTE);
                    continue;
                }
                this.mcTeile.add(oPOBTE);
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnection(con, "BegriffSuche.performSearch");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnection(con, "BegriffSuche.performSearch");
        if (this.mcBTEs.size() == 0 && this.mcTeile.size() == 0) {
            return 4;
        }
        if (this.mcBTEs.size() != 0 && this.mcTeile.size() != 0) {
            return 3;
        }
        if (this.mcBTEs.size() != 0 && this.mcTeile.size() == 0) {
            return 1;
        }
        return 2;
    }
}

