/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.fzgsuche;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.WebetkUtils;
import webetk.app.SearchBTETeile;
import webetk.app.ServerGlobalObjects;
import webetk.app.SucheInfo;
import webetk.app.fzgsuche.FzgSucheInfo;
import webetk.db.dbaccess.TeileSucheFzgDbAccess;
import webetk.framework.ServerSessionInfo;

@XmlRootElement(name="BenennungSucheFzg")
@XmlType(name="webetk.app.fzgsuche.BenennungSuche")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class BenennungSuche
extends SearchBTETeile
implements Serializable {
    private static final long serialVersionUID = 2070727143880372068L;
    private static Logger log = Logger.getLogger(BenennungSuche.class);
    private String msBenennungInit;
    private String msBenennung;

    public BenennungSuche() {
    }

    public BenennungSuche(String sBenennung) {
        this.msBenennungInit = sBenennung;
        if (sBenennung.charAt(sBenennung.length() - 1) != '*') {
            sBenennung = sBenennung + "*";
        }
        this.msBenennung = sBenennung;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int performSearch(SucheInfo oSucheInfo, String sLang, ServerSessionInfo oServerSessionInfo) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        if (!(oSucheInfo instanceof FzgSucheInfo)) {
            log.error("oSucheInfo is no instance of FzgSucheInfo!");
            return 4;
        }
        FzgSucheInfo oFzgSucheInfo = (FzgSucheInfo)oSucheInfo;
        oSucheInfo.setSuchBenennung(this.msBenennungInit);
        boolean bIGDOM = oSucheInfo.isIGDOM();
        this.mcBTEs.clear();
        this.mcTeile.clear();
        Connection con = null;
        Vector<SearchBTETeile.PartOrBTE> objKB = new Vector<SearchBTETeile.PartOrBTE>();
        ResultSet res = null;
        try {
            SearchBTETeile.PartOrBTE obj;
            con = gObj.getDBConnection("BenennungSuche.performSearch");
            String sMarke = oFzgSucheInfo.getMarke();
            String sProduktart = oFzgSucheInfo.getProduktart();
            String sKatalogumfang = oFzgSucheInfo.getKatalogumfang();
            long lModellspalte = oFzgSucheInfo.getModellspalte();
            String sLenkung = oFzgSucheInfo.getLenkung();
            String sGetriebe = oFzgSucheInfo.getGetriebe();
            String sBaujahr = oFzgSucheInfo.getBaujahr();
            String sZulassungsmonat = oFzgSucheInfo.getZulassungsmonat();
            String sFahrgestellnummer = oFzgSucheInfo.getFahrgestellnummer();
            boolean bIdentifiedByFgstnr = sFahrgestellnummer != null && !sFahrgestellnummer.equals("");
            boolean bSicherheitsrelevant = oFzgSucheInfo.isSicherheitsfahrzeug();
            sLenkung = sLenkung == null ? "kA" : sLenkung;
            sGetriebe = sGetriebe == null ? "kA" : sGetriebe;
            sBaujahr = sBaujahr == null ? "kA" : sBaujahr;
            sZulassungsmonat = sZulassungsmonat == null ? "kA" : sZulassungsmonat;
            res = TeileSucheFzgDbAccess.searchBildtafel_Benennung(con, this.msBenennung, sLang, sMarke, sProduktart, sKatalogumfang, lModellspalte, sLenkung, sGetriebe, sBaujahr, sZulassungsmonat, bIdentifiedByFgstnr, bSicherheitsrelevant, this.includeAccessoiresBildtafeln());
            SearchBTETeile.PartOrBTE.PartOrBTEHelper oPoBHelper = oServerSessionInfo.getMoSessionInfoDez() != null ? (oServerSessionInfo.getMoSessionInfoDez().isMbAusweisungenElementeAktiv() ? new SearchBTETeile.PartOrBTE.PartOrBTEHelper(oServerSessionInfo.getMoSessionInfoDez().isMbAusweisungenElementeAktiv(), oFzgSucheInfo.getModellspalte(), sLang, oServerSessionInfo.getMoSessionInfoDez().isMbNachruestungenRelevant(), oFzgSucheInfo.getRegion().equals("USA"), oFzgSucheInfo.getFahrgestellnummer() != null && !oFzgSucheInfo.getFahrgestellnummer().equals(""), oServerSessionInfo.getMoSessionInfoDez().getMoBedingungswerte_BTE()) : null) : (oServerSessionInfo.isAusweisungenElementeAktiv() ? new SearchBTETeile.PartOrBTE.PartOrBTEHelper(oServerSessionInfo.isAusweisungenElementeAktiv(), lModellspalte, sLang, oServerSessionInfo.getUserInfo().getNachruestungenRelevant(), oFzgSucheInfo.getRegion().equals("USA"), bIdentifiedByFgstnr, oServerSessionInfo.getFzgSucheInfo().getBedingungsMenge_BTE()) : null);
            while (res != null && res.next()) {
                obj = BenennungSuche.readResultIntoBte(res, sLang, sProduktart, oPoBHelper, bIGDOM);
                this.mcBTEs.add(obj);
            }
            WebetkUtils.closeQuery(res);
            res = TeileSucheFzgDbAccess.searchSachnummern_Benennung(con, this.msBenennung, sLang, sMarke, sProduktart, sKatalogumfang, lModellspalte, sLenkung, sGetriebe, sBaujahr, sZulassungsmonat, bIdentifiedByFgstnr, bSicherheitsrelevant, this.includeAccessoiresBildtafeln());
            while (res != null && res.next()) {
                obj = BenennungSuche.getPartFromResult(res);
                objKB.add(obj);
            }
            WebetkUtils.closeQuery(res);
            for (SearchBTETeile.PartOrBTE oPOBTE : objKB) {
                if (oPOBTE.isCP_Kabelbaum()) {
                    if (!TeileSucheFzgDbAccess.getChangepointsKB(con, oFzgSucheInfo, oPOBTE)) continue;
                    this.mcTeile.add(oPOBTE);
                    continue;
                }
                this.mcTeile.add(oPOBTE);
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnection(con, "BenennungSuche.performSearch");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnection(con, "BenennungSuche.performSearch");
        if (this.mcBTEs.size() == 0 && this.mcTeile.size() == 0) {
            return 4;
        }
        if (this.mcBTEs.size() != 0 && this.mcTeile.size() != 0) {
            return 3;
        }
        if (this.mcBTEs.size() != 0 && this.mcTeile.size() == 0) {
            return 1;
        }
        return 2;
    }
}

