/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.fzgumfang;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.InvalidInitializationException;
import webetk.NoDataFoundException;
import webetk.WebetkUtils;
import webetk.app.ServerGlobalObjects;
import webetk.app.ValueAndName;
import webetk.app.ValueAndNameSupport;
import webetk.db.dbaccess.FzgUmfangDbAccess;
import webetk.mrkprd.Produkte;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class FzgUmfang
implements Serializable {
    @XmlTransient
    private static final long serialVersionUID = 1L;
    @XmlTransient
    protected static Logger log = Logger.getLogger(FzgUmfang.class);
    public static final String ERSTBEVORRATUNG = "Erstbevorratung";
    public static final String TEILEVERWENDUNG_FZG = "TeileverwendungFzg";
    public static final String TEILEERSETZUNG = "Teileersetzung";
    private String msArt = null;
    private boolean mbNurInSelFzg = false;
    private Vector<String> mcSelRegionen = new Vector();
    private Vector<String> mcSelLenkungen = new Vector();
    private Vector<String> mcSelBauarten = new Vector();
    private Vector<String> mcSelBaureihen = new Vector();
    private Vector<String> mcSelKarosserien = new Vector();
    private Vector<String> mcSelModelle = new Vector();
    private Vector<String> mcDefaultRegionen = new Vector();
    private Vector<String> mcRegionen = new Vector();
    private Vector<ValueAndNameSupport> mcBauarten = new Vector();
    private Vector<ValueAndNameSupport> mcBaureihen = new Vector();
    private Vector<ValueAndNameSupport> mcKarosserien = new Vector();
    private Vector<String> mcModelle = new Vector();
    private Vector<ValueAndNameSupport> mcLenkungen = new Vector();
    private String msMarke = null;
    private String msProduktart = null;
    private String msKatalogumfang = null;
    private String msAbTag = null;
    private String msAbMonat = null;
    private String msAbJahr = null;
    private String msAbHG = null;
    private String msBisHG = null;

    public FzgUmfang() {
    }

    public FzgUmfang(String sMarke, String sProduktart, String sKatalogumfang, Collection cDefaultRegionen) throws InvalidInitializationException, SQLException, DatabaseBusyException {
        if (sMarke == null || sProduktart == null || sKatalogumfang == null || cDefaultRegionen.size() == 0) {
            log.error("no valid initialization parameters");
            throw new InvalidInitializationException("no valid initialization parameters!");
        }
        this.msMarke = sMarke;
        this.msProduktart = sProduktart;
        this.msKatalogumfang = sKatalogumfang;
        this.msAbHG = "11";
        this.mcDefaultRegionen = new Vector(cDefaultRegionen);
    }

    public String getMarke() {
        return this.msMarke;
    }

    public String getArt() {
        return this.msArt;
    }

    public void setArt(String sArt) {
        this.msArt = sArt;
    }

    public void setMarke(String sMarke) {
        this.msMarke = sMarke;
    }

    public String getProduktart() {
        return this.msProduktart;
    }

    public void setProduktart(String sProduktart) {
        this.msProduktart = sProduktart;
    }

    public String getKatalogumfang() {
        return this.msKatalogumfang;
    }

    public void setKatalogumfang(String sKatalogumfang) {
        this.msKatalogumfang = sKatalogumfang;
    }

    public Collection getRegionen() {
        return this.mcRegionen;
    }

    public void setRegionen(String[] aRegionen) {
        if (aRegionen == null) {
            this.mcRegionen = null;
            return;
        }
        this.mcRegionen = new Vector();
        for (int ii = 0; ii < aRegionen.length; ++ii) {
            this.mcRegionen.add(aRegionen[ii]);
        }
    }

    public Collection getSelRegionen() {
        return this.mcSelRegionen;
    }

    public Collection getSelRegionenExtern() {
        return this.getSelAttributeExtern(this.mcRegionen, this.mcSelRegionen);
    }

    public void setSelRegionen(String[] aSelRegionen) {
        if (aSelRegionen == null) {
            this.mcSelRegionen = null;
            return;
        }
        this.mcSelRegionen = new Vector();
        for (int ii = 0; ii < aSelRegionen.length; ++ii) {
            this.mcSelRegionen.add(aSelRegionen[ii]);
        }
    }

    public void setSelRegionen(String sSelRegion) {
        this.mcSelRegionen = new Vector();
        this.mcSelRegionen.add(sSelRegion);
    }

    public Collection getLenkungen() {
        return this.mcLenkungen;
    }

    public void setLenkungen(String[] aLenkungenValues, String[] aLenkungenNames) {
        if (aLenkungenValues == null) {
            this.mcLenkungen = null;
            return;
        }
        this.mcLenkungen = new Vector();
        for (int ii = 0; ii < aLenkungenValues.length; ++ii) {
            this.mcLenkungen.add(new ValueAndNameSupport(aLenkungenValues[ii], aLenkungenNames[ii]));
        }
    }

    public Collection getSelLenkungen() {
        return this.mcSelLenkungen;
    }

    public Collection getSelLenkungenExtern() {
        return this.getSelAttributeExtern(this.mcLenkungen, this.mcSelLenkungen);
    }

    public void setSelLenkungen(String[] aSelLenkungen) {
        if (aSelLenkungen == null) {
            this.mcSelLenkungen = null;
            return;
        }
        this.mcSelLenkungen = new Vector();
        for (int ii = 0; ii < aSelLenkungen.length; ++ii) {
            this.mcSelLenkungen.add(aSelLenkungen[ii]);
        }
    }

    public void setSelLenkungen(String sSelLenkung) {
        this.mcSelLenkungen = new Vector();
        this.mcSelLenkungen.add(sSelLenkung);
    }

    public Collection getBauarten() {
        return this.mcBauarten;
    }

    public void setBauarten(String[] aBauartenValues, String[] aBauartenNames) {
        if (aBauartenValues == null) {
            this.mcBauarten = null;
            return;
        }
        this.mcBauarten = new Vector();
        for (int ii = 0; ii < aBauartenValues.length; ++ii) {
            this.mcBauarten.add(new ValueAndNameSupport(aBauartenValues[ii], aBauartenNames[ii]));
        }
    }

    public Collection getSelBauarten() {
        return this.mcSelBauarten;
    }

    public Collection getSelBauartenExtern() {
        return this.getSelAttributeExtern(this.mcBauarten, this.mcSelBauarten);
    }

    public void setSelBauarten(String[] aSelBauarten) {
        if (aSelBauarten == null) {
            this.mcSelBauarten = null;
            return;
        }
        this.mcSelBauarten = new Vector();
        for (int ii = 0; ii < aSelBauarten.length; ++ii) {
            this.mcSelBauarten.add(aSelBauarten[ii]);
        }
    }

    public void setSelBauarten(String sSelBauart) {
        this.mcSelBauarten = new Vector();
        this.mcSelBauarten.add(sSelBauart);
    }

    public Collection getBaureihen() {
        return this.mcBaureihen;
    }

    public void setBaureihen(String[] aBaureihenValues, String[] aBaureihenNames) {
        if (aBaureihenValues == null) {
            this.mcBaureihen = null;
            return;
        }
        this.mcBaureihen = new Vector();
        for (int ii = 0; ii < aBaureihenValues.length; ++ii) {
            this.mcBaureihen.add(new ValueAndNameSupport(aBaureihenValues[ii], aBaureihenNames[ii]));
        }
    }

    public Collection getSelBaureihen() {
        return this.mcSelBaureihen;
    }

    public Collection getSelBaureihenExtern() {
        return this.getSelAttributeExtern(this.mcBaureihen, this.mcSelBaureihen);
    }

    public void setSelBaureihen(String[] aSelBaureihen) {
        if (aSelBaureihen == null) {
            this.mcSelBaureihen = null;
            return;
        }
        this.mcSelBaureihen = new Vector();
        for (int ii = 0; ii < aSelBaureihen.length; ++ii) {
            this.mcSelBaureihen.add(aSelBaureihen[ii]);
        }
    }

    public void setSelBaureihen(String sSelBaureihe) {
        this.mcSelBaureihen = new Vector();
        this.mcSelBaureihen.add(sSelBaureihe);
    }

    public Collection getKarosserien() {
        return this.mcKarosserien;
    }

    public void setKarosserien(String[] aKarosserienValues, String[] aKarosserienNames) {
        if (aKarosserienValues == null) {
            this.mcKarosserien = null;
            return;
        }
        this.mcKarosserien = new Vector();
        for (int ii = 0; ii < aKarosserienValues.length; ++ii) {
            this.mcKarosserien.add(new ValueAndNameSupport(aKarosserienValues[ii], aKarosserienNames[ii]));
        }
    }

    public Collection getSelKarosserien() {
        return this.mcSelKarosserien;
    }

    public Collection getSelKarosserienExtern() {
        return this.getSelAttributeExtern(this.mcKarosserien, this.mcSelKarosserien);
    }

    public void setSelKarosserien(String[] aSelKarosserien) {
        if (aSelKarosserien == null) {
            this.mcSelKarosserien = null;
            return;
        }
        this.mcSelKarosserien = new Vector();
        for (int ii = 0; ii < aSelKarosserien.length; ++ii) {
            this.mcSelKarosserien.add(aSelKarosserien[ii]);
        }
    }

    public void setSelKarosserien(String sSelKarosserie) {
        this.mcSelKarosserien = new Vector();
        this.mcSelKarosserien.add(sSelKarosserie);
    }

    public Collection getModelle() {
        return this.mcModelle;
    }

    public void setModelle(String[] aModelle) {
        if (aModelle == null) {
            this.mcModelle = null;
            return;
        }
        this.mcModelle = new Vector();
        for (int ii = 0; ii < aModelle.length; ++ii) {
            this.mcModelle.add(aModelle[ii]);
        }
    }

    public Collection getSelModelle() {
        return this.mcSelModelle;
    }

    public Collection getSelModelleExtern() {
        return this.getSelAttributeExtern(this.mcModelle, this.mcSelModelle);
    }

    public void setSelModelle(String[] aSelModelle) {
        if (aSelModelle == null) {
            this.mcSelModelle = null;
            return;
        }
        this.mcSelModelle = new Vector();
        for (int ii = 0; ii < aSelModelle.length; ++ii) {
            this.mcSelModelle.add(aSelModelle[ii]);
        }
    }

    public void setSelModelle(String sSelModell) {
        this.mcSelModelle = new Vector();
        this.mcSelModelle.add(sSelModell);
    }

    public String getAbTag() {
        if (this.msAbTag == null) {
            return "";
        }
        return this.msAbTag;
    }

    public void setAbTag(String sAbTag) {
        this.msAbTag = sAbTag;
    }

    public String getAbMonat() {
        if (this.msAbMonat == null) {
            return "";
        }
        return this.msAbMonat;
    }

    public void setAbMonat(String sAbMonat) {
        this.msAbMonat = sAbMonat;
    }

    public String getAbJahr() {
        if (this.msAbJahr == null) {
            return "";
        }
        return this.msAbJahr;
    }

    public void setAbJahr(String sAbJahr) {
        this.msAbJahr = sAbJahr;
    }

    public String getAbHG() {
        if (this.msAbHG == null) {
            return "";
        }
        return this.msAbHG;
    }

    public void setAbHG(String sAbHG) {
        this.msAbHG = sAbHG;
    }

    public String getBisHG() {
        if (this.msBisHG == null) {
            return "";
        }
        return this.msBisHG;
    }

    public void setBisHG(String sBisHG) {
        this.msBisHG = sBisHG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRegionen() throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Accessing database ...");
        Connection con = null;
        ResultSet res = null;
        try {
            con = globs.getDBConnection("FzgUmfang.updateRegionen");
            log.debug("Executing query ...");
            res = FzgUmfangDbAccess.selectRegionen(con, this.getMarke(), this.getProduktart(), this.getKatalogumfang(), this.mcDefaultRegionen);
            this.mcRegionen = new Vector();
            while (res != null && res.next()) {
                String sValue = res.getString("Region");
                if (res.wasNull()) {
                    log.error("***ERROR: NULL value retrieved!");
                    continue;
                }
                this.mcRegionen.add(sValue);
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            globs.freeDBConnection(con, "FzgUmfang.updateRegionen");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        globs.freeDBConnection(con, "FzgUmfang.updateRegionen");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLenkungen(String sSprache) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Accessing database ...");
        Connection con = null;
        ResultSet res = null;
        try {
            con = globs.getDBConnection("FzgUmfang.updateLenkungen");
            log.debug("Executing query ...");
            res = FzgUmfangDbAccess.selectLenkungen(con, sSprache, this.msMarke, this.msKatalogumfang, this.mcSelRegionen);
            this.mcLenkungen = new Vector();
            while (res != null && res.next()) {
                String sValue = res.getString("Lenkung");
                if (res.wasNull()) {
                    log.error("***ERROR: NULL value retrieved!");
                    continue;
                }
                String sName = res.getString("ExtLenkung");
                this.mcLenkungen.add(new ValueAndNameSupport(sValue, sName));
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            globs.freeDBConnection(con, "FzgUmfang.updateLenkungen");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        globs.freeDBConnection(con, "FzgUmfang.updateLenkungen");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBauarten(String sSprache) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Accessing database ...");
        Connection con = null;
        ResultSet res = null;
        try {
            con = globs.getDBConnection("FzgUmfang.updateBauarten");
            log.debug("Executing query ...");
            res = FzgUmfangDbAccess.selectBauarten(con, sSprache, this.getMarke(), this.getKatalogumfang(), this.mcSelRegionen);
            this.mcBauarten = new Vector();
            while (res != null && res.next()) {
                String sValue = res.getString("Bauart");
                if (res.wasNull()) {
                    log.error("***ERROR: NULL value retrieved!");
                    continue;
                }
                String sName = res.getString("ExtBauart");
                this.mcBauarten.add(new ValueAndNameSupport(sValue, sName));
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            globs.freeDBConnection(con, "FzgUmfang.updateBauarten");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        globs.freeDBConnection(con, "FzgUmfang.updateBauarten");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBaureihen(String sSprache) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Accessing database ...");
        Connection con = null;
        ResultSet res = null;
        try {
            con = globs.getDBConnection("FzgUmfang.updateBaureihen");
            log.debug("Executing query ...");
            res = FzgUmfangDbAccess.selectBaureihen(con, sSprache, this.msMarke, this.msProduktart, this.msKatalogumfang, this.mcSelRegionen, this.mcSelLenkungen, this.mcSelBauarten);
            this.mcBaureihen = new Vector();
            while (res != null && res.next()) {
                String sValue = res.getString("Baureihe");
                if (res.wasNull()) {
                    log.error("***ERROR: NULL value retrieved!");
                    continue;
                }
                String sName = res.getString("ExtBaureihe");
                this.mcBaureihen.add(new ValueAndNameSupport(sValue, sName));
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            globs.freeDBConnection(con, "FzgUmfang.updateBaureihen");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        globs.freeDBConnection(con, "FzgUmfang.updateBaureihen");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateKarosserien(String sSprache) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Accessing database ...");
        Connection con = null;
        ResultSet res = null;
        try {
            con = globs.getDBConnection("FzgUmfang.updateKarosserien");
            log.debug("Executing query ...");
            res = FzgUmfangDbAccess.selectKarosserien(con, sSprache, this.msKatalogumfang, this.mcSelRegionen, this.mcSelLenkungen, this.mcSelBaureihen);
            this.mcKarosserien = new Vector();
            while (res != null && res.next()) {
                String sValue = res.getString("Karosserie");
                if (res.wasNull()) {
                    log.error("***ERROR: NULL value retrieved!");
                    continue;
                }
                String sName = res.getString("ExtKarosserie");
                this.mcKarosserien.add(new ValueAndNameSupport(sValue, sName));
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            globs.freeDBConnection(con, "FzgUmfang.updateKarosserien");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        globs.freeDBConnection(con, "FzgUmfang.updateKarosserien");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateModelle() throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Accessing database ...");
        Connection con = null;
        ResultSet res = null;
        try {
            con = globs.getDBConnection("FzgUmfang.updateModelle");
            log.debug("Executing query ...");
            res = FzgUmfangDbAccess.selectModelle(con, this.msProduktart, this.msKatalogumfang, this.mcSelRegionen, this.mcSelLenkungen, this.mcSelBauarten, this.mcSelBaureihen, this.mcSelKarosserien);
            this.mcModelle = new Vector();
            while (res != null && res.next()) {
                String sModell = res.getString("Modell");
                if (res.wasNull()) {
                    log.error("***ERROR: NULL value retrieved!");
                    continue;
                }
                this.mcModelle.add(sModell);
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            globs.freeDBConnection(con, "FzgUmfang.updateModelle");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        globs.freeDBConnection(con, "FzgUmfang.updateModelle");
    }

    public boolean getNurInSelFzg() {
        return this.mbNurInSelFzg;
    }

    public void setNurInSelFzg(boolean bNurInSelFzg) {
        this.mbNurInSelFzg = bNurInSelFzg;
    }

    protected static boolean compare(Collection cStrings1, String[] aStrings2) {
        if (cStrings1 == null && aStrings2 == null) {
            return true;
        }
        if (cStrings1 == null || aStrings2 == null) {
            return false;
        }
        if (cStrings1.size() != aStrings2.length) {
            return false;
        }
        Iterator iStrings1 = cStrings1.iterator();
        int ii = 0;
        while (iStrings1.hasNext()) {
            String sString1 = (String)iStrings1.next();
            if (!sString1.equals(aStrings2[ii])) {
                return false;
            }
            ++ii;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String loadModellspalten() throws SQLException, DatabaseBusyException, NoDataFoundException {
        String string;
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Accessing database ...");
        Connection con = null;
        ResultSet res = null;
        try {
            con = globs.getDBConnection("FzgUmfang.loadModellspalten");
            log.debug("Executing query ...");
            res = FzgUmfangDbAccess.selectModellspalten(con, this.getProduktart(), this.getKatalogumfang(), this.getSelRegionen(), this.getSelLenkungen(), this.getSelBauarten(), this.getSelBaureihen(), this.getSelKarosserien(), this.getSelModelle());
            String sModellspalten = "";
            while (res != null && res.next()) {
                String sValue = res.getString("MospID");
                if (sModellspalten.length() > 0) {
                    sModellspalten = sModellspalten + ",";
                }
                sModellspalten = sModellspalten + sValue;
            }
            string = sModellspalten;
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            globs.freeDBConnection(con, "FzgUmfang.loadModellspalten");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        globs.freeDBConnection(con, "FzgUmfang.loadModellspalten");
        return string;
    }

    public Collection getSelRegionenAsCollection() {
        return this.getSelAttributeAsCollection(this.mcRegionen, this.mcSelRegionen);
    }

    public Collection getSelBauartenAsCollection() {
        return this.getSelAttributeAsCollection(this.mcBauarten, this.mcSelBauarten);
    }

    public Collection getSelBaureihenAsCollection() {
        return this.getSelAttributeAsCollection(this.mcBaureihen, this.mcSelBaureihen);
    }

    public Collection getSelLenkungenAsCollection() {
        return this.getSelAttributeAsCollection(this.mcLenkungen, this.mcSelLenkungen);
    }

    public Collection getSelKarosserienAsCollection() {
        return this.getSelAttributeAsCollection(this.mcKarosserien, this.mcSelKarosserien);
    }

    public Collection getSelModelleAsCollection() {
        return this.getSelAttributeAsCollection(this.mcModelle, this.mcSelModelle);
    }

    public Collection getSelAttributeAsCollection(Collection aAlle, Collection aSel) {
        Vector aResult = new Vector();
        if (aSel == null || aAlle == null) {
            return aResult;
        }
        block0: for (String sToFind : aSel) {
            for (Object oObject : aAlle) {
                String sToCompare = null;
                if (oObject instanceof String) {
                    sToCompare = (String)oObject;
                } else if (oObject instanceof ValueAndName) {
                    sToCompare = ((ValueAndName)oObject).getValue();
                } else if (oObject instanceof ValueAndNameSupport) {
                    sToCompare = ((ValueAndNameSupport)oObject).getValue();
                } else {
                    log.debug("getSelAttributeAsCollection: unsupportet class " + oObject.getClass());
                }
                if (sToCompare == null || !sToCompare.equals(sToFind)) continue;
                aResult.add(oObject);
                continue block0;
            }
        }
        return aResult;
    }

    public Collection getSelAttributeExtern(Collection aAlle, Collection aSel) {
        Vector<String> aResult = new Vector<String>();
        if (aSel == null || aAlle == null) {
            return aResult;
        }
        block0: for (String sToFind : aSel) {
            for (Object oObject : aAlle) {
                String sToCompare = null;
                String sName = null;
                if (oObject instanceof String) {
                    sName = sToCompare = (String)oObject;
                } else if (oObject instanceof ValueAndName) {
                    sToCompare = ((ValueAndName)oObject).getValue();
                    sName = ((ValueAndName)oObject).getName();
                } else if (oObject instanceof ValueAndNameSupport) {
                    sToCompare = ((ValueAndNameSupport)oObject).getValue();
                    sName = ((ValueAndNameSupport)oObject).getName();
                } else {
                    log.debug("getSelAttributeAsCollection: unsupportet class " + oObject.getClass());
                }
                if (sToCompare == null || !sToCompare.equals(sToFind)) continue;
                aResult.add(sName);
                continue block0;
            }
        }
        return aResult;
    }

    public String getFzgUmfangStringFuerHeader(int nAnzahl) {
        if (this.msProduktart.equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung())) {
            return this.erzeugeFzgUmfangStringFuerHeader(nAnzahl, this.getSelRegionenAsCollection(), this.getSelLenkungenAsCollection(), this.getSelBaureihenAsCollection(), this.getSelKarosserienAsCollection(), this.getSelModelleAsCollection());
        }
        return this.erzeugeFzgUmfangStringFuerHeader(nAnzahl, this.getSelRegionenAsCollection(), this.getSelBauartenAsCollection(), this.getSelBaureihenAsCollection(), this.getSelModelleAsCollection());
    }

    public String erzeugeFzgUmfangStringFuerHeader(int nAnzahl, Collection cRegionen, Collection cLenkungen, Collection cBaureihen, Collection cKarosserien, Collection cModelle) {
        String sResult = "";
        sResult = this.appendCollectionFzgUmfangString(sResult, nAnzahl, cRegionen);
        sResult = this.appendCollectionFzgUmfangString(sResult, nAnzahl, cLenkungen);
        sResult = this.appendCollectionFzgUmfangString(sResult, nAnzahl, cBaureihen);
        sResult = this.appendCollectionFzgUmfangString(sResult, nAnzahl, cKarosserien);
        sResult = this.appendCollectionFzgUmfangString(sResult, nAnzahl, cModelle);
        return sResult;
    }

    public String erzeugeFzgUmfangStringFuerHeader(int nAnzahl, Collection cRegionen, Collection cBauarten, Collection cBaureihen, Collection cModelle) {
        String sResult = "";
        sResult = this.appendCollectionFzgUmfangString(sResult, nAnzahl, cRegionen);
        sResult = this.appendCollectionFzgUmfangString(sResult, nAnzahl, cBauarten);
        sResult = this.appendCollectionFzgUmfangString(sResult, nAnzahl, cBaureihen);
        sResult = this.appendCollectionFzgUmfangString(sResult, nAnzahl, cModelle);
        return sResult;
    }

    public String appendCollectionFzgUmfangString(String sBisher, int nAnzahl, Collection cStrings) {
        if (cStrings == null || cStrings.size() == 0) {
            return sBisher;
        }
        if (sBisher != null && !sBisher.equals("") && sBisher.charAt(sBisher.length() - 1) == '>') {
            return sBisher;
        }
        if (sBisher != null && sBisher.length() > 0) {
            sBisher = sBisher + "; ";
        }
        Iterator iterator = cStrings.iterator();
        boolean bFirst = true;
        String sAppend = null;
        while (iterator.hasNext()) {
            String sString;
            Object oObject = iterator.next();
            if (oObject instanceof String) {
                sString = (String)oObject;
            } else if (oObject instanceof ValueAndName) {
                sString = ((ValueAndName)oObject).getName();
            } else if (oObject instanceof ValueAndNameSupport) {
                sString = ((ValueAndNameSupport)oObject).getName();
            } else {
                log.error("appendCollectionFzgUmfangString: unsupported class" + oObject.getClass());
                continue;
            }
            sAppend = bFirst ? sString : ", " + sString;
            bFirst = false;
            if ((sBisher + sAppend).length() <= nAnzahl) {
                sBisher = sBisher + sAppend;
                continue;
            }
            sBisher = sBisher + " >>";
            return sBisher;
        }
        return sBisher;
    }
}

