/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.hilfe;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.WebetkUtils;
import webetk.app.ServerGlobalObjects;
import webetk.app.hilfe.Teileart;
import webetk.db.dbaccess.HilfeDbAccess;

public class Attributlisten
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(Attributlisten.class);
    private String msSprache = null;
    private Collection<Hashtable<String, String>> mcTeilearten = null;

    public Attributlisten(String sSprache) {
        this.msSprache = sSprache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Teileart> load() throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Accessing database ...");
        ArrayList<Teileart> retval = new ArrayList<Teileart>();
        Connection con = null;
        ResultSet res = null;
        try {
            con = globs.getDBConnection("Attributlisten.load");
            res = HilfeDbAccess.loadBedeutungen(con, "TA", this.msSprache);
            String sPrevWert = "";
            String sBedeutung = "";
            String sWert = "";
            while (res != null && res.next()) {
                sWert = res.getString("WERT");
                if (!sWert.equals(sPrevWert)) {
                    if (!sPrevWert.equals("")) {
                        retval.add(new Teileart(sPrevWert, sBedeutung));
                    }
                    sPrevWert = sWert;
                    sBedeutung = res.getString("BEDEUTUNG");
                    continue;
                }
                if (res.getString("BEDEUTUNG").equals("*****")) continue;
                sBedeutung = sBedeutung + " " + res.getString("BEDEUTUNG");
            }
            if (!sWert.equals("")) {
                retval.add(new Teileart(sWert, sBedeutung));
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            globs.freeDBConnection(con, "Attributlisten.load");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        globs.freeDBConnection(con, "Attributlisten.load");
        return retval;
    }

    public void loadIntoHashtable() throws SQLException, DatabaseBusyException {
        this.mcTeilearten = new Vector<Hashtable<String, String>>();
        List<Teileart> lTArt = this.load();
        for (Teileart tArt : lTArt) {
            Hashtable<String, String> objHashtable = new Hashtable<String, String>();
            objHashtable.put("Wert", tArt.getWert());
            objHashtable.put("Bedeutung", tArt.getBedeutung());
            this.mcTeilearten.add(objHashtable);
        }
    }

    public Collection<Hashtable<String, String>> getTeilearten() {
        if (this.mcTeilearten != null) {
            Iterator<Hashtable<String, String>> iter = this.mcTeilearten.iterator();
            int nLfdNr = 0;
            while (iter.hasNext()) {
                Hashtable<String, String> objHashtable = iter.next();
                String sLfdNr = String.valueOf(++nLfdNr);
                objHashtable.put("LfdNr", sLfdNr);
                if ((nLfdNr - 1) % 15 != 0) continue;
                objHashtable.put("hatUeberschrift", "J");
            }
        }
        return this.mcTeilearten;
    }
}

