/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.konfiguration;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.WebetkUtils;
import webetk.app.ServerGlobalObjects;
import webetk.app.konfiguration.Filiale;
import webetk.db.dbaccess.KonfigurationDbAccess;

public class Filialen {
    private static Logger log = Logger.getLogger(Filialen.class);
    private String msFirmaId = null;
    private Vector<Filiale> mcFilialen = new Vector();

    public Filialen(String sFirmaId) {
        this.msFirmaId = sFirmaId;
    }

    public Vector<Filiale> getFilialen() {
        return this.mcFilialen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFilialen() throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info("Loading SprachenFilialen");
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnectionNutzer("Filialen.load");
            res = KonfigurationDbAccess.loadFilialen(con, this.msFirmaId);
            if (res != null) {
                while (res.next()) {
                    String sId = res.getString("Id");
                    String sBezeichnung = res.getString("Bezeichnung");
                    this.mcFilialen.add(new Filiale(sId, sBezeichnung, this.msFirmaId));
                }
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnectionNutzer(con, "Filialen.load");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnectionNutzer(con, "Filialen.load");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFilialenSprachen() throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info("Loading SprachenFilialen");
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnectionNutzer("Filialen.loadFilialenSprachen");
            res = KonfigurationDbAccess.loadFilialenSprachen(con, this.msFirmaId);
            if (res != null) {
                while (res.next()) {
                    String sId = res.getString("Id");
                    String sBezeichnung = res.getString("Bezeichnung");
                    String sIso = res.getString("Iso");
                    String sRegIso = res.getString("RegIso");
                    this.mcFilialen.add(new Filiale(sId, sBezeichnung, this.msFirmaId, sIso, sRegIso));
                }
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnectionNutzer(con, "Filialen.load");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnectionNutzer(con, "Filialen.load");
    }
}

