/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.konfiguration;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.WebetkUtils;
import webetk.app.ServerGlobalObjects;
import webetk.app.konfiguration.Sprache;
import webetk.db.dbaccess.KonfigurationDbAccess;

public class Sprachen
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(Sprachen.class);
    private Vector<Sprache> mcSprachen = new Vector();
    private String msIso;
    private String msRegIso;

    public Sprachen(String sIso, String sRegIso) {
        this.msIso = sIso;
        this.msRegIso = sRegIso;
    }

    public Vector<Sprache> getSprachen() {
        return this.mcSprachen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadSprachen() throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info("Loading Sprachen");
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnection("Sprachen.load");
            res = KonfigurationDbAccess.loadSprachen(con, this.msIso, this.msRegIso);
            if (res != null) {
                while (res.next()) {
                    String sCode = res.getString("Code");
                    String sBenennung = res.getString("Benennung");
                    this.mcSprachen.add(new Sprache(sBenennung, sCode));
                }
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnection(con, "Sprachen.load");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnection(con, "Sprachen.load");
    }
}

