/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.newstexte;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.WebetkUtils;
import webetk.app.ServerGlobalObjects;
import webetk.app.konfiguration.Sprache;
import webetk.app.konfiguration.Sprachen;
import webetk.app.newstexte.Newstext;
import webetk.db.dbaccess.NewstexteDbAccess;

public class Newstexte
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(Newstexte.class);
    private Sprachen oSprachen = null;
    private boolean isStandardText;
    private boolean isAktiviert;
    private String sText = null;
    private String[] sMarken = null;
    private String[] sSprachen = null;
    private String sFilePath = null;
    public static int START = 0;
    public static int SEARCH = 1;
    public static int NEW = 2;
    public static int VIEW = 3;
    public static int SAVE = 4;
    private int status = 0;
    private ArrayList<Newstext> mcNewstexte = null;
    private byte[] image = null;
    private Collection<String> aMoeglImageMarken = new Vector<String>();
    private Collection<String> aMoeglTextMarken = new Vector<String>();

    public Vector<Sprache> getAlleSprachen() {
        return this.oSprachen.getSprachen();
    }

    public void loadSprachen(String sCurrentLang) throws SQLException, DatabaseBusyException {
        this.oSprachen = sCurrentLang.length() == 2 ? new Sprachen(sCurrentLang, "  ") : new Sprachen(sCurrentLang.substring(0, 2), sCurrentLang.substring(2));
        this.oSprachen.loadSprachen();
    }

    public boolean isAktiviert() {
        return this.isAktiviert;
    }

    public boolean isStandardText() {
        return this.isStandardText;
    }

    public void setAktiviert(boolean b) {
        this.isAktiviert = b;
    }

    public void setStandardText(boolean b) {
        this.isStandardText = b;
    }

    public String getText() {
        return this.sText == null ? "" : this.sText;
    }

    public void setMarken(String[] string) {
        this.sMarken = string;
    }

    public void setSprachen(String[] string) {
        this.sSprachen = string;
    }

    public String[] getMarken() {
        return this.sMarken;
    }

    public String[] getSprachen() {
        return this.sSprachen;
    }

    public void setText(String string) {
        this.sText = string;
    }

    public boolean isMarkeSelected(String sMarke) {
        if (this.sMarken != null) {
            for (int i = 0; i < this.sMarken.length; ++i) {
                String dummy = this.sMarken[i];
                if (!dummy.equals(sMarke)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSpracheSelected(String sSprache) {
        if (this.sSprachen != null) {
            for (int i = 0; i < this.sSprachen.length; ++i) {
                String dummy = this.sSprachen[i];
                if (!dummy.equals(sSprache)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveNewstexte(String sTextMitUmbruechen) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        Connection con = null;
        try {
            con = gObj.getDBConnection("Newstexte.saveNewstexte");
            log.debug("Saving Newstexte...");
            String sIsAktuell = this.isAktiviert() ? "J" : "N";
            String sIsStandard = this.isStandardText() ? "J" : "N";
            for (int i = 0; i < this.sMarken.length; ++i) {
                String sMarke = this.sMarken[i];
                for (int j = 0; j < this.sSprachen.length; ++j) {
                    String sSprache = this.sSprachen[j];
                    NewstexteDbAccess.saveNewstext(con, sMarke, sSprache.substring(0, 2), sSprache.substring(2), sTextMitUmbruechen, sIsAktuell, sIsStandard);
                }
            }
        }
        finally {
            gObj.freeDBConnection(con, "Newstexte.saveNewstexte");
        }
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int i) {
        this.status = i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadNewstexte() throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info("Loading Newstexte");
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnection("Newstexte.load");
            this.mcNewstexte = new ArrayList();
            int id = 0;
            for (int i = 0; i < this.sMarken.length; ++i) {
                String sMarke = this.sMarken[i];
                for (int j = 0; j < this.sSprachen.length; ++j) {
                    String sIsoRegIso = this.sSprachen[j];
                    String sSprache = "";
                    for (int k = 0; k < this.oSprachen.getSprachen().size(); ++k) {
                        Sprache sprache = this.oSprachen.getSprachen().get(k);
                        if (!sprache.getCode().equals(sIsoRegIso)) continue;
                        sSprache = sprache.getBenennung();
                        break;
                    }
                    if ((res = NewstexteDbAccess.loadNewstexte(con, sMarke, sIsoRegIso.substring(0, 2), sIsoRegIso.substring(2))) == null) continue;
                    while (res.next()) {
                        String sText = res.getString("Text");
                        String sIsAktiviert = res.getString("IsAktiviert");
                        String sIsStandardText = res.getString("IsStandard");
                        this.mcNewstexte.add(new Newstext(sMarke, sSprache, sIsoRegIso, sText, sIsStandardText, sIsAktiviert, id));
                        ++id;
                    }
                }
            }
        }
        finally {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnection(con, "Newstexte.load");
        }
    }

    public ArrayList<Newstext> getNewstexte() {
        return this.mcNewstexte;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteNewstext(String sMarke, String sIsoRegIso, String sText) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info("Delete Newstext");
        Connection con = null;
        try {
            con = gObj.getDBConnection("Newstext.delete");
            NewstexteDbAccess.deleteNewstext(con, sMarke, sIsoRegIso.substring(0, 2), sIsoRegIso.substring(2), sText);
        }
        finally {
            gObj.freeDBConnection(con, "Newstext.delete");
        }
        for (int i = this.mcNewstexte.size() - 1; i >= 0; --i) {
            Newstext newstext = this.mcNewstexte.get(i);
            if (!newstext.getMarke().equals(sMarke) || !newstext.getIsoRegIso().equals(sIsoRegIso) || !newstext.getText().equals(sText)) continue;
            this.mcNewstexte.remove(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateNewstext(String sMarke, String sIsoRegIso, String sText, String sAktiv) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info("Update Newstext");
        Connection con = null;
        try {
            con = gObj.getDBConnection("Newstext.update");
            NewstexteDbAccess.updateNewstexte(con, sMarke, sIsoRegIso.substring(0, 2), sIsoRegIso.substring(2), sText, sAktiv);
        }
        finally {
            gObj.freeDBConnection(con, "Newstext.update");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateNewstexte() throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        Connection con = null;
        try {
            con = gObj.getDBConnection("Newstexte.updateNewstexte");
            log.debug("Saving Newstexte...");
            for (int i = 0; i < this.sMarken.length; ++i) {
                String sMarke = this.sMarken[i];
                for (int j = 0; j < this.sSprachen.length; ++j) {
                    String sSprache = this.sSprachen[j];
                    for (int k = this.mcNewstexte.size() - 1; k >= 0; --k) {
                        Newstext newstext = this.mcNewstexte.get(k);
                        if (!newstext.getMarke().equals(sMarke) || !newstext.getIsoRegIso().equals(sSprache)) continue;
                        NewstexteDbAccess.updateNewstexte(con, sMarke, sSprache.substring(0, 2), sSprache.substring(2), newstext.getText(), newstext.getIsAktiviert());
                    }
                }
            }
        }
        finally {
            gObj.freeDBConnection(con, "Newstexte.updateNewstexte");
        }
    }

    public String getFilePath() {
        return this.sFilePath;
    }

    public void setFilePath(String string) {
        this.sFilePath = string;
    }

    public byte[] getImage() {
        return this.image;
    }

    public void setImage(byte[] bs) {
        this.image = bs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveImage() throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        Connection con = null;
        try {
            con = gObj.getDBConnection("Newstexte.saveImage");
            log.debug("Saving Image...");
            NewstexteDbAccess.saveImage(con, this.sMarken[0], this.image);
        }
        finally {
            gObj.freeDBConnection(con, "Newstexte.saveImage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadImage(String sMarke, OutputStream out) throws SQLException, DatabaseBusyException, IOException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info("Loading Newsimage");
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnection("Newstexte.loadImage");
            res = NewstexteDbAccess.loadImage(con, sMarke);
            if (res != null) {
                while (res.next()) {
                    InputStream inStream = res.getBinaryStream("Grafik");
                    byte[] data = new byte[2048];
                    while (inStream.read(data, 0, 2048) != -1) {
                        out.write(data);
                        out.flush();
                    }
                    out.close();
                    inStream.close();
                }
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnection(con, "Newstexte.loadImage");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnection(con, "Newstexte.loadImage");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadImageMarken() throws SQLException, DatabaseBusyException, IOException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info("Loading Newsimage Marken");
        Connection con = null;
        ResultSet res = null;
        Vector<String> aMarken = new Vector<String>();
        try {
            con = gObj.getDBConnection("Newstexte.loadImageMarken");
            res = NewstexteDbAccess.loadImageMarken(con);
            if (res != null) {
                while (res.next()) {
                    aMarken.add(res.getString("Marke"));
                }
                this.setMoeglImageMarken(aMarken);
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnection(con, "Newstexte.loadImageMarken");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnection(con, "Newstexte.loadImageMarken");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTextMarken() throws SQLException, DatabaseBusyException, IOException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info("Loading Newstext Marken");
        Connection con = null;
        ResultSet res = null;
        Vector<String> aMarken = new Vector<String>();
        try {
            con = gObj.getDBConnection("Newstexte.loadTextMarken");
            res = NewstexteDbAccess.loadImageMarken(con);
            if (res != null) {
                while (res.next()) {
                    aMarken.add(res.getString("Marke"));
                }
                this.setMoeglTextMarken(aMarken);
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnection(con, "Newstexte.loadTextMarken");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnection(con, "Newstexte.loadTextMarken");
    }

    public Collection<String> getMoeglImageMarken() throws SQLException, DatabaseBusyException, IOException {
        if (this.aMoeglImageMarken == null || this.aMoeglImageMarken.isEmpty()) {
            this.loadImageMarken();
        }
        return this.aMoeglImageMarken;
    }

    public void setMoeglImageMarken(Collection<String> aMoeglImageMarken) {
        this.aMoeglImageMarken = aMoeglImageMarken;
    }

    public Collection<String> getMoeglTextMarken() throws SQLException, DatabaseBusyException, IOException {
        if (this.aMoeglTextMarken == null || this.aMoeglTextMarken.isEmpty()) {
            this.loadTextMarken();
        }
        return this.aMoeglTextMarken;
    }

    public void setMoeglTextMarken(Collection<String> aMoeglTextMarken) {
        this.aMoeglTextMarken = aMoeglTextMarken;
    }
}

