/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.notizuebersicht;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.NoDataFoundException;
import webetk.WebetkUtils;
import webetk.app.ServerGlobalObjects;
import webetk.app.notizuebersicht.Teil;
import webetk.db.dbaccess.NotizuebersichtDbAccess;

public class Notizuebersicht
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(Notizuebersicht.class);
    private String msUserID;
    private String msFirma;
    private String msSprache;
    private String msFirstHG;
    private int mnAnzTeile;
    private Collection<Teil> mcTeile;

    public Notizuebersicht(String sUserID, String sSprache) {
        this.msUserID = sUserID;
        this.msFirma = null;
        this.msSprache = sSprache;
        this.mcTeile = new Vector<Teil>();
    }

    public Notizuebersicht(String sUserID, String sFirma, String sSprache) {
        this.msUserID = sUserID;
        this.msFirma = sFirma;
        this.msSprache = sSprache;
        this.mcTeile = new Vector<Teil>();
    }

    public String getUserID() {
        return this.msUserID;
    }

    public Collection<Teil> getTeile() {
        return this.mcTeile;
    }

    public Collection<Hashtable<String, String>> getTeileHashtableCollection() {
        Vector<Hashtable<String, String>> cTeile = new Vector<Hashtable<String, String>>();
        if (this.mcTeile != null) {
            Iterator<Teil> iter = this.mcTeile.iterator();
            int nLfdNr = 0;
            while (iter.hasNext()) {
                Teil objTeil = iter.next();
                Hashtable<String, String> objHashtable = objTeil.getHashtable();
                String sLfdNr = String.valueOf(++nLfdNr);
                objHashtable.put("LfdNr", sLfdNr);
                if ((nLfdNr - 1) % 15 == 0) {
                    objHashtable.put("hatUeberschrift", "J");
                }
                cTeile.add(objHashtable);
            }
        }
        return cTeile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadTeileFirstHG() throws SQLException, DatabaseBusyException, NoDataFoundException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Accessing database ...");
        Connection con = null;
        try {
            con = globs.getDBConnection("Notizuebersicht.loadTeileFirstHG");
            log.debug("Executing query ...");
            this.mnAnzTeile = NotizuebersichtDbAccess.selectAnzahlNotizen(con, this.msUserID, this.msFirma);
            if (this.mnAnzTeile == 0) {
                throw new NoDataFoundException();
            }
            this.msFirstHG = null;
            if ((long)this.mnAnzTeile > 50L) {
                this.msFirstHG = NotizuebersichtDbAccess.selectMinHG(con, this.msUserID, this.msFirma);
            }
            this.loadTeile(con, this.msFirstHG);
        }
        finally {
            globs.freeDBConnection(con, "Notizuebersicht.loadTeileFirstHG");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadTeileZuHG(String sHG) throws SQLException, DatabaseBusyException, NoDataFoundException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Accessing database ...");
        Connection con = null;
        try {
            con = globs.getDBConnection("Notizuebersicht.loadTeileZuHG");
            log.debug("Executing query ...");
            this.loadTeile(con, sHG);
        }
        finally {
            globs.freeDBConnection(con, "Notizuebersicht.loadTeileZuHG");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadTeileAllHGs() throws SQLException, DatabaseBusyException, NoDataFoundException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Accessing database ...");
        Connection con = null;
        try {
            con = globs.getDBConnection("Notizuebersicht.loadTeileAllHGs");
            log.debug("Executing query ...");
            this.loadTeile(con, null);
        }
        finally {
            globs.freeDBConnection(con, "Notizuebersicht.loadTeileAllHGs");
        }
    }

    public int getAnzTeile() {
        return this.mnAnzTeile;
    }

    public void setAnzTeile(int nAnzTeile) {
        this.mnAnzTeile = nAnzTeile;
    }

    public String getFirstHG() {
        return this.msFirstHG;
    }

    public void setFirstHG(String sFirstHG) {
        this.msFirstHG = sFirstHG;
    }

    public boolean getShowHinweis() {
        return (long)this.mnAnzTeile > 50L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTeile(Connection con, String sHG) throws SQLException, NoDataFoundException {
        ResultSet res = null;
        try {
            log.debug("Executing query ...");
            res = NotizuebersichtDbAccess.selectNotizen(con, this.msUserID, this.msSprache, sHG, this.msFirma);
            if (res == null || !res.next()) {
                throw new NoDataFoundException();
            }
            this.mcTeile = new Vector<Teil>();
            while (res != null) {
                Teil objTeil = new Teil();
                String sValue = res.getString("HG");
                objTeil.setHG(sValue);
                sValue = res.getString("UG");
                objTeil.setUG(sValue);
                sValue = res.getString("SACHNR");
                objTeil.setSachnummer(sValue);
                sValue = res.getString("BENENNUNG");
                objTeil.setBenennung(sValue);
                String sMonat = res.getString("MONAT");
                int nJahr = res.getInt("JAHR");
                String sGueltigBis = sMonat + " " + Integer.toString(nJahr);
                objTeil.setGueltigBis(sGueltigBis);
                this.mcTeile.add(objTeil);
                if (res.next()) continue;
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
    }
}

