/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.polstercode;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.WebetkUtils;
import webetk.app.ServerGlobalObjects;
import webetk.app.polstercode.PCZeile;
import webetk.db.dbaccess.PolstercodeDbAccess;

public class PCZeilen {
    private static Logger log = Logger.getLogger(PCZeilen.class);
    private Collection mcZeilen = new Vector();
    private Iterator miZeilen = null;
    private PCZeile moZeile;

    public PCZeilen() {
    }

    public PCZeilen(String sLang) throws SQLException, DatabaseBusyException {
        this.load(sLang);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(String sLang) throws SQLException, DatabaseBusyException {
        this.mcZeilen.clear();
        this.miZeilen = null;
        this.moZeile = null;
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnection("PCZeilen.load");
            log.debug("Loading Polstercode...");
            res = PolstercodeDbAccess.loadPolstercode(con, sLang);
            while (res != null && res.next()) {
                String sArt = res.getString("Art");
                String sCode = res.getString("Code");
                String sBenennung = res.getString("Benennung");
                String sPCode = res.getString("PCode");
                long lGueltigVon = res.getLong("GueltigVon");
                long lGueltigBis = res.getLong("GueltigBis");
                PCZeile oZeile = sArt.equalsIgnoreCase("A") ? new PCZeile(sCode, sBenennung, lGueltigVon, lGueltigBis) : new PCZeile(sCode, sBenennung, sPCode, lGueltigVon, lGueltigBis);
                this.mcZeilen.add(oZeile);
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnection(con, "CurrentBTE.ladenKommentareUgb");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnection(con, "CurrentBTE.ladenKommentareUgb");
    }

    public void first() {
        if (this.mcZeilen != null) {
            this.miZeilen = this.mcZeilen.iterator();
            if (this.miZeilen.hasNext()) {
                try {
                    this.moZeile = (PCZeile)this.miZeilen.next();
                }
                catch (ClassCastException e) {
                    log.error("Store object in row collection is no PCZeile!", e);
                    this.moZeile = null;
                }
            } else {
                this.moZeile = null;
            }
        } else {
            this.miZeilen = null;
            this.moZeile = null;
        }
    }

    public void next() {
        if (this.miZeilen != null && this.miZeilen.hasNext()) {
            try {
                this.moZeile = (PCZeile)this.miZeilen.next();
            }
            catch (ClassCastException e) {
                log.error("Store object in row collection is no PCZeile!", e);
                this.moZeile = null;
            }
        } else {
            log.log(Level.ALL, "No more Zeilen.");
        }
    }

    public boolean hasNext() {
        return this.miZeilen != null && this.miZeilen.hasNext();
    }

    public boolean isEmpty() {
        return this.mcZeilen == null || this.mcZeilen.size() == 0;
    }

    public boolean isValidPosition() {
        return this.mcZeilen == null || this.mcZeilen.size() == 0 || this.miZeilen == null || this.moZeile == null;
    }

    public String getCode() {
        if (this.moZeile == null) {
            return "";
        }
        return this.moZeile.getCode();
    }

    public String getBenennung() {
        if (this.moZeile == null) {
            return "";
        }
        return this.moZeile.getBenennung();
    }

    public String getGueltigVon() {
        if (this.moZeile == null) {
            return "";
        }
        return this.moZeile.getGueltigVon();
    }

    public String getGueltigBis() {
        if (this.moZeile == null) {
            return "";
        }
        return this.moZeile.getGueltigBis();
    }

    public String getPCode() {
        if (this.moZeile == null) {
            return "";
        }
        return this.moZeile.getPCode();
    }

    public String getArt() {
        if (this.moZeile == null) {
            return "";
        }
        return this.moZeile.getArt();
    }

    public boolean hatGueltigkeitszeitraum() {
        if (this.moZeile == null) {
            return false;
        }
        return this.moZeile.hatGueltigkeitszeitraum();
    }

    public boolean hatGueltigVon() {
        if (this.moZeile == null) {
            return false;
        }
        return !this.getGueltigVon().equalsIgnoreCase("");
    }

    public boolean hatGueltigBis() {
        if (this.moZeile == null) {
            return false;
        }
        return !this.getGueltigBis().equalsIgnoreCase("");
    }

    public boolean istA() {
        if (this.getArt().equalsIgnoreCase("")) {
            return false;
        }
        return this.getArt().equalsIgnoreCase("A");
    }

    public boolean istAF() {
        if (this.getArt().equalsIgnoreCase("")) {
            return false;
        }
        return this.getArt().equalsIgnoreCase("AF");
    }
}

