/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.teileersetzung;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.NoDataFoundException;
import webetk.NoHGFoundException;
import webetk.WebetkUtils;
import webetk.app.BlaetternButton;
import webetk.app.ServerGlobalObjects;
import webetk.app.fzgumfang.FzgUmfang;
import webetk.app.teileersetzung.Teil;
import webetk.app.teileersetzung.VectorVectorAdapter;
import webetk.db.dbaccess.TeileErsetzungDbAccess;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Teileersetzung
implements Serializable {
    @XmlTransient
    private static final long serialVersionUID = 1L;
    @XmlTransient
    private static Logger log = Logger.getLogger(Teileersetzung.class);
    private int mnIndexAkt = -1;
    private String msAktHG;
    private String msMarke;
    private String msBaureihen;
    private String msEinsatzSerieTag;
    private String msEinsatzSerieMonat;
    private String msEinsatzSerieJahr;
    private String msHgVon;
    private String msHgBis;
    private String msModellspalten;
    private String msTeileUebernehmen;
    private String msLenkung;
    private Vector<String> mcHGs;
    @XmlJavaTypeAdapter(value=VectorVectorAdapter.class)
    private Vector<Vector<Teil>> mcTeile = new Vector();
    private int mnAnzahl = 0;
    private Vector<BlaetternButton> mcBlaetterButtonInfo = new Vector();

    public Teileersetzung() {
    }

    public Teileersetzung(FzgUmfang objFzgUmfang, String sSprache, String sLandkuerzel) throws NoDataFoundException, NoHGFoundException, SQLException, DatabaseBusyException {
        Collection cSelLenkungen;
        this.msMarke = objFzgUmfang.getMarke();
        this.msBaureihen = "";
        if (objFzgUmfang.getSelBaureihen() != null) {
            Iterator Baureihen = objFzgUmfang.getSelBaureihen().iterator();
            while (Baureihen != null && Baureihen.hasNext()) {
                this.msBaureihen = this.msBaureihen + (String)Baureihen.next() + " ";
            }
        }
        this.msTeileUebernehmen = "NurSelektierte";
        this.msEinsatzSerieTag = objFzgUmfang.getAbTag();
        this.msEinsatzSerieMonat = objFzgUmfang.getAbMonat();
        this.msEinsatzSerieJahr = objFzgUmfang.getAbJahr();
        this.msHgVon = objFzgUmfang.getAbHG();
        this.msHgBis = objFzgUmfang.getBisHG();
        this.msLenkung = "";
        Collection cLenkungen = objFzgUmfang.getLenkungen();
        if (cLenkungen != null && cLenkungen.size() > 1 && (cSelLenkungen = objFzgUmfang.getSelLenkungen()) != null && cSelLenkungen.size() == 1) {
            this.msLenkung = (String)cSelLenkungen.iterator().next();
        }
        this.msModellspalten = objFzgUmfang.loadModellspalten();
        Long lDatumAb = new Long(0L);
        try {
            Long lJahr = new Long(this.msEinsatzSerieJahr);
            Long lMonat = new Long(this.msEinsatzSerieMonat);
            Long lTag = new Long(this.msEinsatzSerieTag);
            lDatumAb = new Long(lJahr * 10000L + lMonat * 100L + lTag);
        }
        catch (Exception e) {
            log.debug("Kein Datum angegeben.");
        }
        try {
            this.loadHGs(objFzgUmfang.getAbHG(), objFzgUmfang.getBisHG(), lDatumAb, this.msModellspalten, this.msLenkung);
        }
        catch (NoDataFoundException e) {
            if (this.checkNoHG()) {
                throw new NoHGFoundException();
            }
            throw new NoDataFoundException();
        }
        Iterator<String> HGs = this.mcHGs.iterator();
        if (HGs.hasNext()) {
            this.msAktHG = HGs.next();
        }
        this.loadTeile(sSprache, this.msAktHG, lDatumAb, this.msModellspalten, this.msLenkung, sLandkuerzel);
    }

    public Teileersetzung(Collection<String> cBaureihen, String sEinsatzSerieTag, String sEinsatzSerieMonat, String sEinsatzSerieJahr) {
        this.msBaureihen = "";
        if (cBaureihen != null) {
            Iterator<String> Baureihen = cBaureihen.iterator();
            while (Baureihen != null && Baureihen.hasNext()) {
                this.msBaureihen = this.msBaureihen + Baureihen.next() + " ";
            }
        }
        this.msEinsatzSerieTag = sEinsatzSerieTag;
        this.msEinsatzSerieMonat = sEinsatzSerieMonat;
        this.msEinsatzSerieJahr = sEinsatzSerieJahr;
    }

    public String getAktHG() {
        return this.msAktHG;
    }

    public void setAktHG(String sAktHG) {
        this.msAktHG = sAktHG;
    }

    public String getMarke() {
        return this.msMarke;
    }

    public String getModellspalten() {
        return this.msModellspalten;
    }

    public void setModellspalten(String sModellspalten) {
        this.msModellspalten = sModellspalten;
    }

    public Collection<Teil> getTeile(int nIndex) {
        if (nIndex < 0 || nIndex >= this.mcTeile.size()) {
            return new Vector<Teil>();
        }
        return this.mcTeile.get(nIndex);
    }

    public Collection<Teil> getTeile() {
        return this.getTeile(this.mnIndexAkt);
    }

    public String getSerienEinsatzAbString() {
        if (this.msEinsatzSerieTag == null || this.msEinsatzSerieMonat == null || this.msEinsatzSerieJahr == null || this.msEinsatzSerieTag.length() == 0 || this.msEinsatzSerieMonat.length() == 0 || this.msEinsatzSerieJahr.length() == 0) {
            return "";
        }
        return this.msEinsatzSerieTag + "." + this.msEinsatzSerieMonat + "." + this.msEinsatzSerieJahr;
    }

    public String getBaureihenString() {
        return this.msBaureihen;
    }

    public void setBaureihenString(String sBaureihen) {
        this.msBaureihen = sBaureihen;
    }

    public Vector<String> getHGs() {
        return this.mcHGs;
    }

    public void setHGs(Vector<String> cHGs) {
        this.mcHGs = cHGs;
    }

    public Collection<Hashtable<String, String>> getHGHashtables() {
        Vector<Hashtable<String, String>> cHGHashtables = new Vector<Hashtable<String, String>>();
        Iterator<String> iter = this.mcHGs.iterator();
        int nLfdNr = 0;
        while (iter.hasNext()) {
            Hashtable<String, String> objHashtable = new Hashtable<String, String>();
            String sLfdNr = String.valueOf(++nLfdNr);
            objHashtable.put("LfdNr", sLfdNr);
            objHashtable.put("HG", iter.next());
            cHGHashtables.add(objHashtable);
        }
        return cHGHashtables;
    }

    public String getLenkung() {
        return this.msLenkung;
    }

    public void setLenkung(String sLenkung) {
        this.msLenkung = sLenkung;
    }

    public String getEinsatzSerieTag() {
        if (this.msEinsatzSerieTag == null) {
            return "";
        }
        return this.msEinsatzSerieTag;
    }

    public String getEinsatzSerieMonat() {
        if (this.msEinsatzSerieMonat == null) {
            return "";
        }
        return this.msEinsatzSerieMonat;
    }

    public String getEinsatzSerieJahr() {
        if (this.msEinsatzSerieJahr == null) {
            return "";
        }
        return this.msEinsatzSerieJahr;
    }

    public Collection<Hashtable<String, String>> getTeileHashtableCollection(int nIndex) {
        Vector<Hashtable<String, String>> cTeile = new Vector<Hashtable<String, String>>();
        Collection<Teil> cTeileSrc = this.getTeile(nIndex);
        Iterator<Teil> iter = cTeileSrc.iterator();
        int nLfdNr = 0;
        while (iter.hasNext()) {
            Teil objTeil = iter.next();
            Hashtable<String, String> objHashtable = objTeil.getHashtable();
            String sLfdNr = String.valueOf(++nLfdNr);
            objHashtable.put("LfdNr", sLfdNr);
            if ((nLfdNr - 1) % 15 == 0) {
                objHashtable.put("hatUeberschrift", "J");
            }
            cTeile.add(objHashtable);
        }
        return cTeile;
    }

    public Collection<Hashtable<String, String>> getTeileHashtableCollection() {
        return this.getTeileHashtableCollection(this.mnIndexAkt);
    }

    public String getTeileUebernehmen() {
        return this.msTeileUebernehmen;
    }

    public void setTeileUebernehmen(String sTeileUebernehmen) {
        this.msTeileUebernehmen = sTeileUebernehmen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadHGs(String sHGVon, String sHGBis, long lDatumAb, String sMospIDs, String sLenkung) throws NoDataFoundException, SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Accessing database ...");
        Connection con = null;
        ResultSet res = null;
        if (sMospIDs == null) {
            log.debug("No MosIDs: No data found.");
            throw new NoDataFoundException();
        }
        try {
            con = globs.getDBConnection("Teileersetzung.loadHGs");
            log.debug("Executing query ...");
            res = TeileErsetzungDbAccess.selectHGs(con, sHGVon, sHGBis, lDatumAb, sMospIDs, sLenkung);
            this.mcHGs = new Vector();
            if (res == null || !res.next()) {
                throw new NoDataFoundException("No values found");
            }
            while (res != null) {
                String sValue = res.getString("HG");
                this.mcHGs.add(sValue);
                if (res.next()) continue;
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            globs.freeDBConnection(con, "Teileersetzung.loadHGs");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        globs.freeDBConnection(con, "Teileersetzung.loadHGs");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadTeile(String sSprache, String sHG, long lDatumAb, String sMospIDs, String sLenkung, String sLandkuerzel) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Accessing database ...");
        Connection con = null;
        ResultSet res = null;
        try {
            con = globs.getDBConnection("Teileersetzung.loadTeile");
            log.debug("Executing query ...");
            res = TeileErsetzungDbAccess.selectTeile(con, sSprache, sHG, lDatumAb, sMospIDs, sLenkung, sLandkuerzel);
            int nCounter = 0;
            this.mnAnzahl = 0;
            Vector<Teil> cTeile = null;
            while (res != null && res.next()) {
                String sC;
                Teil objTeil = new Teil();
                ++this.mnAnzahl;
                String sValue = res.getString("HG");
                objTeil.setHG(sValue);
                sValue = res.getString("UG");
                objTeil.setUG(sValue);
                sValue = res.getString("SACHNR");
                objTeil.setSachnummer(sValue);
                sValue = res.getString("HGALT");
                sValue = sValue + res.getString("UGALT");
                sValue = sValue + res.getString("SACHNRALT");
                objTeil.setTeilenummerAlt(sValue);
                sValue = res.getString("AT");
                objTeil.setKzAT(sValue);
                sValue = res.getString("BENENNUNG");
                objTeil.setBenennung(sValue);
                sValue = res.getString("ZUSATZ");
                if (sValue == null) {
                    sValue = "";
                }
                objTeil.setZusatz(sValue);
                String sSi = res.getString("SI");
                String sPi = res.getString("PI");
                String sLzb = res.getString("LZB");
                String sIdKommentar = res.getString("BENKOMMENTARID");
                boolean bIsReach = res.getString("REACH") != null && res.getString("REACH").equals("J");
                String sI = "";
                if (sSi != null && sSi.equals("J") || sLzb != null && sLzb.equals("J") || sIdKommentar != null && !sIdKommentar.equals("0") || sPi != null || bIsReach) {
                    sI = "I";
                }
                sC = (sC = res.getString("TC")) != null && sC.equals("C") ? "C" : "";
                objTeil.setZI(sI + sC);
                if (res.getString("Teil_Diebstahlrelevant") != null) {
                    objTeil.setIsTeilDiebstahlrelevant(res.getString("Teil_Diebstahlrelevant"));
                } else {
                    objTeil.setIsTeilDiebstahlrelevant("N");
                }
                if (nCounter == 0) {
                    cTeile = new Vector<Teil>();
                    this.mcTeile.add(cTeile);
                }
                cTeile.add(objTeil);
                if (++nCounter != 100) continue;
                nCounter = 0;
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            globs.freeDBConnection(con, "Teileersetzung.loadTeile");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        globs.freeDBConnection(con, "Teileersetzung.loadTeile");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkNoHG() throws SQLException, DatabaseBusyException {
        ResultSet res;
        Connection con;
        ServerGlobalObjects globs;
        block4: {
            boolean bl;
            globs = ServerGlobalObjects.getInstance();
            if (this.msHgVon.length() == 0 || !this.msHgVon.equals(this.msHgBis)) {
                return false;
            }
            con = null;
            res = null;
            try {
                con = globs.getDBConnection("Teileersetzung.checkNoHG");
                log.debug("Executing query ...");
                res = TeileErsetzungDbAccess.findHG(con, this.msHgVon);
                if (res != null && res.next()) break block4;
                bl = true;
            }
            catch (Throwable throwable) {
                WebetkUtils.closeQuery(res);
                globs.freeDBConnection(con, "Teileersetzung.loadTeile");
                throw throwable;
            }
            WebetkUtils.closeQuery(res);
            globs.freeDBConnection(con, "Teileersetzung.loadTeile");
            return bl;
        }
        boolean bl = false;
        WebetkUtils.closeQuery(res);
        globs.freeDBConnection(con, "Teileersetzung.loadTeile");
        return bl;
    }

    public void setEinsatzSerieTag(String sEinsatzSerieTag) {
        this.msEinsatzSerieTag = sEinsatzSerieTag;
    }

    public void setEinsatzSerieMonat(String sEinsatzSerieMonat) {
        this.msEinsatzSerieMonat = sEinsatzSerieMonat;
    }

    public void setEinsatzSerieJahr(String sEinsatzSerieJahr) {
        this.msEinsatzSerieJahr = sEinsatzSerieJahr;
    }

    public String getHgVon() {
        return this.msHgVon;
    }

    public void setHgVon(String sHgVon) {
        this.msHgVon = sHgVon;
    }

    public String getHgBis() {
        return this.msHgBis;
    }

    public void setHgBis(String sHgBis) {
        this.msHgBis = sHgBis;
    }

    public void setMarke(String sMarke) {
        this.msMarke = sMarke;
    }

    public void setAktuellenIndex(int nIndex) {
        this.mnIndexAkt = nIndex;
    }

    public int getAnzahlTeile() {
        return this.mnAnzahl;
    }

    public int getAnzahlPakete() {
        return this.mcTeile.size();
    }

    public void setBlaetterButtonInfo(Collection<BlaetternButton> cBlaetterButtonInfo) {
        this.mcBlaetterButtonInfo = (Vector)cBlaetterButtonInfo;
    }

    public Collection<BlaetternButton> getBlaetterButtonInfo() {
        return this.mcBlaetterButtonInfo;
    }

    public Collection<Hashtable<String, String>> getBlaetterButtonCollection() {
        Vector<Hashtable<String, String>> cButtonInfo = new Vector<Hashtable<String, String>>();
        for (BlaetternButton oButton : this.mcBlaetterButtonInfo) {
            if (oButton == null) continue;
            Hashtable<String, String> oHashtable = new Hashtable<String, String>();
            oHashtable.put("Index", Integer.toString(oButton.getIndex()));
            oHashtable.put("Beschriftung", oButton.getBeschriftung());
            if (oButton.isSensitiv()) {
                oHashtable.put("isSensitiv", "J");
            }
            cButtonInfo.add(oHashtable);
        }
        return cButtonInfo;
    }
}

