/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.teileliste;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.WebetkUtils;
import webetk.app.ServerGlobalObjects;
import webetk.app.teileliste.Scoreliste;
import webetk.app.teileliste.ScorelisteJob;
import webetk.app.teileliste.ScorelisteSrp;
import webetk.app.teileliste.Teil;
import webetk.app.teileliste.Teileliste;
import webetk.db.dbaccess.TeileListeDbAccess;
import webetk.etkscore.EtkScoreTeileliste;
import webetk.etkscore.EtkScoreTeilelisteJob;
import webetk.etkscore.EtkScoreTeilelisteSrp;
import webetk.etkscore.EtkScoreTeilelisteTeil;

public class As2ServerScore {
    private static Logger log = Logger.getLogger(As2ServerScore.class);

    public static String[] holeFzgDlfIds(String firma) {
        log.info("Loading released FzgDlfIds for firma: " + firma);
        ArrayList as2ScoreListInfos = As2ServerScore.holeFzgDlfInfos(firma);
        String[] fzgDlfIds = new String[as2ScoreListInfos.size()];
        for (int i = 0; i < fzgDlfIds.length; ++i) {
            fzgDlfIds[i] = ((As2ScoreListInfo)as2ScoreListInfos.get((int)i)).fzgDlfID;
        }
        log.debug(fzgDlfIds.length + " fzgDlfIds got");
        return fzgDlfIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static ArrayList holeFzgDlfInfos(String firma) {
        ArrayList<As2ScoreListInfo> fzgDlfInfos;
        block12: {
            ResultSet res;
            Connection con;
            ServerGlobalObjects gObj;
            block11: {
                gObj = ServerGlobalObjects.getInstance();
                log.info("Loading released FzgDlfIds for firma: " + firma);
                fzgDlfInfos = null;
                con = null;
                res = null;
                con = gObj.getDBConnectionNutzer("holeFzgDlfIdsDB");
                res = TeileListeDbAccess.loadFzgDlfIds(con, firma);
                if (res == null) break block11;
                fzgDlfInfos = new ArrayList<As2ScoreListInfo>();
                As2ServerScore as2ServerScore = new As2ServerScore();
                String lastFzgDlfID = "?";
                while (res.next()) {
                    String thisFzgDlfID = res.getString("fzgDlfID");
                    if (thisFzgDlfID.compareTo(lastFzgDlfID) == 0) continue;
                    lastFzgDlfID = thisFzgDlfID;
                    As2ServerScore as2ServerScore2 = as2ServerScore;
                    as2ServerScore2.getClass();
                    As2ScoreListInfo as2ScoreListInfo = as2ServerScore2.new As2ScoreListInfo();
                    as2ScoreListInfo.fzgDlfID = thisFzgDlfID;
                    as2ScoreListInfo.firmaId = res.getString("firmaId");
                    as2ScoreListInfo.filialeId = res.getString("filialeId");
                    as2ScoreListInfo.listeId = res.getString("listeId");
                    as2ScoreListInfo.auftragsnr = res.getString("auftragsnr");
                    fzgDlfInfos.add(as2ScoreListInfo);
                }
                log.debug(fzgDlfInfos.size() + " fzgDlfInfos got");
            }
            WebetkUtils.closeQuery(res);
            try {
                gObj.freeDBConnectionNutzer(con, "holeFzgDlfIdsDB");
            }
            catch (SQLException e) {
                log.error("Fehler beim Freigeben der DB-Verbindung", e);
            }
            break block12;
            catch (Exception e) {
                try {
                    log.error("Fehler beim holen der FzgDlfIds", e);
                }
                catch (Throwable throwable) {
                    WebetkUtils.closeQuery(res);
                    try {
                        gObj.freeDBConnectionNutzer(con, "holeFzgDlfIdsDB");
                    }
                    catch (SQLException e2) {
                        log.error("Fehler beim Freigeben der DB-Verbindung", e2);
                    }
                    throw throwable;
                }
                WebetkUtils.closeQuery(res);
                try {
                    gObj.freeDBConnectionNutzer(con, "holeFzgDlfIdsDB");
                }
                catch (SQLException e3) {
                    log.error("Fehler beim Freigeben der DB-Verbindung", e3);
                }
            }
        }
        return fzgDlfInfos;
    }

    private static As2ScoreListInfo holeInfoZuFzgDlfId(String firma, String fzgDlfId) {
        log.info("getting Info for fzgDlfId " + fzgDlfId + " for firma: " + firma);
        As2ScoreListInfo as2ScoreListInfo = null;
        ArrayList as2ScoreListInfos = As2ServerScore.holeFzgDlfInfos(firma);
        for (int i = 0; i < as2ScoreListInfos.size(); ++i) {
            if (((As2ScoreListInfo)as2ScoreListInfos.get((int)i)).fzgDlfID.compareTo(fzgDlfId) != 0) continue;
            as2ScoreListInfo = (As2ScoreListInfo)as2ScoreListInfos.get(i);
            break;
        }
        if (as2ScoreListInfo != null) {
            log.debug(as2ScoreListInfo.fzgDlfID + " fzgDlfId got");
        }
        return as2ScoreListInfo;
    }

    public static EtkScoreTeileliste holeTLzuFzgDlfId(String firma, String fzgDlfId) {
        EtkScoreTeileliste tl = null;
        log.debug("retrieving given list: " + fzgDlfId + " for firma: " + firma);
        As2ScoreListInfo tlInfo = As2ServerScore.holeInfoZuFzgDlfId(firma, fzgDlfId);
        if (tlInfo == null) {
            log.info("no list for fzgDlfId " + fzgDlfId + " for firma: " + firma);
            return tl;
        }
        Scoreliste objScoreliste = new Scoreliste(tlInfo.listeId, "de", "score", tlInfo.filialeId);
        try {
            objScoreliste.reload(firma, tlInfo.filialeId);
            tl = new EtkScoreTeileliste();
            As2ServerScore.createScorelistenPos(objScoreliste, tl);
            log.debug("Scoreliste erzeugt");
        }
        catch (Exception e) {
            log.error("failure on creating list.", e);
        }
        return tl;
    }

    public static int holeListeZurueckDB(String firma, String fzgDlfId) {
        int retCode = 0;
        log.debug("Deleting given list: " + fzgDlfId + " for firma: " + firma);
        As2ScoreListInfo tlInfo = As2ServerScore.holeInfoZuFzgDlfId(firma, fzgDlfId);
        if (tlInfo == null) {
            log.info("no list for fzgDlfId " + fzgDlfId + " for firma: " + firma);
            return 1;
        }
        try {
            Teileliste.delete(tlInfo.listeId, "score", tlInfo.firmaId, tlInfo.filialeId, tlInfo.auftragsnr, true);
        }
        catch (SQLException e) {
            log.error("internal error", e);
            return 2;
        }
        catch (DatabaseBusyException e) {
            log.error("database error", e);
            return 3;
        }
        log.info("deleted list for fzgDlfId:" + fzgDlfId);
        return retCode;
    }

    public static void createScorelistenPos(Scoreliste etk, EtkScoreTeileliste score) {
        int jj = -1;
        Collection<ScorelisteJob> etkJobs = etk.getJobs();
        EtkScoreTeilelisteJob[] scoreJobs = new EtkScoreTeilelisteJob[etkJobs.size()];
        Iterator<ScorelisteJob> iterJobs = etkJobs.iterator();
        while (iterJobs.hasNext()) {
            ++jj;
            ScorelisteJob etkJob = iterJobs.next();
            EtkScoreTeilelisteJob scoreJob = new EtkScoreTeilelisteJob();
            scoreJob.setId(etkJob.getId());
            scoreJob.setBezeichung(etkJob.getBezeichnung());
            scoreJob.setLock(etkJob.isLock());
            scoreJobs[jj] = scoreJob;
            int ss = -1;
            Collection<ScorelisteSrp> etkSrps = etkJob.getSrps();
            EtkScoreTeilelisteSrp[] scoreSrps = new EtkScoreTeilelisteSrp[etkSrps.size()];
            Iterator<ScorelisteSrp> iterSrps = etkSrps.iterator();
            while (iterSrps.hasNext()) {
                ++ss;
                ScorelisteSrp etkSrp = iterSrps.next();
                EtkScoreTeilelisteSrp scoreSrp = new EtkScoreTeilelisteSrp();
                scoreSrp.setId(etkSrp.getId());
                scoreSrp.setBezeichung(etkSrp.getBezeichnung());
                scoreSrp.setLock(etkSrp.isLock());
                scoreSrp.setPaketquelle(etkSrp.getQuelle());
                scoreSrps[ss] = scoreSrp;
                int tt = -1;
                Collection<Teil> etkTeile = etkSrp.getTeile();
                EtkScoreTeilelisteTeil[] scoreTeile = new EtkScoreTeilelisteTeil[etkTeile.size()];
                Iterator<Teil> iterTeile = etkTeile.iterator();
                while (iterTeile.hasNext()) {
                    ++tt;
                    Teil etkTeil = iterTeile.next();
                    EtkScoreTeilelisteTeil scoreTeil = new EtkScoreTeilelisteTeil();
                    scoreTeil.setSachnummer(etkTeil.getTeilenummer());
                    scoreTeil.setBezeichnung(etkTeil.getBenennung());
                    scoreTeil.setMenge(Double.parseDouble(etkTeil.getMenge()));
                    scoreTeil.setPreis(etkTeil.getPreis());
                    scoreTeil.setLokalteil(etkTeil.getLokalteil());
                    scoreTeil.setAenderung(Integer.toString(etkTeil.getScoreAenderung()));
                    scoreTeil.setPruefen(etkTeil.isScorePruefen());
                    scoreTeil.setLock(etkTeil.isScoreLock());
                    scoreTeile[tt] = scoreTeil;
                }
                scoreSrps[ss].setTeile(scoreTeile);
            }
            scoreJobs[jj].setSrps(scoreSrps);
        }
        score.setJobs(scoreJobs);
    }

    private class As2ScoreListInfo {
        public String fzgDlfID;
        public String firmaId;
        public String filialeId;
        public String listeId;
        public String auftragsnr;

        private As2ScoreListInfo() {
        }
    }
}

