/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.teileliste;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.DuplicateValueException;
import webetk.InvalidDataException;
import webetk.NoDataFoundException;
import webetk.WebetkUtils;
import webetk.app.ServerGlobalObjects;
import webetk.app.ValueAndNameSupport;
import webetk.app.fzgid.Auftrag;
import webetk.app.teileliste.ComboTeilelisteItem;
import webetk.app.teileliste.RrNutzerdaten;
import webetk.app.teileliste.Teil;
import webetk.app.teileliste.TeilComparator;
import webetk.app.teileliste.TeilelisteTO;
import webetk.db.dbaccess.NotizuebersichtDbAccess;
import webetk.db.dbaccess.TeileListeDbAccess;
import webetk.mrkprd.Marken;
import webetk.utils.StringUtils;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Teileliste
implements Serializable {
    public static final String PASS_LISTE = "PaSS";
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(Teileliste.class);
    @XmlElements(value={@XmlElement(type=Teil.class)})
    protected Vector<Teil> mcTeile = new Vector();
    @XmlElement
    protected String msMarke = null;
    @XmlElement
    protected String msID;
    @XmlElement
    private String msNewID;
    @XmlElement
    protected String msNutzerID;
    @XmlElement
    private String msNutzerName;
    @XmlElement
    protected String msFiliale;
    @XmlElement
    protected String msFilialeBen;
    @XmlElement
    private Teil mSelektiertesTeil;
    @XmlElement
    private String msBemerkung;
    @XmlElement
    protected Date mdatErstellung;
    @XmlElement
    protected Date mdatAenderung;
    @XmlElement
    private String msTarget;
    @XmlElement
    private boolean mbModified = false;
    @XmlElement
    protected String msLanguage;
    @XmlElements(value={@XmlElement(type=ValueAndNameSupport.class)})
    private Vector<ValueAndNameSupport> mcAnMailAdressen = new Vector();
    @XmlElement
    private Auftrag mAuftrag;
    @XmlElement
    private String msAuftragsNrLokal = null;
    @XmlElement
    protected Long mlKundenNrLokal = null;
    @XmlElement
    protected boolean mbPrivat = false;
    @XmlElement
    protected boolean mbGesperrt = false;
    @XmlElement
    private String msFzgDlfId = null;
    @XmlElement
    protected Date mdatGesperrtAm = null;
    @XmlElement
    protected String msGesperrtVon = null;
    @XmlElement
    private long mlAbfrageId;
    @XmlElement
    private int mnStep = 0;
    @XmlElement
    private String msSapArt = null;
    @XmlElement
    private String msSapStatus = null;
    @XmlElement
    private String msVIN;
    private String msDringlichkeit;
    @XmlElement
    private String msSapOrderNo;
    @XmlElement
    private double mdSapPreisSumme = 0.0;
    @XmlElement
    private String msSapError;
    @XmlElement
    private String msSapErrorIntern = null;
    @XmlElement
    private String msSapWaehrung = null;
    @XmlElement
    private String msHistory;
    @XmlElement
    private String msSortSpalte = "";
    @XmlElement
    private String msSortAsc = "";
    @XmlElement
    private String msPartsPartnerStatus = null;
    @XmlElement
    private RrNutzerdaten moRrNutzerdaten = null;
    @XmlElement
    private boolean mbShowHintDiebstahlrelevant = false;
    @XmlElement
    private String msShowHintDiebstahlrelevantFor = "";

    public Teileliste() {
    }

    public Teileliste(String sID, String sNutzerID, String sSprache) {
        this.msID = sID;
        this.msNutzerID = sNutzerID;
        this.msLanguage = sSprache;
    }

    public Teileliste(String sID, String sNutzerID, String sSprache, boolean bSapRecht) throws SQLException, DatabaseBusyException, NoDataFoundException {
        this.msID = sID;
        this.msNutzerID = sNutzerID;
        this.msLanguage = sSprache;
        this.reload(bSapRecht);
    }

    public Teileliste(String sID, String sNutzerID, String sSprache, String sFirma, String sFiliale) throws SQLException, DatabaseBusyException, NoDataFoundException {
        this.msID = sID;
        this.msNutzerID = sNutzerID;
        this.msLanguage = sSprache;
        this.msFiliale = sFiliale;
        this.reload(sFirma, sFiliale);
    }

    public Teileliste(String sMarke, String sNutzerID, String sName, String sSprache) {
        this.msID = sName;
        this.msMarke = sMarke;
        this.msNutzerID = sNutzerID;
        this.msLanguage = sSprache;
    }

    public Teileliste(String sId, String sNutzerID, long lAbfrageId, String sHistory) {
        this.msID = sId;
        this.msNutzerID = sNutzerID;
        this.mlAbfrageId = lAbfrageId;
        this.msHistory = sHistory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(boolean bNeuanlage) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info("Storing Teileliste");
        if (bNeuanlage) {
            this.msID = this.msID.trim();
        }
        Connection con = null;
        try {
            con = gObj.getDBConnectionNutzer("Teileliste.save");
            TeileListeDbAccess.storeTeileliste(con, this, bNeuanlage);
        }
        finally {
            gObj.freeDBConnectionNutzer(con, "Teileliste.save");
        }
    }

    public void storniereAnfrage(boolean bWriteHistorie) throws SQLException, DatabaseBusyException {
        if (this.msSapArt != null && this.msSapArt.equals("A")) {
            this.deleteSapDaten();
            this.msSapArt = null;
            this.msSapStatus = "N";
            if (bWriteHistorie) {
                this.writeHistorie("ANFRAGE_STORNIERT");
            }
        }
    }

    public void saveSapAbfrage(String sFirma) throws SQLException, DatabaseBusyException {
        this.saveKopfdatenRr(sFirma);
        String sFunktion = null;
        sFunktion = this.msSapArt.equals("B") ? "BESTELLUNG_ABGECHICKT" : "ANFRAGE_ABGESCHICKT";
        this.writeHistorie(sFunktion, sFirma);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveKopfdatenRr(String sFirma) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        Connection con = null;
        try {
            con = gObj.getDBConnectionNutzer("Teileliste.saveKopfdatenRr");
            TeileListeDbAccess.saveRrNutzerdaten(con, sFirma, this.msNutzerID, this.moRrNutzerdaten);
            try {
                boolean bNeuanlage = false;
                TeileListeDbAccess.storeTeilelisteAllgemein(con, this, bNeuanlage, sFirma);
            }
            catch (DuplicateValueException ex) {
                log.error(ex);
            }
        }
        finally {
            gObj.freeDBConnectionNutzer(con, "Teileliste.saveKopfdatenRr");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertTeileInDB(String sFirma) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info("insertTeileInDB");
        Connection con = null;
        try {
            con = gObj.getDBConnectionNutzer("Teileliste.insertTeileInDB");
            TeileListeDbAccess.insertTeile(con, this, sFirma, null, null);
        }
        finally {
            gObj.freeDBConnectionNutzer(con, "Teileliste.insertTeileInDB");
        }
    }

    public void saveTeile(Collection<Teil> cTeile, String sFirma) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info("saveTeile");
        Connection con = null;
        try {
            con = gObj.getDBConnectionNutzer("Teileliste.saveTeile");
            con.setAutoCommit(false);
            for (Teil oTeil : cTeile) {
                if (!oTeil.getMustSave()) continue;
                TeileListeDbAccess.saveTeilInListe(con, oTeil, this.msID, this.msNutzerID, sFirma, this.msFiliale, null, null);
            }
            Calendar rightNow = Calendar.getInstance();
            this.mdatAenderung = rightNow.getTime();
            this.saveAenderungsdatum(con, sFirma);
        }
        catch (SQLException ex) {
            if (con != null) {
                con.rollback();
            }
            throw ex;
        }
        finally {
            if (con != null) {
                con.setAutoCommit(true);
                gObj.freeDBConnectionNutzer(con, "Teileliste.saveTeile");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(String sFirma, String sFiliale) throws SQLException, DatabaseBusyException {
        this.msFiliale = sFiliale;
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info("Inserting Teileliste");
        Calendar rightNow = Calendar.getInstance();
        this.mdatErstellung = rightNow.getTime();
        this.mdatAenderung = rightNow.getTime();
        Connection con = null;
        try {
            con = gObj.getDBConnectionNutzer("Teileliste.insert");
            TeileListeDbAccess.insertTeileliste(con, this, sFirma);
        }
        catch (DuplicateValueException ex) {
        }
        finally {
            gObj.freeDBConnectionNutzer(con, "Teileliste.insert");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert() throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info("Inserting Teileliste");
        Calendar rightNow = Calendar.getInstance();
        this.mdatErstellung = rightNow.getTime();
        this.mdatAenderung = rightNow.getTime();
        Connection con = null;
        try {
            con = gObj.getDBConnectionNutzer("Teileliste.insert");
            TeileListeDbAccess.insertTeileliste(con, this);
        }
        catch (DuplicateValueException ex) {
        }
        finally {
            gObj.freeDBConnectionNutzer(con, "Teileliste.insert");
        }
    }

    public static Teileliste insertRrListe(String sNutzerId, String sFirma, String sFiliale, String sName, String sSprache) throws SQLException, DatabaseBusyException {
        String sID = Teileliste.generateID(sName);
        Teileliste objTeileliste = new Teileliste(Marken.getInstance().getMarke("RR").getBerechtigung(), sNutzerId, sID, sSprache);
        objTeileliste.insert(sFirma, sFiliale);
        objTeileliste.loadRrNutzerdaten(null, sNutzerId, sFirma);
        return objTeileliste;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String generateID(String sName) throws SQLException, DatabaseBusyException {
        if (sName == null) {
            return "_RRSAPLIST";
        }
        String sID = null;
        sID = sName.length() > 14 ? sName.substring(0, 14) : sName;
        Connection con = null;
        try {
            con = ServerGlobalObjects.getInstance().getDBConnectionNutzer("Teileliste.generateID");
            long seq = TeileListeDbAccess.getNextRrSapListenId(con);
            sID = sID + StringUtils.addNullen(Long.toString(seq), 6);
        }
        finally {
            ServerGlobalObjects.getInstance().freeDBConnectionNutzer(con, "Teileliste.generateID");
        }
        return sID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String renameDefaultRrSapListe(String sNutzerId, String sFirma, String sFiliale, String sName) throws SQLException, DatabaseBusyException {
        String newID = Teileliste.generateID(sName);
        String oldID = "_RRSAPLIST";
        Connection con = null;
        try {
            con = ServerGlobalObjects.getInstance().getDBConnectionNutzer("Teileliste.renameDefaultRrSapListe");
            TeileListeDbAccess.renameRrSapListe(con, sFirma, sFiliale, sNutzerId, oldID, newID);
            String string = newID;
            return string;
        }
        finally {
            ServerGlobalObjects.getInstance().freeDBConnectionNutzer(con, "Teileliste.renameDefaultRrSapListe");
        }
    }

    public static Teileliste insertSammelnutzerListe(String sMarke, String sNutzerId, String sSprache) throws SQLException, DatabaseBusyException {
        String sID = Teileliste.generateIDSammelnutzerListe();
        Teileliste objTeileliste = new Teileliste(sMarke, sNutzerId, sID, sSprache);
        objTeileliste.insert();
        return objTeileliste;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String generateIDSammelnutzerListe() throws SQLException, DatabaseBusyException {
        String sID = null;
        Connection con = null;
        try {
            con = ServerGlobalObjects.getInstance().getDBConnectionNutzer("Teileliste.generateIDSammelnutzerListe");
            long seq = TeileListeDbAccess.getNextSammelnutzerListenId(con);
            sID = Long.toString(seq);
        }
        finally {
            ServerGlobalObjects.getInstance().freeDBConnectionNutzer(con, "Teileliste.generateIDSammelnutzerListe");
        }
        return sID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveKopfdaten(boolean bNeuanlage, String sFirma) throws SQLException, DatabaseBusyException, DuplicateValueException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info("Storing Teileliste");
        Connection con = null;
        try {
            con = gObj.getDBConnectionNutzer("Teileliste.saveKopfdaten");
            TeileListeDbAccess.storeTeilelisteAllgemein(con, this, bNeuanlage, sFirma);
        }
        finally {
            gObj.freeDBConnectionNutzer(con, "Teileliste.saveKopfdaten");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAenderungsdatum(String sFirma) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info("saveAenderungsdatum");
        Connection con = null;
        try {
            con = gObj.getDBConnectionNutzer("Teileliste.saveAenderungsdatum");
            TeileListeDbAccess.updateAenderungsdatum(con, this, sFirma);
        }
        finally {
            gObj.freeDBConnectionNutzer(con, "Teileliste.saveAenderungsdatum");
        }
    }

    public void saveAenderungsdatum(Connection con, String sFirma) throws SQLException {
        log.info("saveAenderungsdatum");
        TeileListeDbAccess.updateAenderungsdatum(con, this, sFirma);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sperre(String sFirma, String sSendeArt, String sAuftragsnummer, int nKundennummer, int nMitarbeiternummer, boolean bGreiferschein, boolean bRechnung, boolean bLieferschein, String sFreitext, String sPasswort, int nSondersteuerung, double dBar, double dUnbar) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info("sperre");
        this.sperre(true, sFirma);
        Connection con = null;
        try {
            con = gObj.getDBConnectionNutzer("Teileliste.sperre");
            TeileListeDbAccess.insertSendeinfo(con, this, sFirma, sSendeArt, sAuftragsnummer, nKundennummer, nMitarbeiternummer, bGreiferschein, bRechnung, bLieferschein, sFreitext, sPasswort, nSondersteuerung, dBar, dUnbar);
        }
        finally {
            gObj.freeDBConnectionNutzer(con, "Teileliste.sperre");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sperre(boolean bGesperrt, String sNutzer, String sFirma) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info("sperre");
        Connection con = null;
        try {
            con = gObj.getDBConnection("Teileliste.sperre");
            if (TeileListeDbAccess.updateSperre(con, bGesperrt, false, this, sNutzer, sFirma)) {
                this.msGesperrtVon = sNutzer;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            gObj.freeDBConnection(con, "Teileliste.sperre");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sperre(boolean bGesperrt, String sFirma) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info("sperre");
        Connection con = null;
        try {
            con = gObj.getDBConnectionNutzer("Teileliste.sperre");
            this.mbGesperrt = bGesperrt;
            TeileListeDbAccess.updateSperre(con, this, sFirma);
        }
        finally {
            gObj.freeDBConnectionNutzer(con, "Teileliste.sperre");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable<String, String> loadSendeinfo(String sFirma) throws SQLException, DatabaseBusyException {
        Hashtable<String, String> oHashTable;
        ResultSet res;
        Connection con;
        ServerGlobalObjects gObj;
        block16: {
            gObj = ServerGlobalObjects.getInstance();
            log.info("loadSendeinfo");
            con = null;
            res = null;
            oHashTable = new Hashtable<String, String>();
            try {
                String sUnbar;
                String sBar;
                String sFreitext;
                String sLieferschein;
                String sRechnung;
                String sGreiferschein;
                String sMitarbeiterNr;
                String sKundennummer;
                String sAuftragsnummer;
                con = gObj.getDBConnectionNutzer("Teileliste.loadSendeinfo");
                res = TeileListeDbAccess.loadSendeinfo(con, this.msNutzerID, sFirma, this.msFiliale, this.msID);
                if (res == null || !res.next()) break block16;
                String sArt = res.getString("Satzart");
                if (sArt != null) {
                    oHashTable.put("Satzart", sArt);
                }
                if ((sAuftragsnummer = res.getString("AuftragsNr")) != null) {
                    oHashTable.put("AuftragsNr", sAuftragsnummer);
                }
                if ((sKundennummer = res.getString("KundenNr")) != null) {
                    oHashTable.put("KundenNr", sKundennummer);
                }
                if ((sMitarbeiterNr = res.getString("MitarbeiterNr")) != null) {
                    oHashTable.put("MitarbeiterNr", sMitarbeiterNr);
                }
                if ((sGreiferschein = res.getString("Greiferschein")) != null) {
                    oHashTable.put("Greiferschein", sGreiferschein);
                }
                if ((sRechnung = res.getString("Rechnung")) != null) {
                    oHashTable.put("Rechnung", sRechnung);
                }
                if ((sLieferschein = res.getString("Lieferschein")) != null) {
                    oHashTable.put("Lieferschein", sLieferschein);
                }
                if ((sFreitext = res.getString("Freitext")) != null) {
                    oHashTable.put("Freitext", sFreitext);
                } else {
                    oHashTable.put("Freitext", "");
                }
                String sPasswort = res.getString("Passwort");
                if (sPasswort != null) {
                    oHashTable.put("Passwort", sPasswort);
                } else {
                    oHashTable.put("Passwort", "");
                }
                String sSondersteuerung = res.getString("Sondersteuerung");
                if (sSondersteuerung != null) {
                    oHashTable.put("Sondersteuerung", sSondersteuerung);
                }
                if ((sBar = res.getString("Bar")) != null) {
                    oHashTable.put("Bar", sBar);
                }
                if ((sUnbar = res.getString("Unbar")) != null) {
                    oHashTable.put("Unbar", sUnbar);
                }
            }
            catch (Throwable throwable) {
                WebetkUtils.closeQuery(res);
                gObj.freeDBConnectionNutzer(con, "Teileliste.loadSendeinfo");
                throw throwable;
            }
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnectionNutzer(con, "Teileliste.loadSendeinfo");
        return oHashTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete(String sID, String sNutzer) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info("Deleting Teileliste");
        Connection con = null;
        try {
            con = gObj.getDBConnectionNutzer("Teileliste.delete");
            TeileListeDbAccess.deleteTeileliste(con, sID, sNutzer);
        }
        finally {
            gObj.freeDBConnectionNutzer(con, "Teileliste.delete");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete(String sID, String sNutzer, String sFirma, String sFiliale, String sAuftragsnummer, boolean bScoreListe) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info("Deleting Teileliste");
        Connection con = null;
        try {
            con = gObj.getDBConnectionNutzer("Teileliste.delete");
            TeileListeDbAccess.deleteTeileliste(con, sID, sNutzer, sFirma, sFiliale, sAuftragsnummer, bScoreListe);
        }
        finally {
            gObj.freeDBConnectionNutzer(con, "Teileliste.delete");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteParts(Collection<Teil> cPartsToDelete, String sFirma) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info("Deleting Parts from Teileliste");
        Connection con = null;
        try {
            con = gObj.getDBConnectionNutzer("Teileliste.deleteParts");
            TeileListeDbAccess.deleteTeileAusTeileliste(con, cPartsToDelete, this.msID, this.msNutzerID, sFirma, this.msFiliale, false, false);
        }
        finally {
            gObj.freeDBConnectionNutzer(con, "Teileliste.deleteParts");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void aendereEigentuemer(String sNewEigentuemer, String sFirma, String sFiliale) throws SQLException, DatabaseBusyException, DuplicateValueException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info("Aendere Listeneigentuemer");
        Connection con = null;
        try {
            con = gObj.getDBConnectionNutzer("Teileliste.aendereEigentuemer");
            TeileListeDbAccess.aendereEigentuemer(con, sNewEigentuemer, this.msID, this.msNutzerID, sFirma, sFiliale);
        }
        finally {
            gObj.freeDBConnectionNutzer(con, "Teileliste.aendereEigentuemer");
        }
    }

    public String getID() {
        if (this.msID == null) {
            return "";
        }
        return this.msID;
    }

    public void setID(String sID) {
        this.msID = sID;
    }

    public String getNewID() {
        if (this.msNewID == null) {
            return "";
        }
        return this.msNewID;
    }

    public void setNewID(String sNewID) {
        this.msNewID = sNewID;
    }

    public String getNutzerID() {
        return this.msNutzerID;
    }

    public void setNutzerID(String sNutzerID) {
        this.msNutzerID = sNutzerID;
    }

    public String getNutzerName() {
        return this.msNutzerName;
    }

    public void setNutzerName(String sNutzerName) {
        this.msNutzerName = sNutzerName;
    }

    public String getFiliale() {
        return this.msFiliale;
    }

    public void setFiliale(String sFiliale) {
        this.msFiliale = sFiliale;
    }

    public String getFilialeBen() {
        return this.msFilialeBen;
    }

    public void setFilialeBen(String sFilialeBen) {
        this.msFilialeBen = sFilialeBen;
    }

    public Vector<Teil> getTeile() {
        return this.mcTeile;
    }

    public void setTeile(Vector<Teil> cTeile) {
        this.mcTeile = cTeile;
    }

    public String getTarget() {
        if (this.msTarget != null) {
            return this.msTarget;
        }
        return "";
    }

    public void setTarget(String sTarget) {
        this.msTarget = sTarget;
    }

    public boolean getModified() {
        return this.mbModified;
    }

    public void setModified(boolean bModified) {
        this.mbModified = bModified;
    }

    public Collection<Hashtable<String, String>> getTeileHashtableCollection() {
        Vector<Hashtable<String, String>> cTeile = new Vector<Hashtable<String, String>>();
        if (this.mcTeile != null) {
            for (Teil objTeil : this.mcTeile) {
                cTeile.add(objTeil.getHashtable());
            }
        }
        return cTeile;
    }

    public String getMarke() {
        return this.msMarke;
    }

    public void setMarke(String sMarke) {
        this.msMarke = sMarke;
    }

    public String getAuftragsNr() {
        if (this.mAuftrag != null) {
            return this.mAuftrag.getAuftragsNr();
        }
        return null;
    }

    public String getKundenNr() {
        if (this.mAuftrag != null && this.mAuftrag.getKundenNr() != null) {
            return this.mAuftrag.getKundenNr().toString();
        }
        return null;
    }

    public String getKundenName() {
        if (this.mAuftrag != null) {
            return this.mAuftrag.getKundenname();
        }
        return null;
    }

    public String getFgstNr() {
        if (this.mAuftrag != null) {
            return this.mAuftrag.getFgstNr();
        }
        return null;
    }

    public String getFzgIdString() {
        if (this.mAuftrag != null) {
            return this.mAuftrag.getFzgIdString();
        }
        return null;
    }

    public Auftrag getAuftrag() {
        return this.mAuftrag;
    }

    public void setAuftrag(Auftrag oAuftrag) {
        this.mAuftrag = oAuftrag;
    }

    public Collection<ValueAndNameSupport> getAnMailAdressen() {
        return this.mcAnMailAdressen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reload(boolean bSapRecht) throws SQLException, DatabaseBusyException, NoDataFoundException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info("Loading Partslist ID: " + this.msID + " User: " + this.msNutzerID);
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnection("Teileliste.reload");
            res = TeileListeDbAccess.loadTeilelisteAllgemein(con, this.msID, this.msNutzerID);
            if (res == null || !res.next()) {
                throw new NoDataFoundException();
            }
            this.msNewID = this.msID;
            this.msMarke = res.getString("Marke");
            this.msBemerkung = res.getString("Bemerkung");
            this.mdatErstellung = WebetkUtils.getDateFromLong(res.getLong("Erzeugt"));
            this.mdatAenderung = WebetkUtils.getDateFromLong(res.getLong("Geaendert"));
            this.msVIN = res.getString("VIN");
            this.msDringlichkeit = res.getString("Dringlichkeit");
            WebetkUtils.closeQuery(res);
            if (this.msMarke != null && this.msMarke.equals(Marken.getInstance().getMarke("RR").getBerechtigung()) && bSapRecht) {
                this.loadHistorie(con, null);
            }
            res = TeileListeDbAccess.loadTeilelistePositionen(con, this.msID, this.msNutzerID, this.msLanguage);
            this.mcTeile = new Vector();
            int nPosGemerkt = -1;
            while (res.next()) {
                int nPos = res.getInt("Pos");
                String sSachnummer = res.getString("SachNr");
                String sHg = res.getString("Hg");
                String sUg = res.getString("Ug");
                String sMenge = res.getString("Menge");
                String sBemerkung = res.getString("Bemerkung");
                String sBenennung = res.getString("Benennung");
                String sZusatz = res.getString("Zusatz");
                String sFertigungshinweis = res.getString("FH");
                if (nPosGemerkt != -1 && nPosGemerkt == nPos) continue;
                nPosGemerkt = nPos;
                Teil objTeil = new Teil(sSachnummer, sHg, sUg, nPos, sMenge, sBemerkung, sBenennung, sZusatz);
                objTeil.setFertigungshinweis(sFertigungshinweis);
                objTeil.setFIString(res.getString("FiString"));
                objTeil.setAspgTyp(res.getString("AspgTyp"));
                objTeil.setAspgRef(res.getString("AspgRef"));
                objTeil.setAspgMenge(res.getString("AspgMenge"));
                this.mcTeile.add(objTeil);
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnection(con, "Teileliste.reload");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnection(con, "Teileliste.reload");
        if (this.msMarke != null && this.msMarke.equals(Marken.getInstance().getMarke("RR").getBerechtigung()) && bSapRecht) {
            this.loadSapAntwort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload(String sFirma, String sFiliale) throws SQLException, DatabaseBusyException, NoDataFoundException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info("Loading Partslist ID: " + this.msID + " User: " + this.msNutzerID);
        Connection con = null;
        ResultSet res = null;
        try {
            String sAuftragsNr;
            con = gObj.getDBConnectionNutzer("Teileliste.reload");
            res = TeileListeDbAccess.loadTeilelisteAllgemein(con, this.msID, this.msNutzerID, sFirma, sFiliale);
            if (res == null || !res.next()) {
                throw new NoDataFoundException();
            }
            this.msNewID = this.msID;
            this.msFiliale = sFiliale;
            this.msMarke = res.getString("Marke");
            this.msBemerkung = res.getString("Bemerkung");
            this.mdatErstellung = WebetkUtils.getDateFromLong(res.getLong("Erzeugt"));
            this.mdatAenderung = WebetkUtils.getDateFromLong(res.getLong("Geaendert"));
            this.msFzgDlfId = res.getString("DurchlaufId");
            this.msDringlichkeit = res.getString("Dringlichkeit");
            this.msVIN = res.getString("Vin");
            this.msSapStatus = res.getString("RrSapStatus");
            if (this.msSapStatus != null) {
                if (this.msSapStatus.equals("A")) {
                    this.msSapArt = "A";
                } else if (this.msSapStatus.equals("B") || this.msSapStatus.equals("E")) {
                    this.msSapArt = "B";
                }
            }
            if ((sAuftragsNr = res.getString("Auftragsnr")) != null) {
                Long lKundenNr = null;
                String sKundenNr = res.getString("Kundennr");
                if (sKundenNr != null) {
                    lKundenNr = Long.valueOf(sKundenNr);
                }
                String sKundenName = res.getString("Kundenname");
                String sFgStNr = res.getString("FgStNr");
                this.mAuftrag = new Auftrag(sFirma, sFiliale, sAuftragsNr, lKundenNr, sKundenName, sFgStNr);
                this.msAuftragsNrLokal = null;
                this.mlKundenNrLokal = null;
            } else {
                String sPrivat;
                this.msAuftragsNrLokal = res.getString("AuftragsnrLokal");
                this.mlKundenNrLokal = null;
                String sKundenNrLokal = res.getString("KundennrLokal");
                if (sKundenNrLokal != null && sKundenNrLokal.length() > 0) {
                    this.mlKundenNrLokal = new Long(sKundenNrLokal);
                }
                this.mbPrivat = (sPrivat = res.getString("Privat")) != null && sPrivat.equals("J");
            }
            WebetkUtils.closeQuery(res);
            if (this.isRrSapListe()) {
                this.loadRrNutzerdaten(con, this.msNutzerID, sFirma);
                this.loadHistorie(con, sFirma);
            }
            res = TeileListeDbAccess.loadTeilelistePositionen(con, this.msID, this.msNutzerID, this.msLanguage, sFirma, sFiliale);
            this.mcTeile = new Vector();
            int nPosGemerkt = -1;
            Teil objTeil = null;
            while (res.next()) {
                String sMarke;
                boolean bLokalteil;
                String sSachnummer = res.getString("SachNr").trim();
                String sHgUg = res.getString("HgUg");
                String sHg = "";
                String sUg = "";
                if (sHgUg != null) {
                    if ((sHgUg = sHgUg.trim()).length() == 4) {
                        sHg = sHgUg.substring(0, 2);
                        sUg = sHgUg.substring(2, 4);
                    } else if (sHgUg.length() > 2) {
                        sHg = sHgUg.substring(0, 2);
                        sUg = sHgUg.substring(2);
                    } else {
                        sHg = sHgUg;
                    }
                }
                int nPos = res.getInt("Pos");
                String sMenge = res.getString("Menge");
                String sBemerkung = res.getString("Bemerkung");
                String sBenennung = res.getString("Benennung");
                String sZusatz = res.getString("Zusatz");
                boolean bl = bLokalteil = res.getString("Lokalteil") != null && res.getString("Lokalteil").equals("J");
                if (nPosGemerkt == -1 || nPos != nPosGemerkt) {
                    nPosGemerkt = nPos;
                    objTeil = new Teil();
                    objTeil.setPos(nPos);
                    objTeil.setHG(sHg);
                    objTeil.setUG(sUg);
                    objTeil.setSachnummer(sSachnummer);
                    objTeil.setBenennung(sBenennung);
                    objTeil.setZusatz(sZusatz);
                    objTeil.setMenge(sMenge);
                    objTeil.setBemerkung(sBemerkung);
                    sMarke = res.getString("Marke");
                    objTeil.appendMarke(sMarke);
                    objTeil.setTeileart(res.getString("Teileart"));
                    objTeil.setProduktklasse(res.getString("ProduktKlasse"));
                    objTeil.setMAM(res.getInt("MAM"));
                    objTeil.setVVM(res.getInt("VVM"));
                    objTeil.setLVM(res.getInt("LVM"));
                    objTeil.setBVM(res.getInt("BVM"));
                    objTeil.setMengenEinheit(res.getString("Mengeneinheit"));
                    Double oDValue = null;
                    if (res.getString("Lagerbestand") != null) {
                        oDValue = new Double(res.getDouble("Lagerbestand"));
                    }
                    objTeil.setLagerbestand(oDValue);
                    if (res.getString("Minimalbestand") != null) {
                        oDValue = new Double(res.getDouble("Minimalbestand"));
                    }
                    objTeil.setMinimalbestand(oDValue);
                    Integer nIValue = null;
                    if (res.getString("Bedarfshinweis") != null) {
                        nIValue = new Integer(res.getInt("Bedarfshinweis"));
                    }
                    objTeil.setBedarfshinweis(nIValue);
                    String sValue = res.getString("Lagerort");
                    objTeil.setLagerort(sValue);
                    if (res.getString("AuMe") != null) {
                        oDValue = new Double(res.getDouble("AuMe"));
                    }
                    objTeil.setAuMe(oDValue);
                    double dValue = res.getDouble("Preis");
                    objTeil.setPreis(dValue);
                    if (res.getString("Rabatt") != null) {
                        oDValue = new Double(res.getDouble("Rabatt"));
                    }
                    objTeil.setRabatt(oDValue);
                    sValue = res.getString("Splitt");
                    objTeil.setSplitt(sValue);
                    sValue = res.getString("Transparenz");
                    objTeil.setTransparenz(sValue);
                    sValue = res.getString("Suffix");
                    objTeil.setSuffix(sValue);
                    sValue = res.getString("Dispocode");
                    objTeil.setDispo(sValue);
                    sValue = res.getString("Ruecksendepflicht");
                    objTeil.setRuecksendepflicht(sValue);
                    sValue = res.getString("FH");
                    if (sValue != null) {
                        sValue = sValue.trim();
                    }
                    objTeil.setFertigungshinweis(sValue);
                    sValue = res.getString("MwSt");
                    if (sValue == null) {
                        objTeil.setMwSt(null);
                    } else {
                        objTeil.setMwSt(new Double(res.getDouble("MwSt")));
                    }
                    sValue = res.getString("AltteilSteuer");
                    if (sValue == null) {
                        objTeil.setAtSt(null);
                    } else {
                        objTeil.setAtSt(new Double(res.getDouble("AltteilSteuer")));
                    }
                    objTeil.setLokalteil(bLokalteil);
                    objTeil.setHatNotiz(res.getString("SachnrMitNotiz") != null);
                    objTeil.setFIString(res.getString("FiString"));
                    objTeil.setAspgTyp(res.getString("AspgTyp"));
                    objTeil.setAspgRef(res.getString("AspgRef"));
                    objTeil.setAspgMenge(res.getString("AspgMenge"));
                    this.mcTeile.add(objTeil);
                    continue;
                }
                sMarke = res.getString("Marke");
                objTeil.appendMarke(sMarke);
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnectionNutzer(con, "Teileliste.reload");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnectionNutzer(con, "Teileliste.reload");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadRrNutzerdaten(Connection con, String sNutzerId, String sFirma) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info("Loading RR USerdata: " + sNutzerId);
        boolean bLocalConnection = false;
        ResultSet res = null;
        try {
            if (con == null) {
                con = gObj.getDBConnectionNutzer("Teileliste.loadRrNutzerdaten");
                bLocalConnection = true;
            }
            this.moRrNutzerdaten = new RrNutzerdaten();
            res = TeileListeDbAccess.loadRrNutzerdaten(con, sNutzerId, sFirma);
            if (res != null && res.next()) {
                this.moRrNutzerdaten.setNutzerName(res.getString("Name"));
                this.moRrNutzerdaten.setNutzerTelefon(res.getString("Telefon"));
                this.moRrNutzerdaten.setNutzerEMail(res.getString("Email"));
                this.moRrNutzerdaten.setHaendlernummer(res.getString("Haendlernr"));
            }
            WebetkUtils.closeQuery(res);
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            if (bLocalConnection) {
                gObj.freeDBConnectionNutzer(con, "Teileliste.loadRrNutzerdaten");
            }
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        if (bLocalConnection) {
            gObj.freeDBConnectionNutzer(con, "Teileliste.loadRrNutzerdaten");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadSapStatus() throws SQLException, DatabaseBusyException {
        boolean bResult = false;
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info("loadSapStatus ID: " + this.msID + " User: " + this.msNutzerID);
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnection("Teileliste.loadSapStatus");
            res = TeileListeDbAccess.loadSapStatus(con, this.msID, this.msNutzerID, this.mlAbfrageId);
            if (res != null && res.next()) {
                String sStatus = res.getString("Status");
                if (sStatus.equals("E")) {
                    bResult = true;
                }
                WebetkUtils.closeQuery(res);
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnection(con, "Teileliste.loadSapStatus");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnection(con, "Teileliste.loadSapStatus");
        return bResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadSapAntwort() throws SQLException, DatabaseBusyException {
        ResultSet res;
        Connection con;
        ServerGlobalObjects gObj;
        block17: {
            block19: {
                boolean bl;
                double dSapPreisSumme;
                String sBestellnr;
                block18: {
                    gObj = ServerGlobalObjects.getInstance();
                    log.info("loadSapAntwort ID: " + this.msID + " User: " + this.msNutzerID);
                    con = null;
                    res = null;
                    con = gObj.getDBConnection("Teileliste.loadSapAntwort");
                    res = TeileListeDbAccess.loadSapStatus(con, this.msID, this.msNutzerID, this.mlAbfrageId);
                    if (res == null || !res.next()) break block17;
                    this.msSapArt = res.getString("Art");
                    this.msSapStatus = res.getString("Status");
                    sBestellnr = res.getString("Bestellnr");
                    dSapPreisSumme = res.getDouble("GesamtPreis");
                    this.msSapError = res.getString("SapError");
                    WebetkUtils.closeQuery(res);
                    if (this.msSapError == null || this.msSapError.length() <= 0) break block18;
                    this.deleteSapDaten();
                    this.msSapArt = null;
                    boolean bl2 = true;
                    WebetkUtils.closeQuery(res);
                    gObj.freeDBConnection(con, "Teileliste.loadSapAntwort");
                    return bl2;
                }
                try {
                    if (!this.msSapStatus.equals("E")) break block19;
                    if (this.msSapArt.equals("B")) {
                        this.msSapOrderNo = sBestellnr;
                    } else {
                        this.mdSapPreisSumme = dSapPreisSumme;
                        this.msSapErrorIntern = "";
                        res = TeileListeDbAccess.loadSapAntwort(con, this.msID, this.msNutzerID, this.mlAbfrageId);
                        int nAnzTeileSap = 0;
                        block7: while (res != null && res.next()) {
                            ++nAnzTeileSap;
                            int nPos = res.getInt("Pos");
                            String sSachnummer = res.getString("Sachnr");
                            double dSapMenge = res.getDouble("Menge");
                            double dSapPreis = res.getDouble("Preis");
                            this.msSapWaehrung = res.getString("Waehrung");
                            String sKodierungsstufe = res.getString("Kodierung");
                            String sVerfuegbar = res.getString("Verfuegbar");
                            String sVerfuegbarkeitHinweis = res.getString("Hinweis");
                            for (Teil objTeil : this.mcTeile) {
                                if (objTeil.getPosInt() != nPos) continue;
                                if (!objTeil.getSachnummer().equals(sSachnummer)) {
                                    this.msSapErrorIntern = this.msSapErrorIntern + "different part numbers at position: " + objTeil.getPos() + "\n";
                                    log.error("Sap Error intern - Teilelisten Id : " + this.msID + " - user : " + this.msNutzerID + " - Abfrage Id : " + this.mlAbfrageId + " ===>>> different part numbers at position: " + objTeil.getPos());
                                }
                                if (objTeil.getMengeDouble() != dSapMenge) {
                                    this.msSapErrorIntern = this.msSapErrorIntern + "different quantities at position: " + objTeil.getPos() + "\n";
                                    log.error("Sap Error intern - Teilelisten Id : " + this.msID + " - user : " + this.msNutzerID + " - Abfrage Id : " + this.mlAbfrageId + " ===>>> different quantities at position: " + objTeil.getPos());
                                }
                                objTeil.setSapPreis(new Double(dSapPreis));
                                objTeil.setSapKodierungsstufe(sKodierungsstufe);
                                objTeil.setSapVerfuegbarkeit(sVerfuegbar);
                                objTeil.setSapVerfuegbarkeitHinweis(sVerfuegbarkeitHinweis);
                                continue block7;
                            }
                        }
                        if (nAnzTeileSap != this.mcTeile.size()) {
                            log.error("Sap Error intern - Teilelisten Id : " + this.msID + " - user : " + this.msNutzerID + " - Abfrage Id : " + this.mlAbfrageId + " ===>>> different quantity of parts in request and in answer. " + " Anzahl Teile in SAP = " + nAnzTeileSap + " in WebETK = " + this.mcTeile.size());
                            this.msSapErrorIntern = this.msSapErrorIntern + "different quantity of parts in request and in answer.\n";
                            try {
                                if (res != null) {
                                    res.beforeFirst();
                                    while (res.next()) {
                                        log.error("SAP Teile:\nPos=" + res.getInt("Pos") + " " + "Sachnr=" + res.getString("Sachnr") + " " + "Menge=" + res.getDouble("Menge") + " " + "Preis=" + res.getDouble("Preis") + " " + "Waehrung=" + res.getString("Waehrung") + " " + "Kodierung=" + res.getString("Kodierung") + " " + "Verfuegbar=" + res.getString("Verfuegbar") + " " + "Hinweis=" + res.getString("Hinweis") + "\n");
                                    }
                                }
                                for (Teil oTeil : this.mcTeile) {
                                    log.error("Teileliste Teile:\nPos=" + oTeil.getPos() + " " + "Sachnr=" + oTeil.getSachnummer() + " " + "Menge=" + oTeil.getMenge() + "\n");
                                }
                            }
                            catch (Exception e) {
                                log.error("Exception while preparing error informations to error before.", e);
                            }
                        }
                        this.deleteSapDaten();
                        this.msSapArt = null;
                        this.msSapStatus = "N";
                    }
                    bl = true;
                }
                catch (Throwable throwable) {
                    WebetkUtils.closeQuery(res);
                    gObj.freeDBConnection(con, "Teileliste.loadSapAntwort");
                    throw throwable;
                }
                WebetkUtils.closeQuery(res);
                gObj.freeDBConnection(con, "Teileliste.loadSapAntwort");
                return bl;
            }
            boolean bl = false;
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnection(con, "Teileliste.loadSapAntwort");
            return bl;
        }
        boolean bl = false;
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnection(con, "Teileliste.loadSapAntwort");
        return bl;
    }

    public void addTeile(Collection<Teil> cTeile, String sSprache, boolean bReplaceMenge, boolean bLoadPubldaten) throws SQLException, DatabaseBusyException, NoDataFoundException, InvalidDataException {
        this.addTeile(cTeile, sSprache, bReplaceMenge, true, bLoadPubldaten, false, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTeile(Collection<Teil> cTeile, String sSprache, boolean bReplaceMenge, boolean bAddMenge, boolean bLoadPubldaten, boolean bLoadAnzNotizen, String sNutzer, String sFirma) throws SQLException, DatabaseBusyException, NoDataFoundException, InvalidDataException {
        HashMap<String, Boolean> kTeile = new HashMap<String, Boolean>();
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info("Entering Function");
        for (Teil objTeil : cTeile) {
            ResultSet res;
            Connection con;
            if (this.mcTeile == null) {
                this.mcTeile = new Vector();
            }
            boolean bFound = false;
            for (Teil objTeilAlt : this.mcTeile) {
                double dAspgMenge;
                boolean addAspgMenge;
                String sAspgRefAlt;
                String sAspgRef;
                String sFIStringAlt;
                String sFIString = objTeil.getFIString();
                if (sFIString == null) {
                    sFIString = "";
                }
                if ((sFIStringAlt = objTeilAlt.getFIString()) == null) {
                    sFIStringAlt = "";
                }
                if ((sAspgRef = objTeil.getAspgRef()) == null) {
                    sAspgRef = "";
                }
                if ((sAspgRefAlt = objTeilAlt.getAspgRef()) == null) {
                    sAspgRefAlt = "";
                }
                if (!objTeilAlt.getSachnummer().equals(objTeil.getSachnummer()) || objTeilAlt.getLokalteil() != objTeil.getLokalteil() || !sFIStringAlt.equals(sFIString) || !sAspgRefAlt.equals(sAspgRef)) continue;
                if (bReplaceMenge) {
                    objTeilAlt.setMenge(objTeil.getMenge());
                    objTeilAlt.setBemerkung(objTeil.getBemerkung());
                } else if (bAddMenge) {
                    double dMenge = new Double(objTeilAlt.getMenge());
                    dMenge = objTeil.getMenge() == null || objTeil.getMenge().equals("0.00") || objTeil.getMenge().equals("") ? (dMenge += 1.0) : (dMenge += new Double(objTeil.getMenge()).doubleValue());
                    objTeilAlt.setMenge(new Double(dMenge).toString());
                    if ("K".equals(objTeilAlt.getAspgTyp())) {
                        boolean bl = addAspgMenge = kTeile.get(objTeilAlt.getFIString() + objTeilAlt.getAspgRef()) == null;
                        if (addAspgMenge) {
                            dAspgMenge = new Double(objTeilAlt.getAspgMenge());
                            dAspgMenge = objTeil.getAspgMenge().equals("0.00") || objTeil.getAspgMenge().equals("") ? (dAspgMenge += 1.0) : (dAspgMenge += new Double(objTeil.getAspgMenge()).doubleValue());
                            objTeilAlt.setAspgMenge(new Double(dAspgMenge).toString());
                        }
                    }
                } else {
                    try {
                        double dMenge = new Double(objTeilAlt.getMenge());
                        objTeilAlt.setMenge(new Double(dMenge += 1.0).toString());
                        boolean bl = addAspgMenge = kTeile.get(objTeilAlt.getFIString() + objTeilAlt.getAspgRef()) == null;
                        if (addAspgMenge && "K".equals(objTeilAlt.getAspgTyp())) {
                            dAspgMenge = new Double(objTeilAlt.getAspgMenge());
                            dAspgMenge = objTeil.getAspgMenge().equals("0.00") || objTeil.getAspgMenge().equals("") ? (dAspgMenge += 1.0) : (dAspgMenge += new Double(objTeil.getAspgMenge()).doubleValue());
                            objTeilAlt.setAspgMenge(new Double(dAspgMenge).toString());
                        }
                    }
                    catch (Exception e) {
                        log.debug("Menge ist keine Zahl!");
                    }
                }
                objTeilAlt.setMenge(WebetkUtils.getPriceString(objTeilAlt.getMengeDouble()));
                objTeilAlt.setUpdate(true);
                bFound = true;
                if (objTeilAlt.getAspgTyp().equals("A")) {
                    kTeile.put(objTeilAlt.getFIString() + objTeilAlt.getAspgRef(), Boolean.TRUE);
                }
                objTeilAlt.setIsTeilDiebstahlrelevant(objTeil.getIsTeilDiebstahlrelevant());
                objTeilAlt.setRuecksendepflicht(objTeil.getRuecksendepflicht());
                break;
            }
            if (bFound) continue;
            objTeil.setInsert(true);
            if (!objTeil.getLokalteil() && bLoadAnzNotizen) {
                con = null;
                res = null;
                try {
                    con = gObj.getDBConnectionNutzer("teileliste.addTeile");
                    int nAnz = NotizuebersichtDbAccess.selectAnzahlNotizen(con, sNutzer, sFirma, objTeil.getSachnummer());
                    objTeil.setHatNotiz(nAnz > 0);
                }
                catch (Throwable throwable) {
                    WebetkUtils.closeQuery(res);
                    gObj.freeDBConnectionNutzer(con, "teileliste.addTeile");
                    throw throwable;
                }
                WebetkUtils.closeQuery(res);
                gObj.freeDBConnectionNutzer(con, "teileliste.addTeile");
            }
            if (!objTeil.getLokalteil() && bLoadPubldaten) {
                block28: {
                    con = null;
                    res = null;
                    try {
                        con = gObj.getDBConnection("teileliste.addTeile");
                        res = TeileListeDbAccess.loadTeil(con, objTeil.getSachnummer(), sSprache);
                        boolean bTeilVorhanden = false;
                        while (res.next()) {
                            bTeilVorhanden = true;
                            objTeil.appendMarke(res.getString("Marke"));
                            objTeil.setTeileart(res.getString("Teileart"));
                            objTeil.setHG(res.getString("Hg"));
                            objTeil.setUG(res.getString("Ug"));
                            objTeil.setBenennung(res.getString("Benennung"));
                            objTeil.setZusatz(res.getString("Zusatz"));
                            objTeil.setMAM(res.getInt("MAM"));
                            objTeil.setFertigungshinweis(res.getString("FH"));
                            objTeil.setIsTeilDiebstahlrelevant(res.getString("Teil_Diebstahlrelevant") != null && res.getString("Teil_Diebstahlrelevant").equals("J") ? "J" : "N");
                        }
                        if (!bTeilVorhanden) {
                            throw new NoDataFoundException();
                        }
                        if (this.msMarke == null || this.msMarke.length() == 0 || objTeil.checkMarke(this.msMarke)) break block28;
                        throw new InvalidDataException();
                    }
                    catch (Throwable throwable) {
                        WebetkUtils.closeQuery(res);
                        gObj.freeDBConnection(con, "teileliste.addTeile");
                        throw throwable;
                    }
                }
                WebetkUtils.closeQuery(res);
                gObj.freeDBConnection(con, "teileliste.addTeile");
            }
            if (!bReplaceMenge && !bAddMenge) {
                objTeil.setMenge("1");
            }
            if (objTeil.getMenge().equals("")) {
                objTeil.setMenge("1");
            }
            objTeil.setPos(this.mcTeile.size() + 1);
            objTeil.setMenge(WebetkUtils.getPriceString(objTeil.getMengeDouble()));
            this.mcTeile.add(objTeil);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<ValueAndNameSupport> getTeilelisten(String sNutzerID, Collection<String> aMarke, boolean bMitSapBestellung) throws SQLException, DatabaseBusyException {
        Vector<ValueAndNameSupport> cTeilelisten = null;
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info("Loading Teilelisten for user with ID: " + sNutzerID);
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnectionNutzer("Teileliste.getTeilelisten");
            res = TeileListeDbAccess.selectTeilelistenIDs(con, sNutzerID, aMarke);
            if (res != null) {
                cTeilelisten = new Vector<ValueAndNameSupport>();
                while (res.next()) {
                    String sSapArt;
                    String sId = res.getString("ListeId");
                    if (!bMitSapBestellung && (sSapArt = res.getString("SapArt")) != null && sSapArt.equals("B")) continue;
                    ValueAndNameSupport objValName = new ValueAndNameSupport(sId, sId);
                    cTeilelisten.add(objValName);
                }
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnectionNutzer(con, "Teileliste.getTeilelisten");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnectionNutzer(con, "Teileliste.getTeilelisten");
        return cTeilelisten;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector<ComboTeilelisteItem> getTeilelisten(String sNutzerID, Collection<String> aMarken, String sFirma, String sFiliale, boolean bMitSapBestellungen) throws SQLException, DatabaseBusyException {
        Vector<ComboTeilelisteItem> cTeilelisten = null;
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info("Loading Teilelisten for user with ID: " + sNutzerID + " and brand(s): " + aMarken.toString());
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnectionNutzer("Teileliste.getTeilelisten");
            res = TeileListeDbAccess.selectTeilelistenIDs(con, sNutzerID, aMarken, sFirma, sFiliale);
            if (res != null) {
                cTeilelisten = new Vector<ComboTeilelisteItem>();
                while (res.next()) {
                    String sId = res.getString("ListeId");
                    String sMarke = res.getString("Marke");
                    String sEigentuemer = res.getString("Eigentuemer");
                    String sRrSapStatus = res.getString("RrSapStatus");
                    ComboTeilelisteItem oTeileliste = new ComboTeilelisteItem(sId, sId, sEigentuemer, sFiliale, sMarke);
                    oTeileliste.setRrSapStatus(sRrSapStatus);
                    if (!bMitSapBestellungen && sRrSapStatus != null && (sRrSapStatus.equals("B") || sRrSapStatus.equals("E"))) continue;
                    cTeilelisten.add(oTeileliste);
                }
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnectionNutzer(con, "Teileliste.getTeilelisten");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnectionNutzer(con, "Teileliste.getTeilelisten");
        return cTeilelisten;
    }

    public static Vector<ComboTeilelisteItem> getRrListen(String sNutzerID, String sFirma, String sFiliale) throws SQLException, DatabaseBusyException {
        Vector<ComboTeilelisteItem> aRrListen = new Vector<ComboTeilelisteItem>();
        Vector<String> aMarken = new Vector<String>();
        aMarken.add(Marken.getInstance().getMarke("RR").getBerechtigung());
        Vector<ComboTeilelisteItem> aListen = Teileliste.getTeilelisten(sNutzerID, aMarken, sFirma, sFiliale, true);
        for (ComboTeilelisteItem oTeileliste : aListen) {
            if (!oTeileliste.isRrSapListe()) continue;
            aRrListen.add(oTeileliste);
        }
        return aRrListen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector<Teileliste> loadTeilelistenUebersicht(String sNutzerID, String sFirma, String sFiliale, String sSprache, boolean bMitBestelllisten, boolean bUSDirect, String sFilter, boolean bPrivate) throws SQLException, DatabaseBusyException {
        Vector<Teileliste> aTeilelisten = null;
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info("loadTeilelistenUebersicht for user with ID: " + sNutzerID);
        Connection con = null;
        try {
            con = gObj.getDBConnectionNutzer("Teileliste.loadTeilelistenUebersicht");
            aTeilelisten = TeileListeDbAccess.loadTeilelistenUebersicht(con, sNutzerID, sFirma, sFiliale, sSprache, bMitBestelllisten, bUSDirect, sFilter, bPrivate);
        }
        finally {
            gObj.freeDBConnectionNutzer(con, "Teileliste.loadTeilelistenUebersicht");
        }
        return aTeilelisten;
    }

    public void removeTeil(String sSachnummer, String sSelFIString, String sSelAspgRef) {
        int nPosRemove = 0;
        boolean isAnker = false;
        Iterator<Teil> iter = this.mcTeile.iterator();
        while (iter.hasNext()) {
            Teil objSelTeil = iter.next();
            if (!objSelTeil.getSachnummer().equals(sSachnummer) || !objSelTeil.getFIString().equals(sSelFIString) || !objSelTeil.getAspgRef().equals(sSelAspgRef)) continue;
            nPosRemove = objSelTeil.getPosInt();
            isAnker = objSelTeil.getAspgTyp().equals("A");
            iter.remove();
            break;
        }
        if (nPosRemove > 0) {
            for (Teil objTeil : this.mcTeile) {
                int nPos = objTeil.getPosInt();
                if (nPos <= nPosRemove) continue;
                objTeil.setPos(--nPos);
            }
        }
        if (isAnker) {
            int deleteCount = 0;
            iter = this.mcTeile.iterator();
            while (iter.hasNext()) {
                Teil objTeil = iter.next();
                if (objTeil.getAspgTyp().equals("K") && objTeil.getFIString().equals(sSelFIString) && objTeil.getAspgRef().equals(sSelAspgRef)) {
                    iter.remove();
                    ++deleteCount;
                    continue;
                }
                objTeil.setPos(objTeil.getPosInt() - deleteCount);
            }
        }
    }

    public void setSelektiertesTeil(Teil oTeil) {
        this.mSelektiertesTeil = oTeil;
    }

    public Teil getSelektiertesTeil() {
        return this.mSelektiertesTeil;
    }

    public String getBemerkung() {
        if (this.msBemerkung == null) {
            return "";
        }
        return this.msBemerkung;
    }

    public void setBemerkung(String sBemerkung) {
        this.msBemerkung = sBemerkung;
    }

    public Date getDatErstellung() {
        return this.mdatErstellung;
    }

    public String getDatErstellungString() {
        if (this.mdatErstellung == null) {
            return "";
        }
        return WebetkUtils.getStringFromDate(this.mdatErstellung, this.msLanguage, 2);
    }

    public void setDatErstellung(Date datErstellung) {
        this.mdatErstellung = datErstellung;
    }

    public Date getDatAenderung() {
        return this.mdatAenderung;
    }

    public String getDatAenderungString() {
        if (this.mdatAenderung == null) {
            return "";
        }
        return WebetkUtils.getStringFromDate(this.mdatAenderung, this.msLanguage, 2);
    }

    public void setDatAenderung(Date datAenderung) {
        this.mdatAenderung = datAenderung;
    }

    public boolean getGesperrt() {
        return this.mbGesperrt;
    }

    public void setGesperrt(boolean bGesperrt) {
        this.mbGesperrt = bGesperrt;
    }

    public boolean getPrivat() {
        return this.mbPrivat;
    }

    public void setPrivat(boolean bPrivat) {
        this.mbPrivat = bPrivat;
    }

    public String formatiereDaten(boolean bMitPreis) {
        String sRet = this.getID() + "\t" + this.getDatErstellungString() + "\t" + this.getBemerkung() + "\t" + this.getDatAenderungString() + "\t" + this.getMarke();
        if (this.mAuftrag != null) {
            sRet = sRet + "\t" + this.mAuftrag.getAuftragsNr() + "\t" + String.valueOf(this.mAuftrag.getKundenNr()) + "\t" + this.mAuftrag.getKundenname();
        }
        sRet = sRet + "\r\n";
        sRet = sRet + "\r\n";
        int nMaxBen = 0;
        int nMaxZusatz = 0;
        for (Teil objTeil : this.mcTeile) {
            if (objTeil.getBenennung() != null && objTeil.getBenennung().length() > nMaxBen) {
                nMaxBen = objTeil.getBenennung().length();
            }
            if (objTeil.getZusatz() == null || objTeil.getZusatz().length() <= nMaxZusatz) continue;
            nMaxZusatz = objTeil.getZusatz().length();
        }
        for (Teil objTeil : this.mcTeile) {
            sRet = sRet + objTeil.getPos() + "\t";
            sRet = sRet + objTeil.getTeilenummerGespreizt() + "\t\t";
            sRet = sRet + objTeil.getMenge() + "\t";
            sRet = sRet + Teileliste.appendSpaces(objTeil.getBenennung(), nMaxBen) + "\t";
            sRet = sRet + Teileliste.appendSpaces(objTeil.getZusatz(), nMaxZusatz);
            if (bMitPreis) {
                sRet = sRet + "\t" + objTeil.ermittleNetto();
            }
            sRet = sRet + "\r\n";
        }
        return sRet;
    }

    private static String appendSpaces(String sInhalt, int nLaenge) {
        int nStart;
        StringBuffer sResult = new StringBuffer(sInhalt);
        if (sInhalt == null) {
            for (int ii = 0; ii < nLaenge; ++ii) {
                sResult.append(" ");
            }
            return sResult.toString();
        }
        for (int ii = nStart = sInhalt.length(); ii < nLaenge; ++ii) {
            sResult.append(" ");
        }
        return sResult.toString();
    }

    public double ermittleSummeNetto() {
        if (this.mcTeile == null) {
            return 0.0;
        }
        long lSummeCent = 0L;
        for (Teil objTeil : this.mcTeile) {
            lSummeCent = (long)((double)lSummeCent + Math.floor(objTeil.ermittleNetto() * 100.0 + 0.5));
        }
        return (double)lSummeCent / 100.0;
    }

    public double ermittleSummeBrutto() {
        if (this.mcTeile == null) {
            return 0.0;
        }
        long lSummeCent = 0L;
        for (Teil objTeil : this.mcTeile) {
            lSummeCent = (long)((double)lSummeCent + Math.floor(objTeil.ermittleBrutto() * 100.0 + 0.5));
        }
        return (double)lSummeCent / 100.0;
    }

    public double ermittleSummeMwSt() {
        if (this.mcTeile == null) {
            return 0.0;
        }
        long lSummeCent = 0L;
        for (Teil objTeil : this.mcTeile) {
            lSummeCent = (long)((double)lSummeCent + Math.floor(objTeil.ermittleMwStOhneAT() * 100.0 + 0.5));
        }
        return (double)lSummeCent / 100.0;
    }

    public double ermittleSummeAtSt() {
        if (this.mcTeile == null) {
            return 0.0;
        }
        long lSummeCent = 0L;
        for (Teil objTeil : this.mcTeile) {
            lSummeCent = (long)((double)lSummeCent + Math.floor(objTeil.ermittleAtSt() * 100.0 + 0.5));
        }
        return (double)lSummeCent / 100.0;
    }

    public double ermittleSummeNettoZuRechnungsTransparenz(String pReTr) {
        if (this.mcTeile == null) {
            return 0.0;
        }
        long lSummeCent = 0L;
        for (Teil objTeil : this.mcTeile) {
            String sReTr = objTeil.getTransparenz() != null ? objTeil.getTransparenz() : "";
            if (!sReTr.equals(pReTr)) continue;
            lSummeCent = (long)((double)lSummeCent + Math.floor(objTeil.ermittleNetto() * 100.0 + 0.5));
        }
        return (double)lSummeCent / 100.0;
    }

    public double ermittleSummeNettoZuFzgUndRechnungsTransparenz(String pFI, String pReTr) {
        if (this.mcTeile == null) {
            return 0.0;
        }
        long lSummeCent = 0L;
        for (Teil objTeil : this.mcTeile) {
            String sReTr;
            String sFI = objTeil.getFIString() != null ? objTeil.getFIString() : "";
            String string = sReTr = objTeil.getTransparenz() != null ? objTeil.getTransparenz() : "";
            if (!sFI.equals(pFI) || !sReTr.equals(pReTr)) continue;
            lSummeCent = (long)((double)lSummeCent + Math.floor(objTeil.ermittleNetto() * 100.0 + 0.5));
        }
        return (double)lSummeCent / 100.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TeilelisteTO getTeilelisteZuAuftrag(String sFirmaId, String sFilialId, String sAuftragNr) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info("getTeilelisteZuAufrag");
        Connection con = null;
        ResultSet res = null;
        TeilelisteTO retval = null;
        try {
            con = gObj.getDBConnectionNutzer("Teileliste.getTeilelisteZuAuftrag");
            res = TeileListeDbAccess.loadTeilelisteZuAuftrag(con, sFirmaId, sFilialId, sAuftragNr);
            if (res != null && res.next()) {
                String sTeilelistenId = res.getString("TeilelisteId");
                String sEigentuemerId = res.getString("EigentuemerId");
                String sFahrgestellnummer = res.getString("Fahrgestellnummer");
                String sAuftragsnummer = res.getString("Auftragsnummer");
                String sKundennummer = res.getString("Kundennummer");
                String sKundenname = res.getString("Kundenname");
                String sGesperrt = res.getString("Gesperrt");
                retval = new TeilelisteTO(sTeilelistenId, sEigentuemerId, sFahrgestellnummer, sAuftragsnummer, sKundennummer, sKundenname, sGesperrt);
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnectionNutzer(con, "Teileliste.getTeilelisteZuAufrag");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnectionNutzer(con, "Teileliste.getTeilelisteZuAufrag");
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAnEMailAdressen(Collection<String> aMarken) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info("loadAnEMailAdressen");
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnection("Teileliste.loadAnEMailAdressen");
            this.mcAnMailAdressen = new Vector();
            res = TeileListeDbAccess.loadMailAdressen(con, aMarken);
            while (res != null && res.next()) {
                String sAnMailAdresse = res.getString("AnMailAdresse");
                if (sAnMailAdresse == null) continue;
                ValueAndNameSupport objValName = new ValueAndNameSupport(sAnMailAdresse, sAnMailAdresse);
                this.mcAnMailAdressen.add(objValName);
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnection(con, "Teileliste.loadAnEMailAdressen");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnection(con, "Teileliste.loadAnEMailAdressen");
    }

    public void doPubldatenAbgleich(String sFirma, String sFiliale) throws SQLException, DatabaseBusyException {
        Teileliste.doPubldatenAbgleich(sFirma, sFiliale, this.getID(), this.getNutzerID(), this.getTeile(), this.msLanguage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doPubldatenAbgleich(String sFirma, String sFiliale, String sTeilelisteId, String sNutzerId, Vector<Teil> cTeile, String sLanguage) throws SQLException, DatabaseBusyException {
        ResultSet res;
        Connection con;
        ServerGlobalObjects gObj;
        block21: {
            int nSize;
            int i;
            block20: {
                gObj = ServerGlobalObjects.getInstance();
                log.info("doPubldatenAbgleich: Partslist ID: " + sTeilelisteId + " User: " + sNutzerId);
                con = null;
                res = null;
                con = gObj.getDBConnectionNutzer("Teileliste.doPubldatenAbgleich");
                res = TeileListeDbAccess.loadTeilelistePubldaten(con, sFirma, sFiliale, sNutzerId, sTeilelisteId, sLanguage);
                i = 0;
                nSize = cTeile.size();
                if (res != null) break block20;
                WebetkUtils.closeQuery(res);
                try {
                    gObj.freeDBConnectionNutzer(con, "TrfTeilelisteCommand.doPubldatenAbgleich");
                }
                catch (Exception e) {
                    log.error("Exception freeing DB conection", e);
                }
                return;
            }
            try {
                Vector<Teil> oHelpCollection = new Vector<Teil>();
                boolean bNacharbeiten = false;
                int nAbIndex = 0;
                int nPosGemerkt = -1;
                while (res.next()) {
                    Teil oTeil = cTeile.get(i);
                    Teil oHelp = null;
                    if (oTeil.getLokalteil()) {
                        log.info("Lokalteil");
                        ++i;
                        continue;
                    }
                    String sHelp = res.getString("Sachnummer_TL");
                    if (sHelp.equals("_empty_")) {
                        log.info("Platzhalter");
                        continue;
                    }
                    sHelp = res.getString("Sachnummer_Publdaten");
                    if (sHelp == null) {
                        log.info(" sHelp == null");
                        ++i;
                        continue;
                    }
                    int nPos = res.getInt("Pos");
                    if (nPosGemerkt == -1 || nPos != nPosGemerkt) {
                        oHelp = new Teil();
                        oHelp.setHG(res.getString("Hg"));
                        oHelp.setHG(res.getString("Hg"));
                        oHelp.setUG(res.getString("Ug"));
                        oHelp.setBenennung(res.getString("Benennung"));
                        oHelp.setSachnummer(res.getString("Sachnummer_TL"));
                        oHelp.setZusatz(res.getString("Zusatz"));
                        oHelp.appendMarke(res.getString("Marke"));
                        oHelp.setTeileart(res.getString("Teileart"));
                        oHelp.setProduktklasse(res.getString("ProduktKlasse"));
                        oHelp.setMAM(res.getInt("MAM"));
                        oHelp.setVVM(res.getInt("VVM"));
                        oHelp.setLVM(res.getInt("LVM"));
                        oHelp.setBVM(res.getInt("BVM"));
                        oHelp.setMengenEinheit(res.getString("Mengeneinheit"));
                        oHelpCollection.add(oHelp);
                        String sSachnummer = res.getString("Sachnummer_TL");
                        if (!oTeil.getSachnummer().equals(sSachnummer)) {
                            log.error("** doPubldatenAbgleich f\u00fcr Teil " + oTeil.getSachnummer() + " nicht m\u00f6glich, da Teilelisten nicht synchron");
                            bNacharbeiten = true;
                            nAbIndex = nAbIndex == 0 ? i : nAbIndex;
                            continue;
                        }
                        Teil oTeilOld = new Teil(oTeil);
                        oTeil.appendMarke(res.getString("Marke"));
                        oTeil.setTeileart(res.getString("Teileart"));
                        oTeil.setProduktklasse(res.getString("ProduktKlasse"));
                        oTeil.setHG(res.getString("Hg"));
                        oTeil.setUG(res.getString("Ug"));
                        if (!oTeil.isTeilVonScore()) {
                            oTeil.setBenennung(res.getString("Benennung"));
                        }
                        oTeil.setZusatz(res.getString("Zusatz"));
                        oTeil.setMAM(res.getInt("MAM"));
                        oTeil.setVVM(res.getInt("VVM"));
                        oTeil.setLVM(res.getInt("LVM"));
                        oTeil.setBVM(res.getInt("BVM"));
                        oTeil.setMengenEinheit(res.getString("Mengeneinheit"));
                        if (!oTeil.equals(oTeilOld)) {
                            oTeil.setMustSave(true);
                        }
                        ++i;
                        continue;
                    }
                    oTeil.appendMarke(res.getString("Marke"));
                }
                if (!bNacharbeiten) break block21;
                block10: for (int j = nAbIndex; j < nSize; ++j) {
                    Teil oTeil = cTeile.get(j);
                    for (Teil oHelp : oHelpCollection) {
                        if (!oTeil.getSachnummer().equals(oHelp.getSachnummer())) continue;
                        Teil oTeilOld = new Teil(oTeil);
                        oTeil.setMarken(oHelp.getMarken());
                        oTeil.setTeileart(oHelp.getTeileart());
                        oTeil.setProduktklasse(oHelp.getProduktklasse());
                        oTeil.setHG(oHelp.getHG());
                        oTeil.setUG(oHelp.getUG());
                        if (!oTeil.isTeilVonScore()) {
                            oTeil.setBenennung(oHelp.getBenennung());
                        }
                        oTeil.setZusatz(oHelp.getZusatz());
                        oTeil.setMAM(oHelp.getMAM());
                        oTeil.setVVM(oHelp.getVVM());
                        oTeil.setLVM(oHelp.getLVM());
                        oTeil.setBVM(oHelp.getBVM());
                        oTeil.setMengenEinheit(oHelp.getMengenEinheit());
                        if (oTeil.equals(oTeilOld)) continue block10;
                        oTeil.setMustSave(true);
                        continue block10;
                    }
                }
            }
            catch (Throwable throwable) {
                WebetkUtils.closeQuery(res);
                try {
                    gObj.freeDBConnectionNutzer(con, "TrfTeilelisteCommand.doPubldatenAbgleich");
                }
                catch (Exception e) {
                    log.error("Exception freeing DB conection", e);
                }
                throw throwable;
            }
        }
        WebetkUtils.closeQuery(res);
        try {
            gObj.freeDBConnectionNutzer(con, "TrfTeilelisteCommand.doPubldatenAbgleich");
        }
        catch (Exception e) {
            log.error("Exception freeing DB conection", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPreismodulAbgleich(String sFirma, String sFiliale) throws SQLException, DatabaseBusyException {
        ResultSet res;
        Connection con;
        ServerGlobalObjects gObj;
        block27: {
            int nSize;
            int i;
            Vector<Teil> cTeile;
            block26: {
                gObj = ServerGlobalObjects.getInstance();
                log.info("doPreismodulAbgleich: Partslist ID: " + this.getID() + " User: " + this.getNutzerID());
                con = null;
                res = null;
                con = gObj.getDBConnectionNutzer("Teileliste.doPreismodulAbgleich");
                String sNutzerId = this.getNutzerID();
                String sTeilelisteId = this.getID();
                res = TeileListeDbAccess.loadTeilelistePreisInfo(con, sFirma, sFiliale, sNutzerId, sTeilelisteId);
                cTeile = this.getTeile();
                i = 0;
                nSize = cTeile.size();
                if (res != null) break block26;
                WebetkUtils.closeQuery(res);
                try {
                    gObj.freeDBConnectionNutzer(con, "TrfTeilelisteCommand.doPreismodulAbgleich");
                }
                catch (Exception e) {
                    log.error("Exception freeing DB conection", e);
                }
                return;
            }
            try {
                Vector<Teil> oHelpCollection = new Vector<Teil>();
                boolean bNacharbeiten = false;
                int nAbIndex = 0;
                while (res.next()) {
                    Teil oTeil = cTeile.get(i);
                    if (!oTeil.getLokalteil()) {
                        String sHelp = res.getString("Sachnummer_Preis");
                        if (sHelp == null) {
                            ++i;
                            continue;
                        }
                        Teil oHelp = new Teil();
                        oHelp.setSachnummer(res.getString("Sachnummer_TL"));
                        double dEvp = res.getDouble("EVP");
                        String sPreisProHundertKZ = res.getString("PreisKz");
                        if (sPreisProHundertKZ != null && sPreisProHundertKZ.equals("%")) {
                            dEvp /= 100.0;
                        }
                        oHelp.setPreis(dEvp);
                        oHelp.setUPE(dEvp);
                        oHelp.setNachbelastungspauschale(res.getDouble("Nachbelastung"));
                        oHelp.setRabattSchluessel(res.getString("RabattSchluessel"));
                        oHelp.setPreisaenderKZ(res.getString("Preisanederung"));
                        oHelp.setSonderpreis(res.getDouble("SNP"));
                        oHelp.setSonderpreisKZ(res.getString("SNPKz"));
                        if (res.getString("MwSt") != null) {
                            oHelp.setMwSt(new Double(res.getDouble("MwSt")));
                        } else {
                            oHelp.setMwSt(null);
                        }
                        oHelp.setMwstCode(res.getString("MwStCode"));
                        oHelp.setZolltarifnummer(res.getString("ZolltarifNr"));
                        oHelpCollection.add(oHelp);
                        String sSachnummer = res.getString("Sachnummer_TL");
                        if (!oTeil.getSachnummer().equals(sSachnummer)) {
                            log.error("** doPubldatenAbgleich f\u00fcr Teil " + oTeil.getSachnummer() + " nicht m\u00f6glich, da Teilelisten nicht synchron");
                            bNacharbeiten = true;
                            nAbIndex = nAbIndex == 0 ? i : nAbIndex;
                            continue;
                        }
                        Teil oTeilOld = new Teil(oTeil);
                        dEvp = res.getDouble("EVP");
                        sPreisProHundertKZ = res.getString("PreisKz");
                        if (sPreisProHundertKZ != null && sPreisProHundertKZ.equals("%")) {
                            dEvp /= 100.0;
                        }
                        if (oTeil.getPreis() == 0.0) {
                            oTeil.setPreis(dEvp);
                        }
                        oTeil.setUPE(dEvp);
                        oTeil.setNachbelastungspauschale(res.getDouble("Nachbelastung"));
                        oTeil.setRabattSchluessel(res.getString("RabattSchluessel"));
                        oTeil.setPreisaenderKZ(res.getString("Preisanederung"));
                        oTeil.setSonderpreis(res.getDouble("SNP"));
                        oTeil.setSonderpreisKZ(res.getString("SNPKz"));
                        double dMwSt = oTeil.getMwSt();
                        if (dMwSt == 0.0) {
                            if (res.getString("MwSt") != null) {
                                oTeil.setMwSt(new Double(res.getDouble("MwSt")));
                            } else {
                                oTeil.setMwSt(null);
                            }
                        }
                        oTeil.setMwstCode(res.getString("MwStCode"));
                        oTeil.setZolltarifnummer(res.getString("ZolltarifNr"));
                        if (!oTeil.equals(oTeilOld)) {
                            oTeil.setMustSave(true);
                        }
                    }
                    ++i;
                }
                if (!bNacharbeiten) break block27;
                block10: for (int j = nAbIndex; j < nSize; ++j) {
                    Teil oTeil = cTeile.get(j);
                    for (Teil oHelp : oHelpCollection) {
                        if (!oTeil.getSachnummer().equals(oHelp.getSachnummer())) continue;
                        Teil oTeilOld = new Teil();
                        if (oTeil.getPreis() == 0.0) {
                            oTeil.setPreis(oHelp.getPreis());
                        }
                        oTeil.setUPE(oHelp.getUPE());
                        oTeil.setNachbelastungspauschale(oHelp.getNachbelastungspauschale());
                        oTeil.setRabattSchluessel(oHelp.getRabattSchluessel());
                        oTeil.setPreisaenderKZ(oHelp.getPreisaenderKZ());
                        oTeil.setSonderpreis(oHelp.getSonderpreis());
                        oTeil.setSonderpreisKZ(oHelp.getSonderpreisKZ());
                        if (oTeil.getMwSt() == 0.0) {
                            oTeil.setMwSt(oHelp.getMwStDouble());
                        }
                        oTeil.setMwstCode(oHelp.getMwstCode());
                        oTeil.setZolltarifnummer(oHelp.getZolltarifnummer());
                        if (oTeil.equals(oTeilOld)) continue block10;
                        oTeil.setMustSave(true);
                        continue block10;
                    }
                }
            }
            catch (Throwable throwable) {
                WebetkUtils.closeQuery(res);
                try {
                    gObj.freeDBConnectionNutzer(con, "TrfTeilelisteCommand.doPreismodulAbgleich");
                }
                catch (Exception e) {
                    log.error("Exception freeing DB conection", e);
                }
                throw throwable;
            }
        }
        WebetkUtils.closeQuery(res);
        try {
            gObj.freeDBConnectionNutzer(con, "TrfTeilelisteCommand.doPreismodulAbgleich");
        }
        catch (Exception e) {
            log.error("Exception freeing DB conection", e);
        }
    }

    public void setStep(int nStep) {
        this.mnStep = nStep;
    }

    public int getStep() {
        return this.mnStep;
    }

    public String getVIN() {
        if (this.msVIN == null) {
            return "";
        }
        return this.msVIN;
    }

    public void setVIN(String sVIN) {
        this.msVIN = sVIN;
    }

    public String getDringlichkeit() {
        if (this.msDringlichkeit == null) {
            return "";
        }
        return this.msDringlichkeit;
    }

    public void setDringlichkeit(String sDringlichkeit) {
        this.msDringlichkeit = sDringlichkeit;
    }

    public String getSapOrderNo() {
        if (this.msSapOrderNo == null) {
            return "";
        }
        return this.msSapOrderNo;
    }

    public void setSapOrderNo(String sSapOrderNo) {
        this.msSapOrderNo = sSapOrderNo;
    }

    public String getSapPreisSumme() {
        if (this.mdSapPreisSumme == 0.0) {
            return "";
        }
        return WebetkUtils.getPriceString(this.mdSapPreisSumme);
    }

    public void resetSapDaten() {
        this.mdSapPreisSumme = 0.0;
        if (this.mcTeile != null) {
            for (Teil objTeil : this.mcTeile) {
                objTeil.setSapKodierungsstufe(null);
                objTeil.setSapPreis(null);
                objTeil.setSapVerfuegbarkeit(null);
                objTeil.setSapVerfuegbarkeitHinweis(null);
            }
        }
    }

    public String ermittleSummeSapPreisOhneRabatt() {
        if (this.mcTeile == null) {
            return "";
        }
        long lSummeCent = 0L;
        for (Teil objTeil : this.mcTeile) {
            if (objTeil.getSapPreis() == null) continue;
            lSummeCent = (long)((double)lSummeCent + Math.floor(objTeil.getSapPreis() * 100.0 + 0.5));
        }
        return WebetkUtils.getPriceString((double)lSummeCent / 100.0);
    }

    public String getHistory() {
        if (this.msHistory == null) {
            return "";
        }
        return this.msHistory;
    }

    public void setHistory(String sHistory) {
        this.msHistory = sHistory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long writeSapDaten(String sArt) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info("writeSapDaten: Partslist ID: " + this.getID() + " User: " + this.getNutzerID());
        Connection con = null;
        long lAbfrageId = 0L;
        try {
            con = gObj.getDBConnectionNutzer("Teileliste.writeSapDaten");
            lAbfrageId = TeileListeDbAccess.writeSapDaten(con, this.msID, this.msNutzerID, sArt);
        }
        finally {
            try {
                gObj.freeDBConnectionNutzer(con, "Teileliste.writeSapDaten");
            }
            catch (Exception e) {
                log.error("Exception freeing DB conection", e);
            }
        }
        this.msSapArt = sArt;
        this.mlAbfrageId = lAbfrageId;
        return lAbfrageId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteSapDaten() throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info("deleteSapDaten: Partslist ID: " + this.getID() + " User: " + this.getNutzerID());
        Connection con = null;
        try {
            con = gObj.getDBConnectionNutzer("Teileliste.deleteSapDaten");
            TeileListeDbAccess.deleteSapDaten(con, true, this.msID, this.msNutzerID);
        }
        finally {
            try {
                gObj.freeDBConnectionNutzer(con, "Teileliste.deleteSapDaten");
            }
            catch (Exception e) {
                log.error("Exception freeing DB conection", e);
            }
        }
    }

    public boolean getSapAnfrage() {
        return this.msSapArt != null && this.msSapArt.equals("A");
    }

    public boolean getSapBestellung() {
        return this.msSapArt != null && this.msSapArt.equals("B");
    }

    public String getSapArt() {
        if (this.msSapArt == null) {
            return "";
        }
        return this.msSapArt;
    }

    public void setSapArt(String sSapArt) {
        this.msSapArt = sSapArt;
    }

    public String getSapStatus() {
        if (this.msSapStatus == null) {
            return "";
        }
        return this.msSapStatus;
    }

    public void setSapStatus(String sSapStatus) {
        this.msSapStatus = sSapStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadHistorie(Connection con, String sFirma) throws SQLException, DatabaseBusyException {
        this.msHistory = "";
        this.mlAbfrageId = 0L;
        ResultSet res = null;
        try {
            res = sFirma == null ? TeileListeDbAccess.loadHistorie(con, this.msID, this.msNutzerID, this.msLanguage) : TeileListeDbAccess.loadHistorie(con, sFirma, this.msID, this.msNutzerID, this.msLanguage);
            while (res != null && res.next()) {
                Date dat = null;
                if (sFirma == null) {
                    long lDatum = res.getLong("Datum");
                    dat = WebetkUtils.getDateTimeFromLong(lDatum);
                } else {
                    dat = res.getTimestamp("Datum");
                }
                String sDatumZeit = WebetkUtils.getStringFromDateTime(dat, "de", 3, 3);
                String sDatum = sDatumZeit.substring(0, 5);
                String sZeit = sDatumZeit.substring(9);
                String sFunktion = res.getString("Funktion");
                if (this.msHistory.length() > 0) {
                    this.msHistory = this.msHistory + "\n";
                }
                this.msHistory = this.msHistory + sDatum + " " + sZeit + " " + sFunktion;
                if (res.getLong("AbfragId") <= 0L || this.mlAbfrageId != 0L) continue;
                this.mlAbfrageId = res.getLong("AbfragId");
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeHistorie(String sFunktion) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info("writeHistorie: Partslist ID: " + this.getID() + " User: " + this.getNutzerID());
        Connection con = null;
        try {
            con = gObj.getDBConnectionNutzer("writeHistorie.writeHistorie");
            TeileListeDbAccess.writeHistorie(con, this.msID, this.msNutzerID, this.mlAbfrageId, sFunktion);
            this.loadHistorie(con, null);
        }
        finally {
            try {
                gObj.freeDBConnectionNutzer(con, "Teileliste.writeHistorie");
            }
            catch (Exception e) {
                log.error("Exception freeing DB conection", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeHistorie(String sFunktion, String sFirma) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info("writeHistorie: Partslist ID: " + this.getID() + " User: " + this.getNutzerID());
        Connection con = null;
        try {
            con = gObj.getDBConnectionNutzer("writeHistorie.writeHistorie");
            TeileListeDbAccess.writeHistorie(con, sFirma, this.msID, this.msNutzerID, this.mlAbfrageId, sFunktion);
            this.loadHistorie(con, sFirma);
        }
        finally {
            try {
                gObj.freeDBConnectionNutzer(con, "Teileliste.writeHistorie");
            }
            catch (Exception e) {
                log.error("Exception freeing DB conection", e);
            }
        }
    }

    public String getSapError() {
        return this.msSapError;
    }

    public String getSapErrorFormated() {
        return this.msSapError.replaceAll("\\*", "<br>");
    }

    public void setSapError(String sSapError) {
        this.msSapError = sSapError;
    }

    public String getSapErrorIntern() {
        return this.msSapErrorIntern;
    }

    public void setSapErrorIntern(String sSapErrorIntern) {
        this.msSapErrorIntern = sSapErrorIntern;
    }

    public String getAbfrageIdString() {
        return Long.toString(this.mlAbfrageId);
    }

    public void setAbfrageId(String sAbfrageId) {
        this.mlAbfrageId = sAbfrageId == null ? 0L : Long.parseLong(sAbfrageId);
    }

    public boolean hatMinEinTeilFertigungshinweis() {
        if (this.mcTeile == null) {
            return false;
        }
        for (Teil oTeil : this.mcTeile) {
            if (oTeil.getFertigungshinweis() == null || oTeil.getFertigungshinweis().trim().length() <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean hatMinEinTeilRetr() {
        if (this.mcTeile == null) {
            return false;
        }
        for (Teil oTeil : this.mcTeile) {
            if (oTeil.getTransparenz() == null || oTeil.getTransparenz().trim().length() <= 0) continue;
            return true;
        }
        return false;
    }

    public String getSapWaehrung() {
        if (this.msSapWaehrung == null) {
            return "";
        }
        return this.msSapWaehrung;
    }

    public void setSapWaehrung(String sSapWaehrung) {
        this.msSapWaehrung = sSapWaehrung;
    }

    public String getAuftragsNrLokal() {
        return this.msAuftragsNrLokal;
    }

    public void setAuftragsNrLokal(String sAuftragsNrLokal) {
        this.msAuftragsNrLokal = sAuftragsNrLokal;
    }

    public Long getKundenNrLokal() {
        return this.mlKundenNrLokal;
    }

    public void setKundenNrLokal(Long lKundenNrLokal) {
        this.mlKundenNrLokal = lKundenNrLokal;
    }

    public Date getDatGesperrtAm() {
        return this.mdatGesperrtAm;
    }

    public String getDatGesperrtAmString() {
        if (this.mdatGesperrtAm == null) {
            return "";
        }
        return WebetkUtils.getStringFromDateTime(this.mdatGesperrtAm, this.msLanguage, 3, 3);
    }

    public void setDatGesperrtAm(Date datGesperrtAm) {
        this.mdatGesperrtAm = datGesperrtAm;
    }

    public String getGesperrtVon() {
        return this.msGesperrtVon;
    }

    public void setGesperrtVon(String sGesperrtVon) {
        this.msGesperrtVon = sGesperrtVon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkKannTeileUebernehmen(String sFirma, String sFiliale, String sNutzer) throws SQLException, DatabaseBusyException, NoDataFoundException {
        ResultSet res;
        Connection con;
        ServerGlobalObjects gObj;
        block7: {
            block6: {
                block5: {
                    boolean bl;
                    gObj = ServerGlobalObjects.getInstance();
                    con = null;
                    res = null;
                    try {
                        con = gObj.getDBConnectionNutzer("Teileliste.checkKannTeileUebernehmen");
                        res = TeileListeDbAccess.loadSperre(con, this.msID, this.msNutzerID, sNutzer, sFirma, sFiliale);
                        if (res != null && res.next()) break block5;
                        bl = false;
                    }
                    catch (Throwable throwable) {
                        WebetkUtils.closeQuery(res);
                        gObj.freeDBConnectionNutzer(con, "Teileliste.checkKannTeileUebernehmen");
                        throw throwable;
                    }
                    WebetkUtils.closeQuery(res);
                    gObj.freeDBConnectionNutzer(con, "Teileliste.checkKannTeileUebernehmen");
                    return bl;
                }
                String sGesperrtVon = res.getString("GesperrtVon");
                long lGesperrtAm = res.getLong("GesperrtAm");
                this.setGesperrtVon(sGesperrtVon);
                Date datGesperrtAm = WebetkUtils.getDateTimeFromLong(lGesperrtAm);
                this.setDatGesperrtAm(datGesperrtAm);
                if (sGesperrtVon == null || sGesperrtVon.equals(sNutzer)) break block6;
                boolean bl = false;
                WebetkUtils.closeQuery(res);
                gObj.freeDBConnectionNutzer(con, "Teileliste.checkKannTeileUebernehmen");
                return bl;
            }
            String sGesperrt = res.getString("Gesperrt");
            if (sGesperrt == null) break block7;
            this.setGesperrt(true);
            boolean bl = false;
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnectionNutzer(con, "Teileliste.checkKannTeileUebernehmen");
            return bl;
        }
        this.setGesperrt(false);
        boolean bl = true;
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnectionNutzer(con, "Teileliste.checkKannTeileUebernehmen");
        return bl;
    }

    public static boolean contains(Collection<Teileliste> cTL, Teileliste oTL) {
        for (Teileliste oVglTL : cTL) {
            if ((oVglTL.getID() != null || oTL.getID() != null) && !oVglTL.getID().equals(oTL.getID()) || (oVglTL.getNutzerID() != null || oTL.getNutzerID() != null) && !oVglTL.getNutzerID().equals(oTL.getNutzerID())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getNextTeilelistenId() throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        Connection con = null;
        try {
            con = gObj.getDBConnectionNutzer("Teileliste.getNextTeilelistenId");
            long l = TeileListeDbAccess.getNextTeilelistenId(con);
            return l;
        }
        finally {
            gObj.freeDBConnectionNutzer(con, "Teileliste.getNextTeilelistenId");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyTeilelisteInDb(String sNewID, String sOldID, String sNewNutzerID, String sOldNutzerID, String sFirma, String sNewFiliale, String sOldFiliale) throws SQLException, DatabaseBusyException, DuplicateValueException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info("copyTeilelisteInDb");
        Connection con = null;
        try {
            con = gObj.getDBConnectionNutzer("Teileliste.copyTeilelisteInDb");
            TeileListeDbAccess.copyTeileliste(con, sNewID, sOldID, sNewNutzerID, sOldNutzerID, sFirma, sNewFiliale, sOldFiliale);
        }
        finally {
            gObj.freeDBConnectionNutzer(con, "Teileliste.copyTeilelisteInDb");
        }
    }

    public Vector<Teil> getTeileSortiert(int feld, boolean bAsc) {
        Vector<Teil> cTeileUnsortiert = this.getTeile();
        Teil[] aTeile = new Teil[cTeileUnsortiert.size()];
        Iterator<Teil> iter = cTeileUnsortiert.iterator();
        int ii = 0;
        while (iter.hasNext()) {
            Teil oTeil;
            aTeile[ii] = oTeil = iter.next();
            ++ii;
        }
        TeilComparator comp = new TeilComparator(feld, bAsc);
        Arrays.sort(aTeile, comp);
        Vector<Teil> cTeileSortiert = new Vector<Teil>();
        for (ii = 0; ii < aTeile.length; ++ii) {
            cTeileSortiert.add(aTeile[ii]);
        }
        return cTeileSortiert;
    }

    public Iterator<String> ermittleFIKuerzel(boolean bMitDoppelten) {
        ArrayList<String> aKuerzel = new ArrayList<String>();
        HashMap<String, String> mapFIStrings = new HashMap<String, String>();
        char chNextKuerzel = 'A';
        Vector<Teil> cTeile = this.getTeile();
        if (cTeile != null) {
            for (Teil oTeil : cTeile) {
                String sFIString = oTeil.getFIString();
                if (sFIString == null) {
                    oTeil.setFIKuerzel("");
                    if (!bMitDoppelten) continue;
                    aKuerzel.add("");
                    continue;
                }
                String sKuerzel = (String)mapFIStrings.get(sFIString);
                if (sKuerzel == null) {
                    sKuerzel = String.valueOf(chNextKuerzel);
                    chNextKuerzel = (char)(chNextKuerzel + '\u0001');
                    mapFIStrings.put(sFIString, sKuerzel);
                    if (!bMitDoppelten) {
                        aKuerzel.add(sKuerzel);
                    }
                }
                oTeil.setFIKuerzel(sKuerzel);
                if (!bMitDoppelten) continue;
                aKuerzel.add(sKuerzel);
            }
        }
        return aKuerzel.iterator();
    }

    public Iterator<String> ermittleFIStrings() {
        ArrayList<String> aFIs = new ArrayList<String>();
        Vector<Teil> cTeile = this.getTeile();
        if (cTeile != null) {
            for (Teil oTeil : cTeile) {
                String sFIString = oTeil.getFIString();
                if (sFIString == null || sFIString.length() <= 0 || aFIs.contains(sFIString)) continue;
                aFIs.add(sFIString);
            }
        }
        return aFIs.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkPassTeileliste(String sID, String sNutzer) {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info("Checking Teileliste");
        Connection con = null;
        try {
            con = gObj.getDBConnectionNutzer("Teileliste.check");
            boolean bl = TeileListeDbAccess.checkTeileliste(con, sID, sNutzer);
            return bl;
        }
        catch (DatabaseBusyException e) {
            log.error("Fehler beim checkPassTeileliste", e);
        }
        catch (SQLException e) {
            log.error("Fehler beim checkPassTeileliste", e);
        }
        finally {
            try {
                gObj.freeDBConnectionNutzer(con, "Teileliste.check");
            }
            catch (SQLException e) {
                log.error("Fehler beim checkPassTeileliste", e);
            }
        }
        return false;
    }

    public String getSortSpalte() {
        return this.msSortSpalte;
    }

    public void setSortSpalte(String sSortSpalte) {
        this.msSortSpalte = sSortSpalte;
    }

    public String getSortAsc() {
        return this.msSortAsc;
    }

    public void setSortAsc(String sSortAsc) {
        this.msSortAsc = sSortAsc;
    }

    public String getLanguage() {
        return this.msLanguage;
    }

    public void setLanguage(String sLanguage) {
        this.msLanguage = sLanguage;
    }

    public String getFzgDlfId() {
        return this.msFzgDlfId;
    }

    public void setFzgDlfId(String fzgDlfId) {
        this.msFzgDlfId = fzgDlfId;
    }

    public String getPartsPartnerStatus() {
        return this.msPartsPartnerStatus;
    }

    public void setPartsPartnerStatus(String sPartsPartnerStatus) {
        this.msPartsPartnerStatus = sPartsPartnerStatus;
    }

    public RrNutzerdaten getRrNutzerdaten() {
        return this.moRrNutzerdaten;
    }

    public void setRrNutzerdaten(RrNutzerdaten oRrNutzerdaten) {
        this.moRrNutzerdaten = oRrNutzerdaten;
    }

    public boolean isRrSapListe() {
        if (this.msID == null) {
            return false;
        }
        if (this.msID.equals("_RRSAPLIST")) {
            return true;
        }
        return this.msSapStatus != null && this.msSapStatus.length() > 0;
    }

    public void setShowHintDiebstahlrelevant(boolean mbShowHintDiebstahlrelevant) {
        this.mbShowHintDiebstahlrelevant = mbShowHintDiebstahlrelevant;
    }

    public boolean isShowHintDiebstahlrelevant() {
        return this.mbShowHintDiebstahlrelevant;
    }

    public void setShowHintDiebstahlrelevantFor(String msShowHintDiebstahlrelevantFor) {
        this.msShowHintDiebstahlrelevantFor = msShowHintDiebstahlrelevantFor;
    }

    public String getShowHintDiebstahlrelevantFor() {
        return this.msShowHintDiebstahlrelevantFor;
    }

    public Collection<Teil> getMcTeile() {
        return this.mcTeile;
    }

    public void setMcTeile(Vector<Teil> mcTeile) {
        this.mcTeile = mcTeile;
    }

    public String getMsMarke() {
        return this.msMarke;
    }

    public void setMsMarke(String msMarke) {
        this.msMarke = msMarke;
    }

    public String getMsID() {
        return this.msID;
    }

    public void setMsID(String msID) {
        this.msID = msID;
    }

    public String getMsNewID() {
        return this.msNewID;
    }

    public void setMsNewID(String msNewID) {
        this.msNewID = msNewID;
    }

    public String getMsNutzerID() {
        return this.msNutzerID;
    }

    public void setMsNutzerID(String msNutzerID) {
        this.msNutzerID = msNutzerID;
    }

    public String getMsNutzerName() {
        return this.msNutzerName;
    }

    public void setMsNutzerName(String msNutzerName) {
        this.msNutzerName = msNutzerName;
    }

    public String getMsFiliale() {
        return this.msFiliale;
    }

    public void setMsFiliale(String msFiliale) {
        this.msFiliale = msFiliale;
    }

    public String getMsFilialeBen() {
        return this.msFilialeBen;
    }

    public void setMsFilialeBen(String msFilialeBen) {
        this.msFilialeBen = msFilialeBen;
    }

    public Teil getmSelektiertesTeil() {
        return this.mSelektiertesTeil;
    }

    public void setmSelektiertesTeil(Teil mSelektiertesTeil) {
        this.mSelektiertesTeil = mSelektiertesTeil;
    }

    public String getMsBemerkung() {
        return this.msBemerkung;
    }

    public void setMsBemerkung(String msBemerkung) {
        this.msBemerkung = msBemerkung;
    }

    public Date getMdatErstellung() {
        return this.mdatErstellung;
    }

    public void setMdatErstellung(Date mdatErstellung) {
        this.mdatErstellung = mdatErstellung;
    }

    public Date getMdatAenderung() {
        return this.mdatAenderung;
    }

    public void setMdatAenderung(Date mdatAenderung) {
        this.mdatAenderung = mdatAenderung;
    }

    public String getMsTarget() {
        return this.msTarget;
    }

    public void setMsTarget(String msTarget) {
        this.msTarget = msTarget;
    }

    public boolean isMbModified() {
        return this.mbModified;
    }

    public void setMbModified(boolean mbModified) {
        this.mbModified = mbModified;
    }

    public String getMsLanguage() {
        return this.msLanguage;
    }

    public void setMsLanguage(String msLanguage) {
        this.msLanguage = msLanguage;
    }

    public Vector<ValueAndNameSupport> getMcAnMailAdressen() {
        return this.mcAnMailAdressen;
    }

    public void setMcAnMailAdressen(Vector<ValueAndNameSupport> mcAnMailAdressen) {
        this.mcAnMailAdressen = mcAnMailAdressen;
    }

    public Auftrag getmAuftrag() {
        return this.mAuftrag;
    }

    public void setmAuftrag(Auftrag mAuftrag) {
        this.mAuftrag = mAuftrag;
    }

    public String getMsAuftragsNrLokal() {
        return this.msAuftragsNrLokal;
    }

    public void setMsAuftragsNrLokal(String msAuftragsNrLokal) {
        this.msAuftragsNrLokal = msAuftragsNrLokal;
    }

    public Long getMlKundenNrLokal() {
        return this.mlKundenNrLokal;
    }

    public void setMlKundenNrLokal(Long mlKundenNrLokal) {
        this.mlKundenNrLokal = mlKundenNrLokal;
    }

    public boolean isMbPrivat() {
        return this.mbPrivat;
    }

    public void setMbPrivat(boolean mbPrivat) {
        this.mbPrivat = mbPrivat;
    }

    public boolean isMbGesperrt() {
        return this.mbGesperrt;
    }

    public void setMbGesperrt(boolean mbGesperrt) {
        this.mbGesperrt = mbGesperrt;
    }

    public String getMsFzgDlfId() {
        return this.msFzgDlfId;
    }

    public void setMsFzgDlfId(String msFzgDlfId) {
        this.msFzgDlfId = msFzgDlfId;
    }

    public Date getMdatGesperrtAm() {
        return this.mdatGesperrtAm;
    }

    public void setMdatGesperrtAm(Date mdatGesperrtAm) {
        this.mdatGesperrtAm = mdatGesperrtAm;
    }

    public String getMsGesperrtVon() {
        return this.msGesperrtVon;
    }

    public void setMsGesperrtVon(String msGesperrtVon) {
        this.msGesperrtVon = msGesperrtVon;
    }

    public long getMlAbfrageId() {
        return this.mlAbfrageId;
    }

    public void setMlAbfrageId(long mlAbfrageId) {
        this.mlAbfrageId = mlAbfrageId;
    }

    public int getMnStep() {
        return this.mnStep;
    }

    public void setMnStep(int mnStep) {
        this.mnStep = mnStep;
    }

    public String getMsSapArt() {
        return this.msSapArt;
    }

    public void setMsSapArt(String msSapArt) {
        this.msSapArt = msSapArt;
    }

    public String getMsSapStatus() {
        return this.msSapStatus;
    }

    public void setMsSapStatus(String msSapStatus) {
        this.msSapStatus = msSapStatus;
    }

    public String getMsVIN() {
        return this.msVIN;
    }

    public void setMsVIN(String msVIN) {
        this.msVIN = msVIN;
    }

    public String getMsDringlichkeit() {
        return this.msDringlichkeit;
    }

    public void setMsDringlichkeit(String msDringlichkeit) {
        this.msDringlichkeit = msDringlichkeit;
    }

    public String getMsSapOrderNo() {
        return this.msSapOrderNo;
    }

    public void setMsSapOrderNo(String msSapOrderNo) {
        this.msSapOrderNo = msSapOrderNo;
    }

    public double getMdSapPreisSumme() {
        return this.mdSapPreisSumme;
    }

    public void setMdSapPreisSumme(double mdSapPreisSumme) {
        this.mdSapPreisSumme = mdSapPreisSumme;
    }

    public String getMsSapError() {
        return this.msSapError;
    }

    public void setMsSapError(String msSapError) {
        this.msSapError = msSapError;
    }

    public String getMsSapErrorIntern() {
        return this.msSapErrorIntern;
    }

    public void setMsSapErrorIntern(String msSapErrorIntern) {
        this.msSapErrorIntern = msSapErrorIntern;
    }

    public String getMsSapWaehrung() {
        return this.msSapWaehrung;
    }

    public void setMsSapWaehrung(String msSapWaehrung) {
        this.msSapWaehrung = msSapWaehrung;
    }

    public String getMsHistory() {
        return this.msHistory;
    }

    public void setMsHistory(String msHistory) {
        this.msHistory = msHistory;
    }

    public String getMsSortSpalte() {
        return this.msSortSpalte;
    }

    public void setMsSortSpalte(String msSortSpalte) {
        this.msSortSpalte = msSortSpalte;
    }

    public String getMsSortAsc() {
        return this.msSortAsc;
    }

    public void setMsSortAsc(String msSortAsc) {
        this.msSortAsc = msSortAsc;
    }

    public String getMsPartsPartnerStatus() {
        return this.msPartsPartnerStatus;
    }

    public void setMsPartsPartnerStatus(String msPartsPartnerStatus) {
        this.msPartsPartnerStatus = msPartsPartnerStatus;
    }

    public RrNutzerdaten getMoRrNutzerdaten() {
        return this.moRrNutzerdaten;
    }

    public void setMoRrNutzerdaten(RrNutzerdaten moRrNutzerdaten) {
        this.moRrNutzerdaten = moRrNutzerdaten;
    }

    public boolean isMbShowHintDiebstahlrelevant() {
        return this.mbShowHintDiebstahlrelevant;
    }

    public void setMbShowHintDiebstahlrelevant(boolean mbShowHintDiebstahlrelevant) {
        this.mbShowHintDiebstahlrelevant = mbShowHintDiebstahlrelevant;
    }

    public String getMsShowHintDiebstahlrelevantFor() {
        return this.msShowHintDiebstahlrelevantFor;
    }

    public void setMsShowHintDiebstahlrelevantFor(String msShowHintDiebstahlrelevantFor) {
        this.msShowHintDiebstahlrelevantFor = msShowHintDiebstahlrelevantFor;
    }
}

