/*
 * Decompiled with CFR 0.152.
 */
package webetk.communication.command;

import java.lang.reflect.Method;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.InvalidDataException;
import webetk.InvalidInitializationException;
import webetk.NoBrandAuthorizationException;
import webetk.NoDataFoundException;
import webetk.app.Bedingung;
import webetk.app.BmwNetz;
import webetk.app.ServerGlobalObjects;
import webetk.app.ValueAndNameSupport;
import webetk.app.ausstattung.Ausstattung;
import webetk.app.fzgid.BedZusatzInfo;
import webetk.app.fzgid.FzgIdInfo;
import webetk.app.fzgid.ZusatzInfoMarke;
import webetk.app.fzgsuche.FzgSucheInfo;
import webetk.communication.CommunicationException;
import webetk.communication.JavaFzgIdInfo;
import webetk.communication.JavaFzgSucheInfo;
import webetk.communication.command.AbstractTransferableCommand;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.Transferable;
import webetk.communication.transferables.TrfFahrzeugId;
import webetk.etkscore.EtkScoreVerbauung;
import webetk.interfaces.dom.basic.Colour;
import webetk.interfaces.dom.basic.Equipment;
import webetk.interfaces.dom.basic.JaNeinCode;
import webetk.interfaces.dom.basic.Upholstery;
import webetk.interfaces.dom.basic.VehicleBasic;
import webetk.interfaces.dom.basic.VehicleType;
import webetk.interfaces.dom.options.DOMmessageType;
import webetk.interfaces.dom.options.Option;
import webetk.interfaces.dom.options.Options;
import webetk.interfaces.dom.options.Vehicle;
import webetk.interfaces.dom.options.VehicleOptions;
import webetk.interfaces.domsowu.ConnectionConfiguration;
import webetk.interfaces.domsowu.VehicleBasicManager;
import webetk.interfaces.domsowu.VehicleOptionsManager;
import webetk.javaserver.app.GlobalObjects;
import webetk.mrkprd.Produkte;

public class TrfFahrzeugIdCommand
extends AbstractTransferableCommand {
    protected Logger log = Logger.getLogger(TrfFahrzeugIdCommand.class);
    protected Logger logTime = Logger.getLogger("time");

    @Override
    public void setTransferable(Transferable trf) {
        if (!(trf instanceof TrfFahrzeugId)) {
            this.log.error("Given transferable must be TrfFahrzeugId, but it isn't!");
            throw new ClassCastException("TrfFahrzeugId excepted!");
        }
        super.setTransferable(trf);
    }

    @Override
    public void execute() throws InvalidDataException, DatabaseBusyException, SQLException {
        TrfFahrzeugId transferableMap = (TrfFahrzeugId)this.transferable;
        Command command = transferableMap.getCommand();
        this.log.debug("Executing command: " + command);
        if (Command.NO_OPERATION.equals(command)) {
            return;
        }
        if (Command.START_FAHRZEUGIDENTIFIKATION.equals(command)) {
            this.doStartOperation(transferableMap);
            return;
        }
        if (Command.CHANGE_FAHRZEUGIDENTIFIKATION.equals(command)) {
            this.doChangeOperation(transferableMap);
            return;
        }
        if (Command.FINALIZE_FAHRZEUGIDENTIFIKATION_WITH_ATTR.equals(command)) {
            this.doFinalizeAttributes(transferableMap);
            return;
        }
        if (Command.FINALIZE_FAHRZEUGIDENTIFIKATION_WITH_FGSTNR.equals(command)) {
            this.doFinalizeFgstnr(transferableMap);
            return;
        }
        if (Command.GET_VIN_RESOLVER_VIN17.equals(command)) {
            this.doFinalizeFgstnrVIN17(transferableMap);
            return;
        }
        if (Command.GET_VIN_BASIC_INFO.equals(command)) {
            this.getVehicleBasicInfo(transferableMap);
            return;
        }
        if (Command.SYNCHRONIZE_FI.equals(command)) {
            this.doSynchronizeFI(transferableMap);
            return;
        }
        if (Command.RESET_FAHRZEUGIDENTIFIKATION.equals(command)) {
            this.doResetOperation();
            return;
        }
        if (Command.LOAD_ZUSATZINFO_MARKE.equals(command)) {
            this.loadZusatzInfoMarke(transferableMap);
            return;
        }
        this.log.error("No valid command: " + command);
        throw new InvalidDataException("No valid command: " + command);
    }

    protected void doResetOperation() {
        this.sessionInfo.resetFzgId();
    }

    protected void doStartOperation(TrfFahrzeugId transferable) {
        String sIsVollstaendigeFI = (String)transferable.getValue("isvollstaendigefi");
        boolean bComplete = sIsVollstaendigeFI != null && sIsVollstaendigeFI.equals("true");
        FzgSucheInfo oSucheInfo = this.sessionInfo.getFzgSucheInfo();
        if (oSucheInfo == null) {
            this.sessionInfo.resetFzgId();
        }
        if (this.sessionInfo.doZentraleRecherche()) {
            try {
                if (this.sessionInfo.getFzgIdInfo() != null) {
                    JavaFzgIdInfo oJavaSucheInfo = new JavaFzgIdInfo(this.sessionInfo.getFzgIdInfo(), bComplete);
                    transferable.setValue("fzgidinfo_java", oJavaSucheInfo);
                    transferable.setValue("marke", this.sessionInfo.getFzgIdInfo().getMarke());
                    transferable.setValue("produktart", this.sessionInfo.getFzgIdInfo().getProduktart());
                    transferable.setValue("katalogumfang", this.sessionInfo.getFzgIdInfo().getKatalogumfang());
                } else {
                    transferable.setValue("marken_berechtigungen", this.sessionInfo.getUserMarken());
                    transferable.setValue("produkte_berechtigungen", this.sessionInfo.getUserProdukte());
                    transferable.setValue("katalogumfang_berechtigung", this.sessionInfo.getUserKatUmfang());
                    transferable.setValue("marke", this.sessionInfo.getUserInfo().getMarke());
                    transferable.setValue("produktart", this.sessionInfo.getUserInfo().getProduktart());
                    transferable.setValue("katalogumfang", this.sessionInfo.getUserInfo().getKatalogumfang());
                }
                transferable.setValue("regionendefault", this.sessionInfo.getUserInfo().getRegionen());
                transferable.setValue("lenkung", this.sessionInfo.getUserInfo().getLenkung());
                transferable.setValue("iso", this.sessionInfo.getUserInfo().getSprache());
                transferable.setValue("regiso", this.sessionInfo.getUserInfo().getSpracheRegion());
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferable, Command.START_FAHRZEUGIDENTIFIKATION);
            }
            catch (CommunicationException ex) {
                transferable.setError(ex);
                return;
            }
            JavaFzgIdInfo oJavaFzgIdInfo = (JavaFzgIdInfo)transferable.getValue("fzgidinfo_java");
            FzgIdInfo oFzgIdInfo = oJavaFzgIdInfo.constructFzgIdInfo();
            this.sessionInfo.setFzgIdInfo(oFzgIdInfo);
            return;
        }
        try {
            if (this.sessionInfo.getFzgIdInfo() == null && !this.initFzgId()) {
                transferable.setError(new InvalidInitializationException("Fehler beim Anlegen der neuen Fahrzeugidentifiaktion"));
            }
            this.sessionInfo.getFzgIdInfo().adjust(bComplete);
        }
        catch (Exception e) {
            transferable.setError(e);
            return;
        }
        JavaFzgIdInfo oJavaFzgIdInfo = new JavaFzgIdInfo(this.sessionInfo.getFzgIdInfo(), bComplete);
        transferable.setValue("fzgidinfo_java", oJavaFzgIdInfo);
    }

    protected void doChangeOperation(TrfFahrzeugId transferable) {
        this.log.info("Performing Operation SELECT!");
        String sLang = this.sessionInfo.getAktuelleSprache();
        String sIsVollstaendigeFI = (String)transferable.getValue("isvollstaendigefi");
        boolean bComplete = sIsVollstaendigeFI != null && sIsVollstaendigeFI.equals("true");
        FzgIdInfo oFzgIdInfo = this.sessionInfo.getFzgIdInfo();
        if (oFzgIdInfo == null) {
            this.log.info("No FzgIdInfo-Objekt found! Trying to reconstruct one.");
            if (!this.initFzgId()) {
                transferable.setError(new InvalidInitializationException("Could not create FzgIdInfo-Objekt."));
                return;
            }
            oFzgIdInfo = this.sessionInfo.getFzgIdInfo();
        }
        if (!this.reconstructDefaultWerte(oFzgIdInfo)) {
            this.log.warn("Could not find the default values in the HTML page! Proceeding without.");
        }
        if (this.sessionInfo.doZentraleRecherche()) {
            JavaFzgIdInfo oJavaFzgIdInfo;
            try {
                oJavaFzgIdInfo = new JavaFzgIdInfo(oFzgIdInfo, bComplete);
                transferable.setValue("fzgidinfo_java", oJavaFzgIdInfo);
                transferable.setValue("sprache", sLang);
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferable, Command.CHANGE_FAHRZEUGIDENTIFIKATION);
            }
            catch (CommunicationException ex) {
                transferable.setError(ex);
                return;
            }
            oJavaFzgIdInfo = (JavaFzgIdInfo)transferable.getValue("fzgidinfo_java");
            oFzgIdInfo = oJavaFzgIdInfo.constructFzgIdInfo();
            this.sessionInfo.setFzgIdInfo(oFzgIdInfo);
            return;
        }
        this.log.debug("Trying to select attributes now ...");
        try {
            this.constructFzgIdInfo(transferable, oFzgIdInfo, sLang);
            oFzgIdInfo.adjust(bComplete);
            JavaFzgIdInfo oJavaFzgIdInfo = new JavaFzgIdInfo(oFzgIdInfo, bComplete);
            transferable.setValue("fzgidinfo_java", oJavaFzgIdInfo);
        }
        catch (Exception e) {
            transferable.setError(e);
        }
    }

    protected void doFinalizeAttributes(TrfFahrzeugId transferable) {
        boolean bDisplayDate;
        this.log.info("Performing Operation FINALIZE_ATT!");
        Boolean bDisplayDateAlways = this.sessionInfo.getUserInfo().getAlwaysDisplayProduktDate();
        boolean bHasRechtDisplayDate = this.sessionInfo.hasRechtAnzeigeProddatum();
        boolean bl = bDisplayDate = bHasRechtDisplayDate;
        if (bDisplayDate && (bDisplayDateAlways == null || !bDisplayDateAlways.booleanValue())) {
            bDisplayDate = false;
        }
        String sLang = this.sessionInfo.getAktuelleSprache();
        String sIsVollstaendigeFI = (String)transferable.getValue("isvollstaendigefi");
        boolean bComplete = sIsVollstaendigeFI != null && sIsVollstaendigeFI.equals("true");
        FzgIdInfo oFzgIdInfo = this.sessionInfo.getFzgIdInfo();
        if (oFzgIdInfo == null) {
            this.log.warn("No FzgIdInfo-Objekt found! Trying to reconstruct one.");
            if (!this.initFzgId()) {
                transferable.setError(new InvalidInitializationException("Could not create FzgIdInfo-Objekt."));
                return;
            }
            oFzgIdInfo = this.sessionInfo.getFzgIdInfo();
        }
        this.log.debug("Trying to collect attributes now ...");
        oFzgIdInfo = this.assembleFzgIdInfo(transferable, oFzgIdInfo);
        if (oFzgIdInfo == null) {
            this.log.error("Not all mandatory attributes were found on the HTML-page.");
            transferable.setError(new InvalidInitializationException("Not all mandatory attributes were found."));
            return;
        }
        if (this.sessionInfo.doZentraleRecherche()) {
            JavaFzgIdInfo oJavaFzgIdInfo;
            try {
                oJavaFzgIdInfo = new JavaFzgIdInfo(oFzgIdInfo, bComplete);
                transferable.setValue("fzgidinfo_java", oJavaFzgIdInfo);
                transferable.setValue("sprache", sLang);
                String sDisplayDate = bDisplayDate ? "true" : "false";
                transferable.setValue("ProdDatum", sDisplayDate);
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferable, Command.FINALIZE_FAHRZEUGIDENTIFIKATION_WITH_ATTR);
            }
            catch (CommunicationException ex) {
                transferable.setError(ex);
                return;
            }
            oJavaFzgIdInfo = (JavaFzgIdInfo)transferable.getValue("fzgidinfo_java");
            oFzgIdInfo = oJavaFzgIdInfo.constructFzgIdInfo();
            this.sessionInfo.setFzgIdInfo(oFzgIdInfo);
            FzgSucheInfo oFzgSucheInfo = (FzgSucheInfo)transferable.getValue("fzgsucheinfo_app");
            this.sessionInfo.setSucheInfo(oFzgSucheInfo);
            JavaFzgSucheInfo oJavaFzgSucheInfo = new JavaFzgSucheInfo(oFzgSucheInfo);
            transferable.setValue("fzgsucheinfo_java", oJavaFzgSucheInfo);
            transferable.setValue("fzgsucheinfo_app", oFzgSucheInfo);
            return;
        }
        this.sessionInfo.resetFzgSuche();
        try {
            oFzgIdInfo.finalize(this.sessionInfo.newFzgSucheInfo(), bDisplayDate, null, null);
            this.log.debug("Calculated Modellspalte is: " + Long.toString(oFzgIdInfo.getModellspalte()));
            JavaFzgSucheInfo oJavaFzgSucheInfo = new JavaFzgSucheInfo(this.sessionInfo.getFzgSucheInfo());
            JavaFzgIdInfo oJavaFzgIdInfo = new JavaFzgIdInfo(oFzgIdInfo, bComplete);
            transferable.setValue("fzgsucheinfo_java", oJavaFzgSucheInfo);
            transferable.setValue("fzgsucheinfo_app", this.sessionInfo.getFzgSucheInfo());
            transferable.setValue("fzgidinfo_java", oJavaFzgIdInfo);
        }
        catch (SQLException e) {
            this.log.error("Calculation Modellspalte failed due to database error: " + e.getMessage(), e);
            transferable.setError(e);
        }
        catch (DatabaseBusyException e) {
            this.log.error("Calculation Modellspalte failed because database is busy!", e);
            transferable.setError(e);
        }
        catch (NoDataFoundException e) {
            transferable.setError(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doEvalFgzIdString(TrfFahrzeugId transferable) {
        boolean bDisplayDate;
        this.log.info("Performing Operation EVAL_FZGID_STRING!");
        Boolean bDisplayDateAlways = this.sessionInfo.getUserInfo().getAlwaysDisplayProduktDate();
        boolean bHasRechtDisplayDate = this.sessionInfo.hasRechtAnzeigeProddatum();
        boolean bl = bDisplayDate = bHasRechtDisplayDate;
        if (bDisplayDate && (bDisplayDateAlways == null || !bDisplayDateAlways.booleanValue())) {
            bDisplayDate = false;
        }
        String sLang = this.sessionInfo.getAktuelleSprache();
        String sFzgNr = (String)transferable.getValue("fgstnr");
        sFzgNr = sFzgNr.toUpperCase();
        FzgIdInfo oFzgIdInfo = new FzgIdInfo();
        boolean bFahrzeugFound = false;
        FzgSucheInfo oFzgSucheInfo = new FzgSucheInfo();
        if (this.sessionInfo.doZentraleRecherche()) {
            try {
                transferable.setValue("sprache", sLang);
                String sDisplayDate = bDisplayDate ? "true" : "false";
                transferable.setValue("fgstnr", sFzgNr);
                transferable.setValue("ProdDatum", sDisplayDate);
                transferable.setValue("marken_berechtigungen", this.sessionInfo.getUserMarken());
                transferable.setValue("produkte_berechtigungen", this.sessionInfo.getUserProdukte());
                transferable.setValue("katalogumfang_berechtigung", this.sessionInfo.getUserKatUmfang());
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferable, Command.EVAL_FZGID_STRING);
            }
            catch (CommunicationException ex) {
                transferable.setError(ex);
                return;
            }
            if (transferable.getError() == null) return;
            if (!(transferable.getError() instanceof NoDataFoundException)) return;
            bFahrzeugFound = false;
        } else {
            try {
                oFzgIdInfo.finalize(sFzgNr, this.sessionInfo.getUserMarken(), this.sessionInfo.getUserProdukte(), this.sessionInfo.getUserKatUmfang(), oFzgSucheInfo, sLang, bDisplayDate, null, null);
                bFahrzeugFound = true;
            }
            catch (SQLException e) {
                this.log.error("Calculation Modellspalte failed due to database error: " + e.getMessage(), e);
                transferable.setError(e);
                return;
            }
            catch (DatabaseBusyException e) {
                this.log.error("Calculation Modellspalte failed because database is busy!", e);
                transferable.setError(e);
                return;
            }
            catch (InvalidDataException e) {
                this.log.error("Inconsistency in the data for the FzgNr <" + sFzgNr + "> detected!", e);
                transferable.setError(e);
                return;
            }
            catch (NoBrandAuthorizationException e) {
                this.log.error("User-Settings (brand:" + this.sessionInfo.getUserMarken() + ", product: " + this.sessionInfo.getUserProdukte() + ", catalogue: " + this.sessionInfo.getUserKatUmfang() + ") does not match with vehicle <" + sFzgNr + "> data!", e);
                transferable.setError(e);
                return;
            }
            catch (NoDataFoundException e) {
                bFahrzeugFound = false;
            }
        }
        try {
            if (!bFahrzeugFound) {
                TrfFahrzeugId webETKTransferable = new TrfFahrzeugId(null);
                webETKTransferable.setValue("FAHRGESTELLNUMMER", sFzgNr);
                webETKTransferable.setValue("language", sLang);
                this.getIGDOMTypetc(webETKTransferable);
                String[] aInfo = (String[])webETKTransferable.getValue("IGDOM_TYPE");
                Exception ex = webETKTransferable.getError();
                if (ex != null) {
                    transferable.setError(ex);
                }
                if (aInfo == null) {
                    transferable.setError(new NoDataFoundException());
                    return;
                }
                String sTyp = aInfo[0];
                String sProdDatum = aInfo[1];
                String marketspecSalesDesc = null;
                if (aInfo.length > 2) {
                    marketspecSalesDesc = aInfo[2];
                }
                oFzgIdInfo.finalize(sFzgNr, sTyp, sProdDatum, this.sessionInfo.getUserMarken(), this.sessionInfo.getUserProdukte(), this.sessionInfo.getUserKatUmfang(), oFzgSucheInfo, sLang, bDisplayDate, null, null, marketspecSalesDesc);
            }
        }
        catch (SQLException e) {
            this.log.error("Calculation Modellspalte failed due to database error: " + e.getMessage(), e);
            transferable.setError(e);
            return;
        }
        catch (DatabaseBusyException e) {
            this.log.error("Calculation Modellspalte failed because database is busy!", e);
            transferable.setError(e);
            return;
        }
        catch (InvalidDataException e) {
            this.log.error("Inconsistency in the data for the FzgNr <" + sFzgNr + "> detected!", e);
            transferable.setError(e);
            return;
        }
        catch (NoBrandAuthorizationException e) {
            this.log.error("User-Settings (brand:" + this.sessionInfo.getUserMarken() + ", product: " + this.sessionInfo.getUserProdukte() + ", catalogue: " + this.sessionInfo.getUserKatUmfang() + ") does not match with vehicle <" + sFzgNr + "> data!", e);
            transferable.setError(e);
            return;
        }
        catch (NoDataFoundException e) {
            transferable.setError(e);
            return;
        }
        String sFzgIdString = oFzgIdInfo.toString(bDisplayDate, null, null);
        transferable.setValue("fzgidstring", sFzgIdString);
    }

    protected void doDeleteOperation(TrfFahrzeugId transferable) {
        this.log.info("Performing Operation DELETE!");
        this.sessionInfo.resetFzgId();
    }

    protected boolean initFzgId() {
        FzgIdInfo fzgInfo = this.sessionInfo.newFzgIdInfo();
        return fzgInfo != null;
    }

    protected void constructFzgIdInfo(TrfFahrzeugId trfHashmap, FzgIdInfo fzgId, String sAktLang) throws InvalidDataException {
        try {
            boolean bComplete;
            String sMarke = (String)trfHashmap.getValue("marke");
            String sPArt = (String)trfHashmap.getValue("produktart");
            String sKatUmfang = (String)trfHashmap.getValue("katalogumfang");
            String sIsVollstaendigeFI = (String)trfHashmap.getValue("isvollstaendigefi");
            boolean bl = bComplete = sIsVollstaendigeFI != null && sIsVollstaendigeFI.equals("true");
            if (sMarke == null || sPArt == null || sKatUmfang == null) {
                this.log.warn("Invalid call! Major attribut is null! Using default from user.");
                if (sMarke == null && (sMarke = fzgId.getDefaultMarke()) == null) {
                    this.log.error("No valid value for Marke found!");
                    throw new InvalidDataException("No valid value for Marke found!");
                }
                if (sPArt == null && (sPArt = fzgId.getDefaultProduktart()) == null) {
                    this.log.error("No valid value for Produktart found!");
                    throw new InvalidDataException("No valid value for Produktart found!");
                }
                if (sKatUmfang == null && (sKatUmfang = fzgId.getDefaultKatUmfang()) == null) {
                    this.log.error("No valid value for Katalogumfang found!");
                    throw new InvalidDataException("No valid value for Katalogumfang found!");
                }
                this.log.warn("Using Marke (" + sMarke + "), Produktart (" + sPArt + "), Katalogumfang (" + sKatUmfang + ")");
            }
            if (!(sMarke.equalsIgnoreCase(fzgId.getMarke()) && sPArt.equalsIgnoreCase(fzgId.getProduktart()) && sKatUmfang.equalsIgnoreCase(fzgId.getKatalogumfang()))) {
                this.log.debug("Calculating Baureihen anew ...");
                fzgId.setMajorAttributes(sMarke, sPArt, sKatUmfang);
                return;
            }
            ValueAndNameSupport oGenVal = null;
            oGenVal = bComplete ? fzgId.NO_RESTRICT_VALUE : fzgId.ALLE_WERTE_VALUE;
            if (sPArt.equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung())) {
                this.constructFzgIdInfoAuto(trfHashmap, fzgId, sMarke);
                this.insertAtBeginToVector(oGenVal, fzgId.getLenkungen());
                this.insertAtBeginToVector(oGenVal, fzgId.getGetriebewerte());
            } else {
                this.constructFzgIdInfoKrad(trfHashmap, fzgId, sMarke);
            }
            this.insertAtBeginToVector(oGenVal, fzgId.getBaujahre());
            this.insertAtBeginToVector(oGenVal, fzgId.getZulassungsmonate());
        }
        catch (SQLException e) {
            this.log.error("Database access error! Baureihen could not be loaded!", e);
            throw new InvalidDataException("Database access error! Baureihen could not be loaded!");
        }
        catch (DatabaseBusyException e) {
            this.log.error("Database is busy! Baureihen could not be loaded!", e);
            throw new InvalidDataException("Database is busy! Baureihen could not be loaded!");
        }
    }

    protected void constructFzgIdInfoAuto(TrfFahrzeugId trfHashmap, FzgIdInfo fzgId, String sMarke) throws SQLException, DatabaseBusyException, InvalidDataException {
        String sIsVollstaendigeFI = (String)trfHashmap.getValue("isvollstaendigefi");
        boolean bComplete = sIsVollstaendigeFI != null && sIsVollstaendigeFI.equals("true");
        String sBaureihe = (String)trfHashmap.getValue("baureihe");
        String sKarosserie = (String)trfHashmap.getValue("karosserie");
        String sModell = (String)trfHashmap.getValue("modell");
        String sRegion = (String)trfHashmap.getValue("region");
        String sLenkung = (String)trfHashmap.getValue("lenkung");
        String sGetriebe = (String)trfHashmap.getValue("getriebe");
        String sBaujahr = (String)trfHashmap.getValue("baujahr");
        String sZulMonat = (String)trfHashmap.getValue("zulmonat");
        if (sBaureihe == null) {
            this.log.debug("Calculating Baureihen new ...");
            fzgId.setMarke(sMarke, bComplete);
            return;
        }
        if (!sBaureihe.equalsIgnoreCase(fzgId.getBaureihe()) || sKarosserie == null) {
            this.log.debug("Setting Baureihe to: " + sBaureihe);
            fzgId.setBaureihe(sBaureihe, bComplete);
        }
        if (sKarosserie == null || !this.checkAttributeValue(fzgId.getKarosserien(), sKarosserie)) {
            return;
        }
        if (!sKarosserie.equalsIgnoreCase(fzgId.getKarosserie()) || sModell == null) {
            this.log.debug("Setting Karosserie to: " + sKarosserie);
            fzgId.setKarosserie(sKarosserie, bComplete);
        }
        if (sModell == null || !this.checkAttributeValue(fzgId.getModelle(), sModell)) {
            return;
        }
        if (!sModell.equalsIgnoreCase(fzgId.getModell()) || sRegion == null) {
            this.log.debug("Setting Modell to: " + sModell);
            fzgId.setModell(sModell, bComplete);
        }
        if (sRegion == null || !this.checkAttributeValue(fzgId.getRegionen(), sRegion)) {
            return;
        }
        if (!sRegion.equalsIgnoreCase(fzgId.getRegion()) || sLenkung == null) {
            this.log.debug("Setting Region to: " + sRegion);
            fzgId.setRegion(sRegion, bComplete);
        }
        if (sLenkung == null || !this.checkAttributeValue(fzgId.getLenkungen(), sLenkung)) {
            if (bComplete) {
                if (sLenkung == null || !sLenkung.equals("kA")) {
                    return;
                }
            } else if (!bComplete) {
                if (fzgId.getLenkung() != null) {
                    return;
                }
                sLenkung = "AlleWerte";
            }
        }
        if (!sLenkung.equalsIgnoreCase(fzgId.getLenkung()) || sGetriebe == null) {
            this.log.debug("Setting Lenkung to: " + sLenkung);
            fzgId.setLenkung(sLenkung, bComplete);
        }
        if (sGetriebe == null || !this.checkAttributeValue(fzgId.getGetriebewerte(), sGetriebe)) {
            if (bComplete) {
                if (sGetriebe == null || !sGetriebe.equals("kA")) {
                    return;
                }
            } else {
                if (fzgId.getGetriebe() != null) {
                    return;
                }
                sGetriebe = "AlleWerte";
            }
        }
        if (!sGetriebe.equalsIgnoreCase(fzgId.getGetriebe()) || sBaujahr == null) {
            this.log.debug("Setting Getriebe to: " + sGetriebe);
            fzgId.setGetriebe(sGetriebe, bComplete);
        }
        if (sBaujahr == null || !this.checkAttributeValue(fzgId.getBaujahre(), sBaujahr)) {
            if (bComplete) {
                if (sBaujahr == null || !sBaujahr.equals("kA")) {
                    return;
                }
            } else {
                if (fzgId.getBaujahr() != null) {
                    return;
                }
                sBaujahr = "AlleWerte";
            }
        }
        if (!sBaujahr.equalsIgnoreCase(fzgId.getBaujahr()) || sZulMonat == null) {
            this.log.debug("Setting Baujahr to: " + sBaujahr);
            fzgId.setBaujahr(sBaujahr, bComplete);
        }
        if (sZulMonat == null || !this.checkAttributeValue(fzgId.getZulassungsmonate(), sZulMonat)) {
            if (bComplete) {
                if (sZulMonat == null || !sZulMonat.equals("kA")) {
                    return;
                }
            } else {
                if (fzgId.getZulMonat() != null) {
                    return;
                }
                sZulMonat = "AlleWerte";
            }
        }
        if (!sZulMonat.equalsIgnoreCase(fzgId.getZulMonat())) {
            this.log.debug("Setting Zulassungsmonat to: " + sZulMonat);
            fzgId.setZulMonat(sZulMonat, bComplete);
        }
    }

    protected void constructFzgIdInfoKrad(TrfFahrzeugId trfHashmap, FzgIdInfo fzgId, String sMarke) throws SQLException, DatabaseBusyException, InvalidDataException {
        String sIsVollstaendigeFI = (String)trfHashmap.getValue("isvollstaendigefi");
        boolean bComplete = sIsVollstaendigeFI != null && sIsVollstaendigeFI.equals("true");
        String sBauart = (String)trfHashmap.getValue("bauart");
        String sBaureihe = (String)trfHashmap.getValue("baureihe");
        String sModell = (String)trfHashmap.getValue("modell");
        String sRegion = (String)trfHashmap.getValue("region");
        String sBaujahr = (String)trfHashmap.getValue("baujahr");
        String sMonat = (String)trfHashmap.getValue("zulmonat");
        if (sBauart == null) {
            this.log.debug("Calculating Bauarten anew ...");
            fzgId.setMarke(sMarke, bComplete);
            return;
        }
        if (!sBauart.equalsIgnoreCase(fzgId.getBauart()) || sBaureihe == null) {
            this.log.debug("Setting Bauart to: " + sBauart);
            fzgId.setBauart(sBauart, bComplete);
        }
        if (sBaureihe == null || !this.checkAttributeValue(fzgId.getBaureihen(), sBaureihe)) {
            return;
        }
        if (!sBaureihe.equalsIgnoreCase(fzgId.getBaureihe()) || sModell == null) {
            this.log.debug("Setting Baureihe to: " + sBaureihe);
            fzgId.setBaureihe(sBaureihe, bComplete);
        }
        if (sModell == null || !this.checkAttributeValue(fzgId.getModelle(), sModell)) {
            return;
        }
        if (!sModell.equalsIgnoreCase(fzgId.getModell()) || sRegion == null) {
            this.log.debug("Setting Modell to: " + sModell);
            fzgId.setModell(sModell, bComplete);
        }
        if (sRegion == null || !this.checkAttributeValue(fzgId.getRegionen(), sRegion)) {
            return;
        }
        if (!sRegion.equalsIgnoreCase(fzgId.getRegion()) || sBaujahr == null) {
            this.log.debug("Setting Region to: " + sRegion);
            fzgId.setRegion(sRegion, bComplete);
        }
        if (sBaujahr == null || !this.checkAttributeValue(fzgId.getBaujahre(), sBaujahr)) {
            if (bComplete) {
                if (sBaujahr == null || !sBaujahr.equals("kA")) {
                    return;
                }
            } else {
                if (fzgId.getBaujahr() != null) {
                    return;
                }
                sBaujahr = "AlleWerte";
            }
        }
        if (!sBaujahr.equalsIgnoreCase(fzgId.getBaujahr()) || sMonat == null) {
            this.log.debug("Setting Baujahr to: " + sBaujahr);
            fzgId.setBaujahr(sBaujahr, bComplete);
        }
        if (sMonat == null || !this.checkAttributeValue(fzgId.getZulassungsmonate(), sMonat)) {
            if (bComplete) {
                if (sMonat == null || !sMonat.equals("kA")) {
                    return;
                }
            } else {
                if (fzgId.getZulMonat() != null) {
                    return;
                }
                sMonat = "AlleWerte";
            }
        }
        if (!sMonat.equalsIgnoreCase(fzgId.getZulMonat())) {
            this.log.debug("Setting Zulassungsmonat to: " + sMonat);
            fzgId.setZulMonat(sMonat, bComplete);
        }
    }

    protected boolean checkAttributeValue(Collection<?> col, String sValue) throws InvalidDataException {
        if (col == null) {
            return false;
        }
        for (Object oElement : col) {
            String sCompare = null;
            if (oElement instanceof String) {
                sCompare = (String)oElement;
            } else {
                Class<?> oClass = oElement.getClass();
                Method oMethod = null;
                try {
                    oMethod = oClass.getMethod("getValue", null);
                    sCompare = (String)oMethod.invoke(oElement, (Object[])null);
                }
                catch (Exception e) {
                    this.log.error("The collection for an attribute contains invalid data (wrong classes)!");
                    throw new InvalidDataException();
                }
            }
            if (sValue == null && sCompare == null) {
                return true;
            }
            if (sValue == null || sCompare == null || !sValue.equals(sCompare)) continue;
            return true;
        }
        return false;
    }

    protected void doFinalizeFgstnrVIN17(TrfFahrzeugId transferable) {
        this.log.info("Performing Operation FINALIZE_FGSTNR! doFinalizeFgstnrVIN17");
        transferable.setValue("language", this.sessionInfo.getAktuelleSprache());
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(transferable, Command.GET_VIN_RESOLVER_VIN17);
        }
        catch (CommunicationException ex) {
            transferable.setError(ex);
            return;
        }
    }

    protected void getVehicleBasicInfo(TrfFahrzeugId transferable) {
        this.log.info("Performing Operation GET_VIN_BASIC_INFO! getVehicleBasicInfo");
        transferable.setValue("language", this.sessionInfo.getAktuelleSprache());
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(transferable, Command.GET_VIN_BASIC_INFO);
        }
        catch (CommunicationException ex) {
            transferable.setError(ex);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doFinalizeFgstnr(TrfFahrzeugId transferable) {
        String sIsVollstaendigeFI;
        boolean bDisplayDate;
        this.log.info("Performing Operation FINALIZE_FGSTNR!");
        String sInfoTyp = (String)transferable.getValue("typ");
        String mospId = (String)transferable.getValue("modellspaltenid");
        ArrayList ausstattung = (ArrayList)transferable.getValue("score_ausstattungsinfo");
        boolean bScoreAusstattungenVerwenden = ausstattung != null && ausstattung.size() > 0;
        String sIGDOMKontaktieren = (String)transferable.getValue("igdom_schnittstelle_kontaktieren");
        boolean bIGDOMKontaktieren = sIGDOMKontaktieren != null && sIGDOMKontaktieren.equals("true");
        String sSOWUKontaktieren = (String)transferable.getValue("sowu_schnittstelle_kontaktieren");
        boolean bSOWUKontaktieren = sSOWUKontaktieren != null && sSOWUKontaktieren.equals("true");
        Boolean bDisplayDateAlways = this.sessionInfo.getUserInfo().getAlwaysDisplayProduktDate();
        boolean bHasRechtDisplayDate = this.sessionInfo.hasRechtAnzeigeProddatum();
        boolean bl = bDisplayDate = bHasRechtDisplayDate;
        if (bDisplayDate && (bDisplayDateAlways == null || !bDisplayDateAlways.booleanValue())) {
            bDisplayDate = false;
        }
        Boolean oIsTemporaer = (Boolean)transferable.getValue("is_temporaer");
        boolean bIsTemporaer = false;
        if (oIsTemporaer != null) {
            bIsTemporaer = oIsTemporaer;
        }
        String sLang = this.sessionInfo.getAktuelleSprache();
        transferable.setValue("sprache", sLang);
        if (!bIsTemporaer) {
            this.sessionInfo.resetFzgSuche();
        }
        boolean bComplete = (sIsVollstaendigeFI = (String)transferable.getValue("isvollstaendigefi")) != null && sIsVollstaendigeFI.equals("true");
        String sLackcode = (String)transferable.getValue("lackcode");
        String sAFCode = (String)transferable.getValue("afcode");
        String sFzgNr = (String)transferable.getValue("fgstnr");
        sFzgNr = sFzgNr.toUpperCase();
        this.logTime.debug("*** doFinalizeFgstnr *** >" + sFzgNr + "<");
        SimpleDateFormat sdf = new SimpleDateFormat("mm:ss:SSS");
        long time = -System.currentTimeMillis();
        FzgIdInfo oFzgIdInfo = null;
        FzgSucheInfo oFzgSucheInfo = null;
        if (!bIsTemporaer) {
            oFzgIdInfo = this.sessionInfo.getFzgIdInfo();
            oFzgSucheInfo = this.sessionInfo.newFzgSucheInfo();
            if (oFzgIdInfo == null) {
                this.log.info("No FzgIdInfo-Objekt found! Creating new one.");
                oFzgIdInfo = this.sessionInfo.newFzgIdInfo();
            }
            oFzgIdInfo.setSelectedVIN17Typ(sInfoTyp);
        } else {
            oFzgIdInfo = new FzgIdInfo();
            oFzgSucheInfo = new FzgSucheInfo();
        }
        boolean bFahrzeugFound = false;
        if (this.sessionInfo.doZentraleRecherche()) {
            JavaFzgIdInfo oJavaFzgIdInfo;
            this.logTime.debug("*** zentrale Fzg Identifikation ***");
            long timeZentraleFzgIdent = -System.currentTimeMillis();
            try {
                oJavaFzgIdInfo = new JavaFzgIdInfo(oFzgIdInfo, bComplete);
                transferable.setValue("fzgidinfo_java", oJavaFzgIdInfo);
                String sDisplayDate = bDisplayDate ? "true" : "false";
                transferable.setValue("ProdDatum", sDisplayDate);
                transferable.setValue("marken_berechtigungen", this.sessionInfo.getUserMarken());
                transferable.setValue("produkte_berechtigungen", this.sessionInfo.getUserProdukte());
                transferable.setValue("katalogumfang_berechtigung", this.sessionInfo.getUserKatUmfang());
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferable, Command.FINALIZE_FAHRZEUGIDENTIFIKATION_WITH_FGSTNR);
            }
            catch (CommunicationException ex) {
                transferable.setError(ex);
                return;
            }
            oJavaFzgIdInfo = (JavaFzgIdInfo)transferable.getValue("fzgidinfo_java");
            oFzgIdInfo = oJavaFzgIdInfo.constructFzgIdInfo();
            if (!bIsTemporaer) {
                this.sessionInfo.setFzgIdInfo(oFzgIdInfo);
            }
            oFzgSucheInfo = (FzgSucheInfo)transferable.getValue("fzgsucheinfo_app");
            if (!bIsTemporaer) {
                this.sessionInfo.setSucheInfo(oFzgSucheInfo);
            }
            if (transferable.getError() != null) {
                if (!(transferable.getError() instanceof NoDataFoundException)) return;
                bFahrzeugFound = false;
                if (oFzgSucheInfo == null && !bIsTemporaer) {
                    this.log.info("FzgSucheInfo null - creating new. Error:" + transferable.getError());
                    oFzgSucheInfo = new FzgSucheInfo();
                    this.sessionInfo.setSucheInfo(oFzgSucheInfo);
                }
                transferable.setError(null);
            } else {
                bFahrzeugFound = true;
            }
            this.logTime.debug("*** Dauer zentrale Fzg Identifikation: *** >" + sdf.format(timeZentraleFzgIdent += System.currentTimeMillis()) + "<");
        } else {
            try {
                this.logTime.debug("*** oFzgIdInfo.finalize - lokale Fzg Identifikation ***");
                long timeLokaleFzgIdent = -System.currentTimeMillis();
                String marketSpecSaledDesc = null;
                if (transferable.getValue("marketSalesSpecDesc") != null) {
                    marketSpecSaledDesc = (String)transferable.getValue("marketSalesSpecDesc");
                }
                oFzgIdInfo.setMsMarketspecSalesdesc(marketSpecSaledDesc);
                oFzgIdInfo.finalize(sFzgNr, this.sessionInfo.getUserMarken(), this.sessionInfo.getUserProdukte(), this.sessionInfo.getUserKatUmfang(), oFzgSucheInfo, sLang, bDisplayDate, sLackcode, sAFCode);
                bFahrzeugFound = true;
                if (oFzgIdInfo.getDuplicateVin7Map() != null && oFzgIdInfo.getDuplicateVin7Map().size() > 1) {
                    transferable.setValue("vin17daten", oFzgIdInfo.getDuplicateVin7Map());
                }
                if (oFzgIdInfo.isNoDatafoundForVin()) {
                    transferable.setError(new NoDataFoundException());
                    return;
                }
                this.logTime.debug("*** Dauer oFzgIdInfo.finalize - lokale Fzg Identifikation: *** >" + sdf.format(timeLokaleFzgIdent += System.currentTimeMillis()) + "<");
            }
            catch (SQLException e) {
                this.log.error("Calculation Modellspalte failed due to database error: " + e.getMessage(), e);
                transferable.setError(e);
                return;
            }
            catch (DatabaseBusyException e) {
                this.log.error("Calculation Modellspalte failed because database is busy!", e);
                transferable.setError(e);
                return;
            }
            catch (InvalidDataException e) {
                this.log.error("Inconsistency in the data for the FzgNr <" + sFzgNr + "> detected!", e);
                transferable.setError(e);
                return;
            }
            catch (NoBrandAuthorizationException e) {
                this.log.error("User-Settings (brand:" + this.sessionInfo.getUserMarken() + ", product: " + this.sessionInfo.getUserProdukte() + ", catalogue: " + this.sessionInfo.getUserKatUmfang() + ") does not match with vehicle <" + sFzgNr + "> data!", e);
                transferable.setError(e);
                return;
            }
            catch (NoDataFoundException e) {
                bFahrzeugFound = false;
            }
        }
        try {
            if (!bFahrzeugFound) {
                this.logTime.debug("*** getIGDOMTypetc - lokale Fzg Identifikation \u00fcber Typschl\u00fcssel von IGDOM ***");
                long timeLokaleFzgIdent21 = -System.currentTimeMillis();
                String[] aInfo = null;
                if (GlobalObjects.getInstance().isIsis()) {
                    aInfo = this.getIGDOMTypetc(transferable);
                } else {
                    TrfFahrzeugId webETKTransferable = new TrfFahrzeugId(null);
                    webETKTransferable.setValue("FAHRGESTELLNUMMER", sFzgNr);
                    webETKTransferable.setValue("language", sLang);
                    webETKTransferable.setValue("vinBasic", transferable.getValue("vinBasic"));
                    this.getIGDOMTypetcZentral(webETKTransferable);
                    aInfo = (String[])webETKTransferable.getValue("IGDOM_TYPE");
                    Exception ex = webETKTransferable.getError();
                    if (ex != null) {
                        transferable.setError(ex);
                    }
                }
                this.logTime.debug("*** Dauer getIGDOMTypetc - lokale Fzg Identifikation \u00fcber Typschl\u00fcssel von IGDOM: *** >" + sdf.format(timeLokaleFzgIdent21 += System.currentTimeMillis()) + "<");
                if (aInfo == null) {
                    transferable.setError(new NoDataFoundException());
                    return;
                }
                this.logTime.debug("*** oFzgIdInfo.finalize - lokale Fzg Identifikation \u00fcber Typschl\u00fcssel von IGDOM ***");
                long timeLokaleFzgIdent22 = -System.currentTimeMillis();
                String sTyp = aInfo[0];
                String sProdDatum = aInfo[1];
                String marketspecSalesDesc = null;
                if (aInfo.length > 2) {
                    marketspecSalesDesc = aInfo[2];
                }
                oFzgIdInfo.finalize(sFzgNr, sTyp, sProdDatum, this.sessionInfo.getUserMarken(), this.sessionInfo.getUserProdukte(), this.sessionInfo.getUserKatUmfang(), oFzgSucheInfo, sLang, bDisplayDate, sLackcode, sAFCode, marketspecSalesDesc);
                this.logTime.debug("*** Dauer oFzgIdInfo.finalize - lokale Fzg Identifikation \u00fcber Typschl\u00fcssel von IGDOM: *** >" + sdf.format(timeLokaleFzgIdent22 += System.currentTimeMillis()) + "<");
            }
        }
        catch (SQLException e) {
            this.log.error("Calculation Modellspalte failed due to database error: " + e.getMessage(), e);
            transferable.setError(e);
            return;
        }
        catch (DatabaseBusyException e) {
            this.log.error("Calculation Modellspalte failed because database is busy!", e);
            transferable.setError(e);
            return;
        }
        catch (InvalidDataException e) {
            this.log.error("Inconsistency in the data for the FzgNr <" + sFzgNr + "> detected!", e);
            transferable.setError(e);
            return;
        }
        catch (NoBrandAuthorizationException e) {
            this.log.error("User-Settings (brand:" + this.sessionInfo.getUserMarken() + ", product: " + this.sessionInfo.getUserProdukte() + ", catalogue: " + this.sessionInfo.getUserKatUmfang() + ") does not match with vehicle <" + sFzgNr + "> data!", e);
            transferable.setError(e);
            return;
        }
        catch (NoDataFoundException e) {
            transferable.setError(e);
            return;
        }
        oFzgSucheInfo.setIGDOM(bIGDOMKontaktieren);
        Collection cSchnittstellenBedingungen = null;
        String sGetriebe = new String();
        String sProduktionsdatum = new String();
        Ausstattung oAusstattung = new Ausstattung();
        if (bScoreAusstattungenVerwenden) {
            cSchnittstellenBedingungen = this.getScoreBedingungen(transferable);
        } else if (bIGDOMKontaktieren) {
            this.logTime.debug("*** getIGDOMBedingungen ***");
            long timeIGDOM = -System.currentTimeMillis();
            if (GlobalObjects.getInstance().isIsis()) {
                cSchnittstellenBedingungen = this.getIGDOMBedingungen(transferable);
                sGetriebe = (String)transferable.getValue("getriebe");
                sProduktionsdatum = (String)transferable.getValue("datum");
                oAusstattung = (Ausstattung)transferable.getValue("ausstattung");
                Exception ex = transferable.getError();
                if (ex != null) {
                    return;
                }
            } else {
                TrfFahrzeugId webETKTransferable = new TrfFahrzeugId(null);
                webETKTransferable.setValue("FAHRGESTELLNUMMER", sFzgNr);
                webETKTransferable.setValue("language", sLang);
                webETKTransferable.setValue("vinBasic", transferable.getValue("vinBasic"));
                this.getIGDOMBedingungenZentral(webETKTransferable);
                cSchnittstellenBedingungen = (Collection)webETKTransferable.getValue("bedingungen");
                sGetriebe = (String)webETKTransferable.getValue("getriebe");
                sProduktionsdatum = (String)webETKTransferable.getValue("datum");
                oAusstattung = (Ausstattung)webETKTransferable.getValue("ausstattung");
                Exception ex = webETKTransferable.getError();
                if (ex != null) {
                    transferable.setError(ex);
                    return;
                }
            }
            this.logTime.debug("*** Dauer getIGDOMBedingungen: *** >" + sdf.format(timeIGDOM += System.currentTimeMillis()) + "<");
            if (transferable.getValue("igdom_fehler") != null) {
                oFzgSucheInfo.setIGDOMFehler(true);
            }
        } else {
            cSchnittstellenBedingungen = new Vector<Bedingung>();
            String sLackart = null;
            if (sLackcode != null && !sLackcode.trim().equals("")) {
                if (sLackcode.length() == 4) {
                    sLackart = sLackcode.substring(0, 1);
                    sLackcode = sLackcode.substring(1);
                }
                Bedingung oLack = new Bedingung(sLackart, sLackcode, null);
                cSchnittstellenBedingungen.add((Bedingung)oLack);
            }
            if (sAFCode != null && !sAFCode.trim().equals("")) {
                Bedingung oAF = new Bedingung(sAFCode, false, null, "AF");
                cSchnittstellenBedingungen.add((Bedingung)oAF);
            }
        }
        oFzgSucheInfo.setAusstattung(oAusstattung);
        Collection<Bedingung> cDBBedingungen = new Vector<Bedingung>();
        if (this.sessionInfo.doZentraleRecherche()) {
            if (cSchnittstellenBedingungen != null && cSchnittstellenBedingungen.size() > 0) {
                try {
                    transferable.setValue("bedingungen", cSchnittstellenBedingungen);
                    transferable.setValue("produktart", oFzgIdInfo.getProduktart());
                    transferable.setValue("ProdDatum", oFzgIdInfo.getProduktionsdatum(false));
                    GlobalObjects.getInstance().getServiceExecutor().executeService(transferable, Command.APPEND_SCHNITTSTELLEN_BED_INFO);
                }
                catch (CommunicationException ex) {
                    transferable.setError(ex);
                    return;
                }
                cDBBedingungen = (Collection)transferable.getValue("bedingungen");
            }
        } else {
            cDBBedingungen = ServerGlobalObjects.getInstance().appendSchnittstellenBedingungenInfo(cSchnittstellenBedingungen, oFzgIdInfo.getProduktionsdatum(false), oFzgIdInfo.getProduktart(), sLang);
        }
        oFzgSucheInfo.getBedingungsMenge().appendSchnittstellenBedingungen(cDBBedingungen);
        oFzgSucheInfo.getBedingungsMenge_BTE().appendSchnittstellenBedingungen(cDBBedingungen);
        sAFCode = oFzgSucheInfo.getBedingungsMenge().getAFCodeSS();
        sLackcode = oFzgSucheInfo.getBedingungsMenge().getLackCodeSS();
        if (sGetriebe.length() > 0 && sGetriebe.charAt(0) != '\u0000') {
            oFzgIdInfo.setGetriebe(String.valueOf(sGetriebe.charAt(0)));
            oFzgSucheInfo.setGetriebe(String.valueOf(sGetriebe.charAt(0)));
        }
        if (sProduktionsdatum.length() != 0) {
            try {
                String sProdDatum = String.valueOf(sProduktionsdatum);
                Long ProdDatumTyp = new Long(sProdDatum);
                long lProdDatumTyp = ProdDatumTyp;
                long lEinsatzDatumTyp = oFzgIdInfo.getEinsatzTyp();
                if (lEinsatzDatumTyp > 0L) {
                    if (lProdDatumTyp < lEinsatzDatumTyp) {
                        sProdDatum = String.valueOf(lEinsatzDatumTyp);
                    }
                    this.log.info("***lProdDatumTyp: " + lProdDatumTyp + " lEinsatzDatumTyp: " + lEinsatzDatumTyp);
                }
                oFzgIdInfo.setProduktionsdatum(sProdDatum);
                oFzgSucheInfo.setProduktionsdatum(sProdDatum);
            }
            catch (Exception e) {
                this.log.error("Given Proddatum from IGDOM " + sProduktionsdatum + " can not be used!");
            }
        }
        Vector<Bedingung> cFgstnrSala = oFzgIdInfo.getFgstnrSalas();
        oFzgSucheInfo.getBedingungsMenge().appendSchnittstellenBedingungen(cFgstnrSala);
        cDBBedingungen.addAll(cFgstnrSala);
        if (oFzgSucheInfo.getBedingungsMenge().hatSicherheitrelevanteBedingungen()) {
            oFzgSucheInfo.isSicherheitsfahrzeug(true);
            oFzgIdInfo.isSicherheitsfahrzeug(true);
        }
        String sFzgIdString = oFzgIdInfo.toString(bDisplayDate, sLackcode, sAFCode);
        oFzgSucheInfo.setFzgIdString(sFzgIdString);
        if (bSOWUKontaktieren && bIGDOMKontaktieren && oAusstattung.isFzgMitSoWu()) {
            this.logTime.debug("*** getSOWUDaten ***");
            long timeSoWu = -System.currentTimeMillis();
            this.getSOWUDaten(transferable, oAusstattung);
            this.logTime.debug("*** Dauer getSOWUDaten: *** >" + sdf.format(timeSoWu += System.currentTimeMillis()) + "<");
        }
        JavaFzgSucheInfo oJavaFzgSucheInfo = new JavaFzgSucheInfo(oFzgSucheInfo);
        JavaFzgIdInfo oJavaFzgIdInfo = new JavaFzgIdInfo(oFzgIdInfo, bComplete);
        transferable.setValue("fzgsucheinfo_java", oJavaFzgSucheInfo);
        transferable.setValue("fzgsucheinfo_app", oFzgSucheInfo);
        transferable.setValue("fzgidinfo_java", oJavaFzgIdInfo);
        transferable.setValue("fzgidinfo_app", oFzgIdInfo);
        BedZusatzInfo oBedZusatzInfo = this.loadBedZusatzInfo(cDBBedingungen);
        if (oBedZusatzInfo != null) {
            transferable.setValue("bed_zusatz_info", oBedZusatzInfo);
        }
        Collection<Bedingung> cSonderausstattungen = oFzgSucheInfo.getBedingungsMenge().getSonderausstattungen();
        oAusstattung.setSonderausstattungen(cSonderausstattungen);
        Collection<Bedingung> cSerienausstattungen = oFzgSucheInfo.getBedingungsMenge().getSerienausstattungen();
        oAusstattung.setSerienausstattungen(cSerienausstattungen);
        Collection<Bedingung> cInformationen = oFzgSucheInfo.getBedingungsMenge().getInformationen();
        oAusstattung.setInformationen(cInformationen);
        this.logTime.debug("*** Dauer doFinalizeFgstnr: *** >" + sdf.format(time += System.currentTimeMillis()) + "<");
    }

    protected void doSynchronizeFI(TrfFahrzeugId transferable) {
        this.log.info("Performing Operation SYNCHRONIZE_FI!");
        FzgIdInfo oFzgIdInfoServer = (FzgIdInfo)transferable.getValue("fzgidinfo_app");
        FzgSucheInfo oFzgSucheInfoServer = (FzgSucheInfo)transferable.getValue("fzgsucheinfo_app");
        FzgSucheInfo oFzgSucheInfoAkt = this.sessionInfo.getFzgSucheInfo();
        oFzgSucheInfoServer.uebernehmenBedingungen(oFzgSucheInfoAkt);
        oFzgSucheInfoServer.uebernehmenBedingungen_BTE(oFzgSucheInfoAkt);
        oFzgSucheInfoServer.setIGDOM(oFzgSucheInfoAkt.isIGDOM());
        FzgIdInfo oFzgIdInfoAkt = this.sessionInfo.getFzgIdInfo();
        oFzgIdInfoAkt.setFahrgestellNr(oFzgIdInfoServer.getFahrgestellNr());
        this.sessionInfo.setSucheInfo(oFzgSucheInfoServer);
    }

    protected boolean ermittleObSowuZugriff() {
        String sCon = GlobalObjects.getInstance().getSowuConnection();
        if (sCon != null) {
            if (sCon.equals("0")) {
                return false;
            }
            if (sCon.equals("AUTO")) {
                try {
                    BmwNetz oBmwNetz = GlobalObjects.getInstance().getCentralServerSettings();
                    return !oBmwNetz.getNetz().equals("SGATE") && !oBmwNetz.getNetz().equals("EXTRANET");
                }
                catch (Exception ex) {
                    this.log.warn("can not get CentralServerSettings, not contacting SOWU");
                    return false;
                }
            }
            if (sCon.equals("1")) {
                return true;
            }
        }
        return true;
    }

    protected void getSOWUDaten(TrfFahrzeugId transferable, Ausstattung oAusstattung) {
        try {
            BmwNetz oBmwNetz = GlobalObjects.getInstance().getCentralServerSettings();
            if (oBmwNetz.getCentralServerUrl() != null) {
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferable, Command.GET_SOWU_DATEN);
                Collection cTexte = (Collection)transferable.getValue("text");
                Exception ex = transferable.getError();
                if (ex != null) {
                    this.log.warn("Error connecting to SOWU: ", ex);
                    this.sessionInfo.getFzgSucheInfo().setSOWUFehler(true);
                    transferable.setError(null);
                } else {
                    transferable.setValue("text", null);
                    oAusstattung.setIndividualFahrzeugdaten(cTexte);
                }
            }
        }
        catch (Exception ex) {
            this.sessionInfo.getFzgSucheInfo().setSOWUFehler(true);
            this.log.warn("Error connecting to SOWU: ", ex);
        }
    }

    protected void insertAtBeginToVector(ValueAndNameSupport oValueAndName, Vector<ValueAndNameSupport> vVector) {
        if (vVector.size() <= 1) {
            return;
        }
        String sFirstValue = vVector.firstElement().getValue();
        if (sFirstValue.equals("kA") || sFirstValue.equals("AlleWerte")) {
            return;
        }
        vVector.add(0, oValueAndName);
    }

    protected boolean reconstructDefaultWerte(FzgIdInfo fzgId) {
        fzgId.resetFahrgestellNr();
        fzgId.setDefaultMarke(this.sessionInfo.getUserInfo().getMarke());
        fzgId.setDefaultProduktart(this.sessionInfo.getUserInfo().getProduktart());
        fzgId.setDefaultKatUmfang(this.sessionInfo.getUserInfo().getKatalogumfang());
        fzgId.setDefaultLenkung(this.sessionInfo.getUserInfo().getLenkung());
        fzgId.setDefaultRegionen(this.sessionInfo.getUserInfo().getRegionen());
        return true;
    }

    protected Collection<Bedingung> getScoreBedingungen(TrfFahrzeugId transferableMap) {
        Vector<Bedingung> cBedignungen = new Vector<Bedingung>();
        ArrayList ausstattungen = (ArrayList)transferableMap.getValue("score_ausstattungsinfo");
        if (ausstattungen == null || ausstattungen.size() == 0) {
            return cBedignungen;
        }
        this.log.info("*******************************************************************");
        this.log.info("Score-Ausstattungsinfo");
        int nSize = ausstattungen.size();
        for (EtkScoreVerbauung ausstattung : ausstattungen) {
            if (ausstattung == null) continue;
            String sArt = ausstattung.getArt();
            String sCode = ausstattung.getCode();
            this.log.info("Art: " + sArt + " - Code: " + sCode);
            if (sArt != null && sCode != null) {
                if (sArt.equals("A")) {
                    if (sCode.length() != 2) {
                        this.log.error(sCode + " ist kein korrekter Ausstattungscode: es m\u00fcssen genau 2 Zeichen \u00fcbergeben werden");
                        continue;
                    }
                    Bedingung oA = new Bedingung(sCode, false, null, "A");
                    cBedignungen.add(oA);
                    continue;
                }
                if (sArt.equals("F")) {
                    if (sCode.length() != 2) {
                        this.log.error(sCode + " ist kein korrekter Farbscode: es m\u00fcssen genau 2 Zeichen \u00fcbergeben werden");
                        continue;
                    }
                    Bedingung oF = new Bedingung(sCode, false, null, "F");
                    cBedignungen.add(oF);
                    continue;
                }
                if (sArt.equals("L")) {
                    String sLackArt = null;
                    String sLackCode = null;
                    if (sCode.length() != 3 && sCode.length() != 4) {
                        this.log.error(sCode + " ist kein korrekter Lackcode: es m\u00fcssen entweder 3 oder 4 Zeichen \u00fcbergeben werden");
                        continue;
                    }
                    if (sCode.length() == 3) {
                        sLackCode = sCode;
                    } else {
                        sLackArt = sCode.substring(0, 1);
                        sLackCode = sCode.substring(1);
                    }
                    Bedingung oLack = new Bedingung(sLackArt, sLackCode, null);
                    cBedignungen.add(oLack);
                    continue;
                }
                if (sArt.equals("AF")) {
                    if (sCode.length() != 4) {
                        this.log.error(sCode + " ist kein korrekter AF-Code: es m\u00fcssen genau 4 Zeichen \u00fcbergeben werden");
                        continue;
                    }
                    boolean bIsPolstercode = Character.isDigit(sCode.charAt(0));
                    Bedingung oAF = new Bedingung(sCode, bIsPolstercode, null, "AF");
                    cBedignungen.add(oAF);
                    continue;
                }
                if (sArt.equals("AFL")) {
                    if (sCode.length() != 8) {
                        this.log.error(sCode + " ist kein korrekter AFL-Code: es m\u00fcssen genau 8 Zeichen \u00fcbergeben werden");
                        continue;
                    }
                    Bedingung oAFL = new Bedingung(sCode, false, null, "AFL");
                    cBedignungen.add(oAFL);
                    continue;
                }
                if (sArt.equals("S")) {
                    String sSalaArt = null;
                    String sSalapaPrimanummer = null;
                    String sSalaHZaehler = null;
                    if (sCode.length() != 3 && sCode.length() != 4 && sCode.length() != 5) {
                        this.log.error(sCode + " ist kein korrekter Salapa-Code: es m\u00fcssen 3 oder 4 oder 5 Zeichen \u00fcbergeben werden");
                        continue;
                    }
                    if (sCode.length() == 3) {
                        sSalapaPrimanummer = sCode;
                    } else if (sCode.length() == 4) {
                        sSalaArt = sCode.substring(0, 1);
                        sSalapaPrimanummer = sCode.substring(1);
                    } else {
                        sSalaArt = sCode.substring(0, 1);
                        sSalapaPrimanummer = sCode.substring(1, 4);
                        sSalaHZaehler = sCode.substring(4);
                    }
                    Bedingung oSalapa = new Bedingung(sSalaArt, sSalapaPrimanummer, sSalaHZaehler, null, "S_SONDER");
                    cBedignungen.add(oSalapa);
                    continue;
                }
                this.log.error(sArt + " ist unbekannte Bedingungsart: zul\u00e4ssige Werte: A, F, L, AF, AFL, S");
                continue;
            }
            this.log.error(sArt + " ist unbekannte Bedingungsart: zul\u00e4ssige Werte: A, F, L, AF, AFL, S");
        }
        this.log.info("Ende: Score-Ausstattungsinfo");
        this.log.info("*******************************************************************");
        return cBedignungen;
    }

    protected void getIGDOMBedingungenZentral(TrfFahrzeugId transferableMap) {
        this.log.debug("***TrfFahrzeugIdCommand.getIGDOMBedingungen(): Start");
        try {
            BmwNetz oBmwNetz = GlobalObjects.getInstance().getCentralServerSettings();
            if (oBmwNetz.getCentralServerUrl() != null) {
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferableMap, Command.GET_IGDOM_BEDINGUNGEN);
            }
        }
        catch (Exception ex) {
            this.log.warn("Error connecting to IGDOM: ", ex);
            this.sessionInfo.getFzgSucheInfo().setIGDOMFehler(true);
            transferableMap.setError(ex);
        }
        if (transferableMap.getValue("igdom_fehler") != null) {
            this.sessionInfo.getFzgSucheInfo().setIGDOMFehler(true);
        }
        this.log.debug("***TrfFahrzeugIdCommand.getIGDOMBedingungen(): Ende");
    }

    protected void getIGDOMTypetcZentral(TrfFahrzeugId transferableMap) {
        this.log.debug("***TrfFahrzeugIdCommand.getIGDOMTypetc(): Start");
        try {
            BmwNetz oBmwNetz = GlobalObjects.getInstance().getCentralServerSettings();
            if (oBmwNetz.getCentralServerUrl() != null) {
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferableMap, Command.GET_IGDOM_TYPETC);
            }
        }
        catch (Exception ex) {
            this.log.warn("Error connecting to IGDOM: ", ex);
            this.sessionInfo.getFzgSucheInfo().setIGDOMFehler(true);
            this.transferable.setError(ex);
        }
        this.log.debug("***TrfFahrzeugIdCommand.getIGDOMTypetc(): Ende");
    }

    protected Collection<Bedingung> getIGDOMBedingungen(TrfFahrzeugId transferableMap) {
        String sFahrgestellnummer;
        Ausstattung oAusstattung = new Ausstattung();
        Vector<Bedingung> cBedingungen = new Vector<Bedingung>();
        BmwNetz oBmwNetz = null;
        try {
            oBmwNetz = GlobalObjects.getInstance().getCIGDOMSettings();
        }
        catch (Exception ex) {
            this.log.debug("***TrfFahrzeugIdCommand.getIGDOMBedingungen(Verbindungsdaten holen): Exception " + ex.getMessage());
            transferableMap.setValue("igdom_fehler", "true");
            return cBedingungen;
        }
        String BASIC_URL = oBmwNetz.getIGDOMBasicsServerUrl();
        String OPTIONS_URL = oBmwNetz.getIGDOMOptionsServerUrl();
        this.log.debug("#### BASIC   URL: " + BASIC_URL);
        this.log.debug("#### OPTIONS URL: " + OPTIONS_URL);
        HashMap<String, String> serverParams = transferableMap.getServerParameter();
        String sAsapSessId = null;
        if (serverParams != null) {
            sAsapSessId = serverParams.get("PSESSID");
        }
        String sProxy = oBmwNetz.getProxyName();
        int nProxyPort = oBmwNetz.getProxyPort();
        String sUsername = oBmwNetz.getProxyUserName();
        String sPassword = oBmwNetz.getProxyPasswort();
        String sRealm = oBmwNetz.getProxyRealm();
        String sHost = "";
        String sDomain = oBmwNetz.getProxyNtDomain();
        String sNTHost = oBmwNetz.getProxyNtHost();
        ConnectionConfiguration domConfig = null;
        if (sProxy != null) {
            domConfig = new ConnectionConfiguration(sProxy, nProxyPort);
            if (sDomain != null) {
                domConfig.setProxyNTCredentials(sUsername, sPassword, sDomain, sNTHost, sHost);
            } else {
                domConfig.setProxyCredentials(sUsername, sPassword, sRealm, sHost);
            }
            this.log.info("Using configuration: " + domConfig.toString());
        }
        if ((sFahrgestellnummer = (String)transferableMap.getValue("fgstnr")) == null || sFahrgestellnummer.length() == 0) {
            transferableMap.setError(new InvalidDataException("keine Fahrgestellnummer angegeben!"));
            return cBedingungen;
        }
        this.log.debug("***TrfFahrzeugIdCommand.getIGDOMBedingungen(): BASICS holen f\u00fcr " + sFahrgestellnummer);
        VehicleBasicManager basicManager = new VehicleBasicManager("JavaServer");
        VehicleBasic vehicleBasic = null;
        try {
            if (domConfig != null) {
                basicManager.setHostConfig(domConfig);
            }
            vehicleBasic = basicManager.retrieveInfo(BASIC_URL, sFahrgestellnummer.toUpperCase(), sAsapSessId);
            this.log.debug("***TrfFahrzeugIdCommand.getIGDOMBedingungen(): BASICS retrieved");
        }
        catch (Exception ex) {
            this.log.debug("***TrfFahrzeugIdCommand.getIGDOMBedingungen(retrieve Basics): Exception " + ex.getMessage());
            transferableMap.setValue("igdom_fehler", "true");
            return cBedingungen;
        }
        if (vehicleBasic == null) {
            this.log.debug("***TrfFahrzeugIdCommand.getIGDOMBedingungen(): vehicleBasic == null");
            transferableMap.setValue("igdom_fehler", "true");
            return cBedingungen;
        }
        webetk.interfaces.dom.basic.DOMmessageType dmt = vehicleBasic.getMessage();
        if (dmt != null && dmt.getMsgClass() != null && dmt.getMsgClass().equalsIgnoreCase("error")) {
            this.log.debug("***TrfFahrzeugIdCommand.getIGDOMBedingungen(): vehicleBasic message class = " + dmt.getMsgClass() + " message code = " + dmt.getMsgCode() + " message text = " + dmt.getMsgText());
            transferableMap.setValue("igdom_fehler", "true");
            return cBedingungen;
        }
        webetk.interfaces.dom.basic.Vehicle vehicleDom = vehicleBasic.getVehicle();
        if (vehicleDom == null) {
            this.log.debug("***TrfFahrzeugIdCommand.getIGDOMBedingungen(): vehicleDom == null");
            transferableMap.setValue("igdom_fehler", "true");
            return cBedingungen;
        }
        String sFgstnrKomplett = vehicleDom.getVinLong();
        oAusstattung.setFgstnrKomplett(sFgstnrKomplett);
        VehicleType vehicleDomType = vehicleDom.getVehicleType();
        if (vehicleDomType == null) {
            this.log.debug("***TrfFahrzeugIdCommand.getIGDOMBedingungen(): vehicleDomType == null");
            transferableMap.setValue("igdom_fehler", "true");
            return cBedingungen;
        }
        String sTypCode = vehicleDomType.getModelCode();
        oAusstattung.setTypCode(sTypCode);
        String sModell = vehicleDomType.getModel();
        String sLand = vehicleDomType.getCountry();
        String sTyp = sModell;
        if (sLand != null) {
            sTyp = sTyp + " (" + sLand + ")";
        }
        oAusstattung.setTyp(sTyp);
        String sBaureihe = vehicleDomType.getSeriesDevt();
        String sBaureiheDiff = vehicleDomType.getSeriesDevtDiff();
        oAusstattung.setEBaureihe(sBaureihe + " (" + sBaureiheDiff + ")");
        sBaureihe = vehicleDomType.getSeries();
        oAusstattung.setBaureihe(sBaureihe);
        String sBauart = vehicleDomType.getBodyType();
        oAusstattung.setBauart(sBauart);
        String sLenkung = vehicleDomType.getSteering();
        oAusstattung.setLenkung(sLenkung);
        String sTueren = String.valueOf(vehicleDomType.getDoorCount());
        oAusstattung.setTueren(sTueren);
        String sMotor = vehicleDomType.getEngineType();
        oAusstattung.setMotor(sMotor);
        String sHubraum = vehicleDomType.getCubicCapacity().toString();
        oAusstattung.setHubraum(sHubraum);
        String sLeistung = vehicleDomType.getPower();
        oAusstattung.setLeistung(sLeistung);
        String sAntrieb = vehicleDomType.getPowerTransm();
        oAusstattung.setAntrieb(sAntrieb);
        String sGetriebe = vehicleDomType.getTransmissionType();
        oAusstattung.setGetriebe(sGetriebe);
        Equipment vehicleDomEquipment = vehicleDom.getEquipment();
        if (vehicleDomEquipment == null) {
            this.log.debug("***TrfFahrzeugIdCommand.getIGDOMBedingungen(): vehicleDomEquipment == null");
            transferableMap.setValue("igdom_fehler", "true");
            return cBedingungen;
        }
        oAusstattung.setFzgMitSoWu(!vehicleDomEquipment.getSpecialRequestCode().equals(" ") || !vehicleDomEquipment.getSABIcode().equals((Object)JaNeinCode.N));
        this.log.debug(" Vin: >" + sFahrgestellnummer + "< hat Sonderw\u00fcnsche (specialRequestCode oder SABIcode) >" + oAusstattung.isFzgMitSoWu() + "<");
        Colour vehicleDomEquipColour = vehicleDomEquipment.getColour();
        if (vehicleDomEquipColour == null) {
            this.log.debug("***TrfFahrzeugIdCommand.getIGDOMBedingungen(): vehicleDomEquipColour == null");
            transferableMap.setValue("igdom_fehler", "true");
            return cBedingungen;
        }
        String sFarbBenennung = vehicleDomEquipColour.getValue();
        String sFarbCode = vehicleDomEquipColour.getColourCode();
        oAusstattung.setFarbe(sFarbBenennung + " (" + sFarbCode + ")");
        Upholstery vehicleDomEquipUpholstery = vehicleDomEquipment.getUpholstery();
        if (vehicleDomEquipUpholstery == null) {
            this.log.debug("***TrfFahrzeugIdCommand.getIGDOMBedingungen(): vehicleDomEquipUpholstery == null");
            transferableMap.setValue("igdom_fehler", "true");
            return cBedingungen;
        }
        String sPolsterBenennung = vehicleDomEquipUpholstery.getValue();
        String sPolsterCode = vehicleDomEquipUpholstery.getUpholsteryCode();
        oAusstattung.setPolsterung(sPolsterBenennung + " (" + sPolsterCode + ")");
        String sProdDatum = "";
        if (vehicleDom.getPackingNotficationDate() != null && vehicleDom.getPackingNotficationDate().toString().length() != 0 && !vehicleDom.getPackingNotficationDate().toString().substring(0, 10).replaceAll("[^0-9]", "").equals("00010101")) {
            sProdDatum = vehicleDom.getPackingNotficationDate().toString();
            this.log.info("CKD-Fzg - Sollverpackungsdatum ist Produktionsdatum: " + sProdDatum);
        } else if (vehicleDom.getProdDate() != null && vehicleDom.getProdDate().toString().length() != 0) {
            sProdDatum = vehicleDom.getProdDate().toString();
            this.log.info("Produktionsdatum: " + sProdDatum);
        } else {
            this.log.info("kein Produktionsdatum vorhanden in IG DOM Basics");
        }
        if (sProdDatum.length() != 0) {
            sProdDatum = sProdDatum.substring(0, 10);
        }
        oAusstattung.setProdDatum(sProdDatum);
        String sLackArt = vehicleDomEquipColour.getColourTypeTAIS();
        String sLackCode = vehicleDomEquipColour.getColourCode();
        String sLackBenennungDMS = vehicleDomEquipColour.getValue();
        if (sLackCode != null && !sLackCode.trim().equals("")) {
            Bedingung oLack = new Bedingung(sLackArt, sLackCode, sLackBenennungDMS);
            cBedingungen.add(oLack);
            this.log.debug("***TrfFahrzeugIdCommand.getIGDOMBedingungen(): Lack = " + sLackArt + sLackCode + " " + sLackBenennungDMS);
        } else {
            this.log.warn("IGDOM: No Lack-Code given");
        }
        String sAFCode = vehicleDomEquipUpholstery.getUpholsteryCode();
        String sAFBenennungDMS = vehicleDomEquipUpholstery.getValue();
        String string = sAFCode = sAFCode == null ? "" : sAFCode.trim();
        if (!sAFCode.equals("") && !sAFCode.trim().equals("*")) {
            boolean bPolstercode = false;
            if (Character.isDigit(sAFCode.charAt(0))) {
                bPolstercode = true;
            }
            Bedingung oAF = new Bedingung(sAFCode, bPolstercode, sAFBenennungDMS, "AF");
            cBedingungen.add(oAF);
            this.log.debug("***TrfFahrzeugIdCommand.getIGDOMBedingungen(): AF = " + sAFCode + " " + sAFBenennungDMS);
        } else {
            this.log.warn("IGDOM: No AF-Code given");
        }
        if (sGetriebe.toUpperCase().equals("MECH")) {
            sGetriebe = "M";
        }
        if (sGetriebe.toUpperCase().equals("AUT")) {
            sGetriebe = "A";
        }
        String sHelp = sProdDatum;
        sProdDatum = "";
        if (sHelp != null && sHelp.length() == 10) {
            String sYear = sHelp.substring(0, 4);
            String sMonth = sHelp.substring(5, 7);
            String sDay = sHelp.substring(8, 10);
            sProdDatum = sYear + sMonth + sDay;
        }
        this.log.debug("***TrfFahrzeugIdCommand.getIGDOMBedingungen(): Produktionsdatum: " + sProdDatum);
        transferableMap.setValue("ausstattung", oAusstattung);
        transferableMap.setValue("getriebe", sGetriebe);
        transferableMap.setValue("datum", sProdDatum);
        VehicleOptionsManager optionsManager = new VehicleOptionsManager("JavaServer");
        String sLang = this.sessionInfo.getAktuelleSprache();
        String sLangIGDOM = "EN";
        if (sLang.equals("de") || sLang.equals("ru")) {
            sLangIGDOM = "DE";
        }
        this.log.debug("***TrfFahrzeugIdCommand.getIGDOMBedingungen(): OPTIONS holen f\u00fcr : " + sFahrgestellnummer + " und IG DOM Language : " + sLangIGDOM);
        if (domConfig != null) {
            optionsManager.setHostConfig(domConfig);
        }
        VehicleOptions vehicleOptions = optionsManager.retrieveInfo(OPTIONS_URL, sFahrgestellnummer, sLangIGDOM, sAsapSessId);
        this.log.debug("***TrfFahrzeugIdCommand.getIGDOMBedingungen(): OPTIONS retrieved");
        if (vehicleOptions == null) {
            this.log.debug("***TrfFahrzeugIdCommand.getIGDOMBedingungen(retrieve Options): vehicleOptions == null");
            transferableMap.setValue("igdom_fehler", "true");
            return cBedingungen;
        }
        Vehicle vehicleOptionsVehicle = vehicleOptions.getVehicle();
        if (vehicleOptionsVehicle == null) {
            this.log.debug("***TrfFahrzeugIdCommand.getIGDOMBedingungen(retrieve Options): vehicleOptionsVehicle == null");
            transferableMap.setValue("igdom_fehler", "true");
            return cBedingungen;
        }
        DOMmessageType dmtOpt = vehicleOptionsVehicle.getMessage();
        if (dmtOpt != null && dmtOpt.getMsgClass().equalsIgnoreCase("error")) {
            this.log.debug("***TrfFahrzeugIdCommand.getIGDOMBedingungen(): vehicleOptions message class = " + dmtOpt.getMsgClass() + " message code = " + dmtOpt.getMsgCode() + " message text = " + dmtOpt.getMsgText());
            transferableMap.setValue("igdom_fehler", "true");
            return cBedingungen;
        }
        List<Options> optList = vehicleOptionsVehicle.getOptions();
        for (int i = 0; i < optList.size(); ++i) {
            this.log.debug("***TrfFahrzeugIdCommand.getIGDOMBedingungen(retrieve Options): options[" + i + "]");
            Options aOptions = optList.get(i);
            String sOptionType = aOptions.getType();
            List<Option> opts = aOptions.getOption();
            for (int j = 0; j < opts.size(); ++j) {
                Option opt = opts.get(j);
                String sArt = opt.getCategory();
                String sPrimanummer = opt.getId();
                String sHZaehler = opt.getHistoryMark();
                String sSalapaBenennungDMS = opt.getDescription().getValue();
                if (sPrimanummer == null || sPrimanummer.trim().length() != 3) continue;
                if (!sPrimanummer.trim().equals("")) {
                    Bedingung oSalapa;
                    if (sOptionType.equalsIgnoreCase("series")) {
                        oSalapa = new Bedingung(sArt, sPrimanummer, sHZaehler, sSalapaBenennungDMS, "S_SERIE");
                        cBedingungen.add(oSalapa);
                    }
                    if (sOptionType.equalsIgnoreCase("order")) {
                        oSalapa = new Bedingung(sArt, sPrimanummer, sHZaehler, sSalapaBenennungDMS, "S_SONDER");
                        cBedingungen.add(oSalapa);
                    }
                    if (sOptionType.equalsIgnoreCase("info")) {
                        oSalapa = new Bedingung(sArt, sPrimanummer, sHZaehler, sSalapaBenennungDMS, "S_INFORMATION");
                        cBedingungen.add(oSalapa);
                    }
                    this.log.debug("***TrfFahrzeugIdCommand.getIGDOMBedingungen(): Sala = " + sArt + sPrimanummer + sHZaehler + " " + sSalapaBenennungDMS);
                    continue;
                }
                this.log.warn("IGDOM-SPEC: No SALAP-Code given");
            }
        }
        this.log.debug("***TrfFahrzeugIdCommand.getIGDOMBedingungen(): Ende");
        return cBedingungen;
    }

    protected String[] getIGDOMTypetc(TrfFahrzeugId transferableMap) {
        String sFahrgestellnummer;
        String[] aResult = new String[]{null, null};
        BmwNetz oBmwNetz = null;
        try {
            oBmwNetz = GlobalObjects.getInstance().getCIGDOMSettings();
        }
        catch (Exception ex) {
            this.log.debug("***TrfFahrzeugIdCommand.getIGDOMTypetc(Verbindungsdaten holen): Exception " + ex.getMessage());
            return null;
        }
        String BASIC_URL = oBmwNetz.getIGDOMBasicsServerUrl();
        HashMap<String, String> serverParams = transferableMap.getServerParameter();
        String sAsapSessId = null;
        if (serverParams != null) {
            sAsapSessId = serverParams.get("PSESSID");
        }
        String sProxy = oBmwNetz.getProxyName();
        int nProxyPort = oBmwNetz.getProxyPort();
        String sUsername = oBmwNetz.getProxyUserName();
        String sPassword = oBmwNetz.getProxyPasswort();
        String sRealm = oBmwNetz.getProxyRealm();
        String sHost = null;
        String sDomain = oBmwNetz.getProxyNtDomain();
        String sNTHost = oBmwNetz.getProxyNtHost();
        ConnectionConfiguration domConfig = null;
        if (sProxy != null) {
            domConfig = new ConnectionConfiguration(sProxy, nProxyPort);
            if (sDomain != null) {
                domConfig.setProxyNTCredentials(sUsername, sPassword, sDomain, sNTHost, sHost);
            } else {
                domConfig.setProxyCredentials(sUsername, sPassword, sRealm, sHost);
            }
            this.log.info("Using configuration: " + domConfig.toString());
        }
        if ((sFahrgestellnummer = (String)transferableMap.getValue("fgstnr")) == null || sFahrgestellnummer.length() == 0) {
            transferableMap.setError(new InvalidDataException("keine Fahrgestellnummer angegeben!"));
            return null;
        }
        this.log.debug("***TrfFahrzeugIdCommand.getIGDOMTypetc(): BASICS holen");
        VehicleBasicManager basicManager = new VehicleBasicManager("JavaServer");
        VehicleBasic vehicleBasic = null;
        try {
            if (domConfig != null) {
                basicManager.setHostConfig(domConfig);
            }
            vehicleBasic = basicManager.retrieveInfo(BASIC_URL, sFahrgestellnummer.toUpperCase(), sAsapSessId);
            this.log.debug("***TrfFahrzeugIdCommand.getIGDOMTypetc(): BASICS retrieved");
        }
        catch (Exception ex) {
            this.log.debug("***TrfFahrzeugIdCommand.getIGDOMTypetc(retrieve Basics): Exception " + ex.getMessage());
            return null;
        }
        if (vehicleBasic == null) {
            this.log.debug("***TrfFahrzeugIdCommand.getIGDOMTypetc(): vehicleBasic == null");
            return null;
        }
        webetk.interfaces.dom.basic.DOMmessageType dmt = vehicleBasic.getMessage();
        if (dmt != null && dmt.getMsgClass() != null && dmt.getMsgClass().equalsIgnoreCase("error")) {
            this.log.debug("***TrfFahrzeugIdCommand.getIGDOMTypetc(): vehicleBasic message class = " + dmt.getMsgClass() + " message code = " + dmt.getMsgCode() + " message text = " + dmt.getMsgText());
            return null;
        }
        webetk.interfaces.dom.basic.Vehicle vehicleDom = vehicleBasic.getVehicle();
        if (vehicleDom == null) {
            this.log.debug("***TrfFahrzeugIdCommand.getIGDOMTypetc(): vehicleDom == null");
            return null;
        }
        VehicleType vehicleDomType = vehicleDom.getVehicleType();
        if (vehicleDomType == null) {
            this.log.debug("***TrfFahrzeugIdCommand.getIGDOMTypetc(): vehicleDomType == null");
            return null;
        }
        aResult[0] = vehicleDomType.getModelCode();
        String sHelp = "";
        if (vehicleDom.getPackingNotficationDate() != null && vehicleDom.getPackingNotficationDate().toString().length() != 0 && !vehicleDom.getPackingNotficationDate().toString().substring(0, 10).replaceAll("[^0-9]", "").equals("00010101")) {
            sHelp = vehicleDom.getPackingNotficationDate().toString();
        } else if (vehicleDom.getProdDate() != null && vehicleDom.getProdDate().toString().length() != 0) {
            sHelp = vehicleDom.getProdDate().toString();
        }
        if (sHelp.length() != 0) {
            sHelp = sHelp.substring(0, 10);
        }
        String sProdDatum = "";
        if (sHelp != null && sHelp.length() == 10) {
            String sYear = sHelp.substring(0, 4);
            String sMonth = sHelp.substring(5, 7);
            String sDay = sHelp.substring(8, 10);
            sProdDatum = sYear + sMonth + sDay;
            if (sYear.equals("0001") && sMonth.equals("01") && sDay.equals("01")) {
                return null;
            }
        }
        aResult[1] = sProdDatum;
        this.log.debug("***TrfFahrzeugIdCommand.getIGDOMTypetc(): Ende");
        return aResult;
    }

    public BedZusatzInfo loadBedZusatzInfo(Collection<Bedingung> cBedingungen) {
        if (cBedingungen == null || cBedingungen.size() == 0) {
            return null;
        }
        String sISO = this.sessionInfo.getUserInfo().getSprache();
        String sRegISO = this.sessionInfo.getUserInfo().getSpracheRegion();
        if (this.sessionInfo.doZentraleRecherche()) {
            TrfFahrzeugId transferable = new TrfFahrzeugId(null);
            try {
                transferable.setValue("bedingungen", cBedingungen);
                transferable.setValue("iso", sISO);
                transferable.setValue("regiso", sRegISO);
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferable, Command.LOAD_BED_ZUSATZINFO);
            }
            catch (CommunicationException ex) {
                transferable.setError(ex);
                return null;
            }
            return (BedZusatzInfo)transferable.getValue("bed_zusatz_info");
        }
        BedZusatzInfo oBedZusatzInfo = new BedZusatzInfo();
        if (sRegISO == null) {
            sRegISO = "  ";
        }
        try {
            oBedZusatzInfo.load(cBedingungen, sISO, sRegISO);
        }
        catch (Exception ex) {
            this.transferable.setError(ex);
            return null;
        }
        return oBedZusatzInfo;
    }

    protected void loadZusatzInfoMarke(TrfFahrzeugId transferable) {
        ZusatzInfoMarke oZusatzInfoMarke = new ZusatzInfoMarke();
        String sMarke = (String)transferable.getValue("marke");
        String sISO = this.sessionInfo.getUserInfo().getSprache();
        String sRegISO = this.sessionInfo.getUserInfo().getSpracheRegion();
        if (this.sessionInfo.doZentraleRecherche()) {
            try {
                transferable.setValue("marke", sMarke);
                transferable.setValue("iso", sISO);
                transferable.setValue("regiso", sRegISO);
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferable, Command.LOAD_ZUSATZINFO_MARKE);
                oZusatzInfoMarke = (ZusatzInfoMarke)transferable.getValue("zusatz_info_marke");
            }
            catch (CommunicationException ex) {
                transferable.setError(ex);
                oZusatzInfoMarke = null;
            }
        } else {
            if (sRegISO == null) {
                sRegISO = "  ";
            }
            try {
                oZusatzInfoMarke.load(sMarke, sISO, sRegISO);
            }
            catch (Exception ex) {
                transferable.setError(ex);
                oZusatzInfoMarke = null;
            }
        }
        transferable.setValue("zusatz_info_marke", oZusatzInfoMarke);
    }

    public FzgIdInfo assembleFzgIdInfo(TrfFahrzeugId transferable, FzgIdInfo oFzgIdInfo) {
        if (oFzgIdInfo == null) {
            oFzgIdInfo = new FzgIdInfo();
        }
        String sMarke = (String)transferable.getValue("marke");
        String sPArt = (String)transferable.getValue("produktart");
        String sKatUmfang = (String)transferable.getValue("katalogumfang");
        String sBauart = (String)transferable.getValue("bauart");
        String sBaureihe = (String)transferable.getValue("baureihe");
        String sKarosse = (String)transferable.getValue("karosserie");
        String sModel = (String)transferable.getValue("modell");
        String sRegion = (String)transferable.getValue("region");
        if (sMarke == null) {
            Logger.getLogger(FzgIdInfo.class).error("Marke is not set!");
            return null;
        }
        if (sPArt == null) {
            Logger.getLogger(FzgIdInfo.class).error("Produktart is not set!");
            return null;
        }
        if (sKatUmfang == null) {
            Logger.getLogger(FzgIdInfo.class).error("Katalogumfang is not set!");
            return null;
        }
        if (sBauart == null) {
            if (sPArt.equals(Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung())) {
                Logger.getLogger(FzgIdInfo.class).error("Bauart is not set!");
                return null;
            }
            sBauart = "ohne";
        }
        if (sBaureihe == null) {
            Logger.getLogger(FzgIdInfo.class).error("Baureihe is not set!");
            return null;
        }
        if (sKarosse == null) {
            if (sPArt.equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung())) {
                Logger.getLogger(FzgIdInfo.class).error("Karosserie is not set!");
                return null;
            }
            sKarosse = "ohne";
        }
        if (sModel == null) {
            Logger.getLogger(FzgIdInfo.class).error("Modell is not set!");
            return null;
        }
        if (sRegion == null) {
            Logger.getLogger(FzgIdInfo.class).error("Katalogausf\u00fchrung/Region is not set!");
            return null;
        }
        oFzgIdInfo.setMarke(sMarke);
        oFzgIdInfo.setProduktart(sPArt);
        oFzgIdInfo.setKatalogumfang(sKatUmfang);
        oFzgIdInfo.setBauart(sBauart);
        oFzgIdInfo.setBaureihe(sBaureihe);
        oFzgIdInfo.setKarosserie(sKarosse);
        oFzgIdInfo.setModell(sModel);
        oFzgIdInfo.setRegion(sRegion);
        String sLenkung = (String)transferable.getValue("lenkung");
        if (sLenkung == null) {
            sLenkung = "kA";
        }
        oFzgIdInfo.setLenkung(sLenkung);
        String sGetriebe = (String)transferable.getValue("getriebe");
        if (sGetriebe == null) {
            sGetriebe = "kA";
        }
        oFzgIdInfo.setGetriebe(sGetriebe);
        String sBaujahr = (String)transferable.getValue("baujahr");
        if (sBaujahr == null) {
            sBaujahr = "kA";
        }
        oFzgIdInfo.setBaujahr(sBaujahr);
        String sZulMonat = (String)transferable.getValue("zulmonat");
        if (sZulMonat == null) {
            sZulMonat = "kA";
        }
        oFzgIdInfo.setZulMonat(sZulMonat);
        return oFzgIdInfo;
    }
}

