/*
 * Decompiled with CFR 0.152.
 */
package webetk.communication.command;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Set;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.InvalidDataException;
import webetk.app.BmwNetzeInfos;
import webetk.communication.CommunicationException;
import webetk.communication.command.AbstractTransferableCommand;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.Transferable;
import webetk.communication.transferables.TrfMisc;
import webetk.javaserver.app.GlobalObjects;

public class TrfMiscCommand
extends AbstractTransferableCommand {
    private static Logger log = Logger.getLogger(TrfMiscCommand.class);

    @Override
    public void setTransferable(Transferable trf) {
        if (!(trf instanceof TrfMisc)) {
            log.error("Given transferable must be TrfMisc, but it isn't!");
            throw new ClassCastException("TrfMisc excepted!");
        }
        super.setTransferable(trf);
    }

    @Override
    public void execute() throws InvalidDataException, DatabaseBusyException, SQLException {
        TrfMisc transferableMap = (TrfMisc)this.transferable;
        Command command = transferableMap.getCommand();
        log.debug("Executing command: " + command);
        if (Command.SETZE_FLAG_AUSWEISUNG_ELEMENTE.equals(command)) {
            this.setzeAusweisungElemente(transferableMap);
            return;
        }
        if (Command.HOLEN_FLAG_AUSWEISUNG_ELEMENTE.equals(command)) {
            this.holeAusweisungElemente(transferableMap);
            return;
        }
        if (Command.SENDE_MAIL_VIA_WEBETK_TRF.equals(command)) {
            this.sendenMailViaWebETK_Trf(transferableMap);
            return;
        }
        if (Command.LOAD_BMW_NETZ_INFOS.equals(command)) {
            this.loadBmwNetzInfos(transferableMap);
            return;
        }
        log.error("No valid command: " + command);
        throw new InvalidDataException("No valid command: " + command);
    }

    private void setzeAusweisungElemente(TrfMisc transferableMap) {
        try {
            String sFlagAusweisungElemente = (String)transferableMap.getValue("flagAusweisungElementeErmitteln");
            this.sessionInfo.setAusweisungenElementeAktiv(sFlagAusweisungElemente.equals("true"));
            log.info("*** Flag BTE Bedingungen Ausweisungen Elemente wird am Server gesetzt auf : " + this.sessionInfo.isAusweisungenElementeAktiv());
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void holeAusweisungElemente(TrfMisc transferableMap) {
        try {
            String sFlagAusweisungElemente = this.sessionInfo.isAusweisungenElementeAktiv() ? "true" : "false";
            transferableMap.setValue("flagAusweisungElementeErmitteln", sFlagAusweisungElemente);
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    protected void sendenMailViaWebETK_Trf(TrfMisc transferableMap) {
        log.debug("Entering sendenMailViaWebETK_Trf");
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(transferableMap, Command.SENDE_MAIL_VIA_WEBETK_TRF);
        }
        catch (CommunicationException ex) {
            transferableMap.setError(ex);
            return;
        }
        if (transferableMap.getError() != null) {
            return;
        }
        String sRetStatusCode = (String)transferableMap.getValue("return_mail_status");
        String sRetStatusMsg = (String)transferableMap.getValue("return_mail_msg");
        if (!sRetStatusCode.equals("0")) {
            CommunicationException comEx = new CommunicationException("e-Mail versand war nicht erfolgreich! Status Code : " + sRetStatusCode + " Status Message : " + sRetStatusMsg);
            log.error("Fehler bei der Kommunikation mit dem WebETK webservice rest mail -> " + comEx.getMessage(), comEx);
            transferableMap.setError(comEx);
        }
    }

    private String appendParameter(TrfMisc transferableMap, String sCentralServerUrl) {
        StringBuffer sReturnCentralServerUrl = new StringBuffer(sCentralServerUrl);
        HashMap<String, String> serverParams = transferableMap.getServerParameter();
        String sAsapSessId = null;
        if (serverParams != null && (sAsapSessId = serverParams.get("PSESSID")) != null && sAsapSessId.length() > 0) {
            boolean useQM = sCentralServerUrl.indexOf(63) == -1;
            Set<String> theKeys = serverParams.keySet();
            for (String key : theKeys) {
                String value = serverParams.get(key);
                log.debug("Rewriting Parameter <" + key.toString() + "> at server URL with value: " + value.toString());
                sReturnCentralServerUrl.append(useQM ? "?" : "&").append((Object)key).append("=").append((Object)value);
                useQM = false;
            }
        }
        return sReturnCentralServerUrl.toString();
    }

    private void loadBmwNetzInfos(TrfMisc transferableMap) {
        BmwNetzeInfos oBmwNetzInfos = new BmwNetzeInfos();
        try {
            oBmwNetzInfos.load();
            transferableMap.setValue("Bmw_Netz_Infos", oBmwNetzInfos);
        }
        catch (Exception ex) {
            transferableMap.setError(ex);
        }
    }
}

