/*
 * Decompiled with CFR 0.152.
 */
package webetk.communication.command;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.InvalidDataException;
import webetk.app.zub.marketing.MarketingInfo;
import webetk.app.zub.marketing.MarketingProdukt;
import webetk.app.zub.verwaltung.Fahrzeug;
import webetk.communication.command.AbstractTransferableCommand;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.Transferable;
import webetk.communication.transferables.TrfZubMarketing;
import webetk.db.zub.dbaccess.MarketingDbAccess;

public class TrfZubMarketingCommand
extends AbstractTransferableCommand {
    protected Logger log = Logger.getLogger(TrfZubMarketingCommand.class);

    @Override
    public void setTransferable(Transferable trf) {
        if (!(trf instanceof TrfZubMarketing)) {
            this.log.error("Given transferable must be TrfZubMarketing, but it isn't!");
            throw new ClassCastException("TrfZubMarketing excepted!");
        }
        super.setTransferable(trf);
    }

    @Override
    public void execute() throws InvalidDataException, DatabaseBusyException, SQLException {
        TrfZubMarketing transferableMap = (TrfZubMarketing)this.transferable;
        Command command = transferableMap.getCommand();
        this.log.debug("Executing command: " + command);
        if (Command.NO_OPERATION.equals(command)) {
            return;
        }
        if (Command.LOAD_MARKETINGINFO_PRODUKT.equals(command)) {
            this.ladeMarketingdaten(transferableMap);
            return;
        }
        if (Command.ERMITTLE_ZUSATZFZATTRIBUTE.equals(command)) {
            this.ermittleZusatzAttribute(transferableMap);
            return;
        }
        this.log.error("No valid command: " + command);
        throw new InvalidDataException("No valid command: " + command);
    }

    private void ermittleZusatzAttribute(TrfZubMarketing transferableMap) {
        MarketingProdukt produkt = (MarketingProdukt)transferableMap.getValue("marketingProdukt");
        if (produkt == null) {
            return;
        }
        Fahrzeug fahrzeug = (Fahrzeug)transferableMap.getValue("fahrzeug");
        if (fahrzeug.getModellspalte() == 0L) {
            return;
        }
        try {
            MarketingDbAccess.ermittleFzgEinschraenkungenMospId(produkt, fahrzeug);
            transferableMap.setValue("marketingProdukt", produkt);
            transferableMap.setValue("lenkungNoetig", new Boolean(produkt.isLenkungNoetig()));
            transferableMap.setValue("getriebeNoetig", new Boolean(produkt.isGetriebeNoetig()));
            transferableMap.setValue("datumNoetig", new Boolean(produkt.isDatumNoetig()));
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void ladeMarketingdaten(TrfZubMarketing transferableMap) {
        String produktArt = this.sessionInfo.getUserInfo().getProduktart();
        String marke = this.sessionInfo.getUserInfo().getMarke();
        String sprache = this.sessionInfo.getUserInfo().getSprache();
        String regIso = this.sessionInfo.getUserInfo().getSpracheRegion();
        Vector<String> regionen = this.sessionInfo.getUserInfo().getRegionen();
        String katalogUmfang = this.sessionInfo.getUserInfo().getKatalogumfang();
        int marktId = this.sessionInfo.getUserInfo().getMarktId();
        if (marktId == -1) {
            marktId = 0;
        }
        try {
            StringBuffer buf = new StringBuffer();
            Iterator it = regionen.iterator();
            while (it.hasNext()) {
                if (buf.length() == 0) {
                    buf.append("'").append(it.next()).append("'");
                    continue;
                }
                buf.append(",'").append(it.next()).append("'");
            }
            String bteNr = transferableMap.getValue("btnummer").toString();
            String bildposNr = null;
            if (transferableMap.getHashMap().containsKey("bildPosNr") && transferableMap.getValue("bildPosNr") != null) {
                bildposNr = transferableMap.getValue("bildPosNr").toString();
            }
            String isLifestyle = transferableMap.getValue("isLifestyle").toString();
            MarketingProdukt produkt = MarketingDbAccess.ermittleMarketingProduktZuBte(bteNr, bildposNr, produktArt, marke, katalogUmfang, buf.toString(), marktId, sprache, regIso, isLifestyle.equals("J"));
            produkt.setBteKommentar(new MarketingInfo(bteNr, bildposNr, produktArt, sprache));
            transferableMap.setValue("marketingProdukt", produkt);
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }
}

