/*
 * Decompiled with CFR 0.152.
 */
package webetk.communication.command;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import webetk.DMSException;
import webetk.DatabaseBusyException;
import webetk.InvalidDataException;
import webetk.app.fzgsuche.FzgSucheInfo;
import webetk.app.konfiguration.Filiale;
import webetk.app.konfiguration.Konfiguration;
import webetk.app.settings.WertebereichRegionen;
import webetk.app.zub.common.PreisZeile;
import webetk.app.zub.common.Preise;
import webetk.app.zub.verwaltung.AufwandsKonfiguration;
import webetk.communication.command.AbstractTransferableCommand;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.Transferable;
import webetk.communication.transferables.TrfZubMisc;
import webetk.db.zub.dbaccess.PreiseDbAccess;
import webetk.db.zub.dbaccess.SucheDbAccess;
import webetk.db.zub.dbaccess.VerwaltungDbAccess;
import webetk.javaserver.framework.SessionInfo;
import webetk.mrkprd.Marken;
import webetk.xmlapi.XmlCommunicationException;
import webetk.xmlapi.XmlParseException;
import webetk.xmlapi.dms.commands.XmlDmsTeilelistenInfo;

public class TrfZubMiscCommand
extends AbstractTransferableCommand {
    private static Logger log = Logger.getLogger(TrfZubMiscCommand.class);

    @Override
    public void setTransferable(Transferable trf) {
        if (!(trf instanceof TrfZubMisc)) {
            log.error("Given transferable must be TrfZubMisc, but it isn't!");
            throw new ClassCastException("TrfZubMisc excepted!");
        }
        super.setTransferable(trf);
    }

    @Override
    public void execute() throws InvalidDataException, DatabaseBusyException, SQLException {
        TrfZubMisc transferableMap = (TrfZubMisc)this.transferable;
        Command command = transferableMap.getCommand();
        log.debug("Executing command: " + command);
        if (Command.SETZE_MARKE.equals(command)) {
            this.setzeMarke(transferableMap);
            return;
        }
        if (Command.ANPASSEN_SESSIONINFO_IPAC.equals(command)) {
            this.setzeSessionInfoWerteFuerIpac(transferableMap);
            return;
        }
        log.error("No valid command: " + command);
        throw new InvalidDataException("No valid command: " + command);
    }

    private void setzeSessionInfoWerteFuerIpac(TrfZubMisc transferableMap) {
        this.sessionInfo.getUserInfo().setSuchraum("L");
        if (this.sessionInfo.getUserInfo().getSprache() == null) {
            String firmaId = this.sessionInfo.getUserInfo().getFirmaID();
            String filialId = this.sessionInfo.getUserInfo().getFilialeID();
            Filiale oFiliale = new Filiale(filialId, firmaId);
            try {
                oFiliale.load();
                String sprache = oFiliale.getISO();
                this.sessionInfo.getUserInfo().setSprache(sprache);
                String spracheRegion = oFiliale.getRegISO();
                this.sessionInfo.getUserInfo().setSpracheRegion(spracheRegion);
            }
            catch (Exception ex) {
                log.error("New User, getting filiale: ", ex);
                transferableMap.setError(ex);
            }
        }
        if (this.sessionInfo.getUserInfo().getRegionen().isEmpty()) {
            WertebereichRegionen wbRegionen = new WertebereichRegionen();
            try {
                wbRegionen.load();
            }
            catch (Exception ex) {
                log.error("New User, getting all regions: ", ex);
                transferableMap.setError(ex);
            }
            Iterator<String> iterator = wbRegionen.iteratorRegionen();
            while (iterator.hasNext()) {
                this.sessionInfo.getUserInfo().getSettings().addRegion(iterator.next());
            }
        }
        if (this.sessionInfo.getUserInfo().getKatalogumfang() == null || this.sessionInfo.getUserInfo().getKatalogumfang().length() < 1) {
            this.sessionInfo.getUserInfo().setKatalogumfang("VT");
        }
        if (this.sessionInfo.getUserInfo().getLenkung() == null || this.sessionInfo.getUserInfo().getLenkung().length() < 1) {
            this.sessionInfo.getUserInfo().setLenkung("kA");
        }
    }

    private void setzeMarke(TrfZubMisc transferableMap) {
        try {
            String marke = (String)transferableMap.getValue("marke");
            String produktArt = (String)transferableMap.getValue("produktart");
            this.sessionInfo.getUserInfo().setMarke(marke);
            this.sessionInfo.getUserInfo().setProduktart(produktArt);
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    public static Preise ladePreiseAusPriceFile(String bteNr, String bteTyp, String kundenNr, FzgSucheInfo fahrzeug, ArrayList<?> hinzugefuegteTeile, SessionInfo sessionInfo) throws DatabaseBusyException, SQLException {
        String firmaId = sessionInfo.getUserInfo().getFirmaID();
        String filialId = sessionInfo.getUserInfo().getFilialeID();
        String iso = sessionInfo.getUserInfo().getSprache();
        String regIso = sessionInfo.getUserInfo().getSpracheRegion();
        String marke = sessionInfo.getUserInfo().getMarke();
        String produktArt = sessionInfo.getUserInfo().getProduktart();
        int marktId = sessionInfo.getUserInfo().getMarktId();
        if (marktId < 0) {
            marktId = SucheDbAccess.ermittleDefaultMarktId(iso, regIso);
        }
        AufwandsKonfiguration aufwaende = VerwaltungDbAccess.ladeAWKonfiguration(firmaId, filialId, marke, produktArt, marktId, iso, regIso);
        Preise preise = PreiseDbAccess.ladeTeileUndPreiseZuBte(firmaId, bteNr, bteTyp, aufwaende, fahrzeug, hinzugefuegteTeile, marktId, produktArt);
        TrfZubMiscCommand.ladeMwStSaetzeZuCodes(preise, sessionInfo);
        int marktID = sessionInfo.getUserInfo().getMarktId();
        boolean mitSteuer = TrfZubMiscCommand.ladePreiseMitSteuer(marktID);
        preise.setAbPreiseMitSteuer(mitSteuer);
        return preise;
    }

    public static Preise ladePreiseVonDMS(Preise preise, String kundenNr, SessionInfo sessionInfo) throws DatabaseBusyException, SQLException, DMSException, XmlParseException, XmlCommunicationException {
        if (sessionInfo.getDMSVerwenden()) {
            int nKundenNr = 0;
            if (kundenNr != null && kundenNr.length() > 0) {
                nKundenNr = Integer.parseInt(kundenNr);
            }
            TrfZubMiscCommand.holePreiseVomDMS(preise.getPreisZeilen(), nKundenNr, sessionInfo);
        }
        int marktID = sessionInfo.getUserInfo().getMarktId();
        boolean mitSteuer = TrfZubMiscCommand.ladePreiseMitSteuer(marktID);
        preise.setAbPreiseMitSteuer(mitSteuer);
        return preise;
    }

    private static void ladeMwStSaetzeZuCodes(Preise preise, SessionInfo sessionInfo) throws SQLException, DatabaseBusyException {
        String firmaId = sessionInfo.getUserInfo().getFirmaID();
        String filialeId = sessionInfo.getUserInfo().getFilialeID();
        Konfiguration konfig = new Konfiguration(firmaId, filialeId);
        konfig.loadKonfiguration();
        preise.setzeMwStSaetzeZuCodes(konfig);
    }

    private static boolean ladePreiseMitSteuer(int marktID) {
        try {
            boolean anzeigeMwst = VerwaltungDbAccess.isAnzeigeInklMwSt(marktID);
            return anzeigeMwst;
        }
        catch (Exception ex) {
            log.error("AdminToolDbAccess.isAnzeigeInklMwSt", ex);
            return true;
        }
    }

    private static void holePreiseVomDMS(List<PreisZeile> zeilen, int kundenNr, SessionInfo sessionInfo) throws XmlParseException, XmlCommunicationException, DMSException {
        Vector<String> aFehlerhafteTeilenummern = new Vector<String>();
        Vector<Integer> aFehlerhaftePos = new Vector<Integer>();
        Vector<Integer> aTeilRetCodes = new Vector<Integer>();
        if (zeilen == null || zeilen.isEmpty()) {
            return;
        }
        String sNutzerId = sessionInfo.getUserInfo().getID();
        String sFirma = sessionInfo.getUserInfo().getFirmaID();
        String sFiliale = sessionInfo.getUserInfo().getFilialeID();
        String sMarke = sessionInfo.getUserInfo().getMarke();
        String auftragsNr = "";
        Vector<String> teileNummern = new Vector<String>();
        for (PreisZeile zeile : zeilen) {
            teileNummern.add(zeile.getTeileNr());
        }
        String sDMSMarke = Marken.getInstance().getMarkeEigenschaft("marke.berechtigung", sMarke, "marke.DMSSchnittstelle", null);
        XmlDmsTeilelistenInfo xmlReq = new XmlDmsTeilelistenInfo();
        xmlReq.setInputParameters(sNutzerId, sFirma, sFiliale, auftragsNr, kundenNr, sDMSMarke, teileNummern);
        xmlReq.requestService();
        int nStatus = xmlReq.getErgebnisCode();
        if (nStatus != 0) {
            throw new DMSException(Integer.toString(nStatus));
        }
        Iterator<PreisZeile> iter = zeilen.iterator();
        for (int ii = 0; ii < xmlReq.getTeileCount() && iter.hasNext(); ++ii) {
            PreisZeile zeile = iter.next();
            nStatus = xmlReq.getErgebnisCode(ii);
            if (nStatus != 0) {
                aFehlerhaftePos.add(new Integer(ii + 1));
                aFehlerhafteTeilenummern.add(zeile.getSachNr());
                aTeilRetCodes.add(new Integer(nStatus));
                continue;
            }
            double dPreis = xmlReq.getHaendlerpreis(ii);
            if (dPreis == 0.0) {
                zeile.setPreis(null);
            } else {
                zeile.setPreis(new Double(dPreis));
            }
            String sRabatt = xmlReq.getRabatt(ii);
            zeile.setRabatt(sRabatt);
            Double dMwst = xmlReq.getMwst(ii);
            if (dMwst != null) {
                zeile.setMwSt(dMwst);
            } else {
                zeile.setMwSt(0.0);
            }
            Double dAtSt = xmlReq.getSondersteuer(ii);
            if (dAtSt != null) {
                zeile.setAtSt(dAtSt);
            } else {
                zeile.setAtSt(0.0);
            }
            Double dLagerbestand = xmlReq.getLagerbestand(ii);
            if (dLagerbestand != null) {
                zeile.setLagerbestand(dLagerbestand);
                continue;
            }
            zeile.setLagerbestand(0.0);
        }
        if (!aFehlerhafteTeilenummern.isEmpty()) {
            throw new DMSException(aFehlerhaftePos, aFehlerhafteTeilenummern, aTeilRetCodes);
        }
    }
}

