/*
 * Decompiled with CFR 0.152.
 */
package webetk.communication.transferables;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Observer;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import webetk.communication.transferables.Transferable;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class TrfBinary
extends Transferable {
    protected byte[] data;

    public TrfBinary(Observer objObserver) {
        super(objObserver);
    }

    TrfBinary() {
    }

    public void fromStream(ByteArrayOutputStream stream) {
        byte[] theData = stream.toByteArray();
        this.data = new byte[theData.length];
        System.arraycopy(theData, 0, this.data, 0, theData.length);
    }

    public ByteArrayInputStream getAsStream() {
        if (this.data == null) {
            return null;
        }
        return new ByteArrayInputStream(this.data);
    }

    public void storeByteArray(byte[] newData) {
        this.data = newData;
    }

    public void fromByteArray(byte[] newData) {
        if (newData == null) {
            return;
        }
        this.data = new byte[newData.length];
        System.arraycopy(newData, 0, this.data, 0, newData.length);
    }

    public byte[] toByteArray() {
        return this.data == null ? null : this.data;
    }

    public byte[] cloneData() {
        if (this.data == null) {
            return null;
        }
        byte[] newData = new byte[this.data.length];
        System.arraycopy(this.data, 0, newData, 0, this.data.length);
        return newData;
    }

    @Override
    public void copyData(Transferable trf) throws ClassCastException {
        super.copyData(trf);
        TrfBinary trfBin = (TrfBinary)trf;
        this.storeByteArray(trfBin.toByteArray());
    }

    public int length() {
        return this.data == null ? -1 : this.data.length;
    }
}

