/*
 * Decompiled with CFR 0.152.
 */
package webetk.db;

import org.apache.log4j.Logger;

public class ClassLoaderUtil {
    private static final Logger log = Logger.getLogger(ClassLoaderUtil.class);
    private String mDBEnvironment;
    private String mPackageAndClassPrefix;

    public ClassLoaderUtil(String pDBEnvironment, String pPackageAndClassPrefix) {
        this.mDBEnvironment = pDBEnvironment;
        this.mPackageAndClassPrefix = pPackageAndClassPrefix;
    }

    public <T> T createInstance(Class<T> pClass) {
        try {
            String classname = this.mPackageAndClassPrefix + this.mDBEnvironment + '$' + pClass.getSimpleName();
            if (log.isDebugEnabled()) {
                log.debug("instantiating query class " + classname);
            }
            Class<?> resClass = Class.forName(classname);
            return (T)resClass.newInstance();
        }
        catch (Exception e) {
            log.error("caught exception!", e);
            return null;
        }
    }
}

