/*
 * Decompiled with CFR 0.152.
 */
package webetk.db;

import java.util.Locale;
import webetk.db.SQLStatements;

public final class SQLStatementsOracle
extends SQLStatements {

    public static final class ETKTexte
    extends SQLStatements.ETKTexte {
        @Override
        public final String RETRIEVE_ETKTEXTE() {
            return "select bedetkt_elemid ElemId,      bedetkt_hg HG,      bedetkt_fg FG,      bedetkt_produktart Produktart,      bedetkt_kommid KommId  from w_bed_etktext  order by Produktart, HG, FG";
        }

        @Override
        public final String RETRIEVE_ETKTEXTE_KOMMENTARE() {
            return "select DISTINCT bedetkt_kommid KommId,               ben_text Text,              komm_pos KommPos from w_bed_etktext, w_komm, w_ben_gk  where komm_id = bedetkt_kommid    and ben_textcode = komm_textcode    and ben_iso = ?    and ben_regiso = ?  order by KommId, KommPos";
        }
    }

    public static final class PerformanceLog
    extends SQLStatements.PerformanceLog {
        @Override
        public final String GET_NEXT_REQUESTID_SEQ_VAL() {
            return " select help_requestid_seq.nextval from DUAL";
        }

        @Override
        public final String LOAD_LOG_PERFORMANCE_FLAG() {
            return "SELECT log_performance log_perf FROM w_help_properties";
        }

        @Override
        public final String WRITE_PERFORMANCE_LOG() {
            return "INSERT INTO w_log_performance (request_id, request_date, time_ms, time_delta, funktion, sessionid, app) values (&REQUESTID&, SYSDATE, &TIMEMS&, &TIMEDELTA&, '&FUNKTION&', &SESSIONID&, &APP&)";
        }
    }

    public static final class MailOptions
    extends SQLStatements.MailOptions {
        @Override
        public final String LOAD_ABSENDER_UND_EMPFAENGER() {
            return "SELECT usermo_krit_art Kriterium, usermo_krit_wert Wert FROM w_user_mailoptions@etk_nutzer WHERE  usermo_firma_id = ? AND  usermo_user_id = ? AND (usermo_krit_art = 'E-Mail-Adresse Empfaenger' OR usermo_krit_art = 'E-Mail-Adresse Absender' OR usermo_krit_art = 'Name Absender') ";
        }

        @Override
        public final String INSERT_ABSENDER() {
            return "INSERT INTO w_user_mailoptions@etk_nutzer (usermo_firma_id, usermo_user_id, usermo_krit_art, usermo_krit_wert) TABLE ( ( ?, ?, 'E-Mail-Adresse Absender', ? ), ( ?, ?, 'Name Absender', ? ) ) ";
        }

        @Override
        public final String DELETE_ABSENDER() {
            return "DELETE FROM w_user_mailoptions@etk_nutzer WHERE  usermo_firma_id = ? AND  usermo_user_id = ? AND (usermo_krit_art = 'Name Absender' OR usermo_krit_art = 'E-Mail-Adresse Absender') ";
        }

        @Override
        public final String INSERT_EMPFAENGER() {
            return "INSERT INTO w_user_mailoptions@etk_nutzer (usermo_firma_id, usermo_user_id, usermo_krit_art, usermo_krit_wert) VALUES ( ?, ?, 'E-Mail-Adresse Empfaenger', ? ) ";
        }

        @Override
        public final String DELETE_EMPAENGER() {
            return "DELETE FROM w_user_mailoptions@etk_nutzer WHERE  usermo_firma_id = ? AND  usermo_user_id = ? AND  usermo_krit_art = 'E-Mail-Adresse Empfaenger' ";
        }
    }

    public static final class TabellenKonfiguration
    extends SQLStatements.TabellenKonfiguration {
        @Override
        public final String LOAD_KONFIG() {
            return "SELECT usertk_column_index Spalte,  usertk_column_name Name FROM w_user_tabellenkonfig@etk_nutzer WHERE  usertk_firma_id = ? AND  usertk_user_id = ? AND  usertk_table_name = ? AND  usertk_zusatz = ? ORDER BY usertk_column_index ";
        }

        @Override
        public final String INSERT_SPALTE() {
            return "INSERT INTO w_user_tabellenkonfig@etk_nutzer (usertk_firma_id, usertk_user_id, usertk_table_name, usertk_zusatz, usertk_column_name, usertk_column_index ) VALUES ( ?, ?, ?, ?, ?, ? )";
        }

        @Override
        public final String DELETE_KONFIG() {
            return "DELETE FROM w_user_tabellenkonfig@etk_nutzer WHERE  usertk_firma_id = ? AND  usertk_user_id = ? AND  usertk_table_name = ? AND  usertk_zusatz = ? ";
        }
    }

    public static final class LoginInfo
    extends SQLStatements.LoginInfo {
        @Override
        public final String LOAD_SINGLE_USER_LOGIN_INFO() {
            return "SELECT\tuserlog_eingeloggt Eingeloggt, \t\t\t\tuserlog_lastlogin LastLogin, \t\t\t\tuserlog_anzahl_logins AnzahlLogins FROM \tw_user_log@etk_nutzer WHERE\tuserlog_firma_id = ? AND\t\tuserlog_user_id = ? ";
        }

        @Override
        public final String INSERT_NEW_LOGIN_INFO() {
            return "INSERT INTO w_user_log@etk_nutzer ( \t\t\t\tuserlog_firma_id, \t\t\t\tuserlog_user_id, \t\t\t\tuserlog_eingeloggt, \t\t\t\tuserlog_lastlogin, \t\t\t\tuserlog_anzahl_logins ) VALUES ( ?, ?, 'J', ?, 1 ) ";
        }

        @Override
        public final String UPDATE_LOGIN_INFO() {
            return "UPDATE w_user_log@etk_nutzer SET    userlog_eingeloggt = 'J', \t\t\t\tuserlog_lastlogin = ?, \t\t\t\tuserlog_anzahl_logins = userlog_anzahl_logins + 1 WHERE\tuserlog_firma_id = ? AND    userlog_user_id = ? ";
        }

        @Override
        public final String UPDATE_LOGIN_INFO_LOGOUT() {
            return "UPDATE w_user_log@etk_nutzer SET    userlog_eingeloggt = 'N' WHERE\tuserlog_firma_id = ? AND    userlog_user_id = ? ";
        }

        @Override
        public final String GET_LOGGEDIN_USERS() {
            return "SELECT userlog_user_id UserId,        user_name UserName, \t      userlog_lastlogin LastLogin, \t      userlog_anzahl_logins AnzahlLogins,       user_default_filiale_id DefaultFiliale FROM   w_user_log@etk_nutzer, w_user@etk_nutzer WHERE  user_firma_id = userlog_firma_id   AND  user_id = userlog_user_id   AND  user_id NOT IN (&IGNORE_USER&)   AND  userlog_firma_id = ?   AND \tuserlog_eingeloggt = 'J' ORDER BY UserId ";
        }

        @Override
        public final String GET_INACTIVE_USERS() {
            return "SELECT user_id UserId,        user_name UserName, \t\t\t\tuserlog_lastlogin LastLogin, \t\t\t\tuserlog_anzahl_logins AnzahlLogins,        user_default_filiale_id DefaultFiliale FROM \tw_user_log@etk_nutzer \t\t\t\tRIGHT OUTER JOIN w_user@etk_nutzer \t\t\t\tON (user_firma_id = userlog_firma_id \t\t\t\t\tAND user_id = userlog_user_id) WHERE  user_firma_id = ?   AND  user_id NOT IN (&IGNORE_USER&)   AND  (userlog_lastlogin IS NULL    OR   userlog_lastlogin < ?) ORDER BY UserId ";
        }
    }

    public static final class Admintool
    extends SQLStatements.Admintool {
        protected static final PriceField[] PRICE_FIELD = new PriceField[]{new PriceField("&preise_sachnr&", true), new PriceField("&preise_evpreis&", false), new PriceField("&preise_nachbelastung&", false), new PriceField("&preise_rabattschluessel&", true), new PriceField("&preise_preisaenderung&", true), new PriceField("&preise_preis_kz&", true), new PriceField("&preise_sonderpreis&", false), new PriceField("&preise_sonderpreis_kz&", true), new PriceField("&preise_mwst&", false), new PriceField("&preise_mwst_code&", true), new PriceField("&preise_zolltarifnr&", true), new PriceField("&preise_nettopreis&", false)};

        @Override
        public final String LOAD_FIRMEN() {
            return "select firma_id Id from w_firma order by firma_bezeichnung";
        }

        @Override
        public final String DELETE_PRICES() {
            return "delete from w_preise";
        }

        @Override
        public final String DELETE_PRICES_BY_FIRMA() {
            return "delete from w_preise where preise_firma = '&FIRMA&'";
        }

        @Override
        public final String ERMITTLE_NUTZERTABELLEN() {
            return "SELECT tname tabelle FROM systable WHERE tname NOT LIKE 'sys%' AND tname NOT LIKE '%id_seq%'";
        }

        @Override
        public final String ERMITTLE_NUTZERSEQUENZEN() {
            return "SELECT tname sequenz FROM systable WHERE tname NOT LIKE 'sys%' AND tname LIKE '%id_seq%'";
        }

        @Override
        public final String DROP_SEQUENCE() {
            return "drop sequence &SEQUENCE&";
        }

        @Override
        public final String DROP_TABLE() {
            return "drop table &TABLE&";
        }

        @Override
        public final String GET_COUNT_FIRMA_PREISE() {
            return "select count(preise_firma) cnt from w_preise where preise_firma = '&FIRMA&'";
        }

        @Override
        public final String GET_DISTINCT_FIRMA_PREISE() {
            return "select distinct preise_firma FirmaId from w_preise";
        }

        @Override
        public final String LOCK_TABLE() {
            return "lock &TABLE& &MODE&";
        }

        @Override
        public final String UNLOCK_TABLE() {
            return "unlock &TABLE&";
        }

        @Override
        public final String INSERT_PRICES() {
            return "INSERT INTO w_preise (preise_firma,preise_sachnr,preise_evpreis,preise_nachbelastung,preise_rabattschluessel,preise_preisaenderung,preise_preis_kz,preise_sonderpreis,preise_sonderpreis_kz,preise_mwst,preise_mwst_code,preise_zolltarifnr,preise_nettopreis) VALUES (&preise_firma&,&preise_sachnr&,&preise_evpreis&,&preise_nachbelastung&,&preise_rabattschluessel&,&preise_preisaenderung&,&preise_preis_kz&,&preise_sonderpreis&,&preise_sonderpreis_kz&,&preise_mwst&,&preise_mwst_code&,&preise_zolltarifnr&,&preise_nettopreis&)";
        }

        @Override
        public String PRICE_FIELD_getName(int pInt) {
            return Admintool.PRICE_FIELD[pInt].name;
        }

        @Override
        public boolean PRICE_FIELD_getIsQuoted(int pInt) {
            return Admintool.PRICE_FIELD[pInt].isQuoted;
        }

        @Override
        public final String UPDATE_PRICES() {
            return "UPDATE w_preise SET preise_preis_kz = &preise_preis_kz&,preise_evpreis = &preise_evpreis&,preise_nachbelastung = &preise_nachbelastung&,preise_rabattschluessel = &preise_rabattschluessel&,preise_preisaenderung = &preise_preisaenderung&,preise_sonderpreis = &preise_sonderpreis&,preise_sonderpreis_kz = &preise_sonderpreis_kz&,preise_mwst = &preise_mwst&,preise_mwst_code = &preise_mwst_code&,preise_zolltarifnr = &preise_zolltarifnr&,preise_nettopreis = &preise_nettopreis& WHERE preise_firma = &preise_firma& and preise_sachnr = &preise_sachnr&";
        }

        @Override
        public final String LOAD_SPRACHEN() {
            return "select ben_iso ISO, ben_regiso RegISO, ben_text Benennung from w_ben_gk@etk_publ, w_publben@etk_publ where publben_art = 'S' and ben_textcode = publben_textcode and ben_iso = substr(publben_bezeichnung, 1, 2)  and ben_regiso = substr(publben_bezeichnung, 3, 2)";
        }

        @Override
        public final String LOAD_DBVERSIONSINFO() {
            return "select verwaltung_info Info, verwaltung_wert Wert from w_verwaltung";
        }

        protected static class PriceField {
            protected String name;
            protected boolean isQuoted;

            protected PriceField(String theName, boolean quote) {
                this.name = theName;
                this.isQuoted = quote;
            }
        }
    }

    public static final class Infotool
    extends SQLStatements.Infotool {
        @Override
        public final String INSERT_USER_TIPP() {
            return "insert into w_user_tipps            (usert_firma_id, usert_id, usert_tipp_id) values (?, ?, ?)";
        }

        @Override
        public final String DELETE_USER_TIPP() {
            return "delete from w_user_tipps where usert_firma_id = ?   and usert_id = ?   and usert_tipp_id = ?";
        }

        @Override
        public final String LOAD_TIPPS_TRICKS() {
            return "select tipp_id Id, tipp_filename Filename, tipp_art Art, DECODE(usert_tipp_id, usert_tipp_id, 'J', 'N') Gelesen  from w_tipp     left join w_user_tipps on (usert_firma_id = '&FIRMAID&'  and usert_id ='&USERID&' and usert_tipp_id = tipp_id) where tipp_wichtig = '&WICHTIG&' order by tipp_pos";
        }

        @Override
        public final String COUNT_TIPPS_TRICKS() {
            return "select Count(*) Anzahl from w_tipp@etk_nutzer";
        }

        @Override
        public final String COUNT_TICKER() {
            return "nur Transbase";
        }
    }

    public static final class News
    extends SQLStatements.News {
        @Override
        public final String INSERT_NEWSTEXT() {
            return "insert into w_news_text (NEWST_MARKE_TPS, NEWST_ISO, NEWST_REGISO, NEWST_TEXT, NEWST_AKTUELL, NEWST_STANDARD) values ('&MARKE&','&ISO&','&REGISO&','&TEXT&','&AKTUELL&','&STANDARD&')";
        }

        @Override
        public final String UPDATE_NEWSTEXT() {
            return "update w_news_text set NEWST_TEXT = '&TEXT&' where NEWST_MARKE_TPS = '&MARKE&' and NEWST_ISO = '&ISO&' and NEWST_REGISO = '&REGISO&' and NEWST_STANDARD = '&STANDARD&'";
        }

        @Override
        public final String LOAD_NEWSTEXTE() {
            return "select NEWST_TEXT Text, NEWST_AKTUELL IsAktiviert, NEWST_STANDARD IsStandard from w_news_text where NEWST_MARKE_TPS = ? and NEWST_ISO = ? and NEWST_REGISO = ? order by NEWST_MARKE_TPS, NEWST_ISO, NEWST_REGISO, NEWST_STANDARD";
        }

        @Override
        public final String LOAD_NEWSTEXTE_MARKEN() {
            return "select distinct NEWST_MARKE_TPS Marke  from w_news_text ";
        }

        @Override
        public final String DELETE_NEWSTEXT() {
            return "delete from w_news_text where NEWST_MARKE_TPS = '&MARKE&' and NEWST_ISO = '&ISO&' and NEWST_REGISO = '&REGISO&' and NEWST_TEXT = '&TEXT&'";
        }

        @Override
        public final String UPDATE_NEWSTEXT_AKTIVIERUNG() {
            return "update w_news_text set NEWST_AKTUELL = '&AKTUELL&' where NEWST_MARKE_TPS = '&MARKE&' and NEWST_ISO = '&ISO&' and NEWST_REGISO = '&REGISO&' and NEWST_TEXT = '&TEXT&'";
        }

        @Override
        public final String DELETE_IMAGE() {
            return "delete from w_news_grafik where newsg_marke_tps = '&MARKE&'";
        }

        @Override
        public final String INSERT_IMAGE() {
            return "insert into w_news_grafik values ( '&MARKE&', EMPTY_BLOB() )";
        }

        @Override
        public final String LOAD_IMAGE() {
            return "select newsg_grafik Grafik from w_news_grafik where newsg_marke_tps = ?";
        }

        @Override
        public final String LOAD_IMAGE_MARKEN() {
            return "select newsg_marke_tps Marke  from w_news_grafik ";
        }

        @Override
        public final String UPDATE_IMAGE() {
            return "select newsg_grafik from w_news_grafik where newsg_marke_tps = '&MARKE&' for update";
        }
    }

    public static final class Firmenkonfiguration
    extends SQLStatements.Firmenkonfiguration {
        @Override
        public final String RETRIEVE_FIRMEN() {
            return "select firma_id Id, firma_bezeichnung Bezeichnung from w_firma order by Bezeichnung";
        }

        @Override
        public final String RETRIEVE_FILIALEN() {
            return "select filiale_id Id, filiale_bezeichnung Bezeichnung from w_filiale where filiale_firma_id = ? order by Bezeichnung";
        }

        @Override
        public final String RETRIEVE_COUNT_FILIALEN_IN_FIRMA() {
            return "select Count(*) countFiliale from w_filiale@etk_nutzer where filiale_firma_id = ?";
        }

        @Override
        public final String RETRIEVE_INFO_FILIALE() {
            return "select firma_id FirmaId,  firma_bezeichnung FirmaBezeichnung,  filiale_bezeichnung FilialeId,  filiale_bezeichnung FilialeBezeichnung,  filiale_iso SpracheISO,  filiale_regiso SpracheRegISO from w_firma@etk_nutzer, w_filiale@etk_nutzer where filiale_firma_id = ? and filiale_id = ? and firma_id = filiale_firma_id";
        }

        @Override
        public final String RETRIEVE_EXIST_USER() {
            return "select count(user_id) ANZ from w_user where user_firma_id = ? and user_id = ? and user_passwort = ?";
        }

        @Override
        public final String RETRIEVE_DMS_VERWENDEN() {
            return "select konfig_hs_verwenden DMSVerwenden from w_konfig where konfig_firma_id = ? and konfig_filiale_id = ?";
        }

        @Override
        public final String LOAD_KONFIGURATION() {
            return "select konfig_hd_firma Firma, konfig_hd_zusatz Zusatz, konfig_hd_strasse Strasse, konfig_hd_plz Plz, konfig_hd_ort Ort, konfig_hd_telefon Telefon, konfig_hdnr_pkw Pkw, konfig_hdnr_motorrad Motorrad, konfig_mwst_niedrig MwstNiedrig, konfig_mwst_hoch MwstHoch, konfig_mwst_altteile MwstAltteile, konfig_mwst_3 Mwst3, konfig_mwst_4 Mwst4, konfig_rechnungnr RechnungsNr, konfig_mailserver Mailserver, konfig_barverkaufnr BarverkaufsNr, konfig_auftragnr AuftragsNr, konfig_kundennr KundenNr, konfig_hs_verwenden Verwenden, konfig_abwicklung Abwicklung, konfig_bestandfiliale Bestandfiliale, konfig_datenabgleich Datenabgleich from w_konfig where konfig_firma_id = '&FIRMA&' and konfig_filiale_id = '&FILIALE&'";
        }

        @Override
        public final String DELETE_KONFIGURATION() {
            return "delete from w_konfig where konfig_firma_id = '&FIRMA&' and konfig_filiale_id = '&FILIALE&'";
        }

        @Override
        public final String DELETE_ZUB_KONFIGURATION() {
            return "delete from w_zub_konfig@etk_nutzer where konfigz_firma_id = '&FIRMA&' and konfigz_filiale_id = '&FILIALE&'";
        }

        @Override
        public final String INSERT_KONFIGURATION() {
            return "insert into w_konfig (konfig_firma_id, konfig_filiale_id, konfig_hd_firma, konfig_hd_zusatz, konfig_hd_strasse, konfig_hd_plz, konfig_hd_ort, konfig_hd_telefon, konfig_hdnr_pkw, konfig_hdnr_motorrad, konfig_mwst_niedrig, konfig_mwst_hoch, konfig_mwst_altteile, konfig_mwst_3, konfig_mwst_4, konfig_rechnungnr, konfig_mailserver, konfig_barverkaufnr, konfig_auftragnr, konfig_kundennr, konfig_hs_verwenden, konfig_abwicklung, konfig_bestandfiliale, konfig_datenabgleich) values ('&FIRMA&', '&FILIALE&', &FIRMENNAME&, &ZUSATZ&, &STRASSE&, &PLZ&, &ORT&, &TELEFON&, &PKW&, &MOTOTRRAD&, &MWST_NIEDRIG&, &MWST_HOCH&, &MWST_ALTTEILE&, &MWST_3&, &MWST_4&, &RECHNUNGNR&, &MAILSERVER&, &BARVERKAUFNR&, &AUFTRAGSNR&, &KUNDENNR&, '&HS_VERWENDEN&',&ABWICKLUNG&, &BESTAND_FILIALE&, &DATENABGLEICH&)";
        }

        @Override
        public final String UPDATE_KONFIGURATION() {
            return "update w_konfig@etk_nutzer set konfig_hd_firma = &FIRMENNAME&, konfig_hd_zusatz = &ZUSATZ&, konfig_hd_strasse = &STRASSE&, konfig_hd_plz = &PLZ&, konfig_hd_ort = &ORT&, konfig_hd_telefon = &TELEFON&, konfig_hdnr_pkw = &PKW&, konfig_hdnr_motorrad = &MOTOTRRAD&, konfig_mwst_niedrig = &MWST_NIEDRIG&, konfig_mwst_hoch = &MWST_HOCH&, konfig_mwst_altteile = &MWST_ALTTEILE&, konfig_mwst_3 = &MWST_3&, konfig_mwst_4 = &MWST_4&, konfig_rechnungnr = &RECHNUNGNR&, konfig_mailserver = &MAILSERVER&, konfig_barverkaufnr = &BARVERKAUFNR&, konfig_auftragnr = &AUFTRAGSNR&, konfig_kundennr = &KUNDENNR&, konfig_hs_verwenden = '&HS_VERWENDEN&', konfig_abwicklung = &ABWICKLUNG&, konfig_bestandfiliale = &BESTAND_FILIALE&, konfig_datenabgleich = &DATENABGLEICH& where konfig_firma_id = '&FIRMA&' and konfig_filiale_id = '&FILIALE&'";
        }

        @Override
        public final String SELECT_RECHNUNGSNUMMER_FOR_UPDATE() {
            return "select konfig_rechnungnr RechnungsNr from w_konfig where konfig_firma_id = ? and konfig_filiale_id = ? for update";
        }

        @Override
        public final String UPDATE_RECHNUNGSNUMMER() {
            return "update w_konfig set konfig_rechnungnr = &RECHNUNGSNR& where konfig_firma_id = '&FIRMA&' and konfig_filiale_id = '&FILIALE&'";
        }

        @Override
        public final String UPDATE_FIRMENBEZEICHNUNG() {
            return "update w_firma set firma_bezeichnung = '&BEZEICHNUNG&' where firma_id = '&ID&'";
        }

        @Override
        public final String INSERT_FILIALE() {
            return "insert into w_filiale (filiale_firma_id, filiale_id, filiale_bezeichnung, filiale_iso, filiale_regiso) values ('&FIRMAID&', '&FILIALID&', '&FILIALE&', '&ISO&', '&REGISO&')";
        }

        @Override
        public final String DELETE_FILIALE() {
            return "delete from w_filiale where filiale_firma_id = '&FIRMAID&' and filiale_id = '&FILIALID&'";
        }

        @Override
        public final String UPDATE_FILIALE() {
            return "update w_filiale set filiale_bezeichnung = '&FILIALE&', filiale_iso = '&ISO&', filiale_regiso = '&REGISO&' where filiale_firma_id = '&FIRMAID&' and filiale_id = '&FILIALID&'";
        }

        @Override
        public final String RETRIEVE_FILIALEN_SPRACHEN() {
            return "select filiale_id Id, filiale_bezeichnung Bezeichnung, filiale_iso Iso, filiale_regiso RegIso from w_filiale where filiale_firma_id = ? order by filiale_id";
        }

        @Override
        public final String RETRIEVE_ANZAHL_NUTZER() {
            return "SELECT count(user_id) NutzerAnzahl FROM   w_user@etk_nutzer WHERE  user_firma_id = ?   AND  user_id NOT IN (&IN&)   AND (UPPER(user_id) LIKE UPPER(?)    OR  UPPER(user_name) LIKE UPPER(?)) ";
        }

        @Override
        public final String RETRIEVE_MATCHING_NUTZER() {
            return "SELECT user_id NutzerId,        user_name NutzerName FROM   w_user@etk_nutzer WHERE  user_firma_id = ?   AND  user_id NOT IN (&IN&)   AND (UPPER(user_id) LIKE UPPER(?)    OR  UPPER(user_name) LIKE UPPER(?)) ORDER BY user_name ";
        }

        @Override
        public final String RETRIEVE_NUTZER() {
            return "select user_id NutzerId, user_passwort Passwort, user_default_filiale_id DefaultFiliale, user_name NutzerName from w_user where user_firma_id = ? order by user_id";
        }

        @Override
        public final String RETRIEVE_SINGLE_NUTZER() {
            return "select user_passwort Passwort, user_default_filiale_id DefaultFiliale, user_name NutzerName from w_user where user_firma_id = ? and user_id = ?";
        }

        @Override
        public final String RETRIEVE_BERECHTIGUNEN() {
            return "select firmab_art Art, firmab_wert Wert from w_firma_berechtigungen where firmab_firma_id = ?";
        }

        @Override
        public final String RETRIEVE_SPRACHEN() {
            return "select publben_bezeichnung Code, ben_text Benennung from w_ben_gk, w_publben where publben_art = ? and ben_textcode = publben_textcode and ben_iso = ? and ben_regiso = ?";
        }

        @Override
        public final String RETRIEVE_FUNKTIONSRECHTE() {
            return "select publben_bezeichnung Bezeichnung, ben_text Text from w_ben_gk, w_publben where publben_art = ? and ben_textcode = publben_textcode and ben_iso = ? and ben_regiso = ? order by ben_text";
        }

        @Override
        public final String RETRIEVE_NUTZER_FUNKTIONSRECHTE() {
            return "select publben_bezeichnung Bezeichnung, ben_text Text from w_ben_gk, w_publben, w_user_funktionsrechte  where userf_firma_id = ? and userf_id = ? and publben_art = ? and publben_bezeichnung = userf_recht_id  and ben_textcode = publben.publben_textcode  and ben_iso = ? and ben_regiso = ? order by userf_recht_id";
        }

        @Override
        public final String RETRIEVE_NUTZER_BERECHTIGUNGEN() {
            return "select userb_art Art, userb_wert Wert from w_user_berechtigungen where userb_id = ? and userb_firma_id = ?";
        }

        @Override
        public final String DELETE_NUTZER_BERECHTIGUNGEN() {
            return "delete from w_user_berechtigungen where userb_id = '&ID&'";
        }

        @Override
        public final String DELETE_NUTZER_FUNKTIONSRECHTE() {
            return "delete from w_user_funktionsrechte where userf_id = '&ID&'";
        }

        @Override
        public final String DELETE_NUTZER_EINSTELLUNGEN() {
            return "delete from w_user_einstellungen where user_id = '&ID&'";
        }

        @Override
        public final String DELETE_ZUB_NUTZER() {
            return "delete from w_zub_user@etk_nutzer where userz_id = '&ID&' and userz_firma_id = '&FIRMA&'";
        }

        @Override
        public final String DELETE_NUTZER_EINSTELLUNGEN_REGION() {
            return "delete from w_user_einstellungen_region where user_id = '&ID&'";
        }

        @Override
        public final String DELETE_NUTZER() {
            return "delete from w_user where user_id = '&ID&'";
        }

        @Override
        public final String DELETE_NUTZER_TEILELISTEPOS() {
            return "delete from w_teilelistepos where teilelistepos_user_id = '&ID&'";
        }

        @Override
        public final String DELETE_NUTZER_TEILELISTE() {
            return "delete from w_teileliste where teileliste_user_id = '&ID&'";
        }

        @Override
        public final String DELETE_NUTZER_TEILELISTE_SENDEINFO() {
            return "delete from w_teileliste_sendeinfo where teilelistesi_user_id = '&ID&'";
        }

        @Override
        public final String DELETE_NUTZER_TEILEINFO() {
            return "delete from w_teileinfo where teileinfo_user_id = '&ID&'";
        }

        @Override
        public final String RETRIEVE_EXIST_USER_ID() {
            return "select count(user_id) Cnt from w_user where user_firma_id = ? and user_id = ?";
        }

        @Override
        public final String STORE_NUTZER() {
            return "insert into w_user (user_firma_id, user_id, user_name, user_passwort, user_default_filiale_id ) values('&FIRMAID&', '&USERID&', '&USERNAME&', '&PASSWORD&', '&FILIALE&')";
        }

        @Override
        public final String STORE_NUTZER_BERECHTIGUNGEN() {
            return "insert into w_user_berechtigungen (userb_firma_id, userb_id, userb_art, userb_wert ) values ('&FIRMAID&', '&USERID&', '&ART&', '&WERT&')";
        }

        @Override
        public final String STORE_NUTZER_FUNKTIONSRECHTE() {
            return "insert into w_user_funktionsrechte (userf_firma_id, userf_id, userf_recht_id) values ('&FIRMAID&', '&USERID&', '&RECHT&')";
        }

        @Override
        public final String UPDATE_NUTZER() {
            return "UPDATE w_user@etk_nutzer SET    user_name = ?,        user_passwort = ?,        user_default_filiale_id = ?,        user_bearbeiternummer = ? WHERE  user_firma_id = ? AND    user_id = ? ";
        }

        @Override
        public final String MOVE_TEILELISTEN() {
            return "update w_teileliste set teileliste_filiale_id = '&FILIALID_NEU&' where teileliste_firma_id = '&FIRMAID&' and teileliste_filiale_id = '&FILIALID_ALT&' and teileliste_user_id = '&USERID&' and teileliste_id in (select teileliste_id from w_teileliste where teileliste_auftragsnr is null and teileliste_firma_id = '&FIRMAID&' and teileliste_filiale_id = '&FILIALID_ALT&' and teileliste_user_id = '&USERID&')";
        }

        @Override
        public final String MOVE_TEILELISTENPOS() {
            return "update w_teilelistepos set teilelistepos_filiale_id = '&FILIALID_NEU&' where teilelistepos_firma_id = '&FIRMAID&' and teilelistepos_filiale_id = '&FILIALID_ALT&' and teilelistepos_user_id = '&USERID&' and teilelistepos_teileliste_id in (select teileliste_id from w_teileliste where teileliste_auftragsnr is null and teileliste_firma_id = '&FIRMAID&' and teileliste_filiale_id = '&FILIALID_ALT&' and teileliste_user_id = '&USERID&')";
        }

        @Override
        public final String MOVE_TEILELISTENSI() {
            return "update w_teileliste_sendeinfo set teilelistesi_filiale_id = '&FILIALID_NEU&' where teilelistesi_firma_id = '&FIRMAID&' and teilelistesi_filiale_id = '&FILIALID_ALT&' and teilelistesi_user_id = '&USERID&' and teilelistesi_teileliste_id in (select teileliste_id from w_teileliste where teileliste_auftragsnr is null and teileliste_firma_id = '&FIRMAID&' and teileliste_filiale_id = '&FILIALID_ALT&' and teileliste_user_id = '&USERID&')";
        }

        @Override
        public final String RETRIEVE_USERINFO() {
            return "select user_passwort Passwort, user_default_filiale_id DefaultFiliale, filiale_bezeichnung FilialBezeichnung, filiale_iso Iso, filiale_regiso RegIso from w_user, w_filiale where user_firma_id = ? and user_id = ? and user_default_filiale_id = filiale_id";
        }

        @Override
        public final String UPDATE_DEFAULT_FILIALE() {
            return "update w_user set user_default_filiale_id='&FILIALID&' where user_firma_id='&FIRMAID&' and user_id='&USERID&'";
        }

        @Override
        public final String RETRIEVE_EINEFIRMAFILIALENUTZER() {
            return "select firma_id, filiale_id, user_id from w_firma, w_filiale, w_user where user_firma_id (+) = firma_id and filiale_firma_id (+) = firma_id";
        }

        @Override
        public final String RETRIEVE_USER_BY_DEFAULT_FILIALE() {
            return "select user_id Id, user_name Name from w_user where user_default_filiale_id= ?";
        }

        @Override
        public final String RETRIEVE_BESTELLLISTE_POSITIONEN() {
            return "select * from w_bestelllistepos where bestelllistepos_firma_id= ? and bestelllistepos_filiale_id=?";
        }

        @Override
        public final String RETRIEVE_TEILELISTE_POSITIONEN() {
            return "select * from w_teilelistepos where teilelistepos_firma_id=? and teilelistepos_filiale_id=?";
        }

        @Override
        public final String DELETE_ALL_AUFTRAEGE() {
            return " delete from w_auftrag where auftrag_firma_id='&FIRMAID&' and auftrag_filiale_id='&FILIALID&'";
        }

        @Override
        public final String DELETE_ALL_TEILELISTEN() {
            return " delete from w_teileliste where teileliste_firma_id='&FIRMAID&' and teileliste_filiale_id='&FILIALID&'";
        }

        @Override
        public final String DELETE_ALL_TEILELISTEN_POSITIONEN() {
            return " delete from w_teilelistepos where teilelistepos_firma_id='&FIRMAID&' and teilelistepos_filiale_id='&FILIALID&'";
        }

        @Override
        public final String DELETE_ALL_TEILELISTEN_SI() {
            return " delete from w_teileliste_sendeinfo where teilelistesi_firma_id='&FIRMAID&' and teilelistesi_filiale_id='&FILIALID&'";
        }

        @Override
        public final String DELETE_ALL_BESTELLLISTEN() {
            return " delete from w_bestellliste where bestellliste_firma_id='&FIRMAID&' and bestellliste_filiale_id='&FILIALID&'";
        }

        @Override
        public final String DELETE_ALL_BESTELLLISTEN_POSITIONEN() {
            return " delete from w_bestelllistepos where bestelllistepos_firma_id='&FIRMAID&' and bestelllistepos_filiale_id='&FILIALID&'";
        }

        @Override
        public final String EXISTIERT_FILIAL_ZUB() {
            return " select count(*) from w_zub_konfig@etk_nutzer where konfigz_firma_id = ?  and konfigz_filiale_id = ?  and konfigz_default_markt_id is not null";
        }

        @Override
        public final String UPDATE_MARKTID_NUTZER_VON_FILIALE() {
            return " update w_user@etk_nutzer set user_marktid = ( select konfigz_default_markt_id from w_zub_konfig@etk_nutzer  where konfigz_filiale_id = ? and konfigz_firma_id = user_firma_id)  where user_firma_id = ? and user_id = ?";
        }
    }

    public static final class Hilfe
    extends SQLStatements.Hilfe {
        @Override
        public final String RETRIEVE_ABKUERZUNGEN() {
            return "select abk_kuerzel ABKUERZUNG, abk_bedeutung BEDEUTUNG, ben_text UEBERSETZUNG from w_ben_gk, w_abk where ben_textcode = abk_textcode and ben_iso = ? and ben_regiso = ? order by ABKUERZUNG";
        }

        @Override
        public final String RETRIEVE_VERSIONSINFO() {
            return "select verwaltung_info Info, verwaltung_wert Wert from w_verwaltung";
        }

        @Override
        public final String RETRIEVE_BEDEUTUNGEN() {
            return "select bedeutung_wert WERT, ben_text BEDEUTUNG, komm_pos POS from w_ben_gk, w_komm, w_bedeutung where bedeutung_art = ? and komm_id = bedeutung_kommid and ben_textcode = komm_textcode and ben_iso = ? and ben_regiso = ? order by WERT, POS";
        }

        @Override
        public final String RETRIEVE_SALAPAS() {
            return "select bedsala_art || bedsala_pnr || bedsala_hz Code, ben_text Benennung from w_ben_gk, w_bed, w_bed_sala where bedsala_art IN (&ARTEN&) and bed_elemid = bedsala_id and ben_textcode = bed_textcode and ben_iso = ? and ben_regiso = ? order by Code";
        }
    }

    public static final class TeilevwdgBen
    extends SQLStatements.TeilevwdgBen {
        @Override
        public final String RETRIEVE_BAUREIHEN() {
            return "select distinct baureihe_baureihe BAUREIHE, ben_text EXT_BAUREIHE, baureihe_position POS from w_baureihe inner join w_ben_gk on (ben_textcode = baureihe_textcode and ben_iso = ? and ben_regiso = ?)\twhere baureihe_baureihe IN (select distinct fztyp_baureihe from w_ben_gk H\tinner join w_bildtaf on (bildtaf_textc = ben_textcode and bildtaf_vbereich = ?and bildtaf_produktart = ?) inner join w_bildtaf_marke on (bildtaf_btnr = bildtafm_btnr and bildtafm_marke_tps = ?) inner join w_bildtaf_suche on (bildtafs_hg = bildtaf_hg and bildtafs_btnr = bildtaf_btnr) inner join w_fztyp on (fztyp_mospid = bildtafs_mospid\tand fztyp_vbereich = ?\tand fztyp_sichtschutz = ?\tand fztyp_ktlgausf IN (&IN&)) where ben_iso = ? and ben_regiso = ? and '&SUCHSTRING&') order by POS";
        }

        @Override
        public final String RETRIEVE_BAUREIHEN_SONDERLOCKE() {
            return "select distinct baureihe_baureihe BAUREIHE, ben_text EXT_BAUREIHE, baureihe_position POS from w_baureihe inner join w_ben_gk on (ben_textcode = baureihe_textcode and ben_iso = ? and ben_regiso = ?)\twhere baureihe_baureihe IN (select distinct fztyp_baureihe from w_ben_gk H\tinner join w_bildtaf on (bildtaf_textc = ben_textcode and bildtaf_vbereich = ?and bildtaf_produktart = ?) inner join w_bildtaf_marke on (bildtaf_btnr = bildtafm_btnr  and bildtafm_marke_tps = ?) inner join w_bildtaf_suche on (bildtafs_hg = bildtaf_hg and bildtafs_btnr = bildtaf_btnr) inner join w_fztyp on (fztyp_mospid = bildtafs_mospid\tand fztyp_vbereich = ?\tand fztyp_sichtschutz = ?\tand fztyp_ktlgausf IN (&IN&)) where ben_iso = ? and ben_regiso = ? and ('&SUCHSTRING1&' or '&SUCHSTRING2&')) order by POS";
        }

        @Override
        public final String RETRIEVE_BAUREIHEN_TR() {
            return "select distinct baureihe_baureihe BAUREIHE, ben_text EXT_BAUREIHE, baureihe_position POS from w_baureihe inner join w_ben_gk on (ben_textcode = baureihe_textcode and ben_iso = '&ISO&' and ben_regiso = '&REGISO&')\twhere baureihe_baureihe IN (select distinct fztyp_baureihe from w_ben_gk\tinner join w_bildtaf on (bildtaf_textc = ben_textcode and bildtaf_vbereich = '&KATALOGUMFANG&'and bildtaf_produktart = '&PRODUKTART&')inner join w_bildtaf_marke on (bildtaf_btnr = bildtafm_btnr  and bildtafm_marke_tps = '&MARKE&') inner join w_bildtaf_suche on (bildtafs_hg = bildtaf_hg and bildtafs_btnr = bildtaf_btnr) inner join w_fztyp on (fztyp_mospid = bildtafs_mospid\tand fztyp_vbereich = '&KATALOGUMFANG&'\tand fztyp_sichtschutz = 'N'\tand fztyp_ktlgausf IN (&REGIONEN&)) where ben_iso = '&ISO&' and ben_regiso = '&REGISO&' and upper(replace(ben_text,'i',chr(50352))) like ''&SUCHSTRING&'') order by POS";
        }

        @Override
        public final String RETRIEVE_MODELLSPALTEN() {
            return "select distinct btzeilenv_vmenge MENGE, bildtaf_btnr BTNR, B.ben_text BTUEBERSCHRIFT, fztyp_erwvbez MODELL, K.ben_text KAROSSERIE, fztyp_karosserie KAROSSERIE_ID, baureihe_bauart BAUART, fztyp_ktlgausf REGION, bildtaf_kommbt Kommentar, bildtaf_vorh_cp CPVorhanden, bildtaf_bedkez BedingungKZ, marktetk_isokz MarktIso from w_markt_etk, w_ben_gk H, w_bildtaf, w_bildtaf_marke, w_bildtaf_suche,w_fztyp, w_baureihe, w_ben_gk K, w_publben, w_ben_gk B, w_btzeilen_verbauung where H.ben_iso = ? and H.ben_regiso = ? and '&SUCHSTRING&' and H.ben_textcode = bildtaf_textc and bildtaf_vbereich = ? and bildtaf_btnr = bildtafm_btnr  and bildtafm_marke_tps = ? and bildtaf_produktart = ? and bildtaf_btnr = bildtafs_btnr and bildtafs_mospid = fztyp_mospid and fztyp_baureihe = ? and fztyp_vbereich = ? and fztyp_sichtschutz = ? and fztyp_ktlgausf IN (&IN&) and fztyp_baureihe = baureihe_baureihe and fztyp_karosserie = publben_bezeichnung and publben_art = ? and publben_textcode = K.ben_textcode and K.ben_iso = ? and K.ben_regiso = ? and bildtaf_textc = B.ben_textcode and B.ben_iso = ? and B.ben_regiso = ? and bildtaf_btnr = btzeilenv_btnr and bildtafs_mospid = btzeilenv_mospid &MODELLSPALTEN_STMT&  and marktetk_lkz (+) = bildtaf_lkz order by MODELL, BTNR, KAROSSERIE, REGION";
        }

        @Override
        public final String RETRIEVE_MODELLSPALTEN_SONDERLOCKE() {
            return "select distinct btzeilenv_vmenge MENGE, bildtaf_btnr BTNR, B.ben_text BTUEBERSCHRIFT, fztyp_erwvbez MODELL, K.ben_text KAROSSERIE, fztyp_karosserie KAROSSERIE_ID, baureihe_bauart BAUART, fztyp_ktlgausf REGION, bildtaf_kommbt Kommentar, bildtaf_vorh_cp CPVorhanden, bildtaf_bedkez BedingungKZ, marktetk_isokz MarktIso from w_markt_etk, w_ben_gk H, w_bildtaf, w_bildtaf_marke, w_bildtaf_suche,w_fztyp, w_baureihe, w_ben_gk K, w_publben, w_ben_gk B, w_btzeilen_verbauung where H.ben_iso = ? and H.ben_regiso = ? and ('&SUCHSTRING1&' or '&SUCHSTRING2&') and H.ben_textcode = bildtaf_textc and bildtaf_vbereich = ? and bildtaf_btnr = bildtafm_btnr  and bildtafm_marke_tps = ? and bildtaf_produktart = ? and bildtaf_hg = bildtafs_hg and bildtaf_btnr = bildtafs_btnr and bildtafs_mospid = fztyp_mospid and fztyp_baureihe = ? and fztyp_vbereich = ? and fztyp_sichtschutz = ? and fztyp_ktlgausf IN (&IN&) and fztyp_baureihe = baureihe_baureihe and fztyp_karosserie = publben_bezeichnung and publben_art = ? and publben_textcode = K.ben_textcode and K.ben_iso = ? and K.ben_regiso = ? and bildtaf_textc = B.ben_textcode and B.ben_iso = ? and B.ben_regiso = ? and bildtaf_btnr = btzeilenv_btnr and bildtafs_mospid = btzeilenv_mospid &MODELLSPALTEN_STMT&  and marktetk_lkz (+) = bildtaf_lkz order by MODELL, BTNR, KAROSSERIE, REGION";
        }

        @Override
        public final String MODELLSPALTEN_STMT() {
            return " and btzeilenv_mospid IN (&MOSPIDS&)";
        }

        @Override
        public final String RETRIEVE_BAUREIHEN_TNR() {
            return "select distinct baureihe_baureihe BAUREIHE, ben_text EXT_BAUREIHE, baureihe_position POS from w_baureihe inner join w_ben_gk on (ben_textcode = baureihe_textcode and ben_iso = ? and ben_regiso = ?)\twhere baureihe_baureihe IN (select distinct fztyp_baureihe from w_btzeilen inner join w_bildtaf on (bildtaf_btnr =  btzeilen_btnr and bildtaf_vbereich = ? and bildtaf_produktart = ?) inner join w_bildtaf_suche on (bildtafs_hg = bildtaf_hg and bildtafs_btnr = bildtaf_btnr) inner join w_btzeilen_verbauung on (btzeilen_sachnr = btzeilenv_sachnr)  inner join w_fztyp on (fztyp_mospid = bildtafs_mospid\tand fztyp_vbereich = ?\tand fztyp_sichtschutz = ?\tand fztyp_ktlgausf IN (&IN1&)) where btzeilen_sachnr IN (&IN2&) and btzeilenv_alter_kz is null ) order by POS";
        }

        @Override
        public final String RETRIEVE_MODELLSPALTEN_TNR() {
            return "select distinct btzeilenv_vmenge MENGE, bildtaf_btnr BTNR, B.ben_text BTUEBERSCHRIFT, fztyp_erwvbez MODELL, K.ben_text KAROSSERIE, fztyp_karosserie KAROSSERIE_ID, baureihe_bauart BAUART, fztyp_ktlgausf REGION, bildtaf_kommbt Kommentar, bildtaf_vorh_cp CPVorhanden, bildtaf_bedkez BedingungKZ, marktetk_isokz MarktIso from w_markt_etk, w_bildtaf, w_bildtaf_marke, w_bildtaf_suche,w_fztyp, w_baureihe, w_ben_gk K, w_publben, w_ben_gk B, w_btzeilen_verbauung where btzeilenv_sachnr IN (&IN1&) and btzeilenv_btnr = bildtaf_btnr and bildtaf_vbereich = ? and bildtafm_btnr = bildtaf_btnr  and bildtafm_marke_tps = ? and bildtaf_produktart = ? and bildtaf_hg = bildtafs_hg and bildtaf_btnr = bildtafs_btnr and bildtafs_mospid = fztyp_mospid and fztyp_baureihe = ? and fztyp_vbereich = ? and fztyp_sichtschutz = ? and fztyp_ktlgausf IN (&IN2&) and fztyp_baureihe = baureihe_baureihe and fztyp_karosserie = publben_bezeichnung and publben_art = ? and publben_textcode = K.ben_textcode and K.ben_iso = ? and K.ben_regiso = ? and bildtaf_textc = B.ben_textcode and B.ben_iso = ? and B.ben_regiso = ? and bildtaf_btnr = btzeilenv_btnr and bildtafs_mospid = btzeilenv_mospid and btzeilenv_alter_kz is null and marktetk_lkz (+) = bildtaf_lkz order by MODELL, BTNR, KAROSSERIE, REGION";
        }

        @Override
        public final String SEARCH_SNR_TVBENENNUNG() {
            return "select distinct teil_hauptgr Hauptgruppe, teil_untergrup Untergruppe, teil_sachnr Sachnummer, ben_teil.ben_text Benennung, teil_benennzus Zusatz, ben_komm.ben_text BenennungKommentar,  teil_ist_diebstahlrelevant Teil_Diebstahlrelevant  from w_btzeilen_verbauung, w_teil_marken, w_teil  inner join  w_ben_gk ben_teil on (ben_textcode = teil_textcode and ben_teil.ben_iso = ? and ben_teil.ben_regiso = ? and '&SUCHSTRING&') left join w_ben_gk ben_komm on (ben_komm.ben_textcode = teil_textcode_kom  and ben_komm.ben_iso = ? and ben_komm.ben_regiso = ?) where teil_sachnr = teilm_sachnr and teilm_marke_tps = ? and teil_verbaubar = ? and teil_produktart in (?, ?) and btzeilenv_sachnr = teil_sachnr and btzeilenv_alter_kz is null union select distinct teil_hauptgr Hauptgruppe, teil_untergrup Untergruppe, teil_sachnr Sachnummer, ben_teil.ben_text Benennung, teil_benennzus Zusatz, ben_komm.ben_text BenennungKommentar,  teil_ist_diebstahlrelevant Teil_Diebstahlrelevant  from w_btzeilenugb, w_teil_marken, w_teil inner join  w_ben_gk ben_teil on (ben_textcode = teil_textcode and ben_teil.ben_iso = ? and ben_teil.ben_regiso = ? and '&SUCHSTRING&') left join w_ben_gk ben_komm on (ben_komm.ben_textcode = teil_textcode_kom and ben_komm.ben_iso = ? and ben_komm.ben_regiso = ?) where teil_sachnr = teilm_sachnr and teilm_marke_tps = ? and teil_verbaubar = ? and teil_produktart in (?, ?) and btzeilenu_sachnr = teil_sachnr order by Benennung, Hauptgruppe, Untergruppe, Sachnummer";
        }

        @Override
        public final String SEARCH_SNR_TVBENENNUNG_SONDERLOCKE() {
            return "select distinct teil_hauptgr Hauptgruppe, teil_untergrup Untergruppe, teil_sachnr Sachnummer, ben_teil.ben_text Benennung, teil_benennzus Zusatz, ben_komm.ben_text BenennungKommentar,  teil_ist_diebstahlrelevant Teil_Diebstahlrelevant  from w_btzeilen_verbauung, w_teil_marken, w_teil  inner join  w_ben_gk ben_teil on (ben_textcode = teil_textcode and ben_teil.ben_iso = ? and ben_teil.ben_regiso = ? and ('&SUCHSTRING1&' or '&SUCHSTRING2&')) left join w_ben_gk ben_komm on (ben_komm.ben_textcode = teil_textcode_kom  and ben_komm.ben_iso = ? and ben_komm.ben_regiso = ?) where teil_sachnr = teilm_sachnr and teilm_marke_tps = ? and teil_verbaubar = ? and teil_produktart in (?, ?) and btzeilenv_sachnr = teil_sachnr and btzeilenv_alter_kz is null  union select distinct teil_hauptgr Hauptgruppe, teil_untergrup Untergruppe, teil_sachnr Sachnummer, ben_teil.ben_text Benennung, teil_benennzus Zusatz, ben_komm.ben_text BenennungKommentar,  teil_ist_diebstahlrelevant Teil_Diebstahlrelevant  from w_btzeilenugb, w_teil_marken, w_teil inner join  w_ben_gk ben_teil on (ben_textcode = teil_textcode and ben_teil.ben_iso = ? and ben_teil.ben_regiso = ? and ('&SUCHSTRING1&' or '&SUCHSTRING2&')) left join w_ben_gk ben_komm on (ben_komm.ben_textcode = teil_textcode_kom and ben_komm.ben_iso = ? and ben_komm.ben_regiso = ?) where teil_sachnr = teilm_sachnr and teilm_marke_tps = ? and teil_verbaubar = ? and teil_produktart in (?, ?) and btzeilenu_sachnr = teil_sachnr order by Benennung, Hauptgruppe, Untergruppe, Sachnummer";
        }

        @Override
        public final String SEARCH_BT_SACHNUMMERN_TVBEN() {
            return "select distinct bildtaf_btnr BildtafelNr, bildtaf_bteart BildtafelArt, ben_text Benennung, bildtaf_kommbt Kommentar, bildtaf_vorh_cp CPVorhanden, bildtaf_bedkez BedingungKZ, bildtaf_pos Pos, marktetk_isokz MarktIso from w_markt_etk, w_ben_gk, w_bildtaf, w_btzeilen, w_btzeilen_verbauung, w_fztyp, w_baureihe where btzeilenv_mospid =  fztyp_mospid and fztyp_vbereich = ? and fztyp_sichtschutz = ? and fztyp_ktlgausf IN (&IN1&) and fztyp_baureihe = baureihe_baureihe and baureihe_marke_tps = ? and baureihe_produktart = ? and baureihe_vbereich in (?, ?) and btzeilenv_sachnr IN (&IN2&) and btzeilenv_btnr = btzeilen_btnr and btzeilenv_pos = btzeilen_pos and btzeilen_btnr = bildtaf_btnr and bildtaf_textc = ben_textcode and ben_iso = ? and ben_regiso = ? and marktetk_lkz (+) = bildtaf_lkz &UNION& &SEARCH_BT_SACHNUMMERN_ASS& order by Pos";
        }
    }

    public static final class TeilevwdgTeil
    extends SQLStatements.TeilevwdgTeil {
        @Override
        public final String RETRIEVE_TEIL_ZU_MARKE_PROD() {
            return "select teil_hauptgr HG, teil_untergrup UG, ben_text BEN    , teil_ist_diebstahlrelevant Teil_Diebstahlrelevant  from w_ben_gk, w_teil_marken, w_teil where teil_sachnr = ? and teil_produktart IN (?, ?) and teilm_sachnr = teil_sachnr  and teilm_marke_tps = ?  and ben_textcode = teil_textcode and ben_iso = ? and ben_regiso = ?";
        }

        @Override
        public final String RETRIEVE_TEIL() {
            return "select teil_hauptgr HG,  teil_untergrup UG,  teilm_marke_tps MARKE,  teil_produktart PRODUKTART,  ben_text BEN,  teil_ist_diebstahlrelevant Teil_Diebstahlrelevant  from w_ben_gk, w_teil_marken, w_teil  where teil_sachnr = ? and teilm_sachnr = teil_sachnr and ben_textcode = teil_textcode and ben_iso = ? and ben_regiso = ?";
        }

        @Override
        public final String RETRIEVE_BAUREIHEN() {
            return "select distinct baureihe_baureihe BAUREIHE, ben_text EXT_BAUREIHE, baureihe_position POS from w_ben_gk, w_baureihe, w_fztyp, w_btzeilen, w_btzeilen_verbauung where btzeilenv_sachnr = ? &MODELLSPALTEN_STMT&  and btzeilen_btnr = btzeilenv_btnr and btzeilen_pos = btzeilenv_pos and btzeilen_bildposnr <> '--' and fztyp_mospid = btzeilenv_mospid and fztyp_vbereich = ? and fztyp_sichtschutz = ? and fztyp_ktlgausf IN (&IN&) and baureihe_baureihe = fztyp_baureihe and baureihe_marke_tps = ? and baureihe_produktart = ? and baureihe_vbereich in (?, ?) and ben_textcode = baureihe_textcode and ben_iso = ? and ben_regiso = ? and btzeilenv_alter_kz is null order by Pos";
        }

        @Override
        public final String RETRIEVE_MODELLSPALTEN() {
            return "select distinct btzeilenv_vmenge MENGE, btzeilenv_btnr BTNR, B.ben_text BTUEBERSCHRIFT, fztyp_erwvbez MODELL, K.ben_text KAROSSERIE, fztyp_karosserie KAROSSERIE_ID, baureihe_bauart BAUART, fztyp_ktlgausf REGION, bildtaf_kommbt Kommentar, bildtaf_vorh_cp CPVorhanden, bildtaf_bedkez BedingungKZ, marktetk_isokz MarktIso from  w_markt_etk, w_ben_gk B, w_ben_gk K, w_publben, w_baureihe, w_bildtaf, w_btzeilen_verbauung, w_btzeilen, w_fztyp where fztyp_baureihe = ? and fztyp_vbereich = ? and fztyp_sichtschutz = ? and fztyp_ktlgausf IN (&IN&) and btzeilenv_mospid = fztyp_mospid &MODELLSPALTEN_STMT&  and btzeilenv_sachnr = ? and btzeilen_btnr = btzeilenv_btnr and btzeilen_pos = btzeilenv_pos and btzeilen_bildposnr <> '--' and bildtaf_btnr = btzeilenv_btnr and baureihe_baureihe = fztyp_baureihe and publben_art = ? and publben_bezeichnung = fztyp_karosserie and K.ben_textcode = publben_textcode and K.ben_iso = ? and K.ben_regiso = ? and B.ben_textcode = bildtaf_textc and B.ben_iso = ? and B.ben_regiso = ? and btzeilenv_alter_kz is null and marktetk_lkz (+) = bildtaf_lkz order by MODELL, BTNR, KAROSSERIE, REGION";
        }

        @Override
        public final String MODELLSPALTEN_STMT() {
            return " and btzeilenv_mospid IN (&IN&)";
        }
    }

    public static final class Federtabelle
    extends SQLStatements.Federtabelle {
        @Override
        public final String LOAD_SALAS() {
            return "select distinct sftsala_salaid Id, bedsala_art || bedsala_pnr || bedsala_hz Code, ben_text Benennung from w_ben_gk, w_bed_sala, w_bed, w_sftsala, w_sft, w_sfttyp where sfttyp_typ in (&TYPEN&) and sft_sftid = sfttyp_sftid &PRODDATUM_STMT& and sftsala_sftid = sft_sftid and bedsala_id = sftsala_salaid and bed_elemid = bedsala_id and ben_textcode = bed_textcode and ben_iso = ? and ben_regiso = ? order by Code, Benennung";
        }

        @Override
        public final String LOAD_PUNKTE_TYP() {
            return "select distinct sfttyp_sftid FTId, sfttyp_typ Typ, sfttyp_punkte_va_l GrundpunkteVA_links, sfttyp_punkte_va_r GrundpunkteVA_rechts, sfttyp_punkte_ha_l GrundpunkteHA_links, sfttyp_punkte_ha_r GrundpunkteHA_rechts, sftid_ist_aspg Sftid_Ist_Aspg from w_sft, w_sfttyp where sfttyp_typ in (&TYPEN&) and sft_sftid = sfttyp_sftid &PRODDATUM_STMT& order by FTId, Typ";
        }

        @Override
        public final String LOAD_PUNKTE_SALA() {
            return "select distinct sftsala_sftid FTId, sftsala_salaid SalaId, sftsala_va_punkte_l PunkteVA_links, sftsala_va_punkte_r PunkteVA_rechts, sftsala_ha_punkte_l PunkteHA_links, sftsala_ha_punkte_r PunkteHA_rechts from w_sftsala, w_sft, w_sfttyp where sfttyp_typ in (&TYPEN&) and sft_sftid = sfttyp_sftid &PRODDATUM_STMT& and sftsala_sftid = sft_sftid and sftsala_salaid in (&SALAIDS&) order by FTId, SalaId";
        }

        @Override
        public final String SFT_PRODDATUM_YYYYMM() {
            return " and substr(sft_gilt_v, 1, 6) <= ? and nvl(substr(sft_gilt_b, 1, 6), 999999) >= ?";
        }

        @Override
        public final String SFT_PRODDATUM_YYYYMMDD() {
            return " and sft_gilt_v <= ? and nvl(sft_gilt_b, 99999999) >= ?";
        }

        @Override
        public final String LOAD_FEDERN_LINKS() {
            return "select distinct teil_hauptgr || teil_untergrup || sftfeder_sachnr_l Teilenummer   ,          teil_ist_diebstahlrelevant Teil_Diebstahlrelevant  from w_teil, w_sftfeder where sftfeder_sftid = ? and sftfeder_kz_vh = ? and sftfeder_punkte_von <= ? and sftfeder_punkte_bis >= ? and teil_sachnr = sftfeder_sachnr_l";
        }

        @Override
        public final String LOAD_FEDERN_RECHTS() {
            return "select distinct teil_hauptgr || teil_untergrup || sftfeder_sachnr_r Teilenummer   ,          teil_ist_diebstahlrelevant Teil_Diebstahlrelevant  from w_teil, w_sftfeder where sftfeder_sftid = ? and sftfeder_kz_vh = ? and sftfeder_punkte_von <= ? and sftfeder_punkte_bis >= ? and teil_sachnr = sftfeder_sachnr_r";
        }

        @Override
        public final String LOAD_ASPG_KIT() {
            return "select teil_hauptgr || teil_untergrup || sftaspg_sachnr_pg Teilenummer, sftaspg_btnr BTNr, sftaspg_mospid MospId, sftaspg_achse Achse, teil_ist_diebstahlrelevant Teil_Diebstahlrelevant from w_sft_aspg, w_teil where sftaspg_sftid = ? and teil_sachnr = sftaspg_sachnr_pg";
        }
    }

    public static final class Fuellmengen
    extends SQLStatements.Fuellmengen {
        @Override
        public final String RETRIEVE_FUELLMENGEN() {
            return "select fuellmengen_typ Typ, fuellmengen_getriebeben Getriebe, fuellmengen_motor Motor, fuellmengen_fm_getriebe FMGetriebe, fuellmengen_fm_motor FMMotor, fuellmengen_fm_ha FMHinterachse, fuellmengen_fm_km_mitac FMKuehlmittelMitAC, fuellmengen_fm_km_ohneac FMKuehlmittelOhneAC, fuellmengen_fm_bremse FMBremse, fuellmengen_hw_&SPRACHE& Hinweis from w_fuellmengen where fuellmengen_typ in (&IN&) and substr(fuellmengen_ab, 1, 6) <= ? and nvl(substr(fuellmengen_bis, 1, 6), 999999) >= ? order by Typ, Getriebe";
        }
    }

    public static final class Normteile
    extends SQLStatements.Normteile {
        @Override
        public final String RETRIEVE_BENENNUNGEN() {
            return "select distinct ben_text BENENNUNG, normteilben_textcode TEXTCODE from w_ben_gk, w_normteilben where normteilben_marke_tps = ? and (normteilben_produktart = ? or normteilben_produktart = ?) and ben_textcode = normteilben_textcode and ben_iso = ? and ben_regiso = ? order by BENENNUNG";
        }

        @Override
        public final String RETRIEVE_TEILE_ZU_BENENNUNG() {
            return "select distinct ben_text BENENNUNG, teil_hauptgr HG, teil_untergrup UG, teil_sachnr SACHNUMMER, teil_benennzus ZUSATZ, nn_art NORMART, teil_normnummer NORMNUMMER, teil_produktart PRODUKTART, teilm_marke_tps MARKE,  teil_ist_diebstahlrelevant Teil_Diebstahlrelevant  from w_teil inner join w_ben_gk on (teil_textcode = ben_textcode and ben_iso = ? and ben_regiso = ?) inner join w_teil_marken on (teil_sachnr = teilm_sachnr and teilm_marke_tps = ?) left join w_normnummer on (teil_normnummer = nn_nnid and teilm_marke_tps = nn_marke_tps) where (teil_produktart = ? or teil_produktart = ? or teil_produktart IS NULL) and (teil_hauptgr = ? or (teil_hauptgr = ? and teil_untergrup = ?)) and (teil_lkz = '   ' or teil_lkz IS NULL) and teil_technik IN ('0', '3', '4', '7') and (teil_dispo IN ('0', '2', '3', '4', '5') or (teil_dispo = '6' and teil_entfall_dat > ? )) and &TEXTCODE_STMT& order by ZUSATZ, NORMNUMMER";
        }

        @Override
        public final String TEXTCODE_GLEICH_STMT() {
            return "teil_textcode = ?";
        }

        @Override
        public final String TEXTCODE_IN_STMT() {
            return "teil_textcode IN (&IN&)";
        }

        @Override
        public final String RETRIEVE_TEILE_ZU_NORMNUMMER() {
            return "select distinct teil_hauptgr HG, teil_untergrup UG, teil_sachnr SACHNUMMER, ben_text BENENNUNG, teil_benennzus ZUSATZ, nn_art NORMART, teil_normnummer NORMNUMMER, teil_produktart PRODUKTART, teilm_marke_tps MARKE,  teil_ist_diebstahlrelevant Teil_Diebstahlrelevant  from w_teil inner join w_ben_gk on (teil_textcode = ben_textcode and ben_iso = ? and ben_regiso = ?) inner join w_teil_marken on (teil_sachnr = teilm_sachnr and teilm_marke_tps = ?) left join w_normnummer on (teil_normnummer = nn_nnid and teilm_marke_tps = nn_marke_tps) where (teil_produktart = ? or teil_produktart = ? or teil_produktart IS NULL) and UPPER(teil_normnummer) = UPPER(?) and (teil_hauptgr = ? or (teil_hauptgr = ? and teil_untergrup = ?)) and (teil_lkz = '   ' or teil_lkz IS NULL) and teil_technik IN ('0', '3', '4', '7') and (teil_dispo IN ('0', '2', '3', '4', '5') or (teil_dispo = ? and teil_entfall_dat > ? )) order by ZUSATZ, NORMNUMMER";
        }

        @Override
        public final String RETRIEVE_NORMNUMMERN_GRUPPEN() {
            return "select nng_nngid NUMMER, nng_grafikid GRAFIKID, nng_pos POS, grafik_moddate TS from w_grafik, w_normnummergruppe where nng_marke_tps = ? and (nng_produktart = ? or nng_produktart = ?) and grafik_grafikid = nng_grafikid and grafik_art = ? order by POS";
        }

        @Override
        public final String RETRIEVE_NORMNUMMERN() {
            return "select nn_nnid NUMMER, nn_art ART, nn_grafikid GRAFIKID, nn_pos POS, grafik_moddate TS from w_grafik, w_normnummer where nn_marke_tps = ? and (nn_produktart = ? or nn_produktart = ?) and nn_nngid = ? and grafik_grafikid = nn_grafikid and grafik_art = ? order by POS";
        }
    }

    public static final class NotizuebersichtJAVA
    extends SQLStatements.NotizuebersichtJAVA {
        @Override
        public final String RETRIEVE_ANZ_NOTIZEN() {
            return "select count (distinct teileinfo_sachnr) ANZ from w_teileinfo where (teileinfo_user_id =  '&NUTZER&' OR teileinfo_allgemein = 'J') and teileinfo_firma_id = '&FIRMA&'";
        }

        @Override
        public final String RETRIEVE_ANZ_NOTIZEN_ZU_SACHNUMMER() {
            return "select count (distinct teileinfo_sachnr) ANZ from w_teileinfo where (teileinfo_user_id =  ? OR teileinfo_allgemein = ?) and teileinfo_firma_id = ? and teileinfo_sachnr = ?";
        }

        @Override
        public final String RETRIEVE_MIN_HG() {
            return "select min(teil_hauptgr) HG from w_teil, w_teileinfo where teileinfo_user_id =  '&NUTZER&' and teileinfo_firma_id = '&FIRMA&' and teil_sachnr = teileinfo_sachnr";
        }

        @Override
        public final String RETRIEVE_NOTIZEN() {
            return "select teil_hauptgr HG, teil_untergrup UG, teil_sachnr SACHNR, TBEN.ben_text BENENNUNG, MBEN.ben_text MONAT, teileinfo_gueltig_bis_jahr JAHR from w_ben_gk MBEN, w_publben, w_ben_gk TBEN, w_teil, w_teileinfo where (teileinfo_user_id =  '&NUTZER&' OR teileinfo_allgemein = 'J') and teileinfo_firma_id = '&FIRMA&' and teil_sachnr = teileinfo_sachnr &HG_STMT& and TBEN.ben_textcode = teil_textcode and TBEN.ben_iso = '&ISO&' and TBEN.ben_regiso = '&REGISO&' and publben_art = 'M' and publben_bezeichnung = ltrim(to_char(teileinfo_gueltig_bis_monat, '00')) and MBEN.ben_textcode = publben_textcode and MBEN.ben_iso = '&ISO&' and MBEN.ben_regiso = '&REGISO&' order by HG, UG, SACHNR";
        }
    }

    public static final class NotizuebersichtHTML
    extends SQLStatements.NotizuebersichtHTML {
        @Override
        public final String RETRIEVE_ANZ_NOTIZEN() {
            return "select count (*) ANZ from w_teileinfo where teileinfo_user_id = ?";
        }

        @Override
        public final String RETRIEVE_MIN_HG() {
            return "select min(teil_hauptgr) HG from w_teil, w_teileinfo where teileinfo_user_id =  ? and teil_sachnr = teileinfo_sachnr";
        }

        @Override
        public final String RETRIEVE_NOTIZEN() {
            return "select teil_hauptgr HG, teil_untergrup UG, teil_sachnr SACHNR, TBEN.ben_text BENENNUNG, MBEN.ben_text MONAT, teileinfo_gueltig_bis_jahr JAHR from w_ben_gk MBEN, w_publben, w_ben_gk TBEN, w_teil, w_teileinfo where teileinfo_user_id =  ? and teil_sachnr = teileinfo_sachnr &HG_STMT& and TBEN.ben_textcode = teil_textcode and TBEN.ben_iso = ? and TBEN.ben_regiso = ? and publben_art = ? and publben_bezeichnung = ltrim(to_char(teileinfo_gueltig_bis_monat, ?)) and MBEN.ben_textcode = publben_textcode and MBEN.ben_iso = ? and MBEN.ben_regiso = ? order by HG, UG, SACHNR";
        }

        @Override
        public final String HG_STMT() {
            return "and teil_hauptgr = ?";
        }
    }

    public static final class Notizuebersicht
    extends SQLStatements.Notizuebersicht {
        @Override
        public final String HG_STMT() {
            return "and teil_hauptgr = ?";
        }
    }

    public static final class Lagerzeit
    extends SQLStatements.Lagerzeit {
        @Override
        public final String RETRIEVE_HGS() {
            return "select distinct teil_hauptgr HG from w_teil_marken, w_teil where teil_hauptgr >= ? &HGBIS_STMT& and teil_lzb = ? and teil_produktart IN (?, ?) and teilm_sachnr = teil_sachnr  and teilm_marke_tps = ? order by HG";
        }

        @Override
        public final String RETRIEVE_TEILE() {
            return "select distinct teil_hauptgr HG, teil_untergrup UG, teil_sachnr SACHNR, ben_text BENENNUNG, teil_benennzus ZUSATZ, teil_vorhanden_si_ohne_lzb SI, teil_kom_pi PI, teil_textcode_kom BENKOMMENTARID,  teil_ist_reach REACH,  teil_ist_aspg ASPG,  decode(teil_sachnr, tcp_sachnr, 'C', NULL) TC,  teil_ist_diebstahlrelevant Teil_Diebstahlrelevant  from w_teil inner join w_teil_marken on (teil_sachnr = teilm_sachnr and teilm_marke_tps = ?) inner join w_ben_gk on (teil_textcode = ben_textcode and ben_iso = ? and ben_regiso = ?) left join w_tc_performance_allg on (teil_sachnr = tcp_sachnr                                 and tcp_marke_tps = ?                                 and tcp_produktart = ?                                 and tcp_vbereich in (&IN&)                                 &TC_CHECK_LANDKUERZEL&                                 and tcp_datum_von <= ?                                 and (tcp_datum_bis is null or tcp_datum_bis <= ?)) where teil_lzb = ? and teil_hauptgr = ? and teil_produktart IN ( ?, ?) order by HG, UG, SACHNR";
        }

        @Override
        public final String HG_BIS_STMT() {
            return "and teil_hauptgr <= ?";
        }

        @Override
        public final String TC_CHECK_LANDKUERZEL() {
            return " and tcp_landkuerzel = ?";
        }
    }

    public static final class Erstbevorratung
    extends SQLStatements.Erstbevorratung {
        @Override
        public final String RETRIEVE_HGS() {
            return "select distinct ebs_hg HG from w_erstbevorratung_suche where ebs_mospid IN (&IN&) and ebs_hg >= ? &HGBIS_STMT& &LENKUNG_STMT& order by HG";
        }

        @Override
        public final String HG_BIS_STMT() {
            return "and ebs_hg <= ?";
        }

        @Override
        public final String HG_LENKUNG_STMT() {
            return "and (ebs_lenkung = '&LENKUNG&' OR ebs_lenkung IS NULL)";
        }

        @Override
        public final String RETRIEVE_TEILE() {
            return "select distinct teil_hauptgr HG, teil_untergrup UG, teil_sachnr SACHNR, ben_text BENENNUNG, teil_benennzus ZUSATZ, teil_vorhanden_si SI, teil_lzb LZB, teil_kom_pi PI, teil_textcode_kom BENKOMMENTARID, teil_ist_reach REACH,  teil_ist_aspg ASPG,  decode(NVL(tcp_sachnr, 'N'), tcp_sachnr, 'C', NULL) TC,  teil_ist_diebstahlrelevant Teil_Diebstahlrelevant  from w_erstbevorratung inner join w_teil on (eb_sachnr = teil_sachnr) inner join w_ben_gk on (teil_textcode = ben_textcode and ben_iso = ? and ben_regiso = ?) left join w_tc_performance on (tcp_mospid in (&MOSPIDS&) and tcp_sachnr = eb_sachnr &TC_CHECK_LANDKUERZEL& and tcp_datum_von <= ? and (tcp_datum_bis is null or tcp_datum_bis >= ?)) where eb_hg = ? and eb_mospid IN (&IN&) &LENKUNG_STMT& order by HG, UG, SACHNR";
        }

        @Override
        public final String TEIL_LENKUNG_STMT() {
            return "and (eb_lenkung = ? OR eb_lenkung IS NULL)";
        }

        @Override
        public final String TC_CHECK_LANDKUERZEL() {
            return " and tcp_landkuerzel = ?";
        }
    }

    public static final class TechnischeLiteratur
    extends SQLStatements.TechnischeLiteratur {
        @Override
        public final String RETRIEVE_FGS() {
            return "select hgfg_hg Hauptgruppe, hgfg_fg Funktionsgruppe, ben_text Benennung from w_hgfg, w_ben_gk, w_hgfg_mosp where hgfgm_mospid = ? and hgfgm_hg = ? and hgfg_hg = hgfgm_hg and hgfg_fg = hgfgm_fg and hgfg_produktart = hgfgm_produktart and hgfg_bereich = hgfgm_bereich and ben_textcode = hgfg_textcode and ben_iso = ? and ben_regiso = ? union select hgfg_hg Hauptgruppe, hgfg_fg Funktionsgruppe, ben_text Benennung from w_hgfg, w_ben_gk, w_btzeilenugb_verbauung, w_bildtaf where bildtaf_bteart = ? and bildtaf_hg = ? and bildtaf_produktart = ? and bildtaf_vbereich in (?, ?) and btzeilenuv_btnr = bildtaf_btnr and btzeilenuv_marke_tps = ? and hgfg_hg = bildtaf_hg and hgfg_fg = bildtaf_fg and hgfg_produktart = bildtaf_produktart and hgfg_bereich = ? and ben_textcode = hgfg_textcode and ben_iso = ? and ben_regiso = ? order by 1, 2";
        }

        @Override
        public final String RETRIEVE_SPRACHEN() {
            return "select substr(publben_bezeichnung, 1, 2) SpracheISO, substr(publben_bezeichnung, 3, 2) SpracheRegISO, ben_text Benennung from w_ben_gk, w_publben where publben_art = ? and ben_textcode = publben_textcode and ben_iso = ? and ben_regiso = ? order by Benennung";
        }

        @Override
        public final String LOAD_TECHNISCHE_LITERATUR() {
            return " select teil_hauptgr HG, teil_untergrup UG, teil_sachnr Sachnummer, teil_ist_eba istEBA, benennung.ben_text Benennung, kommentar.ben_text Kommentar, teil_benennzus Zusatz, btzeilen_eins Einsatz, btzeilen_auslf Auslauf, teil_mam MAM,  teil_ist_diebstahlrelevant Teil_Diebstahlrelevant  from w_ben_gk benennung, w_ben_gk kommentar, w_teil, w_btzeilen_verbauung, w_btzeilen, w_bildtaf where bildtaf_hg = ? and bildtaf_fg = ? and bildtaf_bteart = ? and bildtaf_produktart = ? and bildtaf_vbereich in (?, ?) and btzeilen_btnr = bildtaf_btnr and btzeilen_bildposnr != ? &TLSPRACHE_STMT_GEB& and btzeilenv_btnr = btzeilen_btnr and btzeilenv_pos = btzeilen_pos and btzeilenv_mospid = ? and teil_sachnr = btzeilen_sachnr and benennung.ben_textcode = teil_textcode and benennung.ben_iso = ? and benennung.ben_regiso = ? and kommentar.ben_textcode (+) = teil_textcode_kom and kommentar.ben_iso (+) = ? and kommentar.ben_regiso (+) = ? union select teil_hauptgr HG, teil_untergrup UG, teil_sachnr Sachnummer, teil_ist_eba istEBA, benennung.ben_text Benennung, kommentar.ben_text Kommentar, teil_benennzus Zusatz, btzeilenu_eins Einsatz, btzeilenu_ausl Auslauf, teil_mam MAM,  teil_ist_diebstahlrelevant Teil_Diebstahlrelevant  from w_ben_gk benennung, w_ben_gk kommentar, w_teil, w_btzeilenugb_verbauung, w_btzeilenugb, w_bildtaf where bildtaf_hg = ? and bildtaf_fg = ? and bildtaf_bteart = ? and bildtaf_produktart = ? and bildtaf_vbereich in (?, ?) and btzeilenu_btnr = bildtaf_btnr and btzeilenu_bildposnr != '--' &TLSPRACHE_STMT_UGB& and btzeilenuv_btnr = btzeilenu_btnr and btzeilenuv_pos = btzeilenu_pos and btzeilenuv_marke_tps = ? and teil_sachnr = btzeilenu_sachnr and benennung.ben_textcode = teil_textcode and benennung.ben_iso = ? and benennung.ben_regiso = ? and kommentar.ben_textcode (+) = teil_textcode_kom and kommentar.ben_iso (+) = ? and kommentar.ben_regiso (+) = ? order by Benennung asc, Kommentar asc, Einsatz desc";
        }

        @Override
        public final String TL_SPRACHE_STMT_GEB() {
            return "and btzeilen_bildposnr = (select tlsb_bildnummer from w_tl_sprache_bnb where tlsb_iso = ? and tlsb_regiso = ?)";
        }

        @Override
        public final String TL_SPRACHE_STMT_UGB() {
            return "and btzeilenu_bildposnr = (select tlsb_bildnummer from w_tl_sprache_bnb where tlsb_iso = ? and tlsb_regiso = ?)";
        }
    }

    public static final class TeilevwdgFzg
    extends SQLStatements.TeilevwdgFzg {
        @Override
        public final String RETRIEVE_HGS() {
            return "select distinct tvs_hg HG from w_teileverwendungfzg_suche where tvs_mospid IN (&IN&) and tvs_hg >= ? &HGBIS_STMT& &DATSERIE_STMT& order by HG";
        }

        @Override
        public final String HG_BIS_STMT() {
            return " and tvs_hg <= ?";
        }

        @Override
        public final String HG_DAT_SERIE_STMT() {
            return " and tvs_einsatz_serie_max >= ?";
        }

        @Override
        public final String HG_LENKUNG_STMT() {
            return " and (tvs_lenkung = ? OR tvs_lenkung IS NULL)";
        }

        @Override
        public final String RETRIEVE_TEILE_OHNE_LENKUNG() {
            return "select distinct NeuesTeil.teil_hauptgr HG, NeuesTeil.teil_untergrup UG, NeuesTeil.teil_sachnr SACHNR, NeuesTeil.teil_alt SACHNRALT, NeuesTeil.teil_austausch_alt AT, AltesTeil.teil_hauptgr HGALT, AltesTeil.teil_untergrup UGALT, ben_text BENENNUNG, NeuesTeil.teil_benennzus ZUSATZ, NeuesTeil.teil_vorhanden_si SI, NeuesTeil.teil_lzb LZB, NeuesTeil.teil_kom_pi PI, NeuesTeil.teil_textcode_kom BENKOMMENTARID, NeuesTeil.teil_ist_reach REACH,  NeuesTeil.teil_ist_aspg ASPG,  NeuesTeil.teil_ist_stecker STECKER,  decode(NVL(tcp_sachnr, 'N'), tcp_sachnr, 'C', NULL) TC,  NeuesTeil.teil_ist_diebstahlrelevant Teil_Diebstahlrelevant  from w_btzeilen_verbauung inner join w_teil NeuesTeil on (btzeilenv_sachnr = NeuesTeil.teil_sachnr and NeuesTeil.teil_hauptgr = ?) inner join w_ben_gk on (NeuesTeil.teil_textcode = ben_textcode and ben_iso = ? and ben_regiso = ?) left join w_teil AltesTeil on (NeuesTeil.teil_alt = AltesTeil.teil_sachnr) left join w_tc_performance on (tcp_mospid in (&MOSPIDS&) and tcp_sachnr = NeuesTeil.teil_sachnr &TC_CHECK_LANDKUERZEL& and tcp_datum_von <= ? and (tcp_datum_bis is null or tcp_datum_bis >= ?)) where btzeilenv_mospid IN (&IN&) &DATSERIE_STMT& and btzeilenv_alter_kz is null order by HG, UG, SACHNR";
        }

        @Override
        public final String RETRIEVE_TEILE_MIT_LENKUNG() {
            return "select distinct NeuesTeil.teil_hauptgr HG, NeuesTeil.teil_untergrup UG, NeuesTeil.teil_sachnr SACHNR, NeuesTeil.teil_alt SACHNRALT, NeuesTeil.teil_austausch_alt AT, AltesTeil.teil_hauptgr HGALT, AltesTeil.teil_untergrup UGALT, ben_text BENENNUNG, NeuesTeil.teil_benennzus ZUSATZ, NeuesTeil.teil_vorhanden_si SI, NeuesTeil.teil_lzb LZB, NeuesTeil.teil_kom_pi PI, NeuesTeil.teil_textcode_kom BENKOMMENTARID,  NeuesTeil.teil_ist_reach REACH,  NeuesTeil.teil_ist_aspg ASPG,  NeuesTeil.teil_ist_stecker STECKER,  decode(NVL(tcp_sachnr, 'N'), tcp_sachnr, 'C', NULL) TC,  NeuesTeil.teil_ist_diebstahlrelevant Teil_Diebstahlrelevant  from w_btzeilen_verbauung inner join w_teil NeuesTeil on (btzeilenv_sachnr = NeuesTeil.teil_sachnr and NeuesTeil.teil_hauptgr = ?) inner join w_btzeilen on (btzeilenv_sachnr = btzeilen_sachnr and btzeilenv_btnr = btzeilen_btnr and btzeilenv_pos = btzeilen_pos and (btzeilen_lenkg = ? OR btzeilen_lenkg IS NULL)) inner join w_ben_gk on (NeuesTeil.teil_textcode = ben_textcode and ben_iso = ? and ben_regiso = ?) left join w_teil AltesTeil on (NeuesTeil.teil_alt = AltesTeil.teil_sachnr) left join w_tc_performance on (tcp_mospid in (&MOSPIDS&) and tcp_sachnr = NeuesTeil.teil_sachnr &TC_CHECK_LANDKUERZEL& and tcp_datum_von <= ? and (tcp_datum_bis is null or tcp_datum_bis >= ?)) where btzeilenv_mospid IN (&IN&) &DATSERIE_STMT& and btzeilenv_alter_kz is null order by HG, UG, SACHNR";
        }

        @Override
        public final String TEIL_DAT_SERIE_STMT() {
            return "and NEU.teil_einsatz_serie >= ?";
        }

        @Override
        public final String RETRIEVE_TEIL_ONLY_IN_OHNE_LENKUNG() {
            return "select count (*) ANZ from w_btzeilen_verbauung where btzeilenv_sachnr = ? and btzeilenv_mospid NOT IN (&IN&)";
        }

        @Override
        public final String RETRIEVE_TEIL_ONLY_IN_MIT_LENKUNG() {
            return "select count (*) ANZ from w_btzeilen_verbauung, w_btzeilen where btzeilen_sachnr = ? and (btzeilen_lenkg = ? OR btzeilen_lenkg IS NULL) and btzeilenv_btnr = btzeilen_btnr and btzeilenv_pos = btzeilen_pos and btzeilenv_sachnr = btzeilen_sachnr and btzeilenv_mospid NOT IN (&IN&)";
        }

        @Override
        public final String TC_CHECK_LANDKUERZEL() {
            return " and tcp_landkuerzel = ?";
        }
    }

    public static final class TeileverwendungReduziert
    extends SQLStatements.TeileverwendungReduziert {
        @Override
        public final String RETRIEVE_TEIL() {
            return "select teil_hauptgr HG, teil_untergrup UG, teil_sachnr Sachnummer, ben_text Ben, teil_benennzus Zusatz from w_ben_gk, w_teil where teil_sachnr = ? and ben_textcode = teil_textcode and ben_iso = ? and ben_regiso = ?";
        }

        @Override
        public final String RETRIEVE_VERWENDUNG() {
            return "select distinct BR.ben_text Baureihe, fztyp_erwvbez Modell, KAR.ben_text Karosserie, fztyp_ktlgausf Region from w_ben_gk BR, w_ben_gk KAR, w_baureihe, w_publben, w_fztyp, w_btzeilen_verbauung where btzeilenv_sachnr = ? and btzeilenv_mospid IN (&IN&) and fztyp_mospid = btzeilenv_mospid and fztyp_sichtschutz = ? and baureihe_baureihe = fztyp_baureihe and BR.ben_textcode = baureihe_textcode and BR.ben_iso = ? and BR.ben_regiso = ? and publben_art = ? and publben_bezeichnung = fztyp_karosserie and KAR.ben_textcode = publben_textcode and KAR.ben_iso = ? and KAR.ben_regiso = ? order by Baureihe, Modell, Karosserie, Region";
        }
    }

    public static final class VisualisierungTeil
    extends SQLStatements.VisualisierungTeil {
        @Override
        public final String RETRIEVE_VISUALISIERUNGSINFO_GEB() {
            return "select teil_hauptgr HG, teil_untergrup UG, teil_sachnr Sachnummer, t.ben_text Teilebenennung, teil_benennzus TeilebenennungZusatz, bildtaf_btnr BildtafelNummer, bt.ben_text BildtafelUeberschrift, btzeilen_bildposnr Bildnummer, bildtaf_grafikId GrafikId, grafik_format GrafikFormat, grafik_moddate GrafikTimestamp from w_grafik, w_baureihe, w_fztyp, w_ben_gk t, w_ben_gk bt, w_teil, w_bildtaf, w_btzeilen, w_btzeilen_verbauung where btzeilenv_sachnr = ? and fztyp_mospid = btzeilenv_mospid and baureihe_baureihe = fztyp_baureihe and baureihe_marke_tps in (&IN1&) and bildtaf_btnr = btzeilenv_btnr and bildtaf_produktart in (&IN2&) and teil_sachnr = btzeilenv_sachnr and btzeilen_btnr = btzeilenv_btnr and btzeilen_pos = btzeilenv_pos and t.ben_textcode = teil_textcode and t.ben_iso = ? and t.ben_regiso = ? and bt.ben_textcode = bildtaf_textc and bt.ben_iso = ? and bt.ben_regiso = ? and grafik_grafikid = bildtaf_grafikid and grafik_art = ? and ROWNUM = 1";
        }

        @Override
        public final String RETRIEVE_VISUALISIERUNGSINFO_UGB() {
            return "select teil_hauptgr HG, teil_untergrup UG, teil_sachnr Sachnummer, t.ben_text Teilebenennung, teil_benennzus TeilebenennungZusatz, bildtaf_btnr BildtafelNummer, bt.ben_text BildtafelUeberschrift, btzeilenu_bildposnr Bildnummer, bildtaf_grafikId GrafikId, grafik_format GrafikFormat, grafik_moddate GrafikTimestamp from w_grafik, w_ben_gk t, w_ben_gk bt, w_teil, w_bildtaf, w_btzeilenugb_verbauung, w_btzeilenugb where btzeilenu_sachnr = ? and btzeilenuv_btnr = btzeilenu_btnr and btzeilenuv_pos = btzeilenu_pos and btzeilenuv_marke_tps in (&IN1&) and bildtaf_btnr = btzeilenu_btnr and bildtaf_produktart in (&IN2&) and teil_sachnr = btzeilenu_sachnr and t.ben_textcode = teil_textcode and t.ben_iso = ? and t.ben_regiso = ? and bt.ben_textcode = bildtaf_textc and bt.ben_iso = ? and bt.ben_regiso = ? and grafik_grafikid = bildtaf_grafikid and grafik_art = ? and ROWNUM = 1";
        }
    }

    public static final class Teileersetzung
    extends SQLStatements.Teileersetzung {
        @Override
        public final String RETRIEVE_HGS() {
            return "select distinct tss_hg HG from w_teileersetzung_suche where tss_mospid IN (&IN&) and tss_hg >= ? &HGBIS_STMT& &LENKUNG_STMT& &DATSERIE_STMT& order by HG";
        }

        @Override
        public final String HG_BIS_STMT() {
            return "and tss_hg <= ?";
        }

        @Override
        public final String HG_LENKUNG_STMT() {
            return "and (tss_lenkung = ? OR tss_lenkung IS NULL)";
        }

        @Override
        public final String HG_DAT_SERIE_STMT() {
            return "and tss_einsatz_serie_max >= ?";
        }

        @Override
        public final String FIND_HG() {
            return "select distinct teil_hauptgr HG from w_teil where teil_hauptgr = ?";
        }

        @Override
        public final String RETRIEVE_TEILE() {
            return "select distinct NEU.teil_hauptgr HG,  NEU.teil_untergrup UG,  ts_sachnr SACHNR, NEU.teil_alt SACHNRALT, ALT.teil_hauptgr HGALT, ALT.teil_untergrup UGALT, NEU.teil_austausch_alt AT, ben_text BENENNUNG, NEU.teil_benennzus ZUSATZ, NEU.teil_vorhanden_si SI, NEU.teil_lzb LZB, NEU.teil_kom_pi PI, NEU.teil_textcode_kom BENKOMMENTARID, NEU.teil_ist_reach REACH,  NEU.teil_ist_aspg ASPG,  decode(NVL(tcp_sachnr, 'N'), tcp_sachnr, 'C', NULL) TC,  NEU.teil_ist_diebstahlrelevant Teil_Diebstahlrelevant  from w_teileersetzung inner join w_teil NEU on (ts_sachnr = NEU.teil_sachnr)      inner join w_teil ALT on (NEU.teil_alt = ALT.teil_sachnr)      inner join w_ben_gk on (NEU.teil_textcode = ben_textcode and ben_iso = ? and ben_regiso = ?)      left join w_tc_performance on (tcp_mospid in (&MOSPIDS&) and tcp_sachnr = ts_sachnr &TC_CHECK_LANDKUERZEL& and tcp_datum_von <= ? and (tcp_datum_bis is null or tcp_datum_bis >= ?)) where ts_hg = ? and ts_mospid IN (&IN&) &LENKUNG_STMT& &DATSERIE_STMT& order by HGALT, UGALT, SACHNRALT, HG, UG, SACHNR";
        }

        @Override
        public final String TEIL_DAT_SERIE_STMT() {
            return "and NEU.teil_einsatz_serie >= ?";
        }

        @Override
        public final String TEIL_LENKUNG_STMT() {
            return "and (ts_lenkung = ? OR ts_lenkung IS NULL)";
        }

        @Override
        public final String TC_CHECK_LANDKUERZEL() {
            return " and tcp_landkuerzel = ?";
        }
    }

    public static final class ValueLine
    extends SQLStatements.ValueLine {
        @Override
        public final String LOAD_HGS() {
            return "select distinct hgfg_hg HG, ben_text Benennung from w_kompl_satz, w_ben_gk, w_hgfg where ks_marke_tps = ? and ks_ist_valueline = ? and ks_produktart IN (?, ?) and hgfg_produktart = ? and ks_hg = hgfg_hg and hgfg_fg = ? and hgfg_textcode = ben_textcode and ben_iso = ? and ben_regiso = ? order by HG";
        }

        @Override
        public final String LOAD_SAETZE() {
            return "select distinct teil_hauptgr HG, teil_untergrup UG, teil_sachnr Sachnummer, ben_text Benennung, teil_benennzus Zusatz, teil_vorhanden_si vorhandenSI, teil_textcode_kom BenKommentarId, teil_ist_reach Reach,  teil_ist_aspg Aspg,  decode(teil_sachnr, tcp_sachnr, 'C', NULL) TC,  teil_ist_diebstahlrelevant Teil_Diebstahlrelevant  from w_kompl_satz inner join w_teil on (ks_sachnr_satz = teil_sachnr) inner join w_ben_gk on (teil_textcode = ben_textcode and ben_iso = ? and ben_regiso = ?) left join w_tc_performance_allg on (teil_sachnr = tcp_sachnr                                 and tcp_marke_tps = ?                                  and tcp_produktart = ?                                 and tcp_vbereich in (&IN&)                                 &TC_CHECK_LANDKUERZEL&                                 and tcp_datum_von <= ?                                 and (tcp_datum_bis is null or tcp_datum_bis <= ?)) where ks_marke_tps = ? and ks_produktart IN (?, ?) and ks_hg = ? and ks_ist_valueline = ? order by HG, UG, Sachnummer";
        }

        @Override
        public final String TC_CHECK_LANDKUERZEL() {
            return " and tcp_landkuerzel = ?";
        }

        @Override
        public final String LOAD_BTE_BAUREIHEN() {
            return "select distinct baureihe_baureihe BAUREIHE, ben_text EXT_BAUREIHE, baureihe_position POS from  w_hgfg, w_bildtaf, w_ben_gk, w_bildtaf_suche, w_baureihe, w_fztyp where hgfg_bereich = ? and hgfg_produktart = ? and hgfg_ist_valueline = ? and bildtaf_hg = hgfg_hg and bildtaf_fg = hgfg_fg and bildtafs_btnr = bildtaf_btnr and bildtafs_hg = bildtaf_hg and fztyp_mospid = bildtafs_mospid and fztyp_vbereich = ? and fztyp_sichtschutz = ? and fztyp_ktlgausf IN (&IN&) and baureihe_baureihe = fztyp_baureihe and baureihe_marke_tps = ? and baureihe_produktart = ? and ben_textcode = baureihe_textcode and ben_iso = ? and ben_regiso = ? order by POS";
        }

        @Override
        public final String LOAD_BILDTAFELN() {
            return "select distinct bildtaf_btnr BildtafelNr, B.ben_text Benennung, fztyp_erwvbez Modell, K.ben_text Karosserie, fztyp_karosserie KarosserieId, baureihe_bauart Bauart, fztyp_ktlgausf Region, bildtaf_kommbt Kommentar, bildtaf_vorh_cp CPVorhanden, bildtaf_bedkez BedingungKZ, bildtaf_pos Pos from  w_hgfg, w_bildtaf, w_ben_gk B, w_publben, w_ben_gk K, w_bildtaf_suche, w_baureihe, w_fztyp where hgfg_ist_valueline = ? and bildtaf_hg = hgfg_hg and bildtaf_fg = hgfg_fg and bildtafs_btnr = bildtaf_btnr and bildtafs_hg = bildtaf_hg and fztyp_mospid = bildtafs_mospid and fztyp_vbereich = ? and fztyp_sichtschutz = ? and fztyp_ktlgausf IN (&IN&) and baureihe_baureihe = ? and baureihe_baureihe = fztyp_baureihe and baureihe_marke_tps = ? and baureihe_produktart = ? and B.ben_textcode = bildtaf_textc and B.ben_iso = ? and B.ben_regiso = ? and publben_bezeichnung = fztyp_karosserie and publben_art = ? and K.ben_textcode = publben_textcode and K.ben_iso = ? and K.ben_regiso = ? order by Pos";
        }

        @Override
        public final String LOAD_TEILENUMMERN() {
            return "select distinct teil_hauptgr Hauptgruppe, teil_untergrup Untergruppe, teil_sachnr Sachnummer, ben_teil.ben_text Benennung, teil_benennzus Zusatz, ben_komm.ben_text Kommentar,  teil_ist_diebstahlrelevant Teil_Diebstahlrelevant  from w_teil_marken, w_teil  inner join  w_ben_gk ben_teil on (ben_textcode = teil_textcode and ben_teil.ben_iso = ? and ben_teil.ben_regiso = ?) left join w_ben_gk ben_komm on (ben_komm.ben_textcode = teil_textcode_kom  and ben_komm.ben_iso = ? and ben_komm.ben_regiso = ?) where teil_ist_valueline = ? and teil_sachnr = teilm_sachnr and teilm_marke_tps = ? and teil_verbaubar = ? and teil_produktart in (?, ?) order by Benennung, Hauptgruppe, Untergruppe, Sachnummer";
        }
    }

    public static final class Aspg
    extends SQLStatements.Aspg {
        @Override
        public final String LOAD_ASPG_TEILE() {
            return "select teilaspg_sachnr_pg, teilaspg_vmenge from w_teil_aspg where teilaspg_sachnr = ? and teilaspg_kz_gruppe = ? ";
        }

        @Override
        public final String LOAD_STECKER() {
            return "select teil_hauptgr, teil_untergrup, teilaspg_sachnr_pg, ben_text, teilaspg_vmenge, teil_benennzus, teil_technik, teil_entfall_kez, teil_ist_diebstahlrelevant from w_teil_aspg, w_teil, w_ben_gk where teilaspg_sachnr = ? and teilaspg_kz_gruppe= ? and teilaspg_sachnr_pg = teil_sachnr and teil_textcode = ben_textcode and ben_iso = ? and ben_regiso = ?";
        }
    }

    public static final class SatzEinzelteile
    extends SQLStatements.SatzEinzelteile {
        @Override
        public final String LOAD_HG() {
            return "select distinct hgfg_hg HG, ben_text Benennung from w_ben_gk, w_hgfg, w_kompl_satz where ks_marke_tps = ? and ks_produktart IN (?, ?) and hgfg_produktart = ? and hgfg_hg = ks_hg and hgfg_fg = ? and ben_textcode = hgfg_textcode and ben_iso = ? and ben_regiso = ? order by HG";
        }

        @Override
        public final String LOAD_SATZ() {
            return "select distinct teil_hauptgr HG, teil_untergrup UG, teil_sachnr Sachnummer, ben_text Benennung, teil_benennzus Zusatz, teil_vorhanden_si vorhandenSI, teil_textcode_kom BenKommentarId, teil_ist_reach Reach,  teil_ist_aspg Aspg,  teil_ist_diebstahlrelevant Teil_Diebstahlrelevant,  decode(teil_sachnr, tcp_sachnr, 'C', NULL) TC from w_kompl_satz inner join w_teil on (ks_sachnr_satz = teil_sachnr) inner join w_ben_gk on (teil_textcode = ben_textcode and ben_iso = ? and ben_regiso = ?) left join w_tc_performance_allg on (teil_sachnr = tcp_sachnr                                 and tcp_marke_tps = ?                                  and tcp_produktart = ?                                 and tcp_vbereich in (&IN&)                                 &TC_CHECK_LANDKUERZEL&                                 and tcp_datum_von <= ?                                 and (tcp_datum_bis is null or tcp_datum_bis <= ?)) where ks_marke_tps = ? and ks_produktart IN (?, ?) and ks_hg = ? order by HG, UG, Sachnummer";
        }

        @Override
        public final String COUNT_EINZELTEILE() {
            return "select count(ke_sachnr_einzelteil) Anzahl  from w_kompl_einzelteil where ke_sachnr_satz = '&SACHNUMMER&'";
        }

        @Override
        public final String LOAD_EINZELTEIL() {
            return "select distinct teil_hauptgr HG, teil_untergrup UG, teil_sachnr Sachnummer, ben_text Benennung, teil_benennzus Zusatz, ke_menge Menge, ke_beziehbar istBeziehbar, teil_vorhanden_si vorhandenSI, teil_textcode_kom BenKommentarId,  teil_ist_reach Reach,  teil_ist_aspg Aspg,  teil_ist_diebstahlrelevant Teil_Diebstahlrelevant,  decode(teil_sachnr, tcp_sachnr, 'C', NULL) TC, teil_ist_eba istEBA, ke_pos Pos from w_kompl_einzelteil inner join w_teil on (ke_sachnr_einzelteil = teil_sachnr)   inner join w_ben_gk on (teil_textcode = ben_textcode and ben_iso = ? and ben_regiso = ?)   left join w_tc_performance_allg on (teil_sachnr = tcp_sachnr                                   and tcp_marke_tps = ?                                    and tcp_produktart = ?                                   and tcp_vbereich in (&IN&)                                   &TC_CHECK_LANDKUERZEL&                                   and tcp_datum_von <= ?                                   and (tcp_datum_bis is null or tcp_datum_bis <= ?)) where ke_sachnr_satz = ?    and ke_marke_tps   = ?  order by Pos";
        }

        @Override
        public final String TC_CHECK_LANDKUERZEL() {
            return " and tcp_landkuerzel = ?";
        }
    }

    public static final class Interpretation
    extends SQLStatements.Interpretation {
        @Override
        public final String EXIST_SACHNUMMER_MARKE() {
            return "select distinct teilm_marke_tps Marke from w_teil_marken where teilm_sachnr = ? and teilm_marke_tps IN (&IN&)";
        }

        @Override
        public final String LOAD_INTERPRETATION_EINSTIEG() {
            return "select hist_sachnr Sachnummer, hist_zweig_nr ZweigNr, hist_struktur_nr StrukturNr from w_hist where hist_sachnr_h = ?";
        }

        @Override
        public final String LOAD_INTERPRETATION() {
            return "select teil_hauptgr Hg, teil_untergrup Ug, hist_sachnr_h Sachnummer, ben_text Benennung, teil_entfall_dat EntfallDatum, teil_bestellbar Bestellbar, teilm_marke_tps Marke, hist_zweig_nr ZweigNr, hist_struktur_nr StrukturNr from w_teil_marken, w_teil, w_ben_gk, w_hist where hist_sachnr = ? and teil_sachnr = hist_sachnr_h and ben_textcode = teil_textcode and ben_iso = ? and ben_regiso = ? and teilm_sachnr = teil_sachnr order by ZweigNr, StrukturNr";
        }
    }

    public static final class Polstercode
    extends SQLStatements.Polstercode {
        @Override
        public final String LOAD_POLSTERCODE() {
            return "select bedaflpc_art Art, bedaflpc_code Code, ben_text Benennung, bedaflpc_pcode PCode, bedaflpc_gilt_v GueltigVon, bedaflpc_gilt_b GueltigBis, bedaflpc_pos Pos from w_ben_gk, w_bed_aflpc where ben_textcode = bedaflpc_textcode and ben_iso = ? and ben_regiso = ?  order by Pos";
        }
    }

    public static final class TeilelisteJAVA_SAP
    extends SQLStatements.TeilelisteJAVA_SAP {
        @Override
        public final String LOAD_TEILELISTE_HIST() {
            return "nur fuer Transbase";
        }

        @Override
        public final String DELETE_TEILELISTE_HIST() {
            return "nur fuer Transbase";
        }

        @Override
        public final String INSERT_TEILELISTE_HIST() {
            return "nur fuer Transbase";
        }

        @Override
        public final String LOAD_NUTZERDATEN() {
            return "nur fuer Transbase";
        }

        @Override
        public final String INSERT_NUTZERDATEN() {
            return "nur fuer Transbase";
        }

        @Override
        public final String UPDATE_NUTZERDATEN() {
            return "nur fuer Transbase";
        }

        @Override
        public final String UPDATE_ID_IN_LISTEPOS() {
            return "nur fuer Transbase";
        }

        @Override
        public final String UPDATE_ID_IN_LISTEHIST() {
            return "nur fuer Transbase";
        }

        @Override
        public final String UPDATE_ID_IN_LISTE() {
            return "nur fuer Transbase";
        }
    }

    public static final class BTEInfo
    extends SQLStatements.BTEInfo {
        @Override
        public final String RETRIEVE_BTEINFO() {
            return "select ben.ben_text Ueberschrift from w_ben_gk ben, w_bildtaf where bildtaf_btnr = ? and bildtaf_produktart = ? and ben.ben_textcode = bildtaf_textc and ben.ben_iso = ? and  ben.ben_regiso = ?";
        }

        @Override
        public final String RETRIEVE_BTEKOMMENTAR() {
            return "select distinct komm_id KommId, ben_text Text, komm_code Code, komm_vz VZ, komm_darstellung Darstellung, komm_tiefe Tiefe, komm_pos Pos from w_ben_gk, w_komm, w_bildtaf where bildtaf_btnr = ? and komm_id = bildtaf_kommbt and ben_textcode = komm_textcode and ben_iso = ? and ben_regiso = ? order by KommId, Pos";
        }
    }

    public static final class TeilelisteHTML_SAP
    extends SQLStatements.TeilelisteHTML_SAP {
        @Override
        public final String LOAD_TEILELISTE_RR() {
            return "select teilelisterr_art Art, teilelisterr_status Status, teilelisterr_bestellnr Bestellnr, teilelisterr_gesamtpreis GesamtPreis, teilelisterr_saperror SapError from w_teileliste_rr where teilelisterr_id = ? and teilelisterr_user_id = ? and teilelisterr_abfrage_id = ?";
        }

        @Override
        public final String LOAD_TEILELISTE_POS_RR() {
            return "select teilelisteposrr_pos Pos, teilelisteposrr_sachnr Sachnr, teilelisteposrr_menge Menge, teilelisteposrr_preis Preis, teilelisteposrr_waehrung Waehrung, teilelisteposrr_kodierung Kodierung, teilelisteposrr_verfuegbar Verfuegbar, teilelisteposrr_hinweis Hinweis from w_teilelistepos_rr where teilelisteposrr_teileliste_id = ? and teilelisteposrr_user_id = ? and teilelisteposrr_abfrage_id = ?";
        }

        @Override
        public final String DELETE_TEILELISTE_RR() {
            return "delete from w_teileliste_rr where teilelisterr_id = '&ID&' and teilelisterr_user_id = '&NUTZER&'";
        }

        @Override
        public final String DELETE_TEILELISTEPOS_RR() {
            return "delete from w_teilelistepos_rr where teilelisteposrr_teileliste_id = '&ID&' and teilelisteposrr_user_id = '&NUTZER&'";
        }

        @Override
        public final String INSERT_TEILELISTE_RR() {
            return "insert into w_teileliste_rr ( teilelisterr_id, teilelisterr_user_id, teilelisterr_abfrage_id, teilelisterr_art, teilelisterr_status, teilelisterr_bestellnr, teilelisterr_gesamtpreis, teilelisterr_timestamp) values( '&ID&', '&NUTZER&', &ABFRAGEID&, '&ART&', '&STATUS&', NULL, NULL, SYSDATE)";
        }

        @Override
        public final String LOAD_TEILELISTE_HIST() {
            return "select TO_NUMBER(TO_CHAR(teilelistehist_datum,'YYYYMMDDHH24MI')) Datum, ben_text Funktion, teilelistehist_abfrage_id AbfragId from w_ben_gk, w_publben, w_teileliste_hist where teilelistehist_id = ? and teilelistehist_user_id = ? and publben_bezeichnung = teilelistehist_funktion and ben_textcode = publben_textcode and ben_iso = ? and ben_regiso = ? and publben_art = ? ORDER BY teilelistehist_datum DESC";
        }

        @Override
        public final String DELETE_TEILELISTE_HIST() {
            return "delete from w_teileliste_hist where teilelistehist_id = '&ID&' and teilelistehist_user_id = '&NUTZER&'";
        }

        @Override
        public final String INSERT_TEILELISTE_HIST() {
            return "insert into w_teileliste_hist ( teilelistehist_id, teilelistehist_user_id, teilelistehist_datum, teilelistehist_abfrage_id, teilelistehist_funktion) values( '&ID&', '&NUTZER&', SYSDATE, &ABFRAGEID&, '&FUNKTION&')";
        }

        @Override
        public final String GET_NEXT_ABFRAGE_SEQ_VAL() {
            return "select abfrageid_seq.nextval from dual";
        }
    }

    public static final class TeilelisteJAVA
    extends SQLStatements.TeilelisteJAVA {
        @Override
        public final String RETRIEVE_LISTEN_IDS() {
            return "select teileliste_marke Marke, teileliste_id ListeId from w_teileliste@etk_nutzer where teileliste_firma_id = ? and teileliste_filiale_id = ? and teileliste_user_id = ? and teileliste_marke IN (&IN&) and teileliste_gesperrt IS NULL and (teileliste_gesperrt_von IS NULL or teileliste_gesperrt_von = teileliste_user_id)";
        }

        @Override
        public final String RETRIEVE_BESTELLLISTEN_IDS() {
            return "select bestellliste_liste_id ListeId from w_bestellliste@etk_nutzer where bestellliste_firma_id = ? and bestellliste_filiale_id = ?";
        }

        @Override
        public final String RETRIEVE_UEBERSICHT() {
            return "select teileliste_id ListeId, teileliste_user_id UserId, user_name UserName, teileliste_filiale_id Filiale, teileliste_bemerkung Bemerkung, teileliste_erzeugt Erzeugt, NVL(teileliste_gesperrt, 'N') Gesperrt, teileliste_auftragsnr Auftragsnr, auftrag_kundennr Kundennr from w_teileliste@etk_nutzer left join w_auftrag@etk_nutzer on (teileliste_firma_id = auftrag_firma_id and teileliste_filiale_id = auftrag_filiale_id and teileliste_auftragsnr = auftrag_auftragsnr), w_user@etk_nutzer where teileliste_firma_id = ? and &FILTER& and user_id = teileliste_user_id and user_firma_id = teileliste_firma_id order by UserId, Gesperrt, Auftragsnr, Erzeugt DESC, ListeId";
        }

        @Override
        public final String FILTER_NUTZER() {
            return "teileliste_user_id = ?";
        }

        @Override
        public final String FILTER_FILIALE() {
            return "teileliste_filiale_id = ? and teileliste_user_id <> ? and teileliste_privat IS NULL";
        }

        @Override
        public final String FILTER_FIRMA() {
            return "(teileliste_user_id <> ? and teileliste_privat IS NULL)";
        }

        @Override
        public final String FILTER_FIRMA_MIT_PRIVAT() {
            return "(teileliste_user_id <> ?)";
        }

        @Override
        public final String RETRIEVE_UEBERSICHT_BESTELLLISTEN() {
            return "select bestellliste_liste_id ListeId, bestellliste_gesperrt_von GesperrtVon, bestellliste_gesperrt_am GesperrtAm from w_bestellliste@etk_nutzer where bestellliste_firma_id = ? and bestellliste_filiale_id = ? order by ListeId";
        }

        @Override
        public final String RETRIEVE_LISTE_ALLG() {
            return "select teileliste_bemerkung Bemerkung, teileliste_erzeugt Erzeugt, teileliste_geaendert Geaendert, teileliste_marke Marke, teileliste_auftragsnr Auftragsnr, teileliste_auftragsnr_lokal AuftragsnrLokal, teileliste_kundennr_lokal KundennrLokal, teileliste_privat Privat, teileliste_gesperrt_von GesperrtVon, teileliste_gesperrt_am GesperrtAm, auftrag_kundennr Kundennr, auftrag_kundenname Kundenname, auftrag_fgstnr FgStNr from w_teileliste@etk_nutzer left join w_auftrag@etk_nutzer on (teileliste_firma_id = auftrag_firma_id and teileliste_filiale_id = auftrag_filiale_id and teileliste_auftragsnr = auftrag_auftragsnr) where teileliste_firma_id = ? and teileliste_filiale_id = ? and teileliste_id = ? and teileliste_user_id = ?";
        }

        @Override
        public final String RETRIEVE_BESTELLLISTE_ALLG() {
            return "select bestellliste_gesperrt_von GesperrtVon, bestellliste_gesperrt_am GesperrtAm from w_bestellliste@etk_nutzer where bestellliste_firma_id = ? and bestellliste_filiale_id = ? and bestellliste_liste_id = ?";
        }

        @Override
        public final String RETRIEVE_LISTE_POS() {
            return "select teilelistepos_sachnr SachNr, teilelistepos_hgug HgUg, teilelistepos_position Pos, teilelistepos_menge Menge, teilelistepos_bemerkung Bemerkung, teilelistepos_benennung Benennung, teilelistepos_zusatz Zusatz, teilelistepos_lagerbestand Lagerbestand, teilelistepos_minimalbestand Minimalbestand, teilelistepos_bedarfshinweis Bedarfshinweis, teilelistepos_lagerort Lagerort, teilelistepos_aume AuMe, teilelistepos_preis Preis, teilelistepos_rabatt Rabatt, teilelistepos_split Splitt, teilelistepos_transparenz Transparenz, teilelistepos_suffix Suffix, teilelistepos_dispocode Dispocode, teilelistepos_ruecksendepfl Ruecksendepflicht, teilelistepos_mwst MwSt, teilelistepos_altteil_steuer AltteilSteuer, teilelistepos_lokalteil Lokalteil, teilm_marke_tps Marke, teil_art Teileart, teil_produktkl ProduktKlasse, teil_mam MAM, teil_mengeeinh Mengeneinheit, NVL(teil_vorverpac, 0) VVM, NVL(teil_lagerverp, 0) LVM, NVL(teil_beh_verp, 0) BVM, teileinfo_sachnr SachnrMitNotiz from w_teilelistepos@etk_nutzer left join w_teileinfo@etk_nutzer on (teilelistepos_sachnr = teileinfo_sachnr and (teilelistepos_user_id = teileinfo_user_id OR teileinfo_allgemein = 'J') and teileinfo_firma_id = teilelistepos_firma_id) left join w_teil@etk_publ on (teilelistepos_sachnr = teil_sachnr) inner join w_teil_marken@etk_publ on (teil_sachnr = teilm_sachnr) where teilelistepos_firma_id = '&FIRMA&' and teilelistepos_filiale_id = '&FILIALE&' and teilelistepos_teileliste_id = '&ID&' and teilelistepos_user_id = '&NUTZER&' and NVL(teilelistepos_lokalteil, 'N') = 'N' union select teilelistepos_sachnr SachNr, teilelistepos_hgug HgUg, teilelistepos_position Pos, teilelistepos_menge Menge, teilelistepos_bemerkung Bemerkung, teilelistepos_benennung Benennung, teilelistepos_zusatz Zusatz, teilelistepos_lagerbestand Lagerbestand, teilelistepos_minimalbestand Minimalbestand, teilelistepos_bedarfshinweis Bedarfshinweis, teilelistepos_lagerort Lagerort, teilelistepos_aume AuMe, teilelistepos_preis Preis, teilelistepos_rabatt Rabatt, teilelistepos_split Splitt, teilelistepos_transparenz Transparenz, teilelistepos_suffix Suffix, teilelistepos_dispocode Dispocode, teilelistepos_ruecksendepfl Ruecksendepflicht, teilelistepos_mwst MwSt, teilelistepos_altteil_steuer AltteilSteuer, teilelistepos_lokalteil Lokalteil, '' Marke, '' Teileart, null ProduktKlasse, 0  MAM, '' Mengeneinheit, 0 VVM, 0 LVM, 0 BVM, null SachnrMitNotiz from w_teilelistepos@etk_nutzer where teilelistepos_firma_id = '&FIRMA&' and teilelistepos_filiale_id = '&FILIALE&' and teilelistepos_teileliste_id = '&ID&' and teilelistepos_user_id = '&NUTZER&' and teilelistepos_lokalteil = 'J' order by 3";
        }

        @Override
        public final String RETRIEVE_MAX_POS() {
            return "select max (teilelistepos_position) Pos from w_teilelistepos@etk_nutzer where teilelistepos_firma_id = ? and teilelistepos_filiale_id = ? and teilelistepos_teileliste_id = ? and teilelistepos_user_id = ?";
        }

        @Override
        public final String RETRIEVE_BESTELLLISTE_POS() {
            return "select bestelllistepos_sachnr SachNr, bestelllistepos_hgug HgUg, bestelllistepos_position Pos, bestelllistepos_menge Menge, bestelllistepos_bemerkung Bemerkung, bestelllistepos_benennung Benennung, bestelllistepos_zusatz Zusatz, bestelllistepos_lagerbestand Lagerbestand, bestelllistepos_minimalbestand Minimalbestand, bestelllistepos_bedarfshinweis Bedarfshinweis, bestelllistepos_lagerort Lagerort, bestelllistepos_aume AuMe, bestelllistepos_auftragsnr AuftragsNr, bestelllistepos_kundennr KundenNr, bestelllistepos_lokalteil Lokalteil from w_bestelllistepos@etk_nutzer where bestelllistepos_firma_id = ? and bestelllistepos_filiale_id = ? and bestelllistepos_liste_id = ? order by Pos";
        }

        @Override
        public final String RETRIEVE_TEIL_PREISE() {
            return "select NVL(preise_evpreis, 0) EVP, NVL(preise_nachbelastung, 0) Nachbelastung, preise_rabattschluessel RabattSchluessel, preise_preisaenderung Preisanederung, preise_preis_kz PreisKz, NVL(preise_sonderpreis, 0) SNP, preise_sonderpreis_kz SNPKz, preise_mwst MwSt, preise_mwst_code MwStCode, preise_zolltarifnr ZolltarifNr, NVL(preise_nettopreis, 0) NettoPreis from w_preise@etk_preise where preise_sachnr = ? and preise_firma = ?";
        }

        @Override
        public final String RETRIEVE_TEILELISTE_PREISE() {
            return "select teilelistepos_sachnr Sachnummer_TL, teilelistepos_position Pos, preise_sachnr Sachnummer_Preis, NVL(preise_evpreis, 0) EVP, NVL(preise_nachbelastung, 0) Nachbelastung, preise_rabattschluessel RabattSchluessel, preise_preisaenderung Preisanederung, preise_preis_kz PreisKz, NVL(preise_sonderpreis, 0) SNP, preise_sonderpreis_kz SNPKz, preise_mwst MwSt, preise_mwst_code MwStCode, preise_zolltarifnr ZolltarifNr, NVL(preise_nettopreis, 0) NettoPreis from w_teilelistepos@etk_nutzer left join w_preise@etk_preise on (teilelistepos_sachnr = preise_sachnr and teilelistepos_firma_id = preise_firma) where teilelistepos_firma_id = ? and teilelistepos_filiale_id = ? and teilelistepos_teileliste_id = ? and teilelistepos_user_id = ? order by teilelistepos_position";
        }

        @Override
        public final String RETRIEVE_TEILELISTE_PUBLDATEN() {
            return "select teil_hauptgr Hg, teil_untergrup Ug, teilelistepos_sachnr Sachnummer_TL, ben_text Benennung, teil_benennzus Zusatz, teilelistepos_position Pos, teil_sachnr Sachnummer_Publdaten, teilm_marke_tps Marke, teil_art Teileart, teil_produktkl ProduktKlasse, teil_mam MAM, teil_mengeeinh Mengeneinheit, NVL(teil_vorverpac, 0) VVM, NVL(teil_lagerverp, 0) LVM, NVL(teil_beh_verp, 0) BVM from w_teilelistepos@etk_nutzer left join w_teil@etk_publ on (teilelistepos_sachnr = teil_sachnr) left join w_ben_gk@etk_publ on (teil_textcode = ben_textcode and  ben_iso = ? and ben_regiso = ?) inner join w_teil_marken@etk_publ on (teil_sachnr = teilm_sachnr) where teilelistepos_firma_id = ? and teilelistepos_filiale_id = ? and teilelistepos_teileliste_id = ? and teilelistepos_user_id = ? order by teilelistepos_position";
        }

        @Override
        public final String DELETE() {
            return "delete from w_teileliste@etk_nutzer where teileliste_firma_id = '&FIRMA&' and teileliste_filiale_id = '&FILIALE&' and teileliste_id = '&ID&' and teileliste_user_id = '&NUTZER&'";
        }

        @Override
        public final String DELETE_POS() {
            return "delete from w_teilelistepos@etk_nutzer where teilelistepos_firma_id = '&FIRMA&' and teilelistepos_filiale_id = '&FILIALE&' and teilelistepos_teileliste_id = '&ID&' and teilelistepos_user_id = '&NUTZER&'";
        }

        @Override
        public final String INSERT_BESTELLLISTE() {
            return "insert into w_bestellliste@etk_nutzer (bestellliste_firma_id, bestellliste_filiale_id, bestellliste_liste_id) values ('&FIRMAID&', '&FILIALID&', '&ID&')";
        }

        @Override
        public final String DELETE_JOBS() {
            return "delete from w_teileliste_job@etk_nutzer where teilelistejob_firma_id = '&FIRMA&' and teilelistejob_filiale_id = '&FILIALE&' and teilelistejob_teileliste_id = '&ID&' and teilelistejob_user_id = '&NUTZER&'";
        }

        @Override
        public final String DELETE_SRPS() {
            return "delete from w_teileliste_srp@etk_nutzer where teilelistesrp_firma_id = '&FIRMA&' and teilelistesrp_filiale_id = '&FILIALE&' and teilelistesrp_teileliste_id = '&ID&' and teilelistesrp_user_id = '&NUTZER&'";
        }

        @Override
        public final String UPDATE_POS() {
            return "update w_teilelistepos@etk_nutzer set teilelistepos_position = teilelistepos_position  - 1 where teilelistepos_firma_id = '&FIRMA&' and teilelistepos_filiale_id = '&FILIALE&' and teilelistepos_teileliste_id = '&ID&' and teilelistepos_user_id = '&NUTZER&' and teilelistepos_position > &POS&";
        }

        @Override
        public final String UPDATE_BESTELL_POS() {
            return "update w_bestelllistepos@etk_nutzer set bestelllistepos_position = bestelllistepos_position  - 1 where bestelllistepos_firma_id = '&FIRMA&' and bestelllistepos_filiale_id = '&FILIALE&' and bestelllistepos_liste_id = '&ID&' and bestelllistepos_position > &POS&";
        }

        @Override
        public final String DELETE_BESTELLLISTE_POS() {
            return "delete from  w_bestelllistepos@etk_nutzer where bestelllistepos_firma_id = '&FIRMA&' and bestelllistepos_filiale_id = '&FILIALE&' and bestelllistepos_liste_id = '&ID&'";
        }

        @Override
        public final String DELETE_SINGLE_POS() {
            return "delete from w_teilelistepos@etk_nutzer where teilelistepos_firma_id = '&FIRMA&' and teilelistepos_filiale_id = '&FILIALE&' and teilelistepos_teileliste_id = '&ID&' and teilelistepos_user_id = '&NUTZER&' and teilelistepos_position = &POS&";
        }

        @Override
        public final String DELETE_BESTELLLISTE_SINGLE_POS() {
            return "delete from w_bestelllistepos@etk_nutzer where bestelllistepos_firma_id = '&FIRMA&' and bestelllistepos_filiale_id = '&FILIALE&' and bestelllistepos_liste_id = '&ID&' and bestelllistepos_position = &POS&";
        }

        @Override
        public final String INSERT_LISTE_ALLG() {
            return "insert into w_teileliste@etk_nutzer (teileliste_firma_id, teileliste_filiale_id, teileliste_id, teileliste_user_id, teileliste_bemerkung, teileliste_erzeugt, teileliste_geaendert, teileliste_marke, teileliste_auftragsnr, teileliste_auftragsnr_lokal, teileliste_kundennr_lokal, teileliste_privat, teileliste_gesperrt) values ('&FIRMA&', '&FILIALE&', '&ID&', '&NUTZER&', '&BEMERKUNG&', &ERZEUGT&, &GEAENDERT&, '&MARKE&', &AUFTRAGSNR&, &AUFTRAGSNRLOKAL&, &KUNDENNRLOKAL&, &PRIVAT&, &GESPERRT&)";
        }

        @Override
        public final String COPY_LISTE_ALLG() {
            return "insert into w_teileliste@etk_nutzer (teileliste_firma_id, teileliste_filiale_id, teileliste_id, teileliste_user_id, teileliste_bemerkung, teileliste_erzeugt, teileliste_geaendert, teileliste_marke, teileliste_auftragsnr, teileliste_auftragsnr_lokal, teileliste_kundennr_lokal, teileliste_privat, teileliste_gesperrt) (select teileliste_firma_id, '&NEWFILIALE&', '&NEWID&', '&NEWNUTZER&', teileliste_bemerkung, teileliste_erzeugt, teileliste_geaendert, teileliste_marke, teileliste_auftragsnr, teileliste_auftragsnr_lokal, teileliste_kundennr_lokal, teileliste_privat, teileliste_gesperrt from w_teileliste@etk_nutzer where teileliste_id = '&OLDID&' and teileliste_user_id = '&OLDNUTZER&' and teileliste_firma_id = '&FIRMA&' and teileliste_filiale_id = '&OLDFILIALE&')";
        }

        @Override
        public final String UPDATE_LISTE_ALLG() {
            return "update w_teileliste@etk_nutzer set teileliste_bemerkung = '&BEMERKUNG&', teileliste_erzeugt = &ERZEUGT&, teileliste_geaendert = &GEAENDERT&, teileliste_marke = '&MARKE&', teileliste_auftragsnr = &AUFTRAGSNR&, teileliste_auftragsnr_lokal = &AUFTRAGSNRLOKAL&, teileliste_kundennr_lokal = &KUNDENNRLOKAL&, teileliste_privat = &PRIVAT& where teileliste_id = '&ID&' and teileliste_user_id = '&NUTZER&' and teileliste_firma_id = '&FIRMA&' and teileliste_filiale_id = '&FILIALE&'";
        }

        @Override
        public final String UPDATE_LISTE_AENDER_DAT() {
            return "update w_teileliste@etk_nutzer set teileliste_geaendert = &GEAENDERT& where teileliste_id = '&ID&' and teileliste_user_id = '&NUTZER&' and teileliste_firma_id = '&FIRMA&' and teileliste_filiale_id = '&FILIALE&'";
        }

        @Override
        public final String UPDATE_LISTE_SPERRE() {
            return "update w_teileliste@etk_nutzer set teileliste_gesperrt = &GESPERRT& where teileliste_id = '&ID&' and teileliste_user_id = '&NUTZER&' and teileliste_firma_id = '&FIRMA&' and teileliste_filiale_id = '&FILIALE&'";
        }

        @Override
        public final String RETRIEVE_LISTE_SPERRE() {
            return "select teileliste_gesperrt_von GesperrtVon, teileliste_gesperrt_am GesperrtAm, teileliste_gesperrt Gesperrt from w_teileliste@etk_nutzer where teileliste_id = ? and teileliste_user_id = ? and teileliste_firma_id = ? and teileliste_filiale_id = ?";
        }

        @Override
        public final String RETRIEVE_LISTE_SPERRE_FOR_UPDATE() {
            return this.RETRIEVE_LISTE_SPERRE() + " for update";
        }

        @Override
        public final String UPDATE_LISTE_SPERRE_NUTZER() {
            return " update w_teileliste@etk_nutzer set teileliste_gesperrt_von = &NUTZER&, teileliste_gesperrt_am = &SPERRE_DAT& where teileliste_id = '&ID&' and teileliste_user_id = '&LISTE_NUTZER&' and teileliste_firma_id = '&FIRMA&' and teileliste_filiale_id = '&FILIALE&'";
        }

        @Override
        public final String INSERT_SENDE_INFO() {
            return "insert into w_teileliste_sendeinfo@etk_nutzer (teilelistesi_teileliste_id, teilelistesi_user_id, teilelistesi_firma_id, teilelistesi_filiale_id, teilelistesi_satzart, teilelistesi_auftragsnr, teilelistesi_kundennr, teilelistesi_mitarbeiternr, teilelistesi_greiferschein, teilelistesi_rechnung, teilelistesi_lieferschein, teilelistesi_freitext, teilelistesi_passwort, teilelistesi_sondersteuerung, teilelistesi_gegeben_bar, teilelistesi_gegeben_unbar) values ('&ID&', '&NUTZER&', '&FIRMA&', '&FILIALE&', '&SATZART&', &AUFTRAGSNR&, &KUNDENNR&, &MITARBEITERNR&, &GREIFERSCHEIN&, &RECHNUNG&, &LIEFERSCHEIN&, &FREITEXT&, &PASSWORT&, &SONDERSTEUERUNG&, &BAR&, &UNBAR&)";
        }

        @Override
        public final String DELETE_SENDE_INFO() {
            return "delete from w_teileliste_sendeinfo@etk_nutzer where teilelistesi_teileliste_id = '&ID&' and teilelistesi_user_id = '&NUTZER&' and teilelistesi_firma_id = '&FIRMA&' and teilelistesi_filiale_id = '&FILIALE&'";
        }

        @Override
        public final String RETRIEVE_SENDE_INFO() {
            return "select teilelistesi_satzart Satzart, teilelistesi_auftragsnr AuftragsNr, teilelistesi_kundennr KundenNr, teilelistesi_mitarbeiternr MitarbeiterNr, teilelistesi_greiferschein Greiferschein, teilelistesi_rechnung Rechnung, teilelistesi_lieferschein Lieferschein, teilelistesi_freitext Freitext, teilelistesi_passwort Passwort, teilelistesi_sondersteuerung Sondersteuerung, teilelistesi_gegeben_bar Bar, teilelistesi_gegeben_unbar Unbar from w_teileliste_sendeinfo@etk_nutzer where teilelistesi_teileliste_id = ? and teilelistesi_user_id = ? and teilelistesi_firma_id = ? and teilelistesi_filiale_id = ?";
        }

        @Override
        public final String RETRIEVE_BESTELLLISTE_SPERRE_FOR_UPDATE() {
            return "select bestellliste_gesperrt_von GesperrtVon, bestellliste_gesperrt_am GesperrtAm from w_bestellliste@etk_nutzer where bestellliste_firma_id = ? and bestellliste_filiale_id = ? and bestellliste_liste_id = ? for update";
        }

        @Override
        public final String UPDATE_BESTELLLISTE_SPERRE() {
            return " update w_bestellliste@etk_nutzer set bestellliste_gesperrt_von = &NUTZER&, bestellliste_gesperrt_am = &SPERRE_DAT& where bestellliste_liste_id = '&ID&' and bestellliste_firma_id = '&FIRMA&' and bestellliste_filiale_id = '&FILIALE&'";
        }

        @Override
        public final String INSERT_LISTE_POS() {
            return "insert into w_teilelistepos@etk_nutzer (teilelistepos_firma_id, teilelistepos_filiale_id, teilelistepos_teileliste_id, teilelistepos_user_id, teilelistepos_position, teilelistepos_hgug, teilelistepos_sachnr, teilelistepos_benennung, teilelistepos_zusatz, teilelistepos_menge, teilelistepos_lagerbestand, teilelistepos_minimalbestand, teilelistepos_bedarfshinweis, teilelistepos_lagerort, teilelistepos_aume, teilelistepos_preis, teilelistepos_rabatt, teilelistepos_split, teilelistepos_transparenz, teilelistepos_suffix, teilelistepos_dispocode, teilelistepos_ruecksendepfl, teilelistepos_mwst, teilelistepos_altteil_steuer, teilelistepos_lokalteil, teilelistepos_bemerkung) values ('&FIRMA&', '&FILIALE&', '&ID&', '&NUTZER&', &POS&, '&HGUG&', '&SACHNR&', '&BENENNUNG&', '&ZUSATZ&', &MENGE&, &LAGERBESTAND&, &MINIMALBESTAND&, &BEDARFSHINWEIS&, '&LAGERORT&', &AUME&, &PREIS&, &RABATT&, '&SPLIT&', '&TRANSPARENZ&', '&SUFFIX&', '&DISPO&', '&RUECKSENDEPFLICHT&', &MWST&, &ATST&, &LOKALTEIL&, '&BEMERKUNG&')";
        }

        @Override
        public final String COPY_LISTE_POSITIONEN() {
            return "insert into w_teilelistepos@etk_nutzer (teilelistepos_firma_id, teilelistepos_filiale_id, teilelistepos_teileliste_id, teilelistepos_user_id, teilelistepos_position, teilelistepos_hgug, teilelistepos_sachnr, teilelistepos_benennung, teilelistepos_zusatz, teilelistepos_menge, teilelistepos_lagerbestand, teilelistepos_minimalbestand, teilelistepos_bedarfshinweis, teilelistepos_lagerort, teilelistepos_aume, teilelistepos_preis, teilelistepos_rabatt, teilelistepos_split, teilelistepos_transparenz, teilelistepos_suffix, teilelistepos_dispocode, teilelistepos_ruecksendepfl, teilelistepos_mwst, teilelistepos_altteil_steuer, teilelistepos_lokalteil, teilelistepos_bemerkung) (select teilelistepos_firma_id, '&NEWFILIALE&', '&NEWID&', '&NEWNUTZER&', teilelistepos_position, teilelistepos_hgug, teilelistepos_sachnr, teilelistepos_benennung, teilelistepos_zusatz, teilelistepos_menge, teilelistepos_lagerbestand, teilelistepos_minimalbestand, teilelistepos_bedarfshinweis, teilelistepos_lagerort, teilelistepos_aume, teilelistepos_preis, teilelistepos_rabatt, teilelistepos_split, teilelistepos_transparenz, teilelistepos_suffix, teilelistepos_dispocode, teilelistepos_ruecksendepfl, teilelistepos_mwst, teilelistepos_altteil_steuer, teilelistepos_lokalteil, teilelistepos_bemerkung from w_teilelistepos@etk_nutzer where teilelistepos_firma_id = '&FIRMA&' and teilelistepos_filiale_id = '&OLDFILIALE&' and teilelistepos_user_id = '&OLDNUTZER&' and teilelistepos_teileliste_id = '&OLDID&')";
        }

        @Override
        public final String INSERT_BESTELLLISTE_POS() {
            return "insert into w_bestelllistepos@etk_nutzer (bestelllistepos_firma_id, bestelllistepos_filiale_id, bestelllistepos_liste_id, bestelllistepos_position, bestelllistepos_hgug, bestelllistepos_sachnr, bestelllistepos_benennung, bestelllistepos_zusatz, bestelllistepos_menge, bestelllistepos_lagerbestand, bestelllistepos_minimalbestand, bestelllistepos_bedarfshinweis, bestelllistepos_lagerort, bestelllistepos_aume, bestelllistepos_auftragsnr, bestelllistepos_kundennr, bestelllistepos_lokalteil, bestelllistepos_bemerkung) values ('&FIRMA&', '&FILIALE&', '&ID&', &POS&, '&HGUG&', '&SACHNR&', '&BENENNUNG&', '&ZUSATZ&', &MENGE&, &LAGERBESTAND&, &MINIMALBESTAND&, &BEDARFSHINWEIS&, '&LAGERORT&', &AUME&, &AUFTRAGSNR&, &KUNDENNR&, &LOKALTEIL&, '&BEMERKUNG&')";
        }

        @Override
        public final String RETRIEVE_COUNT_BESTELLLISTEPOS() {
            return "select count(*) from w_bestelllistepos@etk_nutzer where bestelllistepos_firma_id = '&FIRMA&' and bestelllistepos_filiale_id = '&FILIALE&' and bestelllistepos_liste_id = '&ID&'";
        }

        @Override
        public final String UPDATE_LISTE_POS() {
            return "update w_teilelistepos@etk_nutzer set teilelistepos_hgug = '&HGUG&', teilelistepos_sachnr = '&SACHNR&', teilelistepos_benennung = '&BENENNUNG&', teilelistepos_zusatz = '&ZUSATZ&', teilelistepos_menge = &MENGE&, teilelistepos_lagerbestand = &LAGERBESTAND&, teilelistepos_minimalbestand = &MINIMALBESTAND&, teilelistepos_bedarfshinweis = &BEDARFSHINWEIS&, teilelistepos_lagerort = '&LAGERORT&', teilelistepos_aume = &AUME&, teilelistepos_preis = &PREIS&, teilelistepos_rabatt = &RABATT&, teilelistepos_split = '&SPLIT&', teilelistepos_transparenz = '&TRANSPARENZ&', teilelistepos_suffix = '&SUFFIX&', teilelistepos_dispocode = '&DISPO&', teilelistepos_ruecksendepfl = '&RUECKSENDEPFLICHT&', teilelistepos_mwst = &MWST&, teilelistepos_altteil_steuer = &ATST&, teilelistepos_lokalteil = &LOKALTEIL&, teilelistepos_bemerkung = '&BEMERKUNG&' where teilelistepos_firma_id = '&FIRMA&' and teilelistepos_filiale_id = '&FILIALE&' and teilelistepos_user_id = '&NUTZER&' and teilelistepos_teileliste_id = '&ID&' and teilelistepos_position = &POS&";
        }

        @Override
        public final String UPDATE_SCORELISTE_POS_STATUS() {
            return "update w_teilelistepos@etk_nutzer set teilelistepos_status = &STATUS& where teilelistepos_firma_id = '&FIRMA&' and teilelistepos_filiale_id = '&FILIALE&' and teilelistepos_user_id = '&NUTZER&' and teilelistepos_teileliste_id = '&ID&' and teilelistepos_position = &POS&";
        }

        @Override
        public final String UPDATE_BESTELLLISTE_POS() {
            return "update w_bestelllistepos@etk_nutzer set bestelllistepos_hgug = '&HGUG&', bestelllistepos_sachnr = '&SACHNR&', bestelllistepos_benennung = '&BENENNUNG&', bestelllistepos_zusatz = '&ZUSATZ&', bestelllistepos_menge = &MENGE&, bestelllistepos_lagerbestand = &LAGERBESTAND&, bestelllistepos_minimalbestand = &MINIMALBESTAND&, bestelllistepos_bedarfshinweis = &BEDARFSHINWEIS&, bestelllistepos_lagerort = '&LAGERORT&', bestelllistepos_aume = &AUME&, bestelllistepos_auftragsnr = &AUFTRAGSNR&, bestelllistepos_kundennr = &KUNDENNR&, bestelllistepos_lokalteil = &LOKALTEIL&, bestelllistepos_bemerkung = '&BEMERKUNG&' where bestelllistepos_firma_id = '&FIRMA&' and bestelllistepos_filiale_id = '&FILIALE&' and bestelllistepos_liste_id = '&ID&' and bestelllistepos_position = &POS&";
        }

        @Override
        public final String GET_TEILELISTE_ZU_AUFTRAG() {
            return "select teileliste_id TeilelisteId, teileliste_user_id EigentuemerId, teileliste_gesperrt Gesperrt, auftrag_kundennr Kundennummer, auftrag_kundenname Kundenname, auftrag_fgstnr Fahrgestellnummer, auftrag_auftragsnr Auftragsnummer from w_teileliste@etk_nutzer left join w_auftrag@etk_nutzer on (teileliste_firma_id = auftrag_firma_id and  teileliste_filiale_id = auftrag_filiale_id and teileliste_auftragsnr = auftrag_auftragsnr) where teileliste_firma_id = ? and teileliste_filiale_id = ? and teileliste_id = ?";
        }

        @Override
        public final String INSERT_AUFTRAG() {
            return "insert into w_auftrag@etk_nutzer (auftrag_firma_id, auftrag_filiale_id, auftrag_auftragsnr, auftrag_kundennr, auftrag_kundenname, auftrag_fgstnr) values ('&FIRMA&', '&FILIALE&', '&AUFTRAGSNUMMER&', &KUNDENNUMMER&, &KUNDENNAME&, &FGSTNR&)";
        }

        @Override
        public final String UPDATE_AUFTRAG() {
            return "update w_auftrag@etk_nutzer  set auftrag_kundennr = &KUNDENNUMMER&, auftrag_kundenname = &KUNDENNAME&, auftrag_fgstnr = &FGSTNR& where auftrag_firma_id = '&FIRMA&' and auftrag_filiale_id = '&FILIALE&' and auftrag_auftragsnr = '&AUFTRAGSNUMMER&'";
        }

        @Override
        public final String DELETE_AUFTRAG() {
            return "delete from w_auftrag@etk_nutzer where auftrag_firma_id = '&FIRMA&' and   auftrag_filiale_id = '&FILIALE&' and   auftrag_auftragsnr = '&AUFTRAGSNUMMER&'";
        }

        @Override
        public final String UPDATE_EIGENTUEMER() {
            return " update w_teileliste@etk_nutzer set teileliste_user_id = '&NEWNUTZER&' where teileliste_id = '&ID&' and teileliste_user_id = '&NUTZER&' and teileliste_firma_id = '&FIRMA&' and teileliste_filiale_id = '&FILIALE&'";
        }

        @Override
        public final String UPDATE_EIGENTUEMER_POS() {
            return " update w_teilelistepos@etk_nutzer set teilelistepos_user_id = '&NEWNUTZER&' where teilelistepos_teileliste_id = '&ID&' and teilelistepos_user_id = '&NUTZER&' and teilelistepos_firma_id = '&FIRMA&' and teilelistepos_filiale_id = '&FILIALE&'";
        }

        @Override
        public final String INSERT_JOB() {
            return "insert into w_teileliste_job@etk_nutzer (teilelistejob_firma_id, teilelistejob_filiale_id, teilelistejob_teileliste_id, teilelistejob_user_id, teilelistejob_job_id, teilelistejob_job_ben) values ('&FIRMA&', '&FILIALE&', '&ID&', '&NUTZER&', '&JOBID&', '&JOBBEN&')";
        }

        @Override
        public final String INSERT_SRP() {
            return "insert into w_teileliste_srp@etk_nutzer (teilelistesrp_firma_id, teilelistesrp_filiale_id, teilelistesrp_teileliste_id, teilelistesrp_user_id, teilelistesrp_srp_id, teilelistesrp_srp_ben) values ('&FIRMA&', '&FILIALE&', '&ID&', '&NUTZER&', '&SRPID&', '&SRPBEN&')";
        }

        @Override
        public final String RETRIEVE_JOBS() {
            return "select teilelistejob_job_id id, teilelistejob_job_ben ben from w_teileliste_job@etk_nutzer WHERE teilelistejob_firma_id = ? and teilelistejob_filiale_id = ? and teilelistejob_teileliste_id = ? and teilelistejob_user_id = ?";
        }

        @Override
        public final String RETRIEVE_SRPS() {
            return "select teilelistesrp_srp_id id, teilelistesrp_srp_ben ben from w_teileliste_srp@etk_nutzer WHERE teilelistesrp_firma_id = ? and teilelistesrp_filiale_id = ? and teilelistesrp_teileliste_id = ? and teilelistesrp_user_id = ?";
        }

        @Override
        public final String GET_NEXT_ID_SEQ_VAL() {
            return " select teileliste_id_seq.nextval from teileliste_id_seq";
        }

        @Override
        public final String GET_NEXT_SCOREID_SEQ_VAL() {
            return " select teileliste_score_id_seq.nextval from dual";
        }

        @Override
        public final String GET_NEXT_RRSAPID_SEQ_VAL() {
            return "nur fuer Transbase";
        }

        @Override
        public final String GET_RELEASED_SCORE_LISTS() {
            return "nur fuer Transbase";
        }

        @Override
        public final String LOAD_TC_INFO() {
            return "nur fuer Transbase";
        }

        @Override
        public final String TC_CHECK_LANDKUERZEL() {
            return "nur fuer Transbase";
        }
    }

    public static final class TeilelisteHTML
    extends SQLStatements.TeilelisteHTML {
        @Override
        public final String RETRIEVE_LISTEN_IDS() {
            return "select teileliste_marke Marke,  teileliste_user_id Eigentuemer, teileliste_id ListeId, teilelisterr_art SapArt from w_teileliste_rr, w_teileliste where teileliste_user_id = ?   and (teileliste_marke IN (&IN&) or teileliste_marke is null )   and teilelisterr_id (+) = teileliste_id   and teilelisterr_user_id (+) = teileliste_user_id";
        }

        @Override
        public final String RETRIEVE_LISTE_ALLG() {
            return "select teileliste_bemerkung Bemerkung, teileliste_erzeugt Erzeugt, teileliste_geaendert Geaendert, teileliste_marke Marke, teileliste_dringlichkeit Dringlichkeit, teileliste_vin VIN from w_teileliste where teileliste_id = ? and teileliste_user_id = ?";
        }

        @Override
        public final String RETRIEVE_LISTE_POS() {
            return "select teilelistepos_sachnr SachNr, teil_hauptgr Hg, teil_untergrup Ug, teilelistepos_position Pos, teilelistepos_menge Menge, teilelistepos_bemerkung Bemerkung, ben_text Benennung, teil_benennzus Zusatz, teil_fertigungshinweis FH,  teilelistepos_fistring FiString, teilelistepos_typ AspgTyp, teilelistepos_ref AspgRef, teilelistepos_menge_org AspgMenge from w_ben_gk, w_teil, w_teilelistepos where ben_textcode = teil_textcode and ben_iso = ? and  ben_regiso = ? and  teil_sachnr = teilelistepos_sachnr and teilelistepos_teileliste_id = ? and teilelistepos_user_id = ? order by Pos";
        }

        @Override
        public final String DELETE() {
            return "delete from w_teileliste where teileliste_id = '&ID&' and teileliste_user_id = '&NUTZER&'";
        }

        @Override
        public final String DELETE_POS() {
            return "delete from w_teilelistepos where teilelistepos_teileliste_id = '&ID&' and teilelistepos_user_id = '&NUTZER&'";
        }

        @Override
        public String CHECK_TEILELISTE() {
            return "select teileliste_id, teileliste_user_id from w_teileliste where  teileliste_id = ? and teileliste_user_id = ?";
        }

        @Override
        public final String INSERT_BESTELLLISTE() {
            return "insert into w_bestellliste (bestellliste_firma_id, bestellliste_filiale_id, bestellliste_liste_id) values ('&FIRMAID&', '&FILIALID&', '&ID&')";
        }

        @Override
        public final String INSERT_LISTE_ALLG() {
            return "insert into w_teileliste (teileliste_id, teileliste_user_id, teileliste_bemerkung, teileliste_erzeugt, teileliste_geaendert, teileliste_marke, teileliste_dringlichkeit, teileliste_vin) values ('&ID&', '&NUTZER&', '&BEMERKUNG&', &ERZEUGT&, &GEAENDERT&, '&MARKE&', &DRINGLICHKEIT&, &VIN&)";
        }

        @Override
        public final String UPDATE_LISTE_ALLG() {
            return "update w_teileliste set teileliste_bemerkung = '&BEMERKUNG&', teileliste_erzeugt = &ERZEUGT&, teileliste_geaendert = &GEAENDERT&, teileliste_dringlichkeit = &DRINGLICHKEIT&, teileliste_vin = &VIN& where teileliste_id = '&ID&' and teileliste_user_id = '&NUTZER&'";
        }

        @Override
        public final String INSERT_LISTE_POS() {
            return "insert into w_teilelistepos (teilelistepos_teileliste_id, teilelistepos_user_id, teilelistepos_sachnr, teilelistepos_position, teilelistepos_menge, teilelistepos_bemerkung, teilelistepos_fistring, teilelistepos_typ, teilelistepos_ref, teilelistepos_menge_org) values ('&ID&', '&NUTZER&', '&SACHNR&', &POS&, '&MENGE&', '&BEMERKUNG&', '&FISTRING&', '&ASPGTYP&', '&ASPGREF&', '&ASPGMENGE&')";
        }

        @Override
        public final String RETRIEVE_MAILADRESSEN() {
            return "select mailadr_mailadresse AnMailAdresse from w_mailadressen where mailadr_marke_tps IN (&IN&)";
        }

        @Override
        public final String GET_NEXT_SAMMELID_SEQ_VAL() {
            return " select teileliste_sammel_id_seq.nextval from dual";
        }
    }

    public static final class Teileliste
    extends SQLStatements.Teileliste {
        @Override
        public final String RETRIEVE_TEIL() {
            return "select teil_hauptgr Hg,      teil_untergrup Ug,      ben_text Benennung,      teil_benennzus Zusatz,     teilm_marke_tps Marke,      teil_art Teileart,      teil_produktkl ProduktKlasse,     teil_mam MAM,      teil_mengeeinh Mengeneinheit,     NVL(teil_vorverpac, 0) VVM,      NVL(teil_lagerverp, 0) LVM,      NVL(teil_beh_verp, 0) BVM,     teil_fertigungshinweis FH,      teil_ist_diebstahlrelevant Teil_Diebstahlrelevant  from w_teil_marken, w_ben_gk, w_teil where teil_sachnr = ? and teilm_sachnr = teil_sachnr and  teil_textcode = ben_textcode and ben_regiso = ? and ben_iso = ?";
        }
    }

    public static final class BteAnzeige
    extends SQLStatements.BteAnzeige {
        @Override
        public final String LOAD_HOTSPOTS() {
            return "select grafikhs_bildposnr Bildnummer, grafikhs_topleft_x TopLeft_x, grafikhs_topleft_y TopLeft_y, grafikhs_bottomright_x BottomRight_x, grafikhs_bottomright_y BottomRight_y from w_grafik_hs where grafikhs_grafikid = ? and grafikhs_art = ?";
        }

        @Override
        public final String LOAD_BTZEILEN_FZG() {
            return "select distinct btzeilen_bildposnr Bildnummer, teil_hauptgr Teil_HG, teil_untergrup Teil_UG, teil_sachnr Teil_Sachnummer, tben.ben_text Teil_Benennung, teil_benennzus Teil_Zusatz, teil_entfall_kez Teil_Entfall, teil_textcode_kom Teil_Kommentar_Id, tkben.ben_text Teil_Kommentar, teil_kom_pi Teil_Komm_PI, teil_vorhanden_si Teil_SI, teil_ist_reach Teil_Reach,  teil_ist_aspg Teil_Aspg,  teil_ist_stecker Teil_Stecker,  teil_ist_diebstahlrelevant Teil_Diebstahlrelevant,  si_dokart SI_DokArt, decode(NVL(tcp_sachnr, 'N'), tcp_sachnr, 'C', NULL) Teil_TC,  NVL(tcp_proddat_rel, 'N') Teil_TC_ProdDatRelevant, grpinfo_leitaw_pa GRP_PA, grpinfo_leitaw_hg GRP_HG, grpinfo_leitaw_ug GRP_UG, grpinfo_leitaw_nr GRP_lfdNr, btzeilenv_vmenge Menge, btzeilen_kat Kat_KZ, btzeilen_automatik Getriebe_KZ, btzeilen_lenkg Lenkung_KZ, btzeilen_eins Einsatz, btzeilen_auslf Auslauf, btzeilen_bedkez || btzeilen_regelnr Bedingung_KZ, btzeilen_kommbt KommBT, btzeilen_kommvor KommVor, btzeilen_kommnach KommNach, ks_sachnr_satz Satz_Sachnummer,  btzeilen_gruppeid GruppeId,  btzeilen_blocknr BlockNr,  bnbben.ben_text BnbBenText, btzeilen_pos Pos, btzeilenv_alter_kz BtZAlter, btzeilen_bedkez_pg Teil_BedkezPG, btzeilenv_bed_art BedingungArt, btzeilenv_bed_alter BedingungAlter from w_btzeilen_verbauung inner join w_btzeilen on (btzeilenv_btnr = btzeilen_btnr and btzeilenv_pos = btzeilen_pos) inner join w_teil on (btzeilen_sachnr = teil_sachnr) inner join w_ben_gk tben on (teil_textcode = tben.ben_textcode and tben.ben_iso = ? and tben.ben_regiso = ?) left join w_kompl_satz on (btzeilen_sachnr = ks_sachnr_satz and ks_marke_tps = ?) left join w_tc_performance on (tcp_mospid = ? and tcp_sachnr = btzeilen_sachnr &TC_CHECK_LANDKUERZEL& and tcp_datum_von <= ? and (tcp_datum_bis is null or tcp_datum_bis >= ?)) left join w_grp_information on (btzeilenv_mospid = grpinfo_mospid and grpinfo_sachnr = btzeilen_sachnr and grpinfo_typ = ?) left join w_ben_gk tkben on (teil_textcode_kom = tkben.ben_textcode and tkben.ben_iso = ? and tkben.ben_regiso = ?) left join w_si on (si_sachnr = teil_sachnr) left join w_bildtaf_bnbben on (bildtafb_btnr = btzeilenv_btnr and bildtafb_bildposnr = btzeilen_bildposnr) left join w_ben_gk bnbben on (bildtafb_textcode = bnbben.ben_textcode and bnbben.ben_iso = ? and bnbben.ben_regiso = ?) where btzeilenv_mospid = ? and btzeilenv_btnr = ? order by Pos, GRP_PA, GRP_HG, GRP_UG, GRP_lfdNr, SI_DokArt";
        }

        @Override
        public final String TC_CHECK_LANDKUERZEL() {
            return " and tcp_landkuerzel = ?";
        }

        @Override
        public final String LOAD_BTZEILEN_CP_FZG() {
            return "select distinct btzeilenc_pos Pos, btzeilenc_typschl Typ, btzeilenc_werk Werk, btzeilenc_art Art, btzeilenc_datum Datum, btzeilenc_vin Vin, btzeilenc_vin_proddatum VinProddatum, btzeilenc_vin_min VinMin, btzeilenc_vin_max VinMax, btzeilenc_nart ArtNummer, btzeilenc_nummer Nummer, btzeilenc_alter CPAlter from w_btzeilen_cp where btzeilenc_mospid = ? and btzeilenc_btnr = ? &CP_FZG_TYP_WERK& order by Pos";
        }

        @Override
        public final String CP_FZG_TYP_WERK() {
            return "   and btzeilenc_typschl = ? and btzeilenc_werk = ?";
        }

        @Override
        public final String LOAD_BTZEILEN_UGB() {
            return "select distinct btzeilenu_bildposnr Bildnummer, teil_hauptgr Teil_HG, teil_untergrup Teil_UG, teil_sachnr Teil_Sachnummer, tben.ben_text Teil_Benennung, teil_benennzus Teil_Zusatz, teil_entfall_kez Teil_Entfall, teil_textcode_kom Teil_Kommentar_Id, tkben.ben_text Teil_Kommentar, teil_kom_pi Teil_Komm_PI, teil_vorhanden_si Teil_SI, teil_ist_reach Teil_Reach,  teil_ist_aspg Teil_Aspg,  teil_ist_stecker Teil_Stecker,  teil_ist_diebstahlrelevant Teil_Diebstahlrelevant,  si_dokart SI_DokArt, decode(teil_sachnr, tcp_sachnr, 'C', NULL) Teil_TC, 'N' Teil_TC_ProdDatRelevant, btzeilenu_mmg MMG, btzeilenu_emg EMG, btzeilenu_eins Einsatz, btzeilenu_ausl Auslauf, btzeilenu_kommbt KommBT, btzeilenu_kommvor KommVor, btzeilenu_kommnach KommNach, ks_sachnr_satz Satz_Sachnummer,  0 GruppeId,  0 BlockNr,  bnbben.ben_text BnbBenText, btzeilenu_pos Pos from w_btzeilenugb_verbauung inner join w_btzeilenugb on (btzeilenuv_btnr = btzeilenu_btnr and btzeilenuv_pos = btzeilenu_pos) inner join w_teil on (btzeilenu_sachnr = teil_sachnr) inner join w_ben_gk tben on (teil_textcode = tben.ben_textcode and tben.ben_iso = ? and tben.ben_regiso = ?) left join w_kompl_satz on (btzeilenu_sachnr = ks_sachnr_satz and ks_marke_tps = ?) left join w_tc_performance_allg on (btzeilenu_sachnr = tcp_sachnr                                 and tcp_marke_tps = ?                                  and tcp_produktart = ?                                 and tcp_vbereich = ?                                     &TC_CHECK_LANDKUERZEL&                                 and tcp_datum_von <= ?                                 and (tcp_datum_bis is null or tcp_datum_bis <= ?)) left join w_ben_gk tkben on (teil_textcode_kom = tkben.ben_textcode and tkben.ben_iso = ? and tkben.ben_regiso = ?) left join w_si on (si_sachnr = teil_sachnr) left join w_bildtaf_bnbben on (bildtafb_btnr = btzeilenu_btnr and bildtafb_bildposnr = btzeilenu_bildposnr) left join w_ben_gk bnbben on (bildtafb_textcode = bnbben.ben_textcode and bnbben.ben_iso = ? and bnbben.ben_regiso = ?) where btzeilenuv_marke_tps = ? and btzeilenuv_btnr = ? order by Pos";
        }

        @Override
        public final String LOAD_KOMMENTARE_FZG() {
            return "select distinct komm_id KommId, ben_text Text, komm_code Code, komm_vz VZ, komm_darstellung Darstellung, komm_tiefe Tiefe, komm_pos Pos from w_ben_gk, w_komm, w_komm_help where kommh_mospid = ? and kommh_btnr = ? and komm_id = kommh_id and ben_textcode = komm_textcode and ben_iso = ? and ben_regiso = ? order by KommId, Pos";
        }

        @Override
        public final String LOAD_KOMMENTARE_UGB() {
            return "select distinct komm_id KommId, ben_text Text, komm_pos Pos from w_ben_gk, w_komm, w_kommugb_help where kommuh_marke_tps = ? and kommuh_btnr = ? and komm_id = kommuh_id and ben_textcode = komm_textcode and ben_iso = ? and ben_regiso = ? order by KommId, Pos";
        }

        @Override
        public final String LOAD_BEDINGUNGEN_FZG() {
            return "select distinct btebg_kez Kuerzel, btebg_vz  GesamttermVZ, btebg_gesamtterm Gesamtterm, btebo_ogid OG, btebo_vart VArt, btebo_fzeile FZeile, btebe_vz ElementVZ, btebe_elemid ElementId, btebe_pos Pos from w_bte_bedelem, w_bte_bedog, w_bte_bedgesamt, w_bte_bedkurz where btebk_btnr = ? and btebk_mospid = ? and btebg_btnr = btebk_btnr and btebg_kez = btebk_kez and btebo_btnr = btebg_btnr and btebo_kez = btebg_kez and btebe_btnr = btebo_btnr and btebe_kez = btebo_kez and btebe_ogid = btebo_ogid union select distinct btebg_kez Kuerzel, btebg_vz  GesamttermVZ, btebg_gesamtterm Gesamtterm, btebo_ogid OG, btebo_vart VArt, btebo_fzeile FZeile, btebe_vz ElementVZ, btebe_elemid ElementId, btebe_pos Pos from w_bte_bedelem, w_bte_bedog, w_bte_bedgesamt, w_bildtaf where bildtaf_btnr = ? and bildtaf_bedkez is not null and btebg_btnr = bildtaf_btnr and btebg_kez = bildtaf_bedkez and btebo_btnr = btebg_btnr and btebo_kez = btebg_kez and btebe_btnr = btebo_btnr and btebe_kez = btebo_kez and btebe_ogid = btebo_ogid order by Kuerzel, OG, Pos";
        }

        @Override
        public final String LOAD_BTE_BEDINGUNGEN_FZG() {
            return " select distinct btebg_vz  GesamttermVZ, btebg_gesamtterm Gesamtterm, btebo_ogid OG, btebo_vart VArt, btebo_fzeile FZeile, btebe_vz ElementVZ, btebe_elemid ElementId, btebe_pos Pos from w_bte_bedelem, w_bte_bedog, w_bte_bedgesamt where btebg_btnr = ? and btebg_kez = ? and btebo_btnr = btebg_btnr and btebo_kez = btebg_kez  and btebe_btnr = btebg_btnr and btebe_kez = btebg_kez and btebe_ogid = btebo_ogid order by OG, Pos";
        }

        @Override
        public final String LOAD_UEBERBEDINGUNGEN_FZG() {
            return "select distinct btebu_kez Kuerzel, btebu_kezueber  KuerzelUeber from w_bte_bedkurz, w_bte_bedueber  where btebk_btnr = ? and btebk_mospid = ? and btebu_btnr = btebk_btnr and btebu_kez =  btebk_kez union select distinct btebu_kez Kuerzel, btebu_kezueber  KuerzelUeber from w_bte_bedkurz, w_bte_bedueber  where btebk_btnr = ? and btebk_mospid = ? and btebu_btnr = btebk_btnr and btebu_kezueber = btebk_kez order by Kuerzel, KuerzelUeber";
        }

        @Override
        public final String LOAD_BTVERWEISE_FZG() {
            return "select distinct bv_btnr_nach Bildtafelnummer, bt.ben_text Ueberschrift, bv.ben_text Text, komm_pos Pos from w_ben_gk bt, w_ben_gk bv, w_komm, w_bildtaf, w_bildtaf_suche, w_bildtaf_verweis where bv_btnr_von = ? and bildtafs_hg = substr(bv_btnr_nach, 1, 2) and bildtafs_mospid = ? and bildtafs_btnr = bv_btnr_nach and komm_id = bv_kommid and bv.ben_textcode = komm_textcode and bv.ben_iso = ? and bv.ben_regiso = ? and bildtaf_btnr = bv_btnr_nach and bt.ben_textcode = bildtaf_textc and bt.ben_iso = ? and bt.ben_regiso = ? order by Bildtafelnummer, Pos";
        }

        @Override
        public final String LOAD_BTVERWEISE_UGB() {
            return "select distinct bv_btnr_nach Bildtafelnummer, bt.ben_text Ueberschrift, bv.ben_text Text, komm_pos Pos from w_ben_gk bt, w_ben_gk bv, w_komm, w_bildtaf, w_btzeilenugb_verbauung, w_bildtaf_verweis where bv_btnr_von = ? and btzeilenuv_btnr = bv_btnr_nach and btzeilenuv_marke_tps = ? and komm_id = bv_kommid and bv.ben_textcode = komm_textcode and bv.ben_iso = ? and bv.ben_regiso = ? and bildtaf_btnr = bv_btnr_nach and bildtaf_produktart = ? and bt.ben_textcode = bildtaf_textc and bt.ben_iso = ? and bt.ben_regiso = ? order by Bildtafelnummer, Pos";
        }

        @Override
        public final String LOAD_JA_NEIN_TEXT() {
            return "select distinct publben_bezeichnung Bezeichnung, ben_text Benennung from w_ben_gk, w_publben where publben_art = ? and ben_textcode = publben_textcode and ben_iso = ? and ben_regiso = ? order by Bezeichnung";
        }

        @Override
        public final String LOAD_AZEICHEN() {
            return "select distinct teilatb_kennz ATB,              teilatb_bap BAP from w_teil_atb where teilatb_sachnr_alt = ? and teilatb_sachnr_neu = ?";
        }

        @Override
        public final String LOAD_ANZAHL_REL_KAMPAGNEN() {
            return "select Count(*) Anzahl from w_tc_sachnummer, w_tc_kampagne_proddatum, w_tc_kampagne where tckp_mospid = ? and tckp_proddatum_von <= ? and nvl(tckp_proddatum_bis, 99999999) >= ? and tcs_id = tckp_id and tcs_sachnr = ? and tck_id = tcs_id &TC_CHECK_LANDKUERZEL_KAMPAGNE&";
        }

        @Override
        public final String TC_CHECK_LANDKUERZEL_KAMPAGNE() {
            return " and tck_landkuerzel = ?";
        }
    }

    public static final class BedAuswertung
    extends SQLStatements.BedAuswertung {
        @Override
        public final String LOAD_BT_STAMM() {
            return "select distinct bildtaf_hg HG, bildtaf_fg FG, bildtaf_btnr BildtafelNr, bildtaf_bteart BildtafelArt, ben_text Benennung, bildtaf_bedkez BedKuerzel, bildtaf_vorh_cp VorhandenCP, bildtaf_lkz Lkz, bildtaf_grafikid GrafikId, grafik_moddate ModStamp, NULL ZubBtnr from w_grafik, w_ben_gk, w_bildtaf where bildtaf_btnr = ? and ben_textcode = bildtaf_textc and ben_iso = ? and ben_regiso = ? and grafik_grafikid (+) = bildtaf_grafikid";
        }

        @Override
        public final String LOAD_BT_STAMM_CP() {
            return "select distinct bildtafc_art Art, bildtafc_datum Datum from w_bildtaf_cp where bildtafc_btnr = ? order by Art, Datum";
        }

        @Override
        public final String LOAD_BT_BEDINGUNGEN_SALA() {
            return "select distinct btebe_elemid ElementId, bedsala_art || bedsala_pnr || bedsala_hz Code, ben_text Benennung, bed_egid EGruppenId, eg_exklusiv Exklusiv, bedsala_saz SAZ, eg_pos EGruppenPosition, bedsala_pnr PrimaNr from w_ben_gk, w_bed_sala, w_bed, w_eg, w_bte_bedelem, w_bte_bedkurz where btebk_btnr = ? and btebk_mospid = ? and btebe_btnr = btebk_btnr and btebe_kez = btebk_kez and bed_elemid = btebe_elemid and bedsala_id = bed_elemid and eg_id = bed_egid and ben_textcode = bed_textcode and ben_iso = ? and ben_regiso = ? union select distinct btebe_elemid ElementId, bedsala_art || bedsala_pnr || bedsala_hz Code, ben_text Benennung, bed_egid EGruppenId, eg_exklusiv Exklusiv, bedsala_saz SAZ, eg_pos EGruppenPosition, bedsala_pnr PrimaNr from w_ben_gk, w_bed_sala, w_bed, w_eg, w_bte_bedelem, w_bildtaf where bildtaf_btnr = ? and bildtaf_bedkez is not null and btebe_btnr = bildtaf_btnr and btebe_kez = bildtaf_bedkez and bed_elemid = btebe_elemid and bedsala_id = bed_elemid and eg_id = bed_egid and ben_textcode = bed_textcode and ben_iso = ? and ben_regiso = ? order by EGruppenPosition, PrimaNr";
        }

        @Override
        public final String LOAD_BT_BEDINGUNGEN_AFL() {
            return "select distinct btebe_elemid ElementId, bedafl_code Code, ben_text Benennung, bed_egid EGruppenId, eg_exklusiv Exklusiv, eg_pos EGruppenPosition from w_ben_gk, w_bed_afl, w_bed, w_eg, w_bte_bedelem, w_bte_bedkurz where btebk_btnr = ? and btebk_mospid = ? and btebe_btnr = btebk_btnr and btebe_kez = btebk_kez and bed_elemid = btebe_elemid and bedafl_id = bed_elemid and eg_id = bed_egid and ben_textcode = bed_textcode and ben_iso = ? and ben_regiso = ? union select distinct btebe_elemid ElementId, bedafl_code Code, ben_text Benennung, bed_egid EGruppenId, eg_exklusiv Exklusiv, eg_pos EGruppenPosition from w_ben_gk, w_bed_afl, w_bed, w_eg, w_bte_bedelem, w_bildtaf where bildtaf_btnr = ? and bildtaf_bedkez is not null and btebe_btnr = bildtaf_btnr and btebe_kez = bildtaf_bedkez and bed_elemid = btebe_elemid and bedafl_id = bed_elemid and eg_id = bed_egid and ben_textcode = bed_textcode and ben_iso = ? and ben_regiso = ? order by EGruppenPosition, Code";
        }

        @Override
        public final String LOAD_BT_BEDINGUNGEN_TEXT() {
            return "select distinct btebe_elemid ElementId, ben_text Benennung, bed_egid EGruppenId, eg_exklusiv Exklusiv, eg_pos EGruppenPosition from w_ben_gk, w_bed, w_eg, w_bte_bedelem, w_bte_bedkurz where btebk_btnr = ? and btebk_mospid = ? and btebe_btnr = btebk_btnr and btebe_kez = btebk_kez and bed_elemid = btebe_elemid and bed_ogid = ? and eg_id = bed_egid and ben_textcode = bed_textcode and ben_iso = ? and ben_regiso = ? union select distinct btebe_elemid ElementId, ben_text Benennung, bed_egid EGruppenId, eg_exklusiv Exklusiv, eg_pos EGruppenPosition from w_ben_gk, w_bed, w_eg, w_bte_bedelem, w_bildtaf where bildtaf_btnr = ? and bildtaf_bedkez is not null and btebe_btnr = bildtaf_btnr and btebe_kez = bildtaf_bedkez and bed_elemid = btebe_elemid and bed_ogid = ? and eg_id = bed_egid and ben_textcode = bed_textcode and ben_iso = ? and ben_regiso = ? order by EGruppenPosition, Benennung";
        }
    }

    public static final class TeileinfoJAVA
    extends SQLStatements.TeileinfoJAVA {
        @Override
        public final String RETRIEVE_TEILEINFO_NOTIZ() {
            return "select teileinfo_notiz Notiz, teileinfo_gueltig_bis_monat BisMonat, teileinfo_gueltig_bis_jahr BisJahr MBEN.ben_text MONATBEN, teileinfo_allgemein Allgemein from w_ben_gk MBEN, w_publben, w_teileinfo where teileinfo_sachnr = ? and teileinfo_user_id = ? and teileinfo_firma_id = ? and publben_art = ? and publben_bezeichnung = ltrim(to_char(teileinfo_gueltig_bis_monat, ?)) and publben_textcode = MBEN.ben_textcode and MBEN.ben_iso = ? and MBEN.ben_regiso = ?";
        }

        @Override
        public final String DELETE_TEILEINFO_NOTIZ() {
            return "delete from w_teileinfo where teileinfo_sachnr = '&SACHNR&' and teileinfo_user_id = '&ID&' and teileinfo_firma_id = '&FIRMA&'";
        }

        @Override
        public final String INSERT_TEILEINFO_NOTIZ() {
            return "insert into w_teileinfo (teileinfo_sachnr, teileinfo_user_id, teileinfo_firma_id, teileinfo_allgemein, teileinfo_notiz, teileinfo_gueltig_bis_monat, teileinfo_gueltig_bis_jahr) values ('&SACHNR&', '&ID&', '&FIRMA&', '&ALLGEMEIN&', '&NOTIZTEXT&', &BISMONAT&, &BISJAHR&)";
        }

        @Override
        public final String RETRIEVE_TEILEINFO_NOTIZEN_OTHERS() {
            return "select teileinfo_notiz Notiz, MBEN.ben_text Monat, teileinfo_gueltig_bis_jahr BisJahr from w_ben_gk MBEN, w_publben, w_teileinfo where teileinfo_sachnr = ? and teileinfo_user_id <> ? and teileinfo_firma_id = ? and teileinfo_allgemein = ? and publben_art = ? and publben_bezeichnung = ltrim(to_char(teileinfo_gueltig_bis_monat, ?)) and publben_textcode = MBEN.ben_textcode and MBEN.ben_iso = ? and MBEN.ben_regiso = ?";
        }

        @Override
        public final String RETRIEVE_COUNT_PREISE() {
            return "select count (*) from w_preise where preise_firma = '&FIRMA&'";
        }
    }

    public static final class TeileinfoHTML
    extends SQLStatements.TeileinfoHTML {
        @Override
        public final String RETRIEVE_TEILEINFO_NOTIZ() {
            return "select teileinfo_notiz Notiz, teileinfo_gueltig_bis_monat BisMonat, teileinfo_gueltig_bis_jahr BisJahr from w_teileinfo where teileinfo_sachnr = ? and teileinfo_user_id = ?";
        }

        @Override
        public final String DELETE_TEILEINFO_NOTIZ() {
            return "delete from w_teileinfo where teileinfo_sachnr = '&SACHNR&' and teileinfo_user_id = '&ID&'";
        }

        @Override
        public final String INSERT_TEILEINFO_NOTIZ() {
            return "insert into w_teileinfo (teileinfo_sachnr, teileinfo_user_id, teileinfo_notiz, teileinfo_gueltig_bis_monat, teileinfo_gueltig_bis_jahr) values ('&SACHNR&', '&ID&', '&NOTIZTEXT&', &BISMONAT&, &BISJAHR&)";
        }
    }

    public static final class Teileinfo
    extends SQLStatements.Teileinfo {
        @Override
        public final String RETRIEVE_TEILEINFO() {
            return "select teil.teil_hauptgr hg,      teil.teil_untergrup Ug,      teil.teil_sachnr SachNr,      teilm.teilm_marke_tps Marke,      ben.ben_text Benennung,      benkom.ben_text BenKom,      teil.teil_benennzus BenZusatz,      teil.teil_art Art,      teiltausch.teil_hauptgr TauschHg,      teiltausch.teil_untergrup TauschUg,      teil.teil_tausch AustauschTNr,      teilalt.teil_hauptgr AltHg,      teilalt.teil_untergrup AltUg,      teil.teil_alt TNrAlt,     teil.teil_austausch_alt Austauschbar,      ben_austausch.ben_text BenAustausch,      teil.teil_technik TST,      teil.teil_dispo TSD,      teil.teil_mengeeinh Mengeneinheit,      ben_mengeneinheit.ben_text BenMengeneinheit,      teil.teil_produktkl Produktklasse,      teil.teil_rundung RundungsKz,      teil.teil_lkz LokalTeilKz,      teil.teil_vorverpac VVM,      teil.teil_Lagerverp LVM,      teil.teil_beh_verp BVM,      teil.teil_teile_gew Gewicht,      nn_art Normart,      teil.teil_normnummer DIN,      teil.teil_fertigungshinweis Fertigungshinweis,      teil.teil_kom_pi ZusatzinfoKomId,      teil.teil_recycling_kez RecyclKz,      teil.teil_produktart Produktart,      teil.teil_verbaubar Verbaubar,  \tteil.teil_ist_reach Reach,      teil.teil_ist_diebstahlrelevant Teil_Diebstahlrelevant,  \tw_eu_reifen.reifen_kraftstoff,  \tw_eu_reifen.reifen_nasshaftung,  \tw_eu_reifen.reifen_rollgeraeusch_stufe,  \tw_eu_reifen.reifen_rollgeraeusch_wert  from w_ben_gk ben, w_ben_gk benkom, w_ben_gk ben_austausch, w_publben publben_austausch, w_ben_gk ben_mengeneinheit, w_publben publben_mengeneinheit, w_teil teilalt, w_teil teiltausch, w_normnummer, w_teil_marken teilm, w_teil teil, w_eu_reifen where ben.ben_textcode = teil.teil_textcode and       ben.ben_iso = ? and        ben.ben_regiso = ? and        benkom.ben_textcode (+)  = teil.teil_textcode_kom and       benkom.ben_iso (+) = ? and        benkom.ben_regiso (+) = ? and        publben_austausch.publben_art (+) = ? and        publben_austausch.publben_bezeichnung (+) = teil.teil_austausch_alt and        ben_austausch.ben_textcode (+)  = publben_austausch.publben_textcode and       ben_austausch.ben_iso (+) = ? and        ben_austausch.ben_regiso (+) = ? and        publben_mengeneinheit.publben_art (+) = ? and        publben_mengeneinheit.publben_bezeichnung (+) = teil.teil_mengeeinh and        ben_mengeneinheit.ben_textcode (+)  = publben_mengeneinheit.publben_textcode and       ben_mengeneinheit.ben_iso (+) = ? and        ben_mengeneinheit.ben_regiso (+) = ? and        teilalt.teil_sachnr (+) = teil.teil_alt and       nn_nnid (+) = teil.teil_normnummer and       teiltausch.teil_sachnr (+) = teil.teil_tausch and       teil.teil_sachnr = ? and       teilm.teilm_sachnr = teil.teil_sachnr and        teilm.teilm_marke_tps IN (&IN&) and \t\t  w_eu_reifen.reifen_sachnr (+) = teil.teil_sachnr        &HGUG_STMT&";
        }

        @Override
        public final String RETRIEVE_TEILEINFO_HGUG() {
            return " and teil.teil_hauptgr = ? and teil.teil_untergrup = ?";
        }

        @Override
        public final String RETRIEVE_TEILEINFO_SERVICEINFO() {
            return "select si_dokart DokArt, si_doknr DokNr from w_si where si_sachnr = ?";
        }

        @Override
        public final String RETRIEVE_TEILEINFO_PRODUKTINFO() {
            return "select ben_text Ben, komm_pos Pos from w_ben_gk, w_komm where ben_textcode = komm_textcode and ben_iso = ? and ben_regiso = ? and komm_id = ? order by Pos";
        }

        @Override
        public final String RETRIEVE_TEILEINFO_REACHINFO() {
            return "select teilreach_casnr casNr, teilreach_casname casName, teilreach_gewanteil Gewichtsanteil,  teilreach_subcomponent subKomponent from w_teil_reach, w_teil  where teilreach_sachnr = ?   and teilreach_sachnr=teil_sachnr  order by casNr";
        }

        @Override
        public final String RETRIEVE_BEN_ZU_KUERZEL() {
            return "select ben_text Ben from w_ben_gk, w_publben where publben_art = ? and publben_bezeichnung = ? and  ben_textcode = publben_textcode and ben_iso = ? and  ben_regiso = ?";
        }

        @Override
        public final String RETRIEVE_TEILEINFO_TEILECLEARING() {
            return "select distinct tck_id Id, tck_landkuerzel Land, tck_marke_tps Marke, tck_produktart Produktart, tck_vbereich VBereich, tck_baureihen Baureihen, tck_motoren Motoren, tck_baureihen_proddat_von DatumVon, tck_baureihen_proddat_bis DatumBis, tck_pos Pos from w_tc_sachnummer, w_tc_kampagne where tcs_sachnr = ?   and tcs_id = tck_id    and tck_marke_tps in (&IN1&)   and tck_produktart in (&IN2&)   and tck_vbereich in (&IN3&)   and tck_datum_von <= ?   &TC_CHECK_LANDKUERZEL&   and (tck_datum_bis is null or tck_datum_bis >= ?) order by Land, Marke, Produktart DESC, VBereich DESC, Id, Pos";
        }

        @Override
        public final String TC_CHECK_LANDKUERZEL() {
            return " and tck_landkuerzel = ?";
        }

        @Override
        public final String RETRIEVE_HGUG() {
            return "select teil_hauptgr Hg, teil_untergrup Ug from w_teil where teil_sachnr = ?";
        }

        @Override
        public final String SEARCH_SNR_FREMDNR() {
            return "select distinct teil_hauptgr Hauptgruppe, teil_untergrup Untergruppe, teil_sachnr Sachnummer, ben_teil.ben_text Benennung, teil_benennzus Zusatz, ben_komm.ben_text BenennungKommentar, teilm_marke_tps Marke,  teil_ist_diebstahlrelevant Teil_Diebstahlrelevant  from w_teil inner join w_ben_gk ben_teil on ( teil_textcode = ben_teil.ben_textcode and  ben_teil.ben_iso = ? and ben_teil.ben_regiso = ?) left join w_ben_gk ben_komm on ( teil_textcode_kom = ben_komm.ben_textcode and ben_komm.ben_iso = ? and ben_komm.ben_regiso = ?) inner join w_teil_marken teil_marke on ( teilm_sachnr = teil_sachnr) where teil_sachnr IN &SACHNUMMERN& order by Benennung, Hauptgruppe, Untergruppe, Sachnummer";
        }
    }

    public static final class TeilesucheAss
    extends SQLStatements.TeilesucheAss {
        @Override
        public final String RETRIEVE_HGS() {
            return "select distinct hgfg_hg Hauptgruppe, ben_text Benennung, hgthb_grafikid GrafikId, grafik_moddate ModStamp from w_grafik, w_hg_thumbnail, w_hgfg, w_ben_gk, w_bildtaf, w_btzeilenugb_verbauung where btzeilenuv_marke_tps = ? and bildtaf_btnr = btzeilenuv_btnr and bildtaf_produktart = ? and bildtaf_vbereich in (?, ?) and hgfg_hg = bildtaf_hg and hgfg_fg = ? and hgfg_produktart = bildtaf_produktart and hgfg_bereich = bildtaf_bereich and ben_textcode = hgfg_textcode and ben_iso = ? and ben_regiso = ? and hgthb_hg (+) = hgfg_hg and hgthb_marke_tps (+) = ? and hgthb_produktart (+) = hgfg_produktart and hgthb_bereich (+) = hgfg_bereich and grafik_grafikid (+) = hgthb_grafikid and grafik_art (+) = ? order by Hauptgruppe";
        }

        @Override
        public final String RETRIEVE_HGS_GRAF() {
            return "select distinct hgfg_hg Hauptgruppe, ben_text Benennung, hgthb_grafikid GrafikId, grafik_moddate ModStamp, NULL Grafik from w_grafik, w_hg_thumbnail, w_hgfg, w_ben_gk, w_bildtaf, w_btzeilenugb_verbauung where btzeilenuv_marke_tps = ? and bildtaf_btnr = btzeilenuv_btnr and bildtaf_produktart = ? and bildtaf_vbereich in (?, ?) and hgfg_hg = bildtaf_hg and hgfg_fg = ? and hgfg_produktart = bildtaf_produktart and hgfg_bereich = bildtaf_bereich and ben_textcode = hgfg_textcode and ben_iso = ? and ben_regiso = ? and hgthb_hg (+) = hgfg_hg and hgthb_marke_tps (+) = ? and hgthb_produktart (+) = hgfg_produktart and hgthb_bereich (+) = hgfg_bereich and grafik_grafikid (+) = hgthb_grafikid and grafik_art (+) = ? order by Hauptgruppe";
        }

        @Override
        public final String RETRIEVE_HGFGS() {
            return "select distinct hgfg_hg Hauptgruppe, hgfg_fg Funktionsgruppe, ben_text Benennung from w_hgfg, w_ben_gk, w_bildtaf, w_btzeilenugb_verbauung where btzeilenuv_marke_tps = ? and bildtaf_btnr = btzeilenuv_btnr and bildtaf_produktart = ? and bildtaf_vbereich in (?, ?) and bildtaf_hg = ? and hgfg_hg = bildtaf_hg and hgfg_fg = bildtaf_fg and hgfg_produktart = bildtaf_produktart and hgfg_bereich = bildtaf_bereich and ben_textcode = hgfg_textcode and ben_iso = ? and ben_regiso = ? order by Hauptgruppe, Funktionsgruppe";
        }

        @Override
        public final String RETRIEVE_ALL_HGFGS() {
            return "select hgfg_hg Hauptgruppe, hgfg_fg Funktionsgruppe, ben_text Benennung from w_hgfg, w_ben_gk, w_bildtaf, w_btzeilenugb_verbauung where btzeilenuv_marke_tps = ? and bildtaf_btnr = btzeilenuv_btnr and bildtaf_produktart = ? and bildtaf_vbereich in (?, ?) and hgfg_hg = bildtaf_hg and hgfg_fg = ? and hgfg_produktart = bildtaf_produktart and hgfg_bereich = bildtaf_bereich and ben_textcode = hgfg_textcode and ben_iso = ? and ben_regiso = ? union  select hgfg_hg Hauptgruppe, hgfg_fg Funktionsgruppe, ben_text Benennung from w_hgfg, w_ben_gk, w_bildtaf, w_btzeilenugb_verbauung where btzeilenuv_marke_tps = ? and bildtaf_btnr = btzeilenuv_btnr and bildtaf_produktart = ? and bildtaf_vbereich in (?, ?) and hgfg_hg = bildtaf_hg and hgfg_fg = bildtaf_fg and hgfg_produktart = bildtaf_produktart and hgfg_bereich = bildtaf_bereich and ben_textcode = hgfg_textcode and ben_iso = ? and ben_regiso = ? order by 1, 2";
        }

        @Override
        public final String SEARCH_BT_BENENNUNG() {
            return "select distinct bildtaf_btnr BildtafelNr, bildtaf_bteart BildtafelArt, ben_text Benennung, bildtaf_pos Pos, bildtaf_kommbt Kommentar, bildtaf_vorh_cp CPVorhanden, bildtaf_bedkez BedingungKZ, marktetk_isokz MarktIso from w_markt_etk, w_ben_gk, w_bildtaf, w_btzeilenugb_verbauung where btzeilenuv_marke_tps = ? and bildtaf_btnr = btzeilenuv_btnr and bildtaf_produktart = ? and bildtaf_vbereich in (?, ?) and ben_textcode = bildtaf_textc and ben_iso = ? and ben_regiso = ? and upper(ben_text) like upper(N'&SUCHSTRING&') and marktetk_lkz (+) = bildtaf_lkz&ORDER_BY_POS&";
        }

        @Override
        public final String SEARCH_BT_BENENNUNG_SONDERLOCKE() {
            return "select distinct bildtaf_btnr BildtafelNr, bildtaf_bteart BildtafelArt, ben_text Benennung, bildtaf_pos Pos, bildtaf_kommbt Kommentar, bildtaf_vorh_cp CPVorhanden, bildtaf_bedkez BedingungKZ, marktetk_isokz MarktIso from w_markt_etk, w_ben_gk, w_bildtaf, w_btzeilenugb_verbauung where btzeilenuv_marke_tps = ? and bildtaf_btnr = btzeilenuv_btnr and bildtaf_produktart = ? and bildtaf_vbereich in (?, ?) and ben_textcode = bildtaf_textc and ben_iso = ? and ben_regiso = ? and (upper(ben_text) like upper(N'&SUCHSTRING1&') or upper(ben_text) like upper(N'&SUCHSTRING2&')) and marktetk_lkz (+) = bildtaf_lkz&ORDER_BY_POS&";
        }

        @Override
        public final String SEARCH_BT_BENENNUNG_TR() {
            return "select distinct bildtaf_btnr BildtafelNr, bildtaf_bteart BildtafelArt, ben_text Benennung, bildtaf_pos Pos, bildtaf_kommbt Kommentar, bildtaf_vorh_cp CPVorhanden, bildtaf_bedkez BedingungKZ, marktetk_isokz MarktIso from w_markt_etk, w_ben_gk, w_bildtaf, w_btzeilenugb_verbauung where btzeilenuv_marke_tps = ? and bildtaf_btnr = btzeilenuv_btnr and bildtaf_produktart = ? and bildtaf_vbereich in (?, ?) and ben_textcode = bildtaf_textc and ben_iso = ? and ben_regiso = ? and upper(replace(ben_text,'i',chr(50352))) like N'&SUCHSTRING&' and marktetk_lkz (+) = bildtaf_lkz&ORDER_BY_POS&";
        }

        @Override
        public final String SEARCH_BT_BEGRIFF() {
            return "select distinct bildtaf_btnr BildtafelNr, bildtaf_bteart BildtafelArt, ben_text Benennung, bildtaf_kommbt Kommentar, bildtaf_vorh_cp CPVorhanden, bildtaf_bedkez BedingungKZ, bildtaf_pos Pos, marktetk_isokz MarktIso from w_markt_etk, w_ben_gk, w_bildtaf, w_btzeilenugb_verbauung where btzeilenuv_marke_tps = ? and bildtaf_btnr = btzeilenuv_btnr and bildtaf_produktart = ? and bildtaf_vbereich in (?, ?) and ben_textcode = bildtaf_textc and ben_iso = ? and ben_regiso = ? and &BEGRIFFE_BEN_STMT& and marktetk_lkz (+) = bildtaf_lkz&ORDER_BY_POS&";
        }

        @Override
        public final String SEARCH_SNR_BENENNUNG() {
            return "select distinct teil_hauptgr Hauptgruppe, teil_untergrup Untergruppe, teil_sachnr Sachnummer, ben_teil.ben_text Benennung, teil_benennzus Zusatz, ben_komm.ben_text BenennungKommentar, NULL BTZeilenAlter, NULL Pos, NULL BTNummer,  teil_ist_diebstahlrelevant Teil_Diebstahlrelevant  from w_ben_gk ben_teil, w_ben_gk ben_komm, w_teil, w_bildtaf, w_btzeilenugb, w_btzeilenugb_verbauung where btzeilenuv_marke_tps = ? and btzeilenu_btnr = btzeilenuv_btnr and btzeilenu_pos = btzeilenuv_pos and bildtaf_btnr = btzeilenuv_btnr and bildtaf_produktart = ? and bildtaf_vbereich in (?, ?) and teil_sachnr = btzeilenu_sachnr and ben_teil.ben_textcode = teil_textcode and ben_teil.ben_iso = ? and ben_teil.ben_regiso = ? and upper(ben_teil.ben_text) like upper(N'&SUCHSTRING&') and ben_komm.ben_textcode (+) = teil_textcode_kom and ben_komm.ben_iso (+) = ? and ben_komm.ben_regiso (+) = ? &ORDER_BY_BENENNUNG_HG_UG_SACHNUMMER&";
        }

        @Override
        public final String SEARCH_SNR_BENENNUNG_SONDERLOCKE() {
            return "select distinct teil_hauptgr Hauptgruppe, teil_untergrup Untergruppe, teil_sachnr Sachnummer, ben_teil.ben_text Benennung, teil_benennzus Zusatz, ben_komm.ben_text BenennungKommentar, NULL BTZeilenAlter, NULL Pos, NULL BTNummer,  teil_ist_diebstahlrelevant Teil_Diebstahlrelevant  from w_ben_gk ben_teil, w_ben_gk ben_komm, w_teil, w_bildtaf, w_btzeilenugb, w_btzeilenugb_verbauung where btzeilenuv_marke_tps = ? and btzeilenu_btnr = btzeilenuv_btnr and btzeilenu_pos = btzeilenuv_pos and bildtaf_btnr = btzeilenuv_btnr and bildtaf_produktart = ? and bildtaf_vbereich in (?, ?) and teil_sachnr = btzeilenu_sachnr and ben_teil.ben_textcode = teil_textcode and ben_teil.ben_iso = ? and ben_teil.ben_regiso = ? and (upper(ben_teil.ben_text) like upper(N'&SUCHSTRING1&') or upper(ben_teil.ben_text) like upper(N'&SUCHSTRING2&')) and ben_komm.ben_textcode (+) = teil_textcode_kom and ben_komm.ben_iso (+) = ? and ben_komm.ben_regiso (+) = ? &ORDER_BY_BENENNUNG_HG_UG_SACHNUMMER&";
        }

        @Override
        public final String SEARCH_SNR_BENENNUNG_TR() {
            return "select distinct teil_hauptgr Hauptgruppe, teil_untergrup Untergruppe, teil_sachnr Sachnummer, ben_teil.ben_text Benennung, teil_benennzus Zusatz, ben_komm.ben_text BenennungKommentar, NULL BTZeilenAlter, NULL Pos, NULL BTNummer,  teil_ist_diebstahlrelevant Teil_Diebstahlrelevant  from w_ben_gk ben_teil, w_ben_gk ben_komm, w_teil, w_bildtaf, w_btzeilenugb, w_btzeilenugb_verbauung where btzeilenuv_marke_tps = ? and btzeilenu_btnr = btzeilenuv_btnr and btzeilenu_pos = btzeilenuv_pos and bildtaf_btnr = btzeilenuv_btnr and bildtaf_produktart = ? and bildtaf_vbereich in (?, ?) and teil_sachnr = btzeilenu_sachnr and ben_teil.ben_textcode = teil_textcode and ben_teil.ben_iso = ? and ben_teil.ben_regiso = ? and upper(replace(ben_teil.ben_text,'i',chr(50352))) like N'&SUCHSTRING&' and ben_komm.ben_textcode (+) = teil_textcode_kom and ben_komm.ben_iso (+) = ? and ben_komm.ben_regiso (+) = ? &ORDER_BY_BENENNUNG_HG_UG_SACHNUMMER&";
        }

        @Override
        public final String SEARCH_SNR_BEGRIFF() {
            return "select distinct teil_hauptgr Hauptgruppe, teil_untergrup Untergruppe, teil_sachnr Sachnummer, ben_teil.ben_text Benennung, teil_benennzus Zusatz, ben_komm.ben_text BenennungKommentar, NULL BTZeilenAlter, NULL Pos, NULL BTNummer,  teil_ist_diebstahlrelevant Teil_Diebstahlrelevant  from w_ben_gk ben_teil, w_ben_gk ben_komm, w_teil, w_bildtaf, w_btzeilenugb, w_btzeilenugb_verbauung where btzeilenuv_marke_tps = ? and btzeilenu_btnr = btzeilenuv_btnr and btzeilenu_pos = btzeilenuv_pos and bildtaf_btnr = btzeilenuv_btnr and bildtaf_produktart = ? and bildtaf_vbereich in (?, ?) and teil_sachnr = btzeilenu_sachnr and ben_teil.ben_textcode = teil_textcode and ben_teil.ben_iso = ? and ben_teil.ben_regiso = ? and &BEGRIFFE_BEN_TEIL_STMT& and ben_komm.ben_textcode (+) = teil_textcode_kom and ben_komm.ben_iso (+) = ? and ben_komm.ben_regiso (+) = ? union select distinct teil_hauptgr Hauptgruppe, teil_untergrup Untergruppe, teil_sachnr Sachnummer, ben_teil.ben_text Benennung, teil_benennzus Zusatz, ben_komm.ben_text BenennungKommentar, NULL BTZeilenAlter, NULL Pos, NULL BTNummer,  teil_ist_diebstahlrelevant Teil_Diebstahlrelevant  from w_ben_gk ben_teil, w_ben_gk ben_komm, w_teil, w_bildtaf, w_btzeilenugb, w_btzeilenugb_verbauung where btzeilenuv_marke_tps = ? and btzeilenu_btnr = btzeilenuv_btnr and btzeilenu_pos = btzeilenuv_pos and bildtaf_btnr = btzeilenuv_btnr and bildtaf_produktart = ? and bildtaf_vbereich in (?, ?) and teil_sachnr = btzeilenu_sachnr and ben_teil.ben_textcode = teil_textcode and ben_teil.ben_iso = ? and ben_teil.ben_regiso = ? and ben_komm.ben_textcode = teil_textcode_kom and ben_komm.ben_iso = ? and ben_komm.ben_regiso = ?  and &BEGRIFFE_BEN_TEIL_KOMM_STMT&&ORDER_BY_BENENNUNG_HG_UG_SACHNUMMER&";
        }

        @Override
        public final String SEARCH_BT_SACHNUMMER_COMPL() {
            return "select distinct bildtaf_btnr BildtafelNr, bildtaf_bteart BildtafelArt, ben_text Benennung, bildtaf_kommbt Kommentar, bildtaf_vorh_cp CPVorhanden, bildtaf_bedkez BedingungKZ, bildtaf_pos Pos, marktetk_isokz MarktIso from w_markt_etk, w_ben_gk, w_bildtaf, w_btzeilenugb, w_btzeilenugb_verbauung where btzeilenuv_marke_tps = ? and btzeilenu_btnr = btzeilenuv_btnr and btzeilenu_pos = btzeilenuv_pos and btzeilenu_sachnr = ? and bildtaf_btnr = btzeilenu_btnr and bildtaf_produktart = ? and bildtaf_vbereich in (?, ?) and ben_textcode = bildtaf_textc and ben_iso = ? and ben_regiso = ? and marktetk_lkz (+) = bildtaf_lkz order by Pos";
        }

        @Override
        public final String SEARCH_BT_NUMMER_COMPL() {
            return "select distinct bildtaf_btnr BildtafelNr, bildtaf_bteart BildtafelArt, ben_text Benennung, bildtaf_kommbt Kommentar, bildtaf_vorh_cp CPVorhanden, bildtaf_bedkez BedingungKZ, bildtaf_pos Pos, marktetk_isokz MarktIso from w_markt_etk, w_ben_gk, w_bildtaf, w_btzeilenugb, w_btzeilenugb_verbauung where btzeilenuv_marke_tps = ? and btzeilenu_btnr = btzeilenuv_btnr and btzeilenu_pos = btzeilenuv_pos and bildtaf_btnr = ? and bildtaf_btnr = btzeilenu_btnr and bildtaf_produktart = ? and bildtaf_vbereich in (?, ?) and ben_textcode = bildtaf_textc and ben_iso = ? and ben_regiso = ? and marktetk_lkz (+) = bildtaf_lkz order by Pos";
        }

        @Override
        public final String SEARCH_SNR_SACHNUMMER_INCOMPL() {
            return "select distinct teil_hauptgr Hauptgruppe, teil_untergrup Untergruppe, teil_sachnr Sachnummer, ben_teil.ben_text Benennung, teil_benennzus Zusatz, ben_komm.ben_text BenennungKommentar,  teil_ist_diebstahlrelevant Teil_Diebstahlrelevant  from w_ben_gk ben_teil, w_ben_gk ben_komm, w_teil, w_bildtaf, w_btzeilenugb, w_btzeilenugb_verbauung where btzeilenuv_marke_tps = ? and btzeilenu_btnr = btzeilenuv_btnr and btzeilenu_pos = btzeilenuv_pos and btzeilenu_sachnr like ? and bildtaf_btnr = btzeilenu_btnr and bildtaf_produktart = ? and bildtaf_vbereich in (?, ?) and teil_sachnr = btzeilenu_sachnr and ben_teil.ben_textcode = teil_textcode and ben_teil.ben_iso = ? and ben_teil.ben_regiso = ? and ben_komm.ben_textcode (+) = teil_textcode_kom and ben_komm.ben_iso (+) = ? and ben_komm.ben_regiso (+) = ?  order by Benennung, Hauptgruppe, Untergruppe, Sachnummer";
        }

        @Override
        public final String SEARCH_SNR_FREMDNR() {
            return "select distinct teil_hauptgr Hauptgruppe, teil_untergrup Untergruppe, teil_sachnr Sachnummer, ben_teil.ben_text Benennung, teil_benennzus Zusatz, ben_komm.ben_text BenennungKommentar,  teil_ist_diebstahlrelevant Teil_Diebstahlrelevant  from w_ben_gk ben_teil, w_ben_gk ben_komm, w_teil, w_bildtaf, w_btzeilenugb, w_btzeilenugb_verbauung where btzeilenuv_marke_tps = ? and btzeilenu_btnr = btzeilenuv_btnr and btzeilenu_pos = btzeilenuv_pos and btzeilenu_sachnr IN (&IN&) and bildtaf_btnr = btzeilenu_btnr and bildtaf_produktart = ? and bildtaf_vbereich in (?, ?) and teil_sachnr = btzeilenu_sachnr and ben_teil.ben_textcode = teil_textcode and ben_teil.ben_iso = ? and ben_teil.ben_regiso = ? and ben_komm.ben_textcode (+) = teil_textcode_kom and ben_komm.ben_iso (+) = ? and ben_komm.ben_regiso (+) = ?  order by Benennung, Hauptgruppe, Untergruppe, Sachnummer";
        }

        @Override
        public final String SEARCH_BT_SACHNUMMERN() {
            return "select distinct bildtaf_btnr BildtafelNr, bildtaf_bteart BildtafelArt, ben_text Benennung, bildtaf_kommbt Kommentar, bildtaf_vorh_cp CPVorhanden, bildtaf_bedkez BedingungKZ, bildtaf_pos Pos, marktetk_isokz MarktIso from w_markt_etk, w_ben_gk, w_bildtaf, w_btzeilenugb, w_btzeilenugb_verbauung where btzeilenuv_marke_tps = ? and btzeilenu_btnr = btzeilenuv_btnr and btzeilenu_pos = btzeilenuv_pos and btzeilenu_sachnr IN (&IN3&) and bildtaf_btnr = btzeilenu_btnr and bildtaf_produktart = ? and bildtaf_vbereich in (?, ?) and ben_textcode = bildtaf_textc and ben_iso = ? and ben_regiso = ? and marktetk_lkz (+) = bildtaf_lkz&ORDER_BY_POS&";
        }

        @Override
        public final String SEARCH_BT_HGFG() {
            return "select distinct bildtaf_btnr BildtafelNr, bildtaf_bteart BildtafelArt, ben_text Benennung, bildtaf_kommbt Kommentar, bildtaf_vorh_cp CPVorhanden, bildtaf_bedkez BedingungKZ, bildtaf_pos Pos, marktetk_isokz MarktIso from w_markt_etk, w_ben_gk, w_bildtaf, w_btzeilenugb, w_btzeilenugb_verbauung where btzeilenuv_marke_tps = ? and btzeilenu_btnr = btzeilenuv_btnr and btzeilenu_pos = btzeilenuv_pos and bildtaf_btnr = btzeilenu_btnr and bildtaf_produktart = ? and bildtaf_vbereich in (?, ?)&HG/HGFG_STMT& and ben_textcode = bildtaf_textc and ben_iso = ? and ben_regiso = ? and marktetk_lkz (+) = bildtaf_lkz order by Pos";
        }

        @Override
        public final String SEARCH_BT_HG_GRAFISCH() {
            return "select distinct bildtaf_btnr BildtafelNr, bildtaf_bteart BildtafelArt, BB.ben_text Benennung, bildtaf_pos Pos, bildtaf_grafikid GrafikId, bildtaf_bedkez BedingungKZ, grafik_moddate ModStamp, marktetk_isokz MarktIso  from w_btzeilenugb, w_btzeilenugb_verbauung, w_bildtaf left join w_markt_etk on (marktetk_lkz = bildtaf_lkz) left join w_ben_gk BB on (bildtaf_textc = BB.ben_textcode and BB.ben_iso = ? and BB.ben_regiso = ?) left join w_grafik on (grafik_grafikid = bildtaf_grafikid and grafik_art = ?) where btzeilenuv_marke_tps = ? and btzeilenu_btnr = btzeilenuv_btnr and btzeilenu_pos = btzeilenuv_pos and bildtaf_btnr = btzeilenu_btnr and bildtaf_produktart = ? and bildtaf_vbereich in (?, ?) and bildtaf_hg = ? order by Pos";
        }

        @Override
        public final String SEARCH_BT_HG_FG_GRAFISCH() {
            return "select distinct bildtaf_btnr BildtafelNr, bildtaf_bteart BildtafelArt, BB.ben_text Benennung, bildtaf_pos Pos, bildtaf_grafikid GrafikId, bildtaf_bedkez BedingungKZ, grafik_moddate ModStamp, marktetk_isokz MarktIso  from w_btzeilenugb_verbauung inner join w_btzeilenugb on (btzeilenuv_btnr = btzeilenu_btnr and btzeilenuv_pos = btzeilenu_pos) left join w_bildtaf on (btzeilenu_btnr = bildtaf_btnr) left join w_grafik on (bildtaf_grafikid = grafik_grafikid and grafik_art = ?) left join w_ben_gk BB on (bildtaf_textc = ben_textcode and ben_iso = ? and ben_regiso = ?) left join w_markt_etk on (marktetk_lkz = bildtaf_lkz) where btzeilenuv_marke_tps = ? and bildtaf_produktart = ? and bildtaf_vbereich in (?, ?) and bildtaf_hg = ? and bildtaf_fg = ? order by Pos";
        }

        @Override
        public final String SEARCH_BT_HG_GRAFISCH_MIT_GRAFIKEN() {
            return "nur fuer transbase";
        }

        @Override
        public final String SEARCH_BT_HG_FG_GRAFISCH_MIT_GRAFIKEN() {
            return "nur fuer transbase";
        }

        @Override
        public final String CHECK_BT_HG_GRAFISCH() {
            return "select count(bildtaf_btnr) countBte from w_grafik, w_bildtaf, w_btzeilenugb, w_btzeilenugb_verbauung where btzeilenuv_marke_tps = ? and btzeilenu_btnr = btzeilenuv_btnr and btzeilenu_pos = btzeilenuv_pos and bildtaf_btnr = btzeilenu_btnr and bildtaf_produktart = ? and bildtaf_vbereich in (?, ?) and bildtaf_hg = ? and grafik_grafikid (+) = bildtaf_grafikid and grafik_art (+) = ?";
        }

        @Override
        public final String SEARCH_BILDTAF_HGFG() {
            return " and bildtaf_hg || bildtaf_fg in (&HGFGS&)";
        }

        @Override
        public final String SEARCH_BILDTAF_HG() {
            return " and bildtaf_hg = ?";
        }

        @Override
        public final String ORDER_BY_POS() {
            return " order by Pos";
        }

        @Override
        public final String ORDER_BY_BENENNUNG_HG_UG_SACHNUMMER() {
            return " order by Benennung, Hauptgruppe, Untergruppe, Sachnummer";
        }
    }

    public static final class TeilesucheAllgemein
    extends SQLStatements.TeilesucheAllgemein {
        @Override
        public final String LOAD_MARKT_BENENNUNG() {
            return " select lj11.ben_text MarktBen  from   w_bildtaf t1     ,   w_markt_etk lj1     ,   w_ben_gk lj11  where t1.bildtaf_btnr = ?  and   t1.bildtaf_produktart = ?  and ( lj1.marktetk_lkz (+) = t1.bildtaf_lkz )  and ( lj11.ben_textcode (+) = lj1.marktetk_textcode  and   lj11.ben_iso (+) = ?  and   lj11.ben_regiso (+) = ? ) ";
        }
    }

    public static final class TeilesucheFzg
    extends SQLStatements.TeilesucheFzg {
        @Override
        public final String RETRIEVE_HGS() {
            return "select distinct hgfg_hg Hauptgruppe, ben_text Benennung, hgthb_grafikid GrafikId, grafik_moddate ModStamp from w_grafik, w_hg_thumbnail, w_hgfg, w_ben_gk, w_hgfg_mosp where hgfgm_mospid = ? and hgfg_hg = hgfgm_hg and hgfg_fg = ? and hgfg_produktart = hgfgm_produktart and hgfg_bereich = hgfgm_bereich and ben_textcode = hgfg_textcode and ben_iso = ? and ben_regiso = ? and hgthb_hg (+) = hgfg_hg and hgthb_marke_tps (+) = ? and hgthb_produktart (+) = hgfg_produktart and hgthb_bereich (+) = hgfg_bereich and grafik_grafikid (+) = hgthb_grafikid and grafik_art (+) = ? order by Hauptgruppe";
        }

        @Override
        public final String RETRIEVE_HGS_GRAF() {
            return "select distinct hgfg_hg Hauptgruppe, ben_text Benennung, hgthb_grafikid GrafikId, grafik_moddate ModStamp, NULL Grafik from w_grafik, w_hg_thumbnail, w_hgfg, w_ben_gk, w_hgfg_mosp where hgfgm_mospid = ? and hgfg_hg = hgfgm_hg and hgfg_fg = ? and hgfg_produktart = hgfgm_produktart and hgfg_bereich = hgfgm_bereich and ben_textcode = hgfg_textcode and ben_iso = ? and ben_regiso = ? and hgthb_hg (+) = hgfg_hg and hgthb_marke_tps (+) = ? and hgthb_produktart (+) = hgfg_produktart and hgthb_bereich (+) = hgfg_bereich and grafik_grafikid (+) = hgthb_grafikid and grafik_art (+) = ? order by Hauptgruppe";
        }

        @Override
        public final String RETRIEVE_FGS_GRAF() {
            return "select distinct hgfg_fg Funktionsgruppe,ben_text Benennung,fgthb_grafikid GrafikId,grafik_moddate ModStamp from w_hgfg  inner join w_ben_gk on (hgfg_textcode = ben_textcode and ben_iso = ? and ben_regiso = ?) left join w_fg_thumbnail on (hgfg_hg = fgthb_hg and hgfg_fg = fgthb_fg and fgthb_marke_tps = ? and fgthb_produktart = hgfg_produktart and fgthb_bereich = hgfg_bereich) left join w_grafik on (fgthb_grafikid = grafik_grafikid and grafik_art = ?) inner join w_bildtaf on (bildtaf_hg = hgfg_hg and hgfg_fg = bildtaf_fg)  where hgfg_hg = ? AND hgfg_produktart = ? order by Funktionsgruppe";
        }

        @Override
        public final String RETRIEVE_FGS_GRAF_MOSP() {
            return "select distinct hgfg_fg Funktionsgruppe, ben_text Benennung, fgthb_grafikid GrafikId, grafik_moddate ModStamp from w_hgfg_mosp inner join w_hgfg on (hgfgm_hg = hgfg_hg and hgfg_produktart = hgfgm_produktart and hgfg_bereich = hgfgm_bereich) inner join w_ben_gk on (hgfg_textcode = ben_textcode and ben_iso = ? and ben_regiso = ?) left join w_fg_thumbnail on (hgfg_hg = fgthb_hg and hgfg_fg = fgthb_fg and fgthb_marke_tps = ? and fgthb_produktart = hgfg_produktart and fgthb_bereich = hgfg_bereich) left join w_grafik on (fgthb_grafikid = grafik_grafikid and grafik_art = ?) inner join w_bildtaf on (bildtaf_hg = hgfgm_hg and hgfgm_fg = bildtaf_fg)  where hgfgm_mospid = ? AND hgfgm_hg = ? order by Funktionsgruppe";
        }

        @Override
        public final String RETRIEVE_FGS_GRAF_MIT_GRAFIKEN() {
            return "select distinct hgfg_fg Funktionsgruppe,ben_text Benennung,fgthb_grafikid GrafikId,grafik_moddate ModStamp,grafik_blob Grafik from w_hgfg  inner join w_ben_gk on (hgfg_textcode = ben_textcode and ben_iso = ? and ben_regiso = ?) left join w_fg_thumbnail on (hgfg_hg = fgthb_hg and hgfg_fg = fgthb_fg and fgthb_marke_tps = ? and fgthb_produktart = hgfg_produktart and fgthb_bereich = hgfg_bereich) left join w_grafik on (fgthb_grafikid = grafik_grafikid and grafik_art = ?) inner join w_bildtaf on (bildtaf_hg = hgfg_hg and hgfg_fg = bildtaf_fg)  where hgfg_hg = ? AND hgfg_produktart = ? order by Funktionsgruppe";
        }

        @Override
        public final String RETRIEVE_FGS_GRAF_MOSP_MIT_GRAFIKEN() {
            return "select distinct hgfg_fg Funktionsgruppe, ben_text Benennung, fgthb_grafikid GrafikId, grafik_moddate ModStamp, grafik_blob Grafik from w_hgfg_mosp inner join w_hgfg on (hgfgm_hg = hgfg_hg and hgfg_fg = ? and hgfg_produktart = hgfgm_produktart and hgfg_bereich = hgfgm_bereich) inner join w_ben_gk on (hgfg_textcode = ben_textcode and ben_iso = ? and ben_regiso = ?) left join w_fg_thumbnail on (hgfg_hg = fgthb_hg and hgfg_fg = fgthb_fg and fgthb_marke_tps = ? and fgthb_produktart = hgfg_produktart and fgthb_bereich = hgfg_bereich) left join w_grafik on (fgthb_grafikid = grafik_grafikid and grafik_art = ?) inner join w_bildtaf on (bildtaf_hg = hgfgm_hg and hgfgm_fg = bildtaf_fg)  where hgfgm_mospid = ? AND hgfgm_hg = ? order by Funktionsgruppe";
        }

        @Override
        public final String RETRIEVE_HGFGS() {
            return "select distinct hgfg_hg Hauptgruppe, hgfg_fg Funktionsgruppe, ben_text Benennung from w_hgfg, w_ben_gk, w_hgfg_mosp where hgfgm_mospid = ? and hgfgm_hg = ? and hgfg_hg = hgfgm_hg and hgfg_fg = hgfgm_fg and hgfg_produktart = hgfgm_produktart and hgfg_bereich = hgfgm_bereich and ben_textcode = hgfg_textcode and ben_iso = ? and ben_regiso = ? order by Hauptgruppe, Funktionsgruppe";
        }

        @Override
        public final String RETRIEVE_ALL_HGFGS() {
            return "select hgfg_hg Hauptgruppe, hgfg_fg Funktionsgruppe, ben_text Benennung from w_hgfg, w_ben_gk, w_hgfg_mosp where hgfgm_mospid = ? and hgfg_hg = hgfgm_hg and hgfg_fg = ? and hgfg_produktart = hgfgm_produktart and hgfg_bereich = hgfgm_bereich and ben_textcode = hgfg_textcode and ben_iso = ? and ben_regiso = ? union  select hgfg_hg Hauptgruppe, hgfg_fg Funktionsgruppe, ben_text Benennung from w_hgfg, w_ben_gk, w_hgfg_mosp where hgfgm_mospid = ? and hgfg_hg = hgfgm_hg and hgfg_fg = hgfgm_fg and hgfg_produktart = hgfgm_produktart and hgfg_bereich = hgfgm_bereich and ben_textcode = hgfg_textcode and ben_iso = ? and ben_regiso = ? order by 1, 2";
        }

        @Override
        public final String SEARCH_BT_BENENNUNG() {
            return "select distinct bildtaf_btnr BildtafelNr, bildtaf_bteart BildtafelArt, ben_text Benennung, bildtaf_pos Pos, bildtaf_kommbt Kommentar, bildtaf_vorh_cp CPVorhanden, bildtaf_bedkez BedingungKZ, marktetk_isokz MarktIso from w_markt_etk, w_ben_gk, w_bildtaf, w_bildtaf_suche where bildtafs_mospid = ?&LENKUNG_STMT&&GETRIEBE_STMT&&EINSATZ_STMT&&AUSLAUF_STMT& and bildtaf_btnr = bildtafs_btnr&BEACHTE_SICHER_FLAG_STMT& and ben_textcode = bildtaf_textc and ben_iso = ? and ben_regiso = ? and upper(ben_text) like upper(N'&SUCHSTRING&') and marktetk_lkz (+) = bildtaf_lkz&UNION&&SEARCH_BT_BENENNUNG_ASS& order by Pos";
        }

        @Override
        public final String SEARCH_BT_BENENNUNG_SONDERLOCKE() {
            return "select distinct bildtaf_btnr BildtafelNr, bildtaf_bteart BildtafelArt, ben_text Benennung, bildtaf_pos Pos, bildtaf_kommbt Kommentar, bildtaf_vorh_cp CPVorhanden, bildtaf_bedkez BedingungKZ, marktetk_isokz MarktIso from w_markt_etk, w_ben_gk, w_bildtaf, w_bildtaf_suche where bildtafs_mospid = ?&LENKUNG_STMT&&GETRIEBE_STMT&&EINSATZ_STMT&&AUSLAUF_STMT& and bildtaf_btnr = bildtafs_btnr&BEACHTE_SICHER_FLAG_STMT& and ben_textcode = bildtaf_textc and ben_iso = ? and ben_regiso = ? and (upper(ben_text) like upper(N'&SUCHSTRING1&') or upper(ben_text) like upper(N'&SUCHSTRING2&')) and marktetk_lkz (+) = bildtaf_lkz&UNION&&SEARCH_BT_BENENNUNG_SONDERLOCKE_ASS& order by Pos";
        }

        @Override
        public final String SEARCH_BT_BENENNUNG_TR() {
            return "select distinct bildtaf_btnr BildtafelNr, bildtaf_bteart BildtafelArt, ben_text Benennung, bildtaf_pos Pos, bildtaf_kommbt Kommentar, bildtaf_vorh_cp CPVorhanden, bildtaf_bedkez BedingungKZ, marktetk_isokz MarktIso from w_markt_etk, w_ben_gk, w_bildtaf, w_bildtaf_suche where bildtafs_mospid = ?&LENKUNG_STMT&&GETRIEBE_STMT&&EINSATZ_STMT&&AUSLAUF_STMT& and bildtaf_btnr = bildtafs_btnr&BEACHTE_SICHER_FLAG_STMT& and ben_textcode = bildtaf_textc and ben_iso = ? and ben_regiso = ? and upper(replace(ben_text,'i',chr(50352))) like N'&SUCHSTRING&' and marktetk_lkz (+) = bildtaf_lkz&UNION&&SEARCH_BT_BENENNUNG_ASS& order by Pos";
        }

        @Override
        public final String SEARCH_BT_BEGRIFF() {
            return "select distinct bildtaf_btnr BildtafelNr, bildtaf_bteart BildtafelArt, ben_text Benennung, bildtaf_kommbt Kommentar, bildtaf_vorh_cp CPVorhanden, bildtaf_bedkez BedingungKZ, bildtaf_pos Pos, marktetk_isokz MarktIso from w_markt_etk, w_ben_gk, w_bildtaf, w_bildtaf_suche where bildtafs_mospid = &MOSP&&LENKUNG_STMT&&GETRIEBE_STMT&&EINSATZ_STMT&&AUSLAUF_STMT& and bildtaf_btnr = bildtafs_btnr&BEACHTE_SICHER_FLAG_STMT& and ben_textcode = bildtaf_textc and ben_iso = '&ISO&' and ben_regiso = '&REGISO&' and &BEGRIFFE_BEN_STMT& and marktetk_lkz (+) = bildtaf_lkz&UNION&&SEARCH_BT_BEGRIFF_ASS& order by Pos";
        }

        @Override
        public final String SEARCH_BT_BEGRIFF_NEU() {
            return "select distinct bildtaf_btnr BildtafelNr, bildtaf_bteart BildtafelArt, ben_text Benennung, bildtaf_kommbt Kommentar, bildtaf_vorh_cp CPVorhanden, bildtaf_bedkez BedingungKZ, bildtaf_pos Pos, marktetk_isokz MarktIso from w_markt_etk, w_ben_gk, w_bildtaf, w_bildtaf_suche where bildtafs_mospid = ?&LENKUNG_STMT&&GETRIEBE_STMT&&EINSATZ_STMT&&AUSLAUF_STMT& and bildtaf_btnr = bildtafs_btnr&BEACHTE_SICHER_FLAG_STMT& and ben_textcode = bildtaf_textc and ben_iso = ? and ben_regiso = ? and &BEGRIFFE_BEN_STMT& and marktetk_lkz (+) = bildtaf_lkz&UNION&&SEARCH_BT_BEGRIFF_ASS& union select distinct bildtaf_btnr BildtafelNr, bildtaf_bteart BildtafelArt, ben_bte.ben_text Benennung, bildtaf_kommbt Kommentar, bildtaf_vorh_cp CPVorhanden, bildtaf_bedkez BedingungKZ, bildtaf_pos Pos, marktetk_isokz MarktIso from w_markt_etk    , w_ben_gk ben_komm     , w_komm_help     , w_komm     , w_bildtaf_suche     , w_bildtaf     , w_ben_gk ben_bte where ben_komm.ben_iso = ?  and ben_komm.ben_regiso = ?  and &BEGRIFFE_BEN_KOMM_STMT&  and komm_textcode = ben_komm.ben_textcode  and kommh_id = komm_id  and kommh_mospid = ?  and kommh_btnr = bildtaf_btnr  and ben_bte.ben_iso = ?  and ben_bte.ben_regiso = ?  and ben_bte.ben_textcode = bildtaf_textc and bildtaf_btnr = bildtafs_btnr &BEACHTE_SICHER_FLAG_STMT& and bildtafs_mospid = kommh_mospid &LENKUNG_STMT&&GETRIEBE_STMT&&EINSATZ_STMT&&AUSLAUF_STMT& and marktetk_lkz (+) = bildtaf_lkz order by Pos";
        }

        @Override
        public final String SEARCH_BILDTAFS_LENKUNG() {
            return " and (bildtafs_lenkg is NULL OR bildtafs_lenkg = ?)";
        }

        @Override
        public final String SEARCH_BILDTAFS_GETRIEBE() {
            return " and (bildtafs_automatik is NULL OR bildtafs_automatik = ?)";
        }

        @Override
        public final String SEARCH_BILDTAFS_EINSATZ() {
            return " and (bildtafs_eins is NULL OR bildtafs_eins <= ?)";
        }

        @Override
        public final String SEARCH_BILDTAFS_AUSLAUF() {
            return " and (bildtafs_auslf is NULL OR ? <= bildtafs_auslf)";
        }

        @Override
        public final String SEARCH_SNR_BENENNUNG() {
            return "select distinct teil_hauptgr Hauptgruppe, teil_untergrup Untergruppe, teil_sachnr Sachnummer, ben_teil.ben_text Benennung, teil_benennzus Zusatz, ben_komm.ben_text BenennungKommentar, btzeilenv_alter_kz BTZeilenAlter, CASE nvl(btzeilenv_alter_kz, 'NULL') WHEN 'NULL' then NULL else btzeilenv_pos end Pos, CASE nvl(btzeilenv_alter_kz, 'NULL') WHEN 'NULL' then NULL else btzeilenv_btnr end BTNummer,  teil_ist_diebstahlrelevant Teil_Diebstahlrelevant  from w_bildtaf, w_ben_gk ben_teil, w_ben_gk ben_komm, w_teil, w_btzeilen, w_btzeilen_verbauung where btzeilenv_mospid = ? and btzeilen_btnr = btzeilenv_btnr and btzeilen_pos = btzeilenv_pos&LENKUNG_STMT&&GETRIEBE_STMT&&EINSATZ_STMT&&AUSLAUF_STMT& and bildtaf_btnr = btzeilen_btnr&BEACHTE_SICHER_FLAG_STMT& and teil_sachnr = btzeilen_sachnr and ben_teil.ben_textcode = teil_textcode and ben_teil.ben_iso = ? and ben_teil.ben_regiso = ? and upper(ben_teil.ben_text) like upper(N'&SUCHSTRING&') and ben_komm.ben_textcode (+) = teil_textcode_kom and ben_komm.ben_iso (+) = ? and ben_komm.ben_regiso (+) = ? &UNION&&SEARCH_SNR_BENENNUNG_ASS& order by Benennung, Hauptgruppe, Untergruppe, Sachnummer";
        }

        @Override
        public final String SEARCH_SNR_BENENNUNG_SONDERLOCKE() {
            return "select distinct teil_hauptgr Hauptgruppe, teil_untergrup Untergruppe, teil_sachnr Sachnummer, ben_teil.ben_text Benennung, teil_benennzus Zusatz, ben_komm.ben_text BenennungKommentar, btzeilenv_alter_kz BTZeilenAlter, CASE nvl(btzeilenv_alter_kz, 'NULL') WHEN 'NULL' then NULL else btzeilenv_pos end Pos, CASE nvl(btzeilenv_alter_kz, 'NULL') WHEN 'NULL' then NULL else btzeilenv_btnr end BTNummer,  teil_ist_diebstahlrelevant Teil_Diebstahlrelevant  from w_bildtaf, w_ben_gk ben_teil, w_ben_gk ben_komm, w_teil, w_btzeilen, w_btzeilen_verbauung where btzeilenv_mospid = ? and btzeilen_btnr = btzeilenv_btnr and btzeilen_pos = btzeilenv_pos&LENKUNG_STMT&&GETRIEBE_STMT&&EINSATZ_STMT&&AUSLAUF_STMT& and bildtaf_btnr = btzeilen_btnr&BEACHTE_SICHER_FLAG_STMT& and teil_sachnr = btzeilen_sachnr and ben_teil.ben_textcode = teil_textcode and ben_teil.ben_iso = ? and ben_teil.ben_regiso = ? and (upper(ben_teil.ben_text) like upper(N'&SUCHSTRING1&') or upper(ben_teil.ben_text) like upper(N'&SUCHSTRING2&')) and ben_komm.ben_textcode (+) = teil_textcode_kom and ben_komm.ben_iso (+) = ? and ben_komm.ben_regiso (+) = ? &UNION&&SEARCH_SNR_BENENNUNG_SONDERLOCKE_ASS& order by Benennung, Hauptgruppe, Untergruppe, Sachnummer";
        }

        @Override
        public final String SEARCH_SNR_BENENNUNG_TR() {
            return "select distinct teil_hauptgr Hauptgruppe, teil_untergrup Untergruppe, teil_sachnr Sachnummer, ben_teil.ben_text Benennung, teil_benennzus Zusatz, ben_komm.ben_text BenennungKommentar, btzeilenv_alter_kz BTZeilenAlter, CASE nvl(btzeilenv_alter_kz, 'NULL') WHEN 'NULL' then NULL else btzeilenv_pos end Pos, CASE nvl(btzeilenv_alter_kz, 'NULL') WHEN 'NULL' then NULL else btzeilenv_btnr end BTNummer,  teil_ist_diebstahlrelevant Teil_Diebstahlrelevant  from w_bildtaf, w_ben_gk ben_teil, w_ben_gk ben_komm, w_teil, w_btzeilen, w_btzeilen_verbauung where btzeilenv_mospid = ? and btzeilen_btnr = btzeilenv_btnr and btzeilen_pos = btzeilenv_pos&LENKUNG_STMT&&GETRIEBE_STMT&&EINSATZ_STMT&&AUSLAUF_STMT& and bildtaf_btnr = btzeilen_btnr&BEACHTE_SICHER_FLAG_STMT& and teil_sachnr = btzeilen_sachnr and ben_teil.ben_textcode = teil_textcode and ben_teil.ben_iso = ? and ben_teil.ben_regiso = ? and upper(replace(ben_teil.ben_text,'i',chr(50352))) like N'&SUCHSTRING&' and ben_komm.ben_textcode (+) = teil_textcode_kom and ben_komm.ben_iso (+) = ? and ben_komm.ben_regiso (+) = ? &UNION&&SEARCH_SNR_BENENNUNG_ASS& order by Benennung, Hauptgruppe, Untergruppe, Sachnummer";
        }

        @Override
        public final String SEARCH_SNR_BEGRIFF() {
            return "select distinct teil_hauptgr Hauptgruppe, teil_untergrup Untergruppe, teil_sachnr Sachnummer, ben_teil.ben_text Benennung, teil_benennzus Zusatz, ben_komm.ben_text BenennungKommentar, btzeilenv_alter_kz BTZeilenAlter, CASE nvl(btzeilenv_alter_kz, 'NULL') WHEN 'NULL' then NULL else btzeilenv_pos end Pos, CASE nvl(btzeilenv_alter_kz, 'NULL') WHEN 'NULL' then NULL else btzeilenv_btnr end BTNummer,  teil_ist_diebstahlrelevant Teil_Diebstahlrelevant  from w_bildtaf, w_ben_gk ben_teil, w_ben_gk ben_komm, w_teil, w_btzeilen, w_btzeilen_verbauung where btzeilenv_mospid = ? and btzeilen_btnr = btzeilenv_btnr and btzeilen_pos = btzeilenv_pos&LENKUNG_STMT&&GETRIEBE_STMT&&EINSATZ_STMT&&AUSLAUF_STMT& and bildtaf_btnr = btzeilen_btnr&BEACHTE_SICHER_FLAG_STMT& and teil_sachnr = btzeilen_sachnr and ben_teil.ben_textcode = teil_textcode and ben_teil.ben_iso = ? and ben_teil.ben_regiso = ? and &BEGRIFFE_BEN_TEIL_STMT& and ben_komm.ben_textcode (+) = teil_textcode_kom and ben_komm.ben_iso (+) = ? and ben_komm.ben_regiso (+) = ? union select distinct teil_hauptgr Hauptgruppe, teil_untergrup Untergruppe, teil_sachnr Sachnummer, ben_teil.ben_text Benennung, teil_benennzus Zusatz, ben_komm.ben_text BenennungKommentar, btzeilenv_alter_kz BTZeilenAlter, CASE nvl(btzeilenv_alter_kz, 'NULL') WHEN 'NULL' then NULL else btzeilenv_pos end Pos, CASE nvl(btzeilenv_alter_kz, 'NULL') WHEN 'NULL' then NULL else btzeilenv_btnr end BTNummer,  teil_ist_diebstahlrelevant Teil_Diebstahlrelevant  from w_bildtaf, w_ben_gk ben_teil, w_ben_gk ben_komm, w_teil, w_btzeilen, w_btzeilen_verbauung where btzeilenv_mospid = ? and btzeilen_btnr = btzeilenv_btnr and btzeilen_pos = btzeilenv_pos&LENKUNG_STMT&&GETRIEBE_STMT&&EINSATZ_STMT&&AUSLAUF_STMT& and bildtaf_btnr = btzeilen_btnr&BEACHTE_SICHER_FLAG_STMT& and teil_sachnr = btzeilen_sachnr and ben_teil.ben_textcode = teil_textcode and ben_teil.ben_iso = ? and ben_teil.ben_regiso = ? and ben_komm.ben_textcode = teil_textcode_kom and ben_komm.ben_iso = ? and ben_komm.ben_regiso = ? and &BEGRIFFE_BEN_TEIL_KOMM_STMT&&UNION&&SEARCH_SNR_BEGRIFF_ASS& order by Benennung, Hauptgruppe, Untergruppe, Sachnummer";
        }

        @Override
        public final String SEARCH_BT_SACHNUMMER_COMPL() {
            return "select distinct bildtaf_btnr BildtafelNr, bildtaf_bteart BildtafelArt, ben_text Benennung, bildtaf_kommbt Kommentar, bildtaf_vorh_cp CPVorhanden, bildtaf_bedkez BedingungKZ, bildtaf_pos Pos, marktetk_isokz MarktIso from w_markt_etk, w_ben_gk, w_bildtaf, w_btzeilen, w_btzeilen_verbauung where btzeilenv_mospid = ? and btzeilenv_sachnr = ? and btzeilen_btnr = btzeilenv_btnr and btzeilen_pos = btzeilenv_pos&LENKUNG_STMT&&GETRIEBE_STMT&&EINSATZ_STMT&&AUSLAUF_STMT& and bildtaf_btnr = btzeilen_btnr and bildtaf_produktart = ?&BEACHTE_SICHER_FLAG_STMT& and ben_textcode = bildtaf_textc and ben_iso = ? and ben_regiso = ? and marktetk_lkz (+) = bildtaf_lkz order by Pos";
        }

        @Override
        public final String SEARCH_BT_NUMMER_COMPL() {
            return "select distinct bildtaf_btnr BildtafelNr, bildtaf_bteart BildtafelArt, ben_text Benennung, bildtaf_kommbt Kommentar, bildtaf_vorh_cp CPVorhanden, bildtaf_bedkez BedingungKZ, bildtaf_pos Pos, marktetk_isokz MarktIso from w_markt_etk, w_ben_gk, w_bildtaf, w_btzeilen, w_btzeilen_verbauung where btzeilenv_mospid = ? and  bildtaf_btnr = ? and btzeilen_btnr = btzeilenv_btnr and btzeilen_pos = btzeilenv_pos&LENKUNG_STMT&&GETRIEBE_STMT&&EINSATZ_STMT&&AUSLAUF_STMT& and bildtaf_btnr = btzeilen_btnr and bildtaf_produktart = ?&BEACHTE_SICHER_FLAG_STMT& and ben_textcode = bildtaf_textc and ben_iso = ? and ben_regiso = ? and marktetk_lkz (+) = bildtaf_lkz order by Pos";
        }

        @Override
        public final String SEARCH_SNR_SACHNUMMER_INCOMPL() {
            return "select distinct teil_hauptgr Hauptgruppe, teil_untergrup Untergruppe, teil_sachnr Sachnummer, ben_teil.ben_text Benennung, teil_benennzus Zusatz, ben_komm.ben_text BenennungKommentar, marktetk_isokz MarktIso,  teil_ist_diebstahlrelevant Teil_Diebstahlrelevant  from w_markt_etk, w_bildtaf, w_ben_gk ben_teil, w_ben_gk ben_komm, w_teil, w_btzeilen, w_btzeilen_verbauung where btzeilenv_mospid = ? and btzeilenv_sachnr like ? and btzeilen_btnr = btzeilenv_btnr and btzeilen_pos = btzeilenv_pos&LENKUNG_STMT&&GETRIEBE_STMT&&EINSATZ_STMT&&AUSLAUF_STMT& and bildtaf_btnr = btzeilen_btnr&BEACHTE_SICHER_FLAG_STMT& and teil_sachnr = btzeilen_sachnr and ben_teil.ben_textcode = teil_textcode and ben_teil.ben_iso = ? and ben_teil.ben_regiso = ? and ben_komm.ben_textcode (+) = teil_textcode_kom and ben_komm.ben_iso (+) = ? and ben_komm.ben_regiso (+) = ? and marktetk_lkz (+) = bildtaf_lkz order by Benennung, Hauptgruppe, Untergruppe, Sachnummer";
        }

        @Override
        public final String SEARCH_SNR_FREMDNR() {
            return "select distinct teil_hauptgr Hauptgruppe, teil_untergrup Untergruppe, teil_sachnr Sachnummer, ben_teil.ben_text Benennung, teil_benennzus Zusatz, ben_komm.ben_text BenennungKommentar, marktetk_isokz MarktIso,  teil_ist_diebstahlrelevant Teil_Diebstahlrelevant  from w_markt_etk, w_bildtaf, w_ben_gk ben_teil, w_ben_gk ben_komm, w_teil, w_btzeilen, w_btzeilen_verbauung where btzeilenv_mospid = ? and btzeilenv_sachnr IN (&IN&) and btzeilen_btnr = btzeilenv_btnr and btzeilen_pos = btzeilenv_pos&LENKUNG_STMT&&GETRIEBE_STMT&&EINSATZ_STMT&&AUSLAUF_STMT& and bildtaf_btnr = btzeilen_btnr&BEACHTE_SICHER_FLAG_STMT& and teil_sachnr = btzeilen_sachnr and ben_teil.ben_textcode = teil_textcode and ben_teil.ben_iso = ? and ben_teil.ben_regiso = ? and ben_komm.ben_textcode (+) = teil_textcode_kom and ben_komm.ben_iso (+) = ? and ben_komm.ben_regiso (+) = ? and marktetk_lkz (+) = bildtaf_lkz order by Benennung, Hauptgruppe, Untergruppe, Sachnummer";
        }

        @Override
        public final String SEARCH_BT_SACHNUMMERN() {
            return "select distinct bildtaf_btnr BildtafelNr, bildtaf_bteart BildtafelArt, ben_text Benennung, bildtaf_kommbt Kommentar, bildtaf_vorh_cp CPVorhanden, bildtaf_bedkez BedingungKZ, bildtaf_pos Pos, marktetk_isokz MarktIso from w_markt_etk, w_ben_gk, w_bildtaf, w_btzeilen, w_btzeilen_verbauung where btzeilenv_mospid = ? and btzeilenv_sachnr IN (&IN&) and btzeilen_btnr = btzeilenv_btnr and btzeilen_pos = btzeilenv_pos&LENKUNG_STMT&&GETRIEBE_STMT&&EINSATZ_STMT&&AUSLAUF_STMT& and bildtaf_btnr = btzeilen_btnr&BEACHTE_SICHER_FLAG_STMT& and ben_textcode = bildtaf_textc and ben_iso = ? and ben_regiso = ? and marktetk_lkz (+) = bildtaf_lkz&UNION&&SEARCH_BT_SACHNUMMERN_ASS& order by Pos";
        }

        @Override
        public final String SEARCH_BTZEILEN_LENKUNG() {
            return " and (btzeilen_lenkg is NULL OR btzeilen_lenkg = ?)";
        }

        @Override
        public final String SEARCH_BTZEILEN_GETRIEBE() {
            return " and (btzeilen_automatik is NULL OR btzeilen_automatik = ?)";
        }

        @Override
        public final String SEARCH_BTZEILEN_EINSATZ() {
            return " and (btzeilen_eins is NULL OR btzeilen_eins <= ?)";
        }

        @Override
        public final String SEARCH_BTZEILEN_AUSLAUF() {
            return " and (btzeilen_auslf is NULL OR ? <= btzeilen_auslf)";
        }

        @Override
        public final String SEARCH_BT_HGFG() {
            return "select distinct bildtaf_btnr BildtafelNr, bildtaf_bteart BildtafelArt, ben_text Benennung, bildtaf_kommbt Kommentar, bildtaf_vorh_cp CPVorhanden, bildtaf_bedkez BedingungKZ, bildtaf_pos Pos, marktetk_isokz MarktIso from w_markt_etk, w_ben_gk, w_bildtaf, w_bildtaf_suche where bildtafs_hg = ? and bildtafs_mospid = ?&LENKUNG_STMT&&GETRIEBE_STMT&&EINSATZ_STMT&&AUSLAUF_STMT& and bildtafs_btnr = bildtaf_btnr&HG/HGFG_STMT&&BEACHTE_SICHER_FLAG_STMT& and bildtaf_textc = ben_textcode and ben_iso = ? and ben_regiso = ? and marktetk_lkz (+) = bildtaf_lkz order by Pos";
        }

        @Override
        public final String SEARCH_ALL_BT_NUMBERS() {
            return "select distinct bildtaf_btnr BildtafelNr from w_bildtaf, w_bildtaf_suche where bildtafs_mospid = ?&LENKUNG_STMT&&GETRIEBE_STMT&&EINSATZ_STMT&&AUSLAUF_STMT& and bildtafs_btnr = bildtaf_btnr&BEACHTE_SICHER_FLAG_STMT&";
        }

        @Override
        public final String SEARCH_BT_HG_GRAFISCH() {
            return "select distinct bildtaf_btnr BildtafelNr, bildtaf_bteart BildtafelArt, BB.ben_text Benennung, bildtaf_pos Pos, bildtaf_grafikid GrafikId, bildtaf_bedkez BedingungKZ, grafik_moddate ModStamp, marktetk_isokz MarktIso  from w_btzeilen, w_btzeilen_verbauung, w_bildtaf left join w_markt_etk on (marktetk_lkz = bildtaf_lkz) left join w_ben_gk BB on (bildtaf_textc = BB.ben_textcode and BB.ben_iso = ? and BB.ben_regiso = ?) left join w_grafik on (grafik_grafikid = bildtaf_grafikid and grafik_art = ?) where btzeilenv_mospid = ? and btzeilen_btnr = btzeilenv_btnr and btzeilen_pos = btzeilenv_pos&LENKUNG_STMT&&GETRIEBE_STMT&&EINSATZ_STMT&&AUSLAUF_STMT& and bildtaf_btnr = btzeilen_btnr and bildtaf_hg = ?&BEACHTE_SICHER_FLAG_STMT& order by Pos";
        }

        @Override
        public final String SEARCH_BT_HG_FG_GRAFISCH() {
            return "select distinct bildtaf_btnr BildtafelNr, bildtaf_bteart BildtafelArt, BB.ben_text Benennung, bildtaf_pos Pos, bildtaf_grafikid GrafikId, bildtaf_bedkez BedingungKZ, grafik_moddate ModStamp, marktetk_isokz MarktIso  from w_btzeilenugb_verbauung inner join w_btzeilenugb on (btzeilenuv_btnr = btzeilenu_btnr and btzeilenuv_pos = btzeilenu_pos) left join w_bildtaf on (btzeilenu_btnr = bildtaf_btnr) left join w_grafik on (bildtaf_grafikid = grafik_grafikid and grafik_art = 'T') left join w_ben_gk BB on (bildtaf_textc = ben_textcode and BB.ben_iso = '&ISO&' and BB.ben_regiso = '&REGISO&') left join w_markt_etk on (marktetk_lkz = bildtaf_lkz) where btzeilenuv_marke_tps = '&MARKE&' and bildtaf_produktart = '&PRODUKTART&' and bildtaf_vbereich in ('BE', '&KATALOGUMFANG&') and bildtaf_hg = '&HG&' and bildtaf_fg = '&FG&' order by Pos";
        }

        @Override
        public final String SEARCH_BT_HG_FG_GRAFISCH_CENTRAL() {
            return "select distinct bildtaf_btnr BildtafelNr, bildtaf_bteart BildtafelArt, BB.ben_text Benennung, bildtaf_pos Pos, bildtaf_grafikid GrafikId, bildtaf_bedkez BedingungKZ, grafik_moddate ModStamp, marktetk_isokz MarktIso  from w_btzeilen_verbauung inner join w_btzeilen on (btzeilenv_btnr = btzeilen_btnr and btzeilenv_pos = btzeilen_pos) inner join w_bildtaf on (btzeilen_btnr = bildtaf_btnr) left join w_grafik on (bildtaf_grafikid = grafik_grafikid and grafik_art = ?) inner join w_ben_gk BB on (bildtaf_textc = BB.ben_textcode and BB.ben_iso = ? and BB.ben_regiso = ?) left join w_markt_etk on (marktetk_lkz = bildtaf_lkz) where btzeilenv_mospid = ?&LENKUNG_STMT&&GETRIEBE_STMT&&EINSATZ_STMT&&AUSLAUF_STMT&and bildtaf_hg || bildtaf_fg in (?)&BEACHTE_SICHER_FLAG_STMT& order by Pos";
        }

        @Override
        public final String SEARCH_BT_HG_GRAFISCH_MIT_GRAFIKEN() {
            return "nur transbase";
        }

        @Override
        public final String SEARCH_BT_HG_FG_GRAFISCH_MIT_GRAFIKEN() {
            return "nur transbase";
        }

        @Override
        public final String CHECK_BT_HG_GRAFISCH() {
            return "select count(bildtaf_btnr) countBte from w_grafik, w_bildtaf, w_btzeilen, w_btzeilen_verbauung where btzeilenv_mospid = ? and btzeilen_btnr = btzeilenv_btnr and btzeilen_pos = btzeilenv_pos&LENKUNG_STMT&&GETRIEBE_STMT&&EINSATZ_STMT&&AUSLAUF_STMT& and bildtaf_btnr = btzeilen_btnr&BEACHTE_SICHER_FLAG_STMT& and bildtaf_hg = ? and grafik_grafikid (+) = bildtaf_grafikid and grafik_art (+) = ?";
        }

        @Override
        public final String SEARCH_BILDTAF_HGFG() {
            return " and bildtaf_hg || bildtaf_fg in (&HGFGS&)";
        }

        @Override
        public final String SEARCH_NUR_NICHT_SICHERHEITSRELEVANTE_BILDTAFELN() {
            return " and bildtaf_sicher = ?";
        }

        @Override
        public final String SEARCH_KABELBAUM_CHANGEPOINTS() {
            return "select distinct btzeilenc_pos Pos, btzeilenc_typschl Typ, btzeilenc_werk Werk, btzeilenc_art Art, btzeilenc_datum Datum, btzeilenc_vin Vin, btzeilenc_vin_proddatum VinProddatum, btzeilenc_vin_min VinMin, btzeilenc_vin_max VinMax, btzeilenc_nart ArtNummer, btzeilenc_nummer Nummer, btzeilenc_alter CPAlter from w_btzeilen_cp where btzeilenc_mospid = ? and btzeilenc_typschl = ? and btzeilenc_werk = ? and btzeilenc_pos = ? and btzeilenc_btnr = ?";
        }
    }

    public static final class TeilesucheSpezifischValueLineFzg
    extends SQLStatements.TeilesucheSpezifischValueLineFzg {
        @Override
        public final String RETRIEVE_BTES_VALUE_LINE() {
            return " select distinct                     bildtaf_hg BildtafelHG,                     bildtaf_btnr BildtafelNr,            \t\t\tbildtaf_bteart BildtafelArt, \t\t\t\t\tben_text Benennung, \t\t\t\t\tbildtaf_pos Pos, \t\t\t\t\tbildtaf_kommbt Kommentar, \t\t\t\t\tbildtaf_vorh_cp CPVorhanden, \t\t\t\t\tbildtaf_bedkez BedingungKZ, \t\t\t\t\tmarktetk_isokz MarktIso  from  \t\t\t\tw_hgfg, \t\t\t\t\tw_bildtaf left join w_markt_etk on (marktetk_lkz = bildtaf_lkz), \t\t\t\t\tw_ben_gk , \t\t\t\t\tw_bildtaf_suche  where \t\t\t\thgfg_ist_valueline = ?  and \t\t\t\tbildtaf_hg = hgfg_hg  and \t\t\t\tbildtaf_fg = hgfg_fg  and \t\t\t\tbildtafs_btnr = bildtaf_btnr  and \t\t\t\tbildtafs_hg = bildtaf_hg  and \t\t\t\tbildtafs_mospid = ?  and \t\t\t\tben_textcode = bildtaf_textc  and \t\t\t\tben_iso = ?  and \t\t\t\tben_regiso = ?  union  select distinct                     bildtaf_hg BildtafelHG,                     bildtaf_btnr BildtafelNr,            \t\t\tbildtaf_bteart BildtafelArt, \t\t\t\t\tben_text Benennung, \t\t\t\t\tbildtaf_pos Pos, \t\t\t\t\tbildtaf_kommbt Kommentar, \t\t\t\t\tbildtaf_vorh_cp CPVorhanden, \t\t\t\t\tbildtaf_bedkez BedingungKZ, \t\t\t\t\tmarktetk_isokz MarktIso  from              w_kompl_satz     ,              w_btzeilen_verbauung     ,              w_bildtaf left join w_markt_etk on (marktetk_lkz = bildtaf_lkz)     ,              w_ben_gk     ,              w_bildtaf_suche  where             ks_ist_valueline = ?  and               ks_sachnr_satz = btzeilenv_sachnr  and               ks_hg = bildtaf_hg  and               btzeilenv_btnr   = bildtaf_btnr  and               btzeilenv_mospid = bildtafs_mospid  and               bildtafs_btnr = bildtaf_btnr  and               bildtafs_hg = bildtaf_hg  and               bildtafs_mospid = ?  and               ben_textcode = bildtaf_textc  and               ben_iso = ?  and               ben_regiso = ?  order by          BildtafelHG         ,          BildtafelNr ";
        }
    }

    public static final class FzgUmfang
    extends SQLStatements.FzgUmfang {
        @Override
        public final String RETRIEVE_REGIONEN() {
            return "select distinct fztyp_ktlgausf Region from w_fztyp, w_baureihe where baureihe_marke_tps = ?  and baureihe_produktart = ?  and baureihe_vbereich in (? , ? ) and fztyp_baureihe = baureihe_baureihe and fztyp_vbereich = ?  and fztyp_ktlgausf in (&IN&) and fztyp_sichtschutz = ? order by Region";
        }

        @Override
        public final String RETRIEVE_LENKUNGEN() {
            return "select distinct fztyp_lenkung Lenkung, ben_text ExtLenkung from w_ben_gk, w_publben, w_fztyp, w_baureihe where baureihe_marke_tps = ? and baureihe_produktart = ? and baureihe_vbereich in (? , ?) and fztyp_baureihe = baureihe_baureihe and fztyp_vbereich = ? and fztyp_ktlgausf in (&IN&) and publben_art = ? and publben_bezeichnung = fztyp_lenkung and ben_textcode = publben_textcode and ben_iso = ? and ben_regiso = ? order by Lenkung";
        }

        @Override
        public final String RETRIEVE_BAUARTEN() {
            return "select distinct baureihe_bauart Bauart, ben_text ExtBauart, bauart_position Pos from w_ben_gk, w_bauart, w_fztyp, w_baureihe where baureihe_marke_tps = ? and baureihe_produktart = ? and baureihe_vbereich in (?, ?) and fztyp_baureihe = baureihe_baureihe and fztyp_vbereich = ? and fztyp_ktlgausf in (&IN&) and fztyp_sichtschutz = ? and bauart_bauart = baureihe_bauart and ben_textcode = bauart_textcode and ben_iso = ? and ben_regiso = ? order by Pos";
        }

        @Override
        public final String RETRIEVE_BAUREIHEN() {
            return "select distinct baureihe_baureihe Baureihe, ben_text ExtBaureihe, baureihe_position Pos from w_ben_gk, w_fztyp, w_baureihe where baureihe_marke_tps = ? and baureihe_produktart = ? and baureihe_vbereich in (?, ?) &BAUART_STMT& and fztyp_baureihe = baureihe_baureihe and fztyp_vbereich = ? and fztyp_ktlgausf in (&IN1&) &LENKUNG_STMT& and fztyp_sichtschutz = ? and ben_textcode = baureihe_textcode and ben_iso = ? and ben_regiso = ? order by Pos";
        }

        @Override
        public final String RETRIEVE_KAROSSERIEN() {
            return "select distinct fztyp_karosserie Karosserie, ben_text ExtKarosserie from w_ben_gk, w_publben, w_fztyp where fztyp_baureihe IN (&IN1&) and fztyp_vbereich = ? and fztyp_ktlgausf in (&IN2&) and fztyp_lenkung IN (&IN3&) and fztyp_sichtschutz = ? and publben_art = ? and publben_bezeichnung = fztyp_karosserie and ben_textcode = publben_textcode and ben_iso = ? and ben_regiso = ? order by ExtKarosserie";
        }

        @Override
        public final String RETRIEVE_MODELLE() {
            return "select distinct fztyp_erwvbez Modell, vbezp_pos Pos from w_vbez_pos, w_fztyp, w_baureihe where baureihe_baureihe IN (&IN1&) and fztyp_baureihe = baureihe_baureihe and fztyp_vbereich = ?  &BAUART_STMT& &KAROSSERIE_STMT& and fztyp_ktlgausf in (&IN5&) &LENKUNG_STMT& and fztyp_sichtschutz = ? and vbezp_baureihe = baureihe_baureihe and vbezp_vbez = fztyp_vbez order by Pos, Modell";
        }

        @Override
        public final String RETRIEVE_MODELLSPALTEN() {
            return "select distinct fztyp_mospid MospID from w_fztyp, w_baureihe where baureihe_baureihe IN (&IN1&) and fztyp_baureihe = baureihe_baureihe and fztyp_vbereich = ? &MODELL_STMT& &BAUART_STMT& &KAROSSERIE_STMT& and fztyp_ktlgausf in (&IN&) &LENKUNG_STMT& and fztyp_sichtschutz = ?  order by MospID";
        }

        @Override
        public final String MODELL_STMT() {
            return " and fztyp_erwvbez IN (&IN5&)";
        }

        @Override
        public final String RETRIEVE_BAUART() {
            return " and baureihe_bauart IN (&IN2&)";
        }

        @Override
        public final String RETRIEVE_KAROSSERIE() {
            return " and fztyp_karosserie IN (&IN4&)";
        }

        @Override
        public final String RETRIEVE_LENKUNG() {
            return " and fztyp_lenkung IN (&IN3&)";
        }
    }

    public static final class FzgIdentifikation
    extends SQLStatements.FzgIdentifikation {
        @Override
        public final String RETRIEVE_BAUARTEN() {
            return "select distinct baureihe_bauart Bauart, ben_text ExtBauart, bauart_position Pos from w_ben_gk, w_bauart, w_fztyp, w_baureihe where baureihe_marke_tps = ? and baureihe_produktart = ? and baureihe_vbereich in (?, ?) and fztyp_baureihe = baureihe_baureihe and fztyp_vbereich = ? and fztyp_ktlgausf in (&IN&) and fztyp_sichtschutz = ? and bauart_bauart = baureihe_bauart and ben_textcode = bauart_textcode and ben_iso = ? and ben_regiso = ? order by Pos";
        }

        @Override
        public final String RETRIEVE_BAUREIHEN() {
            return "select distinct baureihe_baureihe Baureihe, ben_text ExtBaureihe, baureihe_position Pos from w_ben_gk, w_fztyp, w_baureihe where baureihe_marke_tps = ? and baureihe_produktart = ? and baureihe_vbereich in (?, ?) &BAUART_STMT& and fztyp_baureihe = baureihe_baureihe and fztyp_vbereich = ? and fztyp_ktlgausf in (&IN&) &LENKUNG_STMT& and fztyp_sichtschutz = ? and ben_textcode = baureihe_textcode and ben_iso = ? and ben_regiso = ? order by Pos";
        }

        @Override
        public final String GET_GRAFIKID_FOR_BAUREIHE() {
            return "select grafik_grafikid GrafikId, grafik_moddate ModStamp from w_grafik, w_baureihe where baureihe_baureihe = ? and grafik_grafikid = baureihe_grafikid and grafik_art = ?";
        }

        @Override
        public final String GET_GRAFIKID_FOR_BAUREIHE_KAROSSERIE() {
            return "select grafik_grafikid GrafikId, grafik_moddate ModStamp from w_grafik, w_baureihe_kar_thb where baureihekar_baureihe = ? and baureihekar_karosserie = ? and grafik_grafikid = baureihekar_grafikid and grafik_art = ?";
        }

        @Override
        public final String GET_GRAFIKID_FOR_FIBILD() {
            return "select grafik_grafikid GrafikId, grafik_format Format, grafik_moddate ModStamp from w_grafik, w_etk_grafiken where etkgraf_ablauf = ? and etkgraf_marke = ? and etkgraf_produktart = ? and etkgraf_vbereich = ? and grafik_grafikid = etkgraf_grafikid and grafik_art = ?";
        }

        @Override
        public final String RETRIEVE_KAROSSERIEN() {
            return "select distinct fztyp_karosserie Karosserie, ben_text ExtKarosserie from w_ben_gk, w_publben, w_fztyp where fztyp_baureihe = ? and fztyp_vbereich = ? and fztyp_ktlgausf in (&IN&) &LENKUNG_STMT& and fztyp_sichtschutz = ? and publben_art = ? and publben_bezeichnung = fztyp_karosserie and ben_textcode = publben_textcode and ben_iso = ? and ben_regiso = ? order by ExtKarosserie";
        }

        @Override
        public final String RETRIEVE_MODELLE() {
            return "select distinct fztyp_erwvbez Modell, vbezp_pos Pos from w_vbez_pos, w_fztyp where fztyp_baureihe = ? and fztyp_vbereich = ? &KAROSSERIE_STMT& and fztyp_ktlgausf in (&IN&) &LENKUNG_STMT& and fztyp_sichtschutz = ? and vbezp_baureihe = fztyp_baureihe and vbezp_vbez = fztyp_vbez order by Pos, Modell";
        }

        @Override
        public final String RETRIEVE_REGIONEN() {
            return "select distinct fztyp_ktlgausf Region from w_fztyp where fztyp_baureihe = ? and fztyp_vbereich = ? &KAROSSERIE_STMT& and fztyp_erwvbez = ? and fztyp_ktlgausf in (&IN&) &LENKUNG_STMT& and fztyp_sichtschutz = ? order by Region";
        }

        @Override
        public final String RETRIEVE_LENKUNGEN() {
            return "select distinct fztyp_lenkung Lenkung, ben_text ExtLenkung from w_ben_gk, w_publben, w_fztyp where fztyp_baureihe = ? and fztyp_vbereich = ? and fztyp_karosserie = ? and fztyp_erwvbez = ? and fztyp_ktlgausf = ? and fztyp_sichtschutz = ? and publben_art = ? and publben_bezeichnung = fztyp_lenkung and ben_textcode = publben_textcode and ben_iso = ? and ben_regiso = ? order by Lenkung";
        }

        @Override
        public final String RETRIEVE_GETRIEBEARTEN() {
            return "select distinct fztyp_getriebe Getriebe, ben_text ExtGetriebe from w_ben_gk, w_publben, w_fztyp where fztyp_baureihe = ? and fztyp_vbereich = ? and fztyp_karosserie = ? and fztyp_erwvbez = ? and fztyp_ktlgausf = ? &LENKUNG_STMT& and fztyp_sichtschutz = ? and publben_art = ? and publben_bezeichnung = fztyp_getriebe and ben_textcode = publben_textcode and ben_iso = ? and ben_regiso = ? order by Getriebe";
        }

        @Override
        public final String RETRIEVE_BAUJAHRE() {
            return "select distinct substr(to_char(fgstnr_prod), 1, 4) Baujahr from w_fgstnr, w_fztyp where fztyp_baureihe = ? and fztyp_vbereich = ? &KAROSSERIE_STMT& and fztyp_erwvbez = ? and fztyp_ktlgausf = ? &LENKUNG_STMT& &GETRIEBE_STMT& and fztyp_sichtschutz = ? and fgstnr_typschl = fztyp_typschl order by Baujahr";
        }

        @Override
        public final String RETRIEVE_ZULASSMONATE() {
            return "select distinct substr(to_char(fgstnr_prod), 5, 2) Zulassungsmonat, ben_text ExtZulassungsmonat from w_ben_gk, w_publben, w_fgstnr, w_fztyp where fztyp_baureihe = ? and fztyp_vbereich = ? &KAROSSERIE_STMT& and fztyp_erwvbez = ? and fztyp_ktlgausf = ? &LENKUNG_STMT& &GETRIEBE_STMT& and fztyp_sichtschutz = ? and fgstnr_typschl = fztyp_typschl and substr(fgstnr_prod, 1, 4) = ? and publben_art = ? and publben_bezeichnung = substr(to_char(fgstnr_prod), 5, 2) and ben_textcode = publben_textcode and ben_iso = ? and ben_regiso = ? order by Zulassungsmonat";
        }

        @Override
        public final String RETRIEVE_ZULASSMONATE2() {
            return "select distinct substr(to_char(fgstnr_prod), 5, 2) Zulassungsmonat, ben_text ExtZulassungsmonat from w_ben_gk, w_publben, w_fgstnr, w_fztyp where fztyp_baureihe = ? and fztyp_vbereich = ? &KAROSSERIE_STMT& and fztyp_erwvbez = ? and fztyp_ktlgausf = ? &LENKUNG_STMT& &GETRIEBE_STMT& and fztyp_sichtschutz = ? and fgstnr_typschl = fztyp_typschl and publben_art = ? and publben_bezeichnung = substr(to_char(fgstnr_prod), 5, 2) and ben_textcode = publben_textcode and ben_iso = ? and ben_regiso = ? order by Zulassungsmonat";
        }

        @Override
        public final String RETRIEVE_BAUART() {
            return " and baureihe_bauart = ?";
        }

        @Override
        public final String RETRIEVE_KAROSSERIE() {
            return " and fztyp_karosserie = ?";
        }

        @Override
        public final String RETRIEVE_LENKUNG() {
            return " and fztyp_lenkung = ?";
        }

        @Override
        public final String RETRIEVE_GETRIEBE() {
            return " and fztyp_getriebe = ?";
        }

        @Override
        public final String RETRIEVE_MOSP_BY_ATTRIBUTE_PKW() {
            return "select distinct fztyp_mospid Modellspalte from w_fztyp where fztyp_baureihe = ? and fztyp_karosserie = ? and fztyp_erwvbez = ? and fztyp_ktlgausf = ?";
        }

        @Override
        public final String RETRIEVE_MOSP_BY_ATTRIBUTE_KRAD() {
            return "select distinct fztyp_mospid Modellspalte from w_fztyp where fztyp_baureihe = ? and fztyp_erwvbez = ? and fztyp_ktlgausf = ?";
        }

        @Override
        public final String RETRIEVE_MOSP_BY_FGSTNR() {
            return "select distinct fgstnr_mospid Modellspalte, fgstnr_typschl Typ, fgstnr_werk Werk, baureihe_marke_tps Marke, baureihe_produktart Produktart, fztyp_vbereich Katalogumfang, fztyp_baureihe Baureihe, b.ben_text ExtBaureihe, baureihe_bauart Bauart, bb.ben_text ExtBauart, fztyp_karosserie Karosserie, bk.ben_text ExtKarosserie, fztyp_motor Motor, fztyp_erwvbez Modell, fztyp_ktlgausf Region, fztyp_lenkung Lenkung, fztyp_getriebe Getriebe, fgstnr_prod Produktionsdatum, fztyp_sichtschutz Sichtschutz, NVL(fztyp_einsatz, 0) Einsatz from w_fgstnr inner join w_fztyp on (fgstnr_typschl = fztyp_typschl and fgstnr_mospid = fztyp_mospid) inner join w_baureihe on (fztyp_baureihe = baureihe_baureihe) inner join w_publben pk on (fztyp_karosserie = pk.publben_bezeichnung and pk.publben_art = ?) inner join w_publben pb on (baureihe_bauart = pb.publben_bezeichnung and pb.publben_art = ?) inner join w_ben_gk b on (baureihe_textcode = b.ben_textcode and b.ben_iso = ? and b.ben_regiso = ?) inner join w_ben_gk bk on (pk.publben_textcode = bk.ben_textcode and bk.ben_iso = ? and bk.ben_regiso = ?) inner join w_ben_gk bb on (pb.publben_textcode = bb.ben_textcode and bb.ben_iso = ? and bb.ben_regiso = ?) where fgstnr_von <= ? and fgstnr_bis >= ? and fgstnr_anf  = ? &GET_DATA_WITH_FGSTNR_TYP&";
        }

        @Override
        public final String GET_DATA_WITH_FGSTNR_TYP() {
            return " and fgstnr_typschl  = ?";
        }

        @Override
        public final String RETRIEVE_MOSP_BY_TYP() {
            return " select distinct fztyp_mospid Modellspalte, fztyp_typschl Typ, null Werk, baureihe_marke_tps Marke, baureihe_produktart Produktart, fztyp_vbereich Katalogumfang, fztyp_baureihe Baureihe, b.ben_text ExtBaureihe, baureihe_bauart Bauart, bb.ben_text ExtBauart, fztyp_karosserie Karosserie, bk.ben_text ExtKarosserie, fztyp_motor Motor, fztyp_erwvbez Modell, fztyp_ktlgausf Region, fztyp_lenkung Lenkung, fztyp_getriebe Getriebe, '&PRODDATUM&' Produktionsdatum, fztyp_sichtschutz Sichtschutz, NVL(fztyp_einsatz, 0) Einsatz from w_baureihe, w_ben_gk b, w_ben_gk bk, w_publben pk, w_ben_gk bb, w_publben pb, w_fztyp where fztyp_typschl = ? and baureihe_baureihe = fztyp_baureihe and pk.publben_art = ? and pk.publben_bezeichnung = fztyp_karosserie and bk.ben_textcode = pk.publben_textcode and bk.ben_iso = ? and bk.ben_regiso = ? and pb.publben_art = ? and pb.publben_bezeichnung = baureihe_bauart and bb.ben_textcode = pb.publben_textcode and bb.ben_iso = ? and bb.ben_regiso = ? and b.ben_textcode = baureihe_textcode and b.ben_iso = ? and b.ben_regiso = ?";
        }

        @Override
        public final String RETRIEVE_TYPMENGE_BY_ATTRIBUTE_PKW() {
            return "select distinct fztyp_typschl Typ from w_fgstnr, w_fztyp where fztyp_mospid = ? and fztyp_sichtschutz = ? and fztyp_lenkung = ? and fztyp_getriebe = ? and fgstnr_mospid = fztyp_mospid and fgstnr_typschl = fztyp_typschl and fgstnr_prod = ?";
        }

        @Override
        public final String RETRIEVE_TYPMENGE_BY_ATTRIBUTE_KRAD() {
            return "select distinct fztyp_typschl Typ from w_fgstnr, w_fztyp where fztyp_mospid = ? and fztyp_sichtschutz = ? and fgstnr_mospid = fztyp_mospid and fgstnr_typschl = fztyp_typschl and fgstnr_prod = ?";
        }

        @Override
        public final String RETRIEVE_LENKUNG_BEN() {
            return "select ben_text Name from w_ben_gk, w_publben where ben_textcode = publben_textcode and ben_iso = ? and ben_regiso = ? and publben_art = ? and publben_bezeichnung = ?";
        }

        @Override
        public final String LOAD_SALAS_ZU_FGSTNR() {
            return "select distinct bed_elemid ElementId, bedsala_art || bedsala_pnr || bedsala_hz Code, ben_text Benennung, bed_egid EGruppenId, bedsala_sicher Sicher, bedsala_saz SAZ, NVL(REPLACE(bedzus_elemid, bedzus_elemid, 'J'), 'N') HasBedText, fgstnrs_showtext ShowBedText, eg_exklusiv Exklusiv, eg_pos EGruppenPosition, bedsala_pnr PrimaNr from w_bed_zusatzinfo, w_bed_sala, w_ben_gk, w_bed, w_eg, w_fgstnr_sala where fgstnrs_fgstnr = ? and fgstnrs_salaid = bedsala_id and bedsala_id = bed_elemid and bed_egid = eg_id and bed_textcode = ben_textcode and ben_iso = ? and ben_regiso = ? and bedzus_elemid (+) = bedsala_id";
        }

        @Override
        public final String LOAD_SS_BEDINGUNGEN_AF() {
            return "select distinct bed_elemid ElementId, af.bedafl_code Code, ben_text Benennung, bed_egid EGruppenId, bed_vorhanden_info VorhandenInfo, eg_exklusiv Exklusiv, af.bedafl_art Bedingungsart, eg_pos EGruppenPosition from w_ben_gk, w_bed, w_eg, w_bed_afl af where af.bedafl_art = ? &LOAD_SS_BEDINGUNGEN_AF_DECIDE& and af.bedafl_gilt_v <= ? and NVL(af.bedafl_gilt_b, 99999999) >= ? and af.bedafl_id = bed_elemid and bed_egid = eg_id and bed_textcode = ben_textcode and ben_iso = ? and ben_regiso = ?union select distinct bed_elemid ElementId, f.bedafl_code Code, ben_text Benennung, bed_egid EGruppenId, bed_vorhanden_info VorhandenInfo, eg_exklusiv Exklusiv, f.bedafl_art Bedingungsart, eg_pos EGruppenPosition from w_bed_afl f, w_ben_gk, w_bed, w_eg, w_bed_afl af where af.bedafl_art = ? &LOAD_SS_BEDINGUNGEN_AF_DECIDE& and af.bedafl_gilt_v <= ? and NVL(af.bedafl_gilt_b, 99999999) >= ? and f.bedafl_art = ? and f.bedafl_code = substr(af.bedafl_code, 3) and f.bedafl_gilt_v <= ? and NVL(f.bedafl_gilt_b, 99999999) >= ? and f.bedafl_id = bed_elemid and bed_egid = eg_id and bed_textcode = ben_textcode and ben_iso = ? and ben_regiso = ?union select distinct bed_elemid ElementId, a.bedafl_code Code, ben_text Benennung, bed_egid EGruppenId, bed_vorhanden_info VorhandenInfo, eg_exklusiv Exklusiv, a.bedafl_art Bedingungsart, eg_pos EGruppenPosition from w_bed_afl a, w_ben_gk, w_bed, w_eg, w_bed_afl af where af.bedafl_art= ? &LOAD_SS_BEDINGUNGEN_AF_DECIDE& and a.bedafl_art = ? and a.bedafl_code = substr(af.bedafl_code, 1, 2) and a.bedafl_gilt_v <= ? and NVL(a.bedafl_gilt_b, 99999999) >= ? and a.bedafl_id = bed_elemid and bed_egid = eg_id and bed_textcode = ben_textcode and ben_iso = ? and ben_regiso = ?";
        }

        @Override
        public final String LOAD_SS_BEDINGUNGEN_AF_BY_AFCODE() {
            return " and af.bedafl_code = ?";
        }

        @Override
        public final String LOAD_SS_BEDINGUNGEN_AF_BY_POLSTERCODE() {
            return " and af.bedafl_pcode = ?";
        }

        @Override
        public final String LOAD_SS_BEDINGUNGEN_LACK() {
            return "select distinct bed_elemid ElementId, bedafl_code Code, ben_text Benennung, bed_egid EGruppenId, bed_vorhanden_info VorhandenInfo, eg_exklusiv Exklusiv, eg_pos EGruppenPosition from w_ben_gk, w_bed, w_eg, w_bed_afl where bedafl_art= ? and bedafl_gilt_v <= ? and NVL(bedafl_gilt_b, 99999999) >= ? &LOAD_SS_BEDINGUNGEN_LACK_DECIDE& and bedafl_id = bed_elemid and bed_egid = eg_id and bed_textcode = ben_textcode and ben_iso = ? and ben_regiso = ?";
        }

        @Override
        public final String LOAD_SS_BEDINGUNGEN_LACK_EXACT() {
            return " and bedafl_code = ?";
        }

        @Override
        public final String LOAD_SS_BEDINGUNGEN_LACK_LIKE() {
            return " and bedafl_code like ?";
        }

        @Override
        public final String LOAD_SS_BEDINGUNGEN_SALAPA() {
            return "select distinct bed_elemid ElementId, bedsala_art || bedsala_pnr || bedsala_hz Code, ben_text Benennung, bed_egid EGruppenId, bed_vorhanden_info VorhandenInfo, eg_exklusiv Exklusiv, bedsala_sicher Sicher, bedsala_saz SAZ, eg_pos EGruppenPosition, bedsala_pnr PrimaNr from w_ben_gk, w_bed, w_eg, w_bed_sala where bedsala_produktart = ? and bedsala_pnr = ? and bedsala_gilt_v <= ? and NVL(bedsala_gilt_b, 99999999) >= ? and bedsala_art not in ('N', 'V') &LOAD_SS_BEDINGUNGEN_SALAPA_DECIDE_ART& &LOAD_SS_BEDINGUNGEN_SALAPA_DECIDE_HZAEHLER& and bedsala_id = bed_elemid and bed_egid = eg_id and bed_textcode = ben_textcode and ben_iso = ? and ben_regiso = ?";
        }

        @Override
        public final String LOAD_SS_BEDINGUNGEN_SALAPA_BY_ART() {
            return " and bedsala_art = ?";
        }

        @Override
        public final String LOAD_SS_BEDINGUNGEN_SALAPA_BY_HZEAHLER() {
            return " and bedsala_hz = ?";
        }

        @Override
        public final String RETRIEVE_BED_ZUSATZINFO() {
            return "select komm_id KommId, ben_text Ben, komm_pos Pos from w_ben_gk, w_komm where komm_id in   (select bedzus_kommid     from w_bed_zusatzinfo     where bedzus_elemid IN (&BED_ELEMIDS&)   minus    select bedzus_kommid     from w_bed_zusatzinfo     where bedzus_elemid NOT IN (&BED_ELEMIDS&)) and   komm_textcode = ben_textcode and   ben_iso = ? and   ben_regiso = ? order by KommId, Pos";
        }

        @Override
        public final String RETRIEVE_ZUSATZINFO_MARKE() {
            return " select ben_text  from   w_publben     ,   w_ben_gk  where  publben_art = ? and    publben_bezeichnung like ?  and    publben_textcode = ben_textcode  and    ben_iso = ?  and    ben_regiso = ?  order by publben_bezeichnung ";
        }

        @Override
        public String RETRIEVE_VIN17_DATEN_BY_TYP() {
            return "select distinct fztyp_typschl Typ, b.ben_text ExtBaureihe, fztyp_erwvbez Modell, fztyp_ktlgausf Region from w_fztyp inner join w_baureihe on (fztyp_baureihe = baureihe_baureihe) inner join w_publben pk on (fztyp_karosserie = pk.publben_bezeichnung and pk.publben_art = 'K') inner join w_ben_gk bk on (pk.publben_textcode = bk.ben_textcode and bk.ben_iso = '&ISO&' and bk.ben_regiso = '&REGISO&') inner join w_publben pb on (baureihe_bauart = pb.publben_bezeichnung and pb.publben_art = 'B') inner join w_ben_gk bb on (pb.publben_textcode = bb.ben_textcode and bb.ben_iso = '&ISO&' and bb.ben_regiso = '&REGISO&') inner join w_ben_gk b on (baureihe_textcode = b.ben_textcode and b.ben_iso = '&ISO&' and b.ben_regiso = '&REGISO&') where fztyp_typschl = '&TYP&'";
        }
    }

    public static final class Einstellungen
    extends SQLStatements.Einstellungen {
        @Override
        public final String RETRIEVE_EINSTELLUNGEN() {
            return "select user_marke, user_produktart, user_lenkung, user_katalogumfang, user_iso, user_regiso, user_expand_bnb, user_short_searchpath, user_request_saz, user_show_proddate, user_primaermarkt_id,  user_vinBlockRequired, user_vinBlockRequired_DVD, EXCLUDE_IP_VINBLOCK_WEBETK, EXCLUDE_ALL_IP_VINBLOCK_WEBETK, EXCLUDE_IPADDRESS_VINBLOCK_DVD, EXCLUDE_ALL_IP_VINBLOCK_DVD,  user_dft_verbaumenge  from w_user_einstellungen where user_id = ?";
        }

        @Override
        public final String RETRIEVE_EINSTELLUNGEN_JAVA() {
            return "nur transbase";
        }

        @Override
        public final String RETRIEVE_EINSTELLUNGEN_MARKTID_JAVA() {
            return "nur transbase";
        }

        @Override
        public final String RETRIEVE_IPAC_MARKT() {
            return "nur transbase";
        }

        @Override
        public final String UPDATE_MARKTID() {
            return "nur transbase";
        }

        @Override
        public final String RETRIEVE_EINSTELLUNGEN_REGIONEN() {
            return "select user_region from w_user_einstellungen_region where user_id = ?";
        }

        @Override
        public final String RETRIEVE_EINSTELLUNGEN_REGIONEN_JAVA() {
            return "select user_region from w_user_einstellungen_region@etk_nutzer where user_firma_id = '&FIRMAID&' and user_id = '&ID&'";
        }

        @Override
        public final String DELETE_EINSTELLUNGEN() {
            return "delete from w_user_einstellungen where user_id = '&ID&'";
        }

        @Override
        public final String DELETE_EINSTELLUNGEN_JAVA() {
            return "delete from w_user_einstellungen where user_firma_id = '&FIRMAID&' and user_id = '&ID&'";
        }

        @Override
        public final String INSERT_EINSTELLUNGEN() {
            return "insert into w_user_einstellungen (user_id, user_marke, user_produktart, user_lenkung, user_katalogumfang, user_iso, user_regiso, user_expand_bnb, user_short_searchpath, user_request_saz, user_show_proddate, user_primaermarkt_id, user_dft_verbaumenge, user_vinblockrequired) values ('&ID&', '&MARKE&', '&PRODUKTART&', '&LENKUNG&', '&KATALOGUMFANG&', '&ISO&', '&REGISO&', '&EXPAND_BNB&', '&SHORT_SEARCHPATH&', '&REQUEST_SAZ&', &SHOW_PRODDATE&, &PRIMAER_MARKT_ID&, '&VERBAUMENGE&', '&VINBLOCKREQUIRED&')";
        }

        @Override
        public final String INSERT_EINSTELLUNGEN_JAVA() {
            return "nur transbase";
        }

        @Override
        public final String DELETE_EINSTELLUNGEN_REGIONEN() {
            return "delete from w_user_einstellungen_region where user_id = '&ID&'";
        }

        @Override
        public final String DELETE_EINSTELLUNGEN_REGIONEN_JAVA() {
            return "delete from w_user_einstellungen_region where user_firma_id = '&FIRMAID&' and user_id = '&ID&'";
        }

        @Override
        public final String INSERT_EINSTELLUNGEN_REGIONEN() {
            return "insert into w_user_einstellungen_region (user_id, user_region) values ('&ID&', '&REGION&')";
        }

        @Override
        public final String INSERT_EINSTELLUNGEN_REGIONEN_JAVA() {
            return "insert into w_user_einstellungen_region (user_firma_id, user_id, user_region) values ('&FIRMAID&', '&ID&', '&REGION&')";
        }

        @Override
        public final String RETRIEVE_SPRACHEN() {
            return "select ben_iso ISO, ben_regiso RegISO, ben_text Benennung from w_ben_gk, w_publben where publben_art = ? and ben_textcode = publben_textcode and ben_iso = substr(publben_bezeichnung, 1, 2) and ben_regiso = substr(publben_bezeichnung, 3, 2) order by ben_iso, ben_regiso";
        }

        @Override
        public final String RETRIEVE_REGIONEN() {
            return "select distinct fztyp_ktlgausf REGIONEN from  w_fztyp";
        }

        @Override
        public final String RETRIEVE_COUNT_MODSPALTEN() {
            return "select count (distinct fztyp_mospid) from  w_baureihe, w_fztyp where fztyp_baureihe = baureihe_baureihe and baureihe_marke_tps = ? and baureihe_produktart = ? and &LENKUNG_STMT& fztyp_vbereich = ? and  fztyp_ktlgausf in (&IN&)";
        }

        @Override
        public final String RETRIEVE_COUNT_MODSPALTEN_LENKUNG() {
            return "fztyp_lenkung = ? and";
        }

        @Override
        public final String RETRIEVE_RECHTE() {
            return "select userf_recht_id RechtId from w_user_funktionsrechte where userf_id = ?";
        }

        @Override
        public final String RETRIEVE_RECHTE_JAVA() {
            return "select userf_recht_id RechtId from w_user_funktionsrechte@etk_nutzer where userf_id = '&ID&' and userf_firma_id = '&FIRMA&'";
        }

        @Override
        public final String RETRIEVE_BERECHTIGUNGEN() {
            return "select userb_art Art, userb_wert Wert from w_user_berechtigungen where userb_firma_id = ? and userb_id = ? order by userb_art";
        }

        @Override
        public final String DELETE_TEILENOTIZEN_ABGELAUFEN() {
            return "delete from w_teileinfo@etk_nutzer where teileinfo_firma_id = '&FIRMAID&' and  teileinfo_user_id = '&ID&' and (teileinfo_gueltig_bis_jahr <= &JAHR& and  teileinfo_gueltig_bis_monat < &MONAT& and  teileinfo_gueltig_bis_monat is not null) or  (teileinfo_gueltig_bis_jahr < &JAHR& and  teileinfo_gueltig_bis_monat is null)";
        }

        @Override
        public final String RETRIEVE_MAERKTE_ETK_LOKALE_PRODUKTE() {
            return "select marktetk_id id, ben_text name, marktetk_isokz kuerzel, marktetk_lkz lkz from w_markt_etk, w_ben_gk where marktetk_anzlokbt > ? and ben_textcode = marktetk_textcode and ben_iso = ? and ben_regiso = ?";
        }

        @Override
        public final String RETRIEVE_ETK_MARKT() {
            return "select ben_text name, marktetk_isokz kuerzel, marktetk_lkz lkz from w_markt_etk, w_ben_gk where marktetk_id = ? and ben_textcode = marktetk_textcode and ben_iso = ? and ben_regiso = ?";
        }

        @Override
        public final String RETRIEVE_WEITERE_MAERKTE() {
            return "select user_markt_id, ben_text name, marktetk_isokz kuerzel, marktetk_lkz lkz from w_user_einstellungen_wmaerkte, w_markt_etk, w_ben_gk where user_id = ? and marktetk_id = user_markt_id and ben_textcode = marktetk_textcode and ben_iso = ? and ben_regiso = ? order by ben_text";
        }

        @Override
        public final String DELETE_WEITERE_MAERKTE() {
            return "delete from w_user_einstellungen_wmaerkte where user_id = '&USERID&'";
        }

        @Override
        public final String INSERT_WEITERE_MAERKTE() {
            return "insert into w_user_einstellungen_wmaerkte (user_id, user_markt_id) VALUES ('&USERID&', &MARKTID&)";
        }

        @Override
        public String RETRIEVE_SAMMEL_RESTR() {
            return "select SAMMEL_RECHT_ID from ETK_VERWALTUNG.W_SAMMELUSER_RESTR";
        }
    }

    public static final class Wertebereiche
    extends SQLStatements.Wertebereiche {
        @Override
        public String RETRIEVE_WERTEBEREICH() {
            return "select publben_bezeichnung Value, ben_text Name from w_ben_gk, w_publben where ben_textcode = publben_textcode and ben_iso = ? and ben_regiso = ? and publben_art = ?";
        }
    }

    public static final class Allgemein
    extends SQLStatements.Allgemein {
        private final String NVARCHAR_SUBSTITUTE = "N";

        @Override
        public final String getLikeInsensitive(String feldName, String wert, boolean isNVarchar) {
            return " upper(" + feldName + ") LIKE " + "upper(" + (isNVarchar ? "N" : "") + "'" + wert + "')";
        }

        @Override
        public final String getNotLikeInsensitive(String feldName, String wert, boolean isNVarchar) {
            return " upper(" + feldName + ") NOT LIKE upper(" + (isNVarchar ? "N" : "") + "'" + wert + "')";
        }

        @Override
        public final String getLikeTr(String feldName, String wert, boolean isNVarchar) {
            return " upper(replace(" + feldName + ",'i', chr(50352))) LIKE " + (isNVarchar ? "N" : "") + "'" + wert.toUpperCase(new Locale("tr", "TR")) + "'";
        }

        @Override
        public final String getNotLikeTr(String feldName, String wert, boolean isNVarchar) {
            return " upper(replace(" + feldName + ",'i',chr(50352))) NOT LIKE " + (isNVarchar ? "N" : "") + "'" + wert.toUpperCase(new Locale("tr", "TR")) + "'";
        }

        @Override
        public final String LOAD_GRAFIK() {
            return "select grafik_blob Grafik, grafik_format Format, grafik_moddate ModStamp from w_grafik where grafik_grafikid = ? and grafik_art = ?";
        }

        @Override
        public final String INSERT_GRAFIK_STATISTIK() {
            return "insert into w_statistik_grafiken (statg_datum, statg_verzeichnis, statg_anzahl, statg_speicherplatz) values (SYSDATE, '&VERZEICHNIS&', &ANZAHL&, &SPEICHERPLATZ&)";
        }

        @Override
        public final String RETRIEVE_BMWSACHNUMMER_FOR_FREMDESACHNUMMER() {
            return "select distinct fremdtl_sachnr Sachnummer from w_fremdtl where fremdtl_fremdsnr = upper( ? )";
        }

        @Override
        public final String RETRIEVE_URLS() {
            return "select url_url URL from w_url where upper(url_type)=upper( ? ) and upper(url_iso)=upper( ? ) and upper(url_regiso)=upper( ? ) and upper(url_marke_tps)=upper( ? )";
        }

        @Override
        public final String RETRIEVE_BMW_NETZ() {
            return "select netz_netz Netz, netz_krit Krit from w_netz";
        }

        @Override
        public final String RETRIEVE_BMW_NETZURL() {
            return "select netzurl_url_asap AsapUrl, netzurl_asaptunnel AsapTunnel, netzurl_url_zr CentralURL, netzurl_url_dom_basic IGDOMBasicsUrl, netzurl_url_dom_options IGDOMOptionsUrl from w_netzurl where netzurl_netz = ? and netzurl_krit = ?";
        }

        @Override
        public final String RETRIEVE_ALL_BMW_NETZURL() {
            return "select netzurl_netz      , netzurl_krit      , netzurl_krit_textcode      , netzurl_url_asap      , netzurl_asaptunnel      , netzurl_url_zr      , netzurl_url_dom_basic      , netzurl_url_dom_options from   w_netzurl ";
        }

        @Override
        public final String RETRIEVE_BMW_PROXY() {
            return "select proxy_proxyname ProxyName, proxy_port Port, proxy_nutzername UserName, proxy_passwort Passwort, proxy_realm Realm, proxy_ntdomain NtHost, proxy_nthost NtDomain from w_proxy";
        }

        @Override
        public final String RETRIEVE_SOWU_ANTWORT() {
            return "select sowu_id Id, sowu_pos Pos, sowu_text Text from w_sowu_antwort where sowu_vin = ?  for update order by sowu_id, sowu_pos";
        }

        @Override
        public final String DELETE_SOWU_ANTWORT() {
            return "delete from w_sowu_antwort where sowu_vin = '&VIN&' and sowu_id = &ID&";
        }
    }
}

