/*
 * Decompiled with CFR 0.152.
 */
package webetk.db.dbaccess;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;
import webetk.LanguageUtils;
import webetk.WebetkUtils;
import webetk.db.SQLStatements;
import webetk.utils.StringUtils;
import webetk.utils.communication.HtmlUtils;

public class BteAnzeigeDbAccess {
    private static Logger log = Logger.getLogger(BteAnzeigeDbAccess.class);

    public static ResultSet loadHotspots(Connection con, long lGrafikId, String sArt) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSQLStatement = SQLStatements.BteAnzeige.instance.LOAD_HOTSPOTS();
            String sGrafikId = Long.toString(lGrafikId);
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps.setString(1, sGrafikId);
            ps.setString(2, sArt);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sSQLStatement = SQLStatements.BteAnzeige.instance.LOAD_HOTSPOTS();
        String sGrafikId = Long.toString(lGrafikId);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "GRAFIKID", sGrafikId);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ART", sArt);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadZeilenFzg(Connection con, String sBildtafelNr, long lModellspalte, String sTyp, String sSprache, String sMarke, String sPArt, String sLandkuerzel) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSQLStatement = SQLStatements.BteAnzeige.instance.LOAD_BTZEILEN_FZG();
            int index = 0;
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            StringUtils.setPreparedStatementParams(++index, sMarke);
            String sModellspalte = Long.toString(lModellspalte);
            StringUtils.setPreparedStatementParams(++index, sModellspalte);
            if (sLandkuerzel != null && !sLandkuerzel.trim().equals("")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "TC_CHECK_LANDKUERZEL", SQLStatements.BteAnzeige.instance.TC_CHECK_LANDKUERZEL());
                StringUtils.setPreparedStatementParams(++index, sLandkuerzel);
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "TC_CHECK_LANDKUERZEL", "");
            }
            String sToday = WebetkUtils.getTodayYYYYMMDD();
            StringUtils.setPreparedStatementParams(++index, sToday);
            StringUtils.setPreparedStatementParams(++index, sToday);
            if (sTyp == null) {
                sTyp = "  ";
            }
            StringUtils.setPreparedStatementParams(++index, sTyp);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            StringUtils.setPreparedStatementParams(++index, sModellspalte);
            StringUtils.setPreparedStatementParams(++index, sBildtafelNr);
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sSQLStatement = SQLStatements.BteAnzeige.instance.LOAD_BTZEILEN_FZG();
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "BTNR", sBildtafelNr);
        String sModellspalte = Long.toString(lModellspalte);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MOSP", sModellspalte);
        String sToday = WebetkUtils.getTodayYYYYMMDD();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "DATUM", sToday);
        if (sTyp == null) {
            sTyp = "  ";
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "TYP", sTyp);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
        if (sLandkuerzel != null && !sLandkuerzel.trim().equals("")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "TC_CHECK_LANDKUERZEL", SQLStatements.BteAnzeige.instance.TC_CHECK_LANDKUERZEL());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LANDKUERZEL", sLandkuerzel);
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "TC_CHECK_LANDKUERZEL", "");
        }
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadZeilenCPFzg(Connection con, String sBildtafelNr, long lModellspalte, String sTyp, String sWerk) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSQLStatement = SQLStatements.BteAnzeige.instance.LOAD_BTZEILEN_CP_FZG();
            int index = 0;
            String sModellspalte = Long.toString(lModellspalte);
            StringUtils.setPreparedStatementParams(++index, sModellspalte);
            StringUtils.setPreparedStatementParams(++index, sBildtafelNr);
            if (sTyp != null && sWerk != null) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "CP_FZG_TYP_WERK", SQLStatements.BteAnzeige.instance.CP_FZG_TYP_WERK());
                StringUtils.setPreparedStatementParams(++index, sTyp);
                StringUtils.setPreparedStatementParams(++index, sWerk);
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "CP_FZG_TYP_WERK", "");
            }
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sSQLStatement = SQLStatements.BteAnzeige.instance.LOAD_BTZEILEN_CP_FZG();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "BTNR", sBildtafelNr);
        String sModellspalte = Long.toString(lModellspalte);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MOSP", sModellspalte);
        if (sTyp != null && sWerk != null) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "CP_FZG_TYP_WERK", SQLStatements.BteAnzeige.instance.CP_FZG_TYP_WERK());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "TYP", sTyp);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "WERK", sWerk);
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "CP_FZG_TYP_WERK", "");
        }
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadZeilenUgb(Connection con, String sBildtafelNr, String sMarke, String sProduktart, String sKatalogumfang, String sSprache, String sLandkuerzel) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSQLStatement = SQLStatements.BteAnzeige.instance.LOAD_BTZEILEN_UGB();
            int index = 0;
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            StringUtils.setPreparedStatementParams(++index, sMarke);
            StringUtils.setPreparedStatementParams(++index, sMarke);
            StringUtils.setPreparedStatementParams(++index, sProduktart);
            StringUtils.setPreparedStatementParams(++index, sKatalogumfang);
            if (sLandkuerzel != null && !sLandkuerzel.trim().equals("")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "TC_CHECK_LANDKUERZEL", SQLStatements.BteAnzeige.instance.TC_CHECK_LANDKUERZEL());
                StringUtils.setPreparedStatementParams(++index, sLandkuerzel);
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "TC_CHECK_LANDKUERZEL", "");
            }
            String sToday = WebetkUtils.getTodayYYYYMMDD();
            StringUtils.setPreparedStatementParams(++index, sToday);
            StringUtils.setPreparedStatementParams(++index, sToday);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            StringUtils.setPreparedStatementParams(++index, sMarke);
            StringUtils.setPreparedStatementParams(++index, sBildtafelNr);
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sSQLStatement = SQLStatements.BteAnzeige.instance.LOAD_BTZEILEN_UGB();
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "BTNR", sBildtafelNr);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
        String sToday = WebetkUtils.getTodayYYYYMMDD();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "DATUM", sToday);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODUKTART", sProduktart);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "KATALOGUMFANG", sKatalogumfang);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
        if (sLandkuerzel != null && !sLandkuerzel.trim().equals("")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "TC_CHECK_LANDKUERZEL", SQLStatements.BteAnzeige.instance.TC_CHECK_LANDKUERZEL());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LANDKUERZEL", sLandkuerzel);
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "TC_CHECK_LANDKUERZEL", "");
        }
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadKommentareFzg(Connection con, String sBildtafelNr, long lModellspalte, String sSprache) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSQLStatement = SQLStatements.BteAnzeige.instance.LOAD_KOMMENTARE_FZG();
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            int index = 0;
            String sModellspalte = Long.toString(lModellspalte);
            ps.setString(++index, sModellspalte);
            ps.setString(++index, sBildtafelNr);
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            ps.setString(++index, sISO);
            ps.setString(++index, sRegISO);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sSQLStatement = SQLStatements.BteAnzeige.instance.LOAD_KOMMENTARE_FZG();
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "BTNR", sBildtafelNr);
        String sModellspalte = Long.toString(lModellspalte);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MOSP", sModellspalte);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadKommentareUgb(Connection con, String sBildtafelNr, String sMarke, String sSprache) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSQLStatement = SQLStatements.BteAnzeige.instance.LOAD_KOMMENTARE_UGB();
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            int index = 0;
            ps.setString(++index, sMarke);
            ps.setString(++index, sBildtafelNr);
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            ps.setString(++index, sISO);
            ps.setString(++index, sRegISO);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sSQLStatement = SQLStatements.BteAnzeige.instance.LOAD_KOMMENTARE_UGB();
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "BTNR", sBildtafelNr);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadBedingungenFzg(Connection con, String sBildtafelNr, long lModellspalte) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSQLStatement = SQLStatements.BteAnzeige.instance.LOAD_BEDINGUNGEN_FZG();
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            int index = 0;
            ps.setString(++index, sBildtafelNr);
            String sModellspalte = Long.toString(lModellspalte);
            ps.setString(++index, sModellspalte);
            ps.setString(++index, sBildtafelNr);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sSQLStatement = SQLStatements.BteAnzeige.instance.LOAD_BEDINGUNGEN_FZG();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "BTNR", sBildtafelNr);
        String sModellspalte = Long.toString(lModellspalte);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MOSP", sModellspalte);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadBteBedingungFzg(Connection con, String sBildtafelNr, String sBedKez) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSQLStatement = SQLStatements.BteAnzeige.instance.LOAD_BTE_BEDINGUNGEN_FZG();
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            int index = 0;
            ps.setString(++index, sBildtafelNr);
            ps.setString(++index, sBedKez);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sSQLStatement = SQLStatements.BteAnzeige.instance.LOAD_BTE_BEDINGUNGEN_FZG();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "BTNR", sBildtafelNr);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "BEDKEZ", sBedKez);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadUeberbedingungenFzg(Connection con, String sBildtafelNr, long lModellspalte) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSQLStatement = SQLStatements.BteAnzeige.instance.LOAD_UEBERBEDINGUNGEN_FZG();
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            int index = 0;
            ps.setString(++index, sBildtafelNr);
            String sModellspalte = Long.toString(lModellspalte);
            ps.setString(++index, sModellspalte);
            ps.setString(++index, sBildtafelNr);
            ps.setString(++index, sModellspalte);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sSQLStatement = SQLStatements.BteAnzeige.instance.LOAD_UEBERBEDINGUNGEN_FZG();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "BTNR", sBildtafelNr);
        String sModellspalte = Long.toString(lModellspalte);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MOSP", sModellspalte);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadBTVerweiseFzg(Connection con, String sBildtafelNr, long lModellspalte, String sSprache) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSQLStatement = SQLStatements.BteAnzeige.instance.LOAD_BTVERWEISE_FZG();
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            int index = 0;
            ps.setString(++index, sBildtafelNr);
            String sModellspalte = Long.toString(lModellspalte);
            ps.setString(++index, sModellspalte);
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            ps.setString(++index, sISO);
            ps.setString(++index, sRegISO);
            ps.setString(++index, sISO);
            ps.setString(++index, sRegISO);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sSQLStatement = SQLStatements.BteAnzeige.instance.LOAD_BTVERWEISE_FZG();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "BTNR", sBildtafelNr);
        String sModellspalte = Long.toString(lModellspalte);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MOSP", sModellspalte);
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadBTVerweiseUgb(Connection con, String sBildtafelNr, String sProduktart, String sMarke, String sSprache) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSQLStatement = SQLStatements.BteAnzeige.instance.LOAD_BTVERWEISE_UGB();
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            int index = 0;
            ps.setString(++index, sBildtafelNr);
            ps.setString(++index, sMarke);
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            ps.setString(++index, sISO);
            ps.setString(++index, sRegISO);
            ps.setString(++index, sProduktart);
            ps.setString(++index, sISO);
            ps.setString(++index, sRegISO);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sSQLStatement = SQLStatements.BteAnzeige.instance.LOAD_BTVERWEISE_UGB();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "BTNR", sBildtafelNr);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODUKTART", sProduktart);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadJaNein(Connection con, String sSprache) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSQLStatement = SQLStatements.BteAnzeige.instance.LOAD_JA_NEIN_TEXT();
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            int index = 0;
            ps.setString(++index, "V");
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            ps.setString(++index, sISO);
            ps.setString(++index, sRegISO);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sSQLStatement = SQLStatements.BteAnzeige.instance.LOAD_JA_NEIN_TEXT();
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadAZeichen(Connection con, String sSachnummer1, String sSachnummer2) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSQLStatement = SQLStatements.BteAnzeige.instance.LOAD_AZEICHEN();
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            int index = 0;
            ps.setString(++index, sSachnummer1);
            ps.setString(++index, sSachnummer2);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sSQLStatement = SQLStatements.BteAnzeige.instance.LOAD_AZEICHEN();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "SNR1", sSachnummer1);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "SNR2", sSachnummer2);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String ermittleTCKezBzglProddatum(Connection con, String sSachnummer, long lModellspalte, String sProdDatumMin, String sProdDatumMax, String sLandkuerzel) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sTC = "C";
            String sSQLStatement = SQLStatements.BteAnzeige.instance.LOAD_ANZAHL_REL_KAMPAGNEN();
            int index = 0;
            String sModellspalte = Long.toString(lModellspalte);
            StringUtils.setPreparedStatementParams2(++index, sModellspalte);
            StringUtils.setPreparedStatementParams2(++index, sProdDatumMax);
            StringUtils.setPreparedStatementParams2(++index, sProdDatumMin);
            StringUtils.setPreparedStatementParams2(++index, sSachnummer);
            if (sLandkuerzel != null && !sLandkuerzel.trim().equals("")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "TC_CHECK_LANDKUERZEL_KAMPAGNE", SQLStatements.BteAnzeige.instance.TC_CHECK_LANDKUERZEL_KAMPAGNE());
                StringUtils.setPreparedStatementParams2(++index, sLandkuerzel);
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "TC_CHECK_LANDKUERZEL_KAMPAGNE", "");
            }
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters2(ps);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            try {
                while (res.next()) {
                    int nAnzahl = res.getInt("Anzahl");
                    if (nAnzahl != 0) continue;
                    sTC = null;
                }
            }
            finally {
                WebetkUtils.closeQuery(res);
            }
            return sTC;
        }
        String sTC = "C";
        String sSQLStatement = SQLStatements.BteAnzeige.instance.LOAD_ANZAHL_REL_KAMPAGNEN();
        String sModellspalte = Long.toString(lModellspalte);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MOSPID", sModellspalte);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "SACHNUMMER", sSachnummer);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODDATUM_MIN", sProdDatumMin);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODDATUM_MAX", sProdDatumMax);
        if (sLandkuerzel != null && !sLandkuerzel.trim().equals("")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "TC_CHECK_LANDKUERZEL_KAMPAGNE", SQLStatements.BteAnzeige.instance.TC_CHECK_LANDKUERZEL_KAMPAGNE());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LANDKUERZEL", sLandkuerzel);
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "TC_CHECK_LANDKUERZEL_KAMPAGNE", "");
        }
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        try {
            while (res.next()) {
                int nAnzahl = res.getInt("Anzahl");
                if (nAnzahl != 0) continue;
                sTC = null;
            }
        }
        finally {
            WebetkUtils.closeQuery(res);
        }
        return sTC;
    }
}

