/*
 * Decompiled with CFR 0.152.
 */
package webetk.db.dbaccess;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;
import webetk.LanguageUtils;
import webetk.WebetkUtils;
import webetk.db.SQLStatements;
import webetk.utils.StringUtils;
import webetk.utils.communication.HtmlUtils;

public class ErstbevorratungDbAccess {
    private static Logger log = Logger.getLogger(ErstbevorratungDbAccess.class);

    public static ResultSet selectHGs(Connection con, String sHGVon, String sHGBis, String sMospIDs, String sLenkung) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSQLStatement = SQLStatements.Erstbevorratung.instance.RETRIEVE_HGS();
            int index = 0;
            String[] aMospIDs = sMospIDs.split(",");
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN", StringUtils.preparePlaceHolders(aMospIDs.length));
            for (int i = 0; i < aMospIDs.length; ++i) {
                StringUtils.setPreparedStatementParams(++index, aMospIDs[i]);
            }
            if (sHGVon == null || sHGVon.length() == 0) {
                sHGVon = "11";
            }
            StringUtils.setPreparedStatementParams(++index, sHGVon);
            if (sHGBis == null || sHGBis.length() == 0) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "HGBIS_STMT", "");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "HGBIS_STMT", SQLStatements.Erstbevorratung.instance.HG_BIS_STMT());
                StringUtils.setPreparedStatementParams(++index, sHGBis);
            }
            if (sLenkung == null || sLenkung.length() == 0) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", "");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", SQLStatements.Erstbevorratung.instance.HG_LENKUNG_STMT());
                StringUtils.setPreparedStatementParams(++index, sLenkung);
            }
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sSQLStatement = SQLStatements.Erstbevorratung.instance.RETRIEVE_HGS();
        if (sLenkung == null || sLenkung.length() == 0) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", "");
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", SQLStatements.Erstbevorratung.instance.HG_LENKUNG_STMT());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG", sLenkung);
        }
        if (sHGVon == null || sHGVon.length() == 0) {
            sHGVon = "11";
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "HGAB", sHGVon);
        if (sHGBis == null || sHGBis.length() == 0) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "HGBIS_STMT", "");
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "HGBIS_STMT", SQLStatements.Erstbevorratung.instance.HG_BIS_STMT());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "HGBIS", sHGBis);
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MOSPIDS", sMospIDs);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet findHG(Connection con, String sHG) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSQLStatement = SQLStatements.Teileersetzung.instance.FIND_HG();
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps.setString(1, sHG);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sSQLStatement = SQLStatements.Teileersetzung.instance.FIND_HG();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "HG", sHG);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet selectTeile(Connection con, String sSprache, String sHG, String sMospIDs, String sLenkung, String sLandkuerzel) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSQLStatement = SQLStatements.Erstbevorratung.instance.RETRIEVE_TEILE();
            int index = 0;
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            String[] aMospIDs = sMospIDs.split(",");
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN", StringUtils.preparePlaceHolders(aMospIDs.length));
            for (int i = 0; i < aMospIDs.length; ++i) {
                StringUtils.setPreparedStatementParams(++index, aMospIDs[i]);
            }
            if (sLandkuerzel != null && !sLandkuerzel.trim().equals("")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "TC_CHECK_LANDKUERZEL", SQLStatements.Erstbevorratung.instance.TC_CHECK_LANDKUERZEL());
                StringUtils.setPreparedStatementParams(++index, sLandkuerzel);
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "TC_CHECK_LANDKUERZEL", "");
            }
            String sToday = WebetkUtils.getTodayYYYYMMDD();
            StringUtils.setPreparedStatementParams(++index, sToday);
            StringUtils.setPreparedStatementParams(++index, sToday);
            StringUtils.setPreparedStatementParams(++index, sHG);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "MOSPIDS", sMospIDs);
            if (sLenkung == null || sLenkung.length() == 0) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", "");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", SQLStatements.Erstbevorratung.instance.TEIL_LENKUNG_STMT());
                StringUtils.setPreparedStatementParams(++index, sLenkung);
            }
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sSQLStatement = SQLStatements.Erstbevorratung.instance.RETRIEVE_TEILE();
        if (sLenkung == null || sLenkung.length() == 0) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", "");
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", SQLStatements.Erstbevorratung.instance.TEIL_LENKUNG_STMT());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG", sLenkung);
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "HG", sHG);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MOSPIDS", sMospIDs);
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        String sToday = WebetkUtils.getTodayYYYYMMDD();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "DATUM", sToday);
        if (sLandkuerzel != null && !sLandkuerzel.trim().equals("")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "TC_CHECK_LANDKUERZEL", SQLStatements.Erstbevorratung.instance.TC_CHECK_LANDKUERZEL());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LANDKUERZEL", sLandkuerzel);
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "TC_CHECK_LANDKUERZEL", "");
        }
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }
}

