/*
 * Decompiled with CFR 0.152.
 */
package webetk.db.dbaccess;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Iterator;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.LanguageUtils;
import webetk.WebetkUtils;
import webetk.db.SQLStatements;
import webetk.mrkprd.Marken;
import webetk.mrkprd.Produkte;
import webetk.utils.StringUtils;
import webetk.utils.communication.HtmlUtils;

public class FzgIdDbAccess {
    private static Logger log = Logger.getLogger(FzgIdDbAccess.class);

    static String concatCollection(Collection cString) {
        String sString = "";
        if (cString == null) {
            return sString;
        }
        Iterator iterator = cString.iterator();
        while (iterator.hasNext()) {
            if (sString.length() > 0) {
                sString = sString + ", ";
            }
            sString = sString + "'" + (String)iterator.next() + "'";
        }
        return sString;
    }

    public static ResultSet selectBauarten(Connection con, String sSprache, Collection<String> cRegionen, String sMarke, String sProduktart, String sKatalogUmfang) throws SQLException {
        String sSQLStatement = SQLStatements.FzgIdentifikation.instance.RETRIEVE_BAUARTEN();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            int index = 0;
            StringUtils.setPreparedStatementParams(++index, sMarke);
            StringUtils.setPreparedStatementParams(++index, sProduktart);
            StringUtils.setPreparedStatementParams(++index, "BE");
            StringUtils.setPreparedStatementParams(++index, sKatalogUmfang);
            StringUtils.setPreparedStatementParams(++index, sKatalogUmfang);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN", StringUtils.preparePlaceHolders(cRegionen.size()));
            for (String sRegionen : cRegionen) {
                StringUtils.setPreparedStatementParams(++index, sRegionen);
            }
            StringUtils.setPreparedStatementParams(++index, "N");
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODUKTART", sProduktart);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "KATALOGUMFANG", sKatalogUmfang);
        String sRegionen = FzgIdDbAccess.concatCollection(cRegionen);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGIONEN", sRegionen);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet selectBaureihen(Connection con, String sSprache, Collection<String> cRegionen, String sLenkung, String sMarke, String sProduktart, String sKatalogUmfang, String sBauart) throws SQLException {
        String sSQLStatement = SQLStatements.FzgIdentifikation.instance.RETRIEVE_BAUREIHEN();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            int index = 0;
            StringUtils.setPreparedStatementParams(++index, sMarke);
            StringUtils.setPreparedStatementParams(++index, sProduktart);
            StringUtils.setPreparedStatementParams(++index, "BE");
            StringUtils.setPreparedStatementParams(++index, sKatalogUmfang);
            if (sProduktart.equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung())) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "BAUART_STMT", "");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "BAUART_STMT", SQLStatements.FzgIdentifikation.instance.RETRIEVE_BAUART());
                StringUtils.setPreparedStatementParams(++index, sBauart);
            }
            StringUtils.setPreparedStatementParams(++index, sKatalogUmfang);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN", StringUtils.preparePlaceHolders(cRegionen.size()));
            for (String sRegionen : cRegionen) {
                StringUtils.setPreparedStatementParams(++index, sRegionen);
            }
            if (sProduktart.equals(Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung()) || sLenkung.equals("kA")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", "");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", SQLStatements.FzgIdentifikation.instance.RETRIEVE_LENKUNG());
                StringUtils.setPreparedStatementParams(++index, sLenkung);
            }
            StringUtils.setPreparedStatementParams(++index, "N");
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODUKTART", sProduktart);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "KATALOGUMFANG", sKatalogUmfang);
        if (sProduktart.equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung())) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "BAUART_STMT", "");
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "BAUART_STMT", SQLStatements.FzgIdentifikation.instance.RETRIEVE_BAUART());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "BAUART", sBauart);
        }
        if (sProduktart.equals(Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung()) || sLenkung.equals("kA")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", "");
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", SQLStatements.FzgIdentifikation.instance.RETRIEVE_LENKUNG());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG", sLenkung);
        }
        String sRegionen = FzgIdDbAccess.concatCollection(cRegionen);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGIONEN", sRegionen);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static String preparePlaceHolders(int length) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < length) {
            builder.append("?");
            if (++i >= length) continue;
            builder.append(",");
        }
        return builder.toString();
    }

    public static void setValues(PreparedStatement preparedStatement, int idxstart, Object ... values) throws SQLException {
        for (int i = 0; i < values.length; ++i) {
            log.debug("index: " + (i + idxstart) + " Value: " + values[i]);
            preparedStatement.setObject(i + idxstart, values[i]);
        }
    }

    public static ResultSet getBaureiheGrafikId(Connection con, String sBaureihe) throws SQLException {
        String sSQLStatement = SQLStatements.FzgIdentifikation.instance.GET_GRAFIKID_FOR_BAUREIHE();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps.setString(1, sBaureihe);
            ps.setString(2, "T");
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "BAUREIHE", sBaureihe);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet getBaureiheKarosserieGrafikId(Connection con, String sBaureihe, String sKarosserie) throws SQLException {
        String sSQLStatement = SQLStatements.FzgIdentifikation.instance.GET_GRAFIKID_FOR_BAUREIHE_KAROSSERIE();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps.setString(1, sBaureihe);
            ps.setString(2, sKarosserie);
            ps.setString(3, "T");
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "BAUREIHE", sBaureihe);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "KAROSSERIE", sKarosserie);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet getFIGrafikId(Connection con, Collection<String> aMarken, Collection<String> aProdukte, String sKatalogumfang) throws SQLException {
        String sSQLStatement = SQLStatements.FzgIdentifikation.instance.GET_GRAFIKID_FOR_FIBILD();
        String sMarke = null;
        if (aMarken != null && !aMarken.isEmpty()) {
            sMarke = aMarken.size() > 1 ? Marken.getInstance().getMarke("GROUP").getLayout() : aMarken.iterator().next();
        }
        String sProdukt = null;
        if (aProdukte != null && !aProdukte.isEmpty()) {
            sProdukt = aProdukte.size() > 1 ? Produkte.getInstance().getProdukt("ALLE").getArt() : aProdukte.iterator().next();
        }
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps.setString(1, "FI");
            ps.setString(2, sMarke);
            ps.setString(3, sProdukt);
            ps.setString(4, sKatalogumfang);
            ps.setString(5, "T");
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODUKTART", sProdukt);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "KATALOGUMFANG", sKatalogumfang);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet selectKarosserien(Connection con, String sSprache, String sProduktart, Collection<String> cRegionen, String sLenkung, String sKatalogUmfang, String sBaureihe) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSQLStatement = SQLStatements.FzgIdentifikation.instance.RETRIEVE_KAROSSERIEN();
            int index = 0;
            StringUtils.setPreparedStatementParams(++index, sBaureihe);
            StringUtils.setPreparedStatementParams(++index, sKatalogUmfang);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN", StringUtils.preparePlaceHolders(cRegionen.size()));
            for (String sRegionen : cRegionen) {
                StringUtils.setPreparedStatementParams(++index, sRegionen);
            }
            if (sProduktart.equals(Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung()) || sLenkung.equals("kA")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", "");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", SQLStatements.FzgIdentifikation.instance.RETRIEVE_LENKUNG());
                StringUtils.setPreparedStatementParams(++index, sLenkung);
            }
            StringUtils.setPreparedStatementParams(++index, "N");
            StringUtils.setPreparedStatementParams(++index, "K");
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sSQLStatement = SQLStatements.FzgIdentifikation.instance.RETRIEVE_KAROSSERIEN();
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "KATALOGUMFANG", sKatalogUmfang);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "BAUREIHE", sBaureihe);
        if (sProduktart.equals(Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung()) || sLenkung.equals("kA")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", "");
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", SQLStatements.FzgIdentifikation.instance.RETRIEVE_LENKUNG());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG", sLenkung);
        }
        String sRegionen = FzgIdDbAccess.concatCollection(cRegionen);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGIONEN", sRegionen);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet selectModelle(Connection con, String sProduktart, Collection<String> cRegionen, String sLenkung, String sKatalogUmfang, String sBaureihe, String sKarosserie) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSQLStatement = SQLStatements.FzgIdentifikation.instance.RETRIEVE_MODELLE();
            int index = 0;
            StringUtils.setPreparedStatementParams(++index, sBaureihe);
            StringUtils.setPreparedStatementParams(++index, sKatalogUmfang);
            if (sProduktart.equals(Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung())) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "KAROSSERIE_STMT", "");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "KAROSSERIE_STMT", SQLStatements.FzgIdentifikation.instance.RETRIEVE_KAROSSERIE());
                StringUtils.setPreparedStatementParams(++index, sKarosserie);
            }
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN", StringUtils.preparePlaceHolders(cRegionen.size()));
            for (String sRegionen : cRegionen) {
                StringUtils.setPreparedStatementParams(++index, sRegionen);
            }
            if (sProduktart.equals(Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung()) || sLenkung.equals("kA")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", "");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", SQLStatements.FzgIdentifikation.instance.RETRIEVE_LENKUNG());
                StringUtils.setPreparedStatementParams(++index, sLenkung);
            }
            StringUtils.setPreparedStatementParams(++index, "N");
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sSQLStatement = SQLStatements.FzgIdentifikation.instance.RETRIEVE_MODELLE();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "KATALOGUMFANG", sKatalogUmfang);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "BAUREIHE", sBaureihe);
        if (sProduktart.equals(Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung())) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "KAROSSERIE_STMT", "");
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "KAROSSERIE_STMT", SQLStatements.FzgIdentifikation.instance.RETRIEVE_KAROSSERIE());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "KAROSSERIE", sKarosserie);
        }
        if (sProduktart.equals(Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung()) || sLenkung.equals("kA")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", "");
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", SQLStatements.FzgIdentifikation.instance.RETRIEVE_LENKUNG());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG", sLenkung);
        }
        String sRegionen = FzgIdDbAccess.concatCollection(cRegionen);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGIONEN", sRegionen);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet selectRegionen(Connection con, String sProduktart, Collection<String> cRegionen, String sLenkung, String sKatalogUmfang, String sBaureihe, String sKarosserie, String sModell) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSQLStatement = SQLStatements.FzgIdentifikation.instance.RETRIEVE_REGIONEN();
            int index = 0;
            StringUtils.setPreparedStatementParams(++index, sBaureihe);
            StringUtils.setPreparedStatementParams(++index, sKatalogUmfang);
            if (sProduktart.equals(Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung())) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "KAROSSERIE_STMT", "");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "KAROSSERIE_STMT", SQLStatements.FzgIdentifikation.instance.RETRIEVE_KAROSSERIE());
                StringUtils.setPreparedStatementParams(++index, sKarosserie);
            }
            StringUtils.setPreparedStatementParams(++index, sModell);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN", StringUtils.preparePlaceHolders(cRegionen.size()));
            for (String sRegionen : cRegionen) {
                StringUtils.setPreparedStatementParams(++index, sRegionen);
            }
            if (sProduktart.equals(Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung()) || sLenkung.equals("kA")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", "");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", SQLStatements.FzgIdentifikation.instance.RETRIEVE_LENKUNG());
                StringUtils.setPreparedStatementParams(++index, sLenkung);
            }
            StringUtils.setPreparedStatementParams(++index, "N");
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sSQLStatement = SQLStatements.FzgIdentifikation.instance.RETRIEVE_REGIONEN();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "KATALOGUMFANG", sKatalogUmfang);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "BAUREIHE", sBaureihe);
        if (sProduktart.equals(Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung())) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "KAROSSERIE_STMT", "");
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "KAROSSERIE_STMT", SQLStatements.FzgIdentifikation.instance.RETRIEVE_KAROSSERIE());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "KAROSSERIE", sKarosserie);
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MODELL", sModell);
        if (sProduktart.equals(Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung()) || sLenkung.equals("kA")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", "");
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", SQLStatements.FzgIdentifikation.instance.RETRIEVE_LENKUNG());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG", sLenkung);
        }
        String sRegionen = FzgIdDbAccess.concatCollection(cRegionen);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGIONEN", sRegionen);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet selectLenkungen(Connection con, String sSprache, String sKatalogUmfang, String sBaureihe, String sKarosserie, String sModell, String sRegion) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSQLStatement = SQLStatements.FzgIdentifikation.instance.RETRIEVE_LENKUNGEN();
            int index = 0;
            StringUtils.setPreparedStatementParams(++index, sBaureihe);
            StringUtils.setPreparedStatementParams(++index, sKatalogUmfang);
            StringUtils.setPreparedStatementParams(++index, sKarosserie);
            StringUtils.setPreparedStatementParams(++index, sModell);
            StringUtils.setPreparedStatementParams(++index, sRegion);
            StringUtils.setPreparedStatementParams(++index, "N");
            StringUtils.setPreparedStatementParams(++index, "L");
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            log.debug("Executing: " + sSQLStatement);
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sSQLStatement = SQLStatements.FzgIdentifikation.instance.RETRIEVE_LENKUNGEN();
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "KATALOGUMFANG", sKatalogUmfang);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "BAUREIHE", sBaureihe);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "KAROSSERIE", sKarosserie);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MODELL", sModell);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGION", sRegion);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet selectGetriebe(Connection con, String sSprache, String sKatalogUmfang, String sBaureihe, String sKarosserie, String sModell, String sRegion, String sLenkung) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSQLStatement = SQLStatements.FzgIdentifikation.instance.RETRIEVE_GETRIEBEARTEN();
            int index = 0;
            StringUtils.setPreparedStatementParams(++index, sBaureihe);
            StringUtils.setPreparedStatementParams(++index, sKatalogUmfang);
            StringUtils.setPreparedStatementParams(++index, sKarosserie);
            StringUtils.setPreparedStatementParams(++index, sModell);
            StringUtils.setPreparedStatementParams(++index, sRegion);
            if (sLenkung.equals("kA")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", "");
            } else if (sLenkung.equals("AlleWerte")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", "");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", SQLStatements.FzgIdentifikation.instance.RETRIEVE_LENKUNG());
                StringUtils.setPreparedStatementParams(++index, sLenkung);
            }
            StringUtils.setPreparedStatementParams(++index, "N");
            StringUtils.setPreparedStatementParams(++index, "G");
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sSQLStatement = SQLStatements.FzgIdentifikation.instance.RETRIEVE_GETRIEBEARTEN();
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "KATALOGUMFANG", sKatalogUmfang);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "BAUREIHE", sBaureihe);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "KAROSSERIE", sKarosserie);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MODELL", sModell);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGION", sRegion);
        if (sLenkung.equals("kA")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", "");
        } else if (sLenkung.equals("AlleWerte")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", "");
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", SQLStatements.FzgIdentifikation.instance.RETRIEVE_LENKUNG());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG", sLenkung);
        }
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet selectBaujahre(Connection con, String sProduktart, String sKatalogUmfang, String sBaureihe, String sKarosserie, String sModell, String sRegion, String sLenkung, String sGetriebe) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSQLStatement = SQLStatements.FzgIdentifikation.instance.RETRIEVE_BAUJAHRE();
            int index = 0;
            StringUtils.setPreparedStatementParams(++index, sBaureihe);
            StringUtils.setPreparedStatementParams(++index, sKatalogUmfang);
            if (sProduktart.equals(Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung())) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "KAROSSERIE_STMT", "");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "KAROSSERIE_STMT", SQLStatements.FzgIdentifikation.instance.RETRIEVE_KAROSSERIE());
                StringUtils.setPreparedStatementParams(++index, sKarosserie);
            }
            StringUtils.setPreparedStatementParams(++index, sModell);
            StringUtils.setPreparedStatementParams(++index, sRegion);
            if (sProduktart.equals(Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung()) || sLenkung.equals("kA") || sLenkung.equals("AlleWerte")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", "");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", SQLStatements.FzgIdentifikation.instance.RETRIEVE_LENKUNG());
                StringUtils.setPreparedStatementParams(++index, sLenkung);
            }
            if (sProduktart.equals(Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung()) || sGetriebe.equals("kA") || sGetriebe.equals("AlleWerte")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", "");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", SQLStatements.FzgIdentifikation.instance.RETRIEVE_GETRIEBE());
                StringUtils.setPreparedStatementParams(++index, sGetriebe);
            }
            StringUtils.setPreparedStatementParams(++index, "N");
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sSQLStatement = SQLStatements.FzgIdentifikation.instance.RETRIEVE_BAUJAHRE();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "KATALOGUMFANG", sKatalogUmfang);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "BAUREIHE", sBaureihe);
        if (sProduktart.equals(Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung())) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "KAROSSERIE_STMT", "");
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "KAROSSERIE_STMT", SQLStatements.FzgIdentifikation.instance.RETRIEVE_KAROSSERIE());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "KAROSSERIE", sKarosserie);
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MODELL", sModell);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGION", sRegion);
        if (sProduktart.equals(Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung()) || sLenkung.equals("kA") || sLenkung.equals("AlleWerte")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", "");
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", SQLStatements.FzgIdentifikation.instance.RETRIEVE_LENKUNG());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG", sLenkung);
        }
        if (sProduktart.equals(Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung()) || sGetriebe.equals("kA") || sGetriebe.equals("AlleWerte")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", "");
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", SQLStatements.FzgIdentifikation.instance.RETRIEVE_GETRIEBE());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE", sGetriebe);
        }
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet selectZulassungsmonate(Connection con, String sSprache, String sProduktart, String sKatalogUmfang, String sBaureihe, String sKarosserie, String sModell, String sRegion, String sLenkung, String sGetriebe, String sBaujahr) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSQLStatement = null;
            int index = 0;
            sSQLStatement = sBaujahr == null || sBaujahr.equals("AlleWerte") ? SQLStatements.FzgIdentifikation.instance.RETRIEVE_ZULASSMONATE2() : SQLStatements.FzgIdentifikation.instance.RETRIEVE_ZULASSMONATE();
            StringUtils.setPreparedStatementParams(++index, sBaureihe);
            StringUtils.setPreparedStatementParams(++index, sKatalogUmfang);
            if (sProduktart.equals(Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung())) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "KAROSSERIE_STMT", "");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "KAROSSERIE_STMT", SQLStatements.FzgIdentifikation.instance.RETRIEVE_KAROSSERIE());
                StringUtils.setPreparedStatementParams(++index, sKarosserie);
            }
            StringUtils.setPreparedStatementParams(++index, sModell);
            StringUtils.setPreparedStatementParams(++index, sRegion);
            if (sProduktart.equals(Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung()) || sLenkung.equals("kA") || sLenkung.equals("AlleWerte")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", "");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", SQLStatements.FzgIdentifikation.instance.RETRIEVE_LENKUNG());
                StringUtils.setPreparedStatementParams(++index, sLenkung);
            }
            if (sProduktart.equals(Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung()) || sGetriebe.equals("kA") || sGetriebe.equals("AlleWerte")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", "");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", SQLStatements.FzgIdentifikation.instance.RETRIEVE_GETRIEBE());
                StringUtils.setPreparedStatementParams(++index, sGetriebe);
            }
            StringUtils.setPreparedStatementParams(++index, "N");
            if (sBaujahr != null && !sBaujahr.equals("AlleWerte")) {
                StringUtils.setPreparedStatementParams(++index, sBaujahr);
            }
            StringUtils.setPreparedStatementParams(++index, "M");
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sSQLStatement = SQLStatements.FzgIdentifikation.instance.RETRIEVE_ZULASSMONATE();
        if (sBaujahr == null || sBaujahr.equals("AlleWerte")) {
            sSQLStatement = SQLStatements.FzgIdentifikation.instance.RETRIEVE_ZULASSMONATE2();
        }
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "KATALOGUMFANG", sKatalogUmfang);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "BAUREIHE", sBaureihe);
        if (sProduktart.equals(Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung())) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "KAROSSERIE_STMT", "");
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "KAROSSERIE_STMT", SQLStatements.FzgIdentifikation.instance.RETRIEVE_KAROSSERIE());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "KAROSSERIE", sKarosserie);
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MODELL", sModell);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGION", sRegion);
        if (sProduktart.equals(Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung()) || sLenkung.equals("kA") || sLenkung.equals("AlleWerte")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", "");
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", SQLStatements.FzgIdentifikation.instance.RETRIEVE_LENKUNG());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG", sLenkung);
        }
        if (sProduktart.equals(Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung()) || sGetriebe.equals("kA") || sGetriebe.equals("AlleWerte")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", "");
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", SQLStatements.FzgIdentifikation.instance.RETRIEVE_GETRIEBE());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE", sGetriebe);
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "BAUJAHR", sBaujahr);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long selectModellspalte(Connection con, String sBaureihe, String sKarosserie, String sModell, String sRegion) throws SQLException {
        long lMoSpId = -1L;
        String sSQLStatement = SQLStatements.FzgIdentifikation.instance.RETRIEVE_MOSP_BY_ATTRIBUTE_PKW();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps.setString(1, sBaureihe);
            ps.setString(2, sKarosserie);
            ps.setString(3, sModell);
            ps.setString(4, sRegion);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = null;
            try {
                res = ps.executeQuery();
                if (res.next()) {
                    lMoSpId = res.getLong(1);
                }
            }
            finally {
                WebetkUtils.closeQuery(res);
            }
            return lMoSpId;
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "BAUREIHE", sBaureihe);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "KAROSSERIE", sKarosserie);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MODELL", sModell);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGION", sRegion);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = null;
        try {
            res = stmt.executeQuery(sSQLStatement);
            if (res.next()) {
                lMoSpId = res.getLong(1);
            }
        }
        finally {
            WebetkUtils.closeQuery(res);
        }
        return lMoSpId;
    }

    public static long selectModellspalte(Connection con, String sBaureihe, String sModell, String sRegion) throws SQLException {
        long lMoSpId = -1L;
        String sSQLStatement = SQLStatements.FzgIdentifikation.instance.RETRIEVE_MOSP_BY_ATTRIBUTE_KRAD();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps.setString(1, sBaureihe);
            ps.setString(2, sModell);
            ps.setString(3, sRegion);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            if (res.next()) {
                lMoSpId = res.getLong(1);
            }
            WebetkUtils.closeQuery(res);
            return lMoSpId;
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "BAUREIHE", sBaureihe);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MODELL", sModell);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGION", sRegion);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        if (res.next()) {
            lMoSpId = res.getLong(1);
        }
        WebetkUtils.closeQuery(res);
        return lMoSpId;
    }

    public static ResultSet selectFzgIdDatenByFgstnr(Connection con, String sFahrgestellNr, String sCurrentLang, String typeCode) throws SQLException {
        String sISO = LanguageUtils.toLanguage(sCurrentLang);
        String sRegISO = LanguageUtils.toRegion(sCurrentLang, true);
        String sSQLStatement = SQLStatements.FzgIdentifikation.instance.RETRIEVE_MOSP_BY_FGSTNR();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            int index = 0;
            StringUtils.setPreparedStatementParams(++index, "K");
            StringUtils.setPreparedStatementParams(++index, "B");
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            sFahrgestellNr = sFahrgestellNr.toUpperCase();
            if (sFahrgestellNr.length() == 17) {
                sFahrgestellNr = sFahrgestellNr.substring(10, 17);
            }
            StringUtils.setPreparedStatementParams(++index, sFahrgestellNr);
            StringUtils.setPreparedStatementParams(++index, sFahrgestellNr);
            String sFahrgestellNrFirst2 = sFahrgestellNr.substring(0, 2);
            StringUtils.setPreparedStatementParams(++index, sFahrgestellNrFirst2);
            if (typeCode != null && !typeCode.trim().equals("")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "GET_DATA_WITH_FGSTNR_TYP", SQLStatements.FzgIdentifikation.instance.GET_DATA_WITH_FGSTNR_TYP());
                StringUtils.setPreparedStatementParams(++index, typeCode);
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "GET_DATA_WITH_FGSTNR_TYP", "");
            }
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        if ((sFahrgestellNr = sFahrgestellNr.toUpperCase()).length() == 17) {
            sFahrgestellNr = sFahrgestellNr.substring(10, 17);
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FGSTNR", sFahrgestellNr);
        String sFahrgestellNrFirst2 = sFahrgestellNr.substring(0, 2);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FGSTNR_FIRST2", sFahrgestellNrFirst2);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        if (typeCode != null && !typeCode.trim().equals("")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "GET_DATA_WITH_FGSTNR_TYP", SQLStatements.FzgIdentifikation.instance.GET_DATA_WITH_FGSTNR_TYP());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "TYP", typeCode);
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "GET_DATA_WITH_FGSTNR_TYP", "");
        }
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement(1005, 1008);
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet selectFzgIdDatenByTyp(Connection con, String sTyp, String sProdDatum, String sFahrgestellNr, String sCurrentLang) throws SQLException {
        String sISO = LanguageUtils.toLanguage(sCurrentLang);
        String sRegISO = LanguageUtils.toRegion(sCurrentLang, true);
        String sSQLStatement = SQLStatements.FzgIdentifikation.instance.RETRIEVE_MOSP_BY_TYP();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODDATUM", sProdDatum);
            if ((sFahrgestellNr = sFahrgestellNr.toUpperCase()).length() == 17) {
                sFahrgestellNr = sFahrgestellNr.substring(10, 17);
            }
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "FGSTNR", sFahrgestellNr);
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            sTyp = sTyp.toUpperCase();
            ps.setString(1, sTyp);
            ps.setString(2, "K");
            ps.setString(3, sISO);
            ps.setString(4, sRegISO);
            ps.setString(5, "B");
            ps.setString(6, sISO);
            ps.setString(7, sRegISO);
            ps.setString(8, sISO);
            ps.setString(9, sRegISO);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        sTyp = sTyp.toUpperCase();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "TYP", sTyp);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODDATUM", sProdDatum);
        if ((sFahrgestellNr = sFahrgestellNr.toUpperCase()).length() == 17) {
            sFahrgestellNr = sFahrgestellNr.substring(10, 17);
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FGSTNR", sFahrgestellNr);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet selectFzg17DatenByTyp(Connection con, String sTyp, String sCurrentLang) throws SQLException {
        String sISO = LanguageUtils.toLanguage(sCurrentLang);
        String sRegISO = LanguageUtils.toRegion(sCurrentLang, true);
        String sSQLStatement = SQLStatements.FzgIdentifikation.instance.RETRIEVE_VIN17_DATEN_BY_TYP();
        sTyp = sTyp.toUpperCase();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "TYP", sTyp);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet isVinBlockingRequired(Connection con, String userId) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            log.info("Oracle connection....");
        }
        String sSQLStatement = SQLStatements.Einstellungen.instance.RETRIEVE_EINSTELLUNGEN();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", userId);
        PreparedStatement ps = con.prepareStatement(sSQLStatement);
        ps.setString(1, userId);
        log.debug("Executing: " + sSQLStatement);
        ResultSet res = ps.executeQuery();
        return res;
    }

    public static ResultSet selectSalasZuFahrgestellnummer(Connection con, String sFahrgestellNr, String sCurrentLang) throws SQLException {
        String sISO = LanguageUtils.toLanguage(sCurrentLang);
        String sRegISO = LanguageUtils.toRegion(sCurrentLang, true);
        String sSQLStatement = SQLStatements.FzgIdentifikation.instance.LOAD_SALAS_ZU_FGSTNR();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            if ((sFahrgestellNr = sFahrgestellNr.toUpperCase()).length() == 17) {
                sFahrgestellNr = sFahrgestellNr.substring(10, 17);
            }
            ps.setString(1, sFahrgestellNr);
            ps.setString(2, sISO);
            ps.setString(3, sRegISO);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        if ((sFahrgestellNr = sFahrgestellNr.toUpperCase()).length() == 17) {
            sFahrgestellNr = sFahrgestellNr.substring(10, 17);
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FGSTNR", sFahrgestellNr);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet selectTypmenge(Connection con, long lMospId, String sLenkung, String sGetriebe, String sBaujahr, String sZulMonat) throws DatabaseBusyException, SQLException {
        String sSQLStatement = SQLStatements.FzgIdentifikation.instance.RETRIEVE_TYPMENGE_BY_ATTRIBUTE_PKW();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            String sMospId = Long.toString(lMospId);
            ps.setString(1, sMospId);
            ps.setString(2, "N");
            ps.setString(3, sLenkung);
            ps.setString(4, sGetriebe);
            String sProdDatum = sBaujahr + sZulMonat + "00";
            ps.setString(5, sProdDatum);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sMospId = Long.toString(lMospId);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MOSPID", sMospId);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG", sLenkung);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE", sGetriebe);
        String sProdDatum = sBaujahr + sZulMonat + "00";
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODDATUM", sProdDatum);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet selectTypmenge(Connection con, long lMospId, String sBaujahr, String sZulMonat) throws DatabaseBusyException, SQLException {
        String sSQLStatement = SQLStatements.FzgIdentifikation.instance.RETRIEVE_TYPMENGE_BY_ATTRIBUTE_KRAD();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            String sMospId = Long.toString(lMospId);
            ps.setString(1, sMospId);
            ps.setString(2, "N");
            String sProdDatum = sBaujahr + sZulMonat + "00";
            ps.setString(3, sProdDatum);
            if (log.isDebugEnabled()) {
                log.debug("Executing: " + sSQLStatement);
            }
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sMospId = Long.toString(lMospId);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MOSPID", sMospId);
        String sProdDatum = sBaujahr + sZulMonat + "00";
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODDATUM", sProdDatum);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet getBedingungenZuCode(Connection con, String sISO, String sRegISO, String sProddatum, String sCode, boolean bPolstercode, boolean bExtract) throws SQLException {
        String sSQLStatement = null;
        sSQLStatement = SQLStatements.FzgIdentifikation.instance.LOAD_SS_BEDINGUNGEN_AF();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            int index = 0;
            StringUtils.setPreparedStatementParams(++index, "AF");
            sSQLStatement = bPolstercode ? StringUtils.substituteString(sSQLStatement, "LOAD_SS_BEDINGUNGEN_AF_DECIDE", SQLStatements.FzgIdentifikation.instance.LOAD_SS_BEDINGUNGEN_AF_BY_POLSTERCODE()) : StringUtils.substituteString(sSQLStatement, "LOAD_SS_BEDINGUNGEN_AF_DECIDE", SQLStatements.FzgIdentifikation.instance.LOAD_SS_BEDINGUNGEN_AF_BY_AFCODE());
            StringUtils.setPreparedStatementParams(++index, sCode);
            StringUtils.setPreparedStatementParams(++index, sProddatum);
            StringUtils.setPreparedStatementParams(++index, sProddatum);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            StringUtils.setPreparedStatementParams(++index, "AF");
            StringUtils.setPreparedStatementParams(++index, sCode);
            StringUtils.setPreparedStatementParams(++index, sProddatum);
            StringUtils.setPreparedStatementParams(++index, sProddatum);
            StringUtils.setPreparedStatementParams(++index, "F");
            StringUtils.setPreparedStatementParams(++index, sProddatum);
            StringUtils.setPreparedStatementParams(++index, sProddatum);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            StringUtils.setPreparedStatementParams(++index, "AF");
            StringUtils.setPreparedStatementParams(++index, sCode);
            StringUtils.setPreparedStatementParams(++index, "A");
            StringUtils.setPreparedStatementParams(++index, sProddatum);
            StringUtils.setPreparedStatementParams(++index, sProddatum);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            if (log.isDebugEnabled()) {
                log.debug("Executing: " + sSQLStatement);
            }
            ResultSet res = ps.executeQuery();
            return res;
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODDATUM", sProddatum);
        sSQLStatement = bPolstercode ? StringUtils.substituteString(sSQLStatement, "LOAD_SS_BEDINGUNGEN_AF_DECIDE", SQLStatements.FzgIdentifikation.instance.LOAD_SS_BEDINGUNGEN_AF_BY_POLSTERCODE()) : StringUtils.substituteString(sSQLStatement, "LOAD_SS_BEDINGUNGEN_AF_DECIDE", SQLStatements.FzgIdentifikation.instance.LOAD_SS_BEDINGUNGEN_AF_BY_AFCODE());
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "CODE", sCode);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet getBedingungenZuCode(Connection con, String sISO, String sRegISO, String sProddatum, String sLackArt, String sLackCode) throws SQLException {
        String sSQLStatement = null;
        sSQLStatement = SQLStatements.FzgIdentifikation.instance.LOAD_SS_BEDINGUNGEN_LACK();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            StringUtils.setPreparedStatementParams(1, "L");
            StringUtils.setPreparedStatementParams(2, sProddatum);
            StringUtils.setPreparedStatementParams(3, sProddatum);
            String sCode = null;
            if (sLackArt != null && !sLackArt.trim().equals("")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LOAD_SS_BEDINGUNGEN_LACK_DECIDE", SQLStatements.FzgIdentifikation.instance.LOAD_SS_BEDINGUNGEN_LACK_EXACT());
                sCode = sLackArt + sLackCode;
                StringUtils.setPreparedStatementParams(4, sCode);
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LOAD_SS_BEDINGUNGEN_LACK_DECIDE", SQLStatements.FzgIdentifikation.instance.LOAD_SS_BEDINGUNGEN_LACK_LIKE());
                sCode = "%" + sLackCode.replace(' ', '%');
                StringUtils.setPreparedStatementParams(4, sCode);
            }
            StringUtils.setPreparedStatementParams(5, sISO);
            StringUtils.setPreparedStatementParams(6, sRegISO);
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            if (log.isDebugEnabled()) {
                log.debug("Executing: " + sSQLStatement);
            }
            ResultSet res = ps.executeQuery();
            return res;
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODDATUM", sProddatum);
        String sCode = null;
        if (sLackArt != null && !sLackArt.trim().equals("")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LOAD_SS_BEDINGUNGEN_LACK_DECIDE", SQLStatements.FzgIdentifikation.instance.LOAD_SS_BEDINGUNGEN_LACK_EXACT());
            sCode = sLackArt + sLackCode;
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LOAD_SS_BEDINGUNGEN_LACK_DECIDE", SQLStatements.FzgIdentifikation.instance.LOAD_SS_BEDINGUNGEN_LACK_LIKE());
            sCode = sLackCode;
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "CODE", sCode);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet getBedingungenZuCode(Connection con, String sISO, String sRegISO, String sProddatum, String sProduktart, String sSalaArt, String sSalaPrimanummer, String sSalaHZaehler) throws SQLException {
        if (sProddatum == null) {
            log.warn("No Production date set, can't load conditions.");
            return null;
        }
        String sSQLStatement = null;
        sSQLStatement = SQLStatements.FzgIdentifikation.instance.LOAD_SS_BEDINGUNGEN_SALAPA();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            int index = 0;
            StringUtils.setPreparedStatementParams(++index, sProduktart);
            StringUtils.setPreparedStatementParams(++index, sSalaPrimanummer);
            StringUtils.setPreparedStatementParams(++index, sProddatum);
            StringUtils.setPreparedStatementParams(++index, sProddatum);
            if (sSalaArt != null && !sSalaArt.trim().equals("")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LOAD_SS_BEDINGUNGEN_SALAPA_DECIDE_ART", SQLStatements.FzgIdentifikation.instance.LOAD_SS_BEDINGUNGEN_SALAPA_BY_ART());
                StringUtils.setPreparedStatementParams(++index, sSalaArt);
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LOAD_SS_BEDINGUNGEN_SALAPA_DECIDE_ART", "");
            }
            if (sSalaHZaehler != null && !sSalaHZaehler.trim().equals("")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LOAD_SS_BEDINGUNGEN_SALAPA_DECIDE_HZAEHLER", SQLStatements.FzgIdentifikation.instance.LOAD_SS_BEDINGUNGEN_SALAPA_BY_HZEAHLER());
                StringUtils.setPreparedStatementParams(++index, sSalaHZaehler);
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LOAD_SS_BEDINGUNGEN_SALAPA_DECIDE_HZAEHLER", "");
            }
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            if (log.isDebugEnabled()) {
                log.debug("Executing: " + sSQLStatement);
            }
            ResultSet res = ps.executeQuery();
            return res;
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODDATUM", sProddatum);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODUKTART", sProduktart);
        if (sSalaArt != null && !sSalaArt.trim().equals("")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LOAD_SS_BEDINGUNGEN_SALAPA_DECIDE_ART", SQLStatements.FzgIdentifikation.instance.LOAD_SS_BEDINGUNGEN_SALAPA_BY_ART());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "ART", sSalaArt);
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LOAD_SS_BEDINGUNGEN_SALAPA_DECIDE_ART", "");
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRIMANUMMER", sSalaPrimanummer);
        if (sSalaHZaehler != null && !sSalaHZaehler.trim().equals("")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LOAD_SS_BEDINGUNGEN_SALAPA_DECIDE_HZAEHLER", SQLStatements.FzgIdentifikation.instance.LOAD_SS_BEDINGUNGEN_SALAPA_BY_HZEAHLER());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "HZAEHLER", sSalaHZaehler);
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LOAD_SS_BEDINGUNGEN_SALAPA_DECIDE_HZAEHLER", "");
        }
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String selectLenkungBen(Connection con, String sISO, String sRegISO, String sValue) throws SQLException {
        String sBen = null;
        String sSQLStatement = SQLStatements.FzgIdentifikation.instance.RETRIEVE_LENKUNG_BEN();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            ResultSet res;
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps.setString(1, sISO);
            ps.setString(2, sRegISO);
            ps.setString(3, "L");
            ps.setString(4, sValue);
            if (log.isDebugEnabled()) {
                log.debug("Executing: " + sSQLStatement);
            }
            if ((res = ps.executeQuery()) != null && res.next()) {
                sBen = res.getString("Name");
            }
            WebetkUtils.closeQuery(res);
            return sBen;
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "VALUE", sValue);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = null;
        try {
            res = stmt.executeQuery(sSQLStatement);
            if (res != null && res.next()) {
                sBen = res.getString("Name");
            }
        }
        finally {
            WebetkUtils.closeQuery(res);
        }
        return sBen;
    }

    public static ResultSet getBedZusatzInfo(Connection con, String sISO, String sRegISO, String sBedElemIds) throws SQLException {
        String sSQLStatement = null;
        sSQLStatement = SQLStatements.FzgIdentifikation.instance.RETRIEVE_BED_ZUSATZINFO();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "BED_ELEMIDS", sBedElemIds);
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps.setString(1, sISO);
            ps.setString(2, sRegISO);
            if (log.isDebugEnabled()) {
                log.debug("Executing: " + sSQLStatement);
            }
            ResultSet res = ps.executeQuery();
            return res;
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "BED_ELEMIDS", sBedElemIds);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet getZusatzInfoMarke(Connection con, String sMarke, String sISO, String sRegISO) throws SQLException {
        String sSQLStatement = SQLStatements.FzgIdentifikation.instance.RETRIEVE_ZUSATZINFO_MARKE();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps.setString(1, "FITEXT");
            sMarke = "%" + sMarke.replace(' ', '%') + "%";
            ps.setString(2, sMarke);
            ps.setString(3, sISO);
            ps.setString(4, sRegISO);
            if (log.isDebugEnabled()) {
                log.debug("Executing: " + sSQLStatement);
            }
            ResultSet res = ps.executeQuery();
            return res;
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }
}

