/*
 * Decompiled with CFR 0.152.
 */
package webetk.db.dbaccess;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Iterator;
import org.apache.log4j.Logger;
import webetk.LanguageUtils;
import webetk.NoDataFoundException;
import webetk.app.ValueAndName;
import webetk.db.SQLStatements;
import webetk.mrkprd.Produkte;
import webetk.utils.StringUtils;
import webetk.utils.communication.HtmlUtils;

public class FzgUmfangDbAccess {
    private static Logger log = Logger.getLogger(FzgUmfangDbAccess.class);

    public static ResultSet selectRegionen(Connection con, String sMarke, String sProduktart, String sKatalogUmfang, Collection<String> cSettingsRegionen) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSQLStatement = SQLStatements.FzgUmfang.instance.RETRIEVE_REGIONEN();
            int index = 0;
            StringUtils.setPreparedStatementParams(++index, sMarke);
            StringUtils.setPreparedStatementParams(++index, sProduktart);
            StringUtils.setPreparedStatementParams(++index, "BE");
            StringUtils.setPreparedStatementParams(++index, sKatalogUmfang);
            StringUtils.setPreparedStatementParams(++index, sKatalogUmfang);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN", StringUtils.preparePlaceHolders(cSettingsRegionen.size()));
            for (String sRegionen : cSettingsRegionen) {
                StringUtils.setPreparedStatementParams(++index, sRegionen);
            }
            StringUtils.setPreparedStatementParams(++index, "N");
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sSQLStatement = SQLStatements.FzgUmfang.instance.RETRIEVE_REGIONEN();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODUKTART", sProduktart);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "KATALOGUMFANG", sKatalogUmfang);
        String sRegionen = FzgUmfangDbAccess.concatCollection(cSettingsRegionen);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGIONEN", sRegionen);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    static String concatCollection(Collection<String> cCollection) {
        String sString = "";
        if (cCollection == null) {
            return sString;
        }
        Iterator<String> iterator = cCollection.iterator();
        while (iterator.hasNext()) {
            String nextValue;
            if (sString.length() > 0) {
                sString = sString + ", ";
            }
            if ((nextValue = iterator.next()) instanceof String) {
                sString = sString + "'" + nextValue + "'";
                continue;
            }
            if (!(nextValue instanceof ValueAndName)) continue;
            ValueAndName objValueAndName = (ValueAndName)((Object)nextValue);
            sString = sString + "'" + objValueAndName.getValue() + "'";
        }
        return sString;
    }

    public static ResultSet selectLenkungen(Connection con, String sSprache, String sMarke, String sKatalogUmfang, Collection<String> cRegionen) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSQLStatement = SQLStatements.FzgUmfang.instance.RETRIEVE_LENKUNGEN();
            int index = 0;
            StringUtils.setPreparedStatementParams(++index, sMarke);
            StringUtils.setPreparedStatementParams(++index, "P");
            StringUtils.setPreparedStatementParams(++index, "BE");
            StringUtils.setPreparedStatementParams(++index, sKatalogUmfang);
            StringUtils.setPreparedStatementParams(++index, sKatalogUmfang);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN", StringUtils.preparePlaceHolders(cRegionen.size()));
            for (String sRegionen : cRegionen) {
                StringUtils.setPreparedStatementParams(++index, sRegionen);
            }
            StringUtils.setPreparedStatementParams(++index, "L");
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sSQLStatement = SQLStatements.FzgUmfang.instance.RETRIEVE_LENKUNGEN();
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "KATALOGUMFANG", sKatalogUmfang);
        String sRegionen = FzgUmfangDbAccess.concatCollection(cRegionen);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGIONEN", sRegionen);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet selectBauarten(Connection con, String sSprache, String sMarke, String sKatalogUmfang, Collection<String> cRegionen) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSQLStatement = SQLStatements.FzgUmfang.instance.RETRIEVE_BAUARTEN();
            int index = 0;
            StringUtils.setPreparedStatementParams(++index, sMarke);
            StringUtils.setPreparedStatementParams(++index, "M");
            StringUtils.setPreparedStatementParams(++index, "BE");
            StringUtils.setPreparedStatementParams(++index, sKatalogUmfang);
            StringUtils.setPreparedStatementParams(++index, sKatalogUmfang);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN", StringUtils.preparePlaceHolders(cRegionen.size()));
            for (String sRegionen : cRegionen) {
                StringUtils.setPreparedStatementParams(++index, sRegionen);
            }
            StringUtils.setPreparedStatementParams(++index, "N");
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sSQLStatement = SQLStatements.FzgUmfang.instance.RETRIEVE_BAUARTEN();
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "KATALOGUMFANG", sKatalogUmfang);
        String sRegionen = FzgUmfangDbAccess.concatCollection(cRegionen);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGIONEN", sRegionen);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet selectBaureihen(Connection con, String sSprache, String sMarke, String sProduktart, String sKatalogUmfang, Collection<String> cRegionen, Collection<String> cLenkungen, Collection<String> cBauarten) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSQLStatement = SQLStatements.FzgUmfang.instance.RETRIEVE_BAUREIHEN();
            int index = 0;
            StringUtils.setPreparedStatementParams(++index, sMarke);
            StringUtils.setPreparedStatementParams(++index, sProduktart);
            StringUtils.setPreparedStatementParams(++index, "BE");
            StringUtils.setPreparedStatementParams(++index, sKatalogUmfang);
            if (sProduktart.equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung())) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "BAUART_STMT", "");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "BAUART_STMT", SQLStatements.FzgUmfang.instance.RETRIEVE_BAUART());
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN2", StringUtils.preparePlaceHolders(cBauarten.size()));
                for (String sBauarten : cBauarten) {
                    StringUtils.setPreparedStatementParams(++index, sBauarten);
                }
            }
            StringUtils.setPreparedStatementParams(++index, sKatalogUmfang);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN1", StringUtils.preparePlaceHolders(cRegionen.size()));
            for (String sRegionen : cRegionen) {
                StringUtils.setPreparedStatementParams(++index, sRegionen);
            }
            if (sProduktart.equals(Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung())) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", "");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", SQLStatements.FzgUmfang.instance.RETRIEVE_LENKUNG());
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN3", StringUtils.preparePlaceHolders(cLenkungen.size()));
                for (String sLenkungen : cLenkungen) {
                    StringUtils.setPreparedStatementParams(++index, sLenkungen);
                }
            }
            StringUtils.setPreparedStatementParams(++index, "N");
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sSQLStatement = SQLStatements.FzgUmfang.instance.RETRIEVE_BAUREIHEN();
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODUKTART", sProduktart);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "KATALOGUMFANG", sKatalogUmfang);
        String sRegionen = FzgUmfangDbAccess.concatCollection(cRegionen);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGIONEN", sRegionen);
        if (sProduktart.equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung())) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "BAUART_STMT", "");
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "BAUART_STMT", SQLStatements.FzgUmfang.instance.RETRIEVE_BAUART());
            String sBauarten = FzgUmfangDbAccess.concatCollection(cBauarten);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "BAUARTEN", sBauarten);
        }
        if (sProduktart.equals(Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung())) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", "");
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", SQLStatements.FzgUmfang.instance.RETRIEVE_LENKUNG());
            String sLenkungen = FzgUmfangDbAccess.concatCollection(cLenkungen);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNGEN", sLenkungen);
        }
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet selectKarosserien(Connection con, String sSprache, String sKatalogUmfang, Collection<String> cRegionen, Collection<String> cLenkungen, Collection<String> cBaureihen) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSQLStatement = SQLStatements.FzgUmfang.instance.RETRIEVE_KAROSSERIEN();
            int index = 0;
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN1", StringUtils.preparePlaceHolders(cBaureihen.size()));
            for (String sBaureihen : cBaureihen) {
                StringUtils.setPreparedStatementParams(++index, sBaureihen);
            }
            StringUtils.setPreparedStatementParams(++index, sKatalogUmfang);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN2", StringUtils.preparePlaceHolders(cRegionen.size()));
            for (String sRegionen : cRegionen) {
                StringUtils.setPreparedStatementParams(++index, sRegionen);
            }
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN3", StringUtils.preparePlaceHolders(cLenkungen.size()));
            for (String sLenkungen : cLenkungen) {
                StringUtils.setPreparedStatementParams(++index, sLenkungen);
            }
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            StringUtils.setPreparedStatementParams(++index, "N");
            StringUtils.setPreparedStatementParams(++index, "K");
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sSQLStatement = SQLStatements.FzgUmfang.instance.RETRIEVE_KAROSSERIEN();
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "KATALOGUMFANG", sKatalogUmfang);
        String sRegionen = FzgUmfangDbAccess.concatCollection(cRegionen);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGIONEN", sRegionen);
        String sLenkungen = FzgUmfangDbAccess.concatCollection(cLenkungen);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNGEN", sLenkungen);
        String sBaureihen = FzgUmfangDbAccess.concatCollection(cBaureihen);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "BAUREIHEN", sBaureihen);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet selectModelle(Connection con, String sProduktart, String sKatalogUmfang, Collection<String> cRegionen, Collection<String> cLenkungen, Collection<String> cBauarten, Collection<String> cBaureihen, Collection<String> cKarosserien) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSQLStatement = SQLStatements.FzgUmfang.instance.RETRIEVE_MODELLE();
            int index = 0;
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN1", StringUtils.preparePlaceHolders(cBaureihen.size()));
            for (String sBaureihen : cBaureihen) {
                StringUtils.setPreparedStatementParams(++index, sBaureihen);
            }
            StringUtils.setPreparedStatementParams(++index, sKatalogUmfang);
            if (sProduktart.equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung())) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "BAUART_STMT", "");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "BAUART_STMT", SQLStatements.FzgUmfang.instance.RETRIEVE_BAUART());
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN2", StringUtils.preparePlaceHolders(cBauarten.size()));
                for (String sBauarten : cBauarten) {
                    StringUtils.setPreparedStatementParams(++index, sBauarten);
                }
            }
            if (sProduktart.equals(Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung())) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "KAROSSERIE_STMT", "");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "KAROSSERIE_STMT", SQLStatements.FzgUmfang.instance.RETRIEVE_KAROSSERIE());
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN4", StringUtils.preparePlaceHolders(cKarosserien.size()));
                for (String sKarosserien : cKarosserien) {
                    StringUtils.setPreparedStatementParams(++index, sKarosserien);
                }
            }
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN5", StringUtils.preparePlaceHolders(cRegionen.size()));
            for (String sRegionen : cRegionen) {
                StringUtils.setPreparedStatementParams(++index, sRegionen);
            }
            if (sProduktart.equals(Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung())) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", "");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", SQLStatements.FzgUmfang.instance.RETRIEVE_LENKUNG());
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN3", StringUtils.preparePlaceHolders(cLenkungen.size()));
                for (String sLenkungen : cLenkungen) {
                    StringUtils.setPreparedStatementParams(++index, sLenkungen);
                }
            }
            StringUtils.setPreparedStatementParams(++index, "N");
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sSQLStatement = SQLStatements.FzgUmfang.instance.RETRIEVE_MODELLE();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "KATALOGUMFANG", sKatalogUmfang);
        String sRegionen = FzgUmfangDbAccess.concatCollection(cRegionen);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGIONEN", sRegionen);
        String sBaureihen = FzgUmfangDbAccess.concatCollection(cBaureihen);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "BAUREIHEN", sBaureihen);
        if (sProduktart.equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung())) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "BAUART_STMT", "");
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "BAUART_STMT", SQLStatements.FzgUmfang.instance.RETRIEVE_BAUART());
            String sBauarten = FzgUmfangDbAccess.concatCollection(cBauarten);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "BAUARTEN", sBauarten);
        }
        if (sProduktart.equals(Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung())) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", "");
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", SQLStatements.FzgUmfang.instance.RETRIEVE_LENKUNG());
            String sLenkungen = FzgUmfangDbAccess.concatCollection(cLenkungen);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNGEN", sLenkungen);
        }
        if (sProduktart.equals(Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung())) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "KAROSSERIE_STMT", "");
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "KAROSSERIE_STMT", SQLStatements.FzgUmfang.instance.RETRIEVE_KAROSSERIE());
            String sKarosserien = FzgUmfangDbAccess.concatCollection(cKarosserien);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "KAROSSERIEN", sKarosserien);
        }
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet selectModellspalten(Connection con, String sProduktart, String sKatalogUmfang, Collection<String> cRegionen, Collection<String> cLenkungen, Collection<String> cBauarten, Collection<String> cBaureihen, Collection<String> cKarosserien, Collection<String> cModelle) throws SQLException, NoDataFoundException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSQLStatement = SQLStatements.FzgUmfang.instance.RETRIEVE_MODELLSPALTEN();
            int index = 0;
            if (FzgUmfangDbAccess.concatCollection(cBaureihen).length() < 1) {
                throw new NoDataFoundException();
            }
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN1", StringUtils.preparePlaceHolders(cBaureihen.size()));
            for (String sBaureihen : cBaureihen) {
                StringUtils.setPreparedStatementParams(++index, sBaureihen);
            }
            StringUtils.setPreparedStatementParams(++index, sKatalogUmfang);
            if (FzgUmfangDbAccess.concatCollection(cModelle).length() > 0) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "MODELL_STMT", SQLStatements.FzgUmfang.instance.MODELL_STMT());
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN5", StringUtils.preparePlaceHolders(cModelle.size()));
                for (String sModelle : cModelle) {
                    StringUtils.setPreparedStatementParams(++index, sModelle);
                }
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "MODELL_STMT", "");
            }
            if (sProduktart.equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung())) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "BAUART_STMT", "");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "BAUART_STMT", SQLStatements.FzgUmfang.instance.RETRIEVE_BAUART());
                if (FzgUmfangDbAccess.concatCollection(cBauarten).length() < 1) {
                    throw new NoDataFoundException();
                }
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN2", StringUtils.preparePlaceHolders(cBauarten.size()));
                for (String sBauarten : cBauarten) {
                    StringUtils.setPreparedStatementParams(++index, sBauarten);
                }
            }
            if (sProduktart.equals(Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung())) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "KAROSSERIE_STMT", "");
            } else if (FzgUmfangDbAccess.concatCollection(cKarosserien).length() > 0) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "KAROSSERIE_STMT", SQLStatements.FzgUmfang.instance.RETRIEVE_KAROSSERIE());
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN4", StringUtils.preparePlaceHolders(cKarosserien.size()));
                for (String sKarosserien : cKarosserien) {
                    StringUtils.setPreparedStatementParams(++index, sKarosserien);
                }
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "KAROSSERIE_STMT", "");
            }
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN", StringUtils.preparePlaceHolders(cRegionen.size()));
            for (String sRegionen : cRegionen) {
                StringUtils.setPreparedStatementParams(++index, sRegionen);
            }
            if (sProduktart.equals(Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung())) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", "");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", SQLStatements.FzgUmfang.instance.RETRIEVE_LENKUNG());
                if (FzgUmfangDbAccess.concatCollection(cLenkungen).length() < 1) {
                    throw new NoDataFoundException();
                }
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN3", StringUtils.preparePlaceHolders(cLenkungen.size()));
                for (String sLenkungen : cLenkungen) {
                    StringUtils.setPreparedStatementParams(++index, sLenkungen);
                }
            }
            StringUtils.setPreparedStatementParams(++index, "N");
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sSQLStatement = SQLStatements.FzgUmfang.instance.RETRIEVE_MODELLSPALTEN();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "KATALOGUMFANG", sKatalogUmfang);
        String sRegionen = FzgUmfangDbAccess.concatCollection(cRegionen);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGIONEN", sRegionen);
        String sBaureihen = FzgUmfangDbAccess.concatCollection(cBaureihen);
        if (sBaureihen.length() < 1) {
            throw new NoDataFoundException();
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "BAUREIHEN", sBaureihen);
        if (sProduktart.equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung())) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "BAUART_STMT", "");
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "BAUART_STMT", SQLStatements.FzgUmfang.instance.RETRIEVE_BAUART());
            String sBauarten = FzgUmfangDbAccess.concatCollection(cBauarten);
            if (sBauarten.length() < 1) {
                throw new NoDataFoundException();
            }
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "BAUARTEN", sBauarten);
        }
        if (sProduktart.equals(Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung())) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", "");
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", SQLStatements.FzgUmfang.instance.RETRIEVE_LENKUNG());
            String sLenkungen = FzgUmfangDbAccess.concatCollection(cLenkungen);
            if (sLenkungen.length() < 1) {
                throw new NoDataFoundException();
            }
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNGEN", sLenkungen);
        }
        if (sProduktart.equals(Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung())) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "KAROSSERIE_STMT", "");
        } else {
            String sKarosserien = FzgUmfangDbAccess.concatCollection(cKarosserien);
            if (sKarosserien.length() > 0) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "KAROSSERIE_STMT", SQLStatements.FzgUmfang.instance.RETRIEVE_KAROSSERIE());
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "KAROSSERIEN", sKarosserien);
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "KAROSSERIE_STMT", "");
            }
        }
        String sModelle = FzgUmfangDbAccess.concatCollection(cModelle);
        if (sModelle.length() > 0) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "MODELL_STMT", SQLStatements.FzgUmfang.instance.MODELL_STMT());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "MODELLE", sModelle);
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "MODELL_STMT", "");
        }
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }
}

